/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.display;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.controls.IActionUpdater;
import oracle.dbtools.raptor.controls.display.DisplayModel;
import oracle.dbtools.raptor.controls.display.DisplayResultTable;
import oracle.dbtools.raptor.controls.display.EditableGridInfo;
import oracle.dbtools.raptor.controls.display.JavaBasedGridUpdater;
import oracle.dbtools.raptor.controls.display.ScriptBasedGridUpdater;
import oracle.dbtools.raptor.controls.grid.EditableResultSetTable;
import oracle.dbtools.raptor.controls.grid.EditableResultSetTableModel;
import oracle.dbtools.raptor.controls.grid.IRaptorGridUpdater;
import oracle.dbtools.raptor.controls.grid.RaptorEditableGridTaskWrapper;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryUtils;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.view.View;

public class DisplayEditableResultTable
extends DisplayResultTable {
    private ArrayList<String> _roCols;
    private EditableResultSetTable _localGrid;
    private ArrayList<String> _rwCols;
    private IRaptorGridUpdater _updater;

    @Override
    public void initTable() {
        if (this._localGrid == null) {
            this.initImpl();
        }
    }

    private void initImpl() {
        this._localGrid = new EditableResultSetTable(new IActionUpdater(){

            @Override
            public void updateActions() {
                if (DisplayEditableResultTable.this.getView() != null) {
                    DisplayEditableResultTable.this.getView().updateVisibleActions();
                }
            }
        });
        this._grid = this._localGrid;
        this._grid.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!DisplayEditableResultTable.this._closing && !listSelectionEvent.getValueIsAdjusting()) {
                    DisplayEditableResultTable.this.fireSelectionChanged();
                }
            }
        });
        this._grid.setMinimumSize(new Dimension(200, 200));
        DisplayModel displayModel = this.getDisplayModel();
        this._localGrid.setInsertAllowed(displayModel.getInsertClass() != null || displayModel.getInsertScript() != null);
        this._localGrid.setDeleteAllowed(displayModel.getDeleteClass() != null || displayModel.getDeleteScript() != null);
        if (displayModel.getInsertClass() != null && displayModel.getUpdateClass() != null && displayModel.getDeleteClass() != null && displayModel.getInsertClass().equals(displayModel.getUpdateClass()) && displayModel.getInsertClass().equals(displayModel.getDeleteClass())) {
            try {
                this._updater = (IRaptorGridUpdater)displayModel.getInsertClass().newInstance();
            }
            catch (InstantiationException instantiationException) {
                ExceptionHandler.handleException((Throwable)instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                ExceptionHandler.handleException((Throwable)illegalAccessException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                ExceptionHandler.handleException((Throwable)classNotFoundException);
            }
        } else if (displayModel.getInsertClass() != null || displayModel.getDeleteClass() != null || displayModel.getUpdateClass() != null) {
            this._updater = this.buildClassBasedUpdater(displayModel);
        } else if (displayModel.getInsertScript() != null || displayModel.getDeleteScript() != null || displayModel.getUpdateScript() != null) {
            this._updater = this.buildScriptBasedUpdater(displayModel);
        }
        this._localGrid.setEditable(true);
        this._localGrid.registerGridUpdater(this._updater);
    }

    private IRaptorGridUpdater buildScriptBasedUpdater(DisplayModel displayModel) {
        ScriptBasedGridUpdater scriptBasedGridUpdater = new ScriptBasedGridUpdater(displayModel);
        return scriptBasedGridUpdater;
    }

    private IRaptorGridUpdater buildClassBasedUpdater(DisplayModel displayModel) {
        JavaBasedGridUpdater javaBasedGridUpdater = new JavaBasedGridUpdater(displayModel);
        return javaBasedGridUpdater;
    }

    @Override
    protected void openGrid(List<IRaptorTaskListener> list) throws ExecutionException {
        ((EditableResultSetTable)this._grid).open(new RaptorEditableGridTaskWrapper(Messages.getString("DisplayResultsLabel"), IRaptorTaskRunMode.MODAL_OPTIONAL, true, list, null, null, null));
    }

    @Override
    protected void updateQuery(String string, Map<String, Object> map) {
        Object object2;
        DisplayModel displayModel = this.getDisplayModel();
        Query query = this.getQuery();
        if (this._rwCols == null) {
            this._rwCols = new ArrayList();
        }
        for (Object object2 : query.getCols()) {
            if (!object2.isEditable().booleanValue()) {
                if (this._roCols == null) {
                    this._roCols = new ArrayList();
                }
                this._roCols.add(object2.getName());
                continue;
            }
            this._rwCols.add(object2.getName());
        }
        if (this._rwCols.size() == 0) {
            this._rwCols.add(new String("*"));
        }
        ((EditableResultSetTable)this._grid).setQuery(this.getConnName(), QueryUtils.expandQuery((String)string, map), null, map, null, this._roCols, this._rwCols);
        this._grid.getGridModel().setQueryObject(this.getQuery());
        this._localGrid.registerGridUpdater(this._updater);
        EditableResultSetTableModel editableResultSetTableModel = this._localGrid.getGridModel();
        editableResultSetTableModel.setTableName(this.getDisplayModel().getName());
        object2 = new EditableGridInfo(editableResultSetTableModel.getSql(), editableResultSetTableModel.getBindList(), editableResultSetTableModel.getBindMap(), editableResultSetTableModel.getTableName());
        this._updater.setGridInfo((EditableGridInfo)object2);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                DisplayEditableResultTable.this._localGrid.getController().addToolBarActions(DisplayEditableResultTable.this.getToolbar());
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    @Override
    public void close() {
        super.close();
        this._view = null;
    }

    @Override
    public void setView(View view) {
        super.setView(view);
        this._localGrid.getController().setView(this.getView());
    }
}

