/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.celleditor.popups;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.controls.ControlsArb;
import oracle.dbtools.raptor.controls.celleditor.popups.AbstractPopupCellEditor;
import oracle.ide.Ide;
import oracle.ide.config.EnvironOptions;
import oracle.ide.config.IdeSettings;
import oracle.ide.resource.EnvironOptionsArb;
import oracle.ide.resource.ExtensionBundle;
import oracle.ide.util.ResourceUtils;

public class LongCharEditPanel
extends AbstractPopupCellEditor
implements ChangeListener {
    private static final long serialVersionUID = 1L;
    IdeSettings settings = Ide.getSettings();
    String _EOLChars = null;
    String eolLabel = null;
    EnvironOptions envopts;
    protected Object value = null;
    protected boolean canChange = false;
    final JTextField _jtfLineTerminator = new JTextField();
    protected JTextArea jtaEditValue = new JTextArea();
    private JButton lineTermBtn;
    private static final String LINE_SEPARATOR_PATTERN = "\r\n|[\n\r\u2028\u2029\u0085]";

    public LongCharEditPanel() {
        this.settings = Ide.getSettings();
        this.envopts = (EnvironOptions)this.settings.getData("environment-options");
        this.envopts.addChangeListener((ChangeListener)this);
        this.getEOLSettings();
        this.getLongCharEditPanel();
    }

    public LongCharEditPanel(Object object, boolean bl) {
        this();
        this.value = object;
        this.canChange = bl;
    }

    protected void getLongCharEditPanel() {
        this.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel();
        String string = EnvironOptionsArb.getString((int)20);
        this._jtfLineTerminator.setText(this.eolLabel);
        this._jtfLineTerminator.setEditable(false);
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this._jtfLineTerminator, (String)string);
        this.lineTermBtn = new JButton();
        this.lineTermBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LongCharEditPanel.this.settings.showDialog((Frame)Ide.getMainWindow(), new String[]{ExtensionBundle.get((String)"ENVIRONMENT_SETTINGS")});
            }
        });
        this.lineTermBtn.setEnabled(this.canChange);
        ResourceUtils.resButton((AbstractButton)this.lineTermBtn, (String)Messages.getString("LongCharEditPanel.0"));
        JLabel jLabel2 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this.jtaEditValue, (String)ControlsArb.getString("RESULTSET_EDIT_VALUE"));
        JScrollPane jScrollPane = new JScrollPane(this.jtaEditValue);
        jScrollPane.setHorizontalScrollBarPolicy(32);
        jScrollPane.setVerticalScrollBarPolicy(22);
        this.jtaEditValue.setRows(10);
        this.jtaEditValue.setEditable(this.canChange);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        this.add((Component)jLabel, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        this.add((Component)this._jtfLineTerminator, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 0.0;
        this.add((Component)this.lineTermBtn, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.add((Component)jScrollPane, gridBagConstraints);
    }

    protected void getEOLSettings() {
        this.settings = Ide.getSettings();
        this.envopts = (EnvironOptions)this.settings.getData("environment-options");
        int n = this.envopts.getLineTerminator();
        if (n == 1) {
            this._EOLChars = "\r\n";
            this.eolLabel = EnvironOptionsArb.getString((int)23);
        } else if (n == 3) {
            this._EOLChars = "\r";
            this.eolLabel = EnvironOptionsArb.getString((int)25);
        } else if (n == 2) {
            this._EOLChars = "\n";
            this.eolLabel = EnvironOptionsArb.getString((int)24);
        } else {
            this._EOLChars = System.getProperty("line.separator");
            this.eolLabel = EnvironOptionsArb.getString((int)22);
        }
    }

    public String getEOLChars() {
        return this._EOLChars;
    }

    public EnvironOptions getEnvopts() {
        return this.envopts;
    }

    public String getEolLabel() {
        return this.eolLabel;
    }

    public void setText(String string) {
        String string2 = string.replaceAll(LINE_SEPARATOR_PATTERN, System.getProperty("line.separator"));
        this.jtaEditValue.setText(string2);
    }

    public String getText() {
        String string = this.jtaEditValue.getText();
        String string2 = string.replaceAll(System.getProperty("line.separator"), this._EOLChars);
        return string2;
    }

    @Override
    public JComponent getDefaultComponent() {
        return this.jtaEditValue;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LongCharEditPanel.this.getEOLSettings();
                LongCharEditPanel.this._jtfLineTerminator.setText(LongCharEditPanel.this.eolLabel);
            }
        });
    }

    @Override
    public void dismissPopupEditor() {
        this.envopts.removeChangeListener((ChangeListener)this);
        super.dismissPopupEditor();
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public String getHelpTopicId() {
        return "f1_extendeddataedit_html";
    }

    @Override
    public Object getValue() {
        return this.getText();
    }

    @Override
    public boolean isEditable() {
        return this.canChange;
    }

    @Override
    public void setEditable(boolean bl) {
        this.canChange = bl;
        this.lineTermBtn.setEnabled(this.canChange);
        this.jtaEditValue.setEditable(this.canChange);
    }

    @Override
    public boolean isNULL() {
        return false;
    }

    @Override
    public void setValue(Object object) {
        if (object != null) {
            this.setText(object.toString());
        }
    }

    @Override
    public String validateValue() {
        return null;
    }

    @Override
    public void setConnection(Connection connection) {
    }

    @Override
    public void setPopupDialog(JEWTDialog jEWTDialog) {
    }
}

