/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.TreeSet;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;
import oracle.bali.ewt.grid.Grid;
import oracle.dbtools.raptor.datatypes.objects.OraTemporalDatum;
import oracle.dbtools.raptor.nls.JavaFormat;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.ui.controls.DateTimeEditor;
import oracle.javatools.ui.calendar.CalendarPanel;
import oracle.javatools.ui.calendar.CalendarPopupButton;

public class TemporalController
implements PropertyChangeListener {
    private static final Object[] sortedTimeZoneList = TemporalController.getTZList();
    protected OraTemporalDatum _temporalModel;
    protected boolean _enabled = true;
    protected boolean _hasChanged = false;
    protected final DateFormat _timeFormat;
    protected Locale locale = Locale.getDefault();
    protected String _name;
    private CalendarPanelWrapper _popupCalPanelWrapper;
    private CalendarPanel _popupCalPanel;
    private CalendarPopupButton _popupCalButton;
    private CalendarPanelWrapper _calendarPanelWrapper;
    private CalendarPanel _calendarPanel;
    private DateTimeEditor _timeEditor;
    private NanoSpinner _nanoSpinner;
    private SpinnerNumberModel _nanoSpinnerModel;
    private TimeZoneComboBox _timezones;
    private EditorPanel _editorPanel;
    private char decimalSeparator = new DecimalFormatSymbols(this.locale).getDecimalSeparator();

    protected static boolean areEqual(Object object, Object object2) {
        return object == object2 || object != null && object2 != null && object.equals(object2);
    }

    protected static void nameEditorField(JComponent jComponent, String string, boolean bl) {
        Component component;
        block3: {
            component = null;
            try {
                component = jComponent.getComponent(0);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                if (component instanceof JPanel) break block3;
                component = jComponent;
            }
        }
        if (component != null && (bl || component.getName() == null)) {
            component.setName(string == null ? null : string + "." + "editorField");
        }
    }

    public TemporalController(OraTemporalDatum oraTemporalDatum, boolean bl) {
        this(oraTemporalDatum, bl, new SimpleDateFormat("HH:mm:ss"));
    }

    public TemporalController(OraTemporalDatum oraTemporalDatum, boolean bl, DateFormat dateFormat) {
        this._enabled = bl;
        this._timeFormat = dateFormat != null ? (DateFormat)dateFormat.clone() : null;
        this._temporalModel = oraTemporalDatum;
        this._temporalModel.addPropertyChangeListener((PropertyChangeListener)this);
        this._name = "temporalController";
    }

    public void setName(String string) {
        this._name = string;
    }

    public OraTemporalDatum getModel() {
        return (OraTemporalDatum)this._temporalModel.clone();
    }

    public void setChanged(boolean bl) {
        this._hasChanged = bl;
    }

    public boolean hasChanged() {
        return this._hasChanged;
    }

    public void setEnabled(boolean bl) {
        this._enabled = bl;
        if (this._calendarPanelWrapper != null) {
            this._calendarPanelWrapper.setEnabled(this._enabled);
        }
        if (this._popupCalButton != null) {
            this._popupCalButton.setEnabled(this._enabled);
        }
        if (this._timeEditor != null) {
            this._timeEditor.setEnabled(this._enabled);
        }
        if (this._nanoSpinner != null) {
            this._nanoSpinner.setEnabled(this._enabled);
        }
        if (this._timezones != null) {
            this._timezones.setEnabled(this._enabled);
        }
    }

    public boolean isEnabled() {
        return this._calendarPanel != null && this._calendarPanel.isEnabled() || this._popupCalButton != null && this._popupCalButton.isEnabled() || this._timeEditor != null && this._timeEditor.isEnabled() || this._nanoSpinner != null && this._nanoSpinner.isEnabled() || this._timezones != null && this._timezones.isEnabled();
    }

    public void setEditable(boolean bl) {
        this.setEnabled(bl);
    }

    public boolean isEditable() {
        return this.isEnabled();
    }

    public CalendarPanel getCalendarPanel() {
        if (this._calendarPanelWrapper == null) {
            this._calendarPanel = new CalendarPanel(this.locale);
            this._calendarPanelWrapper = new CalendarPanelWrapper(this._calendarPanel);
            this.nameCalendarPanel(this._calendarPanel, this._name);
            this._calendarPanel.setEnabled(this._enabled);
        }
        return this._calendarPanel;
    }

    protected void nameCalendarPanel(CalendarPanel calendarPanel, String string) {
        String string2 = string == null ? null : string + ".calendarPanel";
        calendarPanel.setName(string2);
        Component[] componentArray = calendarPanel.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            String string3;
            String string4 = componentArray[i].getClass().getName();
            if (string4.equals("oracle.javatools.ui.calendar.MonthComponent")) {
                string3 = string2 == null ? null : string2 + ".monthComponent";
                componentArray[i].setName(string3);
                continue;
            }
            if (string4.equals("oracle.javatools.ui.calendar.YearComponent")) {
                string3 = string2 == null ? null : string2 + ".yearComponent";
                componentArray[i].setName(string3);
                TemporalController.nameEditorField((JComponent)componentArray[i], string3, false);
                continue;
            }
            if (!string4.equals("oracle.javatools.ui.calendar.DayComponent")) continue;
            string3 = string2 == null ? null : string2 + ".dayComponent";
            componentArray[i].setName(string3);
            JComponent jComponent = (JComponent)((JComponent)componentArray[i]).getComponent(0);
            Component[] componentArray2 = jComponent.getComponents();
            for (int j = 0; j < componentArray2.length; ++j) {
                if (!(componentArray2[j] instanceof Grid)) continue;
                String string5 = string3 == null ? null : string3 + ".dayGrid";
                componentArray2[j].setName(string5);
            }
        }
    }

    public CalendarPopupButton getCalendarPopupButton() {
        if (this._popupCalButton == null) {
            this._popupCalButton = new CalendarPopupButton(this.locale);
            if (this._name != null) {
                this._popupCalButton.setName(this._name + ".popupCalButton");
            }
            this._popupCalButton.setEnabled(this._enabled);
            this._popupCalPanel = this._popupCalButton.getCalendarPanel();
            this._popupCalPanelWrapper = new CalendarPanelWrapper(this._popupCalPanel);
        }
        return this._popupCalButton;
    }

    public DateTimeEditor getDateTimeEditor() {
        if (this._timeEditor == null) {
            Calendar calendar = Calendar.getInstance(this.locale);
            this._temporalModel.getCalendar(calendar);
            this._timeEditor = new DateTimeEditor(calendar.getTime(), calendar, this._timeFormat != null ? this._timeFormat : JavaFormat.getDateFormat((OraTemporalDatum.Precision)this._temporalModel.getPrecision(), (Locale)this.locale));
            if (this._name != null) {
                this._timeEditor.setName(this._name + ".timeEditor");
            }
            this._timeEditor.setEnabled(this._enabled);
            this._timeEditor.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    Object object = propertyChangeEvent.getNewValue();
                    if (object instanceof Date) {
                        TemporalController.this.change_calendar((Date)object);
                    }
                }
            });
        }
        return this._timeEditor;
    }

    public NanoSpinner getNanoSpinner() {
        if (this._nanoSpinner == null) {
            int n = (int)Math.pow(10.0, this._temporalModel.getFractionalPrecision());
            int n2 = n - 1;
            String string = Integer.toString(n2).replaceAll("9", "0");
            this._nanoSpinnerModel = new SpinnerNumberModel(0, 0, n2, 1);
            this._nanoSpinner = new NanoSpinner(this._nanoSpinnerModel);
            NanoSpinner.NanoEditor nanoEditor = this._nanoSpinner.getNanoEditor(this._nanoSpinner, string);
            this._nanoSpinner.setEditor(nanoEditor);
            if (this._name != null) {
                this._nanoSpinner.setName(this._name + ".nanoSpinner");
            }
            this._nanoSpinner.setEnabled(this._enabled);
            this._nanoSpinnerModel.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    TemporalController.this.change_nanos(TemporalController.this._nanoSpinnerModel.getNumber().intValue());
                }
            });
        }
        return this._nanoSpinner;
    }

    public JComboBox getTimeZoneComboBox() {
        if (this._timezones == null) {
            this._timezones = new TimeZoneComboBox(this.getSortedTimeZoneList());
            this._timezones.setRenderer(new TimeZoneListRenderer(this._timezones.getRenderer()));
            this._timezones.selectTimeZone(this._temporalModel.getTimeZone());
            this._timezones.setEditable(false);
            if (this._name != null) {
                this._timezones.setName(this._name + ".timezones");
            }
            this._timezones.setEnabled(this._enabled && this._temporalModel.userTimeZoneSupported());
            this._timezones.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    TimeZone timeZone;
                    if (1 == itemEvent.getStateChange() && (timeZone = (TimeZone)TemporalController.this._timezones.getSelectedItem()) != null) {
                        TemporalController.this.change_calendar(timeZone);
                    }
                }
            });
        }
        return this._timezones;
    }

    public JPanel getEditorPanel() {
        return this.getEditorPanel(true);
    }

    public JPanel getEditorPanel(boolean bl) {
        if (this._editorPanel == null) {
            EditorPanel editorPanel = new EditorPanel(new GridBagLayout());
            if (this._name != null) {
                editorPanel.setName(this._name + ".subPanel");
            }
            int n = 0;
            editorPanel.add((Component)((Object)this.getDateTimeEditor()), LayoutControl.GBC.gbc(n++, 0, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, LayoutControl.GBC.Fill.X, LayoutControl.GBC.Spring.X));
            if (this._temporalModel.nanosSupported() && this._temporalModel.getPrecision() == OraTemporalDatum.Precision.NANOSECOND) {
                editorPanel.add((Component)new JLabel(Character.toString(this.getDecimalSeparator())), LayoutControl.GBC.gbc(n++, 0, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_START_COMP));
                editorPanel.add((Component)this.getNanoSpinner(), LayoutControl.GBC.gbc(n++, 0, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_START_COMP));
            }
            if (this._temporalModel.userTimeZoneSupported()) {
                editorPanel.add((Component)this.getTimeZoneComboBox(), LayoutControl.GBC.gbc(n++, 0, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_CONTROL2BUTTON_COMP));
            }
            if (bl) {
                this._editorPanel = new EditorPanel(new GridBagLayout());
                this._editorPanel.add((Component)editorPanel, LayoutControl.GBC.gbc(0, 0, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, LayoutControl.GBC.Fill.X, LayoutControl.GBC.Spring.X));
                this._editorPanel.add((Component)this.getCalendarPopupButton(), LayoutControl.GBC.gbc(1, 0, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_CONTROL2BUTTON_COMP));
            } else {
                this._editorPanel = editorPanel;
            }
            if (this._name != null) {
                this._editorPanel.setName(this._name + ".editorPanel");
            }
        }
        return this._editorPanel;
    }

    public char getDecimalSeparator() {
        return this.decimalSeparator;
    }

    public boolean change_calendar(Date date) {
        boolean bl = false;
        Date date2 = this._temporalModel.getTime();
        if (!TemporalController.areEqual(date2, date)) {
            this._temporalModel.setTime(date);
            bl = true;
        }
        return bl;
    }

    public boolean change_calendar(int n, int n2, int n3, int n4) {
        boolean bl = false;
        int n5 = this._temporalModel.get(0);
        int n6 = this._temporalModel.get(1);
        int n7 = this._temporalModel.get(2);
        int n8 = this._temporalModel.get(5);
        if (n != n5 || n2 != n6 || n3 != n7 || n4 != n8) {
            this._temporalModel.set(0, n);
            this._temporalModel.set(1, n2);
            this._temporalModel.set(2, n3);
            this._temporalModel.set(5, n4);
            this._temporalModel.recompute();
            bl = true;
        }
        return bl;
    }

    public boolean change_calendar(TimeZone timeZone) {
        boolean bl = false;
        TimeZone timeZone2 = this._temporalModel.getTimeZone();
        if (!TemporalController.areEqual(timeZone2, timeZone)) {
            this._temporalModel.setTimeZone(timeZone);
            bl = true;
        }
        return bl;
    }

    public boolean change_nanos(int n) {
        boolean bl = false;
        if (this._temporalModel.getNanos() != n) {
            this._temporalModel.setNanos(n);
            bl = true;
        }
        return bl;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("TIME")) {
            if (this._timeEditor != null) {
                long l = (Long)propertyChangeEvent.getNewValue();
                Calendar calendar = this._timeEditor.getCalendar();
                if (!TemporalController.areEqual(calendar.getTimeInMillis(), l)) {
                    Calendar calendar2 = (Calendar)calendar.clone();
                    calendar2.setTimeInMillis(l);
                    this._timeEditor.setCalendar(calendar2);
                    this._timeEditor.repaint();
                }
            }
            if (this._timezones != null) {
                this._timezones.repaint();
            }
            if (this._calendarPanelWrapper != null) {
                this._calendarPanelWrapper.calendar_changed();
            }
            if (this._popupCalPanelWrapper != null) {
                this._popupCalPanelWrapper.calendar_changed();
            }
        } else if (propertyChangeEvent.getPropertyName().equals("TIMEZONE")) {
            Cloneable cloneable;
            TimeZone timeZone = (TimeZone)propertyChangeEvent.getNewValue();
            if (this._timezones != null) {
                cloneable = (TimeZone)this._timezones.getSelectedItem();
                if (!TemporalController.areEqual(cloneable, timeZone)) {
                    this._timezones.selectTimeZone(timeZone);
                }
                this._timezones.repaint();
            }
            if (this._timeEditor != null && !TemporalController.areEqual(((Calendar)(cloneable = this._timeEditor.getCalendar())).getTimeZone(), timeZone)) {
                Calendar calendar = (Calendar)((Calendar)cloneable).clone();
                calendar.setTimeZone(timeZone);
                this._timeEditor.setCalendar(calendar);
                this._timeEditor.repaint();
            }
            if (this._calendarPanelWrapper != null) {
                this._calendarPanelWrapper.calendar_changed();
            }
            if (this._popupCalPanelWrapper != null) {
                this._popupCalPanelWrapper.calendar_changed();
            }
        } else if (propertyChangeEvent.getPropertyName().equals("NANOS")) {
            if (this._nanoSpinnerModel != null) {
                int n = (Integer)propertyChangeEvent.getNewValue();
                int n2 = this._nanoSpinnerModel.getNumber().intValue();
                if (n2 != n) {
                    this._nanoSpinnerModel.setValue(n);
                }
            }
        } else if (propertyChangeEvent.getPropertyName().equals("FRACTIONALPRECISION")) {
            int n;
            if (this._nanoSpinnerModel != null && (n = ((Integer)propertyChangeEvent.getNewValue()).intValue()) != this._nanoSpinner.getPrecision()) {
                int n3 = (int)Math.pow(10.0, n);
                int n4 = n3 - 1;
                String string = Integer.toString(n4).replaceAll("9", "0");
                NanoSpinner.NanoEditor nanoEditor = this._nanoSpinner.getNanoEditor(this._nanoSpinner, string);
                this._nanoSpinner.setEditor(nanoEditor);
                this._nanoSpinnerModel.setMaximum(Integer.valueOf(n4));
            }
        } else if (propertyChangeEvent.getPropertyName().equals("PRECISION") && this._timeEditor != null && this._timeFormat == null) {
            OraTemporalDatum.Precision precision = (OraTemporalDatum.Precision)propertyChangeEvent.getNewValue();
            this._timeEditor.setDateFormat(JavaFormat.getDateFormat((OraTemporalDatum.Precision)precision, (Locale)this.locale));
        }
        this.setChanged(true);
    }

    protected Object[] getSortedTimeZoneList() {
        return sortedTimeZoneList;
    }

    protected static Object[] getTZList() {
        TreeSet<TimeZone> treeSet = new TreeSet<TimeZone>(new TimeZoneComparator());
        for (String string : TimeZone.getAvailableIDs()) {
            TimeZone timeZone = TimeZone.getTimeZone(string);
            treeSet.add(timeZone);
        }
        return treeSet.toArray();
    }

    protected class TimeZoneComboBox
    extends JComboBox {
        public TimeZoneComboBox(Object[] objectArray) {
            super(objectArray);
        }

        private void selectTimeZone(TimeZone timeZone) {
            TimeZone timeZone2 = (TimeZone)this.getSelectedItem();
            if (!TemporalController.areEqual(timeZone2, timeZone)) {
                this.setSelectedItem(timeZone);
                this.repaint();
                timeZone2 = (TimeZone)this.getSelectedItem();
                if (!TemporalController.areEqual(timeZone2, timeZone)) {
                    this.addItem(timeZone);
                    this.setSelectedItem(timeZone);
                    this.repaint();
                }
            }
        }

        @Override
        public void enable() {
            if (TemporalController.this._temporalModel.userTimeZoneSupported()) {
                super.enable();
            }
        }

        @Override
        public void enable(boolean bl) {
            if (!bl || TemporalController.this._temporalModel.userTimeZoneSupported()) {
                super.enable(bl);
            }
        }

        @Override
        public void disable() {
            super.disable();
        }

        @Override
        public void setEnabled(boolean bl) {
            if (!bl || TemporalController.this._temporalModel.userTimeZoneSupported()) {
                super.setEnabled(bl);
            }
        }

        @Override
        public void setEditable(boolean bl) {
            if (!bl) {
                super.setEditable(bl);
            }
        }
    }

    protected class TimeZoneListRenderer
    implements ListCellRenderer {
        protected ListCellRenderer defaultRenderer;

        public TimeZoneListRenderer(ListCellRenderer listCellRenderer) {
            this.defaultRenderer = listCellRenderer;
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object instanceof TimeZone) {
                TimeZone timeZone = (TimeZone)object;
                boolean bl3 = timeZone.inDaylightTime(new Date(TemporalController.this._temporalModel.getTimeInMillis()));
                if (n == -1) {
                    return this.defaultRenderer.getListCellRendererComponent(jList, timeZone.getDisplayName(bl3, 0, TemporalController.this.locale), n, bl, bl2);
                }
                return this.defaultRenderer.getListCellRendererComponent(jList, timeZone.getID() + " (" + timeZone.getDisplayName(bl3, 1, TemporalController.this.locale) + ")", n, bl, bl2);
            }
            return this.defaultRenderer.getListCellRendererComponent(jList, object, n, bl, bl2);
        }
    }

    protected static class TimeZoneComparator
    implements Comparator<TimeZone> {
        protected TimeZoneComparator() {
        }

        @Override
        public int compare(TimeZone timeZone, TimeZone timeZone2) {
            return timeZone.getID().compareTo(timeZone2.getID());
        }

        @Override
        public boolean equals(Object object) {
            return super.equals(object);
        }
    }

    public class EditorPanel
    extends JPanel {
        public EditorPanel(LayoutManager layoutManager) {
            super(layoutManager);
        }

        public JComponent getDefaultComponent() {
            return TemporalController.this.getDateTimeEditor();
        }
    }

    public class NanoSpinner
    extends NamedSpinner {
        public NanoSpinner(SpinnerModel spinnerModel) {
            super(spinnerModel);
        }

        public NanoEditor getNanoEditor(NanoSpinner nanoSpinner, String string) {
            return new NanoEditor(nanoSpinner, string);
        }

        public int getPrecision() {
            return ((NanoEditor)this.getEditor()).getPrecision();
        }

        @Override
        public void enable() {
            if (TemporalController.this._temporalModel.nanosSupported()) {
                super.enable();
            }
        }

        @Override
        public void enable(boolean bl) {
            if (!bl || TemporalController.this._temporalModel.nanosSupported()) {
                super.enable(bl);
            }
        }

        @Override
        public void disable() {
            super.disable();
        }

        @Override
        public void setEnabled(boolean bl) {
            if (!bl || TemporalController.this._temporalModel.nanosSupported()) {
                super.setEnabled(bl);
            }
        }

        public class NanoEditor
        extends JSpinner.NumberEditor {
            private NanoFormat format;

            public NanoEditor(NanoSpinner nanoSpinner2, String string) {
                this(nanoSpinner2, new NanoFormat(string, string.length()));
            }

            private NanoEditor(NanoSpinner nanoSpinner2, DecimalFormat decimalFormat) {
                super(nanoSpinner2);
                this.format = (NanoFormat)decimalFormat;
                if (!(nanoSpinner2.getModel() instanceof SpinnerNumberModel)) {
                    throw new IllegalArgumentException("model not a SpinnerNumberModel");
                }
                SpinnerNumberModel spinnerNumberModel = (SpinnerNumberModel)nanoSpinner2.getModel();
                NumberEditorFormatter numberEditorFormatter = new NumberEditorFormatter(spinnerNumberModel, decimalFormat);
                DefaultFormatterFactory defaultFormatterFactory = new DefaultFormatterFactory(numberEditorFormatter);
                JFormattedTextField jFormattedTextField = this.getTextField();
                jFormattedTextField.setEditable(true);
                jFormattedTextField.setFormatterFactory(defaultFormatterFactory);
                jFormattedTextField.setHorizontalAlignment(4);
                try {
                    String string = numberEditorFormatter.valueToString(spinnerNumberModel.getMinimum());
                    String string2 = numberEditorFormatter.valueToString(spinnerNumberModel.getMaximum());
                    jFormattedTextField.setColumns(Math.max(string.length(), string2.length()));
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }

            public int getPrecision() {
                return this.format.getPrecision();
            }

            @Override
            public void enable() {
                if (TemporalController.this._temporalModel.nanosSupported()) {
                    super.enable();
                }
            }

            @Override
            public void enable(boolean bl) {
                if (!bl || TemporalController.this._temporalModel.nanosSupported()) {
                    super.enable(bl);
                }
            }

            @Override
            public void disable() {
                super.disable();
            }

            @Override
            public void setEnabled(boolean bl) {
                if (!bl || TemporalController.this._temporalModel.nanosSupported()) {
                    super.setEnabled(bl);
                }
            }
        }
    }

    public class NamedSpinner
    extends JSpinner {
        public NamedSpinner(SpinnerModel spinnerModel) {
            super(spinnerModel);
        }

        @Override
        public void setName(String string) {
            TemporalController.nameEditorField(this.getEditor(), string, false);
            super.setName(string);
        }

        @Override
        public void setEditor(JComponent jComponent) {
            TemporalController.nameEditorField(jComponent, this.getName(), false);
            super.setEditor(jComponent);
        }
    }

    private static class NanoFormat
    extends DecimalFormat {
        int precision;

        public NanoFormat(String string, int n) {
            super(string);
            this.precision = n;
        }

        @Override
        public Number parse(String string, ParsePosition parsePosition) {
            String string2 = string;
            if (string2 != null && string2.length() < this.precision) {
                StringBuilder stringBuilder = new StringBuilder(string2);
                while (stringBuilder.length() < this.precision) {
                    stringBuilder.append('0');
                }
                string2 = stringBuilder.toString();
            }
            return super.parse(string2, parsePosition);
        }

        public int getPrecision() {
            return this.precision;
        }
    }

    private static class NumberEditorFormatter
    extends NumberFormatter {
        private final SpinnerNumberModel model;

        NumberEditorFormatter(SpinnerNumberModel spinnerNumberModel, NumberFormat numberFormat) {
            super(numberFormat);
            this.model = spinnerNumberModel;
            this.setValueClass(spinnerNumberModel.getValue().getClass());
        }

        public void setMinimum(Comparable comparable) {
            this.model.setMinimum(comparable);
        }

        public Comparable getMinimum() {
            return this.model.getMinimum();
        }

        public void setMaximum(Comparable comparable) {
            this.model.setMaximum(comparable);
        }

        public Comparable getMaximum() {
            return this.model.getMaximum();
        }
    }

    private class CalendarPanelWrapper {
        private CalendarPanel _calPanel;
        protected GregorianCalendar _panelCal;

        public CalendarPanelWrapper(CalendarPanel calendarPanel) {
            this._panelCal = TemporalController.this._temporalModel.getCalendar();
            this._panelCal.set(11, 12);
            this._panelCal.set(12, 0);
            this._panelCal.set(13, 0);
            this._panelCal.set(14, 0);
            this._calPanel = calendarPanel;
            this._calPanel.setShowTime(false);
            this._calPanel.setShowTimeZone(false);
            Date date = this._panelCal.getTime();
            this._calPanel.setSelectedDate(date);
            this._calPanel.makeDateVisible(date);
            this._calPanel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Date date;
                    Date[] dateArray;
                    if (actionEvent.getActionCommand() == "SELECTION_CHANGED_COMMAND" && (dateArray = CalendarPanelWrapper.this._calPanel.getSelectedDates()).length > 0 && (date = dateArray[0]) != null) {
                        CalendarPanelWrapper.this._panelCal.setTime(date);
                        TemporalController.this.change_calendar(CalendarPanelWrapper.this._panelCal.get(0), CalendarPanelWrapper.this._panelCal.get(1), CalendarPanelWrapper.this._panelCal.get(2), CalendarPanelWrapper.this._panelCal.get(5));
                    }
                }
            });
        }

        public CalendarPanel getCalendarPanel() {
            return this._calPanel;
        }

        public void calendar_changed() {
            int n = this._panelCal.get(0);
            int n2 = this._panelCal.get(1);
            int n3 = this._panelCal.get(2);
            int n4 = this._panelCal.get(5);
            int n5 = TemporalController.this._temporalModel.get(0);
            int n6 = TemporalController.this._temporalModel.get(1);
            int n7 = TemporalController.this._temporalModel.get(2);
            int n8 = TemporalController.this._temporalModel.get(5);
            if (n != n5 || n2 != n6 || n3 != n7 || n4 != n8) {
                this._panelCal.set(0, n5);
                this._panelCal.set(1, n6);
                this._panelCal.set(2, n7);
                this._panelCal.set(5, n8);
                Date date = this._panelCal.getTime();
                this._calPanel.setSelectedDate(date);
                this._calPanel.makeDateVisible(date);
            }
        }

        public void setEnabled(boolean bl) {
            this.setEnabled((Component)this._calPanel, bl);
        }

        private void setEnabled(Component component, boolean bl) {
            if (component instanceof Container) {
                Component[] componentArray = ((Container)component).getComponents();
                for (int i = 0; i < componentArray.length; ++i) {
                    this.setEnabled(componentArray[i], bl);
                }
            }
            component.setEnabled(bl);
        }
    }
}

