/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.connections;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.connections.AdvancedPropertiesTab;
import oracle.dbtools.raptor.dialogs.CreateDialogArb;
import oracle.dbtools.raptor.explorer.dt.dialog.ConnectionDialogArb;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.util.ModelUtil;

public class ProxyConnectionPanel
extends AdvancedPropertiesTab
implements ItemListener {
    public static final String PROXY_TYPE_USER_NAME = "USER NAME";
    public static final String PROXY_TYPE_DISTINGUISHED_NAME = "DISTINGUISHED NAME";
    public static final String PROXY_TYPE = "PROXY_TYPE";
    public static final String IS_PROXY = "IS_PROXY";
    public static final String PROXY_CANCELLED = "Proxy Cancelled";
    private static final Set<String> SUPPORTED_KEYS = new HashSet<String>(Arrays.asList("IS_PROXY", "PROXY_TYPE", "PROXY_USER_NAME", "PROXY_USER_PASSWORD", "PROXY_DISTINGUISHED_NAME"));
    private JCheckBox mEnableProxy = new JCheckBox();
    private JLabel mLblType = new JLabel(Messages.getString("ProxyConnectionPanel.6"));
    private ButtonGroup mGroupType;
    private JRadioButton mBtnUser = new JRadioButton();
    private JRadioButton mBtnDN = new JRadioButton();
    private JLabel mLblUser = new JLabel();
    private JTextField mFldUser = new JTextField();
    private JLabel mLblProxyPwd = new JLabel();
    private JPasswordField mFldProxyPwd = new JPasswordField();
    private JLabel mLblDName = new JLabel();
    private JTextField mFldDName = new JTextField();

    private static int getPadding(JLabel jLabel, JLabel jLabel2) {
        int n = ProxyConnectionPanel.stringWidth(jLabel, jLabel.getText());
        int n2 = ProxyConnectionPanel.stringWidth(jLabel2, jLabel2.getText());
        return n2 > n ? n2 - n : 0;
    }

    private static int stringWidth(JComponent jComponent, String string) {
        return jComponent.getFontMetrics(jComponent.getFont()).stringWidth(string);
    }

    public static ProxyConnectionPanel createProxyPanel() {
        ProxyConnectionPanel proxyConnectionPanel = new ProxyConnectionPanel();
        proxyConnectionPanel.initialize();
        return proxyConnectionPanel;
    }

    private ProxyConnectionPanel() {
    }

    private void initialize() {
        this.mEnableProxy.addItemListener(this);
    }

    @Override
    String getSetName() {
        return ConnectionDialogArb.getString("PROXY_TAB_NAME");
    }

    @Override
    protected JComponent createPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        ResourceUtils.resButton((AbstractButton)this.mEnableProxy, (String)Messages.getString("OracleConnectionPanel.11"));
        jPanel.add((Component)this.mEnableProxy, LayoutControl.GBC.gbc(0, 0, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_START_COMP));
        final JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.add((Component)this.mLblType, LayoutControl.GBC.gbc(0, 0, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_START_COMP));
        this.mGroupType = new ButtonGroup();
        ResourceUtils.resButton((AbstractButton)this.mBtnUser, (String)CreateDialogArb.getString("PROXY_TYPE_USER"));
        this.mGroupType.add(this.mBtnUser);
        this.mBtnUser.setActionCommand(PROXY_TYPE_USER_NAME);
        this.mBtnUser.setSelected(true);
        ResourceUtils.resButton((AbstractButton)this.mBtnDN, (String)CreateDialogArb.getString("PROXY_LABEL_DN"));
        this.mGroupType.add(this.mBtnDN);
        this.mBtnDN.setActionCommand(PROXY_TYPE_DISTINGUISHED_NAME);
        jPanel2.add((Component)this.mBtnUser, LayoutControl.GBC.gbc(1, 0, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_LABEL2CONTROL_COMP));
        jPanel2.add((Component)this.mBtnDN, LayoutControl.GBC.gbc(2, 0, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_CONTROL2CONTROL_COMP, LayoutControl.GBC.Fill.NONE, LayoutControl.GBC.Spring.NONE, LayoutControl.GBC.Anchor.LINE_START));
        ResourceUtils.resLabel((JLabel)this.mLblUser, (Component)this.mFldUser, (String)CreateDialogArb.getString("PROXY_LABEL_USER"));
        jPanel2.add((Component)this.mLblUser, LayoutControl.GBC.gbc(0, 1, 1, 1, LayoutControl.GBC.Inset.LINE_START_COMP));
        jPanel2.add((Component)this.mFldUser, LayoutControl.GBC.gbc(1, 1, 2, 1, LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, LayoutControl.GBC.Fill.X, LayoutControl.GBC.Spring.X));
        ResourceUtils.resLabel((JLabel)this.mLblProxyPwd, (Component)this.mFldProxyPwd, (String)CreateDialogArb.getString("PROXY_LABEL_PASSWORD"));
        ResourceUtils.resLabel((JLabel)this.mLblDName, (Component)this.mFldDName, (String)CreateDialogArb.getString("PROXY_LABEL_DN"));
        ProxyConnectionPanel.layoutField(jPanel2, this.mLblProxyPwd, this.mFldProxyPwd, 2, ProxyConnectionPanel.getPadding(this.mLblProxyPwd, this.mLblDName));
        this.mBtnUser.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (ProxyConnectionPanel.this.mBtnUser.isSelected()) {
                    jPanel2.remove(ProxyConnectionPanel.this.mLblDName);
                    jPanel2.remove(ProxyConnectionPanel.this.mFldDName);
                    ProxyConnectionPanel.layoutField(jPanel2, ProxyConnectionPanel.this.mLblProxyPwd, ProxyConnectionPanel.this.mFldProxyPwd, 2, ProxyConnectionPanel.getPadding(ProxyConnectionPanel.this.mLblProxyPwd, ProxyConnectionPanel.this.mLblDName));
                    jPanel2.revalidate();
                    jPanel2.repaint();
                }
            }
        });
        this.mBtnDN.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (ProxyConnectionPanel.this.mBtnDN.isSelected()) {
                    jPanel2.remove(ProxyConnectionPanel.this.mLblProxyPwd);
                    jPanel2.remove(ProxyConnectionPanel.this.mFldProxyPwd);
                    ProxyConnectionPanel.layoutField(jPanel2, ProxyConnectionPanel.this.mLblDName, ProxyConnectionPanel.this.mFldDName, 2, ProxyConnectionPanel.getPadding(ProxyConnectionPanel.this.mLblDName, ProxyConnectionPanel.this.mLblProxyPwd));
                    jPanel2.revalidate();
                    jPanel2.repaint();
                }
            }
        });
        jPanel.add((Component)LayoutControl.GBC.createSubPanel(jPanel2), LayoutControl.GBC.gbc(0, 1, 1, 1, LayoutControl.GBC.Inset.LINE_START_COMP, LayoutControl.GBC.Fill.XY, LayoutControl.GBC.Spring.XY));
        return jPanel;
    }

    private static void layoutField(JPanel jPanel, JLabel jLabel, JTextField jTextField, int n, int n2) {
        GridBagConstraints gridBagConstraints = LayoutControl.GBC.gbc(0, n, 1, 1, LayoutControl.GBC.Inset.LINE_START_COMP);
        gridBagConstraints.ipadx = n2;
        jPanel.add((Component)jLabel, gridBagConstraints);
        jPanel.add((Component)jTextField, LayoutControl.GBC.gbc(1, n, 2, 1, LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, LayoutControl.GBC.Fill.X, LayoutControl.GBC.Spring.X));
    }

    @Override
    JComponent getInitialFocusComponent() {
        return this.mFldUser;
    }

    private String getProxyTypeSelected() {
        if (this.mBtnUser.isSelected()) {
            return PROXY_TYPE_USER_NAME;
        }
        return PROXY_TYPE_DISTINGUISHED_NAME;
    }

    private void enableProxyUI(boolean bl) {
        this.mLblType.setEnabled(bl);
        this.mBtnUser.setEnabled(bl);
        this.mBtnDN.setEnabled(bl);
        this.mFldProxyPwd.setEnabled(bl);
        this.mFldUser.setEnabled(bl);
        this.mFldDName.setEnabled(bl);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.mEnableProxy) {
            this.enableProxyUI(this.mEnableProxy.isSelected());
        }
    }

    @Override
    void populate(Properties properties) {
        boolean bl = Boolean.valueOf(properties.getProperty(IS_PROXY));
        this.mEnableProxy.setSelected(bl);
        this.enableProxyUI(bl);
        String string = properties.getProperty(PROXY_TYPE);
        if (PROXY_TYPE_DISTINGUISHED_NAME.equals(string)) {
            this.mBtnDN.setSelected(true);
            this.mFldDName.setText(properties.getProperty("PROXY_DISTINGUISHED_NAME"));
            this.mFldUser.setText(properties.getProperty("PROXY_USER_NAME"));
        } else {
            this.mBtnUser.setSelected(true);
            this.mFldUser.setText(properties.getProperty("PROXY_USER_NAME"));
            if (properties.getProperty("PROXY_USER_PASSWORD") != null) {
                this.mFldProxyPwd.setText(properties.getProperty("PROXY_USER_PASSWORD"));
            }
        }
    }

    @Override
    public void validateProperties() throws TraversalException {
        if (this.mEnableProxy.isSelected()) {
            String string;
            String string2 = this.mFldUser.getText().trim();
            if (!ModelUtil.hasLength((String)string2)) {
                throw new TraversalException(CreateDialogArb.getString("PROXY_USER_REQUIRED"));
            }
            if (PROXY_TYPE_DISTINGUISHED_NAME.equals(this.getProxyTypeSelected()) && !ModelUtil.hasLength((String)(string = this.mFldDName.getText().trim()))) {
                throw new TraversalException(CreateDialogArb.getString("PROXY_DN_REQUIRED"));
            }
        }
    }

    @Override
    public Properties getProperties() {
        Properties properties = new Properties();
        boolean bl = this.mEnableProxy.isSelected();
        properties.setProperty(IS_PROXY, Boolean.toString(bl));
        String string = this.getProxyTypeSelected();
        if (string != null) {
            properties.setProperty(PROXY_TYPE, string);
            String string2 = this.mFldUser.getText();
            if (string2 != null) {
                string2 = string2.trim();
            }
            properties.setProperty("PROXY_USER_NAME", string2);
            if (string.equals(PROXY_TYPE_USER_NAME)) {
                char[] cArray = this.mFldProxyPwd.getPassword();
                String string3 = cArray != null ? new String(cArray) : this.EMPTY_STRING;
                if ((string3 = string3.trim()).length() > 0) {
                    properties.setProperty("PROXY_USER_PASSWORD", string3);
                }
            } else if (string.equals(PROXY_TYPE_DISTINGUISHED_NAME)) {
                String string4 = this.mFldDName.getText();
                properties.setProperty("PROXY_DISTINGUISHED_NAME", string4);
            }
        }
        return properties;
    }

    @Override
    protected boolean isSupportedKey(String string) {
        return SUPPORTED_KEYS.contains(string);
    }
}

