/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.config;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.config.PreferencesArb;
import oracle.dbtools.raptor.data.ui.EncodingsPanel;
import oracle.dbtools.raptor.data.ui.ImportBadFilePanel;
import oracle.dbtools.raptor.data.ui.ImportLogFilePanel;
import oracle.dbtools.raptor.datatools.DataToolsArb;
import oracle.dbtools.raptor.datatools.core.BaseDataFormat;
import oracle.dbtools.raptor.export.wizard.ExportWizArb;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;

public class ImportModeSqlLoaderPreferences
extends DefaultTraversablePanel {
    private URLFileChooser.URLFileChooserPanel _genFilePanel;
    private ImportBadFilePanel _importBadFilePanel;
    private ImportLogFilePanel _importLogFilePanel;
    private JComboBox _recordTerminator;
    String[] _recordTerminators;
    private EncodingsPanel _encodingsPanel;
    private static final long serialVersionUID = -2739487292165944123L;

    public ImportModeSqlLoaderPreferences() {
        this.setHelpID("f1_dbworksheetImportparam_html");
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        int n = 0;
        this._importLogFilePanel = new ImportLogFilePanel();
        this.add(this._importLogFilePanel, new GridBagConstraints(0, n, 3, 1, 0.0, 0.0, 18, 2, new Insets(18, 0, 0, 8), 0, 0));
        this._importBadFilePanel = new ImportBadFilePanel();
        this.add(this._importBadFilePanel, new GridBagConstraints(0, ++n, 3, 1, 0.0, 0.0, 18, 2, new Insets(18, 0, 0, 8), 0, 0));
        this._recordTerminators = new String[]{DataToolsArb.getString("PLATFORM_DEFAULT"), DataToolsArb.getString("ENV_DEFAULT"), DataToolsArb.getString("IMPORT_FILE"), DataToolsArb.getString("LF"), DataToolsArb.getString("CRLF"), DataToolsArb.getString("CR")};
        this._recordTerminator = new JComboBox<String>(this._recordTerminators);
        JLabel jLabel = new JLabel(StringUtils.stripMnemonic((String)ExportWizArb.getString("RECORD_TERMINATOR")));
        jLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)ExportWizArb.getString("RECORD_TERMINATOR")));
        jLabel.setLabelFor(this._recordTerminator);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(null, PreferencesArb.getString("IMPORT_GEN_FILES"), 0, 0, null, null));
        this._encodingsPanel = new EncodingsPanel("IMPORT_LDR_GEN_ENCODING");
        JLabel jLabel2 = new JLabel(StringUtils.stripMnemonic((String)PreferencesArb.getString("IMPORT_GEN_ENCODING")));
        jLabel2.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)PreferencesArb.getString("IMPORT_GEN_ENCODING")));
        jLabel2.setLabelFor(this._encodingsPanel.getEncodingComboBox());
        jPanel.add((Component)jLabel2, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 18, 0, new Insets(8, 0, 0, 8), 0, 0));
        jPanel.add((Component)this._encodingsPanel, new GridBagConstraints(1, n, 2, 1, 1.0, 0.0, 18, 0, new Insets(6, 0, 0, 0), 0, 0));
        jPanel.add((Component)jLabel, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 18, 0, new Insets(18, 0, 0, 8), 0, 0));
        jPanel.add((Component)this._recordTerminator, new GridBagConstraints(1, n, 2, 1, 1.0, 0.0, 18, 2, new Insets(16, 0, 0, 0), 0, 0));
        String string = StringUtils.stripMnemonic((String)PreferencesArb.getString("IMPORT_GEN_DIR"));
        JLabel jLabel3 = new JLabel(string);
        jLabel3.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)PreferencesArb.getString("IMPORT_GEN_DIR")));
        this._genFilePanel = URLFileChooser.createURLFileChooserPanel(0, string, false, false);
        this._genFilePanel.setSelectionScope(1);
        this._genFilePanel.setPathContext(((Object)((Object)this)).getClass().getName() + "._genFileChooser");
        jLabel3.setLabelFor(this._genFilePanel);
        jPanel.add((Component)jLabel3, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 18, 0, new Insets(18, 0, 6, 8), 0, 0));
        jPanel.add((Component)this._genFilePanel, new GridBagConstraints(1, n, 2, 1, 1.0, 0.0, 18, 2, new Insets(16, 0, 6, 0), 0, 0));
        this.add(jPanel, new GridBagConstraints(0, ++n, 2, 1, 1.0, 0.0, 18, 2, new Insets(16, 0, 0, 0), 0, 0));
        this.add(Box.createGlue(), new GridBagConstraints(0, ++n, 2, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void onEntry(TraversableContext traversableContext) {
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        String string = BaseDataFormat.getRecordTerminatorFromConfigValue(dBConfig.getString("IMPORT_LDR_GEN_TERM"));
        boolean bl = false;
        for (int i = 0; string != null && i < this._recordTerminators.length; ++i) {
            if (!this._recordTerminators[i].equals(string)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this._recordTerminator.addItem(string);
        }
        this._recordTerminator.setSelectedItem(string);
        this._encodingsPanel.onEntry(traversableContext);
        this._genFilePanel.setText(dBConfig.getString("IMPORT_LDR_GEN_DIR"));
        this._importLogFilePanel.onEntry(traversableContext);
        this._importBadFilePanel.onEntry(traversableContext);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        dBConfig.putString("IMPORT_LDR_GEN_TERM", BaseDataFormat.getRecordTerminatorForConfigValue((String)this._recordTerminator.getSelectedItem()));
        this._encodingsPanel.onExit(traversableContext);
        dBConfig.putString("IMPORT_LDR_GEN_DIR", this._genFilePanel.getText());
        this._importLogFilePanel.onExit(traversableContext);
        this._importBadFilePanel.onExit(traversableContext);
    }
}

