/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.config;

import oracle.dbtools.raptor.config.FormatOptions;
import oracle.dbtools.raptor.utils.CaseType;
import oracle.dbtools.raptor.utils.TabType;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;

public class ConfigFormat
extends HashStructureAdapter {
    private static final String TABTYPE = "TABTYPE";
    private static final String TABSIZE = "TABSIZE";
    private static final String KEYWORDCASE = "KEYWORDCASE";
    private static final String IDENTIFIERCASE = "IDENTIFIERCASE";
    private static final String KEEPNEWLINES = "KEEPNEWLINES";
    private static final String LISTITEMS = "LISTITEMS";
    private static final String WIDTHSIZE = "WIDTHSIZE";
    private static final String WRAPON = "WRAPON";
    public static final String KEY = "IdeSettings4Formatter0.5";

    protected ConfigFormat(HashStructure hashStructure) {
        super(hashStructure);
    }

    public static ConfigFormat getInstance(PropertyStorage propertyStorage) {
        return new ConfigFormat(ConfigFormat.findOrCreate((PropertyStorage)propertyStorage, (String)KEY));
    }

    public final boolean isWrapOn() {
        return this._hash.getBoolean(WRAPON, false);
    }

    public final void setWrapOn(boolean bl) {
        this._hash.putBoolean(WRAPON, bl);
    }

    public final int getWidthSize() {
        return this._hash.getInt(WIDTHSIZE, 80);
    }

    public final void setWidthSize(int n) {
        this._hash.putInt(WIDTHSIZE, n);
    }

    public final boolean getListItems() {
        return this._hash.getBoolean(LISTITEMS, true);
    }

    public final void setListItems(boolean bl) {
        this._hash.putBoolean(LISTITEMS, bl);
    }

    public final TabType getTabType() {
        return TabType.valueOf(this._hash.getString(TABTYPE, TabType.SPACE.name()));
    }

    public final void setTabType(TabType tabType) {
        this._hash.putString(TABTYPE, tabType.name());
    }

    public final int getTabSize() {
        return this._hash.getInt(TABSIZE, 2);
    }

    public final void setTabSize(int n) {
        this._hash.putInt(TABSIZE, n);
    }

    public final CaseType getKeywordCase() {
        return CaseType.valueOf(this._hash.getString(KEYWORDCASE, CaseType.UPPER.name()));
    }

    public final void setKeywordCase(CaseType caseType) {
        this._hash.putString(KEYWORDCASE, caseType.name());
    }

    public final CaseType getIdentifierCase() {
        return CaseType.valueOf(this._hash.getString(IDENTIFIERCASE, CaseType.LOWER.name()));
    }

    public final void setIdentifierCase(CaseType caseType) {
        this._hash.putString(IDENTIFIERCASE, caseType.name());
    }

    public final boolean isKeepNewLines() {
        return this._hash.getBoolean(KEEPNEWLINES, true);
    }

    public final void setKeepNewLines(boolean bl) {
        this._hash.putBoolean(KEEPNEWLINES, bl);
    }

    public FormatOptions getBasicFormatOptions() {
        FormatOptions formatOptions = new FormatOptions();
        formatOptions.setIdentifierCase(this.getIdentifierCase().name().toLowerCase());
        formatOptions.setKeywordCase(this.getKeywordCase().name().toLowerCase());
        int n = this.getTabSize();
        int n2 = this.getWidthSize();
        formatOptions.setTabSize(n);
        formatOptions.setWidthSize(n2);
        formatOptions.setTabType(this.getTabType().name().toLowerCase());
        formatOptions.setKeepNewLines(this.isKeepNewLines());
        formatOptions.setListNewLines(this.getListItems());
        formatOptions.setWrapOn(this.isWrapOn());
        return formatOptions;
    }
}

