/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.config;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.text.Document;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.config.CodeTemplateRow;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.templates.CodeTemplateUtil;
import oracle.dbtools.raptor.templates.TemplateVariableHandler;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.gutter.LineGutterPlugin;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.editor.plugins.LineHighlightPlugin;
import oracle.javatools.icons.OracleIcons;

public class CodeTemplatePanel
extends DefaultTraversablePanel {
    private static final long serialVersionUID = 1L;
    private JTable m_table;
    private DefaultTableModel m_model = new DefaultTableModel();
    private JTextField tfTemplate;
    private DefaultTableModel m_var_model = new DefaultTableModel(){

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    };
    private JTable m_var_table;

    public CodeTemplatePanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            ExceptionHandler.handleException((Throwable)exception);
        }
    }

    public void setColumns(List<CodeTemplateRow> list) {
        for (CodeTemplateRow codeTemplateRow : list) {
            this.addRow(codeTemplateRow.getId(), codeTemplateRow.getTemplate());
        }
    }

    private void jbInit() {
        this.setHelpID("f1_codetemplatepreference_html");
        this.setLayout(new GridBagLayout());
        JScrollPane jScrollPane = new JScrollPane();
        this.add(jScrollPane, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 17, 1, new Insets(10, 5, 0, 0), 0, 0));
        this.m_table = new JTable(this.m_model);
        this.m_model.addColumn(Messages.getString("CodeTemplatePanel.1"));
        this.m_model.addColumn(Messages.getString("CodeTemplatePanel.2"));
        this.m_table.setShowGrid(true);
        jScrollPane.setViewportView(this.m_table);
        JButton jButton = new JButton();
        ResourceUtils.resButton((AbstractButton)jButton, (String)Messages.getString("CodeTemplatePanel.3"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CodeTemplatePanel.this.addRow(null, null);
                CodeTemplatePanel.this.m_table.setRowSelectionInterval(CodeTemplatePanel.this.m_table.getRowCount() - 1, CodeTemplatePanel.this.m_table.getRowCount() - 1);
                CodeTemplatePanel.this.m_table.setColumnSelectionInterval(0, 0);
            }
        });
        this.m_table.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

            @Override
            public void setValue(Object object) {
                super.setValue(object);
                if (object != null) {
                    this.setToolTipText(object.toString());
                }
            }
        });
        this.add(jButton, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
        JButton jButton2 = new JButton();
        ResourceUtils.resButton((AbstractButton)jButton2, (String)Messages.getString("CodeTemplatePanel.4"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = CodeTemplatePanel.this.m_table.getSelectedRow();
                int n2 = CodeTemplatePanel.this.m_table.getSelectedColumn();
                while (n > -1 && n2 > -1) {
                    if (CodeTemplatePanel.this.m_table.isEditing()) {
                        CodeTemplatePanel.this.m_table.getCellEditor(n, n2).stopCellEditing();
                    }
                    CodeTemplatePanel.this.m_model.removeRow(n);
                    n = CodeTemplatePanel.this.m_table.getSelectedRow();
                }
            }
        });
        this.add(jButton2, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
        jScrollPane = new JScrollPane();
        this.add(jScrollPane, new GridBagConstraints(0, 3, 2, 1, 1.0, 1.0, 17, 1, new Insets(10, 5, 0, 0), 0, 0));
        this.m_var_table = new JTable(this.m_var_model);
        this.m_var_model.addColumn(Messages.getString("CodeTemplatePanel.5"));
        this.m_var_model.addColumn(Messages.getString("CodeTemplatePanel.6"));
        jScrollPane.setViewportView(this.m_var_table);
        this.m_var_table.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

            @Override
            public void setValue(Object object) {
                super.setValue(object);
                this.setToolTipText(object.toString());
            }
        });
        int n = 0;
        TableColumn tableColumn = this.m_table.getColumnModel().getColumn(n);
        n = 1;
        tableColumn = this.m_table.getColumnModel().getColumn(n);
        tableColumn.setCellEditor(new SQLCellEditor());
    }

    public void addRow(String string, String string2) {
        this.m_model.addRow(new Object[]{string, string2});
        this.m_model.fireTableDataChanged();
    }

    public void onEntry(TraversableContext traversableContext) {
        Map map = CodeTemplateUtil.loadFiles();
        DefaultTableModel defaultTableModel = new DefaultTableModel(new String[]{Messages.getString("CodeTemplatePanel.7"), Messages.getString("CodeTemplatePanel.8")}, 0);
        for (Object object : map.keySet()) {
            defaultTableModel.addRow(new Object[]{object, map.get(object)});
        }
        if (defaultTableModel.getColumnName(0).equals(Messages.getString("CodeTemplatePanel.9"))) {
            Object object;
            this.m_model = defaultTableModel;
            this.m_table.setModel(this.m_model);
            this.m_table.updateUI();
            int n = 1;
            object = this.m_table.getColumnModel().getColumn(n);
            ((TableColumn)object).setCellEditor(new SQLCellEditor());
        }
        this.m_var_model.setRowCount(0);
        for (Object object : TemplateVariableHandler.getHandlers().keySet()) {
            this.m_var_model.addRow(new Object[]{object, TemplateVariableHandler.getHandler((String)object).getDescription()});
        }
        this.m_var_table.updateUI();
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        if (this.m_table.getCellEditor() != null) {
            this.m_table.getCellEditor().stopCellEditing();
        }
        CodeTemplateUtil.save((TableModel)this.m_model);
    }

    private class SQLEditorPanel
    extends JPanel {
        private SQLEditorPanel() {
            this.jbInit();
        }

        private void jbInit() {
            this.setLayout(new BorderLayout());
            CodeTemplatePanel.this.tfTemplate = new JTextField();
            CodeTemplatePanel.this.tfTemplate.setEditable(true);
            Document document = CodeTemplatePanel.this.tfTemplate.getDocument();
            if (document != null) {
                document.putProperty("filterNewlines", Boolean.FALSE);
                CodeTemplatePanel.this.tfTemplate.setText("");
            }
            this.add((Component)CodeTemplatePanel.this.tfTemplate, "Center");
            JButton jButton = new JButton(OracleIcons.getIcon((String)"edit.png"));
            this.add((Component)jButton, "East");
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    BasicEditorPane basicEditorPane = EditorFactory.createIdeEditorPane();
                    basicEditorPane.setDocument((Document)new BasicDocument("template.plsql"));
                    basicEditorPane.setText(CodeTemplatePanel.this.tfTemplate.getText());
                    basicEditorPane.installPlugin((EditorPlugin)new LineHighlightPlugin());
                    LineGutterPlugin lineGutterPlugin = new LineGutterPlugin();
                    basicEditorPane.installPlugin((EditorPlugin)lineGutterPlugin);
                    JScrollPane jScrollPane = new JScrollPane((Component)basicEditorPane, 20, 30);
                    jScrollPane.setRowHeaderView((Component)lineGutterPlugin);
                    JPanel jPanel = new JPanel(new BorderLayout());
                    jPanel.add((Component)jScrollPane, "Center");
                    jPanel.setPreferredSize(new Dimension(200, 200));
                    UIUtils.showPanelAsDialog((JPanel)jPanel, (String)Messages.getString("CodeTemplatePanel.13"), null, (int)16);
                    SQLEditorPanel.this.setSQL(basicEditorPane.getText());
                }
            });
        }

        public String getSQL() {
            return CodeTemplatePanel.this.tfTemplate.getText();
        }

        public void setSQL(String string) {
            CodeTemplatePanel.this.tfTemplate.setText(string);
            CodeTemplatePanel.this.tfTemplate.setToolTipText(string);
        }
    }

    class SQLCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private static final long serialVersionUID = -5548409927660575961L;
        private SQLEditorPanel component;

        public SQLCellEditor() {
            this.component = new SQLEditorPanel();
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.component.setSQL((String)object);
            return this.component;
        }

        public SQLEditorPanel getComponent() {
            return this.component;
        }

        @Override
        public Object getCellEditorValue() {
            return this.component.getSQL();
        }
    }
}

