/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.cloud.controls;

import java.text.Collator;
import java.util.Comparator;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import oracle.dbtools.raptor.cloud.CloudBrowserResources;
import oracle.dbtools.raptor.cloud.connection.CConnectionType;
import oracle.dbtools.raptor.cloud.connection.CConnections;
import oracle.dbtools.raptor.cloud.connection.CloudConnectionType;
import oracle.dbtools.raptor.controls.Bug4199622Fix;
import oracle.ide.controls.SortedComboBoxModel;

public class CloudConnectionComboBox {
    private JComboBox m_combo;
    private DefaultComboBoxModel m_model;
    private CConnectionType m_type;

    public CloudConnectionComboBox() {
        this(CloudConnectionType.getInstance());
    }

    public CloudConnectionComboBox(CConnectionType cConnectionType) {
        this.m_type = cConnectionType;
    }

    public final JComboBox getComboBox() {
        if (this.m_combo == null) {
            this.m_model = this.createModel();
            this.m_combo = this.createCombo(this.m_model);
        }
        return this.m_combo;
    }

    protected JComboBox createCombo(ComboBoxModel comboBoxModel) {
        JComboBox jComboBox = new JComboBox(comboBoxModel);
        jComboBox.setToolTipText(CloudBrowserResources.getString("SELECTOR_TOOLTIP"));
        jComboBox.addActionListener(Bug4199622Fix.INSTANCE);
        jComboBox.addPopupMenuListener(Bug4199622Fix.INSTANCE);
        return jComboBox;
    }

    protected DefaultComboBoxModel createModel() {
        SortedComboBoxModel sortedComboBoxModel = new SortedComboBoxModel();
        sortedComboBoxModel.setComparator((Comparator)new Comparator<Object>(){

            @Override
            public int compare(Object object, Object object2) {
                return Collator.getInstance().compare(object, object2);
            }
        });
        for (String string : CConnections.getInstance(this.m_type).listConnections()) {
            sortedComboBoxModel.addElement((Object)string);
        }
        return sortedComboBoxModel;
    }

    public String getCurrentConnectionName() {
        if (this.m_combo != null && this.m_combo.getItemCount() > 0) {
            return (String)this.m_combo.getSelectedItem();
        }
        return null;
    }
}

