/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor;

import java.sql.Connection;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.ConnectionResolver;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetFormatter;
import oracle.dbtools.raptor.DefaultProviderForSQLPATH;
import oracle.dbtools.raptor.InitializeConnectionListener;
import oracle.dbtools.raptor.config.BindConfig;
import oracle.dbtools.raptor.config.ConfigChangeListener;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.config.NavigationFilterChangeListener;
import oracle.dbtools.raptor.navigator.db.xml.ConnectionTypeDetails;
import oracle.dbtools.raptor.newscriptrunner.ProviderForSQLPATH;
import oracle.dbtools.raptor.newscriptrunner.SQLPLUS;
import oracle.dbtools.raptor.nls.DefaultNLSProvider;
import oracle.dbtools.raptor.nls.INLSSupplier;
import oracle.dbtools.raptor.nls.NLSProvider;
import oracle.dbtools.raptor.utils.ClosedConnectionListener;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DefaultProviderTnsnamesDir;
import oracle.dbtools.raptor.utils.IdeMessageLogger;
import oracle.dbtools.raptor.utils.MessageLogging;
import oracle.dbtools.raptor.utils.ProvideTnsnamesDir;
import oracle.dbtools.raptor.utils.RaptorDbDisconnectListener;
import oracle.dbtools.raptor.utils.SQLExceptionListener;
import oracle.dbtools.raptor.utils.SQLExceptionListenerRegistry;
import oracle.dbtools.raptor.utils.TNSHelper;
import oracle.ide.Addin;
import oracle.ide.Ide;
import oracle.ide.config.ClientSetting;
import oracle.ide.config.IdeSettings;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.db.DBException;
import oracle.javatools.db.ora.OracleDatabaseFactory;
import oracle.javatools.util.Copyable;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.ConnectionsEvent;
import oracle.jdeveloper.db.ConnectionsListener;
import oracle.jdeveloper.db.DatabaseConnections;

public class RaptorCoreAddin
implements Addin {
    private RaptorDbDisconnectListener m_disconnectListener = RaptorDbDisconnectListener.getInstance();

    public void initialize() {
        BindConfig bindConfig;
        Preferences preferences = Preferences.getPreferences();
        DBConfig dBConfig = DBConfig.getInstance((PropertyStorage)preferences);
        BindConfig bindConfig2 = BindConfig.getInstance((PropertyStorage)preferences);
        IdeSettings ideSettings = Ide.getSettings();
        ClientSetting clientSetting = ClientSetting.findOrCreate((String)"oracle.sqldeveloper");
        DBConfig dBConfig2 = (DBConfig)clientSetting.getData("DBConfig");
        if (dBConfig2 != null) {
            clientSetting.putData("DBConfig", (Copyable)dBConfig2);
            ideSettings.putLegacyData("DBConfig", (Copyable)dBConfig);
        }
        if ((bindConfig = (BindConfig)clientSetting.getData("BindConfig")) != null) {
            clientSetting.putData("BindConfig", (Copyable)bindConfig);
            ideSettings.putLegacyData("BindConfig", (Copyable)bindConfig2);
        }
        preferences.addStructureChangeListener((StructureChangeListener)new ConfigChangeListener());
        preferences.addStructureChangeListener((StructureChangeListener)new NavigationFilterChangeListener());
        ResultSetFormatter.setMaxRows((int)dBConfig.getInt("MAXSCRIPTROWS"));
        ResultSetFormatter.setMaxLines((int)dBConfig.getInt("MAXSCRIPTLINES"));
        TNSHelper.setProvideTnsnamesDir((ProvideTnsnamesDir)new DefaultProviderTnsnamesDir());
        SQLPLUS.setSqlpathProvider((ProviderForSQLPATH)new DefaultProviderForSQLPATH());
        this.initConnectionStore();
        InitializeConnectionListener initializeConnectionListener = new InitializeConnectionListener();
        initializeConnectionListener.register();
        this.initSettings(clientSetting);
        Connections.getInstance().addConnectionDisconnectListener(this.m_disconnectListener);
        SQLExceptionListenerRegistry.addListener((SQLExceptionListener)new ClosedConnectionListener());
        NLSProvider.setNLSSupplier((INLSSupplier)new INLSSupplier(){

            public DefaultNLSProvider getNLSProvider(Connection connection) {
                return ConnectionTypeDetails.getTypeDetails("", connection).getNLSProvider(connection);
            }

            public DefaultNLSProvider getNLSProvider(String string) {
                Connection connection = null;
                try {
                    connection = Connections.getInstance().getConnection(string);
                }
                catch (DBException dBException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, dBException.getStackTrace()[0].toString(), dBException);
                }
                return ConnectionTypeDetails.getTypeDetails("", connection).getNLSProvider(connection);
            }
        });
    }

    private void initConnectionStore() {
        MessageLogging.setMessageLogger((MessageLogging)new IdeMessageLogger());
        DBUtil.setConnectionResolver((ConnectionResolver)Connections.getInstance());
        final DatabaseConnections databaseConnections = DatabaseConnections.getInstance();
        databaseConnections.addListener(new ConnectionsListener(){

            public void connectionAdded(ConnectionsEvent connectionsEvent) {
                this.saveConnections();
            }

            public void connectionRemoved(ConnectionsEvent connectionsEvent) {
                this.saveConnections();
            }

            public void connectionUpdated(ConnectionsEvent connectionsEvent) {
                this.saveConnections();
            }

            private void saveConnections() {
                try {
                    databaseConnections.saveConnections();
                }
                catch (ConnectionException connectionException) {
                    // empty catch block
                }
            }
        });
    }

    private void initSettings(ClientSetting clientSetting) {
        OracleDatabaseFactory.setDefaultAutocommit((boolean)false);
    }
}

