/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.proformatter.treePreferences.style.profile;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import oracle.dbtools.proformatter.treePreferences.CodingStyleSQLProfile;
import oracle.dbtools.proformatter.treePreferences.NameAndDatabase;
import oracle.dbtools.proformatter.treePreferences.style.profile.ProfileRepository;
import oracle.javatools.util.ModelUtil;

public class ProfileModel
extends AbstractListModel
implements ComboBoxModel {
    private List<CodingStyleSQLProfile> profiles;
    private CodingStyleSQLProfile selection;
    private static Comparator<CodingStyleSQLProfile> s_comparator = new ProfileComparator();
    private static Comparator<Object> s_nameComparator = new ProfileNameAndDatabaseComparator();
    final ProfileRepository repository = ProfileRepository.getProfileRepository();
    private int platform = 0;

    public ProfileModel(int n) {
        this.platform = n;
        this.profiles = new ArrayList<CodingStyleSQLProfile>();
        for (CodingStyleSQLProfile codingStyleSQLProfile : this.repository.getProfiles()) {
            if (codingStyleSQLProfile.getSourceSql() != this.platform && this.platform != 0) continue;
            CodingStyleSQLProfile codingStyleSQLProfile2 = new CodingStyleSQLProfile();
            codingStyleSQLProfile.copyTo(codingStyleSQLProfile2);
            this.profiles.add(codingStyleSQLProfile2);
        }
        Collections.sort(this.profiles, s_comparator);
    }

    public void setPlatform(int n) {
        this.platform = n;
    }

    @Override
    public int getSize() {
        return this.profiles.size();
    }

    @Override
    public Object getSelectedItem() {
        return this.selection;
    }

    @Override
    public Object getElementAt(int n) {
        return this.profiles.get(n);
    }

    public boolean contains(NameAndDatabase nameAndDatabase) {
        return Collections.binarySearch(this.profiles, nameAndDatabase, s_nameComparator) >= 0;
    }

    public CodingStyleSQLProfile getProfile(NameAndDatabase nameAndDatabase) {
        int n = Collections.binarySearch(this.profiles, nameAndDatabase, s_nameComparator);
        return n >= 0 ? this.profiles.get(n) : null;
    }

    public void add(CodingStyleSQLProfile codingStyleSQLProfile) {
        int n = Collections.binarySearch(this.profiles, codingStyleSQLProfile, s_comparator);
        if (n < 0) {
            n = -n - 1;
            this.profiles.add(n, codingStyleSQLProfile);
            this.fireIntervalAdded(this, n, n);
        } else {
            this.profiles.set(n, codingStyleSQLProfile);
            codingStyleSQLProfile.setDirty(true);
            this.fireContentsChanged(this, n, n);
        }
    }

    public void remove(CodingStyleSQLProfile codingStyleSQLProfile) {
        int n = Collections.binarySearch(this.profiles, codingStyleSQLProfile, s_comparator);
        if (n >= 0) {
            if (this.selection.equals(codingStyleSQLProfile)) {
                this.setSelectedItem(n > 0 ? this.profiles.get(n - 1) : this.profiles.get(1));
            }
            this.profiles.remove(n);
            this.fireIntervalRemoved(this, n, n);
        }
    }

    public boolean isDefaultProfile(CodingStyleSQLProfile codingStyleSQLProfile) {
        return this.repository.getDefaultProfileByDatabase(new NameAndDatabase(codingStyleSQLProfile.getName(), codingStyleSQLProfile.getSourceSql())) != null;
    }

    public boolean canRestore(CodingStyleSQLProfile codingStyleSQLProfile) {
        CodingStyleSQLProfile codingStyleSQLProfile2 = this.repository.getDefaultProfileByDatabase(new NameAndDatabase(codingStyleSQLProfile.getName(), codingStyleSQLProfile.getSourceSql()));
        if (codingStyleSQLProfile2 != null) {
            return ModelUtil.areDifferent((Object)codingStyleSQLProfile2, (Object)codingStyleSQLProfile);
        }
        return false;
    }

    public void restore(CodingStyleSQLProfile codingStyleSQLProfile) {
        assert (this.isDefaultProfile(codingStyleSQLProfile));
        String string = codingStyleSQLProfile.getName();
        CodingStyleSQLProfile codingStyleSQLProfile2 = this.repository.getDefaultProfileByDatabase(new NameAndDatabase(string, codingStyleSQLProfile.getSourceSql()));
        codingStyleSQLProfile2.copyTo(codingStyleSQLProfile);
        codingStyleSQLProfile.setModified(false);
        codingStyleSQLProfile.setDirty(true);
        int n = Collections.binarySearch(this.profiles, new NameAndDatabase(string, codingStyleSQLProfile.getSourceSql()), s_nameComparator);
        this.fireContentsChanged(this, n, n);
    }

    public CodingStyleSQLProfile copy(CodingStyleSQLProfile codingStyleSQLProfile, String string) {
        CodingStyleSQLProfile codingStyleSQLProfile2 = new CodingStyleSQLProfile();
        codingStyleSQLProfile.copyTo(codingStyleSQLProfile2);
        codingStyleSQLProfile2.setName(string);
        int n = Collections.binarySearch(this.profiles, new NameAndDatabase(string, codingStyleSQLProfile.getSourceSql()), s_nameComparator);
        if (n < 0) {
            n = -n - 1;
            this.profiles.add(n, codingStyleSQLProfile2);
            this.fireIntervalAdded(this, n, n);
        } else {
            CodingStyleSQLProfile codingStyleSQLProfile3 = this.profiles.get(n);
            this.profiles.set(n, codingStyleSQLProfile2);
            if (!string.equals(codingStyleSQLProfile3.getName())) {
                this.repository.removeProfile(codingStyleSQLProfile3);
            }
            this.fireContentsChanged(this, n, n);
        }
        this.save(codingStyleSQLProfile2);
        return codingStyleSQLProfile2;
    }

    public void save() {
        HashSet<String> hashSet = new HashSet<String>();
        int n = 0;
        for (CodingStyleSQLProfile codingStyleSQLProfile : this.profiles) {
            n = codingStyleSQLProfile.getSourceSql();
            NameAndDatabase nameAndDatabase = new NameAndDatabase(codingStyleSQLProfile.getName(), n);
            hashSet.add(nameAndDatabase.toString());
            if (this.repository.contains(nameAndDatabase) && !codingStyleSQLProfile.isDirty()) continue;
            this.save(codingStyleSQLProfile);
        }
        for (CodingStyleSQLProfile codingStyleSQLProfile : this.repository.getProfiles()) {
            int n2 = codingStyleSQLProfile.getSourceSql();
            if (hashSet.contains(new NameAndDatabase(codingStyleSQLProfile.getName(), n2).toString()) || n != n2) continue;
            this.repository.removeProfile(codingStyleSQLProfile);
        }
    }

    public void revert() {
        HashSet hashSet = new HashSet();
        ArrayList<CodingStyleSQLProfile> arrayList = new ArrayList<CodingStyleSQLProfile>();
        int n = 0;
        for (CodingStyleSQLProfile codingStyleSQLProfile : this.profiles) {
            n = codingStyleSQLProfile.getSourceSql();
            if (!this.repository.contains(new NameAndDatabase(codingStyleSQLProfile.getName(), n))) {
                arrayList.add(codingStyleSQLProfile);
                continue;
            }
            if (!codingStyleSQLProfile.isDirty()) continue;
            this.revert(codingStyleSQLProfile);
        }
        for (CodingStyleSQLProfile codingStyleSQLProfile : arrayList) {
            this.remove(codingStyleSQLProfile);
        }
        for (CodingStyleSQLProfile codingStyleSQLProfile : this.repository.getProfiles()) {
            int n2 = codingStyleSQLProfile.getSourceSql();
            if (hashSet.contains(new NameAndDatabase(codingStyleSQLProfile.getName(), n2).toString()) || n2 != n) continue;
            this.add(codingStyleSQLProfile);
        }
    }

    public void setModified(CodingStyleSQLProfile codingStyleSQLProfile) {
        int n = this.profiles.indexOf(codingStyleSQLProfile);
        if (n >= 0) {
            codingStyleSQLProfile.setModified(true);
            codingStyleSQLProfile.setDirty(true);
            this.fireContentsChanged(this, n, n);
        }
    }

    public void save(CodingStyleSQLProfile codingStyleSQLProfile) {
        CodingStyleSQLProfile codingStyleSQLProfile2 = new CodingStyleSQLProfile();
        codingStyleSQLProfile.copyTo(codingStyleSQLProfile2);
        this.repository.addProfile(codingStyleSQLProfile2);
    }

    public void revert(CodingStyleSQLProfile codingStyleSQLProfile) {
        String string = codingStyleSQLProfile.getName();
        if (this.repository.containsKey(new NameAndDatabase(string, codingStyleSQLProfile.getSourceSql()))) {
            CodingStyleSQLProfile codingStyleSQLProfile2 = this.repository.getProfile(new NameAndDatabase(string, codingStyleSQLProfile.getSourceSql()));
            codingStyleSQLProfile2.copyTo(codingStyleSQLProfile);
            codingStyleSQLProfile.setModified(false);
            codingStyleSQLProfile.setDirty(false);
            int n = Collections.binarySearch(this.profiles, new NameAndDatabase(codingStyleSQLProfile.getName(), codingStyleSQLProfile.getSourceSql()), s_nameComparator);
            this.fireContentsChanged(this, n, n);
        }
    }

    public CodingStyleSQLProfile getDefaultProfile(int n) {
        String string = this.repository.getDefaultProfileByDatabase(n).getName();
        return this.getProfile(new NameAndDatabase(string, n));
    }

    @Override
    public void setSelectedItem(Object object) {
        if (!(object == null && this.getSize() != 0 || this.selection != null && this.selection.equals(object))) {
            CodingStyleSQLProfile codingStyleSQLProfile = (CodingStyleSQLProfile)object;
            if (codingStyleSQLProfile != null && !this.contains(new NameAndDatabase(codingStyleSQLProfile.getName(), codingStyleSQLProfile.getSourceSql()))) {
                this.add(codingStyleSQLProfile);
            }
            this.selection = codingStyleSQLProfile;
            this.fireContentsChanged(this, -1, -1);
        }
    }

    private static class ProfileNameAndDatabaseComparator
    implements Comparator<Object> {
        private ProfileNameAndDatabaseComparator() {
        }

        @Override
        public int compare(Object object, Object object2) {
            int n;
            String string;
            NameAndDatabase nameAndDatabase;
            int n2;
            String string2;
            if (object instanceof CodingStyleSQLProfile) {
                string2 = ((CodingStyleSQLProfile)object).getName();
                n2 = ((CodingStyleSQLProfile)object).getSourceSql();
            } else {
                nameAndDatabase = (NameAndDatabase)object;
                string2 = nameAndDatabase.getName();
                n2 = nameAndDatabase.getDatabase();
            }
            if (object2 instanceof CodingStyleSQLProfile) {
                string = ((CodingStyleSQLProfile)object2).getName();
                n = ((CodingStyleSQLProfile)object2).getSourceSql();
            } else {
                nameAndDatabase = (NameAndDatabase)object2;
                string = nameAndDatabase.getName();
                n = nameAndDatabase.getDatabase();
            }
            if (string2.equalsIgnoreCase(string)) {
                return n2 - n;
            }
            return string2.compareToIgnoreCase(string);
        }
    }

    private static class ProfileComparator
    implements Comparator<CodingStyleSQLProfile> {
        private ProfileComparator() {
        }

        @Override
        public int compare(CodingStyleSQLProfile codingStyleSQLProfile, CodingStyleSQLProfile codingStyleSQLProfile2) {
            String string = codingStyleSQLProfile.getName();
            String string2 = codingStyleSQLProfile2.getName();
            return string.compareToIgnoreCase(string2);
        }
    }
}

