/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.proformatter.treePreferences.style;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import oracle.bali.ewt.button.ButtonBar;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.proformatter.SQLFormatter;
import oracle.dbtools.proformatter.SQLFormatterArb;
import oracle.dbtools.proformatter.dbPrefPanel;
import oracle.dbtools.proformatter.treePreferences.CodingStyleSQLProfile;
import oracle.dbtools.proformatter.treePreferences.NameAndDatabase;
import oracle.dbtools.proformatter.treePreferences.style.preferences.CodingStylePreferencesPanel;
import oracle.dbtools.proformatter.treePreferences.style.preferences.CodingStyleSQLPreferences;
import oracle.dbtools.proformatter.treePreferences.style.profile.CodingStyleSQLProfiles;
import oracle.dbtools.proformatter.treePreferences.style.profile.ProfileRepository;
import oracle.dbtools.raptor.RaptorExtensionConstants;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.util.ModelUtil;

public class OverallImportExport
extends DefaultTraversablePanel
implements ActionListener {
    static final long serialVersionUID = 1970L;
    JPanel north = null;
    JPanel twoPanels = null;
    JButton importJB = new JButton(StringUtils.stripMnemonic((String)SQLFormatterArb.getString("OverallImportExport_IMPORT")));
    JButton exportJB = new JButton(StringUtils.stripMnemonic((String)SQLFormatterArb.getString("OverallImportExport_EXPORT")));
    public static String TITLE = SQLFormatterArb.getString("OverallImportExport_OVERALL_PROFILE_PREFERENCE");
    private dbPrefPanel panel = new dbPrefPanel();
    private URL lastImportExportURL;
    private boolean loadHappened = false;

    public OverallImportExport() {
        this.setHelpID("f1_idedidesetsqlformat_html");
        this.twoPanels = new JPanel();
        this.north = new JPanel();
        this.north.setLayout(new BorderLayout());
        ButtonBar buttonBar = new ButtonBar();
        this.north.setBorder(BorderFactory.createTitledBorder(SQLFormatterArb.getString("OverallImportExport_IMPORT_AND_EXPORT_ALL_THE_SETTINGS")));
        this.importJB.setMnemonic(StringUtils.getMnemonicKeyCode((String)SQLFormatterArb.getString("OverallImportExport_IMPORT")));
        this.exportJB.setMnemonic(StringUtils.getMnemonicKeyCode((String)SQLFormatterArb.getString("OverallImportExport_EXPORT")));
        buttonBar.add((Component)this.importJB);
        this.importJB.addActionListener(this);
        buttonBar.add((Component)this.exportJB);
        this.exportJB.addActionListener(this);
        this.north.add((Component)buttonBar, "East");
        this.setLayout(new BorderLayout());
        this.twoPanels.setLayout(new GridLayout(0, 1));
        this.twoPanels.add(this.north);
        this.twoPanels.add((Component)((Object)this.panel));
        this.add(this.twoPanels, "North");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.importJB) {
            this.importProfiles();
        } else if (object == this.exportJB) {
            this.exportProfiles();
        }
    }

    private void exportProfiles() {
        URL uRL;
        ExportURLChooser exportURLChooser = new ExportURLChooser();
        DialogUtil.initURLChooser((URLChooser)exportURLChooser, null);
        if (this.lastImportExportURL != null) {
            exportURLChooser.setSelectedURL(this.lastImportExportURL);
        } else {
            uRL = this.getUserHomeDirectory();
            if (uRL != null) {
                exportURLChooser.setSelectedURL(uRL);
            }
        }
        exportURLChooser.clearChooseableURLFilters();
        uRL = new DefaultURLFilter(SQLFormatterArb.getString("PROFILE_FILTER_NAME"), ".xml");
        exportURLChooser.addChooseableURLFilter((URLFilter)uRL);
        exportURLChooser.addChooseableURLFilter(URLFileChooser.ALL_FILES_FILTER);
        exportURLChooser.setURLFilter((URLFilter)uRL);
        int n = exportURLChooser.showSaveDialog((Component)((Object)this), SQLFormatterArb.getString("EXPORT_PROFILE_TITLE"));
        if (n == 0) {
            URL uRL2 = exportURLChooser.getSelectedURL();
            if ("".equals(URLFileSystem.getSuffix((URL)uRL2))) {
                uRL2 = URLFileSystem.convertSuffix((URL)uRL2, (String)"", (String)".xml");
            }
            try {
                ProfileRepository.saveProfiles(uRL2);
                this.lastImportExportURL = URLFileSystem.getParent((URL)uRL2);
            }
            catch (Exception exception) {
                String string = SQLFormatterArb.format("EXPORT_ERROR_MESSAGE", URLFileSystem.getPlatformPathName((URL)uRL2), exception.toString());
                String string2 = SQLFormatterArb.getString("EXPORT_ERROR_TITLE");
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), string, string2, 0);
            }
        }
    }

    private URL getUserHomeDirectory() {
        URL uRL = URLFactory.newDirURL((String)Ide.getTrueUserHomeDirectory());
        return URLFileSystem.exists((URL)uRL) ? uRL : null;
    }

    private void importProfiles() {
        URLFileChooser uRLFileChooser = new URLFileChooser();
        uRLFileChooser.clearChooseableURLFilters();
        DefaultURLFilter defaultURLFilter = new DefaultURLFilter(SQLFormatterArb.getString("PROFILE_FILTER_NAME"), ".xml");
        uRLFileChooser.addChooseableURLFilter((URLFilter)defaultURLFilter);
        uRLFileChooser.addChooseableURLFilter(URLFileChooser.ALL_FILES_FILTER);
        uRLFileChooser.setURLFilter((URLFilter)defaultURLFilter);
        if (this.lastImportExportURL != null) {
            uRLFileChooser.setSelectedURL(this.lastImportExportURL);
        } else {
            URL uRL = this.getUserHomeDirectory();
            if (uRL != null) {
                uRLFileChooser.setSelectedURL(uRL);
            }
        }
        int n = uRLFileChooser.showOpenDialog((Component)((Object)this), SQLFormatterArb.getString("IMPORT_PROFILE_TITLE"));
        if (n == 0) {
            URL uRL = uRLFileChooser.getSelectedURL();
            CodingStyleSQLProfiles codingStyleSQLProfiles = ProfileRepository.importProfiles(uRL);
            ProfileRepository profileRepository = ProfileRepository.getProfileRepository();
            for (CodingStyleSQLProfile codingStyleSQLProfile : codingStyleSQLProfiles.getProfileMap().values()) {
                String string = codingStyleSQLProfile.getName();
                int n2 = codingStyleSQLProfile.getSourceSql();
                CodingStyleSQLProfile codingStyleSQLProfile2 = null;
                if (profileRepository.containsKey(new NameAndDatabase(string, n2))) {
                    codingStyleSQLProfile2 = profileRepository.getProfile(new NameAndDatabase(string, n2));
                }
                if (codingStyleSQLProfile2 != null && (!ModelUtil.areDifferent(codingStyleSQLProfile2, (Object)codingStyleSQLProfile) || !this.confirmImportOverwrite(CodingStylePreferencesPanel.dbToFormatter(n2) + ":" + string))) continue;
                if (codingStyleSQLProfile.getMoreNewlines()) {
                    codingStyleSQLProfile.setMoreNewlines(false);
                    codingStyleSQLProfile.setPreserveNewlines(1);
                }
                profileRepository.addProfile(codingStyleSQLProfile);
                this.loadHappened = true;
                this.lastImportExportURL = URLFileSystem.getParent((URL)uRL);
            }
        }
    }

    private boolean confirmImportOverwrite(String string) {
        String string2;
        String string3 = SQLFormatterArb.format("IMPORT_OVERWRITE_WARNING_MESSAGE", string);
        int n = JOptionPane.showConfirmDialog((Component)((Object)this), string3, string2 = SQLFormatterArb.getString("IMPORT_OVERWRITE_WARNING_TITLE"), 2);
        return n == 0;
    }

    public void onEntry(TraversableContext traversableContext) {
        SQLFormatter.getInstance();
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        this.panel.setCheck(dBConfig.getBoolean("AUTO_READONLY_FORMAT"));
        this.loadHappened = false;
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        dBConfig.putBoolean("AUTO_READONLY_FORMAT", this.panel.getCheck());
        if (this.loadHappened) {
            PropertyStorage propertyStorage = traversableContext.getPropertyStorage();
            CodingStyleSQLProfiles codingStyleSQLProfiles = CodingStyleSQLProfiles.getInstance(propertyStorage);
            codingStyleSQLProfiles.setProfileMap(CodingStyleSQLProfiles.getInstance((PropertyStorage)Preferences.getPreferences()).getProfileMap());
            if (RaptorExtensionConstants.isStandAlone()) {
                String string = CodingStyleSQLPreferences.getInstance(traversableContext.getPropertyStorage()).getActiveProfile();
                if (string == null || string.equals("")) {
                    return;
                }
                CodingStyleSQLProfile codingStyleSQLProfile = CodingStyleSQLProfiles.getInstance(traversableContext.getPropertyStorage()).getProfile(new NameAndDatabase(string));
                DBConfig.getInstance(traversableContext).putBoolean("INDENT_CACHE_USE_TAB", codingStyleSQLProfile.getUseTab());
                DBConfig.getInstance(traversableContext).putInt("INDENT_CACHE_NUMBER", codingStyleSQLProfile.getNumSpaces());
                EditorProperties editorProperties = EditorProperties.getProperties();
                editorProperties.putIntegerProperty("indent-size", codingStyleSQLProfile.getNumSpaces());
                editorProperties.putBooleanProperty("use-tabs", codingStyleSQLProfile.getUseTab());
                editorProperties.putIntegerProperty("tab-size", codingStyleSQLProfile.getNumSpaces());
            }
        }
    }

    private static class ExportURLChooser
    extends URLFileChooser {
        static final long serialVersionUID = 2008L;

        @Override
        public boolean approveSelection() {
            boolean bl = super.approveSelection();
            if (bl) {
                URL uRL = this.superGetSelectedURL();
                bl = this.checkExistingFile(uRL) && this.checkReadOnlyFile(uRL);
            }
            return bl;
        }

        private boolean checkExistingFile(URL uRL) {
            if (URLFileSystem.exists((URL)uRL)) {
                String string = SQLFormatterArb.format("EXPORT_OVERWRITE_WARNING_MESSAGE", URLFileSystem.getPlatformPathName((URL)uRL));
                String string2 = SQLFormatterArb.getString("EXPORT_OVERWRITE_WARNING_TITLE");
                int n = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), string, string2, 2);
                return n == 0;
            }
            return true;
        }

        private boolean checkReadOnlyFile(URL uRL) {
            if (URLFileSystem.isReadOnly((URL)uRL)) {
                String string = SQLFormatterArb.format("EXPORT_READ_ONLY_MESSAGE", URLFileSystem.getPlatformPathName((URL)uRL));
                String string2 = SQLFormatterArb.getString("EXPORT_ERROR_TITLE");
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), string, string2, 0);
                return false;
            }
            return true;
        }
    }
}

