/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.proformatter.treePreferences;

import java.io.IOException;
import java.net.URL;
import java.util.concurrent.CopyOnWriteArrayList;
import oracle.dbtools.proformatter.SQLDevFormatter;
import oracle.dbtools.proformatter.treePreferences.SQLPreferences;
import oracle.dbtools.proformatter.treePreferences.SQLSourcePreferences;
import oracle.dbtools.proformatter.treePreferences.style.CodingStyleSQLOptions;
import oracle.dbtools.proformatter.treePreferences.style.CodingStyleSQLOptionsListener;
import oracle.ide.marshal.xml.HashStructureIO;
import oracle.ide.xml.XMLUtil;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.marshal.TransientMarker;
import oracle.javatools.util.Copyable;

public class CodingStyleSQLProfile
extends HashStructureAdapter
implements CodingStyleSQLOptions,
Copyable,
SQLPreferences {
    public static final String DATA_KEY = "ProProfile";
    private static final String NAME = "profile.name";
    private static final String NAMESPACE_URI = XMLUtil.toNamespaceURI((String)"coding-style-SQL-profile");
    private static final String ROOT_TAG = "profile";
    private SQLSourcePreferences preferences;
    private boolean modified;
    private boolean disableEvents;
    private final CopyOnWriteArrayList<CodingStyleSQLOptionsListener> listeners = new CopyOnWriteArrayList();
    public static final String USE_TAB = "useTab";
    public static final String UPPERCASE = "uppercase";
    public static final String TARGET_SQL = "targetSql";
    public static final String FORCE_DIFFERENCE = "forceDifference";
    public static final String SUPPRESS_COMMENT = "suppressComment";
    public static final String SQL_SOURCE_ENCLOSED = "sqlSourceEnclosed";
    public static final String SQL_SOURCE_ESCAPE = "sqlSourceEscape";
    public static final String SOURCE_SQL = "sourceSql";
    public static final String SMALL_SQL = "smallSql";
    public static final String REPLACE_COMMENT = "replaceComment";
    public static final String QUOTE_CHAR = "quoteChar";
    public static final String NUM_SPACES = "numSpaces";
    public static final String NUM_COMMAS = "numCommas";
    public static final String BRACKET_SPACING = "bracketSpacing";
    public static final String BRACKET_SPACING_AND_OR_WHEN = "bracketSpacingAndOrWhen";
    public static final String COMMA_SPACING = "commaSpacing";
    public static final String OPERATOR_SPACING = "operatorSpacing";
    public static final String LINE_WIDTH = "lineWidth";
    public static final String LINE_NUM = "lineNum";
    public static final String BREAK_SELECT_BRACKET = "breakSelectBracket";
    public static final String BREAK_SCHEMA = "breakSchema";
    public static final String BREAK_KEYWORD = "breakKeyword";
    public static final String BREAK_JOIN = "breakJoin";
    public static final String BREAK_CASE_WHEN = "breakCaseWhen";
    public static final String BREAK_CASE_THEN = "breakCaseThen";
    public static final String BREAK_CASE_ELSE = "breakCaseElse";
    public static final String BREAK_CASE = "breakCase";
    public static final String BREAK_CASE_AND_OR = "breakCaseAndOr";
    public static final String BREAK_BEFORE_COMMENT = "breakBeforeComment";
    public static final String BREAK_BEFORE_CONCAT = "breakBeforeConcat";
    public static final String BREAK_BEFORE_COMMA = "breakBeforeComma";
    public static final String BREAK_BEFORE_AND = "breakBeforeAnd";
    public static final String BREAK_AFTER_CONCAT = "breakAfterConcat";
    public static final String BREAK_AFTER_COMMA = "breakAfterComma";
    public static final String BREAK_AFTER_AND = "breakAfterAnd";
    public static final String DBL_INDENT = "dblIndent";
    public static final String COLORED = "colored";
    public static final String INDENT_AND = "indentAnd";
    public static final String ALIGN_OPERATOR = "alignOperator";
    public static final String ALIGN_KEYWORD = "alignKeyword";
    public static final String ALIGN_EQUAL = "alignEqual";
    public static final String ALIGN_DECL = "alignDecl";
    public static final String ALIGN_CONCAT = "alignConcat";
    public static final String ALIGN_COMMENT = "alignComment";
    public static final String ALIGN_COMMA = "alignComma";
    public static final String ALIGN_AS = "alignAs";
    public static final String SQLSOURCE_COPIED = "sqlsourceCopied";
    public static final String MORE_NEWLINES = "moreNewlines";
    public static final String PRESERVE_NEWLINES = "preserveNewlines";
    public static final String KEY = "oracle.dbtools.proformatter.treePreferences.CodingStyleSQLProfile";

    public CodingStyleSQLProfile() {
        this(HashStructure.newInstance());
    }

    public CodingStyleSQLProfile(HashStructure hashStructure) {
        super(hashStructure);
        this.preferences = new SQLSourcePreferences(hashStructure);
        hashStructure.addStructureChangeListener((StructureChangeListener)new ChangeListener());
    }

    @Override
    public void addCodingStyleOptionsListener(CodingStyleSQLOptionsListener codingStyleSQLOptionsListener) {
        if (codingStyleSQLOptionsListener != null) {
            this.listeners.addIfAbsent(codingStyleSQLOptionsListener);
        }
    }

    @Override
    public void removeCodingStyleOptionsListener(CodingStyleSQLOptionsListener codingStyleSQLOptionsListener) {
        if (codingStyleSQLOptionsListener != null) {
            this.listeners.remove(codingStyleSQLOptionsListener);
        }
    }

    public void exportTo(URL uRL) throws IOException {
        HashStructureIO hashStructureIO = new HashStructureIO(NAMESPACE_URI, ROOT_TAG);
        hashStructureIO.save(uRL, (Object)this._hash);
    }

    public static CodingStyleSQLProfile importFrom(URL uRL) throws IOException {
        HashStructureIO hashStructureIO = new HashStructureIO(NAMESPACE_URI, ROOT_TAG);
        return new CodingStyleSQLProfile((HashStructure)hashStructureIO.load(uRL));
    }

    public boolean isModified() throws TransientMarker {
        return this.modified;
    }

    public void setModified(boolean bl) {
        this.modified = bl;
    }

    public boolean isDirty() throws TransientMarker {
        return this._hash.isDirty();
    }

    public void setDirty(boolean bl) {
        this._hash.markDirty(bl);
    }

    @Override
    public SQLSourcePreferences getSourcePreferences() {
        return this.preferences;
    }

    public String getName() {
        return this._hash.getString(NAME);
    }

    public void setName(String string) {
        this._hash.putString(NAME, string, true);
    }

    public boolean getUseTab() {
        return this.preferences.getBoolean(0);
    }

    public void setUseTab(boolean bl) {
        this.preferences.setBoolean(0, bl);
    }

    public int getUppercase() {
        return this.preferences.getInt(1);
    }

    public void setUppercase(int n) {
        this.preferences.setInt(1, n);
    }

    public int getTargetSql() {
        return this.preferences.getInt(2);
    }

    public void setTargetSql(int n) {
        this.preferences.setInt(2, n);
    }

    public boolean getForceDifference() {
        return this.preferences.getBoolean(3);
    }

    public void setForceDifference(boolean bl) {
        this.preferences.setBoolean(3, bl);
    }

    public boolean getSuppressComment() {
        return this.preferences.getBoolean(4);
    }

    public void setSuppressComment(boolean bl) {
        this.preferences.setBoolean(4, bl);
    }

    public int getSqlSourceEnclosed() {
        return this.preferences.getInt(5);
    }

    public void setSqlSourceEnclosed(int n) {
        this.preferences.setInt(5, n);
    }

    public int getSqlSourceEscape() {
        return this.preferences.getInt(49);
    }

    public void setSqlSourceEscape(int n) {
        this.preferences.setInt(49, n);
    }

    public int getSourceSql() {
        return this.preferences.getInt(6);
    }

    public void setSourceSql(int n) {
        this.preferences.setInt(6, n);
    }

    public int getSmallSql() {
        return this.preferences.getInt(7);
    }

    public void setSmallSql(int n) {
        this.preferences.setInt(7, n);
    }

    public boolean getReplaceComment() {
        return this.preferences.getBoolean(45);
    }

    public void setReplaceComment(boolean bl) {
        this.preferences.setBoolean(45, bl);
    }

    public int getQuoteChar() {
        return this.preferences.getInt(8);
    }

    public void setQuoteChar(int n) {
        this.preferences.setInt(8, n);
    }

    public int getNumSpaces() {
        return this.preferences.getInt(9);
    }

    public void setNumSpaces(int n) {
        this.preferences.setInt(9, n);
    }

    public int getNumCommas() {
        return this.preferences.getInt(10);
    }

    public void setNumCommas(int n) {
        this.preferences.setInt(10, n);
    }

    public int getBracketSpacing() {
        return this.preferences.getInt(11);
    }

    public void setBracketSpacing(int n) {
        this.preferences.setInt(11, n);
    }

    public boolean getBracketSpacingAndOrWhen() {
        return this.preferences.getBoolean(46);
    }

    public void setBracketSpacingAndOrWhen(boolean bl) {
        this.preferences.setBoolean(46, bl);
    }

    public int getCommaSpacing() {
        return this.preferences.getInt(12);
    }

    public void setCommaSpacing(int n) {
        this.preferences.setInt(12, n);
    }

    public int getOperatorSpacing() {
        return this.preferences.getInt(13);
    }

    public void setOperatorSpacing(int n) {
        this.preferences.setInt(13, n);
    }

    public int getLineWidth() {
        return this.preferences.getInt(14);
    }

    public void setLineWidth(int n) {
        this.preferences.setInt(14, n);
    }

    public int getLineNum() {
        return this.preferences.getInt(15);
    }

    public void setLineNum(int n) {
        this.preferences.setInt(15, n);
    }

    public boolean getBreakSelectBracket() {
        return this.preferences.getBoolean(16);
    }

    public void setBreakSelectBracket(boolean bl) {
        this.preferences.setBoolean(16, bl);
    }

    public int getBreakSchema() {
        return this.preferences.getInt(17);
    }

    public void setBreakSchema(int n) {
        this.preferences.setInt(17, n);
    }

    public boolean getBreakKeyword() {
        return this.preferences.getBoolean(18);
    }

    public void setBreakKeyword(boolean bl) {
        this.preferences.setBoolean(18, bl);
    }

    public boolean getBreakJoin() {
        return this.preferences.getBoolean(19);
    }

    public void setBreakJoin(boolean bl) {
        this.preferences.setBoolean(19, bl);
    }

    public boolean getBreakCaseWhen() {
        return this.preferences.getBoolean(20);
    }

    public void setBreakCaseWhen(boolean bl) {
        this.preferences.setBoolean(20, bl);
    }

    public boolean getBreakCaseThen() {
        return this.preferences.getBoolean(21);
    }

    public void setBreakCaseThen(boolean bl) {
        this.preferences.setBoolean(21, bl);
    }

    public boolean getBreakCaseElse() {
        return this.preferences.getBoolean(22);
    }

    public void setBreakCaseElse(boolean bl) {
        this.preferences.setBoolean(22, bl);
    }

    public boolean getBreakCase() {
        return this.preferences.getBoolean(23);
    }

    public void setBreakCase(boolean bl) {
        this.preferences.setBoolean(23, bl);
    }

    public boolean getBreakCaseAndOr() {
        return this.preferences.getBoolean(24);
    }

    public void setBreakCaseAndOr(boolean bl) {
        this.preferences.setBoolean(24, bl);
    }

    public boolean getBreakBeforeComment() {
        return this.preferences.getBoolean(25);
    }

    public void setBreakBeforeComment(boolean bl) {
        this.preferences.setBoolean(25, bl);
    }

    public boolean getBreakBeforeConcat() {
        return this.preferences.getBoolean(26);
    }

    public void setBreakBeforeConcat(boolean bl) {
        this.preferences.setBoolean(26, bl);
    }

    public boolean getBreakBeforeComma() {
        return this.preferences.getBoolean(27);
    }

    public void setBreakBeforeComma(boolean bl) {
        this.preferences.setBoolean(27, bl);
    }

    public boolean getBreakBeforeAnd() {
        return this.preferences.getBoolean(28);
    }

    public void setBreakBeforeAnd(boolean bl) {
        this.preferences.setBoolean(28, bl);
    }

    public boolean getBreakAfterConcat() {
        return this.preferences.getBoolean(29);
    }

    public void setBreakAfterConcat(boolean bl) {
        this.preferences.setBoolean(29, bl);
    }

    public boolean getBreakAfterComma() {
        return this.preferences.getBoolean(30);
    }

    public void setBreakAfterComma(boolean bl) {
        this.preferences.setBoolean(30, bl);
    }

    public boolean getBreakAfterAnd() {
        return this.preferences.getBoolean(31);
    }

    public void setBreakAfterAnd(boolean bl) {
        this.preferences.setBoolean(31, bl);
    }

    public boolean getDblIndent() {
        return this.preferences.getBoolean(32);
    }

    public void setDblIndent(boolean bl) {
        this.preferences.setBoolean(32, bl);
    }

    public boolean getColored() {
        return this.preferences.getBoolean(33);
    }

    public void setColored(boolean bl) {
        this.preferences.setBoolean(33, bl);
    }

    public boolean getIndentAnd() {
        return this.preferences.getBoolean(34);
    }

    public void setIndentAnd(boolean bl) {
        this.preferences.setBoolean(34, bl);
    }

    public boolean getAlignOperator() {
        return this.preferences.getBoolean(35);
    }

    public void setAlignOperator(boolean bl) {
        this.preferences.setBoolean(35, bl);
    }

    public boolean getAlignKeyword() {
        return this.preferences.getBoolean(36);
    }

    public void setAlignKeyword(boolean bl) {
        this.preferences.setBoolean(36, bl);
    }

    public boolean getAlignEqual() {
        return this.preferences.getBoolean(37);
    }

    public void setAlignEqual(boolean bl) {
        this.preferences.setBoolean(37, bl);
    }

    public boolean getAlignDecl() {
        return this.preferences.getBoolean(38);
    }

    public void setAlignDecl(boolean bl) {
        this.preferences.setBoolean(38, bl);
    }

    public boolean getAlignConcat() {
        return this.preferences.getBoolean(39);
    }

    public void setAlignConcat(boolean bl) {
        this.preferences.setBoolean(39, bl);
    }

    public boolean getAlignComment() {
        return this.preferences.getBoolean(40);
    }

    public void setAlignComment(boolean bl) {
        this.preferences.setBoolean(40, bl);
    }

    public boolean getAlignComma() {
        return this.preferences.getBoolean(41);
    }

    public void setAlignComma(boolean bl) {
        this.preferences.setBoolean(41, bl);
    }

    public boolean getAlignAs() {
        return this.preferences.getBoolean(42);
    }

    public void setAlignAs(boolean bl) {
        this.preferences.setBoolean(42, bl);
    }

    public boolean getSqlsourceCopied() {
        return this.preferences.getBoolean(43);
    }

    public void setSqlsourceCopied(boolean bl) {
        this.preferences.setBoolean(43, bl);
    }

    public boolean getMoreNewlines() {
        return this.preferences.getBoolean(48);
    }

    public void setMoreNewlines(boolean bl) {
        this.preferences.setBoolean(48, bl);
    }

    public int getPreserveNewlines() {
        return this.preferences.getInt(50);
    }

    public void setPreserveNewlines(int n) {
        this.preferences.setInt(50, n);
    }

    @Override
    public byte getMemberOrder(int n) {
        return this.preferences.getMemberOrder(n);
    }

    @Override
    public void setMemberOrder(int n, byte by) {
        this.preferences.setMemberOrder(n, by);
    }

    public HashStructure getMemberOrderHashStructure() {
        return this.preferences.getMemberOrderHashStructure();
    }

    public void setMemberOrderHashStructure(HashStructure hashStructure) {
        String string = PREFERENCES_keys[47];
        if (hashStructure != null) {
            hashStructure.copyTo(this._hash.getOrCreateHashStructure(string));
        } else {
            this._hash.remove(string);
        }
    }

    @Override
    public String format(String string) {
        return new SQLDevFormatter().format(this, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object copyTo(Object object) {
        if (object == null) {
            object = new CodingStyleSQLProfile();
        }
        CodingStyleSQLProfile codingStyleSQLProfile = (CodingStyleSQLProfile)object;
        try {
            codingStyleSQLProfile.disableEvents();
            Object object2 = super.copyTo(object);
            return object2;
        }
        finally {
            codingStyleSQLProfile.enableEvents();
            codingStyleSQLProfile.fireOptionsChanged();
        }
    }

    private void disableEvents() {
        this.disableEvents = true;
    }

    private void enableEvents() {
        this.disableEvents = false;
    }

    private void fireOptionsChanged() {
        Object[] objectArray = this.listeners.toArray();
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            CodingStyleSQLOptionsListener codingStyleSQLOptionsListener = (CodingStyleSQLOptionsListener)objectArray[i];
            codingStyleSQLOptionsListener.optionsChanged(this);
        }
    }

    private class ChangeListener
    extends StructureChangeListener {
        private ChangeListener() {
        }

        public void structureValuesChanged(StructureChangeEvent structureChangeEvent) {
            if (!CodingStyleSQLProfile.this.disableEvents) {
                CodingStyleSQLProfile.this.fireOptionsChanged();
            }
        }
    }
}

