/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.time;

import ilog.views.util.time.IlvCalendarUtil;
import java.util.Calendar;

public interface IlvTimeIncrementPolicy {
    public void floorTime(Calendar var1);

    public void incrementTime(Calendar var1);

    public void decrementTime(Calendar var1);

    public static class Year
    implements IlvTimeIncrementPolicy {
        private int a = 1;

        public int getYearStep() {
            return this.a;
        }

        public void setYearStep(int n2) {
            if (n2 <= 0) {
                throw new IllegalArgumentException("Step must be > 0");
            }
            this.a = n2;
        }

        public void floorTime(Calendar calendar) {
            int n2 = this.a * (calendar.get(1) / this.a);
            IlvCalendarUtil.yearFloor(calendar);
            calendar.set(1, n2);
        }

        public void incrementTime(Calendar calendar) {
            calendar.add(1, this.a);
        }

        public void decrementTime(Calendar calendar) {
            calendar.add(1, -this.a);
        }
    }

    public static class Month
    implements IlvTimeIncrementPolicy {
        private int a = 1;

        public int getMonthStep() {
            return this.a;
        }

        public void setMonthStep(int n2) {
            if (n2 <= 0) {
                throw new IllegalArgumentException("Step must be > 0");
            }
            this.a = n2;
        }

        public void floorTime(Calendar calendar) {
            int n2 = this.a * (calendar.get(2) / this.a);
            IlvCalendarUtil.monthFloor(calendar);
            calendar.set(2, n2);
        }

        public void incrementTime(Calendar calendar) {
            calendar.add(2, this.a);
        }

        public void decrementTime(Calendar calendar) {
            calendar.add(2, -this.a);
        }
    }

    public static class Week
    implements IlvTimeIncrementPolicy {
        private int a = 1;

        public int getWeekStep() {
            return this.a;
        }

        public void setWeekStep(int n2) {
            if (n2 <= 0) {
                throw new IllegalArgumentException("Step must be > 0");
            }
            this.a = n2;
        }

        public void floorTime(Calendar calendar) {
            int n2 = this.a * (calendar.get(3) / this.a);
            IlvCalendarUtil.weekFloor(calendar);
            calendar.set(3, n2);
        }

        public void incrementTime(Calendar calendar) {
            calendar.add(3, this.a);
        }

        public void decrementTime(Calendar calendar) {
            calendar.add(3, -this.a);
        }
    }

    public static class Day
    implements IlvTimeIncrementPolicy {
        private int a = 1;

        public int getDayStep() {
            return this.a;
        }

        public void setDayStep(int n2) {
            if (n2 <= 0) {
                throw new IllegalArgumentException("Step must be > 0");
            }
            this.a = n2;
        }

        public void floorTime(Calendar calendar) {
            int n2 = this.a * (calendar.get(6) / this.a);
            IlvCalendarUtil.dayFloor(calendar);
            calendar.set(6, n2);
        }

        public void incrementTime(Calendar calendar) {
            calendar.add(6, this.a);
        }

        public void decrementTime(Calendar calendar) {
            calendar.add(6, -this.a);
        }
    }

    public static class HalfDay
    implements IlvTimeIncrementPolicy {
        public void floorTime(Calendar calendar) {
            IlvCalendarUtil.halfDayFloor(calendar);
        }

        public void incrementTime(Calendar calendar) {
            calendar.add(9, 1);
        }

        public void decrementTime(Calendar calendar) {
            calendar.add(9, -1);
        }
    }

    public static class Hour
    implements IlvTimeIncrementPolicy {
        private int a = 1;

        public int getHourStep() {
            return this.a;
        }

        public void setHourStep(int n2) {
            if (n2 <= 0 || n2 > 24 || 24 % n2 != 0) {
                throw new IllegalArgumentException("Step must be a positive divisor of 24");
            }
            this.a = n2;
        }

        public void floorTime(Calendar calendar) {
            int n2 = this.a * (calendar.get(11) / this.a);
            IlvCalendarUtil.hourFloor(calendar);
            calendar.set(11, n2);
        }

        public void incrementTime(Calendar calendar) {
            int n2 = (calendar.get(11) / this.a + 1) * this.a;
            calendar.set(11, n2);
        }

        public void decrementTime(Calendar calendar) {
            if (this.a == 1 && calendar.getTimeZone().inDaylightTime(calendar.getTime())) {
                calendar.add(11, -this.a);
            } else {
                int n2 = (calendar.get(11) / this.a - 1) * this.a;
                calendar.set(11, n2);
            }
        }
    }

    public static class Minute
    implements IlvTimeIncrementPolicy {
        private int a = 1;

        public int getMinuteStep() {
            return this.a;
        }

        public void setMinuteStep(int n2) {
            if (n2 <= 0 || n2 > 60 || 60 % n2 != 0) {
                throw new IllegalArgumentException("Step must be a positive divisor of 60");
            }
            this.a = n2;
        }

        public void floorTime(Calendar calendar) {
            int n2 = this.a * (calendar.get(12) / this.a);
            IlvCalendarUtil.minuteFloor(calendar);
            calendar.set(12, n2);
        }

        public void incrementTime(Calendar calendar) {
            calendar.add(12, this.a);
        }

        public void decrementTime(Calendar calendar) {
            calendar.add(12, -this.a);
        }
    }

    public static class Second
    implements IlvTimeIncrementPolicy {
        private int a = 1;

        public int getSecondStep() {
            return this.a;
        }

        public void setSecondStep(int n2) {
            if (n2 <= 0 || n2 > 60 || 60 % n2 != 0) {
                throw new IllegalArgumentException("Step must be a positive divisor of 60");
            }
            this.a = n2;
        }

        public void floorTime(Calendar calendar) {
            int n2 = this.a * (calendar.get(13) / this.a);
            IlvCalendarUtil.secondFloor(calendar);
            calendar.set(13, n2);
        }

        public void incrementTime(Calendar calendar) {
            calendar.add(13, this.a);
        }

        public void decrementTime(Calendar calendar) {
            calendar.add(13, -this.a);
        }
    }
}

