/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.servlet.tiling;

import ilog.views.util.servlet.tiling.IlvDefaultFileTileCache;
import ilog.views.util.servlet.tiling.IlvDefaultFileTileReader;
import ilog.views.util.servlet.tiling.IlvDefaultFileTileWriter;
import ilog.views.util.servlet.tiling.IlvFileTileURLFactory;
import ilog.views.util.servlet.tiling.IlvTileManager;
import ilog.views.util.servlet.tiling.IlvTileURLFactory;
import ilog.views.util.servlet.tiling.IlvTileUtil;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

public class IlvFileTileManager
implements IlvTileManager {
    public static int PNG_FORMAT = 1;
    public static int JPEG_FORMAT = 0;
    private int a = JPEG_FORMAT;
    private IlvTileURLFactory b;
    private IlvDefaultFileTileWriter c;
    private IlvDefaultFileTileReader d;
    private IlvDefaultFileTileCache e;

    public IlvFileTileManager() {
        this(null, 0xA00000L, 0x100000L);
    }

    public void setBase(File file) {
        if (file != null) {
            IlvFileTileURLFactory ilvFileTileURLFactory = new IlvFileTileURLFactory(file);
            ilvFileTileURLFactory.getBaseDir().mkdirs();
            this.setUrlFactory(ilvFileTileURLFactory);
            this.b(file);
        }
    }

    public IlvFileTileManager(File file, long l2, long l3) {
        this.setWriter(new IlvDefaultFileTileWriter());
        this.setReader(new IlvDefaultFileTileReader());
        if (file != null) {
            IlvFileTileURLFactory ilvFileTileURLFactory = new IlvFileTileURLFactory(file);
            ilvFileTileURLFactory.getBaseDir().mkdirs();
            this.setUrlFactory(ilvFileTileURLFactory);
        }
        this.setCache(new IlvDefaultFileTileCache(l2, l3));
        if (file != null) {
            this.b(file);
        }
    }

    public void setImageFormat(int n2) {
        this.a = n2 >= 0 && n2 <= 1 ? n2 : JPEG_FORMAT;
        if (this.getUrlFactory() instanceof IlvFileTileURLFactory) {
            ((IlvFileTileURLFactory)this.getUrlFactory()).setImageFormat(n2);
        }
    }

    public int getImageFormat() {
        return this.a;
    }

    public BufferedImage getImage(Object object) {
        IlvDefaultFileTileReader ilvDefaultFileTileReader = this.getReader();
        if (ilvDefaultFileTileReader == null) {
            return null;
        }
        URL uRL = this.a(object);
        if (uRL != null) {
            String string;
            IlvDefaultFileTileCache ilvDefaultFileTileCache;
            BufferedImage bufferedImage = ilvDefaultFileTileReader.getImage(uRL);
            if (bufferedImage != null && (ilvDefaultFileTileCache = this.getCache()) != null && (string = uRL.getPath()) != null) {
                ilvDefaultFileTileCache.objectAccessed(new File(string));
            }
            return bufferedImage;
        }
        return null;
    }

    public Object putImage(Object object, BufferedImage bufferedImage) {
        IlvDefaultFileTileWriter ilvDefaultFileTileWriter = this.getWriter();
        if (ilvDefaultFileTileWriter == null) {
            return null;
        }
        URL uRL = this.a(object);
        if (uRL != null) {
            Object object2 = ilvDefaultFileTileWriter.write(uRL, bufferedImage);
            IlvDefaultFileTileCache ilvDefaultFileTileCache = this.getCache();
            if (ilvDefaultFileTileCache != null) {
                ilvDefaultFileTileCache.objectAdded(object2);
            }
        }
        return null;
    }

    URL a(Object object) {
        URL uRL = null;
        IlvTileURLFactory ilvTileURLFactory = this.getUrlFactory();
        if (ilvTileURLFactory != null) {
            uRL = ilvTileURLFactory.makeURL(object);
        }
        return uRL;
    }

    void a(File file) {
        block8: {
            if (file.isFile()) {
                IlvTileURLFactory ilvTileURLFactory = this.getUrlFactory();
                if (ilvTileURLFactory != null) {
                    try {
                        URL uRL = file.toURL();
                        if (ilvTileURLFactory.isURL(uRL)) {
                            this.getCache().objectAdded(file);
                            IlvTileUtil.trace("Added to cache : " + IlvTileUtil.print(file));
                            break block8;
                        }
                        IlvTileUtil.trace("Does not match : " + IlvTileUtil.print(file));
                    }
                    catch (MalformedURLException malformedURLException) {
                        malformedURLException.printStackTrace();
                    }
                }
            } else if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                for (int i2 = 0; i2 < fileArray.length; ++i2) {
                    this.a(fileArray[i2]);
                }
            }
        }
    }

    void b(File file) {
        IlvTileUtil.trace("Filling cache from : " + file);
        if (this.getCache() == null) {
            return;
        }
        if (!file.exists()) {
            return;
        }
        if (!file.isDirectory()) {
            return;
        }
        this.a(file);
        this.getCache().stats();
    }

    public IlvTileURLFactory getUrlFactory() {
        return this.b;
    }

    public void setUrlFactory(IlvTileURLFactory ilvTileURLFactory) {
        this.b = ilvTileURLFactory;
        if (this.getUrlFactory() instanceof IlvFileTileURLFactory) {
            ((IlvFileTileURLFactory)this.getUrlFactory()).setImageFormat(this.getImageFormat());
        }
    }

    public IlvDefaultFileTileReader getReader() {
        return this.d;
    }

    public void setReader(IlvDefaultFileTileReader ilvDefaultFileTileReader) {
        this.d = ilvDefaultFileTileReader;
    }

    public IlvDefaultFileTileWriter getWriter() {
        return this.c;
    }

    public void setWriter(IlvDefaultFileTileWriter ilvDefaultFileTileWriter) {
        this.c = ilvDefaultFileTileWriter;
    }

    public IlvDefaultFileTileCache getCache() {
        return this.e;
    }

    public void setCache(IlvDefaultFileTileCache ilvDefaultFileTileCache) {
        this.e = ilvDefaultFileTileCache;
    }
}

