/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class IlvStreamTokenizer {
    public double nval;
    public String sval;
    public static final int TT_EOF = -1;
    public static final int TT_EOL = 10;
    public static final int TT_NUMBER = -2;
    public static final int TT_WORD = -3;
    protected static final int TT_UNKNOWN = -4;
    public int ttype = -4;
    protected byte[] tokenTypes = new byte[256];
    protected static final byte TOKEN_COMMENT = 1;
    protected static final byte TOKEN_QUOTE = 2;
    protected static final byte TOKEN_WHITE = 4;
    protected static final byte TOKEN_WORD = 8;
    protected static final byte TOKEN_DIGIT = 16;
    protected int lineNumber = 1;
    protected boolean forceLowercase;
    protected boolean isEOLSignificant;
    protected boolean slashStarComments;
    protected boolean slashSlashComments;
    protected boolean pushBackToken;
    protected boolean lastCr;
    protected int nextChar;
    protected InputStream inStream;
    protected Reader inReader;
    protected int peekChar = -2;
    protected StringBuffer quoteString;

    public IlvStreamTokenizer() {
        this.wordChars(65, 90);
        this.wordChars(97, 122);
        this.wordChars(160, 255);
        this.whitespaceChars(0, 32);
        this.commentChar(47);
        this.quoteChar(34);
        this.quoteChar(39);
        this.parseNumbers();
    }

    @Deprecated
    public IlvStreamTokenizer(InputStream inputStream) {
        this();
        if (inputStream == null) {
            throw new NullPointerException();
        }
        this.inStream = inputStream;
    }

    public IlvStreamTokenizer(Reader reader) {
        this();
        if (reader == null) {
            throw new NullPointerException();
        }
        this.inReader = reader;
    }

    public void commentChar(int n2) {
        if (0 <= n2 && n2 < this.tokenTypes.length) {
            this.tokenTypes[n2] = 1;
        }
    }

    public void eolIsSignificant(boolean bl) {
        this.isEOLSignificant = bl;
    }

    public int lineno() {
        return this.lineNumber;
    }

    public void lowerCaseMode(boolean bl) {
        this.forceLowercase = bl;
    }

    public int nextToken() throws IOException {
        int n2;
        int n3;
        if (this.pushBackToken) {
            this.pushBackToken = false;
            if (this.ttype != -4) {
                return this.ttype;
            }
        }
        this.sval = null;
        int n4 = n3 = this.peekChar == -2 ? this.read() : this.peekChar;
        if (this.lastCr && n3 == 10) {
            this.lastCr = false;
            n3 = this.read();
        }
        if (n3 == -1) {
            this.ttype = -1;
            return -1;
        }
        int n5 = n2 = n3 > 255 ? 8 : this.tokenTypes[n3];
        while ((n2 & 4) != 0) {
            if (n3 == 13) {
                ++this.lineNumber;
                if (this.isEOLSignificant) {
                    this.lastCr = true;
                    this.peekChar = -2;
                    this.ttype = 10;
                    return 10;
                }
                n3 = this.read();
                if (n3 == 10) {
                    n3 = this.read();
                }
            } else if (n3 == 10) {
                ++this.lineNumber;
                if (this.isEOLSignificant) {
                    this.peekChar = -2;
                    this.ttype = 10;
                    return 10;
                }
                n3 = this.read();
            } else {
                n3 = this.read();
            }
            if (n3 == -1) {
                this.ttype = -1;
                return -1;
            }
            n2 = n3 > 255 ? 8 : this.tokenTypes[n3];
        }
        if ((n2 & 0x10) != 0) {
            boolean bl;
            StringBuilder stringBuilder = new StringBuilder(20);
            boolean bl2 = false;
            boolean bl3 = bl = n3 == 45;
            do {
                if (n3 == 46) {
                    bl2 = true;
                }
                stringBuilder.append((char)n3);
            } while ((n3 = this.read()) >= 48 && n3 <= 57 || !bl2 && n3 == 46);
            this.peekChar = n3;
            if (bl && stringBuilder.length() == 1) {
                this.ttype = 45;
                return 45;
            }
            try {
                this.nval = Double.valueOf(stringBuilder.toString());
            }
            catch (NumberFormatException numberFormatException) {
                this.nval = 0.0;
            }
            this.ttype = -2;
            return -2;
        }
        if ((n2 & 8) != 0) {
            StringBuffer stringBuffer = new StringBuffer(20);
            do {
                stringBuffer.append((char)n3);
            } while ((n3 = this.read()) != -1 && (n3 >= 256 || (this.tokenTypes[n3] & 0x18) != 0));
            this.peekChar = n3;
            this.sval = this.forceLowercase ? stringBuffer.toString().toLowerCase() : stringBuffer.toString();
            this.ttype = -3;
            return -3;
        }
        if (n2 == 2) {
            int n6 = n3;
            this.quoteString = new StringBuffer();
            int n7 = this.read();
            while (n7 >= 0 && n7 != n6 && n7 != 13 && n7 != 10) {
                boolean bl = true;
                this.getNextChar();
                if (n7 == 92) {
                    n7 = this.handleBackslashInString();
                }
                if (!bl) continue;
                this.quoteString.append((char)n7);
                n7 = this.nextChar;
            }
            if (n7 == n6) {
                n7 = this.read();
            }
            this.peekChar = n7;
            this.ttype = n6;
            this.sval = this.quoteString.toString();
            return this.ttype;
        }
        if (n3 == 47 && (this.slashSlashComments || this.slashStarComments)) {
            n3 = this.read();
            if (n3 == 42 && this.slashStarComments) {
                int n8 = this.read();
                while (true) {
                    n3 = n8;
                    n8 = this.read();
                    if (n3 == -1) {
                        this.peekChar = -1;
                        this.ttype = -1;
                        return -1;
                    }
                    if (n3 == 13) {
                        if (n8 == 10) {
                            n8 = this.read();
                        }
                        ++this.lineNumber;
                        continue;
                    }
                    if (n3 == 10) {
                        ++this.lineNumber;
                        continue;
                    }
                    if (n3 == 42 && n8 == 47) break;
                }
                this.peekChar = this.read();
                return this.nextToken();
            }
            if (n3 == 47 && this.slashSlashComments) {
                while ((n3 = this.read()) >= 0 && n3 != 13 && n3 != 10) {
                }
                this.peekChar = n3;
                return this.nextToken();
            }
            if (n2 != 1) {
                this.peekChar = n3;
                this.ttype = 47;
                return 47;
            }
        }
        if (n2 == 1) {
            while ((n3 = this.read()) >= 0 && n3 != 13 && n3 != 10) {
            }
            this.peekChar = n3;
            return this.nextToken();
        }
        this.peekChar = this.read();
        this.ttype = n3;
        return this.ttype;
    }

    protected final int getNextChar() {
        try {
            this.nextChar = this.inStream == null ? (int)((char)this.inReader.read()) : this.inStream.read();
            if (this.nextChar == -1) {
                this.nextChar = -1;
            }
        }
        catch (IOException iOException) {
            this.nextChar = -1;
        }
        return this.nextChar;
    }

    protected char handleBackslashInString() {
        char c2;
        boolean bl = true;
        if (this.nextChar <= 55 && this.nextChar >= 48) {
            int n2 = this.nextChar - 48;
            this.nextChar = this.getNextChar();
            if (this.nextChar > 55 || this.nextChar < 48) {
                bl = false;
            } else {
                n2 = n2 * 8 + (this.nextChar - 48);
                this.nextChar = this.getNextChar();
                if (n2 > 31 || this.nextChar > 55 || this.nextChar < 48) {
                    bl = false;
                } else {
                    n2 = n2 * 8 + (this.nextChar - 48);
                }
            }
            if (!bl) {
                return (char)n2;
            }
            c2 = (char)n2;
        } else {
            switch (this.nextChar) {
                case 97: {
                    c2 = '\u0007';
                    break;
                }
                case 98: {
                    c2 = '\b';
                    break;
                }
                case 102: {
                    c2 = '\f';
                    break;
                }
                case 110: {
                    c2 = '\n';
                    break;
                }
                case 114: {
                    c2 = '\r';
                    break;
                }
                case 116: {
                    c2 = '\t';
                    break;
                }
                case 118: {
                    c2 = '\u000b';
                    break;
                }
                default: {
                    c2 = (char)this.nextChar;
                }
            }
        }
        this.getNextChar();
        return c2;
    }

    public void ordinaryChar(int n2) {
        if (0 <= n2 && n2 < this.tokenTypes.length) {
            this.tokenTypes[n2] = 0;
        }
    }

    public void ordinaryChars(int n2, int n3) {
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 > this.tokenTypes.length) {
            n3 = this.tokenTypes.length - 1;
        }
        for (int i2 = n2; i2 <= n3; ++i2) {
            this.tokenTypes[i2] = 0;
        }
    }

    public void parseNumbers() {
        int n2 = 48;
        while (n2 <= 57) {
            int n3 = n2++;
            this.tokenTypes[n3] = (byte)(this.tokenTypes[n3] | 0x10);
        }
        this.tokenTypes[46] = (byte)(this.tokenTypes[46] | 0x10);
        this.tokenTypes[45] = (byte)(this.tokenTypes[45] | 0x10);
    }

    public void pushBack() {
        this.pushBackToken = true;
    }

    public void quoteChar(int n2) {
        if (0 <= n2 && n2 < this.tokenTypes.length) {
            this.tokenTypes[n2] = 2;
        }
    }

    protected int read() throws IOException {
        if (this.inStream == null) {
            return this.inReader.read();
        }
        return this.inStream.read();
    }

    public void resetSyntax() {
        for (int i2 = 0; i2 < 256; ++i2) {
            this.tokenTypes[i2] = 0;
        }
    }

    public void slashSlashComments(boolean bl) {
        this.slashSlashComments = bl;
    }

    public void slashStarComments(boolean bl) {
        this.slashStarComments = bl;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Token[");
        switch (this.ttype) {
            case -1: {
                stringBuilder.append("EOF");
                break;
            }
            case 10: {
                stringBuilder.append("EOL");
                break;
            }
            case -2: {
                stringBuilder.append("n=");
                stringBuilder.append(this.nval);
                break;
            }
            case -3: {
                stringBuilder.append(this.sval);
                break;
            }
            default: {
                if (this.ttype == -4 || this.tokenTypes[this.ttype] == 2) {
                    stringBuilder.append(this.sval);
                    break;
                }
                stringBuilder.append('\'');
                stringBuilder.append((char)this.ttype);
                stringBuilder.append('\'');
            }
        }
        stringBuilder.append("], line ");
        stringBuilder.append(this.lineNumber);
        return stringBuilder.toString();
    }

    public void whitespaceChars(int n2, int n3) {
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 > this.tokenTypes.length) {
            n3 = this.tokenTypes.length - 1;
        }
        for (int i2 = n2; i2 <= n3; ++i2) {
            this.tokenTypes[i2] = 4;
        }
    }

    public void wordChars(int n2, int n3) {
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 > this.tokenTypes.length) {
            n3 = this.tokenTypes.length - 1;
        }
        int n4 = n2;
        while (n4 <= n3) {
            int n5 = n4++;
            this.tokenTypes[n5] = (byte)(this.tokenTypes[n5] | 8);
        }
    }
}

