/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.collections;

import ilog.views.util.collections.internal.IlvArrayIterator;
import ilog.views.util.collections.internal.IlvBalancedBinaryTree;
import ilog.views.util.internal.IlvInternalError;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IlvHashTreeList<E>
extends AbstractList<E>
implements Cloneable,
RandomAccess {
    private transient IlvBalancedBinaryTree a = new IlvBalancedBinaryTree();
    private transient HashMap<E, Object> b = new HashMap();
    private Comparator<Entry> c = new Comparator<Entry>(){

        @Override
        public int compare(Entry entry, Entry entry2) {
            int n2;
            int n3 = IlvHashTreeList.this.a.getIndexOfEntry(entry);
            return n3 > (n2 = IlvHashTreeList.this.a.getIndexOfEntry(entry2)) ? 1 : (n3 < n2 ? -1 : 0);
        }
    };

    public IlvHashTreeList() {
    }

    public IlvHashTreeList(Collection<? extends E> collection) {
        this.a(collection.size(), collection.iterator());
    }

    public IlvHashTreeList(E[] EArray) {
        this.a(EArray.length, new IlvArrayIterator(EArray));
    }

    private void a(E e2, Entry<E> entry) {
        Object object = this.b.get(entry.a);
        if (object == null) {
            this.b.put(e2, entry);
        } else if (object instanceof TreeSet) {
            TreeSet treeSet = (TreeSet)object;
            treeSet.add(entry);
        } else if (object instanceof Entry) {
            TreeSet<Entry> treeSet = new TreeSet<Entry>(this.c);
            treeSet.add((Entry)object);
            treeSet.add(entry);
            this.b.put(e2, treeSet);
        } else {
            throw new IlvInternalError("IlvHashTreeList inconsistency");
        }
    }

    private void b(E e2, Entry<E> entry) {
        Object object = this.b.get(entry.a);
        if (object instanceof TreeSet) {
            TreeSet treeSet = (TreeSet)object;
            treeSet.remove(entry);
            if (treeSet.size() == 1) {
                this.b.put(entry.a, treeSet.first());
            }
        } else if (object == entry) {
            this.b.remove(entry.a);
        } else {
            throw new IlvInternalError("IlvHashTreeList inconsistency - did the hash code of an element change?");
        }
    }

    private Entry<E> a(Object object) {
        Object object2 = this.b.get(object);
        if (object2 instanceof TreeSet) {
            object2 = ((TreeSet)object2).first();
        }
        return (Entry)object2;
    }

    private Entry<E> b(Object object) {
        Object object2 = this.b.get(object);
        if (object2 instanceof TreeSet) {
            object2 = ((TreeSet)object2).last();
        }
        return (Entry)object2;
    }

    private Entry<E> a(int n2) {
        return (Entry)this.a.getEntryAt(n2);
    }

    private Entry<E> a() {
        int n2 = this.a.getSize();
        if (n2 > 0) {
            return (Entry)this.a.getEntryAt(0);
        }
        return null;
    }

    private Entry<E> b() {
        int n2 = this.a.getSize();
        if (n2 > 0) {
            return (Entry)this.a.getEntryAt(n2 - 1);
        }
        return null;
    }

    public E getFirstElement() {
        Entry<E> entry = this.a();
        if (entry == null) {
            throw new NoSuchElementException();
        }
        return (E)entry.a;
    }

    public E getLastElement() {
        Entry<E> entry = this.b();
        if (entry == null) {
            throw new NoSuchElementException();
        }
        return (E)entry.a;
    }

    private Entry<E> a(Entry<E> entry) {
        int n2;
        IlvBalancedBinaryTree.Node node = entry.getHoldingNode();
        int n3 = node.getEntriesCount();
        for (n2 = n3 - 1; n2 >= 0 && node.getEntry(n2) != entry; --n2) {
        }
        if (n2 < 0) {
            throw new IllegalStateException();
        }
        if (n2 + 1 < n3) {
            return (Entry)node.getEntry(n2 + 1);
        }
        if ((node = this.a.getSuccessor(node)) != null) {
            return (Entry)node.getEntry(0);
        }
        return null;
    }

    private Entry<E> b(Entry<E> entry) {
        int n2;
        IlvBalancedBinaryTree.Node node = entry.getHoldingNode();
        int n3 = node.getEntriesCount();
        for (n2 = n3 - 1; n2 >= 0 && node.getEntry(n2) != entry; --n2) {
        }
        if (n2 < 0) {
            throw new IllegalStateException();
        }
        if (n2 > 0) {
            return (Entry)node.getEntry(n2 - 1);
        }
        if ((node = this.a.getPredecessor(node)) != null) {
            return (Entry)node.getEntry(node.getEntriesCount() - 1);
        }
        return null;
    }

    private void c(Entry<E> entry) {
        this.a.deleteEntry(entry);
        ++this.modCount;
        this.b(entry.a, entry);
    }

    @Override
    public int size() {
        return this.a.getSize();
    }

    @Override
    public boolean contains(Object object) {
        return this.b.get(object) != null;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            private int a;
            private Entry<E> b;
            private Entry<E> c;
            {
                this.a = IlvHashTreeList.this.modCount;
                this.b = null;
                this.c = IlvHashTreeList.this.a();
            }

            @Override
            public boolean hasNext() {
                return this.c != null;
            }

            @Override
            public E next() {
                if (this.c == null) {
                    throw new NoSuchElementException();
                }
                if (IlvHashTreeList.this.modCount != this.a) {
                    throw new ConcurrentModificationException();
                }
                this.b = this.c;
                this.c = IlvHashTreeList.this.a(this.c);
                return this.b.a;
            }

            @Override
            public void remove() {
                if (this.b == null) {
                    throw new IllegalStateException();
                }
                if (IlvHashTreeList.this.modCount != this.a) {
                    throw new ConcurrentModificationException();
                }
                IlvHashTreeList.this.c(this.b);
                ++this.a;
                this.b = null;
            }
        };
    }

    @Override
    public boolean remove(Object object) {
        Entry<E> entry = this.a(object);
        if (entry != null) {
            this.c(entry);
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        ++this.modCount;
        this.a.deleteAll();
        this.b.clear();
    }

    @Override
    public E get(int n2) {
        Entry<E> entry = this.a(n2);
        return (E)entry.a;
    }

    private E a(Entry<E> entry, E e2) {
        Object t2 = entry.a;
        if (e2 != t2) {
            this.b(t2, entry);
            entry.a = e2;
            this.a(e2, entry);
        }
        return (E)t2;
    }

    @Override
    public E set(int n2, E e2) {
        Entry<E> entry = this.a(n2);
        return this.a(entry, e2);
    }

    @Override
    public void add(int n2, E e2) {
        Entry<E> entry;
        block7: {
            if (n2 < 0 || n2 > this.a.getSize()) {
                throw new IndexOutOfBoundsException();
            }
            entry = new Entry<E>(e2);
            IlvBalancedBinaryTree.Node node = this.a.getRoot();
            if (node == null) {
                this.a.insertEntryAtRoot(entry);
            } else {
                while (true) {
                    int n3;
                    int n4 = n3 = node.getLeftBranch() != null ? node.getLeftBranch().getBranchSize() : 0;
                    if (n2 <= n3) {
                        if (node.getLeftBranch() == null) {
                            this.a.insertEntryBefore(node, entry);
                            break block7;
                        }
                        node = node.getLeftBranch();
                        continue;
                    }
                    int n5 = node.getEntriesCount();
                    if ((n2 -= n3) < n5) break;
                    if (node.getRightBranch() == null) {
                        this.a.insertEntryAfter(node, entry);
                        break block7;
                    }
                    n2 -= n5;
                    node = node.getRightBranch();
                }
                this.a.insertEntryInto(node, n2, entry);
            }
        }
        ++this.modCount;
        this.a(e2, entry);
    }

    @Override
    public E remove(int n2) {
        Entry<E> entry = this.a(n2);
        Object t2 = entry.a;
        this.c(entry);
        return (E)t2;
    }

    @Override
    public int indexOf(Object object) {
        Entry<E> entry = this.a(object);
        if (entry != null) {
            return this.a.getIndexOfEntry(entry);
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        Entry<E> entry = this.b(object);
        if (entry != null) {
            return this.a.getIndexOfEntry(entry);
        }
        return -1;
    }

    @Override
    public ListIterator<E> listIterator() {
        return new MyListIterator(0, this.a(), null);
    }

    @Override
    public ListIterator<E> listIterator(int n2) {
        Entry<E> entry;
        Entry<E> entry2;
        if (n2 == 0) {
            entry2 = this.a();
            entry = null;
        } else if (n2 == this.a.getSize()) {
            entry2 = null;
            entry = this.b();
        } else {
            entry2 = this.a(n2);
            entry = this.b(entry2);
        }
        return new MyListIterator(n2, entry2, entry);
    }

    private void a(int n2, Iterator<? extends E> iterator) {
        IlvBalancedBinaryTree.Entry[] entryArray = new Entry[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            entryArray[i2] = new Entry<E>(iterator.next());
        }
        this.a.init(entryArray);
        Entry<E> entry = this.a();
        while (entry != null) {
            this.a(entry.a, entry);
            entry = this.a(entry);
        }
    }

    public int binarySearch(E e2) {
        IlvBalancedBinaryTree.Node node = this.a.getRoot();
        int n2 = 0;
        while (node != null) {
            int n3 = ((Comparable)((Entry)node.getEntry((int)0)).a).compareTo(e2);
            if (n3 > 0) {
                node = node.getLeftBranch();
                continue;
            }
            if (node.getLeftBranch() != null) {
                n2 += node.getLeftBranch().getBranchSize();
            }
            if (n3 == 0) {
                return n2;
            }
            n3 = node.getEntriesCount();
            if (n3 > 1) {
                int n4 = ((Comparable)((Entry)node.getEntry((int)(n3 - 1))).a).compareTo(e2);
                if (n4 < 0) {
                    n2 += n3;
                    node = node.getRightBranch();
                    continue;
                }
                if (n4 == 0) {
                    return n2 + n3 - 1;
                }
                n4 = 0;
                int n5 = n3 - 1;
                while (n5 - n4 > 1) {
                    int n6 = n4 + n5 >> 1;
                    int n7 = ((Comparable)((Entry)node.getEntry((int)n6)).a).compareTo(e2);
                    if (n7 < 0) {
                        n4 = n6;
                        continue;
                    }
                    if (n7 > 0) {
                        n5 = n6;
                        continue;
                    }
                    return n2 + n6;
                }
                return -(n2 + n5) - 1;
            }
            n2 += n3;
            node = node.getRightBranch();
        }
        return -n2 - 1;
    }

    public int binarySearch(E e2, Comparator<? super E> comparator) {
        if (comparator == null) {
            return this.binarySearch(e2);
        }
        IlvBalancedBinaryTree.Node node = this.a.getRoot();
        int n2 = 0;
        while (node != null) {
            int n3 = comparator.compare(((Entry)node.getEntry((int)0)).a, e2);
            if (n3 > 0) {
                node = node.getLeftBranch();
                continue;
            }
            if (node.getLeftBranch() != null) {
                n2 += node.getLeftBranch().getBranchSize();
            }
            if (n3 == 0) {
                return n2;
            }
            n3 = node.getEntriesCount();
            if (n3 > 1) {
                int n4 = comparator.compare(((Entry)node.getEntry((int)(n3 - 1))).a, e2);
                if (n4 < 0) {
                    n2 += n3;
                    node = node.getRightBranch();
                    continue;
                }
                if (n4 == 0) {
                    return n2 + n3 - 1;
                }
                n4 = 0;
                int n5 = n3 - 1;
                while (n5 - n4 > 1) {
                    int n6 = n4 + n5 >> 1;
                    int n7 = comparator.compare(((Entry)node.getEntry((int)n6)).a, e2);
                    if (n7 < 0) {
                        n4 = n6;
                        continue;
                    }
                    if (n7 > 0) {
                        n5 = n6;
                        continue;
                    }
                    return n2 + n6;
                }
                return -(n2 + n5) - 1;
            }
            n2 += n3;
            node = node.getRightBranch();
        }
        return -n2 - 1;
    }

    public int limitedBinarySearch(E e2, int n2, int n3) {
        IlvBalancedBinaryTree.Node node = this.a.getRoot();
        int n4 = 0;
        while (node != null) {
            int n5;
            int n6;
            int n7 = node.getLeftBranch() != null ? node.getLeftBranch().getBranchSize() : 0;
            if (n2 >= n7 + (n6 = node.getEntriesCount())) {
                n2 -= n7 + n6;
                n3 -= n7 + n6;
                n4 += n7 + n6;
                node = node.getRightBranch();
                continue;
            }
            if (n3 < n7) {
                node = node.getLeftBranch();
                continue;
            }
            if (n2 <= n7) {
                n5 = ((Comparable)((Entry)node.getEntry((int)0)).a).compareTo(e2);
                if (n5 > 0) {
                    node = node.getLeftBranch();
                    continue;
                }
                if (n5 == 0) {
                    return n4;
                }
                n2 = n7 + 1;
            }
            if (n6 > 1) {
                if (n3 >= n7 + n6 - 1) {
                    n5 = ((Comparable)((Entry)node.getEntry((int)(n6 - 1))).a).compareTo(e2);
                    if (n5 < 0) {
                        n2 -= n7 + n6;
                        n3 -= n7 + n6;
                        n4 += n7 + n6;
                        node = node.getRightBranch();
                        continue;
                    }
                    if (n5 == 0) {
                        return n4 + n6 - 1;
                    }
                    n3 = n7 + n6 - 2;
                }
                n2 -= n7;
                n3 -= n7;
                n4 += n7;
                while (n2 <= n3) {
                    n5 = n2 + n3 >> 1;
                    int n8 = ((Comparable)((Entry)node.getEntry((int)n5)).a).compareTo(e2);
                    if (n8 < 0) {
                        n2 = n5 + 1;
                        continue;
                    }
                    if (n8 > 0) {
                        n3 = n5 - 1;
                        continue;
                    }
                    return n4 + n5;
                }
                return -(n4 + n2) - 1;
            }
            n2 -= n7 + n6;
            n3 -= n7 + n6;
            n4 += n7 + n6;
            node = node.getRightBranch();
        }
        return -n4 - 1;
    }

    public int limitedBinarySearch(E e2, Comparator<? super E> comparator, int n2, int n3) {
        if (comparator == null) {
            return this.limitedBinarySearch(e2, n2, n3);
        }
        IlvBalancedBinaryTree.Node node = this.a.getRoot();
        int n4 = 0;
        while (node != null) {
            int n5;
            int n6;
            int n7 = node.getLeftBranch() != null ? node.getLeftBranch().getBranchSize() : 0;
            if (n2 >= n7 + (n6 = node.getEntriesCount())) {
                n2 -= n7 + n6;
                n3 -= n7 + n6;
                n4 += n7 + n6;
                node = node.getRightBranch();
                continue;
            }
            if (n3 < n7) {
                node = node.getLeftBranch();
                continue;
            }
            if (n2 <= n7) {
                n5 = comparator.compare(((Entry)node.getEntry((int)0)).a, e2);
                if (n5 > 0) {
                    node = node.getLeftBranch();
                    continue;
                }
                if (n5 == 0) {
                    return n4;
                }
                n2 = n7 + 1;
            }
            if (n6 > 1) {
                if (n3 >= n7 + n6 - 1) {
                    n5 = comparator.compare(((Entry)node.getEntry((int)(n6 - 1))).a, e2);
                    if (n5 < 0) {
                        n2 -= n7 + n6;
                        n3 -= n7 + n6;
                        n4 += n7 + n6;
                        node = node.getRightBranch();
                        continue;
                    }
                    if (n5 == 0) {
                        return n4 + n6 - 1;
                    }
                    n3 = n7 + n6 - 2;
                }
                n2 -= n7;
                n3 -= n7;
                n4 += n7;
                while (n2 <= n3) {
                    n5 = n2 + n3 >> 1;
                    int n8 = comparator.compare(((Entry)node.getEntry((int)n5)).a, e2);
                    if (n8 < 0) {
                        n2 = n5 + 1;
                        continue;
                    }
                    if (n8 > 0) {
                        n3 = n5 - 1;
                        continue;
                    }
                    return n4 + n5;
                }
                return -(n4 + n2) - 1;
            }
            n2 -= n7 + n6;
            n3 -= n7 + n6;
            n4 += n7 + n6;
            node = node.getRightBranch();
        }
        return -n4 - 1;
    }

    public Object clone() {
        try {
            IlvHashTreeList ilvHashTreeList = (IlvHashTreeList)super.clone();
            ilvHashTreeList.a = new IlvBalancedBinaryTree();
            ilvHashTreeList.b = new HashMap();
            ilvHashTreeList.modCount = 0;
            ilvHashTreeList.a(this.size(), this.iterator());
            return ilvHashTreeList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MyListIterator
    implements ListIterator<E> {
        private int a;
        private Entry<E> b;
        private Entry<E> c;
        private Entry<E> d;
        private int e;

        MyListIterator(int n2, Entry<E> entry, Entry<E> entry2) {
            this.a = IlvHashTreeList.this.modCount;
            this.b = null;
            this.c = IlvHashTreeList.this.a();
            this.d = null;
            this.e = 0;
            this.e = n2;
            this.c = entry;
            this.d = entry2;
        }

        @Override
        public boolean hasNext() {
            return this.c != null;
        }

        @Override
        public E next() {
            if (this.c == null) {
                throw new NoSuchElementException();
            }
            if (IlvHashTreeList.this.modCount != this.a) {
                throw new ConcurrentModificationException();
            }
            this.b = this.c;
            this.d = this.c;
            this.c = IlvHashTreeList.this.a(this.c);
            ++this.e;
            return this.b.a;
        }

        @Override
        public boolean hasPrevious() {
            return this.d != null;
        }

        @Override
        public E previous() {
            if (this.d == null) {
                throw new NoSuchElementException();
            }
            if (IlvHashTreeList.this.modCount != this.a) {
                throw new ConcurrentModificationException();
            }
            this.b = this.d;
            this.c = this.d;
            this.d = IlvHashTreeList.this.b(this.d);
            --this.e;
            return this.b.a;
        }

        @Override
        public int nextIndex() {
            return this.e;
        }

        @Override
        public int previousIndex() {
            return this.e - 1;
        }

        @Override
        public void remove() {
            if (this.b == null) {
                throw new IllegalStateException();
            }
            if (IlvHashTreeList.this.modCount != this.a) {
                throw new ConcurrentModificationException();
            }
            if (this.b == this.d) {
                this.d = IlvHashTreeList.this.b(this.b);
                --this.e;
            } else {
                this.c = IlvHashTreeList.this.a(this.b);
            }
            IlvHashTreeList.this.c(this.b);
            ++this.a;
            this.b = null;
        }

        @Override
        public void set(E e2) {
            if (this.b == null) {
                throw new IllegalStateException();
            }
            if (IlvHashTreeList.this.modCount != this.a) {
                throw new ConcurrentModificationException();
            }
            IlvHashTreeList.this.a(this.b, e2);
        }

        @Override
        public void add(E e2) {
            if (IlvHashTreeList.this.modCount != this.a) {
                throw new ConcurrentModificationException();
            }
            IlvHashTreeList.this.add(this.e, e2);
            ++this.e;
            ++this.a;
            this.b = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Entry<T>
    extends IlvBalancedBinaryTree.Entry {
        T a;

        Entry(T t2) {
            this.a = t2;
        }

        public String toString() {
            return "+" + this.a;
        }
    }
}

