/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.collections;

import ilog.views.util.collections.IlvUnaryPredicate;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IlvCollections {
    private static ListIterator a;
    private static IlvUnaryPredicate b;
    private static IlvUnaryPredicate c;

    private IlvCollections() {
    }

    public static <E> Iterator<E> unmodifiableIterator(Iterator<E> iterator) {
        return iterator == null ? null : new ReadOnlyIterator<E>(iterator);
    }

    public static <E> ListIterator<E> unmodifiableIterator(ListIterator<E> listIterator) {
        return listIterator == null ? null : new ReadOnlyListIterator<E>(listIterator);
    }

    public static <E> ListIterator<E> reversedIterator(ListIterator<E> listIterator) {
        return listIterator == null ? null : new ReversedListIterator<E>(listIterator);
    }

    public static <E> ListIterator<E> reversedIterator(List<E> list) {
        return IlvCollections.reversedIterator(list.listIterator(list.size()));
    }

    public static <E> Iterator<E> emptyIterator() {
        return IlvCollections.emptyListIterator();
    }

    public static <E> ListIterator<E> emptyListIterator() {
        if (a == null) {
            a = new ListIterator(){

                public boolean hasNext() {
                    return false;
                }

                public boolean hasPrevious() {
                    return false;
                }

                public Object next() {
                    throw new NoSuchElementException();
                }

                public Object previous() {
                    throw new NoSuchElementException();
                }

                public int nextIndex() {
                    return 0;
                }

                public int previousIndex() {
                    return -1;
                }

                public void remove() {
                    throw new IllegalStateException();
                }

                public void set(Object object) {
                    throw new IllegalStateException();
                }

                public void add(Object object) {
                    throw new IllegalStateException();
                }
            };
        }
        return a;
    }

    public static <E> Iterator<E> oneElementIterator(E e2) {
        return new OneElementIterator<E>(e2);
    }

    public static <E> ListIterator<E> oneElementListIterator(E e2) {
        return new OneElementIterator<E>(e2);
    }

    public static <T> IlvUnaryPredicate<T> trueUnaryPredicate() {
        if (b == null) {
            b = new IlvUnaryPredicate(){

                public boolean evaluate(Object object) {
                    return true;
                }
            };
        }
        return b;
    }

    public static <T> IlvUnaryPredicate<T> falseUnaryPredicate() {
        if (c == null) {
            c = new IlvUnaryPredicate(){

                public boolean evaluate(Object object) {
                    return false;
                }
            };
        }
        return c;
    }

    public static ConcurrentModificationException concurrentModificationException(String string, Throwable throwable) {
        ConcurrentModificationException concurrentModificationException = new ConcurrentModificationException(string);
        if (throwable != null) {
            concurrentModificationException.initCause(throwable);
        }
        return concurrentModificationException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class OneElementIterator<E>
    implements ListIterator<E> {
        E a;
        boolean b;
        boolean c;

        OneElementIterator(E e2) {
            this.a = e2;
            this.b = true;
            this.c = false;
        }

        @Override
        public boolean hasNext() {
            return this.b;
        }

        @Override
        public boolean hasPrevious() {
            return this.c;
        }

        @Override
        public E next() {
            if (!this.b) {
                throw new IllegalStateException();
            }
            this.b = false;
            this.c = true;
            return this.a;
        }

        @Override
        public E previous() {
            if (!this.c) {
                throw new IllegalStateException();
            }
            this.c = false;
            this.b = true;
            return this.a;
        }

        @Override
        public int nextIndex() {
            if (this.b) {
                return 0;
            }
            return 1;
        }

        @Override
        public int previousIndex() {
            if (this.c) {
                return 0;
            }
            return -1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(E e2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(E e2) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ReversedListIterator<E>
    implements ListIterator<E> {
        ListIterator<E> a;

        ReversedListIterator(ListIterator<E> listIterator) {
            this.a = listIterator;
        }

        @Override
        public boolean hasNext() {
            return this.a.hasPrevious();
        }

        @Override
        public E next() {
            return this.a.previous();
        }

        @Override
        public boolean hasPrevious() {
            return this.a.hasNext();
        }

        @Override
        public E previous() {
            return this.a.next();
        }

        @Override
        public int nextIndex() {
            return this.a.previousIndex();
        }

        @Override
        public int previousIndex() {
            return this.a.nextIndex();
        }

        @Override
        public void set(E e2) {
            this.a.set(e2);
        }

        @Override
        public void add(E e2) {
            this.a.add(e2);
        }

        @Override
        public void remove() {
            this.a.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ReadOnlyListIterator<E>
    implements ListIterator<E> {
        ListIterator<? extends E> a;

        ReadOnlyListIterator(ListIterator<? extends E> listIterator) {
            this.a = listIterator;
        }

        @Override
        public boolean hasNext() {
            return this.a.hasNext();
        }

        @Override
        public E next() {
            return this.a.next();
        }

        @Override
        public boolean hasPrevious() {
            return this.a.hasPrevious();
        }

        @Override
        public E previous() {
            return this.a.previous();
        }

        @Override
        public int nextIndex() {
            return this.a.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.a.previousIndex();
        }

        @Override
        public void set(E e2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(E e2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ReadOnlyIterator<E>
    implements Iterator<E> {
        Iterator<? extends E> a;

        ReadOnlyIterator(Iterator<? extends E> iterator) {
            this.a = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.a.hasNext();
        }

        @Override
        public E next() {
            return this.a.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

