/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.tiling;

import ilog.views.IlvManager;
import ilog.views.IlvManagerLayer;
import ilog.views.IlvManagerView;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.event.ManagerLayerEvent;
import ilog.views.event.ManagerLayerInsertedEvent;
import ilog.views.event.ManagerLayerListener;
import ilog.views.event.ManagerLayerMovedEvent;
import ilog.views.event.ManagerLayerRemovedEvent;
import ilog.views.graphic.IlvPolygon;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import ilog.views.tiling.IlvFreeTile;
import ilog.views.tiling.IlvTile;
import ilog.views.tiling.IlvTileCache;
import ilog.views.tiling.IlvTileController;
import ilog.views.tiling.IlvTileLoader;
import ilog.views.tiling.TileEvent;
import ilog.views.tiling.TileListener;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;

public class IlvTiledLayer
extends IlvManagerLayer {
    transient DebugListener a = null;
    private transient IlvManagerView b = null;
    private transient Color c;
    private transient Color d;
    private transient Color e;
    private transient Color f;
    transient Hashtable g = new Hashtable();
    private IlvTileController h;
    private ManagerLayerListener i = new MyLayerChangedListener();
    private int j;

    public IlvTiledLayer(IlvRect ilvRect) {
        this(ilvRect, null, 0);
    }

    public IlvTiledLayer(IlvRect ilvRect, IlvTileCache ilvTileCache, int n2) {
        this.j = n2;
        this.h = new IlvTileController(ilvRect, ilvTileCache, this, n2);
    }

    public IlvTiledLayer(IlvRect ilvRect, IlvTileCache ilvTileCache) {
        this(ilvRect, ilvTileCache, 0);
    }

    public IlvTiledLayer(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(ilvInputStream);
        this.h = (IlvTileController)ilvInputStream.readPersistentObject("tileController");
        this.h.a(this);
        this.j = this.h.getMode();
    }

    public void setDebugView(IlvManagerView ilvManagerView) {
        if (this.j == 0) {
            this.setDebugView(ilvManagerView, Color.green, Color.blue, Color.yellow, null);
        } else {
            this.setDebugView(ilvManagerView, Color.green, new Color(0.0f, 0.0f, 1.0f, 0.5f), new Color(1.0f, 1.0f, 0.0f, 0.5f), new Color(0.5f, 0.5f, 0.5f, 0.0f));
        }
    }

    protected void initTileOrigin(IlvRect ilvRect) {
        this.h.a(ilvRect);
        if (this.getManager() != null) {
            Enumeration enumeration = this.getManager().getViews();
            IlvTileController ilvTileController = this.getTileController();
            while (enumeration.hasMoreElements()) {
                IlvManagerView ilvManagerView = (IlvManagerView)enumeration.nextElement();
                ilvTileController.updateView(ilvManagerView);
                ilvManagerView.repaint();
            }
        }
    }

    protected void disconnect(IlvManager ilvManager) {
        this.getTileController().dispose();
    }

    public void setDebugView(IlvManagerView ilvManagerView, Color color, Color color2, Color color3, Color color4) {
        this.b = ilvManagerView;
        this.c = color;
        this.d = color2;
        this.e = color3;
        this.f = color4;
        if (this.b != null) {
            if (this.a == null) {
                this.a = new DebugListener();
                this.h.addTileListener(this.a);
            }
        } else if (this.a != null) {
            this.h.removeTileListener(this.a);
            this.a = null;
        }
    }

    public final IlvManagerView getDebugView() {
        return this.b;
    }

    public IlvRect computeBBox(IlvTransformer ilvTransformer) {
        if (this.h.a() == null) {
            return super.computeBBox(ilvTransformer);
        }
        IlvRect ilvRect = this.h.getSize();
        if (ilvTransformer != null) {
            ilvTransformer.boundingBox(ilvRect, false);
        }
        return ilvRect;
    }

    protected void draw(Graphics graphics, IlvManagerView ilvManagerView) {
        if (!this.isVisible(ilvManagerView)) {
            return;
        }
        if (ilvManagerView == this.b) {
            this.a(graphics, ilvManagerView);
        }
        if (super.isVisible(ilvManagerView)) {
            super.draw(graphics, ilvManagerView);
        }
    }

    public boolean isVisible(IlvManagerView ilvManagerView) {
        if (ilvManagerView.getManager() != this.getManager()) {
            throw new IllegalArgumentException("The view is not a view of the manager containing this layer.");
        }
        if (!this.isVisible() || !ilvManagerView.isVisible(this.getIndex())) {
            return false;
        }
        if (ilvManagerView == this.b) {
            return true;
        }
        return super.isVisible(ilvManagerView);
    }

    private void a(Graphics graphics, IlvManagerView ilvManagerView) {
        if (this.h.getMode() == 0) {
            this.b(graphics, ilvManagerView);
        } else {
            this.c(graphics, ilvManagerView);
        }
    }

    private void b(Graphics graphics, IlvManagerView ilvManagerView) {
        IlvRect ilvRect;
        Cloneable cloneable;
        if (!this.h.b()) {
            return;
        }
        IlvRect ilvRect2 = this.h.c();
        Rectangle rectangle = graphics.getClipBounds();
        if (rectangle == null) {
            cloneable = ilvManagerView.getSize();
            ilvRect = new IlvRect(0.0f, 0.0f, ((Dimension)cloneable).width, ((Dimension)cloneable).height);
        } else {
            ilvRect = new IlvRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        cloneable = new IlvRect(ilvRect);
        IlvTransformer ilvTransformer = ilvManagerView.getTransformer();
        if (ilvTransformer != null) {
            ilvTransformer.boundingBox((IlvRect)cloneable, true);
        }
        if (this.h.a() != null) {
            if (!((IlvRect)cloneable).intersects(this.h.a())) {
                return;
            }
            ((IlvRect)cloneable).intersection(this.h.a());
        }
        IlvPoint[] ilvPointArray = new IlvPoint[4];
        for (int i2 = 0; i2 < 4; ++i2) {
            ilvPointArray[i2] = new IlvPoint();
        }
        IlvPolygon ilvPolygon = new IlvPolygon(ilvPointArray, false);
        int[] nArray = this.h.getTileIndexes((IlvRect)cloneable);
        if (nArray[1] - nArray[0] > 500 || nArray[3] - nArray[2] > 500) {
            return;
        }
        for (int i3 = nArray[0]; i3 <= nArray[1]; ++i3) {
            for (int i4 = nArray[2]; i4 <= nArray[3]; ++i4) {
                ilvPolygon.movePoint(0, ilvRect2.x + ilvRect2.width * (float)i3, ilvRect2.y + ilvRect2.height * (float)i4, null);
                ilvPolygon.movePoint(1, ilvRect2.x + ilvRect2.width * (float)(i3 + 1), ilvRect2.y + ilvRect2.height * (float)i4, null);
                ilvPolygon.movePoint(2, ilvRect2.x + ilvRect2.width * (float)(i3 + 1), ilvRect2.y + ilvRect2.height * (float)(i4 + 1), null);
                ilvPolygon.movePoint(3, ilvRect2.x + ilvRect2.width * (float)i3, ilvRect2.y + ilvRect2.height * (float)(i4 + 1), null);
                IlvTile ilvTile = this.h.getTile(i3, i4);
                if (ilvTile == null) {
                    if (this.f == null) continue;
                    ilvPolygon.setForeground(this.f);
                    ilvPolygon.draw(graphics, ilvTransformer);
                    continue;
                }
                if (ilvTile.getStatus() == 1 && this.d != null) {
                    ilvPolygon.setForeground(this.d);
                    ilvPolygon.draw(graphics, ilvTransformer);
                    continue;
                }
                if (ilvTile.getStatus() != 2 || this.e == null) continue;
                ilvPolygon.setForeground(this.e);
                ilvPolygon.draw(graphics, ilvTransformer);
            }
        }
        if (this.c != null) {
            IlvRect ilvRect3;
            int n2;
            graphics.setColor(this.c);
            IlvPoint ilvPoint = new IlvPoint();
            IlvPoint ilvPoint2 = new IlvPoint();
            for (n2 = nArray[0]; n2 <= nArray[1] + 1; ++n2) {
                ilvPoint2.x = ilvPoint.x = ilvRect2.x + ilvRect2.width * (float)n2;
                ilvPoint.y = ((Rectangle2D.Float)cloneable).y;
                ilvPoint2.y = ((Rectangle2D.Float)cloneable).y + ((Rectangle2D.Float)cloneable).height;
                ilvRect3 = this.h.a();
                if (ilvRect3 != null) {
                    if (ilvPoint2.x < ilvRect3.x || ilvPoint2.x > ilvRect3.x + ilvRect3.width) continue;
                    if (ilvPoint.y < ilvRect3.y) {
                        ilvPoint.y = ilvRect3.y;
                    }
                    if (ilvPoint2.y > ilvRect3.y + ilvRect3.height) {
                        ilvPoint2.y = ilvRect3.y + ilvRect3.height;
                    }
                }
                if (ilvTransformer != null) {
                    ilvTransformer.apply(ilvPoint2);
                    ilvTransformer.apply(ilvPoint);
                }
                graphics.drawLine((int)Math.floor(ilvPoint.x), (int)Math.floor(ilvPoint.y), (int)Math.floor(ilvPoint2.x), (int)Math.floor(ilvPoint2.y));
            }
            for (n2 = nArray[2]; n2 <= nArray[3] + 1; ++n2) {
                ilvPoint2.y = ilvPoint.y = ilvRect2.y + ilvRect2.height * (float)n2;
                ilvPoint.x = ((Rectangle2D.Float)cloneable).x;
                ilvPoint2.x = ((Rectangle2D.Float)cloneable).x + ((Rectangle2D.Float)cloneable).width;
                ilvRect3 = this.h.a();
                if (ilvRect3 != null) {
                    if (ilvPoint2.y < ilvRect3.y || ilvPoint2.y > ilvRect3.y + ilvRect3.height) continue;
                    if (ilvPoint.x < ilvRect3.x) {
                        ilvPoint.x = ilvRect3.x;
                    }
                    if (ilvPoint2.x > ilvRect3.x + ilvRect3.width) {
                        ilvPoint2.x = ilvRect3.x + ilvRect3.width;
                    }
                }
                if (ilvTransformer != null) {
                    ilvTransformer.apply(ilvPoint2);
                    ilvTransformer.apply(ilvPoint);
                }
                graphics.drawLine((int)Math.floor(ilvPoint.x), (int)Math.floor(ilvPoint.y), (int)Math.floor(ilvPoint2.x), (int)Math.floor(ilvPoint2.y));
            }
        }
    }

    private void c(Graphics graphics, IlvManagerView ilvManagerView) {
        IlvRect ilvRect;
        Cloneable cloneable;
        Rectangle rectangle = graphics.getClipBounds();
        if (rectangle == null) {
            cloneable = ilvManagerView.getSize();
            ilvRect = new IlvRect(0.0f, 0.0f, ((Dimension)cloneable).width, ((Dimension)cloneable).height);
        } else {
            ilvRect = new IlvRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        cloneable = new IlvRect(ilvRect);
        IlvTransformer ilvTransformer = ilvManagerView.getTransformer();
        if (ilvTransformer != null) {
            ilvTransformer.boundingBox((IlvRect)cloneable, true);
        }
        if (this.h.a() != null) {
            if (!((IlvRect)cloneable).intersects(this.h.a())) {
                return;
            }
            ((IlvRect)cloneable).intersection(this.h.a());
        }
        IlvPoint[] ilvPointArray = new IlvPoint[4];
        for (int i2 = 0; i2 < 4; ++i2) {
            ilvPointArray[i2] = new IlvPoint();
        }
        IlvPolygon ilvPolygon = new IlvPolygon(ilvPointArray, true, true, true);
        IlvRect ilvRect2 = new IlvRect();
        Collection collection = this.h.getIntersectingTiles((IlvRect)cloneable);
        if (collection.size() > 500) {
            return;
        }
        for (IlvTile ilvTile : collection) {
            ilvTile.boundingBox(ilvRect2);
            ilvPolygon.movePoint(0, ilvRect2.x, ilvRect2.y, null);
            ilvPolygon.movePoint(1, ilvRect2.x + ilvRect2.width, ilvRect2.y, null);
            ilvPolygon.movePoint(2, ilvRect2.x + ilvRect2.width, ilvRect2.y + ilvRect2.height, null);
            ilvPolygon.movePoint(3, ilvRect2.x, ilvRect2.y + ilvRect2.height, null);
            if (this.c != null) {
                ilvPolygon.setBackground(this.c);
                ilvPolygon.setStrokeOn(true);
            }
            if (ilvTile.getStatus() == 0) {
                if (this.f == null) continue;
                ilvPolygon.setForeground(this.f);
                ilvPolygon.draw(graphics, ilvTransformer);
                continue;
            }
            if (ilvTile.getStatus() == 1 && this.d != null) {
                ilvPolygon.setForeground(this.d);
                ilvPolygon.draw(graphics, ilvTransformer);
                continue;
            }
            if (ilvTile.getStatus() != 2 || this.e == null) continue;
            ilvPolygon.setForeground(this.e);
            ilvPolygon.draw(graphics, ilvTransformer);
        }
    }

    public void ignoreView(IlvManagerView ilvManagerView, boolean bl) {
        this.h.ignoreView(ilvManagerView, bl);
    }

    public boolean isIgnoringView(IlvManagerView ilvManagerView) {
        return this.h.isIgnoringView(ilvManagerView);
    }

    boolean a(IlvManagerView ilvManagerView) {
        if (ilvManagerView == this.b) {
            return false;
        }
        return this.isVisible(ilvManagerView);
    }

    private void g() {
        if (this.b != null) {
            this.b.repaint();
        }
    }

    final Hashtable f() {
        return this.g;
    }

    public void setSize(IlvRect ilvRect) {
        this.h.setSize(ilvRect);
    }

    public IlvRect getSize() {
        return this.h.getSize();
    }

    public final IlvTileController getTileController() {
        return this.h;
    }

    public final IlvTileLoader getTileLoader() {
        return this.h.getTileLoader();
    }

    public void setTileLoader(IlvTileLoader ilvTileLoader) {
        this.h.setTileLoader(ilvTileLoader);
    }

    protected void setManager(IlvManager ilvManager) {
        super.setManager(ilvManager);
        this.h.a(ilvManager);
        if (ilvManager != null) {
            ilvManager.addManagerLayerListener(this.i);
        }
    }

    public void fitTransformerToTile(IlvManagerView ilvManagerView, int n2, int n3) {
        if (!this.h.b()) {
            return;
        }
        IlvRect ilvRect = this.h.c();
        IlvRect ilvRect2 = new IlvRect();
        ilvRect2.x = ilvRect.x + (float)n3 * ilvRect.width;
        ilvRect2.y = ilvRect.y + (float)n2 * ilvRect.height;
        ilvRect2.width = ilvRect.width;
        ilvRect2.height = ilvRect.height;
        this.a(ilvManagerView, ilvRect2);
    }

    public void fitTransformerToTile(IlvManagerView ilvManagerView, IlvFreeTile ilvFreeTile) {
        if (this.j == 1) {
            IlvRect ilvRect = new IlvRect();
            ilvFreeTile.boundingBox(ilvRect);
            this.a(ilvManagerView, ilvRect);
        }
    }

    private void a(IlvManagerView ilvManagerView, IlvRect ilvRect) {
        Rectangle rectangle = ilvManagerView.visibleRect();
        float f2 = (float)rectangle.width / ilvRect.width;
        float f3 = (float)rectangle.height / ilvRect.height;
        if (f2 > f3) {
            f2 = f3;
        } else {
            f3 = f2;
        }
        float f4 = (float)rectangle.x + (float)rectangle.width / 2.0f - f2 * (ilvRect.x + ilvRect.width / 2.0f);
        float f5 = (float)rectangle.y + (float)rectangle.height / 2.0f - f3 * (ilvRect.y + ilvRect.height / 2.0f);
        IlvTransformer ilvTransformer = new IlvTransformer();
        ilvTransformer.setValues(f2, 0.0, 0.0, f3, f4, f5);
        ilvManagerView.setTransformer(ilvTransformer);
    }

    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        ilvOutputStream.write("tileController", this.h);
    }

    class MyLayerChangedListener
    implements ManagerLayerListener {
        MyLayerChangedListener() {
        }

        public void layerInserted(ManagerLayerInsertedEvent managerLayerInsertedEvent) {
        }

        public void layerRemoved(ManagerLayerRemovedEvent managerLayerRemovedEvent) {
            if (managerLayerRemovedEvent.getLayer() == IlvTiledLayer.this) {
                managerLayerRemovedEvent.getManager().removeManagerLayerListener(this);
                IlvTiledLayer.this.disconnect(managerLayerRemovedEvent.getManager());
            }
        }

        public void layerMoved(ManagerLayerMovedEvent managerLayerMovedEvent) {
        }

        public void layerChanged(ManagerLayerEvent managerLayerEvent) {
        }
    }

    class DebugListener
    implements TileListener {
        DebugListener() {
        }

        public void tileChanged(TileEvent tileEvent) {
            if (!IlvTiledLayer.this.h.d()) {
                IlvTiledLayer.this.g();
            }
        }
    }
}

