/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.symbology.palettes.swing;

import ilog.views.symbology.palettes.IlvPalette;
import ilog.views.symbology.palettes.IlvPaletteBaseObject;
import ilog.views.symbology.palettes.IlvPaletteCategory;
import ilog.views.symbology.palettes.IlvPaletteCategoryChild;
import ilog.views.symbology.palettes.IlvPaletteObject;
import ilog.views.symbology.palettes.IlvPaletteSymbol;
import ilog.views.symbology.palettes.event.PaletteViewerEvent;
import ilog.views.symbology.palettes.event.PaletteViewerListener;
import ilog.views.symbology.palettes.swing.IlvPaletteDragAndDropData;
import ilog.views.symbology.palettes.swing.IlvPaletteObjectTransferable;
import ilog.views.symbology.palettes.swing.IlvPaletteTreeCellRenderer;
import ilog.views.symbology.palettes.swing.IlvPaletteTreeModel;
import ilog.views.symbology.palettes.swing.IlvPaletteViewer;
import ilog.views.symbology.palettes.swing.event.PaletteDropEvent;
import ilog.views.symbology.palettes.swing.event.PaletteDropListener;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class IlvPaletteTreeViewer
implements IlvPaletteViewer {
    private EventListenerList a = null;
    private EventListenerList b = null;
    private IlvPalette c = null;
    private IlvPaletteTreeModel d = null;
    private IlvPaletteTree e = new IlvPaletteTree(this);
    private boolean f = false;
    private DropTarget g = null;
    private DragSource h = null;
    private TreeDragGestureListener i = null;
    private TreeDragSourceListener j = null;

    public IlvPaletteTreeViewer() {
        IlvPaletteTreeCellRenderer ilvPaletteTreeCellRenderer = new IlvPaletteTreeCellRenderer();
        this.e.setCellRenderer(ilvPaletteTreeCellRenderer);
        this.e.setRowHeight(24);
        this.e.setDragEnabled(false);
        this.j = new TreeDragSourceListener(this);
        this.i = new TreeDragGestureListener(this);
        this.h = new DragSource();
        this.h.createDefaultDragGestureRecognizer(this.e, 3, this.i);
        this.h.addDragSourceListener(this.j);
        this.g = new DropTarget(this.getComponent(), new TreeDropTargetListener(this));
        this.g.setActive(this.f);
    }

    public void setPalette(IlvPalette ilvPalette) {
        if (ilvPalette == null) {
            this.e.setModel(null);
            return;
        }
        this.c = ilvPalette;
        this.d = new IlvPaletteTreeModel(ilvPalette, this.e);
        this.e.setModel(this.d);
    }

    public IlvPalette getPalette() {
        return this.c;
    }

    public JComponent getComponent() {
        return this.e;
    }

    public void addPaletteViewerListener(PaletteViewerListener paletteViewerListener) {
        if (this.a == null) {
            this.a = new EventListenerList();
        }
        this.a.add(PaletteViewerListener.class, paletteViewerListener);
    }

    public void removePaletteViewerListener(PaletteViewerListener paletteViewerListener) {
        if (this.a != null) {
            this.a.remove(PaletteViewerListener.class, paletteViewerListener);
            if (this.a.getListenerCount() == 0) {
                this.a = null;
            }
        }
    }

    protected void fireCategorySelected(IlvPalette ilvPalette, IlvPaletteCategory ilvPaletteCategory) {
        if (this.a == null) {
            return;
        }
        Object[] objectArray = this.a.getListenerList();
        if (objectArray == null || objectArray.length <= 0) {
            return;
        }
        PaletteViewerEvent paletteViewerEvent = new PaletteViewerEvent(this, ilvPalette, ilvPaletteCategory, null);
        for (int i2 = 1; i2 < objectArray.length; i2 += 2) {
            PaletteViewerListener paletteViewerListener = (PaletteViewerListener)objectArray[i2];
            paletteViewerListener.categorySelected(paletteViewerEvent);
        }
    }

    protected void fireCategoryDeselected(IlvPalette ilvPalette, IlvPaletteCategory ilvPaletteCategory) {
        if (this.a == null) {
            return;
        }
        Object[] objectArray = this.a.getListenerList();
        if (objectArray == null || objectArray.length <= 0) {
            return;
        }
        PaletteViewerEvent paletteViewerEvent = new PaletteViewerEvent(this, ilvPalette, ilvPaletteCategory, null);
        for (int i2 = 1; i2 < objectArray.length; i2 += 2) {
            PaletteViewerListener paletteViewerListener = (PaletteViewerListener)objectArray[i2];
            paletteViewerListener.categoryDeselected(paletteViewerEvent);
        }
    }

    protected void fireSymbolSelected(IlvPalette ilvPalette, IlvPaletteSymbol ilvPaletteSymbol) {
        if (this.a == null) {
            return;
        }
        Object[] objectArray = this.a.getListenerList();
        if (objectArray == null || objectArray.length <= 0) {
            return;
        }
        PaletteViewerEvent paletteViewerEvent = new PaletteViewerEvent(this, ilvPalette, null, ilvPaletteSymbol);
        for (int i2 = 1; i2 < objectArray.length; i2 += 2) {
            PaletteViewerListener paletteViewerListener = (PaletteViewerListener)objectArray[i2];
            paletteViewerListener.symbolSelected(paletteViewerEvent);
        }
    }

    protected void fireSymbolDeselected(IlvPalette ilvPalette, IlvPaletteSymbol ilvPaletteSymbol) {
        if (this.a == null) {
            return;
        }
        Object[] objectArray = this.a.getListenerList();
        if (objectArray == null || objectArray.length <= 0) {
            return;
        }
        PaletteViewerEvent paletteViewerEvent = new PaletteViewerEvent(this, ilvPalette, null, ilvPaletteSymbol);
        for (int i2 = 1; i2 < objectArray.length; i2 += 2) {
            PaletteViewerListener paletteViewerListener = (PaletteViewerListener)objectArray[i2];
            paletteViewerListener.symbolDeselected(paletteViewerEvent);
        }
    }

    public void setEditable(boolean bl) {
        this.f = bl;
        this.g.setActive(this.f);
    }

    public boolean isEditable() {
        return this.f;
    }

    public void select(IlvPaletteObject ilvPaletteObject) {
        TreePath treePath;
        if (ilvPaletteObject == null) {
            return;
        }
        if (ilvPaletteObject.getPalette() != this.getPalette()) {
            this.setPalette(ilvPaletteObject.getPalette());
        }
        if ((treePath = this.d.a(ilvPaletteObject)) != null) {
            this.e.setExpandsSelectedPaths(true);
            this.e.addSelectionPath(treePath);
            this.e.scrollPathToVisible(treePath);
        }
    }

    public IlvPaletteObject[] getSelectedPaletteObjects() {
        IlvPaletteObject[] ilvPaletteObjectArray = null;
        TreePath[] treePathArray = this.e.getSelectionPaths();
        if (treePathArray != null) {
            ilvPaletteObjectArray = new IlvPaletteObject[treePathArray.length];
            for (int i2 = 0; i2 < treePathArray.length; ++i2) {
                ilvPaletteObjectArray[i2] = (IlvPaletteObject)treePathArray[i2].getLastPathComponent();
            }
        }
        return ilvPaletteObjectArray;
    }

    public void addDropListener(PaletteDropListener paletteDropListener) {
        if (this.b == null) {
            this.b = new EventListenerList();
        }
        this.b.add(PaletteDropListener.class, paletteDropListener);
    }

    public void removeDropListener(PaletteDropListener paletteDropListener) {
        if (this.b == null) {
            return;
        }
        this.b.remove(PaletteDropListener.class, paletteDropListener);
        if (this.b.getListenerCount() == 0) {
            this.b = null;
        }
    }

    protected void fireObjectMoved(IlvPalette ilvPalette, IlvPalette ilvPalette2, Collection collection) {
        if (this.b == null || collection == null) {
            return;
        }
        Object[] objectArray = this.b.getListenerList();
        PaletteDropEvent paletteDropEvent = new PaletteDropEvent(ilvPalette, ilvPalette2, collection);
        for (int i2 = 1; i2 < objectArray.length; i2 += 2) {
            PaletteDropListener paletteDropListener = (PaletteDropListener)objectArray[i2];
            paletteDropListener.objectsMoved(paletteDropEvent);
        }
    }

    protected void fireObjectCopied(IlvPalette ilvPalette, IlvPalette ilvPalette2, Collection collection) {
        if (this.b == null || collection == null) {
            return;
        }
        Object[] objectArray = this.b.getListenerList();
        PaletteDropEvent paletteDropEvent = new PaletteDropEvent(ilvPalette, ilvPalette2, collection);
        for (int i2 = 1; i2 < objectArray.length; i2 += 2) {
            PaletteDropListener paletteDropListener = (PaletteDropListener)objectArray[i2];
            paletteDropListener.objectsCopied(paletteDropEvent);
        }
    }

    public void setMultiSelectionEnabled(boolean bl) {
        TreeSelectionModel treeSelectionModel = this.e.getSelectionModel();
        if (treeSelectionModel != null) {
            treeSelectionModel.setSelectionMode(bl ? 4 : 1);
        }
    }

    private static class TreeDropTargetListener
    implements DropTargetListener {
        private IlvPaletteViewer a = null;

        public TreeDropTargetListener(IlvPaletteViewer ilvPaletteViewer) {
            this.a = ilvPaletteViewer;
        }

        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            if (this.a(dropTargetDragEvent) || !this.b(dropTargetDragEvent)) {
                ((IlvPaletteTree)this.a.getComponent()).setDropCandidat(null);
                dropTargetDragEvent.rejectDrag();
            }
        }

        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            if (this.a(dropTargetDragEvent) || !this.b(dropTargetDragEvent)) {
                ((IlvPaletteTree)this.a.getComponent()).setDropCandidat(null);
                dropTargetDragEvent.rejectDrag();
                return;
            }
            Point point = dropTargetDragEvent.getLocation();
            DropTargetContext dropTargetContext = dropTargetDragEvent.getDropTargetContext();
            JTree jTree = (JTree)dropTargetContext.getComponent();
            TreePath treePath = jTree.getClosestPathForLocation(point.x, point.y);
            Object object = treePath == null ? null : treePath.getLastPathComponent();
            ((IlvPaletteTree)this.a.getComponent()).setDropCandidat(object);
        }

        public void dragExit(DropTargetEvent dropTargetEvent) {
            ((IlvPaletteTree)this.a.getComponent()).setDropCandidat(null);
        }

        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
            if (this.a(dropTargetDragEvent) || !this.b(dropTargetDragEvent)) {
                dropTargetDragEvent.rejectDrag();
                ((IlvPaletteTree)this.a.getComponent()).setDropCandidat(null);
                return;
            }
            dropTargetDragEvent.acceptDrag(3);
        }

        private boolean a(DropTargetDragEvent dropTargetDragEvent) {
            Transferable transferable = dropTargetDragEvent.getTransferable();
            if (transferable.isDataFlavorSupported(IlvPaletteObjectTransferable.PALETTE_OBJECT_FLAVOR)) {
                try {
                    IlvPaletteDragAndDropData ilvPaletteDragAndDropData = (IlvPaletteDragAndDropData)transferable.getTransferData(IlvPaletteObjectTransferable.PALETTE_OBJECT_FLAVOR);
                    if (!ilvPaletteDragAndDropData.getPaletteViewer().isEditable() && dropTargetDragEvent.getDropAction() == 2) {
                        return true;
                    }
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    unsupportedFlavorException.printStackTrace();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            return false;
        }

        private boolean b(DropTargetDragEvent dropTargetDragEvent) {
            Transferable transferable = dropTargetDragEvent.getTransferable();
            return transferable != null && transferable.isDataFlavorSupported(IlvPaletteObjectTransferable.PALETTE_OBJECT_FLAVOR);
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            if (!this.a.isEditable()) {
                ((IlvPaletteTree)this.a.getComponent()).setDropCandidat(null);
                return;
            }
            Point point = dropTargetDropEvent.getLocation();
            DropTargetContext dropTargetContext = dropTargetDropEvent.getDropTargetContext();
            JTree jTree = (JTree)dropTargetContext.getComponent();
            TreePath treePath = jTree.getClosestPathForLocation(point.x, point.y);
            Object object = treePath.getLastPathComponent();
            try {
                Transferable transferable = dropTargetDropEvent.getTransferable();
                DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
                for (int i2 = 0; i2 < dataFlavorArray.length; ++i2) {
                    Iterator iterator;
                    Object object2;
                    Object object32;
                    if (!transferable.isDataFlavorSupported(dataFlavorArray[i2])) continue;
                    IlvPaletteDragAndDropData ilvPaletteDragAndDropData = (IlvPaletteDragAndDropData)transferable.getTransferData(dataFlavorArray[i2]);
                    Collection collection = ilvPaletteDragAndDropData.getPaletteObjects();
                    for (Object object32 : collection) {
                        object2 = ((IlvPaletteTreeModel)jTree.getModel()).a(object32);
                        if (!jTree.getModel().isLeaf(object) && ((TreePath)object2).isDescendant(treePath)) {
                            dropTargetDropEvent.rejectDrop();
                            ((IlvPaletteTree)this.a.getComponent()).setDropCandidat(null);
                            return;
                        }
                        if (!((TreePath)object2).getParentPath().equals(treePath)) continue;
                        dropTargetDropEvent.rejectDrop();
                        ((IlvPaletteTree)this.a.getComponent()).setDropCandidat(null);
                        return;
                    }
                    if (dropTargetDropEvent.getDropAction() == 1) {
                        if (ilvPaletteDragAndDropData.getPaletteViewer().getPalette() != this.a.getPalette()) {
                            dropTargetDropEvent.acceptDrop(1);
                            collection = ilvPaletteDragAndDropData.getPaletteObjects();
                            iterator = collection.iterator();
                            object32 = null;
                            object2 = null;
                            while (iterator.hasNext()) {
                                IlvPaletteCategory ilvPaletteCategory;
                                IlvPaletteObject ilvPaletteObject = (IlvPaletteObject)iterator.next();
                                IlvPaletteObject ilvPaletteObject2 = ilvPaletteObject.copy();
                                if (object32 == null) {
                                    object32 = ilvPaletteObject.getPalette();
                                }
                                if (object instanceof IlvPaletteCategory) {
                                    ilvPaletteCategory = (IlvPaletteCategory)object;
                                    ilvPaletteCategory.add(ilvPaletteObject2);
                                    if (object2 == null) {
                                        object2 = ilvPaletteCategory.getPalette();
                                    }
                                } else {
                                    ilvPaletteCategory = ((IlvPaletteCategoryChild)object).getParent();
                                    int n2 = ilvPaletteCategory.indexOf(object);
                                    ilvPaletteCategory.add(n2, ilvPaletteObject2);
                                    if (object2 == null) {
                                        object2 = ilvPaletteCategory.getPalette();
                                    }
                                }
                                if (!(this.a instanceof IlvPaletteTreeViewer)) continue;
                                ((IlvPaletteTreeViewer)this.a).fireObjectCopied((IlvPalette)object32, (IlvPalette)object2, collection);
                            }
                        } else {
                            ((IlvPaletteTree)this.a.getComponent()).setDropCandidat(null);
                            dropTargetDropEvent.rejectDrop();
                        }
                    } else {
                        if (!ilvPaletteDragAndDropData.getPaletteViewer().isEditable()) {
                            dropTargetDropEvent.rejectDrop();
                            ((IlvPaletteTree)this.a.getComponent()).setDropCandidat(null);
                            return;
                        }
                        dropTargetDropEvent.acceptDrop(2);
                        collection = ilvPaletteDragAndDropData.getPaletteObjects();
                        iterator = collection.iterator();
                        object32 = null;
                        object2 = null;
                        while (iterator.hasNext()) {
                            IlvPaletteCategory ilvPaletteCategory;
                            IlvPaletteObject ilvPaletteObject = (IlvPaletteObject)iterator.next();
                            IlvPaletteCategory ilvPaletteCategory2 = ilvPaletteObject.getParent();
                            if (object32 == null) {
                                object32 = ilvPaletteCategory2.getPalette();
                            }
                            if (object instanceof IlvPaletteCategory) {
                                ilvPaletteCategory = (IlvPaletteCategory)object;
                                if (ilvPaletteCategory2 != null) {
                                    ilvPaletteCategory2.remove(ilvPaletteObject);
                                }
                                ilvPaletteCategory.add(ilvPaletteObject);
                                if (object2 != null) continue;
                                object2 = ilvPaletteCategory.getPalette();
                                continue;
                            }
                            ilvPaletteCategory = ((IlvPaletteCategoryChild)object).getParent();
                            int n3 = ilvPaletteCategory.indexOf(object);
                            if (ilvPaletteCategory2 != null) {
                                ilvPaletteCategory2.remove(ilvPaletteObject);
                            }
                            ilvPaletteCategory.add(n3, ilvPaletteObject);
                            if (object2 != null) continue;
                            object2 = ilvPaletteCategory.getPalette();
                        }
                        if (this.a instanceof IlvPaletteTreeViewer) {
                            ((IlvPaletteTreeViewer)this.a).fireObjectMoved((IlvPalette)object32, (IlvPalette)object2, collection);
                        }
                    }
                    ((IlvPaletteTree)this.a.getComponent()).setDropCandidat(null);
                    dropTargetDropEvent.dropComplete(true);
                    return;
                }
                dropTargetDropEvent.rejectDrop();
                ((IlvPaletteTree)this.a.getComponent()).setDropCandidat(null);
            }
            catch (Exception exception) {
                dropTargetDropEvent.rejectDrop();
                ((IlvPaletteTree)this.a.getComponent()).setDropCandidat(null);
            }
        }
    }

    private static class TreeDragSourceListener
    implements DragSourceListener {
        IlvPaletteTreeViewer a;

        public TreeDragSourceListener(IlvPaletteTreeViewer ilvPaletteTreeViewer) {
            this.a = ilvPaletteTreeViewer;
        }

        public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dragExit(DragSourceEvent dragSourceEvent) {
        }

        public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        }
    }

    private static class TreeDragGestureListener
    implements DragGestureListener {
        IlvPaletteTreeViewer a;
        JTree b;

        public TreeDragGestureListener(IlvPaletteTreeViewer ilvPaletteTreeViewer) {
            this.a = ilvPaletteTreeViewer;
            this.b = (JTree)ilvPaletteTreeViewer.getComponent();
        }

        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            TreePath[] treePathArray = this.b.getSelectionPaths();
            if (treePathArray == null || treePathArray.length < 1) {
                return;
            }
            int n2 = treePathArray.length;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (int i2 = 0; i2 < n2; ++i2) {
                Object object = treePathArray[i2].getLastPathComponent();
                if (!(object instanceof IlvPaletteObject) || object.equals(this.b.getModel().getRoot())) continue;
                arrayList.add(object);
            }
            if (arrayList.size() == 0) {
                return;
            }
            IlvPaletteObjectTransferable ilvPaletteObjectTransferable = new IlvPaletteObjectTransferable(arrayList, (IlvPaletteViewer)this.a);
            try {
                dragGestureEvent.startDrag(null, ilvPaletteObjectTransferable);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static class IlvPaletteTree
    extends JTree
    implements TreeSelectionListener {
        private Object a = null;
        private IlvPaletteTreeViewer b = null;
        private Enumeration c;

        public IlvPaletteTree(IlvPaletteTreeViewer ilvPaletteTreeViewer) {
            this.b = ilvPaletteTreeViewer;
            this.addTreeSelectionListener(this);
            DefaultTreeSelectionModel defaultTreeSelectionModel = new DefaultTreeSelectionModel(){

                public void removeSelectionPath(TreePath treePath) {
                    super.removeSelectionPath(treePath);
                    Object object = treePath.getLastPathComponent();
                    if (object instanceof IlvPaletteCategory) {
                        IlvPaletteTree.this.b.fireCategoryDeselected(IlvPaletteTree.this.b.getPalette(), (IlvPaletteCategory)object);
                    } else if (object instanceof IlvPaletteSymbol) {
                        IlvPaletteTree.this.b.fireSymbolDeselected(IlvPaletteTree.this.b.getPalette(), (IlvPaletteSymbol)object);
                    }
                }

                public void removeSelectionPaths(TreePath[] treePathArray) {
                    super.removeSelectionPaths(treePathArray);
                    for (int i2 = 0; i2 < treePathArray.length; ++i2) {
                        Object object = treePathArray[i2].getLastPathComponent();
                        if (object instanceof IlvPaletteCategory) {
                            IlvPaletteTree.this.b.fireCategoryDeselected(IlvPaletteTree.this.b.getPalette(), (IlvPaletteCategory)object);
                            continue;
                        }
                        if (!(object instanceof IlvPaletteSymbol)) continue;
                        IlvPaletteTree.this.b.fireSymbolDeselected(IlvPaletteTree.this.b.getPalette(), (IlvPaletteSymbol)object);
                    }
                }
            };
            defaultTreeSelectionModel.setSelectionMode(1);
            this.setSelectionModel(defaultTreeSelectionModel);
        }

        public Object getDropCandidat() {
            return this.a;
        }

        public void setDropCandidat(Object object) {
            this.a = object;
            this.repaint();
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            Object object = this.getLastSelectedPathComponent();
            if (object instanceof IlvPaletteCategory) {
                this.b.fireCategorySelected(this.b.getPalette(), (IlvPaletteCategory)object);
            } else if (object instanceof IlvPaletteSymbol) {
                this.b.fireSymbolSelected(this.b.getPalette(), (IlvPaletteSymbol)object);
            }
        }

        public String convertValueToText(Object object, boolean bl, boolean bl2, boolean bl3, int n2, boolean bl4) {
            if (object instanceof IlvPaletteBaseObject) {
                return ((IlvPaletteBaseObject)object).getName();
            }
            return super.convertValueToText(object, bl, bl2, bl3, n2, bl4);
        }

        public void setSelectionPath(TreePath treePath) {
            if (!this.isPathSelected(treePath)) {
                super.setSelectionPath(treePath);
            }
        }

        public void saveExpandedState(TreePath treePath) {
            this.c = this.getExpandedDescendants(treePath);
        }

        public void restoreExpandedState() {
            if (this.c != null) {
                Enumeration enumeration = this.c;
                while (enumeration.hasMoreElements()) {
                    TreePath treePath = (TreePath)enumeration.nextElement();
                    this.expandPath(treePath);
                }
            }
        }
    }
}

