/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.linkconnector;

import ilog.views.IlvApplyObject;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvLinkImage;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.io.IlvFieldNotFoundException;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvPersistentObject;
import ilog.views.io.IlvReadFileException;
import ilog.views.linkconnector.IlvCachingLinkConnector;
import ilog.views.linkconnector.IlvGrapherPin;
import ilog.views.util.internal.IlvEmptyEnumeration;
import java.awt.Color;
import java.awt.Graphics;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class IlvPinLinkConnector
extends IlvCachingLinkConnector {
    public static final int IlvPinSquare = 1;
    public static final int IlvPinDiamond = 2;
    public static final int IlvPinCircle = 4;
    public static final int IlvPinCross = 8;
    public static final int IlvPinPlus = 16;
    public static final int IlvPinFilledSquare = 32;
    public static final int IlvPinFilledCircle = 64;
    public static final int IlvPinFilledDiamond = 128;
    public static final int IlvPinTriangle = 256;
    public static final int IlvPinFilledTriangle = 512;
    private Vector a;
    private Color b = Color.white;
    private Color c = Color.black;
    private int d = 64;
    private int e = 4;
    private boolean f = true;

    public IlvPinLinkConnector() {
    }

    public IlvPinLinkConnector(IlvGraphic ilvGraphic) {
        this();
        this.attach(ilvGraphic, true);
    }

    public IlvPinLinkConnector(IlvLinkImage ilvLinkImage, boolean bl) {
        super(ilvLinkImage, bl);
    }

    public IlvPinLinkConnector(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(ilvInputStream);
        Object object;
        try {
            object = ilvInputStream.readPersistentObjects("pins");
            if (object != null && ((IlvPersistentObject[])object).length > 0) {
                this.a();
                for (int i2 = 0; i2 < ((IlvPersistentObject[])object).length; ++i2) {
                    IlvGrapherPin ilvGrapherPin = (IlvGrapherPin)object[i2];
                    ilvGrapherPin.a(this);
                    this.a(ilvGrapherPin, true);
                }
            }
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            object = ilvInputStream.readColor("color");
            if (object != null) {
                this.setPinColor((Color)object);
            }
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            object = ilvInputStream.readColor("XORColor");
            if (object != null) {
                this.setPinXORColor((Color)object);
            }
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.setPinType(ilvInputStream.readInt("pinType"));
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.setPinSize(ilvInputStream.readInt("pinSize"));
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
    }

    protected boolean useCache() {
        return true;
    }

    private void a() {
        this.a = new Vector(5, 5);
    }

    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        int n2;
        super.write(ilvOutputStream);
        int n3 = n2 = this.a != null ? this.a.size() : 0;
        if (n2 > 0) {
            Vector<IlvGrapherPin> vector = new Vector<IlvGrapherPin>(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                IlvGrapherPin ilvGrapherPin = (IlvGrapherPin)this.a.elementAt(i2);
                if (!ilvGrapherPin.isPersistent()) continue;
                vector.addElement(ilvGrapherPin);
            }
            if (vector.size() > 0) {
                ilvOutputStream.write("pins", vector.elements());
            }
        }
        if (this.c != null) {
            ilvOutputStream.write("color", this.getPinColor());
        }
        ilvOutputStream.write("pinType", this.getPinType());
        ilvOutputStream.write("pinSize", this.getPinSize());
    }

    public void read(IlvInputStream ilvInputStream, IlvLinkImage ilvLinkImage, boolean bl) throws IlvReadFileException {
        super.read(ilvInputStream, ilvLinkImage, bl);
        try {
            IlvGrapherPin ilvGrapherPin = (IlvGrapherPin)ilvInputStream.readPersistentObject(bl ? "fromPin" : "toPin");
            if (ilvGrapherPin != null) {
                this.connectLink(ilvLinkImage, ilvGrapherPin, bl);
            }
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
    }

    public void write(IlvOutputStream ilvOutputStream, IlvLinkImage ilvLinkImage, boolean bl) throws IOException {
        super.write(ilvOutputStream, ilvLinkImage, bl);
        IlvGrapherPin ilvGrapherPin = this.getPin(ilvLinkImage, bl);
        if (ilvGrapherPin != null && ilvGrapherPin.isPersistent()) {
            ilvOutputStream.write(bl ? "fromPin" : "toPin", ilvGrapherPin);
        }
    }

    public boolean isPersistent() {
        return true;
    }

    public final Color getPinColor() {
        return this.c;
    }

    public void setPinColor(Color color) {
        this.c = color;
    }

    public final Color getPinXORColor() {
        return this.b;
    }

    public void setPinXORColor(Color color) {
        this.b = color;
    }

    public final void addPin(IlvGrapherPin ilvGrapherPin) {
        this.a(ilvGrapherPin, false);
    }

    private void a(IlvGrapherPin ilvGrapherPin, boolean bl) {
        if (ilvGrapherPin == null) {
            throw new IllegalArgumentException("pin cannot be null");
        }
        if (!bl) {
            IlvPinLinkConnector ilvPinLinkConnector = ilvGrapherPin.getPinLinkConnector();
            if (ilvPinLinkConnector == this) {
                return;
            }
            if (ilvPinLinkConnector != null) {
                ilvPinLinkConnector.removePin(ilvGrapherPin);
            }
            ilvGrapherPin.a(this);
        }
        if (this.a == null) {
            this.a();
        }
        this.a.addElement(ilvGrapherPin);
        if (!ilvGrapherPin.zoomable()) {
            this.a(false);
        }
    }

    public final void removePin(IlvGrapherPin ilvGrapherPin) {
        if (ilvGrapherPin == null) {
            throw new IllegalArgumentException("pin cannot be null");
        }
        ilvGrapherPin.a();
        ilvGrapherPin.a(null);
        if (this.a != null) {
            this.a.removeElement(ilvGrapherPin);
            if (!ilvGrapherPin.zoomable()) {
                Enumeration enumeration = this.getPins();
                boolean bl = true;
                while (enumeration.hasMoreElements()) {
                    ilvGrapherPin = (IlvGrapherPin)enumeration.nextElement();
                    if (ilvGrapherPin.zoomable()) continue;
                    bl = false;
                }
                this.a(bl);
            }
        }
    }

    public final Enumeration getPins() {
        return this.a != null ? this.a.elements() : IlvEmptyEnumeration.instance;
    }

    public void setPinType(int n2) {
        this.d = n2;
    }

    public int getPinType() {
        return this.d;
    }

    public void setPinSize(int n2) {
        this.e = n2;
    }

    public int getPinSize() {
        return this.e;
    }

    public IlvPoint calcConnectionPoint(IlvLinkImage ilvLinkImage, boolean bl, IlvTransformer ilvTransformer) {
        IlvPoint ilvPoint;
        IlvGrapherPin ilvGrapherPin = this.getPin(ilvLinkImage, bl);
        if (ilvGrapherPin == null && (ilvGrapherPin = this.getClosestConnectionPin(ilvPoint = ilvLinkImage.getConnectionReferencePoint(bl, ilvTransformer), ilvLinkImage.getFrom(), ilvLinkImage.getTo(), ilvLinkImage, bl, ilvTransformer)) == null) {
            IlvRect ilvRect = this.getNode().boundingBox(ilvTransformer);
            return new IlvPoint(ilvRect.x + ilvRect.width / 2.0f, ilvRect.y + ilvRect.height / 2.0f);
        }
        return ilvGrapherPin.getPosition(ilvTransformer);
    }

    public IlvPoint getClosestConnectionPoint(IlvPoint ilvPoint, Object object, Object object2, Object object3, boolean bl, IlvTransformer ilvTransformer) {
        IlvGrapherPin ilvGrapherPin = this.getClosestConnectionPin(ilvPoint, object, object2, object3, bl, ilvTransformer);
        if (ilvGrapherPin == null) {
            IlvRect ilvRect = this.getNode().boundingBox(ilvTransformer);
            return new IlvPoint(ilvRect.x + ilvRect.width / 2.0f, ilvRect.y + ilvRect.height / 2.0f);
        }
        return ilvGrapherPin.getPosition(ilvTransformer);
    }

    protected boolean zoomable() {
        return this.f;
    }

    private final void a(final boolean bl) {
        if (bl == this.f) {
            return;
        }
        IlvGraphic ilvGraphic = this.getNode();
        IlvGraphicBag ilvGraphicBag = ilvGraphic.getGraphicBag();
        ilvGraphicBag.applyToObject(ilvGraphic, new IlvApplyObject(){

            public void apply(IlvGraphic ilvGraphic, Object object) {
                ((IlvPinLinkConnector)object).f = bl;
            }
        }, this, true);
    }

    public IlvGrapherPin getClosestConnectionPin(IlvPoint ilvPoint, Object object, Object object2, Object object3, boolean bl, IlvTransformer ilvTransformer) {
        if (this.a == null) {
            return null;
        }
        double d2 = 0.0;
        IlvGrapherPin ilvGrapherPin = null;
        Enumeration enumeration = this.a.elements();
        while (enumeration.hasMoreElements()) {
            IlvGrapherPin ilvGrapherPin2 = (IlvGrapherPin)enumeration.nextElement();
            if (!ilvGrapherPin2.allow(object, object2, object3, bl)) continue;
            IlvPoint ilvPoint2 = ilvGrapherPin2.getPosition(ilvTransformer);
            if (ilvGrapherPin == null) {
                ilvGrapherPin = ilvGrapherPin2;
                d2 = (ilvPoint.x - ilvPoint2.x) * (ilvPoint.x - ilvPoint2.x) + (ilvPoint.y - ilvPoint2.y) * (ilvPoint.y - ilvPoint2.y);
                continue;
            }
            double d3 = (ilvPoint.x - ilvPoint2.x) * (ilvPoint.x - ilvPoint2.x) + (ilvPoint.y - ilvPoint2.y) * (ilvPoint.y - ilvPoint2.y);
            if (!(d3 < d2)) continue;
            d2 = d3;
            ilvGrapherPin = ilvGrapherPin2;
        }
        return ilvGrapherPin;
    }

    public void connectLink(IlvLinkImage ilvLinkImage, IlvGrapherPin ilvGrapherPin, boolean bl) {
        IlvGrapherPin ilvGrapherPin2 = this.getPin(ilvLinkImage, bl);
        if (ilvGrapherPin != null && ilvGrapherPin != ilvGrapherPin2) {
            if (ilvGrapherPin2 != null) {
                ilvGrapherPin2.b(ilvLinkImage, bl);
            }
            ilvGrapherPin.a(ilvLinkImage, bl);
        }
    }

    public void disConnectLink(IlvLinkImage ilvLinkImage, boolean bl) {
        IlvGrapherPin ilvGrapherPin = this.getPin(ilvLinkImage, bl);
        if (ilvGrapherPin != null) {
            ilvGrapherPin.b(ilvLinkImage, bl);
        }
        super.disconnectLink(ilvLinkImage, bl);
    }

    public void disconnectLink(IlvLinkImage ilvLinkImage, boolean bl) {
        this.disConnectLink(ilvLinkImage, bl);
    }

    public void connectLink(IlvLinkImage ilvLinkImage, IlvPoint ilvPoint, boolean bl, IlvTransformer ilvTransformer) {
        IlvGrapherPin ilvGrapherPin = this.getPin(ilvLinkImage, bl);
        IlvGrapherPin ilvGrapherPin2 = this.getClosestConnectionPin(ilvPoint, ilvLinkImage.getFrom(), ilvLinkImage.getTo(), ilvLinkImage, bl, ilvTransformer);
        if (ilvGrapherPin2 != null && ilvGrapherPin2 != ilvGrapherPin) {
            if (ilvGrapherPin != null) {
                ilvGrapherPin.b(ilvLinkImage, bl);
            }
            ilvGrapherPin2.a(ilvLinkImage, bl);
        }
    }

    public IlvGrapherPin getPin(IlvLinkImage ilvLinkImage, boolean bl) {
        if (this.a == null) {
            return null;
        }
        Enumeration enumeration = this.a.elements();
        while (enumeration.hasMoreElements()) {
            IlvGrapherPin ilvGrapherPin = (IlvGrapherPin)enumeration.nextElement();
            if (!ilvGrapherPin.isConnected(ilvLinkImage, bl)) continue;
            return ilvGrapherPin;
        }
        return null;
    }

    public void linkRemoved(IlvLinkImage ilvLinkImage) {
        IlvGrapherPin ilvGrapherPin = this.getPin(ilvLinkImage, true);
        if (ilvGrapherPin != null) {
            ilvGrapherPin.b(ilvLinkImage, true);
        }
        if ((ilvGrapherPin = this.getPin(ilvLinkImage, false)) != null) {
            ilvGrapherPin.b(ilvLinkImage, false);
        }
        super.linkRemoved(ilvLinkImage);
    }

    protected void allLinksRemoved() {
        if (this.a != null) {
            Enumeration enumeration = this.a.elements();
            while (enumeration.hasMoreElements()) {
                IlvGrapherPin ilvGrapherPin = (IlvGrapherPin)enumeration.nextElement();
                ilvGrapherPin.a();
            }
        }
        super.allLinksRemoved();
    }

    public void drawGhost(Graphics graphics, IlvTransformer ilvTransformer, Object object, Object object2, Object object3, boolean bl) {
        graphics.setColor(this.c);
        if (this.a != null) {
            Enumeration enumeration = this.a.elements();
            while (enumeration.hasMoreElements()) {
                IlvGrapherPin ilvGrapherPin = (IlvGrapherPin)enumeration.nextElement();
                if (!ilvGrapherPin.allow(object, object2, object3, bl)) continue;
                ilvGrapherPin.drawGhost(graphics, ilvTransformer);
            }
        }
    }

    public void drawGhost(Graphics graphics, IlvTransformer ilvTransformer) {
        graphics.setColor(this.c);
        if (this.a != null) {
            Enumeration enumeration = this.a.elements();
            while (enumeration.hasMoreElements()) {
                IlvGrapherPin ilvGrapherPin = (IlvGrapherPin)enumeration.nextElement();
                ilvGrapherPin.drawGhost(graphics, ilvTransformer);
            }
        }
    }

    public IlvRect getGhostBoundingBox(IlvTransformer ilvTransformer) {
        Enumeration enumeration = this.getPins();
        if (!enumeration.hasMoreElements()) {
            return new IlvRect();
        }
        IlvGrapherPin ilvGrapherPin = (IlvGrapherPin)enumeration.nextElement();
        IlvPoint ilvPoint = ilvGrapherPin.getPosition(ilvTransformer);
        int n2 = ilvGrapherPin.getSize();
        float f2 = ilvPoint.x - (float)n2;
        float f3 = ilvPoint.x + (float)n2;
        float f4 = ilvPoint.y - (float)n2;
        float f5 = ilvPoint.y + (float)n2;
        while (enumeration.hasMoreElements()) {
            ilvGrapherPin = (IlvGrapherPin)enumeration.nextElement();
            ilvPoint = ilvGrapherPin.getPosition(ilvTransformer);
            n2 = ilvGrapherPin.getSize();
            float f6 = ilvPoint.x - (float)n2;
            if (f6 < f2) {
                f2 = f6;
            }
            if ((f6 = ilvPoint.y - (float)n2) < f4) {
                f4 = f6;
            }
            if ((f6 = ilvPoint.x + (float)n2) > f3) {
                f3 = f6;
            }
            if (!((f6 = ilvPoint.y + (float)n2) > f5)) continue;
            f5 = f6;
        }
        return new IlvRect(f2, f4, f3 - f2, f5 - f4);
    }

    public boolean supportsDrawGhost() {
        return true;
    }
}

