/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphic;

import ilog.views.IlvApplyObject;
import ilog.views.IlvFontInterface;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvManager;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvSelection;
import ilog.views.IlvTextInterface;
import ilog.views.IlvToolkit;
import ilog.views.IlvTransformer;
import ilog.views.graphic.IlvLayoutTextRenderer;
import ilog.views.graphic.IlvTextSelection;
import ilog.views.internal.IlvUtility;
import ilog.views.internal.impl.IlvUtility2D;
import ilog.views.io.IlvFieldNotFoundException;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvPersistentObject;
import ilog.views.io.IlvReadFileException;
import ilog.views.objectinteractor.IlvTextEditor;
import ilog.views.util.java2d.IlvPattern;
import ilog.views.util.java2d.IlvTexture;
import ilog.views.util.text.IlvAttributedStringUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.font.TextAttribute;
import java.awt.font.TransformAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.IOException;
import java.io.Serializable;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Map;

public class IlvText
extends IlvGraphic
implements IlvTextInterface,
IlvFontInterface {
    private static final IlvTransformer a = new IlvTransformer();
    private static final String b = "margin should be positive or equal to 0";
    private static final short c = 4;
    private static final short d = 2;
    private static final short e = 8;
    private static final short f = 16;
    private static final short g = 128;
    private static final short h = 256;
    private static final short i = 512;
    private static final short j = 1024;
    private static final short k = 6144;
    public static final short OUTLINE_ONLY = 2048;
    public static final short OUTLINE_FRONT = 6144;
    public static final short OUTLINE_BACK = 4096;
    public static final short OUTLINE_DISABLED = 0;
    private int l = 256;
    private float m;
    private float n;
    private float o;
    private float p;
    private String q = "";
    private transient AttributedString r = null;
    private transient boolean s;
    private Font t = IlvToolkit.defaultFont;
    private short u;
    private Color v;
    private float w = 100.0f;
    private float x = 100.0f;
    private short y;
    private Color z;
    private Paint aa;
    private Paint ab;
    private float ac;
    private int ad = 256;
    IlvPoint ae = new IlvPoint();
    private Renderer af;
    private IlvTransformer ag;
    private Color ah;
    private float ai = 0.0f;
    private float aj = 0.0f;
    private float ak = 0.0f;
    public static final short WRAP_NONE = 0;
    public static final short WRAP_WORD = 1;
    public static final short WRAP_TRUNCATE = 2;
    private static boolean al = false;
    private static LabelSetter am = new LabelSetter();

    public IlvText() {
        this(new IlvPoint(0.0f, 0.0f), "");
    }

    public IlvText(IlvPoint ilvPoint, String string) {
        this.q = string != null ? string : "";
        this.ae.setLocation(ilvPoint);
        this.f();
    }

    private void f() {
        this.af = new IlvLayoutTextRenderer(this);
    }

    public IlvText(IlvText ilvText) {
        super(ilvText);
        this.ag = new IlvTransformer(ilvText.ag);
        this.t = ilvText.t;
        this.q = ilvText.q;
        this.r = ilvText.r;
        this.s = ilvText.s;
        this.u = ilvText.u;
        this.ae = new IlvPoint(ilvText.ae);
        this.v = ilvText.v;
        this.ab = ilvText.ab;
        this.z = ilvText.z;
        this.ad = ilvText.ad;
        this.p = ilvText.p;
        this.o = ilvText.o;
        this.n = ilvText.n;
        this.m = ilvText.m;
        this.l = ilvText.l;
        this.y = ilvText.y;
        this.x = ilvText.x;
        this.w = ilvText.w;
        this.ac = ilvText.ac;
        this.ah = ilvText.ah;
        this.ai = ilvText.ai;
        this.aj = ilvText.aj;
        this.ak = ilvText.ak;
        this.f();
        this.a(this.ab);
        this.registerBlinkingResource(null, this.v);
        this.registerBlinkingResource(null, this.z);
        this.registerBlinkingResource(null, this.ah);
        this.g();
    }

    public IlvText(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(ilvInputStream);
        this.ag = ilvInputStream.readTransformer("transform");
        if (this.ag.isIdentity()) {
            this.ag = null;
        }
        this.t = ilvInputStream.readFont("font");
        this.q = ilvInputStream.readString("label");
        try {
            Object[] objectArray = ilvInputStream.readObjectArray("attributes", "(i(sst)*)*");
            this.a(objectArray);
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
        }
        this.u = ilvInputStream.readShort("flags");
        this.ae = ilvInputStream.readPoint("anchorPoint");
        this.v = ilvInputStream.readColor("foreground");
        this.ab = IlvUtility2D.readPaint(ilvInputStream);
        this.z = ilvInputStream.readColor("sColor");
        try {
            this.ah = ilvInputStream.readColor("outlineColor");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.ai = ilvInputStream.readFloat("outlineThickness");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.aj = ilvInputStream.readFloat("rotationAlignmentThresholdAngle");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.ak = ilvInputStream.readFloat("rotationAlignmentAngle");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.ad = ilvInputStream.readInt("aPosition");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.p = ilvInputStream.readFloat("leftMargin");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.o = ilvInputStream.readFloat("rightMargin");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.n = ilvInputStream.readFloat("topMargin");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.m = ilvInputStream.readFloat("bottomMargin");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.l = ilvInputStream.readInt("alignment");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.y = ilvInputStream.readShort("wM");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.x = ilvInputStream.readFloat("wH");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.w = ilvInputStream.readFloat("wW");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.ac = ilvInputStream.readFloat("spacing");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        this.f();
        this.a(this.ab);
        this.registerBlinkingResource(null, this.v);
        this.registerBlinkingResource(null, this.z);
        this.registerBlinkingResource(null, this.ah);
        this.g();
    }

    public IlvGraphic copy() {
        return new IlvText(this);
    }

    public void draw(Graphics graphics, IlvTransformer ilvTransformer) {
        if (this.isFillOn() || this.isStrokeOn()) {
            Cloneable cloneable;
            Object object = this.af.getBounds();
            if (this.getTopMargin() != 0.0f || this.getBottomMargin() != 0.0f || this.getLeftMargin() != 0.0f || this.getRightMargin() != 0.0f) {
                cloneable = object.getBounds2D();
                ((Rectangle2D)cloneable).setFrame(((RectangularShape)cloneable).getX() - (double)this.getLeftMargin(), ((RectangularShape)cloneable).getY() - (double)this.getTopMargin(), ((RectangularShape)cloneable).getWidth() + (double)this.getLeftMargin() + (double)this.getRightMargin(), ((RectangularShape)cloneable).getHeight() + (double)this.getTopMargin() + (double)this.getBottomMargin());
                object = cloneable;
            }
            Cloneable cloneable2 = cloneable = this.ag != null ? new IlvTransformer(this.ag) : null;
            if (cloneable != null) {
                ((IlvTransformer)cloneable).compose(ilvTransformer);
            } else {
                cloneable = ilvTransformer;
            }
            if (cloneable != null) {
                AffineTransform affineTransform = IlvUtility.IlvToJava2DTransformer((IlvTransformer)cloneable, null);
                object = affineTransform.createTransformedShape((Shape)object);
            }
            if (this.isFillOn()) {
                ((Graphics2D)graphics).setPaint(this.aa);
                ((Graphics2D)graphics).fill((Shape)object);
            }
            if (this.isStrokeOn()) {
                graphics.setColor(this.getStrokeColor());
                ((Graphics2D)graphics).draw((Shape)object);
            }
        }
        this.af.draw(graphics, ilvTransformer);
    }

    public final IlvTransformer getTransformer() {
        return this.ag != null ? new IlvTransformer(this.ag) : null;
    }

    public IlvRect boundingBox(IlvTransformer ilvTransformer) {
        IlvTransformer ilvTransformer2;
        IlvRect ilvRect = IlvUtility.Java2DToIlvRect(((IlvLayoutTextRenderer)this.af).getBounds(), null);
        if (this.getTopMargin() != 0.0f || this.getBottomMargin() != 0.0f || this.getLeftMargin() != 0.0f || this.getRightMargin() != 0.0f) {
            ilvRect.setFrame(ilvRect.x - this.getLeftMargin(), ilvRect.y - this.getTopMargin(), ilvRect.width + this.getLeftMargin() + this.getRightMargin(), ilvRect.height + this.getTopMargin() + this.getBottomMargin());
        }
        IlvTransformer ilvTransformer3 = ilvTransformer2 = this.ag != null ? new IlvTransformer(this.ag) : null;
        if (ilvTransformer2 != null) {
            ilvTransformer2.compose(ilvTransformer);
        } else {
            ilvTransformer2 = ilvTransformer;
        }
        if (ilvTransformer2 != null) {
            ilvTransformer2.boundingBox(ilvRect, false);
        }
        return ilvRect;
    }

    public void applyTransform(IlvTransformer ilvTransformer) {
        if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
            if (this.ag == null) {
                this.ag = new IlvTransformer(ilvTransformer);
            } else {
                this.ag.compose(ilvTransformer);
            }
            this.a(false, false);
        }
    }

    public void moveResize(IlvRect ilvRect) {
        if (!this.isAutoWrappingSizeMode()) {
            super.moveResize(ilvRect);
        } else {
            IlvRect ilvRect2 = this.boundingBox();
            if (!ilvRect2.equals(ilvRect)) {
                float f2 = ilvRect.x - ilvRect2.x;
                float f3 = ilvRect.y - ilvRect2.y;
                if (this.ag != null) {
                    double d2 = this.ag.zoomXFactor();
                    double d3 = this.ag.zoomYFactor();
                    if (d2 != 0.0) {
                        f2 = (float)((double)f2 / d2);
                    }
                    if (d3 != 0.0) {
                        f3 = (float)((double)f3 / d3);
                    }
                    ilvRect.width = (float)((double)ilvRect.width / d2);
                    ilvRect.height = (float)((double)ilvRect.height / d3);
                }
                if (this.ag == null) {
                    this.ag = new IlvTransformer();
                }
                this.ag.translate(f2, f3);
                this.w = Math.max(0.0f, ilvRect.width - (this.p + this.o));
                this.x = Math.max(0.0f, ilvRect.height - (this.n + this.m));
                this.a(false, true);
            }
        }
    }

    public void translate(float f2, float f3) {
        if (f2 != 0.0f || f3 != 0.0f) {
            if (!this.isAutoWrappingSizeMode()) {
                super.translate(f2, f3);
            } else {
                if (this.ag != null) {
                    double d2 = this.ag.zoomXFactor();
                    double d3 = this.ag.zoomYFactor();
                    if (d2 != 0.0) {
                        f2 = (float)((double)f2 / d2);
                    }
                    if (d3 != 0.0) {
                        f3 = (float)((double)f3 / d3);
                    }
                }
                if (this.ag == null) {
                    this.ag = new IlvTransformer();
                }
                this.ag.translate(f2, f3);
                this.a(false, true);
            }
        }
    }

    public void resize(float f2, float f3) {
        if (!this.isAutoWrappingSizeMode()) {
            super.resize(f2, f3);
        } else {
            if (this.ag != null) {
                double d2 = this.ag.zoomXFactor();
                double d3 = this.ag.zoomYFactor();
                if (d2 != 0.0) {
                    f2 = (float)((double)f2 / d2);
                }
                if (d3 != 0.0) {
                    f3 = (float)((double)f3 / d3);
                }
            }
            float f4 = Math.max(0.0f, f2 - (this.p + this.o));
            float f5 = Math.max(0.0f, f3 - (this.n + this.m));
            if (f4 != this.w || f5 != this.x) {
                this.w = f4;
                this.x = f5;
                this.a(false, true);
            }
        }
    }

    public final void setAnchorPoint(IlvPoint ilvPoint) {
        if (!this.ae.equals(ilvPoint)) {
            this.ae.setLocation(ilvPoint);
            this.a(false, true);
        }
    }

    public final IlvPoint getAnchorPoint() {
        return new IlvPoint(this.ae);
    }

    public final IlvPoint getEffectiveAnchorPoint() {
        IlvPoint ilvPoint = this.getAnchorPoint();
        if (this.getTransformer() != null) {
            this.getTransformer().apply(ilvPoint);
        }
        return ilvPoint;
    }

    public final void setAnchorPosition(int n2) {
        if (n2 != this.ad) {
            this.ad = n2;
            this.a(false, true);
        }
    }

    public final int getAnchorPosition() {
        return this.ad;
    }

    public IlvPoint[] getAnchorPoints(boolean bl, IlvTransformer ilvTransformer) {
        return this.af.getAnchorPoints(bl, ilvTransformer);
    }

    public void setLabel(String string) {
        String string2 = string != null ? string : "";
        if (!string2.equals(this.q) || this.r != null || this.s) {
            this.q = string2;
            this.r = null;
            this.s = false;
            this.a(false, true);
        }
    }

    public String getLabel() {
        return this.q;
    }

    public void setAttributedLabel(AttributedString attributedString) {
        if (attributedString == null) {
            this.r = new AttributedString("");
            this.s = false;
        } else {
            this.r = attributedString;
            this.s = true;
        }
        this.q = IlvAttributedStringUtil.getString(this.r);
        this.a(false, true);
    }

    public AttributedString getAttributedLabel() {
        if (this.r == null) {
            return new AttributedString(this.q);
        }
        return this.r;
    }

    AttributedString d() {
        return this.s ? this.r : null;
    }

    public void addLabelAttribute(AttributedCharacterIterator.Attribute attribute, Object object) {
        if (this.r == null) {
            this.r = new AttributedString(this.q);
        }
        this.r.addAttribute(attribute, object);
        this.s = true;
        this.a(false, true);
    }

    public void addLabelAttribute(AttributedCharacterIterator.Attribute attribute, Object object, int n2, int n3) {
        if (this.r == null) {
            this.r = new AttributedString(this.q);
        }
        this.r.addAttribute(attribute, object, n2, n3);
        this.s = true;
        this.a(false, true);
    }

    public void addLabelAttributes(Map map, int n2, int n3) {
        if (this.r == null) {
            this.r = new AttributedString(this.q);
        }
        this.r.addAttributes(map, n2, n3);
        this.s = true;
        this.a(false, true);
    }

    public boolean supportMultiline() {
        return true;
    }

    public IlvRect getLabelBBox(IlvTransformer ilvTransformer) {
        IlvTransformer ilvTransformer2;
        IlvRect ilvRect = IlvUtility.Java2DToIlvRect(((IlvLayoutTextRenderer)this.af).getBounds(), null);
        IlvTransformer ilvTransformer3 = ilvTransformer2 = this.ag != null ? new IlvTransformer(this.ag) : null;
        if (ilvTransformer2 != null) {
            ilvTransformer2.compose(ilvTransformer);
        } else {
            ilvTransformer2 = ilvTransformer;
        }
        if (ilvTransformer2 != null) {
            ilvTransformer2.boundingBox(ilvRect, false);
        }
        return ilvRect;
    }

    public void setFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("font should not be null");
        }
        if (!font.equals(this.t)) {
            this.t = font;
            this.a(true, true);
        }
    }

    public Font getFont() {
        return this.t;
    }

    public final boolean isAntialiasing() {
        return (this.u & 8) != 0;
    }

    public final void setAntialiasing(boolean bl) {
        if (bl != this.isAntialiasing()) {
            this.u = bl ? (short)(this.u | 8) : (short)(this.u & 0xFFFFFFF7);
            this.a(true, true);
        }
    }

    public final boolean isStrikethrough() {
        return (this.u & 0x200) != 0;
    }

    public final void setStrikethrough(boolean bl) {
        if (bl != this.isStrikethrough()) {
            this.u = bl ? (short)(this.u | 0x200) : (short)(this.u & 0xFFFFFDFF);
            this.a(false, true);
        }
    }

    public final boolean isUnderline() {
        return (this.u & 0x400) != 0;
    }

    public final void setUnderline(boolean bl) {
        if (bl != this.isUnderline()) {
            this.u = bl ? (short)(this.u | 0x400) : (short)(this.u & 0xFFFFFBFF);
            this.a(false, true);
        }
    }

    public int getOutlineMode() {
        return this.u & 0x1800;
    }

    public void setOutlineMode(int n2) {
        this.u = (short)(this.u & 0xFFFFE7FF);
        this.u = (short)(this.u | n2 & 0x1800);
    }

    public final boolean isFractionalMetrics() {
        return (this.u & 0x80) == 0;
    }

    public final void setFractionalMetrics(boolean bl) {
        if (bl != this.isFractionalMetrics()) {
            this.u = bl ? (short)(this.u & 0xFFFFFF7F) : (short)(this.u | 0x80);
            this.a(true, true);
        }
    }

    public void setForeground(Color color) {
        Color color2 = this.v;
        this.v = color;
        this.registerBlinkingResource(color2, color);
    }

    public Color getForeground() {
        return this.v != null ? this.v : Color.black;
    }

    public void setOutlineColor(Color color) {
        Color color2 = this.ah;
        this.ah = color;
        this.registerBlinkingResource(color2, color);
    }

    public Color getOutlineColor() {
        return this.ah != null ? this.ah : Color.black;
    }

    public void setBackground(Color color) {
        this.setFillPaint(color);
    }

    public void setFillPaint(Paint paint) {
        this.ab = paint;
        this.a(paint);
        this.g();
    }

    private void a(Paint paint) {
        Paint paint2 = this.aa;
        this.aa = paint;
        this.registerBlinkingResource(paint2, paint);
    }

    public Paint getFillPaint() {
        if (this.ab == null) {
            return Color.gray;
        }
        return this.ab;
    }

    private void g() {
        if (this.isFillOn()) {
            this.a(this.isPaintAbsolute() ? this.getFillPaint() : this.adaptPaint(this.boundingBox(), this.getFillPaint()));
        }
    }

    protected Paint adaptPaint(Shape shape, Paint paint) {
        return IlvUtility2D.AdaptPaint(shape, paint);
    }

    public final boolean isPaintAbsolute() {
        return (this.u & 0x10) != 0;
    }

    public final void setPaintAbsolute(boolean bl) {
        if (bl) {
            this.u = (short)(this.u | 0x10);
            this.a(this.getFillPaint());
        } else {
            this.u = (short)(this.u & 0xFFFFFFEF);
            this.g();
        }
    }

    public final void setFillOn(boolean bl) {
        if (bl) {
            this.u = (short)(this.u | 4);
            this.g();
        } else {
            this.u = (short)(this.u & 0xFFFFFFFB);
        }
    }

    public final boolean isFillOn() {
        return (this.u & 4) != 0;
    }

    public final void setStrokeOn(boolean bl) {
        this.u = bl ? (short)(this.u | 2) : (short)(this.u & 0xFFFFFFFD);
    }

    public final boolean isStrokeOn() {
        return (this.u & 2) != 0;
    }

    public final void setStrokeColor(Color color) {
        Color color2 = this.z;
        this.z = color;
        this.registerBlinkingResource(color2, color);
    }

    public final Color getStrokeColor() {
        return this.z != null ? this.z : this.getForeground();
    }

    public final void setAutoWrappingSizeMode(boolean bl) {
        this.u = bl ? (short)(this.u | 0x100) : (short)(this.u & 0xFFFFFEFF);
    }

    public final boolean isAutoWrappingSizeMode() {
        return (this.u & 0x100) != 0;
    }

    public final void setWrappingMode(short s2) {
        if (s2 != this.y) {
            this.y = s2;
            this.a(false, true);
        }
    }

    public final short getWrappingMode() {
        return this.y;
    }

    public final void setWrappingWidth(float f2) {
        if (f2 < 0.0f) {
            throw new IllegalArgumentException("must use a positive value");
        }
        if (f2 != this.w) {
            this.w = f2;
            this.a(false, true);
        }
    }

    public final float getWrappingWidth() {
        return this.w;
    }

    public final void setWrappingHeight(float f2) {
        if (f2 < 0.0f) {
            throw new IllegalArgumentException("must use a positive value");
        }
        if (f2 != this.x) {
            this.x = f2;
            this.a(false, true);
        }
    }

    public final float getWrappingHeight() {
        return this.x;
    }

    public void setOutlineThickness(float f2) {
        this.ai = f2;
    }

    public float getOutlineThickness() {
        return this.ai;
    }

    public final void setLeftMargin(float f2) {
        if (f2 < 0.0f) {
            throw new IllegalArgumentException(b);
        }
        if (this.p != f2) {
            this.p = f2;
            this.g();
        }
    }

    public final float getLeftMargin() {
        return this.p;
    }

    public final void setRightMargin(float f2) {
        if (f2 < 0.0f) {
            throw new IllegalArgumentException(b);
        }
        if (this.o != f2) {
            this.o = f2;
            this.g();
        }
    }

    public final float getRightMargin() {
        return this.o;
    }

    public final void setTopMargin(float f2) {
        if (f2 < 0.0f) {
            throw new IllegalArgumentException(b);
        }
        if (this.n != f2) {
            this.n = f2;
            this.g();
        }
    }

    public final float getTopMargin() {
        return this.n;
    }

    public final void setBottomMargin(float f2) {
        if (f2 < 0.0f) {
            throw new IllegalArgumentException(b);
        }
        if (this.m != f2) {
            this.m = f2;
            this.g();
        }
    }

    public final float getBottomMargin() {
        return this.m;
    }

    public final void setAlignment(int n2) {
        if (this.l != n2) {
            this.l = n2;
            this.a(false, true);
        }
    }

    public final int getAlignment() {
        return this.l;
    }

    public void setRotationAlignmentThresholdAngle(float f2) {
        while (f2 >= 180.0f) {
            f2 -= 180.0f;
        }
        if (f2 >= 90.0f) {
            f2 = 90.0f - f2;
        }
        this.aj = f2;
        this.a(false, true);
    }

    public final float getRotationAlignmentThresholdAngle() {
        return this.aj;
    }

    public void setRotationAlignmentAngle(float f2) {
        while (f2 >= 180.0f) {
            f2 -= 180.0f;
        }
        this.ak = f2;
        this.a(false, true);
    }

    public final float getRotationAlignmentAngle() {
        return this.ak;
    }

    public final void setInterlineSpacing(float f2) {
        this.ac = f2;
    }

    public final float getInterlineSpacing() {
        return this.ac;
    }

    private void a(boolean bl, boolean bl2) {
        if (this.af != null) {
            this.af.invalidate(bl, bl2);
        }
        this.g();
    }

    public boolean contains(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        if (super.contains(ilvPoint, ilvPoint2, ilvTransformer)) {
            return true;
        }
        return IlvText.a(this, ilvPoint2, ilvTransformer);
    }

    static boolean a(IlvGraphic ilvGraphic, IlvPoint ilvPoint, IlvTransformer ilvTransformer) {
        IlvSelection ilvSelection;
        IlvGraphicBag ilvGraphicBag = ilvGraphic.getGraphicBag();
        if (ilvGraphicBag instanceof IlvManager && (ilvSelection = ((IlvManager)ilvGraphicBag).getSelection(ilvGraphic)) instanceof IlvTextSelection) {
            return ((IlvTextSelection)ilvSelection).isOnBorder(ilvPoint, ilvTransformer);
        }
        return false;
    }

    public Shape getCaretShape(IlvTextSelection.Range range, IlvTransformer ilvTransformer) {
        return this.af.getCaretShape(range, ilvTransformer);
    }

    public int pickCharacter(IlvPoint ilvPoint, IlvTransformer ilvTransformer) {
        return this.af.pickCharacter(ilvPoint, ilvTransformer);
    }

    public int lineCount() {
        return this.af.lineCount();
    }

    public int lineOffset(int n2) {
        return this.af.lineOffset(n2);
    }

    public IlvSelection makeSelection() {
        boolean bl = true;
        boolean bl2 = (this.getWrappingMode() & 2) == 0;
        IlvGraphicBag ilvGraphicBag = this.getGraphicBag();
        if (ilvGraphicBag instanceof IlvManager && !((IlvManager)ilvGraphicBag).isEditable(this)) {
            bl2 = false;
            bl = false;
        }
        return new IlvTextSelection(this, bl, bl2){

            public String getDefaultInteractor() {
                return Editor.class.getName();
            }
        };
    }

    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        super.write(ilvOutputStream);
        ilvOutputStream.write("transform", this.ag != null ? this.ag : a);
        ilvOutputStream.write("font", this.getFont());
        ilvOutputStream.write("label", this.getLabel());
        if (this.s && this.r != null) {
            Object[] objectArray = this.h();
            ilvOutputStream.write("attributes", objectArray, "(i(sst)*)*");
        }
        ilvOutputStream.write("flags", this.u);
        ilvOutputStream.write("anchorPoint", this.ae);
        ilvOutputStream.write("foreground", this.getForeground());
        IlvUtility2D.writePaint(ilvOutputStream, this.getFillPaint());
        ilvOutputStream.write("sColor", this.getStrokeColor());
        if (this.ah != null) {
            ilvOutputStream.write("outlineColor", this.ah);
        }
        if (this.ai != 0.0f) {
            ilvOutputStream.write("outlineThickness", this.ai);
        }
        if (this.aj > 0.0f) {
            ilvOutputStream.write("rotationAlignmentThresholdAngle", this.aj);
        }
        if (this.ak > 0.0f) {
            ilvOutputStream.write("rotationAlignmentAngle", this.ak);
        }
        if (this.ad != 256) {
            ilvOutputStream.write("aPosition", this.ad);
        }
        if (this.p != 0.0f) {
            ilvOutputStream.write("leftMargin", this.p);
        }
        if (this.o != 0.0f) {
            ilvOutputStream.write("rightMargin", this.o);
        }
        if (this.n != 0.0f) {
            ilvOutputStream.write("topMargin", this.n);
        }
        if (this.m != 0.0f) {
            ilvOutputStream.write("bottomMargin", this.m);
        }
        if (this.l != 256) {
            ilvOutputStream.write("alignment", this.l);
        }
        if (this.y != 0) {
            ilvOutputStream.write("wM", this.y);
        }
        if (this.x != 100.0f) {
            ilvOutputStream.write("wH", this.x);
        }
        if (this.w != 100.0f) {
            ilvOutputStream.write("wW", this.w);
        }
        if (this.ac != -1.0f) {
            ilvOutputStream.write("spacing", this.ac);
        }
    }

    private Object[] h() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        AttributedCharacterIterator attributedCharacterIterator = this.getAttributedLabel().getIterator();
        int n2 = attributedCharacterIterator.getEndIndex();
        for (int i2 = attributedCharacterIterator.getBeginIndex(); i2 < n2; ++i2) {
            attributedCharacterIterator.setIndex(i2);
            Map<AttributedCharacterIterator.Attribute, Object> map = attributedCharacterIterator.getAttributes();
            arrayList2.clear();
            for (Map.Entry<AttributedCharacterIterator.Attribute, Object> entry : map.entrySet()) {
                TextAttribute textAttribute = (TextAttribute)entry.getKey();
                Object object = entry.getValue();
                arrayList2.add(IlvAttributedStringUtil.getTextAttributeName(textAttribute));
                if (object instanceof String) {
                    arrayList2.add("s");
                    arrayList2.add(object);
                    continue;
                }
                if (object instanceof Font) {
                    arrayList2.add("F");
                    arrayList2.add(object);
                    continue;
                }
                if (object instanceof Boolean) {
                    arrayList2.add("b");
                    arrayList2.add(object);
                    continue;
                }
                if (object instanceof Float) {
                    arrayList2.add("f");
                    arrayList2.add(object);
                    continue;
                }
                if (object instanceof Double) {
                    arrayList2.add("d");
                    arrayList2.add(object);
                    continue;
                }
                if (object instanceof Integer) {
                    arrayList2.add("i");
                    arrayList2.add(object);
                    continue;
                }
                if (object instanceof Color) {
                    arrayList2.add("c");
                    arrayList2.add(object);
                    continue;
                }
                if (object instanceof IlvPersistentObject) {
                    arrayList2.add("O");
                    arrayList2.add(object);
                    continue;
                }
                if (object instanceof GradientPaint) {
                    arrayList2.add("G");
                    arrayList2.add(object);
                    continue;
                }
                if (object instanceof IlvPattern) {
                    arrayList2.add("P");
                    arrayList2.add(object);
                    continue;
                }
                if (object instanceof IlvTexture) {
                    arrayList2.add("X");
                    arrayList2.add(object);
                    continue;
                }
                if (!(object instanceof TransformAttribute)) continue;
                AffineTransform affineTransform = ((TransformAttribute)object).getTransform();
                IlvTransformer ilvTransformer = new IlvTransformer(affineTransform.getScaleX(), affineTransform.getShearX(), affineTransform.getShearY(), affineTransform.getScaleY(), affineTransform.getTranslateX(), affineTransform.getTranslateY());
                arrayList2.add("T");
                arrayList2.add(ilvTransformer);
            }
            if (arrayList2.size() <= 0) continue;
            arrayList.add(new Integer(i2));
            arrayList.add(arrayList2.toArray());
        }
        return new Object[]{arrayList.toArray()};
    }

    private void a(Object[] objectArray) throws IlvReadFileException {
        try {
            Object[] objectArray2 = (Object[])objectArray[0];
            for (int i2 = 0; i2 < objectArray2.length; i2 += 2) {
                int n2 = (Integer)objectArray2[i2];
                Object[] objectArray3 = (Object[])objectArray2[i2 + 1];
                for (int i3 = 0; i3 < objectArray3.length; i3 += 3) {
                    String string = (String)objectArray3[i3];
                    Object object = objectArray3[i3 + 2];
                    if (object instanceof IlvTransformer) {
                        IlvTransformer ilvTransformer = (IlvTransformer)object;
                        AffineTransform affineTransform = new AffineTransform(ilvTransformer.getx11(), ilvTransformer.getx21(), ilvTransformer.getx12(), ilvTransformer.getx22(), ilvTransformer.getx0(), ilvTransformer.gety0());
                        object = new TransformAttribute(affineTransform);
                    }
                    this.addLabelAttribute(IlvAttributedStringUtil.getTextAttribute(string), object, n2, n2 + 1);
                }
            }
        }
        catch (Exception exception) {
            throw new IlvReadFileException("Illegal attributes for attributed string.\nMessage: " + exception.getMessage(), exception);
        }
    }

    public static void SetTransformerDependentRendering(boolean bl) {
        al = bl;
    }

    public static boolean IsTransformerDependentRendering() {
        return al;
    }

    private static final class LabelSetter
    implements IlvApplyObject {
        public void apply(IlvGraphic ilvGraphic, Object object) {
            AttributedString attributedString = (AttributedString)object;
            if (!(ilvGraphic instanceof IlvText)) {
                throw new IllegalArgumentException("object must be IlvText");
            }
            ((IlvText)ilvGraphic).setAttributedLabel(attributedString);
        }
    }

    public static class Editor
    extends IlvTextEditor {
        protected void deleteSelection(IlvTextInterface ilvTextInterface, int n2, int n3) {
            IlvText ilvText = (IlvText)ilvTextInterface;
            if (ilvText.d() == null) {
                super.deleteSelection(ilvTextInterface, n2, n3);
                return;
            }
            int n4 = ilvText.getLabel().length();
            AttributedString attributedString = ilvText.getAttributedLabel();
            if (n2 < 0) {
                n2 = 0;
            }
            if (n2 >= n4) {
                return;
            }
            AttributedString attributedString2 = n3 >= n4 || n3 <= n2 ? IlvAttributedStringUtil.substring(attributedString, 0, n2) : IlvAttributedStringUtil.concat(IlvAttributedStringUtil.substring(attributedString, 0, n2), IlvAttributedStringUtil.substring(attributedString, n3, n4));
            this.a((IlvGraphic)((Object)ilvTextInterface), attributedString2);
        }

        protected void replaceSelection(IlvTextInterface ilvTextInterface, int n2, int n3, String string) {
            IlvText ilvText = (IlvText)ilvTextInterface;
            if (ilvText.d() == null) {
                super.replaceSelection(ilvTextInterface, n2, n3, string);
                return;
            }
            int n4 = ilvText.getLabel().length();
            AttributedString attributedString = ilvText.getAttributedLabel();
            if (n2 < 0) {
                n2 = 0;
            }
            if (n2 > n4) {
                n2 = n4;
            }
            AttributedString attributedString2 = n3 >= n4 || n3 < n2 ? IlvAttributedStringUtil.concat(IlvAttributedStringUtil.substring(attributedString, 0, n2), string) : IlvAttributedStringUtil.concat(IlvAttributedStringUtil.substring(attributedString, 0, n2), string, IlvAttributedStringUtil.substring(attributedString, n3, n4));
            this.a((IlvGraphic)((Object)ilvTextInterface), attributedString2);
        }

        protected void replaceSelection(IlvTextInterface ilvTextInterface, int n2, int n3, AttributedString attributedString) {
            IlvText ilvText = (IlvText)ilvTextInterface;
            int n4 = ilvText.getLabel().length();
            AttributedString attributedString2 = ilvText.getAttributedLabel();
            if (n2 < 0) {
                n2 = 0;
            }
            if (n2 > n4) {
                n2 = n4;
            }
            AttributedString attributedString3 = n3 >= n4 || n3 < n2 ? IlvAttributedStringUtil.concat(IlvAttributedStringUtil.substring(attributedString2, 0, n2), attributedString) : IlvAttributedStringUtil.concat(IlvAttributedStringUtil.substring(attributedString2, 0, n2), attributedString, IlvAttributedStringUtil.substring(attributedString2, n3, n4));
            this.a((IlvGraphic)((Object)ilvTextInterface), attributedString3);
        }

        protected void copySelection(IlvTextInterface ilvTextInterface, int n2, int n3) {
            IlvText ilvText = (IlvText)ilvTextInterface;
            if (ilvText.d() == null) {
                super.copySelection(ilvTextInterface, n2, n3);
                return;
            }
            if (n2 < 0) {
                return;
            }
            String string = ilvTextInterface.getLabel();
            if (n3 >= string.length()) {
                n3 = string.length();
            }
            if (n2 >= n3) {
                return;
            }
            AttributedString attributedString = IlvAttributedStringUtil.substring(ilvText.getAttributedLabel(), n2, n3);
            Transferable transferable = IlvAttributedStringUtil.getTransferable(attributedString);
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(transferable, this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void a(IlvGraphic ilvGraphic, AttributedString attributedString) {
            IlvGraphicBag ilvGraphicBag = ilvGraphic.getGraphicBag();
            IlvGraphicBag ilvGraphicBag2 = ilvGraphic.getTopLevelGraphicBag();
            IlvManager ilvManager = null;
            if (ilvGraphicBag2 != ilvGraphicBag && ilvGraphicBag2 != null) {
                ilvManager = (IlvManager)ilvGraphicBag2;
                ilvManager.setContentsAdjusting(true);
            }
            try {
                ilvGraphicBag.applyToObject(ilvGraphic, am, attributedString, true);
            }
            finally {
                if (ilvManager != null) {
                    ilvManager.setContentsAdjusting(false);
                }
            }
        }
    }

    static interface Renderer
    extends Serializable {
        public void draw(Graphics var1, IlvTransformer var2);

        public void invalidate(boolean var1, boolean var2);

        public Rectangle2D getBounds();

        public Shape getCaretShape(IlvTextSelection.Range var1, IlvTransformer var2);

        public int pickCharacter(IlvPoint var1, IlvTransformer var2);

        public int lineCount();

        public int lineOffset(int var1);

        public IlvPoint[] getAnchorPoints(boolean var1, IlvTransformer var2);
    }
}

