/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphic;

import ilog.views.IlvGraphic;
import ilog.views.IlvPoint;
import ilog.views.IlvPolyPointsInterface;
import ilog.views.IlvPolyPointsSelection;
import ilog.views.IlvRect;
import ilog.views.IlvSelection;
import ilog.views.IlvTransformer;
import ilog.views.graphic.IlvGeneralPathSelection;
import ilog.views.internal.IlvBoundingBoxCache;
import ilog.views.internal.IlvDrawWithBufferedImage;
import ilog.views.internal.IlvUtility;
import ilog.views.internal.impl.IlvUtility2D;
import ilog.views.io.IlvFieldNotFoundException;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvPersistentObject;
import ilog.views.io.IlvReadFileException;
import ilog.views.linkconnector.IlvClippingUtil;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.IOException;
import java.io.Serializable;

public class IlvGeneralPath
extends IlvGraphic
implements IlvPolyPointsInterface {
    private static final int a = 1;
    private static final int b = 2;
    private static final int c = 4;
    private static final int d = 8;
    private static final int e = 16;
    private static final int f = 32;
    private static final int g = 64;
    private static final int h = 128;
    private static final int i = 256;
    private static final int j = 512;
    private static final int k = 1024;
    private static final int l = 2048;
    private int m;
    Paint n;
    private Paint o;
    Paint p;
    private Paint q;
    private transient Stroke r;
    private int s;
    private transient Rectangle2D t;
    private transient Rectangle2D u;
    private IlvTransformer v;
    private transient Shape w;
    private IlvTransformer x = new IlvTransformer();
    private boolean y = false;
    private float z;
    private float aa = 1.0f;
    private IlvBoundingBoxCache ab = new IlvBoundingBoxCache(3);
    private static AffineTransform ac = new AffineTransform();
    private static Boolean ad = new Boolean(true);
    private static transient Stroke ae;

    public IlvGeneralPath() {
        this(new Rectangle2D.Float(0.0f, 0.0f, 100.0f, 100.0f));
    }

    public IlvGeneralPath(Shape shape) {
        if (shape == null) {
            throw new IllegalArgumentException("shape cannot be null");
        }
        this.setInternalShape(shape);
        this.setPointEditionAllowed(!(shape instanceof RectangularShape) && !(shape instanceof Rectangle));
        this.setFillOn(true);
        this.setStrokeOn(true);
        this.h(true);
    }

    public IlvGeneralPath(IlvGeneralPath ilvGeneralPath) {
        super(ilvGeneralPath);
        this.r = ilvGeneralPath.r;
        this.o = ilvGeneralPath.o;
        this.s = ilvGeneralPath.s;
        this.q = ilvGeneralPath.q;
        this.v = ilvGeneralPath.v == null ? null : new IlvTransformer(ilvGeneralPath.v);
        this.setTransformedShapeMode(ilvGeneralPath.isTransformedShapeMode());
        this.z = ilvGeneralPath.z;
        this.setInternalShape(new GeneralPath(ilvGeneralPath.w));
        this.setClip(ilvGeneralPath.getClip());
        this.setAlpha(ilvGeneralPath.aa);
    }

    public IlvGeneralPath(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(ilvInputStream);
        this.setInternalShape(ilvInputStream.readShape("path", "windingRule"));
        this.setStrokeOn(ilvInputStream.readBoolean("strokeOn"));
        try {
            this.setStroke(ilvInputStream.readStroke("stroke"));
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            try {
                this.setStroke((Stroke)((Object)ilvInputStream.readPersistentObject("pstroke")));
            }
            catch (IlvFieldNotFoundException ilvFieldNotFoundException2) {
                // empty catch block
            }
        }
        this.setStrokePaint(IlvUtility2D.readStrokePaint(ilvInputStream));
        this.setFillOn(ilvInputStream.readBoolean("fillOn"));
        this.setFillPaint(IlvUtility2D.readPaint(ilvInputStream));
        try {
            this.setPaintZoomed(ilvInputStream.readBoolean("zoomPaint"));
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.setPaintAbsolute(ilvInputStream.readBoolean("absolutePaint"));
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.setPointEditionAllowed(ilvInputStream.readBoolean("movePoint"));
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.setTransformer(ilvInputStream.readTransformer("transform"));
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.setClip(ilvInputStream.readShape("clip", "clipRule"));
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.setMaximumStrokeWidth(ilvInputStream.readFloat("maxwidth"));
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.setContainsWhenNotFilled(ilvInputStream.readBoolean("contains"));
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.x = ilvInputStream.readTransformer("applyTransformer");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.setTransformedShapeMode(ilvInputStream.readBoolean("transformedShapeMode"));
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.setAlpha(ilvInputStream.readFloat("alpha"));
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
    }

    public Shape getShape() {
        return this.w;
    }

    public void setShape(Shape shape) {
        if (shape == null) {
            throw new IllegalArgumentException("shape cannot be null");
        }
        if (this.y) {
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.setTransform(this.x.getx11(), this.x.getx21(), this.x.getx12(), this.x.getx22(), this.x.getx0(), this.x.gety0());
            this.w = affineTransform.createTransformedShape(shape);
            if (this.getClip() != null) {
                this.setClip(affineTransform.createTransformedShape(this.getClip()));
            }
        } else {
            this.w = shape;
        }
        this.a(this.a(this.w, this.getFillPaint()));
        this.b(this.a(this.w, this.getStrokePaint()));
        this.e(false);
        this.d(false);
        this.j();
    }

    protected void setInternalShape(Shape shape) {
        if (shape == null) {
            throw new IllegalArgumentException("shape cannot be null");
        }
        this.w = shape;
        this.a(this.a(shape, this.getFillPaint()));
        this.b(this.a(shape, this.getStrokePaint()));
        this.e(false);
        this.d(false);
        this.j();
    }

    public final IlvTransformer getTransformer() {
        return this.v == null ? new IlvTransformer() : new IlvTransformer(this.v);
    }

    public final void setTransformer(IlvTransformer ilvTransformer) {
        if (ilvTransformer == null || ilvTransformer.isIdentity()) {
            this.v = null;
        } else {
            if (this.v == null) {
                this.v = new IlvTransformer();
            }
            this.v.setValues(ilvTransformer.getx11(), ilvTransformer.getx12(), ilvTransformer.getx21(), ilvTransformer.getx22(), ilvTransformer.getx0(), ilvTransformer.gety0());
        }
        this.d(false);
    }

    public boolean isFillOn() {
        return (this.s & 4) != 0;
    }

    public void setFillOn(boolean bl) {
        this.s = bl ? (this.s |= 4) : (this.s &= 0xFFFFFFFB);
    }

    public boolean isStrokeOn() {
        return (this.s & 2) != 0;
    }

    public void setStrokeOn(boolean bl) {
        this.s = bl ? (this.s |= 2) : (this.s &= 0xFFFFFFFD);
        this.c(false);
    }

    public void setStroke(Stroke stroke) {
        this.r = stroke;
        this.h(stroke instanceof BasicStroke || stroke == null);
        this.c(false);
    }

    public Stroke getStroke() {
        return this.r;
    }

    public void setMaximumStrokeWidth(float f2) {
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        this.z = f2;
        this.c(false);
    }

    public float getMaximumStrokeWidth() {
        return this.z;
    }

    final Stroke a(IlvTransformer ilvTransformer) {
        BasicStroke basicStroke;
        Stroke stroke = this.getStroke();
        if (stroke == null) {
            if (ae == null) {
                ae = new BasicStroke(1.0f);
            }
            stroke = ae;
        } else if (!this.d()) {
            return stroke;
        }
        if (this.z == 0.0f) {
            return stroke;
        }
        double d2 = ilvTransformer == null ? 1.0 : ilvTransformer.zoomFactor();
        if (d2 * (double)(basicStroke = (BasicStroke)stroke).getLineWidth() > (double)this.z) {
            return new BasicStroke((float)((double)this.z / d2), basicStroke.getEndCap(), basicStroke.getLineJoin(), basicStroke.getMiterLimit(), basicStroke.getDashArray(), basicStroke.getDashPhase());
        }
        return stroke;
    }

    public void setFillPaint(Paint paint) {
        this.o = paint;
        this.a(this.a(this.getShape(), this.getFillPaint()));
    }

    private void a(Paint paint) {
        Paint paint2 = this.n;
        this.n = paint;
        this.registerBlinkingResource(paint2, paint);
    }

    public Paint getFillPaint() {
        return this.o == null ? Color.black : this.o;
    }

    public void setStrokePaint(Paint paint) {
        this.q = paint;
        this.b(this.a(this.getShape(), this.getStrokePaint()));
    }

    private void b(Paint paint) {
        Paint paint2 = this.p;
        this.p = paint;
        this.registerBlinkingResource(paint2, paint);
    }

    public Paint getStrokePaint() {
        return this.q == null ? Color.black : this.q;
    }

    public boolean isPaintZoomed() {
        return (this.s & 0x10) == 0;
    }

    public void setPaintZoomed(boolean bl) {
        this.s = !bl ? (this.s |= 0x10) : (this.s &= 0xFFFFFFEF);
    }

    public boolean isPaintAbsolute() {
        return (this.s & 0x20) != 0;
    }

    public void setPaintAbsolute(boolean bl) {
        if (bl) {
            this.s |= 0x20;
            this.a(this.getFillPaint());
            this.b(this.getStrokePaint());
        } else {
            this.s &= 0xFFFFFFDF;
            this.a(this.a(this.getShape(), this.getFillPaint()));
            this.b(this.a(this.getShape(), this.getStrokePaint()));
        }
    }

    public boolean isContainsWhenNotFilled() {
        return (this.s & 8) != 0;
    }

    public void setContainsWhenNotFilled(boolean bl) {
        this.s = bl ? (this.s |= 8) : (this.s &= 0xFFFFFFF7);
    }

    private boolean e() {
        return (this.s & 1) != 0;
    }

    private void c(boolean bl) {
        if (bl) {
            this.s |= 1;
        } else {
            this.s &= 0xFFFFFFFE;
            this.ab.setInvalid();
        }
    }

    private boolean f() {
        return (this.s & 0x200) != 0;
    }

    private void d(boolean bl) {
        if (bl) {
            this.s |= 0x200;
        } else {
            this.s &= 0xFFFFFDFF;
            this.c(false);
        }
    }

    private boolean g() {
        return (this.s & 0x80) != 0;
    }

    private void e(boolean bl) {
        this.s = bl ? (this.s |= 0x80) : (this.s &= 0xFFFFFF7F);
    }

    private boolean h() {
        return (this.s & 0x400) != 0;
    }

    private void f(boolean bl) {
        this.s = bl ? (this.s |= 0x400) : (this.s &= 0xFFFFFBFF);
    }

    private boolean i() {
        return (this.s & 0x800) != 0;
    }

    private void g(boolean bl) {
        this.s = bl ? (this.s |= 0x800) : (this.s &= 0xFFFFF7FF);
    }

    private void j() {
        boolean bl = false;
        boolean bl2 = false;
        PathIterator pathIterator = this.getShape().getPathIterator(null);
        float[] fArray = new float[6];
        while (!pathIterator.isDone()) {
            switch (pathIterator.currentSegment(fArray)) {
                case 0: {
                    bl = true;
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    bl2 = true;
                }
            }
            if (bl2) break;
            pathIterator.next();
        }
        this.g(bl && !bl2);
    }

    final boolean d() {
        return (this.s & 0x100) != 0;
    }

    private void h(boolean bl) {
        this.s = bl ? (this.s |= 0x100) : (this.s &= 0xFFFFFEFF);
    }

    public void setForeground(Color color) {
        this.setStrokePaint(color);
    }

    public void setBackground(Color color) {
        this.setFillPaint(color);
    }

    public void setClip(Shape shape) {
        this.setProperty("__ClipProperty", shape);
    }

    public Shape getClip() {
        return (Shape)this.getProperty("__ClipProperty");
    }

    public void setAlpha(float f2) {
        if (f2 > 1.0f || f2 < 0.0f) {
            throw new IllegalArgumentException("alpha must be in the range [0.0, 1.0]");
        }
        this.aa = f2;
    }

    public float getAlpha() {
        return this.aa;
    }

    public void draw(Graphics graphics, IlvTransformer ilvTransformer) {
        float f2 = this.getAlpha();
        boolean bl = false;
        Composite composite = null;
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (f2 != 1.0f) {
            composite = graphics2D.getComposite();
            if (composite instanceof AlphaComposite && composite != AlphaComposite.Xor) {
                bl = true;
            }
            if (bl) {
                IlvUtility2D.SetAlphaComposite(graphics, f2);
            }
        }
        if (bl) {
            this.aa = 1.0f;
            IlvDrawWithBufferedImage.drawWithBufferedImage(this, graphics2D, ilvTransformer);
            this.aa = f2;
        } else {
            this.a(graphics2D, ilvTransformer);
        }
        if (bl && f2 != 1.0f) {
            graphics2D.setComposite(composite);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(Graphics graphics, IlvTransformer ilvTransformer) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        AffineTransform affineTransform = null;
        Paint paint = null;
        Stroke stroke = null;
        Shape shape = null;
        Shape shape2 = this.getShape();
        Shape shape3 = this.getClip();
        boolean bl = !this.isPaintZoomed();
        affineTransform = graphics2D.getTransform();
        IlvTransformer ilvTransformer2 = this.getTransformer();
        Boolean bl2 = ad;
        synchronized (bl2) {
            Object object;
            Shape shape4;
            if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
                ilvTransformer2.compose(ilvTransformer);
            }
            if (!ilvTransformer2.isIdentity()) {
                ac.setTransform(ilvTransformer2.getx11(), ilvTransformer2.getx21(), ilvTransformer2.getx12(), ilvTransformer2.getx22(), ilvTransformer2.getx0(), ilvTransformer2.gety0());
                if (shape3 != null) {
                    shape3 = ac.createTransformedShape(shape3);
                }
            } else {
                ac.setToIdentity();
            }
            if (shape3 != null) {
                shape = graphics2D.getClip();
            }
            if (this.isFillOn()) {
                shape4 = shape2;
                object = this.n;
                paint = graphics2D.getPaint();
                boolean bl3 = bl = bl && !(object instanceof Color) && ilvTransformer != null && !ilvTransformer2.isIdentity();
                if (bl) {
                    if (shape3 != null) {
                        graphics2D.clip(shape3);
                    }
                    shape4 = ac.createTransformedShape(shape4);
                    graphics2D.setPaint(this.a(shape4, (Paint)object));
                } else {
                    if (shape3 != null) {
                        graphics2D.clip(shape3);
                    }
                    graphics2D.transform(ac);
                    graphics2D.setPaint((Paint)object);
                }
                graphics2D.fill(shape4);
                graphics2D.setPaint(paint);
                graphics2D.setTransform(affineTransform);
                if (shape3 != null) {
                    graphics2D.setClip(shape);
                }
            }
            if (this.isStrokeOn()) {
                shape4 = shape2;
                object = this.a(ilvTransformer);
                Paint paint2 = this.p;
                paint = graphics2D.getPaint();
                stroke = graphics2D.getStroke();
                boolean bl4 = bl = bl && object != null && !(paint2 instanceof Color) && ilvTransformer != null && !ilvTransformer2.isIdentity();
                if (bl) {
                    if (shape3 != null) {
                        graphics2D.clip(shape3);
                    }
                    shape4 = object.createStrokedShape(shape2);
                    shape4 = ac.createTransformedShape(shape4);
                    graphics2D.setPaint(this.a(shape4, paint2));
                    graphics2D.fill(shape4);
                } else {
                    if (shape3 != null) {
                        graphics2D.clip(shape3);
                    }
                    graphics2D.transform(ac);
                    if (object != null) {
                        graphics2D.setStroke((Stroke)object);
                    }
                    graphics2D.setPaint(paint2);
                    graphics2D.draw(shape2);
                    if (object != null) {
                        graphics2D.setStroke(stroke);
                    }
                }
                graphics2D.setPaint(paint);
                graphics2D.setTransform(affineTransform);
                if (shape3 != null) {
                    graphics2D.setClip(shape);
                }
            }
        }
    }

    private Paint a(Shape shape, Paint paint) {
        return this.isPaintAbsolute() ? paint : this.adaptPaint(shape, paint);
    }

    protected Paint adaptPaint(Shape shape, Paint paint) {
        return IlvUtility2D.AdaptPaint(shape, paint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        Cloneable cloneable;
        if (this.ab.contains(ilvTransformer)) {
            cloneable = this.boundingBox(ilvTransformer);
            if (ilvPoint2.x < ((Rectangle2D.Float)cloneable).x) {
                return false;
            }
            if (ilvPoint2.x > ((Rectangle2D.Float)cloneable).x + ((Rectangle2D.Float)cloneable).width) {
                return false;
            }
            if (ilvPoint2.y < ((Rectangle2D.Float)cloneable).y) {
                return false;
            }
            if (ilvPoint2.y > ((Rectangle2D.Float)cloneable).y + ((Rectangle2D.Float)cloneable).height) {
                return false;
            }
        }
        cloneable = this.getTransformer();
        Shape shape = this.getShape();
        Shape shape2 = this.getClip();
        Boolean bl = ad;
        synchronized (bl) {
            if (!((IlvTransformer)cloneable).isIdentity()) {
                ac.setTransform(((IlvTransformer)cloneable).getx11(), ((IlvTransformer)cloneable).getx21(), ((IlvTransformer)cloneable).getx12(), ((IlvTransformer)cloneable).getx22(), ((IlvTransformer)cloneable).getx0(), ((IlvTransformer)cloneable).gety0());
                shape = ac.createTransformedShape(shape);
                if (shape2 != null) {
                    shape2 = ac.createTransformedShape(shape2);
                }
            }
            if (shape2 != null && !shape2.contains(ilvPoint)) {
                return false;
            }
            if (this.z == 0.0f || !this.isStrokeOn() || !this.d()) {
                if (this.e() && !this.t.contains(ilvPoint)) {
                    return false;
                }
            } else if (this.f() && !this.u.contains(ilvPoint)) {
                return false;
            }
            if ((this.isFillOn() || this.isContainsWhenNotFilled()) && shape.contains(ilvPoint)) {
                return true;
            }
            if (this.isStrokeOn()) {
                Stroke stroke = this.a(ilvTransformer);
                shape = stroke.createStrokedShape(this.getShape());
                if (!((IlvTransformer)cloneable).isIdentity()) {
                    shape = ac.createTransformedShape(shape);
                }
                if (this.d()) {
                    float f2 = ((BasicStroke)stroke).getLineWidth();
                    if (ilvTransformer != null) {
                        if (!((IlvTransformer)cloneable).isIdentity()) {
                            ((IlvTransformer)cloneable).compose(ilvTransformer);
                        } else {
                            cloneable = ilvTransformer;
                        }
                    }
                    if (!((IlvTransformer)cloneable).isIdentity()) {
                        f2 = (float)((double)f2 * ((IlvTransformer)cloneable).zoomFactor());
                    }
                    if (f2 < 4.0f) {
                        double d2 = 2.0;
                        if (!((IlvTransformer)cloneable).isIdentity()) {
                            d2 /= ((IlvTransformer)cloneable).zoomFactor();
                        }
                        Rectangle2D.Double double_ = new Rectangle2D.Double((double)ilvPoint.x - d2, (double)ilvPoint.y - d2, 2.0 * d2, 2.0 * d2);
                        return shape.intersects(double_);
                    }
                    return shape.contains(ilvPoint);
                }
                if (shape.contains(ilvPoint)) {
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void k() {
        Shape shape = this.getShape();
        if (!this.f()) {
            this.l();
        }
        Rectangle2D.Float float_ = new Rectangle2D.Float();
        float_.setRect(this.u);
        if (this.isStrokeOn() && this.m()) {
            Object object;
            Stroke stroke = this.r;
            if (stroke == null) {
                if (ae == null) {
                    ae = new BasicStroke(1.0f);
                }
                stroke = ae;
            }
            if (this.d() && (this.v == null || this.v.isIdentity())) {
                int n2;
                object = (BasicStroke)stroke;
                float f2 = ((BasicStroke)object).getLineWidth();
                float f3 = ((BasicStroke)object).getMiterLimit();
                int n3 = ((BasicStroke)object).getLineJoin();
                if (n3 != (n2 = 0) || n3 == n2 && f3 <= 1.0f) {
                    Rectangle2D.Float float_2 = new Rectangle2D.Float();
                    float_2.setRect(float_);
                    float_2.x -= f2;
                    float_2.y -= f2;
                    float_2.width += 2.0f * f2;
                    float_2.height += 2.0f * f2;
                    float_.add(float_2);
                    this.t = float_;
                    this.c(true);
                    return;
                }
            }
            shape = stroke.createStrokedShape(this.getShape());
            if (this.v != null && !this.v.isIdentity()) {
                object = ad;
                synchronized (object) {
                    ac.setTransform(this.v.getx11(), this.v.getx21(), this.v.getx12(), this.v.getx22(), this.v.getx0(), this.v.gety0());
                    shape = ac.createTransformedShape(shape);
                }
            }
            if (!((RectangularShape)(object = shape.getBounds2D())).isEmpty() || !this.i()) {
                float_.add((Rectangle2D)object);
            }
        }
        this.t = float_;
        this.c(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void l() {
        Shape shape = this.getShape();
        if (shape == null) {
            throw new RuntimeException("getShape() must not return null");
        }
        if (this.v != null && !this.v.isIdentity()) {
            Boolean bl = ad;
            synchronized (bl) {
                ac.setTransform(this.v.getx11(), this.v.getx21(), this.v.getx12(), this.v.getx22(), this.v.getx0(), this.v.gety0());
                shape = ac.createTransformedShape(shape);
            }
        }
        this.u = shape.getBounds2D();
    }

    private boolean m() {
        return this.z == 0.0f || !this.d();
    }

    public IlvRect boundingBox(IlvTransformer ilvTransformer) {
        IlvRect ilvRect = this.ab.get(ilvTransformer);
        if (ilvRect == null) {
            ilvRect = this.calcBoundingBox(ilvTransformer);
            this.ab.put(ilvTransformer, ilvRect);
        }
        return ilvRect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IlvRect calcBoundingBox(IlvTransformer ilvTransformer) {
        if (!this.e()) {
            this.k();
        }
        IlvRect ilvRect = new IlvRect((float)this.t.getX(), (float)this.t.getY(), (float)this.t.getWidth(), (float)this.t.getHeight());
        if (this.isStrokeOn() && !this.m()) {
            int n2;
            Object object;
            int n3;
            Stroke stroke = this.a(ilvTransformer);
            if (stroke == null) {
                if (ae == null) {
                    ae = new BasicStroke(1.0f);
                }
                stroke = ae;
            }
            IlvRect ilvRect2 = null;
            if ((this.v == null || this.v.isIdentity()) && ((n3 = ((BasicStroke)(object = (BasicStroke)stroke)).getLineJoin()) != (n2 = 0) || n3 == n2 && ((BasicStroke)object).getMiterLimit() <= 1.0f)) {
                float f2 = ((BasicStroke)object).getLineWidth();
                ilvRect2 = new IlvRect(ilvRect);
                ilvRect2.x -= f2;
                ilvRect2.y -= f2;
                ilvRect2.width += 2.0f * f2;
                ilvRect2.height += 2.0f * f2;
                ilvRect.add(ilvRect2);
            }
            if (ilvRect2 == null) {
                Rectangle2D rectangle2D;
                object = this.getShape();
                object = stroke.createStrokedShape((Shape)object);
                if (this.v != null && !this.v.isIdentity()) {
                    Boolean bl = ad;
                    synchronized (bl) {
                        ac.setTransform(this.v.getx11(), this.v.getx21(), this.v.getx12(), this.v.getx22(), this.v.getx0(), this.v.gety0());
                        object = ac.createTransformedShape((Shape)object);
                    }
                }
                if (!(rectangle2D = object.getBounds2D()).isEmpty() || !this.i()) {
                    ilvRect2 = new IlvRect((float)rectangle2D.getX(), (float)rectangle2D.getY(), (float)rectangle2D.getWidth(), (float)rectangle2D.getHeight());
                    ilvRect.add(ilvRect2);
                }
            }
        }
        if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
            ilvTransformer.boundingBox(ilvRect, false);
        }
        if (ilvRect.height < 1.0E-20f) {
            ilvRect.height = 1.0E-20f;
        }
        if (ilvRect.width < 1.0E-20f) {
            ilvRect.width = 1.0E-20f;
        }
        return ilvRect;
    }

    public IlvRect getShapeBounds(IlvTransformer ilvTransformer) {
        if (!this.f()) {
            this.l();
        }
        IlvRect ilvRect = new IlvRect((float)this.u.getX(), (float)this.u.getY(), (float)this.u.getWidth(), (float)this.u.getHeight());
        if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
            ilvTransformer.boundingBox(ilvRect, false);
        }
        return ilvRect;
    }

    public IlvPoint getIntersectionWithOutline(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        Stroke stroke;
        if (ilvPoint == null || ilvPoint2 == null) {
            return null;
        }
        if (ilvPoint.equals(ilvPoint2)) {
            return new IlvPoint(ilvPoint);
        }
        float f2 = 0.0f;
        if (this.isStrokeOn() && (stroke = this.a(ilvTransformer)) instanceof BasicStroke) {
            f2 = ((BasicStroke)stroke).getLineWidth();
        }
        return IlvClippingUtil.getClippedPoint(this.getShape().getPathIterator(null), ilvTransformer, f2, ilvPoint, ilvPoint2);
    }

    public void moveResize(IlvRect ilvRect) {
        this.a(ilvRect);
        IlvUtility.correctMoveResizeNonzoomableGraphic(this, ilvRect, true, true);
    }

    private void a(IlvRect ilvRect) {
        BasicStroke basicStroke = null;
        if (this.boundingBox(null).equals(ilvRect)) {
            return;
        }
        IlvRect ilvRect2 = this.getShapeBounds(null);
        IlvRect ilvRect3 = new IlvRect(ilvRect);
        if (this.isStrokeOn() && this.d() && (basicStroke = (BasicStroke)this.a((IlvTransformer)null)) != null) {
            float f2 = basicStroke.getLineWidth() / 2.0f;
            float f3 = Math.min(f2, ilvRect3.width / 2.0f);
            float f4 = Math.min(f2, ilvRect3.height / 2.0f);
            ilvRect3.x += f3;
            ilvRect3.y += f4;
            ilvRect3.width -= 2.0f * f3;
            ilvRect3.height -= 2.0f * f4;
        }
        if (!ilvRect2.equals(ilvRect3)) {
            IlvUtility.adjustToAvoidZeroSize(ilvRect2);
            IlvUtility.adjustToAvoidZeroSize(ilvRect3);
            IlvTransformer ilvTransformer = new IlvTransformer();
            IlvTransformer.computeTransformer(ilvRect2, ilvRect3, ilvTransformer);
            if (!ilvTransformer.isBad()) {
                this.applyTransform(ilvTransformer);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void resize(float var1_1, float var2_2) {
        var3_3 = this.boundingBox(null);
        IlvUtility.adjustToAvoidZeroSize(var3_3);
        if (!(0.0f <= var1_1)) ** GOTO lbl-1000
        if (var1_1 < 0.1f) {
            var1_1 = 0.1f;
        } else if (0.0f >= var1_1) {
            if (var1_1 > -0.1f) {
                var1_1 = -0.1f;
            }
        }
        if (!(0.0f <= var2_2)) ** GOTO lbl-1000
        if (var2_2 < 0.1f) {
            var2_2 = 0.1f;
        } else if (0.0f >= var2_2) {
            if (var2_2 > -0.1f) {
                var2_2 = -0.1f;
            }
        }
        this.scale((double)var1_1 / (double)var3_3.width, (double)var2_2 / (double)var3_3.height);
    }

    public void setShapeBounds(IlvRect ilvRect) {
        IlvRect ilvRect2;
        if (!this.f()) {
            this.l();
        }
        if (!(ilvRect2 = new IlvRect((float)this.u.getX(), (float)this.u.getY(), (float)this.u.getWidth(), (float)this.u.getHeight())).equals(ilvRect)) {
            IlvRect ilvRect3 = new IlvRect(ilvRect);
            IlvUtility.adjustToAvoidZeroSize(ilvRect2);
            IlvUtility.adjustToAvoidZeroSize(ilvRect3);
            IlvTransformer ilvTransformer = new IlvTransformer();
            IlvTransformer.computeTransformer(ilvRect2, ilvRect3, ilvTransformer);
            if (!ilvTransformer.isBad()) {
                this.applyTransform(ilvTransformer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyTransform(IlvTransformer ilvTransformer) {
        Serializable serializable;
        IlvTransformer ilvTransformer2 = this.getTransformer();
        if (ilvTransformer2.isIdentity()) {
            ilvTransformer2 = ilvTransformer;
        } else {
            serializable = new IlvTransformer();
            ilvTransformer2.computeInverse((IlvTransformer)serializable);
            ilvTransformer2.compose(ilvTransformer);
            ilvTransformer2.compose((IlvTransformer)serializable);
        }
        serializable = ad;
        synchronized (serializable) {
            if (!ilvTransformer2.isIdentity()) {
                ac.setTransform(ilvTransformer2.getx11(), ilvTransformer2.getx21(), ilvTransformer2.getx12(), ilvTransformer2.getx22(), ilvTransformer2.getx0(), ilvTransformer2.gety0());
                this.setInternalShape(ac.createTransformedShape(this.getShape()));
                if (this.getClip() != null) {
                    this.setClip(ac.createTransformedShape(this.getClip()));
                }
            }
        }
        if (this.y) {
            this.x.compose(ilvTransformer2);
        }
    }

    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        float f2;
        super.write(ilvOutputStream);
        ilvOutputStream.write("path", "windingRule", this.getShape());
        ilvOutputStream.write("strokeOn", this.isStrokeOn());
        Stroke stroke = this.getStroke();
        if (stroke != null) {
            if (stroke instanceof IlvPersistentObject) {
                ilvOutputStream.write("pstroke", (IlvPersistentObject)((Object)stroke));
            } else if (this.d()) {
                ilvOutputStream.write("stroke", (BasicStroke)stroke);
            }
        }
        IlvUtility2D.writeStrokePaint(ilvOutputStream, this.getStrokePaint());
        ilvOutputStream.write("fillOn", this.isFillOn());
        IlvUtility2D.writePaint(ilvOutputStream, this.getFillPaint());
        if (!this.isPaintZoomed()) {
            ilvOutputStream.write("zoomPaint", false);
        }
        if (this.isPaintAbsolute()) {
            ilvOutputStream.write("absolutePaint", true);
        }
        if (this.isPointEditionAllowed()) {
            ilvOutputStream.write("movePoint", true);
        }
        if (this.v != null && !this.v.isIdentity()) {
            ilvOutputStream.write("transform", this.v);
        }
        if (this.getClip() != null) {
            ilvOutputStream.write("clip", "clipRule", this.getClip());
        }
        if (this.getMaximumStrokeWidth() != 0.0f) {
            ilvOutputStream.write("maxwidth", this.z);
        }
        if (this.isContainsWhenNotFilled()) {
            ilvOutputStream.write("contains", true);
        }
        if (this.x != null && !this.x.isIdentity()) {
            ilvOutputStream.write("applyTransformer", this.x);
        }
        if (this.isTransformedShapeMode()) {
            ilvOutputStream.write("transformedShapeMode", true);
        }
        if ((f2 = this.getAlpha()) != 1.0f) {
            ilvOutputStream.write("alpha", f2);
        }
    }

    public IlvGraphic copy() {
        return new IlvGeneralPath(this);
    }

    public boolean isMovePointAllowed() {
        return (this.s & 0x40) != 0;
    }

    public void setMovePointAllowed(boolean bl) {
        this.s = bl ? (this.s |= 0x40) : (this.s &= 0xFFFFFFBF);
    }

    public boolean isPointEditionAllowed() {
        return this.isMovePointAllowed();
    }

    public void setPointEditionAllowed(boolean bl) {
        this.setMovePointAllowed(bl);
    }

    public IlvSelection makeSelection() {
        if (this.isPointEditionAllowed()) {
            IlvPolyPointsSelection ilvPolyPointsSelection = new IlvPolyPointsSelection(this);
            this.n();
            ilvPolyPointsSelection.setClosedMode(this.h());
            return ilvPolyPointsSelection;
        }
        return new IlvGeneralPathSelection(this);
    }

    public boolean allowsPointInsertion() {
        return this.isPointEditionAllowed();
    }

    public boolean allowsPointRemoval() {
        return this.isPointEditionAllowed();
    }

    public boolean allowsPointMove(int n2) {
        return this.isPointEditionAllowed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IlvPoint getPointAt(int n2, IlvTransformer ilvTransformer) {
        IlvTransformer ilvTransformer2 = this.getTransformer();
        if (ilvTransformer != null) {
            ilvTransformer2.compose(ilvTransformer);
        }
        PathIterator pathIterator = null;
        if (ilvTransformer2.isIdentity()) {
            pathIterator = this.getShape().getPathIterator(null);
        } else {
            Boolean bl = ad;
            synchronized (bl) {
                ac.setTransform(ilvTransformer2.getx11(), ilvTransformer2.getx21(), ilvTransformer2.getx12(), ilvTransformer2.getx22(), ilvTransformer2.getx0(), ilvTransformer2.gety0());
                pathIterator = this.getShape().getPathIterator(ac);
            }
        }
        int n3 = 0;
        float[] fArray = new float[6];
        while (!pathIterator.isDone()) {
            int n4 = pathIterator.currentSegment(fArray);
            int n5 = this.a(n4);
            if (n3 <= n2 && n3 + n5 > n2) {
                for (int i2 = 0; i2 < n5; ++i2) {
                    if (n3 + i2 != n2) continue;
                    return new IlvPoint(fArray[2 * i2], fArray[2 * i2 + 1]);
                }
            }
            n3 += n5;
            pathIterator.next();
        }
        return null;
    }

    private int a(int n2) {
        int n3 = 0;
        switch (n2) {
            case 0: 
            case 1: {
                n3 = 1;
                break;
            }
            case 2: {
                n3 = 2;
                break;
            }
            case 3: {
                n3 = 3;
            }
        }
        return n3;
    }

    public int getPointsCardinal() {
        this.n();
        return this.m;
    }

    private void n() {
        if (!this.g()) {
            this.m = 0;
            int n2 = 0;
            PathIterator pathIterator = this.getShape().getPathIterator(null);
            float[] fArray = new float[6];
            while (!pathIterator.isDone()) {
                n2 = this.a(pathIterator.currentSegment(fArray));
                this.m += n2;
                pathIterator.next();
            }
            if (n2 == 0) {
                this.f(true);
            } else {
                this.f(false);
            }
            this.e(true);
        }
    }

    public void insertPoint(int n2, float f2, float f3, IlvTransformer ilvTransformer) {
        Object object;
        if (!this.allowsPointInsertion()) {
            return;
        }
        IlvTransformer ilvTransformer2 = this.getTransformer();
        if (!ilvTransformer2.isIdentity()) {
            object = new IlvPoint(f2, f3);
            ilvTransformer2.inverse((IlvPoint)object);
            f2 = ((Point2D.Float)object).x;
            f3 = ((Point2D.Float)object).y;
        }
        object = this.getShape().getPathIterator(null);
        GeneralPath generalPath = new GeneralPath(object.getWindingRule());
        int n3 = 0;
        int n4 = this.getPointsCardinal();
        while (!object.isDone()) {
            float[] fArray = new float[6];
            int n5 = object.currentSegment(fArray);
            int n6 = this.a(n5);
            if (n3 > n2 || n4 != n3 + n6 && n3 + n6 <= n2) {
                switch (n5) {
                    case 1: {
                        generalPath.lineTo(fArray[0], fArray[1]);
                        break;
                    }
                    case 2: {
                        generalPath.quadTo(fArray[0], fArray[1], fArray[2], fArray[3]);
                        break;
                    }
                    case 3: {
                        generalPath.curveTo(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
                        break;
                    }
                    case 0: {
                        generalPath.moveTo(fArray[0], fArray[1]);
                        break;
                    }
                    case 4: {
                        generalPath.closePath();
                    }
                }
            } else {
                switch (n5) {
                    case 1: {
                        if (n2 == n3) {
                            generalPath.lineTo(f2, f3);
                            generalPath.lineTo(fArray[0], fArray[1]);
                            break;
                        }
                        generalPath.lineTo(fArray[0], fArray[1]);
                        generalPath.lineTo(f2, f3);
                        break;
                    }
                    case 2: {
                        if (n2 == n3) {
                            generalPath.curveTo(f2, f3, fArray[0], fArray[1], fArray[2], fArray[3]);
                            break;
                        }
                        if (n2 == n3 + 1) {
                            generalPath.curveTo(fArray[0], fArray[1], f2, f3, fArray[2], fArray[3]);
                            break;
                        }
                        generalPath.curveTo(fArray[0], fArray[1], fArray[2], fArray[3], f2, f3);
                        break;
                    }
                    case 3: {
                        if (n2 == n3) {
                            generalPath.quadTo(f2, f3, fArray[0], fArray[1]);
                            generalPath.quadTo(fArray[2], fArray[3], fArray[4], fArray[5]);
                            break;
                        }
                        if (n2 == n3 + 1) {
                            generalPath.quadTo(fArray[0], fArray[1], f2, f3);
                            generalPath.quadTo(fArray[2], fArray[3], fArray[4], fArray[5]);
                            break;
                        }
                        if (n2 == n3 + 2) {
                            generalPath.quadTo(fArray[0], fArray[1], fArray[2], fArray[3]);
                            generalPath.quadTo(f2, f3, fArray[4], fArray[5]);
                            break;
                        }
                        generalPath.quadTo(fArray[0], fArray[1], fArray[2], fArray[3]);
                        generalPath.quadTo(fArray[4], fArray[5], f2, f3);
                        break;
                    }
                    case 0: {
                        if (n2 == n3) {
                            generalPath.moveTo(f2, f3);
                            generalPath.lineTo(fArray[0], fArray[1]);
                            break;
                        }
                        generalPath.moveTo(fArray[0], fArray[1]);
                        generalPath.lineTo(f2, f3);
                        break;
                    }
                    case 4: {
                        generalPath.closePath();
                    }
                }
            }
            n3 += n6;
            object.next();
        }
        this.setInternalShape(generalPath);
    }

    public void movePoint(int n2, float f2, float f3, IlvTransformer ilvTransformer) {
        Object object;
        if (!this.isPointEditionAllowed()) {
            return;
        }
        IlvTransformer ilvTransformer2 = this.getTransformer();
        if (!ilvTransformer2.isIdentity()) {
            object = new IlvPoint(f2, f3);
            ilvTransformer2.inverse((IlvPoint)object);
            f2 = ((Point2D.Float)object).x;
            f3 = ((Point2D.Float)object).y;
        }
        object = this.getShape().getPathIterator(null);
        GeneralPath generalPath = new GeneralPath(object.getWindingRule());
        int n3 = 0;
        while (!object.isDone()) {
            float[] fArray = new float[6];
            int n4 = object.currentSegment(fArray);
            int n5 = this.a(n4);
            if (n3 <= n2 && n3 + n5 > n2) {
                for (int i2 = 0; i2 < n5; ++i2) {
                    if (n3 + i2 != n2) continue;
                    fArray[2 * i2] = f2;
                    fArray[2 * i2 + 1] = f3;
                    break;
                }
            }
            switch (n4) {
                case 1: {
                    generalPath.lineTo(fArray[0], fArray[1]);
                    break;
                }
                case 2: {
                    generalPath.quadTo(fArray[0], fArray[1], fArray[2], fArray[3]);
                    break;
                }
                case 3: {
                    generalPath.curveTo(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
                    break;
                }
                case 0: {
                    generalPath.moveTo(fArray[0], fArray[1]);
                    break;
                }
                case 4: {
                    generalPath.closePath();
                }
            }
            n3 += n5;
            object.next();
        }
        this.setInternalShape(generalPath);
    }

    public boolean pointsInBBox() {
        return false;
    }

    public void removePoint(int n2, IlvTransformer ilvTransformer) {
        if (!this.allowsPointRemoval()) {
            return;
        }
        PathIterator pathIterator = this.getShape().getPathIterator(null);
        GeneralPath generalPath = new GeneralPath(pathIterator.getWindingRule());
        int n3 = 0;
        while (!pathIterator.isDone()) {
            float[] fArray = new float[6];
            int n4 = pathIterator.currentSegment(fArray);
            int n5 = this.a(n4);
            if (n3 > n2 || n3 + n5 <= n2) {
                switch (n4) {
                    case 1: {
                        generalPath.lineTo(fArray[0], fArray[1]);
                        break;
                    }
                    case 2: {
                        generalPath.quadTo(fArray[0], fArray[1], fArray[2], fArray[3]);
                        break;
                    }
                    case 3: {
                        generalPath.curveTo(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
                        break;
                    }
                    case 0: {
                        generalPath.moveTo(fArray[0], fArray[1]);
                        break;
                    }
                    case 4: {
                        generalPath.closePath();
                    }
                }
            } else {
                switch (n4) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        if (n2 == n3) {
                            generalPath.lineTo(fArray[2], fArray[3]);
                            break;
                        }
                        generalPath.lineTo(fArray[0], fArray[1]);
                        break;
                    }
                    case 3: {
                        if (n2 == n3) {
                            generalPath.quadTo(fArray[2], fArray[3], fArray[4], fArray[5]);
                            break;
                        }
                        if (n2 == n3 + 1) {
                            generalPath.quadTo(fArray[0], fArray[1], fArray[4], fArray[5]);
                            break;
                        }
                        generalPath.quadTo(fArray[0], fArray[1], fArray[2], fArray[3]);
                        break;
                    }
                    case 0: {
                        IlvPoint ilvPoint = null;
                        if (!pathIterator.isDone() && (ilvPoint = this.getPointAt(n2 + 1, null)) != null) {
                            if (this.v != null) {
                                this.v.inverse(ilvPoint);
                            }
                            generalPath.moveTo(ilvPoint.x, ilvPoint.y);
                            ++n2;
                        }
                        if (ilvPoint != null) break;
                        generalPath.moveTo(fArray[0], fArray[1]);
                        break;
                    }
                }
            }
            n3 += n5;
            pathIterator.next();
        }
        this.setInternalShape(generalPath);
    }

    public void setTransformedShapeMode(boolean bl) {
        this.y = bl;
        if (!bl) {
            this.x = new IlvTransformer();
        }
        this.d(false);
    }

    public boolean isTransformedShapeMode() {
        return this.y;
    }
}

