/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphic;

import ilog.views.IlvGraphic;
import ilog.views.IlvLinkImage;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import java.io.IOException;

public class IlvDoubleLinkImage
extends IlvLinkImage {
    public static final int VerticalLink = 0;
    public static final int HorizontalLink = 1;
    private int a = 0;

    public IlvDoubleLinkImage(IlvGraphic ilvGraphic, IlvGraphic ilvGraphic2, boolean bl) {
        this(ilvGraphic, ilvGraphic2, 0, bl);
    }

    public IlvDoubleLinkImage(IlvGraphic ilvGraphic, IlvGraphic ilvGraphic2, int n2, boolean bl) {
        super(ilvGraphic, ilvGraphic2, bl);
        this.a = n2;
    }

    public IlvDoubleLinkImage(IlvDoubleLinkImage ilvDoubleLinkImage) {
        super(ilvDoubleLinkImage);
        this.a = ilvDoubleLinkImage.a;
    }

    public IlvDoubleLinkImage(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(ilvInputStream);
        this.a = ilvInputStream.readInt("orientation");
    }

    public IlvGraphic copy() {
        return new IlvDoubleLinkImage(this);
    }

    public void setOrientation(int n2) {
        this.a = n2;
    }

    public int getOrientation() {
        return this.a;
    }

    public int getPointsCardinal() {
        return 2;
    }

    public IlvPoint getPointAt(int n2, IlvTransformer ilvTransformer) {
        IlvPoint[] ilvPointArray = this.getLinkPoints(ilvTransformer);
        if (n2 != 0 && n2 != 1) {
            throw new IllegalArgumentException("index should be 0 or 1");
        }
        if (n2 == 0) {
            return ilvPointArray[0];
        }
        return ilvPointArray[ilvPointArray.length - 1];
    }

    public IlvPoint getConnectionReferencePoint(boolean bl, IlvTransformer ilvTransformer) {
        if (bl) {
            IlvRect ilvRect = this.getToBoundingBox(ilvTransformer);
            return new IlvPoint(ilvRect.x + ilvRect.width / 2.0f, ilvRect.y + ilvRect.height / 2.0f);
        }
        IlvRect ilvRect = this.getFromBoundingBox(ilvTransformer);
        return new IlvPoint(ilvRect.x + ilvRect.width / 2.0f, ilvRect.y + ilvRect.height / 2.0f);
    }

    final boolean a(IlvTransformer ilvTransformer) {
        IlvRect ilvRect = this.getToBoundingBox(ilvTransformer);
        IlvRect ilvRect2 = this.getFromBoundingBox(ilvTransformer);
        if (this.a == 0) {
            return ilvRect.y + ilvRect.height > ilvRect2.y && ilvRect.y < ilvRect2.y + ilvRect2.height;
        }
        return ilvRect.x + ilvRect.width > ilvRect2.x && ilvRect.x < ilvRect2.x + ilvRect2.width;
    }

    public void getConnectionPoints(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        boolean bl = this.getLinkConnectorConnectionPoint(true, ilvPoint, ilvTransformer);
        boolean bl2 = this.getLinkConnectorConnectionPoint(false, ilvPoint2, ilvTransformer);
        if (!bl || !bl2) {
            if (this.a(ilvTransformer)) {
                IlvPoint ilvPoint3 = new IlvPoint();
                IlvPoint ilvPoint4 = new IlvPoint();
                super.getConnectionPoints(ilvPoint3, ilvPoint4, ilvTransformer);
                if (!bl) {
                    ilvPoint.move(ilvPoint3.x, ilvPoint3.y);
                }
                if (!bl2) {
                    ilvPoint2.move(ilvPoint4.x, ilvPoint4.y);
                }
                return;
            }
            IlvRect ilvRect = this.getToBoundingBox(ilvTransformer);
            IlvRect ilvRect2 = this.getFromBoundingBox(ilvTransformer);
            if (this.a == 0) {
                if (!bl2) {
                    if (ilvRect.y >= ilvRect2.y + ilvRect2.height / 2.0f) {
                        ilvPoint2.move(ilvRect.x + ilvRect.width / 2.0f, ilvRect.y);
                    } else {
                        ilvPoint2.move(ilvRect.x + ilvRect.width / 2.0f, ilvRect.y + ilvRect.height);
                    }
                }
                if (!bl) {
                    if (ilvRect.y >= ilvRect2.y + ilvRect2.height / 2.0f) {
                        ilvPoint.move(ilvRect2.x + ilvRect2.width / 2.0f, ilvRect2.y + ilvRect2.height);
                    } else {
                        ilvPoint.move(ilvRect2.x + ilvRect2.width / 2.0f, ilvRect2.y);
                    }
                }
            } else {
                if (!bl) {
                    if (ilvRect.x >= ilvRect2.x + ilvRect2.width / 2.0f) {
                        ilvPoint.move(ilvRect2.x + ilvRect2.width, ilvRect2.y + ilvRect2.height / 2.0f);
                    } else {
                        ilvPoint.move(ilvRect2.x, ilvRect2.y + ilvRect2.height / 2.0f);
                    }
                }
                if (!bl2) {
                    if (ilvRect.x >= ilvRect2.x + ilvRect2.width / 2.0f) {
                        ilvPoint2.move(ilvRect.x, ilvRect.y + ilvRect.height / 2.0f);
                    } else {
                        ilvPoint2.move(ilvRect.x + ilvRect.width, ilvRect.y + ilvRect.height / 2.0f);
                    }
                }
            }
        }
    }

    public IlvPoint[] getLinkPoints(IlvTransformer ilvTransformer) {
        IlvPoint[] ilvPointArray = new IlvPoint[]{new IlvPoint(), new IlvPoint(), new IlvPoint(), new IlvPoint()};
        this.getConnectionPoints(ilvPointArray[0], ilvPointArray[3], ilvTransformer);
        if (this.a(ilvTransformer)) {
            ilvPointArray[1].x = ilvPointArray[0].x;
            ilvPointArray[1].y = ilvPointArray[0].y;
            ilvPointArray[2].x = ilvPointArray[0].x;
            ilvPointArray[2].y = ilvPointArray[0].y;
        } else if (this.a == 1) {
            ilvPointArray[1].x = ilvPointArray[0].x + (ilvPointArray[3].x - ilvPointArray[0].x) / 2.0f;
            ilvPointArray[1].y = ilvPointArray[0].y;
            ilvPointArray[2].x = ilvPointArray[1].x;
            ilvPointArray[2].y = ilvPointArray[3].y;
        } else {
            ilvPointArray[1].x = ilvPointArray[0].x;
            ilvPointArray[1].y = ilvPointArray[0].y + (ilvPointArray[3].y - ilvPointArray[0].y) / 2.0f;
            ilvPointArray[2].x = ilvPointArray[3].x;
            ilvPointArray[2].y = ilvPointArray[1].y;
        }
        return ilvPointArray;
    }

    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        super.write(ilvOutputStream);
        ilvOutputStream.write("orientation", this.a);
    }
}

