/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.appframe.settings.query;

import ilog.views.appframe.settings.IlvSettings;
import ilog.views.appframe.settings.query.AbstractNodeList;
import ilog.views.appframe.settings.query.IlvEvaluationContext;
import ilog.views.appframe.settings.query.IlvNumberUtil;
import ilog.views.appframe.settings.query.NodeListHandler;
import ilog.views.appframe.settings.query.ParseException;
import ilog.views.appframe.settings.query.XPathParser;
import java.io.StringReader;
import java.util.HashMap;
import java.util.ResourceBundle;

public class IlvXPathParser {
    protected XPathParser parser = null;
    protected HashMap functions = new HashMap(10);
    public static boolean Debug = false;
    protected boolean debug = Debug;

    public IlvXPathParser() {
        try {
            this.parser = new XPathParser(new StringReader(""));
            this.setDebug(this.debug);
        }
        catch (Exception exception) {
            System.out.println("XPath Parser exception: " + exception.getMessage());
            return;
        }
        this.initializeFunctions();
    }

    public AbstractNodeList evaluate(String string, AbstractNodeList abstractNodeList, NodeListHandler nodeListHandler, ResourceBundle resourceBundle) throws ParseException {
        this.parser.ReInit(new StringReader(string));
        this.parser.XPath();
        IlvEvaluationContext ilvEvaluationContext = new IlvEvaluationContext(abstractNodeList, nodeListHandler);
        if (resourceBundle != null) {
            ilvEvaluationContext.setTranslateLiterals(true);
            ilvEvaluationContext.setResourceBundle(resourceBundle);
        }
        ilvEvaluationContext.setFunctions(this.functions);
        this.parser.jjtree.c().evaluate(ilvEvaluationContext);
        return (AbstractNodeList)ilvEvaluationContext.getStackObject(0);
    }

    public AbstractNodeList evaluate(String string, IlvSettings ilvSettings, NodeListHandler nodeListHandler, ResourceBundle resourceBundle) throws ParseException {
        this.parser.ReInit(new StringReader(string));
        this.parser.XPath();
        IlvEvaluationContext ilvEvaluationContext = new IlvEvaluationContext(ilvSettings, nodeListHandler);
        if (resourceBundle != null) {
            ilvEvaluationContext.setTranslateLiterals(true);
            ilvEvaluationContext.setResourceBundle(resourceBundle);
        }
        ilvEvaluationContext.setFunctions(this.functions);
        this.parser.jjtree.c().evaluate(ilvEvaluationContext);
        return (AbstractNodeList)ilvEvaluationContext.getStackObject(0);
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
        if (bl) {
            this.parser.enable_tracing();
        } else {
            this.parser.disable_tracing();
        }
    }

    public void addFunction(String string, Function function) {
        this.functions.put(string, function);
    }

    public boolean removeFunction(String string) {
        return this.functions.remove(string) != null;
    }

    protected void initializeFunctions() {
        this.addFunction("last", new Function(){

            public Object evaluate(IlvEvaluationContext ilvEvaluationContext, Object[] objectArray) {
                if (ilvEvaluationContext.isEvaluatingPredicate()) {
                    return new Integer(ilvEvaluationContext.getContextSize());
                }
                return new Integer(-1);
            }
        });
        this.addFunction("position", new Function(){

            public Object evaluate(IlvEvaluationContext ilvEvaluationContext, Object[] objectArray) {
                if (ilvEvaluationContext.isEvaluatingPredicate() && ilvEvaluationContext.getContextNode() != null) {
                    return new Integer(ilvEvaluationContext.getContextPosition() + 1);
                }
                return new Integer(-1);
            }
        });
        this.addFunction("count", new Function(){

            public Object evaluate(IlvEvaluationContext ilvEvaluationContext, Object[] objectArray) {
                if (objectArray.length <= 0 || objectArray[0] == null || !(objectArray[0] instanceof AbstractNodeList)) {
                    return null;
                }
                return new Integer(((AbstractNodeList)objectArray[0]).getLength());
            }
        });
        this.addFunction("id", new Function(){

            public Object evaluate(IlvEvaluationContext ilvEvaluationContext, Object[] objectArray) {
                return new String("");
            }
        });
        this.addFunction("local-name", new Function(){

            public Object evaluate(IlvEvaluationContext ilvEvaluationContext, Object[] objectArray) {
                return new String("");
            }
        });
        this.addFunction("namespace-uri", new Function(){

            public Object evaluate(IlvEvaluationContext ilvEvaluationContext, Object[] objectArray) {
                return new String("");
            }
        });
        this.addFunction("name", new Function(){

            public Object evaluate(IlvEvaluationContext ilvEvaluationContext, Object[] objectArray) {
                return new String("");
            }
        });
        this.addFunction("concat", new Function(){

            public Object evaluate(IlvEvaluationContext ilvEvaluationContext, Object[] objectArray) {
                if (objectArray.length == 0) {
                    return new String("");
                }
                if (objectArray.length == 1) {
                    return objectArray[0];
                }
                String string = objectArray[0].toString();
                for (int i2 = 1; i2 < objectArray.length; ++i2) {
                    string = string + objectArray[i2].toString();
                }
                return string;
            }
        });
        this.addFunction("start-with", new Function(){

            public Object evaluate(IlvEvaluationContext ilvEvaluationContext, Object[] objectArray) {
                if (objectArray.length < 2) {
                    return Boolean.FALSE;
                }
                return new Boolean(objectArray[0].toString().startsWith(objectArray[1].toString()));
            }
        });
        this.addFunction("contains", new Function(){

            public Object evaluate(IlvEvaluationContext ilvEvaluationContext, Object[] objectArray) {
                if (objectArray.length < 2) {
                    return Boolean.FALSE;
                }
                return new Boolean(objectArray[0].toString().indexOf(objectArray[1].toString()) != -1);
            }
        });
        this.addFunction("substring-before", new Function(){

            public Object evaluate(IlvEvaluationContext ilvEvaluationContext, Object[] objectArray) {
                if (objectArray.length == 0) {
                    return new String("");
                }
                String string = objectArray[0].toString();
                if (objectArray.length == 1) {
                    return string;
                }
                int n2 = string.indexOf(objectArray[1].toString());
                return n2 == -1 ? string : string.substring(0, n2);
            }
        });
        this.addFunction("substring-after", new Function(){

            public Object evaluate(IlvEvaluationContext ilvEvaluationContext, Object[] objectArray) {
                if (objectArray.length == 0) {
                    return new String("");
                }
                String string = objectArray[0].toString();
                if (objectArray.length == 1) {
                    return string;
                }
                int n2 = string.indexOf(objectArray[1].toString());
                return n2 == -1 ? string : string.substring(n2 + objectArray[1].toString().length());
            }
        });
        this.addFunction("substring", new Function(){

            public Object evaluate(IlvEvaluationContext ilvEvaluationContext, Object[] objectArray) {
                if (objectArray.length == 0) {
                    return new String("");
                }
                String string = objectArray[0].toString();
                if (objectArray.length == 1) {
                    return string;
                }
                int n2 = IlvNumberUtil.a(objectArray[1]) - 1;
                if (objectArray.length == 2) {
                    return string.substring(n2);
                }
                return string.substring(n2, IlvNumberUtil.a(objectArray[2]) - 1);
            }
        });
        this.addFunction("string-length", new Function(){

            public Object evaluate(IlvEvaluationContext ilvEvaluationContext, Object[] objectArray) {
                String string = objectArray.length == 0 ? ilvEvaluationContext.getContextNodeString() : objectArray[0].toString();
                return new Integer(string.length());
            }
        });
        this.addFunction("normalize-space", new Function(){

            public Object evaluate(IlvEvaluationContext ilvEvaluationContext, Object[] objectArray) {
                String string = objectArray.length == 0 ? ilvEvaluationContext.getContextNodeString() : objectArray[0].toString();
                int n2 = IlvXPathParser.this.skipWhites(string);
                if (n2 > 0) {
                    if (n2 == string.length()) {
                        return new String("");
                    }
                    string = string.substring(n2);
                }
                n2 = 1;
                while (true) {
                    int n3;
                    if (n2 < string.length() && !IlvXPathParser.this.isWhite(string.charAt(n2))) {
                        ++n2;
                        continue;
                    }
                    if (n2 == string.length()) {
                        return string;
                    }
                    for (n3 = n2 + 1; n3 < string.length() && IlvXPathParser.this.isWhite(string.charAt(n3)); ++n3) {
                    }
                    if (n3 == string.length()) {
                        return string.substring(0, n2);
                    }
                    if (++n2 >= (string = string.substring(0, n2) + " " + string.substring(n3)).length()) break;
                }
                return string;
            }
        });
        this.addFunction("translate", new Function(){

            public Object evaluate(IlvEvaluationContext ilvEvaluationContext, Object[] objectArray) {
                if (objectArray.length < 2) {
                    return objectArray.length == 1 ? objectArray[0].toString() : new String("");
                }
                String string = "";
                String string2 = objectArray[0].toString();
                String string3 = objectArray[1].toString();
                String string4 = objectArray.length > 2 ? objectArray[2].toString() : "";
                int n2 = 0;
                for (int i2 = 0; i2 < string2.length(); ++i2) {
                    int n3 = string3.indexOf(string2.charAt(i2));
                    if (n3 != -1 && i2 > 0 && i2 > n2) {
                        string = string + string2.substring(n2, i2);
                        n2 = i2 + 1;
                    }
                    if (n3 >= string4.length()) continue;
                    string = string + string4.charAt(n3);
                }
                if (n2 < string2.length()) {
                    string = string + string2.substring(n2);
                }
                return string;
            }
        });
        this.addFunction("boolean", new Function(){

            public Object evaluate(IlvEvaluationContext ilvEvaluationContext, Object[] objectArray) {
                if (objectArray.length < 1) {
                    return Boolean.FALSE;
                }
                if (objectArray[0] instanceof AbstractNodeList) {
                    return new Boolean(((AbstractNodeList)objectArray[0]).getLength() > 0);
                }
                if (objectArray[0] instanceof String) {
                    return new Boolean(((String)objectArray[0]).length() > 0);
                }
                return new Boolean(IlvNumberUtil.b(objectArray[0]) != 0.0f);
            }
        });
        this.addFunction("not", new Function(){

            public Object evaluate(IlvEvaluationContext ilvEvaluationContext, Object[] objectArray) {
                if (objectArray.length < 1) {
                    return Boolean.TRUE;
                }
                return new Boolean(!IlvNumberUtil.c(objectArray[0]));
            }
        });
        this.addFunction("true", new Function(){

            public Object evaluate(IlvEvaluationContext ilvEvaluationContext, Object[] objectArray) {
                return Boolean.TRUE;
            }
        });
        this.addFunction("false", new Function(){

            public Object evaluate(IlvEvaluationContext ilvEvaluationContext, Object[] objectArray) {
                return Boolean.FALSE;
            }
        });
        this.addFunction("lang", new Function(){

            public Object evaluate(IlvEvaluationContext ilvEvaluationContext, Object[] objectArray) {
                if (objectArray.length < 1) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
        });
        this.addFunction("number", new Function(){

            public Object evaluate(IlvEvaluationContext ilvEvaluationContext, Object[] objectArray) {
                if (objectArray.length < 1 || objectArray[0] instanceof String) {
                    String string = objectArray.length == 0 ? ilvEvaluationContext.getContextNodeString() : (String)objectArray[0];
                    int n2 = IlvXPathParser.this.skipWhites(string);
                    if (n2 > 0) {
                        string = string.substring(n2);
                    }
                    try {
                        return new Integer(Integer.parseInt(string));
                    }
                    catch (Exception exception) {
                        return new Integer(Integer.MIN_VALUE);
                    }
                }
                if (objectArray[0] instanceof Boolean) {
                    return new Integer((Boolean)objectArray[0] != false ? 1 : 0);
                }
                if (objectArray[0] instanceof AbstractNodeList) {
                    return null;
                }
                return new Integer(0);
            }
        });
        this.addFunction("sum", new Function(){

            public Object evaluate(IlvEvaluationContext ilvEvaluationContext, Object[] objectArray) {
                return new Integer(0);
            }
        });
        this.addFunction("floor", new Function(){

            public Object evaluate(IlvEvaluationContext ilvEvaluationContext, Object[] objectArray) {
                return new Integer(0);
            }
        });
        this.addFunction("ceiling", new Function(){

            public Object evaluate(IlvEvaluationContext ilvEvaluationContext, Object[] objectArray) {
                return new Integer(0);
            }
        });
        this.addFunction("round", new Function(){

            public Object evaluate(IlvEvaluationContext ilvEvaluationContext, Object[] objectArray) {
                return new Integer(0);
            }
        });
    }

    protected final boolean isWhite(char c2) {
        switch (c2) {
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    protected int skipWhites(String string) {
        for (int i2 = 0; i2 < string.length(); ++i2) {
            if (this.isWhite(string.charAt(i2))) continue;
            return i2;
        }
        return string.length();
    }

    public static interface Function {
        public Object evaluate(IlvEvaluationContext var1, Object[] var2);
    }
}

