/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.appframe.settings.query;

import ilog.views.appframe.settings.IlvSettings;
import ilog.views.appframe.settings.IlvSettingsAttribute;
import ilog.views.appframe.settings.IlvSettingsElement;
import ilog.views.appframe.settings.IlvSettingsNode;
import ilog.views.appframe.settings.query.AbstractNodeList;
import ilog.views.appframe.settings.query.IlvXPathParser;
import ilog.views.appframe.settings.query.NodeListHandler;
import java.util.HashMap;
import java.util.ResourceBundle;

class IlvEvaluationContext {
    private transient NodeListHandler a;
    protected IlvSettings querySource = null;
    protected AbstractNodeList nodeList = null;
    protected IlvSettingsNode contextNode = null;
    protected int contextPosition;
    protected int contextSize;
    protected HashMap bindings = null;
    protected HashMap functions = null;
    protected HashMap namespaces = null;
    protected int DefaultStackSize = 1024;
    protected Object[] stack = new Object[this.DefaultStackSize];
    protected int top = -1;
    protected boolean translateLiterals = false;
    protected ResourceBundle bundle = null;
    protected int predicateLocks = 0;

    public IlvEvaluationContext(AbstractNodeList abstractNodeList, NodeListHandler nodeListHandler) {
        this.a = nodeListHandler;
        this.nodeList = abstractNodeList;
        this.querySource = null;
        this.contextNode = abstractNodeList != null && abstractNodeList.getLength() > 0 ? abstractNodeList.getNode(0) : null;
    }

    public IlvEvaluationContext(IlvSettings ilvSettings, NodeListHandler nodeListHandler) {
        this.a = nodeListHandler;
        this.nodeList = null;
        this.querySource = ilvSettings;
        this.contextNode = new RootElement(ilvSettings);
        this.nodeList = nodeListHandler.newNodeList(this.contextNode);
    }

    NodeListHandler a() {
        return this.a;
    }

    public Object callFunction(String string, Object[] objectArray) throws UnsupportedFunctionException {
        IlvXPathParser.Function function = (IlvXPathParser.Function)this.functions.get(string);
        if (function == null) {
            throw new UnsupportedFunctionException(string);
        }
        return function.evaluate(this, objectArray);
    }

    public int getContextSize() {
        return this.contextSize;
    }

    public void setContextSize(int n2) {
        this.contextSize = n2;
    }

    public int getContextPosition() {
        return this.contextPosition;
    }

    public void setContextPosition(int n2) {
        this.contextPosition = n2;
    }

    public AbstractNodeList select() {
        return this.nodeList;
    }

    public void setNodeList(AbstractNodeList abstractNodeList) {
        this.nodeList = abstractNodeList;
        this.contextNode = abstractNodeList != null && abstractNodeList.getLength() > 0 ? abstractNodeList.getNode(0) : null;
    }

    public IlvSettingsNode getContextNode() {
        return this.contextNode;
    }

    public IlvSettingsElement getContextElement() {
        return (IlvSettingsElement)this.contextNode;
    }

    public void setContextNode(IlvSettingsNode ilvSettingsNode) {
        this.contextNode = ilvSettingsNode;
    }

    public String getContextNodeString() {
        return new String("");
    }

    public IlvSettings getSettings() {
        return this.querySource;
    }

    public void setFunctions(HashMap hashMap) {
        this.functions = hashMap;
    }

    public void reInitialize() {
        this.top = -1;
    }

    public Object getTopStackObject() {
        return this.top == -1 ? null : this.stack[this.top];
    }

    public void setTopStackObject(Object object) {
        this.stack[this.top] = object;
    }

    public Object getStackObject(int n2) {
        return this.stack[n2];
    }

    public void setStackObject(int n2, Object object) {
        this.stack[n2] = object;
    }

    public void setTopStack(int n2) {
        this.top = n2;
    }

    public int getTopStack() {
        return this.top;
    }

    public void push(Object object) {
        this.stack[++this.top] = object;
    }

    public AbstractNodeList getCurrentNodeList() {
        return this.top > -1 && this.stack[this.top] != null && this.stack[this.top] instanceof AbstractNodeList ? (AbstractNodeList)this.stack[this.top] : this.nodeList;
    }

    public void lockPredicateEvaluation() {
        ++this.predicateLocks;
    }

    public void unLockPredicateEvaluation() {
        --this.predicateLocks;
    }

    public boolean isEvaluatingPredicate() {
        return this.predicateLocks > 0;
    }

    public boolean translateLiterals() {
        return this.translateLiterals;
    }

    public void setTranslateLiterals(boolean bl) {
        this.translateLiterals = bl;
    }

    public void setResourceBundle(ResourceBundle resourceBundle) {
        this.bundle = resourceBundle;
    }

    public String getLiteralString(String string) {
        if (this.translateLiterals && this.bundle != null) {
            try {
                String string2 = this.bundle.getString(string);
                return string2;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    AbstractNodeList b() {
        return this.a.newNodeList();
    }

    AbstractNodeList a(int n2) {
        return this.a.newNodeList(n2);
    }

    AbstractNodeList a(IlvSettingsAttribute[] ilvSettingsAttributeArray) {
        return this.a.newNodeList(ilvSettingsAttributeArray);
    }

    AbstractNodeList a(IlvSettingsNode ilvSettingsNode) {
        return this.a.newNodeList(ilvSettingsNode);
    }

    void a(IlvSettingsElement ilvSettingsElement, String string, AbstractNodeList abstractNodeList) {
        this.a.getChildren(this.querySource, ilvSettingsElement, string, abstractNodeList);
    }

    void a(IlvSettingsElement ilvSettingsElement, AbstractNodeList abstractNodeList) {
        this.a.getChildren(this.querySource, ilvSettingsElement, null, abstractNodeList);
    }

    void a(IlvSettings ilvSettings, IlvSettingsElement ilvSettingsElement, AbstractNodeList abstractNodeList) {
        this.a.getChildren(ilvSettings, ilvSettingsElement, null, abstractNodeList);
    }

    class RootElement
    extends IlvSettingsElement {
        public RootElement(IlvSettings ilvSettings) {
            super(ilvSettings);
        }

        public short getNodeType() {
            return IlvSettingsNode.ROOT_ELEMENT_NODE;
        }

        public String getType() {
            return null;
        }

        public Object getID() {
            return null;
        }
    }

    static class UnsupportedFunctionException
    extends Exception {
        public UnsupportedFunctionException(String string) {
            super("Unsupported function " + string);
        }
    }
}

