/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.thirdparty.sqlserver;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.ConnectException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.dbtools.raptor.connections.CDComponentView;
import oracle.dbtools.raptor.conntypes.RaptorClassLoader;
import oracle.dbtools.raptor.explorer.dt.dialog.ConnectionDialogArb;
import oracle.dbtools.thirdparty.sqlserver.Messages;
import oracle.dbtools.thirdparty.sqlserver.SQLServerConnectionPanel;
import oracle.dbtools.thirdparty.sqlserver.SQLServerExplorerResource;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.util.PlatformUtils;

class BasicPanel
extends JPanel
implements CDComponentView {
    private static final long serialVersionUID = 428751755326227573L;
    private final SQLServerConnectionPanel _basicPanel;
    private JLabel _hostLbl = new JLabel();
    protected JTextField tfdHost = new JTextField(15);
    private JLabel _portLbl = new JLabel();
    protected JTextField tfdPort = new JTextField(15);
    private JComboBox _sqlServerDbComboBox;
    private JButton _retrieveDatabaseButton;
    private JCheckBox _autoPasswordCheck = new JCheckBox();
    private JCheckBox _windowsAuthenticate = new JCheckBox();
    private JLabel _domainLbl = new JLabel();
    protected JTextField tfdDomain = new JTextField(15);
    private boolean isWindows = true;

    public BasicPanel(SQLServerConnectionPanel sQLServerConnectionPanel) {
        this._basicPanel = sQLServerConnectionPanel;
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    public void clear() {
        this.tfdHost.setText("");
        this.tfdPort.setText("");
        this._sqlServerDbComboBox.removeAllItems();
    }

    public void generateProperties(Properties properties) {
        String string = "";
        String string2 = "";
        properties.setProperty("hostname", this.tfdHost.getText().trim());
        properties.setProperty("port", this.tfdPort.getText().trim());
        Object object = this._sqlServerDbComboBox.getSelectedItem();
        if (object != null) {
            string2 = object.toString();
        }
        string = string2.length() < 1 ? "jdbc:jtds:sqlserver://" + this.tfdHost.getText().trim() + ":" + this.tfdPort.getText().trim() + "/" : "jdbc:jtds:sqlserver://" + this.tfdHost.getText().trim() + ":" + this.tfdPort.getText().trim() + "/" + string2;
        properties.setProperty("customUrl", string);
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        ResourceUtils.resButton((AbstractButton)this._autoPasswordCheck, (String)Messages.getString("BasicPanel.10"));
        ResourceUtils.resButton((AbstractButton)this._windowsAuthenticate, (String)SQLServerExplorerResource.getString("WINDOWS_AUTHENTICATION"));
        ResourceUtils.resLabel((JLabel)this._hostLbl, (Component)this.tfdHost, (String)ConnectionDialogArb.getString((String)"CONNECTION_DIALOG_DETAILS_HOST"));
        ResourceUtils.resLabel((JLabel)this._portLbl, (Component)this.tfdPort, (String)ConnectionDialogArb.getString((String)"CONNECTION_DIALOG_DETAILS_PORT"));
        ResourceUtils.resLabel((JLabel)this._domainLbl, (Component)this.tfdDomain, (String)SQLServerExplorerResource.getString("DOMAIN_NAME"));
        this.tfdDomain.setEditable(false);
        this.tfdDomain.setBackground(Color.LIGHT_GRAY);
        this.isWindows = PlatformUtils.isWindows();
        this._autoPasswordCheck.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                BasicPanel.this.setDefaultPasswordSelected(itemEvent.getStateChange() == 1);
            }
        });
        this._windowsAuthenticate.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                BasicPanel.this.setWindowsAuthSelected(itemEvent.getStateChange() == 1);
            }
        });
        this.add((Component)this._autoPasswordCheck, new GridBagConstraints(0, 0, 5, 1, 0.0, 0.0, 18, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)this._windowsAuthenticate, new GridBagConstraints(0, 1, 5, 1, 0.0, 0.0, 18, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)this._hostLbl, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)this.tfdHost, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 2, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)this._portLbl, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)this.tfdPort, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 18, 2, new Insets(10, 5, 0, 0), 0, 0));
        this.add(Box.createVerticalGlue(), new GridBagConstraints(0, 6, 1, 1, 1.0, 1.0, 18, 2, new Insets(10, 5, 0, 0), 0, 0));
        this.tfdHost.setText("localhost");
        this.tfdPort.setText("1433");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 5, 0, 0);
        gridBagConstraints.anchor = 11;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridx = 1;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(10, 0, 0, 0);
        gridBagConstraints2.anchor = 11;
        gridBagConstraints2.gridy = 5;
        gridBagConstraints2.gridx = 0;
        this.add((Component)this.retrieveDatabaseButton(), gridBagConstraints2);
        this.add((Component)this.getsqlServerDbComboBox(), gridBagConstraints);
    }

    protected JComboBox getsqlServerDbComboBox() {
        if (this._sqlServerDbComboBox == null) {
            this._sqlServerDbComboBox = new JComboBox();
        }
        return this._sqlServerDbComboBox;
    }

    protected JButton retrieveDatabaseButton() {
        if (this._retrieveDatabaseButton == null) {
            this._retrieveDatabaseButton = new JButton();
            ResourceUtils.resButton((AbstractButton)this._retrieveDatabaseButton, (String)Messages.getString("BasicPanel.11"));
        }
        this._retrieveDatabaseButton.addActionListener(new ActionListener(){
            private static final String JTDS_DRIVER_CLASS = "net.sourceforge.jtds.jdbc.Driver";

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (BasicPanel.this._basicPanel.getConnectionName().length() < 1) {
                        BasicPanel.this._basicPanel.setErrorStatus(ConnectionDialogArb.getString((String)"CONNECTION_DIALOG_STATUS_FAILURE") + Messages.getString("BasicPanel.13"));
                        return;
                    }
                    if (!(BasicPanel.this._basicPanel.getUserName().length() >= 1 && BasicPanel.this._basicPanel.getUserName().length() >= 1 || BasicPanel.this._windowsAuthenticate.isSelected() && (!BasicPanel.this._windowsAuthenticate.isSelected() || BasicPanel.this.isWindows))) {
                        BasicPanel.this._basicPanel.setErrorStatus(ConnectionDialogArb.getString((String)"CONNECTION_DIALOG_STATUS_FAILURE") + Messages.getString("BasicPanel.14"));
                        return;
                    }
                    if (BasicPanel.this._windowsAuthenticate.isSelected() && !BasicPanel.this.isWindows && (BasicPanel.this.tfdDomain.getText() == null || BasicPanel.this.tfdDomain.getText().length() <= 0)) {
                        BasicPanel.this._basicPanel.setErrorStatus(ConnectionDialogArb.getString((String)"CONNECTION_DIALOG_STATUS_FAILURE") + Messages.getString("BasicPanel.15"));
                        return;
                    }
                    BasicPanel.this._basicPanel.setStatus("");
                    ClassLoader classLoader = RaptorClassLoader.findClassLoader((String)JTDS_DRIVER_CLASS);
                    Class<Driver> clazz = (classLoader != null ? classLoader.loadClass(JTDS_DRIVER_CLASS) : Class.forName(JTDS_DRIVER_CLASS)).asSubclass(Driver.class);
                    Driver driver = clazz.newInstance();
                    Properties properties = new Properties();
                    String string = BasicPanel.this._basicPanel.getUserName();
                    String string2 = BasicPanel.this._basicPanel.getPassword();
                    String string3 = BasicPanel.this.tfdHost.getText().trim();
                    String string4 = "jdbc:jtds:sqlserver://" + string3 + ":" + BasicPanel.this.tfdPort.getText().trim();
                    if (BasicPanel.this._windowsAuthenticate.isSelected() && !BasicPanel.this.isWindows) {
                        string4 = string4 + ";domain=" + BasicPanel.this.tfdDomain.getText();
                    }
                    if (null != string) {
                        properties.setProperty("user", string);
                    }
                    if (BasicPanel.this._autoPasswordCheck.isSelected()) {
                        properties.put("password", "");
                    } else if (null != string2) {
                        properties.setProperty("password", string2);
                    }
                    Connection connection = driver.connect(string4, properties);
                    PreparedStatement preparedStatement = connection.prepareStatement("select name from master..sysdatabases ORDER by name");
                    ResultSet resultSet = preparedStatement.executeQuery();
                    BasicPanel.this._sqlServerDbComboBox.removeAllItems();
                    while (resultSet.next()) {
                        String string5 = resultSet.getString("name");
                        if (string5 == null) continue;
                        BasicPanel.this._sqlServerDbComboBox.addItem(string5);
                    }
                    connection.close();
                }
                catch (SQLException sQLException) {
                    if (sQLException.getCause() instanceof ConnectException) {
                        BasicPanel.this._basicPanel.setErrorStatus(ConnectionDialogArb.getString((String)"CONNECTION_DIALOG_STATUS_FAILURE") + ConnectionDialogArb.format((String)"SQL_SERVER_CONNECTION_ERROR", (Object[])new Object[]{BasicPanel.this.tfdHost.getText()}));
                    } else {
                        BasicPanel.this._basicPanel.setErrorStatus(ConnectionDialogArb.getString((String)"CONNECTION_DIALOG_STATUS_FAILURE") + sQLException.getMessage());
                    }
                }
                catch (InstantiationException instantiationException) {
                    BasicPanel.this._basicPanel.setErrorStatus(ConnectionDialogArb.getString((String)"CONNECTION_DIALOG_STATUS_FAILURE") + instantiationException.getMessage());
                }
                catch (IllegalAccessException illegalAccessException) {
                    BasicPanel.this._basicPanel.setErrorStatus(ConnectionDialogArb.getString((String)"CONNECTION_DIALOG_STATUS_FAILURE") + illegalAccessException.getMessage());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    BasicPanel.this._basicPanel.setErrorStatus(ConnectionDialogArb.getString((String)"CONNECTION_DIALOG_STATUS_FAILURE") + classNotFoundException.getMessage());
                }
            }
        });
        return this._retrieveDatabaseButton;
    }

    protected void retrieveDatabase(Properties properties) {
        String string;
        this._sqlServerDbComboBox.removeAllItems();
        String string2 = properties.getProperty("customUrl");
        if (string2 != null && (string = string2.substring(string2.lastIndexOf(47) + 1)) != null) {
            this._sqlServerDbComboBox.addItem(string);
            this._sqlServerDbComboBox.setSelectedItem(string);
        }
    }

    public JCheckBox get_autoPasswordCheck() {
        return this._autoPasswordCheck;
    }

    public void set_autoPasswordCheck(JCheckBox jCheckBox) {
        this._autoPasswordCheck = jCheckBox;
    }

    public JCheckBox get_windowsAuthenticate() {
        return this._windowsAuthenticate;
    }

    public void set_windowsAuthenticate(boolean bl) {
        this._windowsAuthenticate.setSelected(bl);
    }

    public boolean get_isWindows() {
        return this.isWindows;
    }

    public JTextField getTfdDomain() {
        return this.tfdDomain;
    }

    public void setDomain(String string) {
        this.tfdDomain.setText(string);
    }

    void setDefaultPasswordSelected(boolean bl) {
        this.isWindows = PlatformUtils.isWindows();
        this._autoPasswordCheck.setSelected(bl);
        if (bl || this.isWindows && this._windowsAuthenticate.isSelected()) {
            this._basicPanel.getDialog().usePassword(false);
        } else {
            this._basicPanel.getDialog().usePassword(true);
        }
    }

    void setWindowsAuthSelected(boolean bl) {
        this.isWindows = PlatformUtils.isWindows();
        this._windowsAuthenticate.setSelected(bl);
        if (bl && !this.isWindows) {
            this._basicPanel.getDialog().useUserName(true);
            this._basicPanel.getDialog().usePassword(true);
            this._autoPasswordCheck.setEnabled(true);
            this.add((Component)this._domainLbl, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 5, 0, 0), 0, 0));
            this.add((Component)this.tfdDomain, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 18, 2, new Insets(10, 5, 0, 0), 0, 0));
            this.revalidate();
            this.tfdDomain.setEditable(true);
            this.tfdDomain.setBackground(Color.WHITE);
        } else if (bl && this.isWindows) {
            this._autoPasswordCheck.setEnabled(false);
            this._basicPanel.getDialog().useUserName(false);
            this._basicPanel.getDialog().usePassword(false);
        } else {
            this._basicPanel.getDialog().useUserName(true);
            if (!this._autoPasswordCheck.isSelected()) {
                this._basicPanel.getDialog().usePassword(true);
            } else {
                this._basicPanel.getDialog().usePassword(false);
            }
            this._autoPasswordCheck.setEnabled(true);
            this.remove(this._domainLbl);
            this.remove(this.tfdDomain);
            this.revalidate();
        }
    }

    public void setDefaultPrompts() {
        this.tfdHost.setText("localhost");
        this.tfdPort.setText("1433");
        this._sqlServerDbComboBox.removeAllItems();
    }

    public void updatePrompts(Properties properties) {
        String string = properties.getProperty("hostname");
        this.tfdHost.setText(string);
        String string2 = properties.getProperty("port");
        this.tfdPort.setText(string2 != null ? string2 : "1433");
        boolean bl = Boolean.parseBoolean(properties.getProperty(SQLServerConnectionPanel.SQLSERVER_WINDOWS_AUTHENTICATION, "false"));
        this.setWindowsAuthSelected(bl);
        boolean bl2 = Boolean.parseBoolean(properties.getProperty(SQLServerConnectionPanel.SQLSERVER_DEFAULT_PASSWORD, "false"));
        this.setDefaultPasswordSelected(bl2);
        this.setDomain(properties.getProperty(SQLServerConnectionPanel.SQLSERVER_DOMAIN, ""));
    }
}

