/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate.boot;

import java.io.PrintStream;
import java.io.PrintWriter;
import oracle.ide.Ide;
import oracle.ide.IdeArgs;
import oracle.ide.IdeCore;
import oracle.ide.IdeStarter;
import oracle.ide.Version;

public class WebupdateStarter
extends IdeStarter {
    private String[] arguments;
    private String webupdate_usage_message = "Webupdate from command line.\n\n     \nUsage\n    ojwebupdate -zips=bundle.zip -bundles=bundle.name \n     \nParameter\n  -list | -l  List remote bundles available for this installation (will not attempt update)\n  -ignore-invalid-bundles | -i  List remote bundles available for this installation (will not attempt update)\n  -bundles=bundle1,bundle2 | -b=...   comman separated list of bundle names\n  -zips=/path/bundle1.zip,/path/bundle2.zip | -z=...   comman separated list of fully qualified zip file names\n  -verbose | -v Provide some diagnostic information, will also list any arguments the Command Line Update doesn't understand\n  -proxy=xxx-proxy.someplace.com:80\n  -properties=update.properties\n  \n  \nNotes\n  Both local bundles and extensions can be updated in the same properties file or the same command line\n  \nExamples\n  ojwebupdate -properties=update.properties\n     performs update based on what is in specified in update.properties\n  ojwebupdate update.properties -l\n     lists remote updates available\n  ojwebupdate -zips=/path/bundle1.zip,/path/bundle2.zip -bundles=bundle1.oracle,bundle2.oracle\n     \n  Proprerty file usage: \n  \n     -properties=file        Properties File, specifies the details of the webupdate.\n                 This file is optional, you can also specifiy properties on the command line using options,\n                 or can even use a properties file and add or override properties on the command line.\n     \n     proxy.hostname sets the proxy hostname\n     proxy.portnumber sets the proxy port number \n     bundle list each local bundle file on a separate line\n     extension list each remote bundle by ID on a separate line\n     \n     If proxy.hostname and proxy.portnumber are not specified ojwebupdate will use the proxy settings from the environment\n     \n     Example of a properties file\n         proxy.hostname=xxx-proxy.someplace.com \n         proxy.portnumber=80 \n         bundle=c:/updates/esdk_bundle.zip\n         bundle=c:/updates/my_bundle.zip\n         extension=oracle.jdeveloper.cvs\n     \n     \n";
    String webupdate_copyright_message = "Oracle " + Version.NAME_SHORT + " Command Line WebUpdate " + Version.VER + "." + Version.BUILD_NUM + "\n" + "Copyright (c) 2003-2012 Oracle. All Rights Reserved.";

    public String[] getArguments() {
        return this.arguments;
    }

    public void startIde(String command, String[] arguments, IdeCore core) {
        if (arguments.length == 0 || arguments.length == 1 && "-help".equals(arguments[0])) {
            this.printUsage();
            System.exit(0);
        }
        this.arguments = arguments;
        IdeArgs ideArgs = core.getIdeArgs();
        ideArgs.setCreateUI(false);
        try {
            Ide.startup((IdeCore)core);
        }
        catch (Throwable e) {
            this.fail(e.getMessage(), e);
        }
    }

    public void printUsage() {
        this.printCopyright();
        System.out.println(this.webupdate_usage_message);
        System.out.println();
    }

    private void printCopyright() {
        System.out.println(this.webupdate_copyright_message);
        System.out.println();
    }

    private void fail(String message, Throwable exception) {
        this.printLines(System.err, "ojwebupdate: " + message);
        if (exception != null) {
            exception.printStackTrace(System.err);
        }
        System.err.println();
        System.exit(1);
    }

    private void printLines(PrintStream stream, String ... lines) {
        PrintWriter writer = new PrintWriter(stream);
        for (String line : lines) {
            int end;
            int start = 0;
            while ((end = line.indexOf(10, start)) >= 0) {
                writer.write(line, start, end - start);
                start = end + 1;
                writer.println();
            }
            writer.write(line, start, line.length() - start);
            writer.println();
        }
        writer.flush();
    }
}

