/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.unit_test.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.unit_test.UtAddin;
import oracle.dbtools.unit_test.editor.UiArb;
import oracle.dbtools.unit_test.editor.UtLibraryEditor;
import oracle.dbtools.unit_test.testObjects.UtLibraryItem;
import oracle.dbtools.unit_test.utils.UiUtils;
import oracle.dbtools.unit_test.utils.UtUtils;
import oracle.ide.Context;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.view.View;
import oracle.javatools.icons.OracleIcons;

public class LibraryUsages
extends JPanel {
    private static final long serialVersionUID = 1L;
    private UtLibraryEditor _editor;
    private UsagesView _view;

    public LibraryUsages(UtLibraryEditor utLibraryEditor) {
        this._editor = utLibraryEditor;
        this._view = new UsagesView();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateUI(UtLibraryItem utLibraryItem) {
        Object object;
        DefaultMutableTreeNode defaultMutableTreeNode;
        UsagesRenderer usagesRenderer;
        block16: {
            this.removeAll();
            this.invalidate();
            this.setLayout(new BorderLayout());
            this.add((Component)this._view.getToolbar(), "North");
            usagesRenderer = new UsagesRenderer();
            usagesRenderer.setOpenIcon(OracleIcons.getIcon((String)"unit_test.png"));
            usagesRenderer.setClosedIcon(OracleIcons.getIcon((String)"unit_test.png"));
            defaultMutableTreeNode = new DefaultMutableTreeNode(UiArb.getString("LIBRARY_USAGES"), true);
            ResultSet resultSet = null;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            Connection connection = UtAddin.getRepositoryManager().getConnection();
            if (Connections.getInstance().lock(connection)) {
                try {
                    DefaultMutableTreeNode defaultMutableTreeNode2;
                    object = DBUtil.getInstance((Connection)connection);
                    object.setRaiseError(true);
                    String string = UtUtils.getQuery("libItemTestUsages");
                    hashMap.put("LIB_ID", utLibraryItem.getRef().getLibId());
                    resultSet = object.executeOracleQuery(string, hashMap);
                    if (resultSet != null) {
                        try {
                            while (resultSet.next()) {
                                defaultMutableTreeNode2 = new DefaultMutableTreeNode(new UsagesValue(UtAddin.testNodeIcon, resultSet.getString("NAME")), false);
                                defaultMutableTreeNode.add(defaultMutableTreeNode2);
                            }
                        }
                        finally {
                            DBUtil.closeResultSet((ResultSet)resultSet);
                        }
                    }
                    string = UtUtils.getQuery("libItemSuiteUsages");
                    hashMap.put("LIB_ID", utLibraryItem.getRef().getLibId());
                    resultSet = object.executeOracleQuery(string, hashMap);
                    if (resultSet == null) break block16;
                    try {
                        while (resultSet.next()) {
                            defaultMutableTreeNode2 = new DefaultMutableTreeNode(new UsagesValue(UtAddin.suiteNodeIcon, resultSet.getString("NAME")), false);
                            defaultMutableTreeNode.add(defaultMutableTreeNode2);
                        }
                    }
                    finally {
                        DBUtil.closeResultSet((ResultSet)resultSet);
                    }
                }
                catch (SQLException sQLException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                }
                finally {
                    Connections.getInstance().unlock(connection);
                }
            }
        }
        object = new JTree(defaultMutableTreeNode);
        ((JTree)object).setCellRenderer(usagesRenderer);
        this.add((Component)object, "West");
        this.invalidate();
    }

    class UsagesRenderer
    extends DefaultTreeCellRenderer {
        UsagesRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            Object object2 = defaultMutableTreeNode.getUserObject();
            if (object2 instanceof UsagesValue) {
                UsagesValue usagesValue = (UsagesValue)defaultMutableTreeNode.getUserObject();
                this.setIcon(usagesValue.getIcon());
            } else {
                this.setIcon(OracleIcons.getIcon((String)"unit_test.png"));
            }
            return this;
        }
    }

    class UsagesValue {
        private Icon _icon;
        private String _label;

        UsagesValue(Icon icon, String string) {
            this._icon = icon;
            this._label = string;
        }

        Icon getIcon() {
            return this._icon;
        }

        public String toString() {
            return this._label;
        }
    }

    class UsagesView
    extends View {
        private Toolbar _toolbar;
        private Controller myRefreshController = new Controller(){

            public boolean handleEvent(IdeAction ideAction, Context context) {
                LibraryUsages.this._editor.updateContent(false, true);
                return true;
            }

            public boolean update(IdeAction ideAction, Context context) {
                return true;
            }
        };

        UsagesView() {
            LibraryUsages.this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentShown(ComponentEvent componentEvent) {
                    LibraryUsages.this._editor.getRefreshAction().addController(UsagesView.this.myRefreshController);
                    View.updateToolbarActions((Toolbar)UsagesView.this.getToolbar());
                }

                @Override
                public void componentHidden(ComponentEvent componentEvent) {
                    LibraryUsages.this._editor.getRefreshAction().removeController(UsagesView.this.myRefreshController);
                    View.updateToolbarActions((Toolbar)UsagesView.this.getToolbar());
                }
            });
            LibraryUsages.this._editor.getRefreshAction().addController(this.myRefreshController);
            View.updateToolbarActions((Toolbar)this.getToolbar());
        }

        public Component getGUI() {
            return LibraryUsages.this;
        }

        public Toolbar getToolbar() {
            if (null == this._toolbar) {
                this._toolbar = new Toolbar();
                this._toolbar.addToggleButton((ToggleAction)LibraryUsages.this._editor.getPinToggleAction());
                this._toolbar.add((ToggleAction)LibraryUsages.this._editor.getRefreshAction());
                UiUtils.nameButtonsForQA(this._toolbar, "LibraryUsages");
            }
            return this._toolbar;
        }
    }
}

