/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.xml.dtd.grammar;

import oracle.bali.xml.grammar.AttributeDef;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.grammar.SimpleType;
import oracle.jdeveloper.xml.dtd.grammar.DtdGrammar;
import oracle.jdeveloper.xml.dtd.grammar.DtdGrammarComponent;

public class DtdAttribute
extends DtdGrammarComponent
implements AttributeDef {
    private DtdGrammar _grammar;
    private String _name;
    private String _targetNamespace;
    private QualifiedName _qualifiedName;
    private SimpleType _simpleType;
    private String _defValue;
    private String _fixedValue;
    private boolean _isRequired;

    DtdAttribute(DtdGrammar grammar, String name, boolean required, String defaultValue, String fixedValue, SimpleType simpleType) {
        this._grammar = grammar;
        this._name = grammar.isCaseSensitive() ? name : name.toLowerCase();
        this._isRequired = required;
        this._simpleType = simpleType;
        this._defValue = defaultValue;
        this._fixedValue = fixedValue;
        if (this._name.startsWith("xml")) {
            if (this._name.startsWith("xml:") && this._name.length() > 4) {
                this._name = this._name.substring(4);
                this._targetNamespace = "http://www.w3.org/XML/1998/namespace";
            } else if (this._name.startsWith("xmlns")) {
                if (this._name.startsWith("xmlns:")) {
                    this._name = this._name.substring(6);
                }
                this._targetNamespace = "http://www.w3.org/2000/xmlns/";
            }
        }
        this._simpleType.getConstrainingFacets();
    }

    public String getTargetNamespace() {
        return this._targetNamespace;
    }

    public String getName() {
        return this._name;
    }

    public QualifiedName getQualifiedName() {
        if (this._qualifiedName == null) {
            this._qualifiedName = QualifiedName.getQualifiedName(this.getTargetNamespace(), this.getName());
        }
        return this._qualifiedName;
    }

    public SimpleType getType() {
        return this._simpleType;
    }

    public boolean isRequired() {
        return this._isRequired;
    }

    public String getDefaultValue() {
        return this._defValue;
    }

    public String getFixedValue() {
        return this._fixedValue;
    }

    public boolean isReference() {
        return false;
    }

    public AttributeDef getReferencedAttributeDef() {
        return null;
    }

    String getMetadataElementName() {
        return "attributeMetadata";
    }
}

