/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.sax;

import java.util.Map;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.TreeWalker;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;

public class CreateIdToDomMapsXmlFilter
extends XMLFilterImpl {
    private final TreeWalker _walker;
    private final Map _idToDom;
    private final Map _domToId;

    public CreateIdToDomMapsXmlFilter(XMLReader parent, TreeWalker walker, Map idToDom, Map domToId) {
        super(parent);
        this._checkNull(walker, "TreeWalker");
        this._checkNull(idToDom, "ID to DOM map");
        this._checkNull(domToId, "DOM to ID map");
        this._walker = walker;
        this._idToDom = idToDom;
        this._domToId = domToId;
    }

    private void _checkNull(Object o, String desc) {
        if (o == null) {
            throw new IllegalArgumentException("Can not pass null " + desc + " to " + this.getClass().getName() + "!");
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        Node currentNode;
        String id = atts.getValue("id");
        if (id != null && (currentNode = this._walker.getCurrentNode()) != null) {
            this._idToDom.put(id, currentNode);
            this._domToId.put(currentNode, id);
        }
        super.startElement(uri, localName, qName, atts);
    }
}

