/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.grammar.schema;

import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.xml.grammar.AttributeDef;
import oracle.bali.xml.grammar.ContentGroup;
import oracle.bali.xml.grammar.ElementDef;
import oracle.bali.xml.grammar.GrammarException;
import oracle.bali.xml.grammar.IdentityConstraint;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.grammar.Type;
import oracle.bali.xml.grammar.schema.OracleAttributeDef;
import oracle.bali.xml.grammar.schema.OracleAttributeGroup;
import oracle.bali.xml.grammar.schema.OracleComplexType;
import oracle.bali.xml.grammar.schema.OracleContentGroup;
import oracle.bali.xml.grammar.schema.OracleElementDef;
import oracle.bali.xml.grammar.schema.OracleSchema;
import oracle.bali.xml.grammar.schema.OracleSimpleType;
import oracle.bali.xml.grammar.schema.OracleWildcard;
import oracle.bali.xml.grammar.schema.error.XmlErrorLog;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XMLSchemaNode;
import oracle.xml.parser.schema.XSDAny;
import oracle.xml.parser.schema.XSDAttrGroup;
import oracle.xml.parser.schema.XSDAttribute;
import oracle.xml.parser.schema.XSDBuilder;
import oracle.xml.parser.schema.XSDComplexType;
import oracle.xml.parser.schema.XSDElement;
import oracle.xml.parser.schema.XSDGroup;
import oracle.xml.parser.schema.XSDNode;
import oracle.xml.parser.schema.XSDSimpleType;
import oracle.xml.parser.v2.XMLError;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public final class OracleSchemaFactory {
    private Map _wrapperCache = Collections.synchronizedMap(new IdentityHashMap(313));
    private Map _typeCache = Collections.synchronizedMap(new IdentityHashMap(313));
    private Map _wildcardCache = Collections.synchronizedMap(new IdentityHashMap());
    private Map _schemaCache = Collections.synchronizedMap(new IdentityHashMap());
    private List<OracleElementDef> _elementDefsWithSubstitutionGroupList = Collections.synchronizedList(new ArrayList());
    private Map<QualifiedName, IdentityConstraint> _identityConstraintKeyCache = Collections.synchronizedMap(new HashMap());
    private XSDBuilder _xsdBuilder = null;
    private EntityResolver _resolver;
    private static Logger _logger = null;
    private static final OracleSchemaFactory _sSharedInstance = new OracleSchemaFactory();
    private static final String _SCHEMA_NAMESPACE = "http://www.w3.org/2001/XMLSchema";

    public OracleSchemaFactory() {
    }

    public OracleSchemaFactory(EntityResolver resolver) {
        this._resolver = resolver;
    }

    @Deprecated
    public static OracleSchemaFactory getSharedInstance() {
        return _sSharedInstance;
    }

    public static String validateSchemas(URL schemaLocation, XMLError error) throws Exception {
        if (schemaLocation == null) {
            throw new GrammarException("OracleSchema:: Schema Location cannot be null");
        }
        if (error == null) {
            error = new XMLError();
            error.setErrorStream((OutputStream)new NullOutputStream());
        }
        XSDBuilder privateBuilder = null;
        try {
            privateBuilder = new XSDBuilder();
            privateBuilder.setDebugMode(true);
        }
        catch (Exception e) {
            throw new GrammarException("OracleSchemaFactory:: Could not instantiate the Oracle Schema Processor");
        }
        privateBuilder.setError(error);
        XMLSchema dummy = privateBuilder.build(schemaLocation);
        return dummy.getSchemaTargetNS();
    }

    public OracleSchema[] buildSchemas(URL schemaLocation) throws GrammarException {
        return this.buildSchemas(schemaLocation, false);
    }

    public OracleSchema[] buildSchemas(URL schemaLocation, boolean useEntityResolverForRoot) throws GrammarException {
        return this.buildSchemas(schemaLocation, useEntityResolverForRoot, null);
    }

    public synchronized OracleSchema[] buildSchemas(URL schemaLocation, XMLError error) throws GrammarException {
        return this.buildSchemas(schemaLocation, false, error);
    }

    public synchronized OracleSchema[] buildSchemas(URL schemaLocation, boolean useEntityResolverForRoot, XMLError error) throws GrammarException {
        XmlErrorLog log;
        if (schemaLocation == null) {
            throw new GrammarException("OracleSchema:: Schema Location cannot be null");
        }
        boolean hasErrorLog = false;
        if (error == null) {
            error = new XmlErrorLog();
            error.setErrorStream((OutputStream)new NullOutputStream());
            hasErrorLog = true;
        }
        ArrayList<OracleSchema> newSchemas = Collections.EMPTY_LIST;
        XMLSchema xmlSchema = null;
        if (this._xsdBuilder == null) {
            try {
                this._xsdBuilder = new XSDBuilder();
                if (this._resolver != null) {
                    this._xsdBuilder.setEntityResolver(this._resolver);
                }
                boolean debugMode = false;
                try {
                    debugMode = Boolean.getBoolean("oracle.bali.xml.grammar.schema.debug");
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                this._xsdBuilder.setDebugMode(debugMode);
            }
            catch (Exception e) {
                throw new GrammarException("OracleSchemaFactory:: Could not instantiate the Oracle Schema Processor");
            }
        }
        this._xsdBuilder.setError(error);
        try {
            InputSource is = null;
            if (useEntityResolverForRoot && this._resolver != null) {
                is = this._resolver.resolveEntity(null, schemaLocation.toExternalForm());
            }
            xmlSchema = is != null ? this._xsdBuilder.build(is) : this._xsdBuilder.build(schemaLocation);
        }
        catch (Exception e) {
            OracleSchemaFactory._getLogger().log(Level.WARNING, "Errors processing schema:" + schemaLocation, e);
            xmlSchema = (XMLSchema)this._xsdBuilder.getObject();
        }
        if (hasErrorLog && (log = (XmlErrorLog)error).hasAnyErrors()) {
            String errors = ((XmlErrorLog)error).toString(true);
            OracleSchemaFactory._getLogger().log(Level.INFO, "Errors processing schema:" + schemaLocation + "\n" + errors);
        }
        if (xmlSchema != null) {
            String[] namespaces = xmlSchema.getAllTargetNS();
            newSchemas = new ArrayList<OracleSchema>(namespaces.length);
            for (int i = 0; i < namespaces.length; ++i) {
                OracleSchema currentSchema;
                String ns = namespaces[i];
                XMLSchemaNode currentNode = xmlSchema.getSchemaByTargetNS(ns);
                if (_SCHEMA_NAMESPACE.equals(ns) && (currentNode.getElementSet() == null || currentNode.getElementSet().length == 0) || (currentSchema = (OracleSchema)this._schemaCache.get(currentNode)) != null) continue;
                currentSchema = new OracleSchema(this, currentNode, schemaLocation);
                this._schemaCache.put(currentNode, currentSchema);
                newSchemas.add(currentSchema);
            }
            this._updateSubstitutionGroups();
        }
        OracleSchema[] schemaArray = new OracleSchema[newSchemas.size()];
        schemaArray = newSchemas.toArray(schemaArray);
        return schemaArray;
    }

    public Collection getOracleSchemas() {
        return Collections.unmodifiableCollection(this._schemaCache.values());
    }

    public ElementDef resolveElementReference(String refNamespace, String refLocalName) {
        XMLSchemaNode schemaNode;
        OracleSchema oracleSchema;
        XMLSchema xmlSchema;
        ElementDef referencedElementDef = null;
        if (refLocalName != null && (xmlSchema = this.getXMLSchema()) != null && (oracleSchema = (OracleSchema)this._schemaCache.get(schemaNode = xmlSchema.getSchemaByTargetNS(refNamespace))) != null) {
            referencedElementDef = oracleSchema.getElementDefByName(refLocalName);
        }
        return referencedElementDef;
    }

    public AttributeDef resolveAttributeReference(String refNamespace, String refLocalName) {
        XMLSchemaNode schemaNode;
        OracleSchema oracleSchema;
        XMLSchema xmlSchema;
        AttributeDef referencedAttributeDef = null;
        if (refNamespace != null && refLocalName != null && (xmlSchema = this.getXMLSchema()) != null && (oracleSchema = (OracleSchema)this._schemaCache.get(schemaNode = xmlSchema.getSchemaByTargetNS(refNamespace))) != null) {
            referencedAttributeDef = oracleSchema.getAttributeDefByName(refLocalName);
        }
        return referencedAttributeDef;
    }

    public Type resolveTypeReference(String refNamespace, String refLocalName) {
        XMLSchemaNode schemaNode;
        OracleSchema oracleSchema;
        XMLSchema xmlSchema;
        Type referencedType = null;
        if (refNamespace != null && refLocalName != null && (xmlSchema = this.getXMLSchema()) != null && (oracleSchema = (OracleSchema)this._schemaCache.get(schemaNode = xmlSchema.getSchemaByTargetNS(refNamespace))) != null) {
            referencedType = oracleSchema.getTypeByName(refLocalName);
        }
        return referencedType;
    }

    public ContentGroup resolveContentGroupReference(String refNamespace, String refLocalName) {
        XMLSchemaNode schemaNode;
        OracleSchema oracleSchema;
        XMLSchema xmlSchema;
        ContentGroup referencedContentGroup = null;
        if (refNamespace != null && refLocalName != null && (xmlSchema = this.getXMLSchema()) != null && (oracleSchema = (OracleSchema)this._schemaCache.get(schemaNode = xmlSchema.getSchemaByTargetNS(refNamespace))) != null) {
            referencedContentGroup = oracleSchema.getContentGroupByName(refLocalName);
        }
        return referencedContentGroup;
    }

    public synchronized XMLSchema getXMLSchema() {
        XMLSchema schema = null;
        if (this._xsdBuilder != null) {
            schema = (XMLSchema)this._xsdBuilder.getObject();
        }
        return schema;
    }

    public void clearCache() {
        this._xsdBuilder = null;
        this._schemaCache.clear();
        this._wrapperCache.clear();
        this._typeCache.clear();
        this._wildcardCache.clear();
    }

    OracleElementDef getElementWrapper(XSDElement xsdElement) {
        OracleElementDef wrapper = null;
        if (xsdElement != null && (wrapper = (OracleElementDef)this._wrapperCache.get(xsdElement)) == null) {
            wrapper = new OracleElementDef(this, xsdElement);
            this._wrapperCache.put(xsdElement, wrapper);
        }
        return wrapper;
    }

    OracleAttributeDef getAttributeWrapper(XSDAttribute xsdAttribute) {
        OracleAttributeDef wrapper = null;
        if (xsdAttribute != null && (wrapper = (OracleAttributeDef)this._wrapperCache.get(xsdAttribute)) == null) {
            wrapper = new OracleAttributeDef(this, xsdAttribute);
            this._wrapperCache.put(xsdAttribute, wrapper);
        }
        return wrapper;
    }

    OracleSimpleType getSimpleTypeWrapper(XSDSimpleType xsdSimpleType) {
        OracleSimpleType wrapper = null;
        if (xsdSimpleType != null && (wrapper = (OracleSimpleType)this._typeCache.get(xsdSimpleType)) == null) {
            wrapper = new OracleSimpleType(this, xsdSimpleType);
            this._typeCache.put(xsdSimpleType, wrapper);
        }
        return wrapper;
    }

    OracleComplexType getComplexTypeWrapper(XSDComplexType xsdComplexType) {
        OracleComplexType wrapper = null;
        if (xsdComplexType != null && (wrapper = (OracleComplexType)this._typeCache.get(xsdComplexType)) == null) {
            wrapper = new OracleComplexType(this, xsdComplexType);
            this._typeCache.put(xsdComplexType, wrapper);
        }
        return wrapper;
    }

    Type getTypeWrapper(XSDNode xsdType) {
        Type wrapper = null;
        if (xsdType != null) {
            if (xsdType instanceof XSDSimpleType) {
                XSDSimpleType simpleType = (XSDSimpleType)xsdType;
                wrapper = this.getSimpleTypeWrapper(simpleType);
            } else if (xsdType instanceof XSDComplexType) {
                XSDComplexType complexType = (XSDComplexType)xsdType;
                wrapper = this.getComplexTypeWrapper(complexType);
            }
        }
        return wrapper;
    }

    OracleContentGroup getContentGroupWrapper(XSDGroup xsdGroup) {
        OracleContentGroup wrapper = null;
        if (xsdGroup != null && (wrapper = (OracleContentGroup)this._typeCache.get(xsdGroup)) == null) {
            wrapper = new OracleContentGroup(this, xsdGroup);
            this._typeCache.put(xsdGroup, wrapper);
        }
        return wrapper;
    }

    OracleAttributeGroup getAttributeGroupWrapper(XSDAttrGroup xsdAttrGroup) {
        OracleAttributeGroup wrapper = null;
        if (xsdAttrGroup != null && (wrapper = (OracleAttributeGroup)this._typeCache.get(xsdAttrGroup)) == null) {
            wrapper = new OracleAttributeGroup(this, xsdAttrGroup);
            this._typeCache.put(xsdAttrGroup, wrapper);
        }
        return wrapper;
    }

    OracleWildcard getWildcardWrapper(XSDAny xsdAny) {
        OracleWildcard wrapper = null;
        if (xsdAny != null && (wrapper = (OracleWildcard)this._wildcardCache.get(xsdAny)) == null) {
            wrapper = new OracleWildcard(xsdAny);
            this._wildcardCache.put(xsdAny, wrapper);
        }
        return wrapper;
    }

    void addElementDefWithSubstitutionGroup(OracleElementDef elementDef) {
        this._elementDefsWithSubstitutionGroupList.add(elementDef);
    }

    private void _updateSubstitutionGroups() {
        int size = this._elementDefsWithSubstitutionGroupList.size();
        OracleElementDef current = null;
        for (int i = 0; i < size; ++i) {
            current = this._elementDefsWithSubstitutionGroupList.get(i);
            current.updateSubstitutionGroup();
        }
    }

    void addKeyIdentityConstraint(QualifiedName keyName, IdentityConstraint keyIdentityConstraintDef) {
        this._identityConstraintKeyCache.put(keyName, keyIdentityConstraintDef);
    }

    IdentityConstraint getKeyIdentityConstraint(QualifiedName keyName) {
        return this._identityConstraintKeyCache.get(keyName);
    }

    private static Logger _getLogger() {
        if (_logger == null) {
            _logger = Logger.getLogger("oracle.bali.xml.grammar");
        }
        return _logger;
    }

    static class NullOutputStream
    extends OutputStream {
        NullOutputStream() {
        }

        public void write(int b) {
        }
    }
}

