/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.compiler;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;

class IdeStorageMap {
    private HashMap hash;

    private IdeStorageMap(HashMap hash) {
        this.hash = hash;
    }

    public static IdeStorageMap create(URLPath urlPath) {
        HashMap hash = new HashMap();
        Iterator nodes = NodeFactory.getCachedNodes();
        while (nodes.hasNext()) {
            URL base;
            URL url;
            String protocol;
            Node node = (Node)nodes.next();
            if (!node.isOpen() || !node.isDirty() || !node.isNew() || (protocol = (url = node.getURL()).getProtocol()) == null || !protocol.equals("file") || (base = IdeStorageMap.getBaseFor(urlPath, url)) == null) continue;
            URL parent = URLFileSystem.getParent((URL)url);
            while (parent != null && !base.equals(url) && URLFileSystem.isBaseURLFor((URL)base, (URL)url)) {
                String filename = URLFileSystem.getFileName((URL)url);
                ArrayList<String> bucket = (ArrayList<String>)hash.get(parent);
                if (bucket == null) {
                    bucket = new ArrayList<String>();
                    bucket.add(filename);
                    hash.put(parent, bucket);
                } else if (!bucket.contains(filename)) {
                    bucket.add(filename);
                }
                url = parent;
                parent = URLFileSystem.getParent((URL)url);
            }
        }
        return hash.size() > 0 ? new IdeStorageMap(hash) : null;
    }

    public ArrayList get(URL url) {
        ArrayList bucket = (ArrayList)this.hash.get(url);
        return bucket == null ? null : (ArrayList)bucket.clone();
    }

    public void destroy() {
        this.hash.clear();
        this.hash = null;
    }

    private static URL getBaseFor(URLPath urlPath, URL url) {
        URL[] entries = urlPath.getEntries();
        for (int i = 0; i < entries.length; ++i) {
            URL base = entries[i];
            if (!URLFileSystem.isBaseURLFor((URL)base, (URL)url)) continue;
            return base;
        }
        return null;
    }
}

