/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util.options.oracle;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import oracle.dbtools.crest.model.design.storage.oracle.IndexProxyOracle;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.AbstractPropertyDialog;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;
import oracle.dbtools.crest.util.options.oracle.OracleIndexTemplate;

public class OracleIndexTemplateDialog
extends CustomDialog {
    private JDialog dialog;
    protected JPanel general;
    private JButton bnOK;
    private JButton bnCancel;
    private JComboBox cbBitmapIndex;
    private JComboBox cbPartitioned;
    private JTextField tfTableSpace;
    private JComboBox cbLogging;
    private JTextField tfSegment;
    private JIntegerField ifCompress;
    private JComboBox cbParallel;
    private JTextField tfDegree;
    private JComboBox cbSortedRows;
    private JComboBox cbComputeStats;
    private JComboBox cbOnline;
    private Dimension dim = new Dimension(150, 20);
    private OracleIndexTemplate oit;

    public OracleIndexTemplateDialog(ApplicationView appView, OracleIndexTemplate oit) {
        super(appView);
        this.oit = oit;
        this.general = new JPanel(new SpringLayout());
        this.general.setPreferredSize(new Dimension(280, 350));
        this.general.setBorder(BorderFactory.createEtchedBorder());
        this.initGeneralView();
        JPanel pnButtons = new JPanel(new FlowLayout(2));
        this.bnOK = new JButton(this.createOKButton());
        this.bnOK.setMnemonic(79);
        this.bnCancel = new JButton(this.createCancelButton());
        this.bnCancel.setMnemonic(67);
        pnButtons.add(this.bnOK);
        pnButtons.add(this.bnCancel);
        this.bnOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.add((Component)this.general, "Center");
        this.add((Component)pnButtons, "South");
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog(this.getApplicationView().getFrame(), Messages.getString("OracleIndexTemplateDialog.OracleIndexTemplate"), false);
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.setContentPane(this);
            this.dialog.getRootPane().setDefaultButton(this.bnOK);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setResizable(false);
            this.dialog.setModal(true);
            CommonUtil.centerOnScreen(this.dialog);
        }
        return this.dialog;
    }

    public void showDialog() {
        this.initOptions();
        this.getDialog().setVisible(true);
    }

    @Override
    protected String getHelpIndex() {
        return "";
    }

    private void initOptions() {
        this.cbBitmapIndex.setSelectedItem(this.oit.isBitmapIndex() ? AbstractPropertyDialog.YES : AbstractPropertyDialog.NO);
        this.cbPartitioned.setSelectedItem(this.oit.getPartitioned());
        this.tfTableSpace.setText(this.oit.getTableSpace());
        this.cbLogging.setSelectedItem(AbstractPropertyDialog.translateYesNoForDisplay(this.oit.getLogging()));
        this.tfSegment.setText(this.oit.getSegment());
        this.ifCompress.setValue((long)this.oit.getCompress());
        this.cbParallel.setSelectedItem(AbstractPropertyDialog.translateYesNoForDisplay(this.oit.getParallel()));
        this.tfDegree.setText(this.oit.getDegree());
        this.cbSortedRows.setSelectedItem(this.oit.getSortedRows());
        this.cbComputeStats.setSelectedItem(AbstractPropertyDialog.translateYesNoForDisplay(this.oit.getComputeStatistics()));
        this.cbOnline.setSelectedItem(AbstractPropertyDialog.translateYesNoForDisplay(this.oit.getOnline()));
    }

    private void setOptions() {
        Object selected = this.cbBitmapIndex.getSelectedItem();
        boolean result = String.valueOf(selected).equalsIgnoreCase(AbstractPropertyDialog.YES);
        this.oit.setBitmapIndex(result);
        this.oit.setPartitioned((String)this.cbPartitioned.getSelectedItem());
        this.oit.setTableSpace(this.tfTableSpace.getText());
        this.oit.setLogging(AbstractPropertyDialog.translateYesNoForStorage((String)this.cbLogging.getSelectedItem()));
        this.oit.setSegment(this.tfSegment.getText());
        this.oit.setCompress(this.ifCompress.getIntValue());
        this.oit.setParallel(AbstractPropertyDialog.translateYesNoForStorage((String)this.cbParallel.getSelectedItem()));
        this.oit.setDegree(this.tfDegree.getText());
        this.oit.setSortedRows((String)this.cbSortedRows.getSelectedItem());
        this.oit.setComputeStatistics(AbstractPropertyDialog.translateYesNoForStorage((String)this.cbComputeStats.getSelectedItem()));
        this.oit.setOnline(AbstractPropertyDialog.translateYesNoForStorage((String)this.cbOnline.getSelectedItem()));
    }

    private void initGeneralView() {
        this.initBitmapIndex();
        this.initPartitioned();
        this.initTableSpace();
        this.initLogging();
        this.initSegment();
        this.initCompress();
        this.initParallel();
        this.initDegree();
        this.initSortedRows();
        this.initComputeStats();
        this.initOnline();
    }

    protected SpringLayout getGeneralLayout() {
        return (SpringLayout)this.general.getLayout();
    }

    protected void setLabelConstraints(JLabel label, int y) {
        SpringLayout.Constraints labelCons = this.getGeneralLayout().getConstraints(label);
        labelCons.setX(Spring.constant(10));
        labelCons.setY(Spring.constant(y));
    }

    protected void setObjectConstraints(Component c, int x, int y) {
        SpringLayout.Constraints labelCons = this.getGeneralLayout().getConstraints(c);
        labelCons.setX(Spring.constant(x));
        labelCons.setY(Spring.constant(y));
    }

    protected void setObjectConstraints(Component c, int y) {
        SpringLayout.Constraints labelCons = this.getGeneralLayout().getConstraints(c);
        labelCons.setX(Spring.constant(120));
        labelCons.setY(Spring.constant(y));
    }

    private void initBitmapIndex() {
        JLabel label = new JLabel(Messages.getString("OracleIndexTemplateDialog.BitmapIndex"));
        this.general.add(label);
        this.cbBitmapIndex = new JComboBox<String>(AbstractPropertyDialog.YES_NO);
        this.cbBitmapIndex.setPreferredSize(this.dim);
        this.general.add(this.cbBitmapIndex);
        this.setLabelConstraints(label, 20);
        this.setObjectConstraints(this.cbBitmapIndex, 20);
    }

    private void initPartitioned() {
        JLabel label = new JLabel(Messages.getString("OracleIndexTemplateDialog.Partitioned"));
        this.general.add(label);
        this.cbPartitioned = new JComboBox<String>(IndexProxyOracle.getPartitionedChoices());
        this.cbPartitioned.setPreferredSize(this.dim);
        this.general.add(this.cbPartitioned);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.cbPartitioned, 50);
    }

    private void initTableSpace() {
        JLabel label = new JLabel(Messages.getString("OracleIndexTemplateDialog.TableSpace"));
        this.general.add(label);
        this.tfTableSpace = new JTextField();
        this.tfTableSpace.setPreferredSize(this.dim);
        this.general.add(this.tfTableSpace);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.tfTableSpace, 80);
    }

    private void initLogging() {
        JLabel label = new JLabel(Messages.getString("OracleIndexTemplateDialog.Logging"));
        this.general.add(label);
        this.cbLogging = new JComboBox<String>(AbstractPropertyDialog.EMPTY_YES_NO);
        this.cbLogging.setPreferredSize(this.dim);
        this.general.add(this.cbLogging);
        this.setLabelConstraints(label, 110);
        this.setObjectConstraints(this.cbLogging, 110);
    }

    private void initSegment() {
        JLabel label = new JLabel(Messages.getString("OracleIndexTemplateDialog.Segment"));
        this.general.add(label);
        this.tfSegment = new JTextField();
        this.tfSegment.setPreferredSize(this.dim);
        this.general.add(this.tfSegment);
        this.setLabelConstraints(label, 140);
        this.setObjectConstraints(this.tfSegment, 140);
    }

    private void initCompress() {
        JLabel label = new JLabel(Messages.getString("OracleIndexTemplateDialog.Compress"));
        this.general.add(label);
        this.ifCompress = new JIntegerField();
        this.ifCompress.setPreferredSize(this.dim);
        this.general.add(this.ifCompress);
        this.setLabelConstraints(label, 170);
        this.setObjectConstraints(this.ifCompress, 170);
    }

    private void initParallel() {
        JLabel label = new JLabel(Messages.getString("OracleIndexTemplateDialog.Parallel"));
        this.general.add(label);
        this.cbParallel = new JComboBox<String>(AbstractPropertyDialog.YES_NO);
        this.cbParallel.setPreferredSize(this.dim);
        this.general.add(this.cbParallel);
        this.setLabelConstraints(label, 200);
        this.setObjectConstraints(this.cbParallel, 200);
    }

    private void initDegree() {
        JLabel label = new JLabel(Messages.getString("OracleIndexTemplateDialog.Degree"));
        this.general.add(label);
        this.tfDegree = new JTextField();
        this.tfDegree.setPreferredSize(this.dim);
        this.general.add(this.tfDegree);
        this.setLabelConstraints(label, 230);
        this.setObjectConstraints(this.tfDegree, 230);
    }

    private void initSortedRows() {
        JLabel label = new JLabel(Messages.getString("OracleIndexTemplateDialog.SortedRows"));
        this.general.add(label);
        this.cbSortedRows = new JComboBox<String>(IndexProxyOracle.getSortedRowsChoices());
        this.cbSortedRows.setPreferredSize(this.dim);
        this.general.add(this.cbSortedRows);
        this.setLabelConstraints(label, 260);
        this.setObjectConstraints(this.cbSortedRows, 260);
    }

    private void initComputeStats() {
        JLabel label = new JLabel(Messages.getString("OracleIndexTemplateDialog.ComputeStats"));
        this.general.add(label);
        this.cbComputeStats = new JComboBox<String>(AbstractPropertyDialog.YES_NO);
        this.cbComputeStats.setPreferredSize(this.dim);
        this.general.add(this.cbComputeStats);
        this.setLabelConstraints(label, 290);
        this.setObjectConstraints(this.cbComputeStats, 290);
    }

    private void initOnline() {
        JLabel label = new JLabel(Messages.getString("OracleIndexTemplateDialog.Online"));
        this.general.add(label);
        this.cbOnline = new JComboBox<String>(AbstractPropertyDialog.YES_NO);
        this.cbOnline.setPreferredSize(this.dim);
        this.general.add(this.cbOnline);
        this.setLabelConstraints(label, 320);
        this.setObjectConstraints(this.cbOnline, 320);
    }

    public Action createOKButton() {
        AbstractAction action = new AbstractAction(Messages.getString("OracleIndexTemplateDialog.OK")){

            @Override
            public void actionPerformed(ActionEvent e) {
                OracleIndexTemplateDialog.this.setOptions();
                OracleIndexTemplateDialog.this.close();
            }
        };
        return action;
    }

    public Action createCancelButton() {
        AbstractAction action = new AbstractAction(Messages.getString("OracleIndexTemplateDialog.Cancel")){

            @Override
            public void actionPerformed(ActionEvent e) {
                OracleIndexTemplateDialog.this.close();
            }
        };
        return action;
    }
}

