/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util.gui.swing;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class SortedJListModel
extends DefaultListModel {
    private List<SortedListEntry> sortedModel;
    private ListModel unsortedModel;
    private Comparator comparator;
    private SortOrder sortOrder;

    private SortedJListModel() {
    }

    public SortedJListModel(ListModel model) {
        this(model, SortOrder.ASCENDING, null);
    }

    public SortedJListModel(ListModel model, SortOrder sortOrder) {
        this(model, sortOrder, null);
    }

    public SortedJListModel(ListModel model, SortOrder sortOrder, Comparator comp) {
        this.unsortedModel = model;
        this.unsortedModel.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                SortedJListModel.this.unsortedIntervalAdded(e);
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                SortedJListModel.this.unsortedIntervalRemoved(e);
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                SortedJListModel.this.unsortedContentsChanged(e);
            }
        });
        this.sortOrder = sortOrder;
        this.comparator = comp != null ? comp : Collator.getInstance();
        int size = model.getSize();
        this.sortedModel = new ArrayList<SortedListEntry>(size);
        for (int x = 0; x < size; ++x) {
            SortedListEntry entry = new SortedListEntry(x);
            int insertionPoint = this.findInsertionPoint(entry);
            this.sortedModel.add(insertionPoint, entry);
        }
    }

    @Override
    public Object getElementAt(int index) throws IndexOutOfBoundsException {
        if (this.sortedModel.size() == 0) {
            return null;
        }
        int modelIndex = this.toUnsortedModelIndex(index);
        Object element = this.unsortedModel.getElementAt(modelIndex);
        return element;
    }

    @Override
    public int getSize() {
        int size = this.sortedModel.size();
        return size;
    }

    public int toUnsortedModelIndex(int index) throws IndexOutOfBoundsException {
        int modelIndex = -1;
        SortedListEntry entry = this.sortedModel.get(index);
        modelIndex = entry.getIndex();
        return modelIndex;
    }

    public int[] toUnsortedModelIndices(int[] sortedSelectedIndices) {
        int[] unsortedSelectedIndices = new int[sortedSelectedIndices.length];
        int x = 0;
        for (int sortedIndex : sortedSelectedIndices) {
            unsortedSelectedIndices[x++] = this.toUnsortedModelIndex(sortedIndex);
        }
        Arrays.sort(unsortedSelectedIndices);
        return unsortedSelectedIndices;
    }

    public int toSortedModelIndex(int unsortedIndex) {
        int sortedIndex = -1;
        int x = -1;
        for (SortedListEntry entry : this.sortedModel) {
            ++x;
            if (entry.getIndex() != unsortedIndex) continue;
            sortedIndex = x;
            break;
        }
        return sortedIndex;
    }

    public int[] toSortedModelIndices(int[] unsortedModelIndices) {
        int[] sortedModelIndices = new int[unsortedModelIndices.length];
        int x = 0;
        for (int unsortedIndex : unsortedModelIndices) {
            sortedModelIndices[x++] = this.toSortedModelIndex(unsortedIndex);
        }
        Arrays.sort(sortedModelIndices);
        return sortedModelIndices;
    }

    private void resetModelData() {
        int index = 0;
        for (SortedListEntry entry : this.sortedModel) {
            entry.setIndex(index++);
        }
    }

    public void setComparator(Comparator comp) {
        if (comp == null) {
            this.sortOrder = SortOrder.UNORDERED;
            this.comparator = Collator.getInstance();
            this.resetModelData();
        } else {
            this.comparator = comp;
            Collections.sort(this.sortedModel);
        }
        this.fireContentsChanged(0, 0, this.sortedModel.size() - 1);
    }

    public void setSortOrder(SortOrder sortOrder) {
        if (this.sortOrder != sortOrder) {
            this.sortOrder = sortOrder;
            if (sortOrder == SortOrder.UNORDERED) {
                this.resetModelData();
            } else {
                Collections.sort(this.sortedModel);
            }
            this.fireContentsChanged(0, 0, this.sortedModel.size() - 1);
        }
    }

    private void unsortedIntervalAdded(ListDataEvent e) {
        int begin = e.getIndex0();
        int end = e.getIndex1();
        int nElementsAdded = end - begin + 1;
        for (SortedListEntry entry : this.sortedModel) {
            int index = entry.getIndex();
            if (index < begin) continue;
            entry.setIndex(index + nElementsAdded);
        }
        for (int x = begin; x <= end; ++x) {
            SortedListEntry newEntry = new SortedListEntry(x);
            int insertionPoint = this.findInsertionPoint(newEntry);
            this.sortedModel.add(insertionPoint, newEntry);
            this.fireIntervalAdded(1, insertionPoint, insertionPoint);
        }
    }

    private void unsortedIntervalRemoved(ListDataEvent e) {
        int x;
        int begin = e.getIndex0();
        int end = e.getIndex1();
        int nElementsRemoved = end - begin + 1;
        int sortedSize = this.sortedModel.size();
        boolean[] bElementRemoved = new boolean[sortedSize];
        for (x = sortedSize - 1; x >= 0; --x) {
            SortedListEntry entry = this.sortedModel.get(x);
            int index = entry.getIndex();
            if (index > end) {
                entry.setIndex(index - nElementsRemoved);
                continue;
            }
            if (index < begin) continue;
            this.sortedModel.remove(x);
            bElementRemoved[x] = true;
        }
        for (x = bElementRemoved.length - 1; x >= 0; --x) {
            if (!bElementRemoved[x]) continue;
            this.fireIntervalRemoved(2, x, x);
        }
    }

    private void unsortedContentsChanged(ListDataEvent e) {
        Collections.sort(this.sortedModel);
        this.fireContentsChanged(0, 0, this.sortedModel.size() - 1);
    }

    private int findInsertionPoint(SortedListEntry entry) {
        int insertionPoint = this.sortedModel.size();
        if (this.sortOrder != SortOrder.UNORDERED && (insertionPoint = Collections.binarySearch(this.sortedModel, entry)) < 0) {
            insertionPoint = -(insertionPoint + 1);
        }
        return insertionPoint;
    }

    class SortedListEntry
    implements Comparable {
        private int index;

        private SortedListEntry() {
        }

        public SortedListEntry(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public int compareTo(Object o) {
            Object thisElement = SortedJListModel.this.unsortedModel.getElementAt(this.index);
            SortedListEntry thatEntry = (SortedListEntry)o;
            Object thatElement = SortedJListModel.this.unsortedModel.getElementAt(thatEntry.getIndex());
            if (SortedJListModel.this.comparator instanceof Collator) {
                thisElement = thisElement.toString();
                thatElement = thatElement.toString();
            }
            int comparison = SortedJListModel.this.comparator.compare(thisElement, thatElement);
            if (SortedJListModel.this.sortOrder == SortOrder.DESCENDING) {
                comparison = -comparison;
            }
            return comparison;
        }
    }

    public static enum SortOrder {
        UNORDERED,
        ASCENDING,
        DESCENDING;

    }
}

