/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.TreeMap;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import oracle.dbtools.crest.util.CreateSearchPanelConstants;

public class MetadataXML2HTMLDoc {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws TransformerException, TransformerConfigurationException, FileNotFoundException, IOException {
        FileOutputStream fosIndex = null;
        FileOutputStream fosList = null;
        FileOutputStream fosDetails = null;
        TreeMap<String, String> allClassesAndParents = null;
        String clName = "";
        try {
            String tmp;
            TransformerFactory tFactory = TransformerFactory.newInstance();
            File xslList = new File("src/oracle/dbtools/crest/util/metadata_list.xsl");
            Transformer transformerList = tFactory.newTransformer(new StreamSource(xslList));
            File xslDetails = new File("src/oracle/dbtools/crest/util/metadata_details.xsl");
            Transformer transformerDetails = tFactory.newTransformer(new StreamSource(xslDetails));
            String indexFilePath = "ide.template/datamodeler/xmlmetadata/doc/index.html";
            String listFilePath = "ide.template/datamodeler/xmlmetadata/doc/list.html";
            String detailsFilePath = "ide.template/datamodeler/xmlmetadata/doc/details.html";
            File f = new File(indexFilePath);
            if (f.exists()) {
                f.delete();
            }
            fosIndex = new FileOutputStream(indexFilePath);
            String htmlString = "<html xmlns=\"http://www.w3.org/1999/xhtml\">\n\t<head>\n\t\t<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">\n\t\t<title>XML Metadata</title>\n\t</head>\n\t<frameset cols=\"20%,80%\">\n\t\t<frame name=\"list\" src=\"list.html\">\n\t\t<frame name=\"details\" src=\"details.html\">\n\t</frameset>\n</html>";
            fosIndex.write(htmlString.getBytes());
            fosIndex.flush();
            fosIndex.close();
            f = new File(listFilePath);
            if (f.exists()) {
                f.delete();
            }
            String htmlCodeStart = "<html xmlns=\"http://www.w3.org/1999/xhtml\">\n\t<head>\n\t\t<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"/>\n\t\t<style>\n\t\t\tdiv.tab div{height:21px;float:left;margin:0;}\n\t\t\tdiv.tab div a{margin:0 8px;height:21px;line-height:21px;display:block;text-decoration:none;vertical-align:middle;float:left;}\n\t\t</style>\n\t\t<script>\n\t\tfunction $x(pNd){\n\t\t\tvar lThis;\n\t\t\tswitch(typeof (pNd)){\n\t\t\t\tcase 'string':lThis = document.getElementById(pNd);break;\n\t\t\t\tcase 'object':lThis = pNd;break;\n\t\t\t\tdefault:return false;break;\n\t\t\t}\n\t\t\treturn (lThis.nodeType == 1)?lThis:false;\n\t\t}\n\t\tvar gRegex=false;\n\t\tvar gHeight=0;\n\t\tfunction $d_Find(pThis,pString,pTags,pClass){\n\t\t       if(!pTags){pTags = 'DIV';}\n\t\t       pThis = $x(pThis);\n\t\t       if(pThis){\n\t\t           var d=pThis.getElementsByTagName(pTags);\n\t\t           pThis.style.display=\"none\";\n\t\t           if(!gRegex){gRegex =new RegExp(\"test\");}\n\t\t           gRegex.compile(pString,\"i\");\n\t\t           for(var i=0,len=d.length ;i<len;i++){\n\t\t               if(gRegex.test(d[i].innerHTML)){\n\t\t                   d[i].style.display=\"table-row\";\n\t\t                   d[i].style.visiblilty=\"visible\";\n\t\t                   d[i].style.height=gHeight;\n\t\t               } else{\n\t\t                   if ( gHeight==0)  gHeight=d[i].style.height;\n\t\t                   d[i].style.height='0';\n\t\t                   d[i].style.display=\"none\";\n\t\t                   d[i].style.visiblilty=\"hidden\";\n\t\t               }\n\t\t           }\n\t\t       pThis.style.display=\"block\";\n\t\t   }\n\t\t   return;\n\t\t}\n\t\t</script>\n\t</head>\n\t<body>\n\t\t<table id=\"toc_table\" width=\"100%\" style=\"empty-cells:show; font-family:Tahoma; font-size:small; text-align:left; vertical-align:top; word-wrap:break-word;\">\n\t\t\t<tr>\n\t\t\t\t<td style=\"color:navy; font-family:Tahoma; font-size:small; font-style:italic; font-weight:bold;\">Content</td>\n\t\t\t</tr>\n\t\t\t<tr>\n\t\t\t\t<td style=\"color:navy; font-family:Tahoma; font-size:small; font-style:italic; font-weight:bold;\"><input type=\"text\" onkeyup=\"$d_Find('toc_list',this.value,'a')\"/></td>\n\t\t\t</tr>\n\t\t\t<tr><td>&nbsp;</td></tr>\n\t\t</table>\n\t\t<div id=\"toc_list\">\n";
            fosList = new FileOutputStream(listFilePath);
            fosList.write(htmlCodeStart.getBytes());
            fosList.flush();
            f = new File(detailsFilePath);
            if (f.exists()) {
                f.delete();
            }
            htmlCodeStart = "<html xmlns=\"http://www.w3.org/1999/xhtml\">\n\t<head>\n\t\t<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"/>\n\t</head>\n\t<body>\n";
            fosDetails = new FileOutputStream(detailsFilePath);
            fosDetails.write(htmlCodeStart.getBytes());
            fosDetails.flush();
            System.out.println("Reading XML files from /ide.template/datamodeler/xmlmetadata ...");
            System.out.println("\n");
            File directory = new File("ide.template/datamodeler/xmlmetadata");
            List<File> listOfFiles = Arrays.asList(directory.listFiles());
            Collections.sort(listOfFiles, new FileComparator());
            for (int i = 0; i < listOfFiles.size(); ++i) {
                int mid;
                File xmlFile;
                String fileName;
                String extension;
                if (!listOfFiles.get(i).isFile() || !(extension = (fileName = (xmlFile = listOfFiles.get(i)).getName()).substring((mid = fileName.lastIndexOf(".")) + 1, fileName.length())).equals("xml")) continue;
                System.out.println("File " + fileName + " ... done.");
                transformerList.transform(new StreamSource(xmlFile), new StreamResult(fosList));
                transformerDetails.transform(new StreamSource(xmlFile), new StreamResult(fosDetails));
            }
            String htmlCodeEnd = "\n\t\t</div>\n\t</body>\n</html>";
            fosList.write(htmlCodeEnd.getBytes());
            fosList.flush();
            fosList.close();
            htmlCodeEnd = "\n\t</body>\n</html>";
            fosDetails.write(htmlCodeEnd.getBytes());
            fosDetails.flush();
            fosDetails.close();
            allClassesAndParents = new TreeMap<String, String>();
            block6: for (int i = 0; i < listOfFiles.size(); ++i) {
                if (!listOfFiles.get(i).isFile()) continue;
                File xmlFile = listOfFiles.get(i);
                String fileName = xmlFile.getName();
                Scanner in = null;
                boolean result = false;
                in = new Scanner(new FileReader(xmlFile));
                while (in.hasNextLine() && !result) {
                    String line = in.nextLine();
                    int pk = line.indexOf("parentClass");
                    if (pk < 0) continue;
                    String cls = line.substring(1, pk - 1);
                    String parent = line.substring(pk + 13, line.indexOf("\"", pk + 13));
                    allClassesAndParents.put(cls, parent);
                    continue block6;
                }
            }
            ArrayList<String> list = new ArrayList<String>();
            BufferedReader reader = new BufferedReader(new FileReader(detailsFilePath));
            while ((tmp = reader.readLine()) != null) {
                list.add(tmp);
                if (tmp.contains("<a name=")) {
                    clName = tmp.substring(tmp.indexOf("<a name=") + 9, tmp.indexOf("\">"));
                }
                if (!tmp.contains("Parent class : <a href=")) continue;
                list.add("<br/>");
                list.add("Subclasses :");
                for (String sc : MetadataXML2HTMLDoc.getSubclasses(allClassesAndParents, clName)) {
                    String scName = sc.substring(sc.lastIndexOf(".") + 1, sc.length());
                    list.add("<a href=\"#" + sc + "\">" + scName + "</a>");
                }
            }
            reader.close();
            BufferedWriter writer = new BufferedWriter(new FileWriter(detailsFilePath));
            for (int i = 0; i < list.size(); ++i) {
                writer.write(list.get(i) + "\r\n");
            }
            writer.flush();
            writer.close();
            CreateSearchPanelConstants.recreateFiles();
            System.out.println("\nCompleted.");
        }
        catch (Exception e) {
            System.out.println(e);
        }
        finally {
            if (fosIndex != null) {
                fosIndex.close();
            }
            if (fosList != null) {
                fosList.close();
            }
            if (fosDetails != null) {
                fosDetails.close();
            }
        }
    }

    public static List getSubclasses(Map map, Object value) {
        ArrayList<String> list = new ArrayList<String>();
        for (Object o : map.keySet()) {
            if (!map.get(o).equals(value)) continue;
            list.add((String)o);
        }
        Collections.sort(list, new NComparator());
        return list;
    }

    static class NComparator
    implements Comparator {
        NComparator() {
        }

        public int compare(Object o1, Object o2) {
            String f1 = (String)o1;
            String f2 = (String)o2;
            return f1.substring(f1.lastIndexOf("."), f1.length()).compareTo(f2.substring(f2.lastIndexOf("."), f2.length()));
        }
    }

    static class FileComparator
    implements Comparator {
        FileComparator() {
        }

        public int compare(Object o1, Object o2) {
            File f1 = (File)o1;
            File f2 = (File)o2;
            return f1.getName().compareTo(f2.getName());
        }
    }
}

