/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util;

import java.awt.Component;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.util.Messages;
import oracle.ide.Ide;

public class BirtReports_JavaMaker {
    RelationalDesign pdes;
    String tab = "  ";
    String tab2 = "    ";
    private List columnNames = new ArrayList();
    private String dirName;
    int cols_in_row = 3;

    public void generate(File textFile, RelationalDesign pdes) {
        int result;
        this.pdes = pdes;
        if (textFile.exists() && (result = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("BirtReports_JavaMaker.FileExists"), textFile.getAbsolutePath()), Messages.getString("BirtReports_JavaMaker.Warning"), 0, 3, this.getConfiguration().getIcon("SAVE_ICON", 32))) == 1) {
            return;
        }
        StringBuffer content = this.generateContent();
        textFile.getParentFile().mkdirs();
        try {
            textFile.createNewFile();
        }
        catch (IOException e) {
            // empty catch block
        }
        PrintWriter out = null;
        try {
            out = new PrintWriter(new BufferedOutputStream(new FileOutputStream(textFile)));
        }
        catch (FileNotFoundException e) {
            out = null;
        }
        if (out != null) {
            out.print(content.toString());
            out.flush();
            out.close();
        }
    }

    private StringBuffer generateContent() {
        StringBuffer sb = new StringBuffer();
        sb.append("import java.util.ArrayList;");
        sb.append("\nimport java.util.List;\n");
        sb.append("\npublic class BirtJavaClasses {");
        Iterator it = this.pdes.getTableSet().iterator();
        while (it.hasNext()) {
            Table table = (Table)it.next();
            sb.append("\n\n");
            this.processTable(table, sb);
        }
        sb.append("\n}");
        return sb;
    }

    public void setDirName(String dirName) {
        this.dirName = dirName;
    }

    private void processTable(Table table, StringBuffer sb) {
        sb.append("    public static class ").append(table.getName().trim()).append(" {\n");
        sb.append(this.tab).append("        private static List columnNames = new ArrayList();\n");
        sb.append(this.tab).append("        private static List dataTypes = new ArrayList();");
        this.addConstructor(table, sb);
        sb.append(this.tab).append("\n        public static List getColumnNames() {");
        sb.append(this.tab).append("\n            return columnNames;");
        sb.append(this.tab).append("\n        }");
        sb.append(this.tab).append("\n        public static List getDataTypes() {");
        sb.append(this.tab).append("\n            return dataTypes;");
        sb.append(this.tab).append("\n        }");
        sb.append("\n    }");
    }

    private void addConstructor(Table table, StringBuffer sb) {
        sb.append("\n        public ").append(table.getName().trim()).append("() {");
        for (Column column : table.getElementsCollection()) {
            sb.append("\n            ").append("columnNames.add(\"").append(column.getName().trim()).append("\");");
            sb.append("\n            ").append("dataTypes.add(\"").append(this.getDataType(column).trim()).append("\");");
        }
        sb.append("\n        }");
    }

    private GUIConfiguration getConfiguration() {
        return GUIConfiguration.getInstance();
    }

    public List getColumnNames() {
        return this.columnNames;
    }

    public String getDirName() {
        return this.dirName;
    }

    private String getDataType(Column element) {
        if (element.getDataType() instanceof StructuredType && element.isReference()) {
            return "REF " + element.getDataType().toString();
        }
        if (element.getDataType() instanceof DistinctType) {
            DistinctType dt = (DistinctType)element.getDataType();
            return dt.getName();
        }
        return element.getDataType().toString();
    }
}

