/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.wizards.reports;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.SpringLayout;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import oracle.dbtools.crest.exports.reports.DifferentVersionException;
import oracle.dbtools.crest.exports.reports.SchemaFactory;
import oracle.dbtools.crest.model.ChangeRequest;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.Measurement;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.glossary.Glossary;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.RelationalDesignSet;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.metadata.ClassDescription;
import oracle.dbtools.crest.model.metadata.MetaDataManager;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.editor.UserDefinedProperty;
import oracle.dbtools.crest.swingui.search.SearchResultObject;
import oracle.dbtools.crest.swingui.wizards.metadata.ColorTableCellRenderer;
import oracle.dbtools.crest.swingui.wizards.metadata.DMConnectionModel;
import oracle.dbtools.crest.swingui.wizards.metadata.connection.ConnectionInfo;
import oracle.dbtools.crest.swingui.wizards.metadata.connection.FCPConnectionDialog;
import oracle.dbtools.crest.swingui.wizards.reports.BaseReportsGenerationDialog;
import oracle.dbtools.crest.swingui.wizards.reports.CustomReportTemplate;
import oracle.dbtools.crest.swingui.wizards.reports.CustomReportTemplatesPersistence;
import oracle.dbtools.crest.swingui.wizards.reports.CustomReportsTemplatesDialog;
import oracle.dbtools.crest.swingui.wizards.reports.Messages;
import oracle.dbtools.crest.swingui.wizards.reports.RenderPDFReport;
import oracle.dbtools.crest.swingui.wizards.reports.ReportColumn;
import oracle.dbtools.crest.swingui.wizards.reports.ReportConstants;
import oracle.dbtools.crest.swingui.wizards.reports.ReportSection;
import oracle.dbtools.crest.swingui.wizards.reports.ReportTemplatesPersistence;
import oracle.dbtools.crest.swingui.wizards.reports.ReportUtils;
import oracle.dbtools.crest.swingui.wizards.reports.ReportsGenerator;
import oracle.dbtools.crest.swingui.wizards.reports.ReportsHTMLTOC;
import oracle.dbtools.crest.swingui.wizards.reports.SaxonLoader;
import oracle.dbtools.crest.swingui.wizards.reports.SearchResultsReportsGenerationDialog;
import oracle.dbtools.crest.swingui.wizards.reports.SelectGlossaryDialog;
import oracle.dbtools.crest.swingui.wizards.reports.StandardReportConfiguration;
import oracle.dbtools.crest.swingui.wizards.reports.StandardReportConfigurationsPersistence;
import oracle.dbtools.crest.swingui.wizards.reports.StandardReportTemplate;
import oracle.dbtools.crest.swingui.wizards.reports.StandardReportsConfigurationDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.ToStringComparator;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.ide.Ide;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFilter;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.DatabaseConnections;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.BFILE;
import oracle.sql.ORAData;

public class ReportsGenerationDialog
extends BaseReportsGenerationDialog {
    private final String captionSingleTableDetails = "Table Details";
    private final String captionAllTablesDetails = "All Tables Details";
    private final String captionSingleEntityDetails = "Entity Details";
    private final String captionAllEntitiesDetails = "All Entities Details";
    private final String captionSingleSTDetails = "Structured Type Details";
    private final String captionAllSTDetails = "All Structured Types Details";
    private final String captionSingleDTDetails = "Distinct Type Details";
    private final String captionAllDTDetails = "All Distinct Types Details";
    private final String captionSingleCTDetails = "Collection Type Details";
    private final String captionAllCTDetails = "All Collection Type Details";
    private final String captionAllDomainDetails = "All Domains Details";
    private final String captionMeasurementsDetails = "Measurements Details";
    private final String captionUDP = "User Defined Properties";
    private final String captionGlossaryDetails = "Glossary Details";
    private final String captionCRDetails = "Change Requests Details";
    private static StandardReportConfiguration blankSR = new StandardReportConfiguration(null, " ", "", "", "", true, new ArrayList(), new ArrayList());
    private ToStringComparator toStringComparator = new ToStringComparator();
    private JPanel reportingSchemaPanel;
    private JPanel loadedDesignsPanel;
    private JComboBox cmbReports;
    private JComboBox cmbDesignsLDP = new JComboBox();
    private JComboBox cmbModelsLDP = new JComboBox();
    private JComboBox cmbStandardReportConfigurationsLDP = new JComboBox();
    private JButton btnStandardReportConfigurationsLDP = new JButton(Messages.getString("ReportsGenerationDialog.Manage"));
    private JComboBox cmbDesignsRSP = new JComboBox();
    private JComboBox cmbModelsRSP = new JComboBox();
    private JComboBox cmbStandardReportConfigurationsRSP = new JComboBox();
    private JButton btnStandardReportConfigurationsRSP = new JButton(Messages.getString("ReportsGenerationDialog.Manage"));
    private String selectedGlossaryOVID = "";
    private JTextField txtReportsDir = new JTextField();
    private JTable tbConnections = new JTable(new DMConnectionModel(DatabaseConnections.getInstance(), true));
    private JButton btnProps;
    private JButton btnRemove;
    private JButton btnTest;
    private JButton btnReloadDesignsAndModels;
    private JButton btnGenerateRGD;
    private List selectedObjectsList = null;
    private static boolean srLoaded = false;
    private JButton btnAdd = new JButton();
    private JCheckBox chbClearLMDiagrams = new JCheckBox(Messages.getString("ReportsGenerationDialog.ClearDiagrams"));
    private JCheckBox chbClearRSDiagrams = new JCheckBox(Messages.getString("ReportsGenerationDialog.ClearDiagrams"));
    private JTabbedPane tpane;
    private static File lastFolder = null;
    private InputStream bfileBinaryStream;
    private Connection connection = null;
    private ReportsGenerationDialog rgd;
    private File xsltFile = null;
    private String tocTagName = "";
    private String reportFileName = "";
    private StandardReportConfigurationsPersistence srp;
    private List allConfigurationsList;
    private List allRSObjectsList;
    private ReportsComboListener reportsComboListener;
    private LDDesignsComboListener ldDesignsComboListener;
    private RSDesignsComboListener rsDesignsComboListener;
    private LDModelsComboListener ldModelsComboListener;
    private RSModelsComboListener rsModelsComboListener;
    private LDReportConfigurationsComboListener ldReportConfigurationsComboListener;
    private RSReportConfigurationsComboListener rsReportConfigurationsComboListener;
    private List allRSModelsList;
    private List allRSSubViewsList;
    private Class clazz;
    private BaseReportsGenerationDialog.ManageTemplatesAction manageTemplatesAction;
    private ARRAY objects;
    private JPanel customReportsTemplatesPanel;
    private JButton btnManageCustomTemplates;
    private JCheckBox chbReplaceBooleanValues;
    private ReportUtils.SortedComboBoxModel cmbTrueModel;
    private ReportUtils.SortedComboBoxModel cmbFalseModel;
    private JComboBox cmbTrue;
    private JComboBox cmbFalse;
    private CustomReportTemplatesPersistence customReportTemplatesPersistence;
    private static boolean replaceBooleanValues;
    private MetaDataManager metaDataManager;
    private DesignPart currentModel;
    private static final Logger LOGGER;

    public ReportsGenerationDialog(ApplicationView appView, HashMap extraParams) {
        super(appView, Collections.emptyList(), extraParams);
        this.appView = appView;
        this.rgd = this;
        this.customReportTemplatesPersistence = new CustomReportTemplatesPersistence(appView);
        this.mainPanel.setPreferredSize(new Dimension(460, 700));
        this.reportTemplatesPersistence = new ReportTemplatesPersistence(appView);
        this.loadReportTemplates();
        this.loadCustomReportTemplates();
        this.metaDataManager = appView.getXMLTransformationManager().getMetaDataManager();
        this.srp = new StandardReportConfigurationsPersistence(appView);
        this.loadReportCinfigurations();
        this.allConfigurationsList = appView.getStandardReportConfigurations();
        this.reportsComboListener = new ReportsComboListener();
        this.ldDesignsComboListener = new LDDesignsComboListener();
        this.ldModelsComboListener = new LDModelsComboListener();
        this.ldReportConfigurationsComboListener = new LDReportConfigurationsComboListener();
        this.rsReportConfigurationsComboListener = new RSReportConfigurationsComboListener();
        this.rsDesignsComboListener = new RSDesignsComboListener();
        this.rsModelsComboListener = new RSModelsComboListener();
        this.initNorthPanel();
        this.initCenterPanel();
        this.cmbReports.setSelectedIndex(-1);
        this.cmbReports.setSelectedIndex(0);
    }

    @Override
    public boolean showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
        return this.result;
    }

    private void initNorthPanel() {
        this.reportsPanel.setPreferredSize(new Dimension(400, 135));
        JLabel lblReports = new JLabel(Messages.getString("ReportsGenerationDialog.AvailableReports"));
        lblReports.setPreferredSize(new Dimension(130, 20));
        CommonUtil.setLabelConstraints((SpringLayout)this.reportsPanel.getLayout(), lblReports, 5, 3);
        this.cmbReports = new JComboBox();
        this.cmbReports.setMaximumRowCount(10);
        this.cmbReports.setPreferredSize(new Dimension(140, 20));
        CommonUtil.setObjectConstraints((SpringLayout)this.reportsPanel.getLayout(), this.cmbReports, 140, 3);
        for (String r : this.getReportsList()) {
            this.cmbReports.addItem(r);
        }
        this.cmbReports.addItemListener(this.reportsComboListener);
        this.clazz = Table.class;
        this.reportsPanel.add(lblReports);
        this.reportsPanel.add(this.cmbReports);
        CommonUtil.setLabelConstraints((SpringLayout)this.reportsPanel.getLayout(), this.lblOutFormat, 5, 27);
        CommonUtil.setObjectConstraints((SpringLayout)this.reportsPanel.getLayout(), this.cmbOutFormat, 140, 27);
        CommonUtil.setLabelConstraints((SpringLayout)this.reportsPanel.getLayout(), this.lblVMOptions, 200, 27);
        CommonUtil.setObjectConstraints((SpringLayout)this.reportsPanel.getLayout(), this.txtVMOptions, 300, 27);
        CommonUtil.setLabelConstraints((SpringLayout)this.reportsPanel.getLayout(), this.lblTtitle, 5, 54);
        CommonUtil.setObjectConstraints((SpringLayout)this.reportsPanel.getLayout(), this.txtReportTtitle, 140, 54);
        CommonUtil.setLabelConstraints((SpringLayout)this.reportsPanel.getLayout(), this.lblFileName, 5, 81);
        CommonUtil.setObjectConstraints((SpringLayout)this.reportsPanel.getLayout(), this.txtReportFileName, 140, 81);
    }

    private void initCenterPanel() {
        JPanel centerPanel = new JPanel(new BorderLayout());
        this.standardReportsTemplatesPanel = new JPanel(new SpringLayout());
        this.standardReportsTemplatesPanel.setPreferredSize(new Dimension(400, 30));
        this.cmbStandardTemplates = new JComboBox();
        this.cmbStandardTemplates.setPreferredSize(new Dimension(315, 20));
        this.cmbStandardTemplates.setRenderer(new BaseReportsGenerationDialog.StandardComboBoxRenderer());
        CommonUtil.setObjectConstraints((SpringLayout)this.standardReportsTemplatesPanel.getLayout(), this.cmbStandardTemplates, 5, 5);
        this.btnManageStandardTemplates = new JButton(Messages.getString("ReportTemplatesDialog.Manage"));
        this.btnManageStandardTemplates.setMnemonic(77);
        this.btnManageStandardTemplates.setPreferredSize(new Dimension(105, 20));
        CommonUtil.setObjectConstraints((SpringLayout)this.standardReportsTemplatesPanel.getLayout(), this.btnManageStandardTemplates, 325, 5);
        this.manageTemplatesAction = new BaseReportsGenerationDialog.ManageTemplatesAction();
        this.btnManageStandardTemplates.addActionListener(this.manageTemplatesAction);
        this.standardReportsTemplatesPanel.add(this.cmbStandardTemplates);
        this.standardReportsTemplatesPanel.add(this.btnManageStandardTemplates);
        this.customReportsTemplatesPanel = new JPanel(new SpringLayout());
        this.cmbCustomTemplates = new JComboBox();
        this.cmbCustomTemplates.setPreferredSize(new Dimension(315, 20));
        this.cmbCustomTemplates.setRenderer(new BaseReportsGenerationDialog.CustomComboBoxRenderer());
        CommonUtil.setObjectConstraints((SpringLayout)this.customReportsTemplatesPanel.getLayout(), this.cmbCustomTemplates, 5, 5);
        this.cmbCustomTemplates.removeAllItems();
        this.cmbCustomTemplates.addItem(blankCRT);
        for (CustomReportTemplate crt : this.appView.getCustomReportTemplates()) {
            if (crt.getClazz() != this.clazz) continue;
            this.cmbCustomTemplates.addItem(crt);
        }
        this.cmbCustomTemplates.updateUI();
        this.btnManageCustomTemplates = new JButton(Messages.getString("ReportTemplatesDialog.Manage"));
        this.btnManageCustomTemplates.setMnemonic(77);
        this.btnManageCustomTemplates.setPreferredSize(new Dimension(105, 20));
        CommonUtil.setObjectConstraints((SpringLayout)this.customReportsTemplatesPanel.getLayout(), this.btnManageCustomTemplates, 325, 5);
        this.btnManageCustomTemplates.addActionListener(new CustomReportsAction());
        this.chbReplaceBooleanValues = new JCheckBox(Messages.getString("BaseReportsGenerationDialog.ReplaceBooleanValues"));
        CommonUtil.setObjectConstraints((SpringLayout)this.customReportsTemplatesPanel.getLayout(), this.chbReplaceBooleanValues, 5, 35);
        JLabel lblTrue = new JLabel(Messages.getString("BaseReportsGenerationDialog.True"));
        CommonUtil.setObjectConstraints((SpringLayout)this.customReportsTemplatesPanel.getLayout(), lblTrue, 200, 35);
        this.cmbTrueModel = new ReportUtils.SortedComboBoxModel(arrTrue);
        this.cmbTrue = new JComboBox(this.cmbTrueModel);
        this.cmbTrue.setEnabled(false);
        this.cmbTrue.setPreferredSize(new Dimension(60, 20));
        CommonUtil.setObjectConstraints((SpringLayout)this.customReportsTemplatesPanel.getLayout(), this.cmbTrue, 240, 35);
        this.cmbTrue.setEditable(true);
        JLabel lblFalse = new JLabel(Messages.getString("BaseReportsGenerationDialog.False"));
        CommonUtil.setObjectConstraints((SpringLayout)this.customReportsTemplatesPanel.getLayout(), lblFalse, 335, 35);
        this.cmbFalseModel = new ReportUtils.SortedComboBoxModel(arrFalse);
        this.cmbFalse = new JComboBox(this.cmbFalseModel);
        this.cmbFalse.setEnabled(false);
        this.cmbFalse.setPreferredSize(new Dimension(60, 20));
        CommonUtil.setObjectConstraints((SpringLayout)this.customReportsTemplatesPanel.getLayout(), this.cmbFalse, 375, 35);
        this.cmbFalse.setEditable(true);
        this.chbReplaceBooleanValues.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ReportsGenerationDialog.this.cmbTrue.setEnabled(true);
                    ReportsGenerationDialog.this.cmbFalse.setEnabled(true);
                    replaceBooleanValues = true;
                } else {
                    ReportsGenerationDialog.this.cmbTrue.setEnabled(false);
                    ReportsGenerationDialog.this.cmbFalse.setEnabled(false);
                    replaceBooleanValues = false;
                }
                ReportsGenerationDialog.this.chbReplaceBooleanValues.setSelected(replaceBooleanValues);
            }
        });
        this.chbReplaceBooleanValues.setSelected(false);
        this.customReportsTemplatesPanel.add(this.cmbCustomTemplates);
        this.customReportsTemplatesPanel.add(this.btnManageCustomTemplates);
        this.customReportsTemplatesPanel.add(this.chbReplaceBooleanValues);
        this.customReportsTemplatesPanel.add(lblTrue);
        this.customReportsTemplatesPanel.add(lblFalse);
        this.customReportsTemplatesPanel.add(this.cmbTrue);
        this.customReportsTemplatesPanel.add(this.cmbFalse);
        this.templatesTabbedPane = new JTabbedPane();
        this.templatesTabbedPane.setBorder(BorderFactory.createTitledBorder(Messages.getString("ReportTemplatesDialog.ReportTemplates")));
        this.templatesTabbedPane.setPreferredSize(new Dimension(400, 100));
        this.templatesTabbedPane.addTab(Messages.getString("BaseReportsGenerationDialog.Standard"), this.standardReportsTemplatesPanel);
        this.templatesTabbedPane.addTab(Messages.getString("BaseReportsGenerationDialog.Custom"), this.customReportsTemplatesPanel);
        this.templatesTabbedPane.setToolTipTextAt(1, Messages.getString("ReportsGenerationDialog.LoadedDesignsOnly"));
        this.templatesTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (ReportsGenerationDialog.this.templatesTabbedPane.getSelectedComponent() == ReportsGenerationDialog.this.customReportsTemplatesPanel) {
                    ReportsGenerationDialog.this.cmbOutFormat.removeItem("RTF");
                    if (ReportsGenerationDialog.this.cmbFormatsmodel.getIndexOf("XLS") == -1) {
                        ReportsGenerationDialog.this.cmbOutFormat.addItem("XLS");
                    }
                    if (ReportsGenerationDialog.this.cmbFormatsmodel.getIndexOf("XLSX") == -1) {
                        ReportsGenerationDialog.this.cmbOutFormat.addItem("XLSX");
                    }
                    if (((String)ReportsGenerationDialog.this.cmbReports.getSelectedItem()).equalsIgnoreCase("Glossaries")) {
                        ReportsGenerationDialog.this.btnGenerate.setEnabled(false);
                    } else if (ReportsGenerationDialog.this.tpane.getSelectedComponent() == ReportsGenerationDialog.this.loadedDesignsPanel) {
                        ReportsGenerationDialog.this.btnGenerate.setEnabled(true);
                    } else if (ReportsGenerationDialog.this.tpane.getSelectedComponent() == ReportsGenerationDialog.this.reportingSchemaPanel) {
                        ReportsGenerationDialog.this.btnGenerate.setEnabled(false);
                    }
                } else if (ReportsGenerationDialog.this.templatesTabbedPane.getSelectedComponent() == ReportsGenerationDialog.this.standardReportsTemplatesPanel) {
                    if (ReportsGenerationDialog.this.cmbFormatsmodel.getIndexOf("RTF") == -1) {
                        ReportsGenerationDialog.this.cmbOutFormat.addItem("RTF");
                    }
                    ReportsGenerationDialog.this.cmbOutFormat.removeItem("XLS");
                    ReportsGenerationDialog.this.cmbOutFormat.removeItem("XLSX");
                    if (((String)ReportsGenerationDialog.this.cmbReports.getSelectedItem()).equalsIgnoreCase("Glossaries")) {
                        ReportsGenerationDialog.this.btnGenerate.setEnabled(false);
                    } else {
                        ReportsGenerationDialog.this.btnGenerate.setEnabled(true);
                    }
                }
            }
        });
        JPanel designsPanel = new JPanel(new BorderLayout());
        designsPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("ReportsGenerationDialog.Designs")));
        this.tpane = new JTabbedPane();
        this.tpane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (e.getSource() instanceof JTabbedPane) {
                    ReportsGenerationDialog.this.adujstSettings(false);
                    if (ReportsGenerationDialog.this.tpane.getSelectedComponent() == ReportsGenerationDialog.this.loadedDesignsPanel) {
                        if (!((String)ReportsGenerationDialog.this.cmbReports.getSelectedItem()).equalsIgnoreCase("Glossaries")) {
                            ReportsGenerationDialog.this.cmbCustomTemplates.setEnabled(true);
                            ReportsGenerationDialog.this.btnManageCustomTemplates.setEnabled(true);
                            ReportsGenerationDialog.this.chbReplaceBooleanValues.setEnabled(true);
                            ReportsGenerationDialog.this.cmbFalse.setEnabled(true);
                            ReportsGenerationDialog.this.cmbTrue.setEnabled(true);
                            ReportsGenerationDialog.this.btnGenerate.setEnabled(true);
                        }
                    } else if (ReportsGenerationDialog.this.tpane.getSelectedComponent() == ReportsGenerationDialog.this.reportingSchemaPanel) {
                        ReportsGenerationDialog.this.cmbCustomTemplates.setEnabled(false);
                        ReportsGenerationDialog.this.btnManageCustomTemplates.setEnabled(false);
                        ReportsGenerationDialog.this.chbReplaceBooleanValues.setEnabled(false);
                        ReportsGenerationDialog.this.cmbFalse.setEnabled(false);
                        ReportsGenerationDialog.this.cmbTrue.setEnabled(false);
                        if (ReportsGenerationDialog.this.templatesTabbedPane.getSelectedComponent() == ReportsGenerationDialog.this.customReportsTemplatesPanel) {
                            ReportsGenerationDialog.this.btnGenerate.setEnabled(false);
                        } else if (ReportsGenerationDialog.this.templatesTabbedPane.getSelectedComponent() == ReportsGenerationDialog.this.standardReportsTemplatesPanel) {
                            ReportsGenerationDialog.this.btnGenerate.setEnabled(true);
                        }
                    }
                }
            }
        });
        this.initDesignsPanel();
        this.initReportingSchemaPanel();
        designsPanel.add(this.tpane);
        centerPanel.add((Component)this.templatesTabbedPane, "North");
        centerPanel.add((Component)designsPanel, "Center");
        this.mainPanel.add((Component)centerPanel, "Center");
    }

    private void initDesignsPanel() {
        this.loadedDesignsPanel = new JPanel(new SpringLayout());
        this.loadedDesignsPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("ReportsGenerationDialog.Designs")));
        JLabel lblDesigns = new JLabel(Messages.getString("ReportsGenerationDialog.AvailableDesigns"));
        lblDesigns.setPreferredSize(new Dimension(140, 20));
        CommonUtil.setLabelConstraints((SpringLayout)this.loadedDesignsPanel.getLayout(), lblDesigns, 5, 25);
        this.loadedDesignsPanel.add(lblDesigns);
        Object[] designs = this.appView.getDesigns().toArray();
        for (int l = 0; l < designs.length; ++l) {
            this.cmbDesignsLDP.addItem(designs[l]);
        }
        this.cmbDesignsLDP.addItemListener(this.ldDesignsComboListener);
        this.cmbDesignsLDP.setPreferredSize(new Dimension(265, 20));
        CommonUtil.setObjectConstraints((SpringLayout)this.loadedDesignsPanel.getLayout(), this.cmbDesignsLDP, 160, 25);
        this.loadedDesignsPanel.add(this.cmbDesignsLDP);
        JLabel lblModels = new JLabel(Messages.getString("ReportsGenerationDialog.AvailableModels"));
        lblModels.setPreferredSize(new Dimension(140, 20));
        CommonUtil.setLabelConstraints((SpringLayout)this.loadedDesignsPanel.getLayout(), lblModels, 5, 50);
        this.loadedDesignsPanel.add(lblModels);
        this.cmbModelsLDP.setPreferredSize(new Dimension(265, 20));
        CommonUtil.setObjectConstraints((SpringLayout)this.loadedDesignsPanel.getLayout(), this.cmbModelsLDP, 160, 50);
        this.loadedDesignsPanel.add(this.cmbModelsLDP);
        this.cmbStandardReportConfigurationsLDP.setPreferredSize(new Dimension(155, 20));
        this.cmbStandardReportConfigurationsLDP.setRenderer(new StandardReportRenderer());
        CommonUtil.setObjectConstraints((SpringLayout)this.loadedDesignsPanel.getLayout(), this.cmbStandardReportConfigurationsLDP, 160, 75);
        this.loadedDesignsPanel.add(this.cmbStandardReportConfigurationsLDP);
        JLabel lblStandardReports = new JLabel(Messages.getString("ReportsGenerationDialog.ReportConfiguration"));
        lblStandardReports.setPreferredSize(new Dimension(140, 20));
        CommonUtil.setLabelConstraints((SpringLayout)this.loadedDesignsPanel.getLayout(), lblStandardReports, 5, 75);
        this.loadedDesignsPanel.add(lblStandardReports);
        this.btnStandardReportConfigurationsLDP.setPreferredSize(new Dimension(105, 20));
        this.btnStandardReportConfigurationsLDP.addActionListener(new ShowStandardReportConfigurationsAction());
        CommonUtil.setObjectConstraints((SpringLayout)this.loadedDesignsPanel.getLayout(), this.btnStandardReportConfigurationsLDP, 320, 75);
        this.loadedDesignsPanel.add(this.btnStandardReportConfigurationsLDP);
        this.chbClearLMDiagrams.setToolTipText(Messages.getString("ReportsGenerationDialog.ClearDiagramsTooltip"));
        CommonUtil.setObjectConstraints((SpringLayout)this.loadedDesignsPanel.getLayout(), this.chbClearLMDiagrams, 5, 100);
        this.loadedDesignsPanel.add(this.chbClearLMDiagrams);
        this.tpane.addTab(Messages.getString("ReportsGenerationDialog.LoadedDesigns"), this.loadedDesignsPanel);
        this.reloadModels();
        this.reloadReportConfigurations(true);
    }

    private void reloadModels() {
        if (this.tpane.getSelectedIndex() == 0) {
            this.cmbModelsLDP.removeItemListener(this.ldModelsComboListener);
            this.cmbModelsLDP.removeAllItems();
        } else if (this.tpane.getSelectedIndex() == 1) {
            this.cmbModelsRSP.removeItemListener(this.rsModelsComboListener);
            this.cmbModelsRSP.removeAllItems();
        }
        List fullList = this.getFullModelList();
        if (fullList != null) {
            Iterator it = fullList.iterator();
            if (((String)this.cmbReports.getSelectedItem()).equalsIgnoreCase("Entities")) {
                while (it.hasNext()) {
                    RSchemaModel rSchemaModel;
                    Object ob = it.next();
                    if (ob instanceof LogicalDesign) {
                        this.cmbModelsLDP.addItem(ob);
                        continue;
                    }
                    if (!(ob instanceof RSchemaModel) || !(rSchemaModel = (RSchemaModel)ob).getType().equals(Messages.getString("ReportsGenerationDialog.Logical")) || !rSchemaModel.getDesignOVID().equals(((RSchemaDesign)this.cmbDesignsRSP.getSelectedItem()).getDesignOVID())) continue;
                    this.cmbModelsRSP.addItem(rSchemaModel);
                }
            } else if (((String)this.cmbReports.getSelectedItem()).equalsIgnoreCase("Tables")) {
                while (it.hasNext()) {
                    RSchemaModel rSchemaModel;
                    Object ob = it.next();
                    if (ob instanceof RelationalDesign) {
                        if (!((RelationalDesign)ob).isLoaded()) continue;
                        this.cmbModelsLDP.addItem(ob);
                        continue;
                    }
                    if (!(ob instanceof RSchemaModel) || !(rSchemaModel = (RSchemaModel)ob).getType().equals(Messages.getString("ReportsGenerationDialog.Relational")) || !rSchemaModel.getDesignOVID().equals(((RSchemaDesign)this.cmbDesignsRSP.getSelectedItem()).getDesignOVID())) continue;
                    this.cmbModelsRSP.addItem(rSchemaModel);
                }
            } else if (((String)this.cmbReports.getSelectedItem()).equalsIgnoreCase("Structured Types") || ((String)this.cmbReports.getSelectedItem()).equalsIgnoreCase("Distinct Types") || ((String)this.cmbReports.getSelectedItem()).equalsIgnoreCase("Collection Types")) {
                while (it.hasNext()) {
                    RSchemaModel rSchemaModel;
                    Object ob = it.next();
                    if (ob instanceof DataTypesDesign) {
                        this.cmbModelsLDP.addItem(ob);
                        continue;
                    }
                    if (!(ob instanceof RSchemaModel) || !(rSchemaModel = (RSchemaModel)ob).getType().equals(Messages.getString("ReportsGenerationDialog.DataTypes")) || !rSchemaModel.getDesignOVID().equals(((RSchemaDesign)this.cmbDesignsRSP.getSelectedItem()).getDesignOVID())) continue;
                    this.cmbModelsRSP.addItem(rSchemaModel);
                }
            }
            if (this.tpane.getSelectedIndex() == 0) {
                this.cmbModelsLDP.addItemListener(this.ldModelsComboListener);
                this.cmbModelsLDP.setSelectedIndex(-1);
                if (this.cmbModelsLDP.getModel().getSize() > 0) {
                    this.cmbModelsLDP.setSelectedIndex(0);
                }
            } else if (this.tpane.getSelectedIndex() == 1) {
                this.cmbModelsRSP.addItemListener(this.rsModelsComboListener);
                this.cmbModelsRSP.setSelectedIndex(-1);
                if (this.cmbModelsRSP.getModel().getSize() > 0) {
                    this.cmbModelsRSP.setSelectedIndex(0);
                }
            }
        }
    }

    private void initReportingSchemaPanel() {
        JPanel dirPanel = new JPanel(new SpringLayout());
        dirPanel.setPreferredSize(new Dimension(400, 50));
        dirPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("ReportsGenerationDialog.ServerDir")));
        JLabel lblDir = new JLabel(Messages.getString("ReportsGenerationDialog.DirPath"));
        lblDir.setPreferredSize(new Dimension(130, 20));
        CommonUtil.setLabelConstraints((SpringLayout)dirPanel.getLayout(), lblDir, 5, 3);
        dirPanel.add(lblDir);
        this.txtReportsDir = new JTextField();
        this.txtReportsDir.setToolTipText(Messages.getString("ReportsGenerationDialog.ReportsDirTooltip"));
        this.txtReportsDir.setPreferredSize(new Dimension(280, 20));
        CommonUtil.setObjectConstraints((SpringLayout)dirPanel.getLayout(), this.txtReportsDir, 150, 3);
        dirPanel.add(this.txtReportsDir);
        this.tbConnections.setSelectionMode(0);
        this.tbConnections.setDefaultRenderer(Object.class, new ColorTableCellRenderer());
        this.tbConnections.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ReportsGenerationDialog.this.showConnectionProperties();
                } else {
                    boolean enabled = ReportsGenerationDialog.this.tbConnections.getSelectedRow() > -1;
                    ReportsGenerationDialog.this.btnTest.setEnabled(enabled);
                    ReportsGenerationDialog.this.btnReloadDesignsAndModels.setEnabled(enabled);
                    ReportsGenerationDialog.this.btnProps.setEnabled(enabled);
                    ReportsGenerationDialog.this.btnRemove.setEnabled(enabled);
                }
            }
        });
        this.tbConnections.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int selRow = ReportsGenerationDialog.this.tbConnections.getSelectedRow();
                if (!e.getValueIsAdjusting()) {
                    if (selRow == -1) {
                        ReportsGenerationDialog.this.cmbDesignsRSP.removeAllItems();
                        ReportsGenerationDialog.this.cmbDesignsRSP.setEnabled(false);
                        ReportsGenerationDialog.this.cmbModelsRSP.removeAllItems();
                        ReportsGenerationDialog.this.cmbModelsRSP.setEnabled(false);
                        ReportsGenerationDialog.this.cmbStandardReportConfigurationsRSP.removeAllItems();
                        ReportsGenerationDialog.this.cmbStandardReportConfigurationsRSP.setEnabled(false);
                        ReportsGenerationDialog.this.btnStandardReportConfigurationsRSP.setEnabled(false);
                    } else {
                        ReportsGenerationDialog.this.cmbDesignsRSP.removeAllItems();
                        ReportsGenerationDialog.this.cmbDesignsRSP.setEnabled(false);
                        ReportsGenerationDialog.this.cmbModelsRSP.removeAllItems();
                        ReportsGenerationDialog.this.cmbModelsRSP.setEnabled(false);
                        ReportsGenerationDialog.this.cmbStandardReportConfigurationsRSP.removeAllItems();
                        ReportsGenerationDialog.this.cmbStandardReportConfigurationsRSP.setEnabled(false);
                        ReportsGenerationDialog.this.btnStandardReportConfigurationsRSP.setEnabled(false);
                    }
                }
            }
        });
        JScrollPane sp = new JScrollPane(this.tbConnections);
        sp.setPreferredSize(new Dimension(100, 50));
        GUIConfiguration configuration = GUIConfiguration.getInstance();
        JPanel pnConnections = new JPanel(new BorderLayout());
        pnConnections.setPreferredSize(new Dimension(100, 90));
        pnConnections.add((Component)new JLabel(Messages.getString("ReportsGenerationDialog.Connections")), "North");
        JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
        buttonGeneral.setPreferredSize(new Dimension(200, 23));
        this.btnProps = new JButton(configuration.getIcon("EDIT_ICON", 16));
        this.btnProps.setToolTipText(Messages.getString("ReportsGenerationDialog.ConnectionProperties"));
        this.btnProps.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReportsGenerationDialog.this.showConnectionProperties();
            }
        });
        this.btnProps.setEnabled(false);
        this.btnAdd.setIcon(configuration.getIcon("ADD_ICON", 16));
        this.btnAdd.setToolTipText(Messages.getString("ReportsGenerationDialog.AddConnection"));
        this.btnAdd.addActionListener(new AddAction());
        this.btnRemove = new JButton(configuration.getIcon("REMOVE_ICON", 16));
        this.btnRemove.setToolTipText(Messages.getString("ReportsGenerationDialog.RemoveConnection"));
        this.btnRemove.addActionListener(new RemoveAction());
        this.btnRemove.setEnabled(false);
        this.btnTest = new JButton(configuration.getIcon("DESIGN_RULES_ICON", 16));
        this.btnTest.setToolTipText(Messages.getString("ReportsGenerationDialog.TestConnection"));
        this.btnTest.addActionListener(new TestAction());
        this.btnTest.setEnabled(false);
        this.btnReloadDesignsAndModels = new JButton(configuration.getIcon("REFRESH_ICON", 16));
        this.btnReloadDesignsAndModels.setToolTipText(Messages.getString("ReportsGenerationDialog.ReloadDesignsAndModels"));
        this.btnReloadDesignsAndModels.addActionListener(new ReloadDesignsAndModelsAction());
        this.btnReloadDesignsAndModels.setEnabled(false);
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.add(this.btnProps);
        toolBar.add(this.btnAdd);
        toolBar.add(this.btnRemove);
        toolBar.add(this.btnTest);
        toolBar.add(this.btnReloadDesignsAndModels);
        buttonGeneral.add(toolBar);
        pnConnections.add((Component)buttonGeneral, "North");
        pnConnections.add((Component)sp, "Center");
        this.updateConnections();
        JPanel designModelConfigPanel = new JPanel(new SpringLayout());
        designModelConfigPanel.setPreferredSize(new Dimension(100, 120));
        JLabel lblDesigns = new JLabel(Messages.getString("ReportsGenerationDialog.AvailableDesigns"));
        lblDesigns.setPreferredSize(new Dimension(140, 20));
        CommonUtil.setLabelConstraints((SpringLayout)designModelConfigPanel.getLayout(), lblDesigns, 5, 25);
        designModelConfigPanel.add(lblDesigns);
        this.cmbDesignsRSP.setPreferredSize(new Dimension(265, 20));
        CommonUtil.setObjectConstraints((SpringLayout)designModelConfigPanel.getLayout(), this.cmbDesignsRSP, 160, 25);
        designModelConfigPanel.add(this.cmbDesignsRSP);
        this.cmbDesignsRSP.setRenderer(new CmbDesignsRSPRenderer());
        this.cmbDesignsRSP.setEnabled(false);
        JLabel lblModels = new JLabel(Messages.getString("ReportsGenerationDialog.AvailableModels"));
        lblModels.setPreferredSize(new Dimension(140, 20));
        CommonUtil.setLabelConstraints((SpringLayout)designModelConfigPanel.getLayout(), lblModels, 5, 50);
        designModelConfigPanel.add(lblModels);
        this.cmbModelsRSP.setPreferredSize(new Dimension(265, 20));
        CommonUtil.setObjectConstraints((SpringLayout)designModelConfigPanel.getLayout(), this.cmbModelsRSP, 160, 50);
        designModelConfigPanel.add(this.cmbModelsRSP);
        this.cmbModelsRSP.setRenderer(new CmbModelsRSPRenderer());
        this.cmbModelsRSP.setEnabled(false);
        this.cmbStandardReportConfigurationsRSP.setPreferredSize(new Dimension(155, 20));
        this.cmbStandardReportConfigurationsRSP.setRenderer(new StandardReportRenderer());
        CommonUtil.setObjectConstraints((SpringLayout)designModelConfigPanel.getLayout(), this.cmbStandardReportConfigurationsRSP, 160, 75);
        designModelConfigPanel.add(this.cmbStandardReportConfigurationsRSP);
        this.cmbStandardReportConfigurationsRSP.setEnabled(false);
        JLabel lblStandardReports = new JLabel(Messages.getString("ReportsGenerationDialog.ReportConfiguration"));
        lblStandardReports.setPreferredSize(new Dimension(140, 20));
        CommonUtil.setLabelConstraints((SpringLayout)designModelConfigPanel.getLayout(), lblStandardReports, 5, 75);
        designModelConfigPanel.add(lblStandardReports);
        this.btnStandardReportConfigurationsRSP.setPreferredSize(new Dimension(105, 20));
        this.btnStandardReportConfigurationsRSP.addActionListener(new ShowStandardReportConfigurationsAction());
        CommonUtil.setObjectConstraints((SpringLayout)designModelConfigPanel.getLayout(), this.btnStandardReportConfigurationsRSP, 320, 75);
        designModelConfigPanel.add(this.btnStandardReportConfigurationsRSP);
        this.btnStandardReportConfigurationsRSP.setEnabled(false);
        this.chbClearRSDiagrams.setToolTipText(Messages.getString("ReportsGenerationDialog.ClearDiagramsTooltip"));
        CommonUtil.setObjectConstraints((SpringLayout)designModelConfigPanel.getLayout(), this.chbClearRSDiagrams, 5, 100);
        designModelConfigPanel.add(this.chbClearRSDiagrams);
        this.reportingSchemaPanel = new JPanel(new BorderLayout());
        JPanel southPanel = new JPanel(new BorderLayout());
        southPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("ReportsGenerationDialog.ReportingSchema")));
        southPanel.setPreferredSize(new Dimension(400, 360));
        southPanel.add((Component)pnConnections, "Center");
        southPanel.add((Component)designModelConfigPanel, "South");
        this.reportingSchemaPanel.add((Component)dirPanel, "North");
        this.reportingSchemaPanel.add((Component)southPanel, "Center");
        this.tpane.addTab(Messages.getString("ReportsGenerationDialog.UseReportingSchema"), this.reportingSchemaPanel);
    }

    private Properties getSelectedConnectionProperties() {
        Properties cd = null;
        try {
            cd = ((DMConnectionModel)this.tbConnections.getModel()).getRowData(this.tbConnections.getSelectedRow());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cd;
    }

    private void showConnectionProperties() {
        Properties cd = this.getSelectedConnectionProperties();
        if (cd != null) {
            String connName = ConnectionInfo.getConnectionName(cd);
            FCPConnectionDialog.showConnectionDialog(connName, true);
            this.updateConnections();
        }
    }

    private void closeConnection() {
        if (this.connection != null) {
            try {
                if (!this.connection.isClosed()) {
                    this.connection.close();
                }
                this.connection = null;
            }
            catch (Exception e) {
                LOGGER.error("Unable to close the connection", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initConnection() {
        block5: {
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                this.closeConnection();
                Properties cd = this.getSelectedConnectionProperties();
                if (cd == null) break block5;
                try {
                    this.connection = DatabaseConnections.getInstance().getConnection(cd);
                }
                catch (Exception e) {
                    MessageDialogs.showErrorMessage(e.getLocalizedMessage());
                    boolean bl = false;
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    return bl;
                }
            }
            finally {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
        return this.connection != null;
    }

    private ArrayList<String> getReportsList() {
        ArrayList<String> reports = new ArrayList<String>();
        reports.add("Tables");
        reports.add("Entities");
        reports.add("Domains");
        reports.add("Glossaries");
        reports.add("Structured Types");
        reports.add("Distinct Types");
        reports.add("Collection Types");
        reports.add("Change Requests");
        reports.add("Measurements");
        reports.add("User Defined Properties");
        return reports;
    }

    private ArrayList<String> getOutTypesList() {
        ArrayList<String> types = new ArrayList<String>();
        types.add("RTF");
        types.add("HTML");
        types.add("PDF");
        return types;
    }

    private void updateConnections() {
        ((DMConnectionModel)this.tbConnections.getModel()).reReadConnections();
    }

    public JComboBox getCmbReports() {
        return this.cmbReports;
    }

    @Override
    protected void generateReport() {
        boolean go = true;
        if (this.tpane.getSelectedIndex() == 1) {
            if ((this.clazz == Table.class || this.clazz == Entity.class || this.clazz == Domain.class || this.clazz == StructuredType.class || this.clazz == CollectionType.class || this.clazz == DistinctType.class || this.clazz == ChangeRequest.class || this.clazz == Measurement.class || this.clazz == UserDefinedProperty.class) && this.cmbDesignsRSP.getSelectedItem() == null) {
                JOptionPane.showMessageDialog(this, Messages.getString("ReportsGenerationDialog.ReportCanNotBeGenerated_v1"), Messages.getString("ReportsGenerationDialog.Warning"), 2);
                go = false;
            } else if (this.clazz == Glossary.class && this.tbConnections.getSelectedRow() == -1) {
                JOptionPane.showMessageDialog(this, Messages.getString("ReportsGenerationDialog.ReportCanNotBeGenerated_v2"), Messages.getString("ReportsGenerationDialog.Warning"), 2);
                go = false;
            }
        }
        if (go) {
            this.generate();
        }
    }

    private void generate() {
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block192: {
                    try {
                        StandardReportTemplate reportTemplate = (StandardReportTemplate)ReportsGenerationDialog.this.cmbStandardTemplates.getSelectedItem();
                        if (ReportsGenerationDialog.this.tpane.getSelectedIndex() == 0) {
                            Glossary glossary = null;
                            if (ReportsGenerationDialog.this.clazz == Glossary.class) {
                                glossary = ReportsGenerationDialog.this.getGlossaryFile();
                            }
                            ReportsGenerationDialog.this.extraParams.put("out_format", (String)ReportsGenerationDialog.this.cmbOutFormat.getSelectedItem());
                            ReportsGenerationDialog.this.extraParams.put("vm_options", ReportsGenerationDialog.this.txtVMOptions.getText());
                            ReportsGenerationDialog.this.extraParams.put("reports_path", ReportsGenerationDialog.this.reportsPath);
                            ReportsGenerationDialog.this.extraParams.put("glossary", glossary);
                            ReportsGenerationDialog.this.extraParams.put("report_template", reportTemplate);
                            ReportsGenerationDialog.this.extraParams.put("parent", ReportsGenerationDialog.this);
                            ReportsGenerationDialog.this.extraParams.put("reportCaption", ReportsGenerationDialog.this.txtReportTtitle.getText());
                            ReportsGenerationDialog.this.extraParams.put("clearDiagrams", ReportsGenerationDialog.this.chbClearLMDiagrams.isSelected());
                            ReportsGenerationDialog.this.extraParams.put("reportCustomFilenName", ReportsGenerationDialog.this.txtReportFileName.getText());
                            ReportsGenerationDialog.this.extraParams.put("show", false);
                            ReportsGenerationDialog.this.extraParams.put("filterObject", "");
                            ReportsGenerationDialog.this.extraParams.put("custom_report_template", (CustomReportTemplate)ReportsGenerationDialog.this.cmbCustomTemplates.getSelectedItem());
                            ReportsGenerationDialog.this.extraParams.put("pboolean", ReportsGenerationDialog.this.chbReplaceBooleanValues.isSelected());
                            DesignPart model = (DesignPart)ReportsGenerationDialog.this.cmbModelsLDP.getSelectedItem();
                            if (model == null) {
                                model = ((Design)ReportsGenerationDialog.this.cmbDesignsLDP.getSelectedItem()).getLogicalDesign();
                            }
                            List<SearchResultObject> objects = new ArrayList();
                            ReportsGenerationDialog.this.g = new ReportsGenerator(ReportsGenerationDialog.this.appView);
                            if (ReportsGenerationDialog.this.templatesTabbedPane.getSelectedIndex() == 0) {
                                if (ReportsGenerationDialog.this.cmbStandardReportConfigurationsLDP.getSelectedItem() == blankSR) {
                                    ReportsGenerationDialog.this.extraParams.put("subviews", new HashMap());
                                } else {
                                    StandardReportConfiguration srConfig = (StandardReportConfiguration)ReportsGenerationDialog.this.cmbStandardReportConfigurationsLDP.getSelectedItem();
                                    objects = ReportsGenerationDialog.this.getDesignObjectsForObjectsIDs(model, srConfig.getObjects());
                                    ReportsGenerationDialog.this.extraParams.put("subviews", ReportsGenerationDialog.this.getSubViewsMap(model, srConfig));
                                }
                                ReportsGenerationDialog.this.g.createReport(ReportsGenerationDialog.this.clazz, model, objects, ReportsGenerationDialog.this.extraParams);
                            } else if (ReportsGenerationDialog.this.templatesTabbedPane.getSelectedIndex() == 1) {
                                if (ReportsGenerationDialog.this.cmbStandardReportConfigurationsLDP.getSelectedItem() == blankSR) {
                                    List tempL = ReportsGenerationDialog.this.getLDObjects();
                                    for (ReportObject obj : tempL) {
                                        SearchResultObject sro = new SearchResultObject(obj.getObject(), ReportsGenerationDialog.this.clazz, "", "", "", "");
                                        objects.add(sro);
                                    }
                                    ReportsGenerationDialog.this.extraParams.put("subviews", new HashMap());
                                } else {
                                    StandardReportConfiguration srConfig = (StandardReportConfiguration)ReportsGenerationDialog.this.cmbStandardReportConfigurationsLDP.getSelectedItem();
                                    List tempL = ReportsGenerationDialog.this.getDesignObjectsForObjectsIDs(model, srConfig.getObjects());
                                    for (DesignObject obj : tempL) {
                                        SearchResultObject sro = new SearchResultObject(obj, ReportsGenerationDialog.this.clazz, "", "", "", "");
                                        objects.add(sro);
                                    }
                                    ReportsGenerationDialog.this.extraParams.put("subviews", ReportsGenerationDialog.this.getSubViewsMap(model, srConfig));
                                }
                                ReportsGenerationDialog.this.g.createReport(SearchResultsReportsGenerationDialog.class, model, objects, ReportsGenerationDialog.this.extraParams);
                            }
                            ReportsGenerationDialog.this.adujstSettings(false);
                            break block192;
                        }
                        if (ReportsGenerationDialog.this.tpane.getSelectedIndex() != 1) break block192;
                        BufferedReader xmlISR = null;
                        BufferedReader xsltISR = null;
                        OutputStreamWriter osw = null;
                        DataOutputStream xmlDOS = null;
                        PrintWriter htmlIDXPW = null;
                        PrintWriter htmlTOCPW = null;
                        String objID = "";
                        RSchemaModel model = (RSchemaModel)ReportsGenerationDialog.this.cmbModelsRSP.getSelectedItem();
                        if (!ReportsGenerationDialog.this.initConnection()) break block192;
                        Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(3));
                        OracleCallableStatement stmt = null;
                        try {
                            ReportsGenerationDialog.this.monitor = new ProgressDialog(ReportsGenerationDialog.this.appView, "", 0, 100);
                            ReportsGenerationDialog.this.monitor.setNote(Messages.getString("ReportsGenerationDialog.GatherData"));
                            ReportsGenerationDialog.this.monitor.setProgress(1);
                            ArrayDescriptor descriptor = ArrayDescriptor.createDescriptor((String)"OBJECTS_LIST", (Connection)ReportsGenerationDialog.this.connection);
                            ReportsGenerationDialog.this.objects = new ARRAY(descriptor, ReportsGenerationDialog.this.connection, (Object)Collections.EMPTY_LIST.toArray());
                            if (ReportsGenerationDialog.this.clazz == Glossary.class) {
                                SelectGlossaryDialog sg = new SelectGlossaryDialog(ReportsGenerationDialog.this.appView, ReportsGenerationDialog.this.rgd, ReportsGenerationDialog.this.connection);
                                sg.showDialog();
                                objID = ReportsGenerationDialog.this.getSelectedGlossaryOVID();
                            } else if (ReportsGenerationDialog.this.clazz == Domain.class || ReportsGenerationDialog.this.clazz == ChangeRequest.class || ReportsGenerationDialog.this.clazz == Measurement.class) {
                                objID = ((RSchemaDesign)ReportsGenerationDialog.this.cmbDesignsRSP.getSelectedItem()).getDesignOVID();
                            } else {
                                ArrayList<String> objectsOVIDsList = new ArrayList<String>();
                                if (ReportsGenerationDialog.this.cmbStandardReportConfigurationsRSP.getSelectedItem() == blankSR) {
                                    for (ReportObject ro : ReportsGenerationDialog.this.getRSObjects()) {
                                        objectsOVIDsList.add(ro.getObjectUniqueIdentifier());
                                    }
                                    ReportsGenerationDialog.this.objects = new ARRAY(descriptor, ReportsGenerationDialog.this.connection, (Object)objectsOVIDsList.toArray());
                                    objID = ((RSchemaModel)ReportsGenerationDialog.this.cmbModelsRSP.getSelectedItem()).getObjectOVID();
                                } else {
                                    StandardReportConfiguration srConfig = (StandardReportConfiguration)ReportsGenerationDialog.this.cmbStandardReportConfigurationsRSP.getSelectedItem();
                                    ReportsGenerationDialog.this.objects = new ARRAY(descriptor, ReportsGenerationDialog.this.connection, (Object)srConfig.getObjects().toArray());
                                    if (srConfig.getObjects().size() > 1) {
                                        objID = ((RSchemaModel)ReportsGenerationDialog.this.cmbModelsRSP.getSelectedItem()).getObjectOVID();
                                    } else if (srConfig.getObjects().size() == 1) {
                                        objID = (String)srConfig.getObjects().get(0);
                                    }
                                }
                            }
                            ReportsGenerationDialog.this.initReportParams();
                            String htmlIndexFileName = "";
                            if (((String)ReportsGenerationDialog.this.cmbOutFormat.getSelectedItem()).equals("HTML") && !ReportsGenerationDialog.this.tocTagName.equals("")) {
                                htmlIndexFileName = ReportsGenerationDialog.this.reportFileName.substring(0, ReportsGenerationDialog.this.reportFileName.indexOf(".")) + "_index" + ReportsGenerationDialog.this.reportFileName.substring(ReportsGenerationDialog.this.reportFileName.indexOf("."), ReportsGenerationDialog.this.reportFileName.length());
                            }
                            stmt = (OracleCallableStatement)ReportsGenerationDialog.this.connection.prepareCall("{CALL Pkg_Osdm_Utils.Generate_Report(?,?,?,?,?,?,?,?,?,?,?)}");
                            stmt.setInt(1, ReportsGenerationDialog.this.getStoredPackageReportCode());
                            stmt.setString(2, objID);
                            stmt.setInt(3, 1);
                            stmt.setString(4, ReportsGenerationDialog.this.txtReportsDir.getText().equals("") ? null : ReportsGenerationDialog.this.txtReportsDir.getText().trim());
                            stmt.setString(5, htmlIndexFileName.equals("") ? ReportsGenerationDialog.this.reportFileName : htmlIndexFileName);
                            stmt.setORAData(6, (ORAData)reportTemplate);
                            stmt.setARRAY(7, ReportsGenerationDialog.this.objects);
                            stmt.registerOutParameter(8, -13);
                            stmt.registerOutParameter(9, 2);
                            stmt.registerOutParameter(10, 12);
                            stmt.registerOutParameter(11, -10);
                            ReportsGenerationDialog.this.monitor.setProgress(5);
                            stmt.execute();
                            int generationResult = ((BigDecimal)stmt.getObject(9)).intValue();
                            if (generationResult == 0) {
                                File rp = new File(ReportsGenerationDialog.this.reportsPath);
                                File rp1 = new File((String)stmt.getObject(10));
                                ReportsGenerationDialog.this.rawXMLFile = new File(ReportsGenerationDialog.this.reportsPath + "/report_data_rs.xml");
                                if (!rp.getAbsolutePath().equals(rp1.getAbsolutePath())) {
                                    int len;
                                    ReportsGenerationDialog.this.monitor.setNote(Messages.getString("ReportsGenerationDialog.DownloadReport") + ReportsGenerationDialog.this.reportFileName + " ...");
                                    ReportsGenerationDialog.this.monitor.setProgress(50);
                                    ReportsGenerationDialog.this.bfile = (BFILE)stmt.getObject(8);
                                    ReportsGenerationDialog.this.bfile.openFile();
                                    ReportsGenerationDialog.this.bfileBinaryStream = ReportsGenerationDialog.this.bfile.getBinaryStream();
                                    xmlDOS = new DataOutputStream(new FileOutputStream(ReportsGenerationDialog.this.rawXMLFile));
                                    byte[] buf = new byte[1024];
                                    while ((len = ReportsGenerationDialog.this.bfileBinaryStream.read(buf)) > 0) {
                                        xmlDOS.write(buf, 0, len);
                                    }
                                    xmlDOS.flush();
                                    xmlDOS.close();
                                    ReportsGenerationDialog.this.bfileBinaryStream.close();
                                    ReportsGenerationDialog.this.bfile.closeFile();
                                }
                                xmlISR = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(ReportsGenerationDialog.this.rawXMLFile), "UTF-8"));
                                StreamSource xmlSource = new StreamSource(xmlISR);
                                xsltISR = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(ReportsGenerationDialog.this.xsltFile), "UTF-8"));
                                StreamSource xsltSource = new StreamSource(xsltISR);
                                ReportsGenerationDialog.this.outputFile = new File(ReportsGenerationDialog.this.reportsPath, ReportsGenerationDialog.this.reportFileName);
                                if (((String)ReportsGenerationDialog.this.cmbOutFormat.getSelectedItem()).equals("PDF")) {
                                    new Thread(new RenderPDFReport(ReportsGenerationDialog.this.appView, ReportsGenerationDialog.this.txtVMOptions.getText(), "report_data_rs.xml", ReportsGenerationDialog.this.xsltFile.getAbsolutePath(), ReportsGenerationDialog.this.reportFileName, ReportsGenerationDialog.this.appView.getSettings().getDefaultSaxonPath(), ReportsGenerationDialog.this.reportsPath)).start();
                                    ReportsGenerationDialog.this.monitor.setProgress(100);
                                    ReportsGenerationDialog.this.monitor.close();
                                    ApplicationView.log(Messages.getString("ReportsGenerationDialog.RenderingPDFReport"));
                                    JOptionPane.showMessageDialog(ReportsGenerationDialog.this, Messages.getString("ReportsGenerationDialog.PDFRenderingStarted"), Messages.getString("ReportsGenerationDialog.ReportGenerationRes"), 1);
                                } else {
                                    if (ReportsGenerationDialog.this.saxonPath != null && !ReportsGenerationDialog.this.saxonPath.equals("")) {
                                        SaxonLoader saxonClassLoader = SaxonLoader.getInstance(ReportsGenerationDialog.this.saxonPath);
                                        TransformerFactory transFact = TransformerFactory.newInstance("net.sf.saxon.TransformerFactoryImpl", saxonClassLoader);
                                        Transformer trans = transFact.newTransformer(xsltSource);
                                        trans.setOutputProperty("encoding", "UTF-8");
                                        trans.transform(xmlSource, new StreamResult(ReportsGenerationDialog.this.outputFile));
                                    } else {
                                        TransformerFactory transFact = TransformerFactory.newInstance();
                                        Transformer trans = transFact.newTransformer(xsltSource);
                                        trans.setOutputProperty("encoding", "UTF-8");
                                        FileOutputStream fos = new FileOutputStream(ReportsGenerationDialog.this.outputFile);
                                        osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
                                        trans.transform(xmlSource, new StreamResult(osw));
                                        osw.flush();
                                        fos.close();
                                    }
                                    if (((String)ReportsGenerationDialog.this.cmbOutFormat.getSelectedItem()).equals("HTML") && !ReportsGenerationDialog.this.tocTagName.equals("")) {
                                        String htmlContentsFileName = ReportsGenerationDialog.this.reportFileName.substring(0, ReportsGenerationDialog.this.reportFileName.indexOf(".")) + "_toc" + ReportsGenerationDialog.this.reportFileName.substring(ReportsGenerationDialog.this.reportFileName.indexOf("."), ReportsGenerationDialog.this.reportFileName.length());
                                        htmlIDXPW = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(ReportsGenerationDialog.this.reportsPath, htmlIndexFileName)), "UTF-8"));
                                        htmlIDXPW.print(ReportsHTMLTOC.createHTMLIndexPage(htmlContentsFileName, ReportsGenerationDialog.this.reportFileName));
                                        htmlIDXPW.flush();
                                        htmlIDXPW.close();
                                        htmlTOCPW = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(ReportsGenerationDialog.this.reportsPath, htmlContentsFileName)), "UTF-8"));
                                        htmlTOCPW.print(ReportsHTMLTOC.createHTMLTOCPage(ReportsGenerationDialog.this.reportFileName, ReportsGenerationDialog.this.rawXMLFile, ReportsGenerationDialog.this.tocTagName, new ArrayList()));
                                        htmlTOCPW.flush();
                                        htmlTOCPW.close();
                                        ReportsGenerationDialog.this.reportFileName = htmlIndexFileName;
                                    }
                                    String reportFilesDirName = ReportsGenerationDialog.this.reportFileName + "_files";
                                    new File(ReportsGenerationDialog.this.reportsPath, reportFilesDirName).mkdir();
                                    String modelExtraFilesDirName = model.getName().replaceAll("[^a-zA-Z1-9_]", "_") + "_" + model.getObjectOVID();
                                    File modelExtraFilesDir = new File(ReportsGenerationDialog.this.reportsPath, modelExtraFilesDirName);
                                    if (modelExtraFilesDir.exists()) {
                                        if (ReportsGenerationDialog.this.chbClearRSDiagrams.isSelected()) {
                                            String[] list = modelExtraFilesDir.list();
                                            for (int i = 0; i < list.length; ++i) {
                                                File file = new File(modelExtraFilesDir, list[i]);
                                                file.delete();
                                            }
                                        }
                                    } else {
                                        modelExtraFilesDir.mkdir();
                                    }
                                    ResultSet rsDiagrams = stmt.getCursor(11);
                                    while (rsDiagrams.next()) {
                                        char[] buffer = new char[4096];
                                        StringBuilder s = new StringBuilder();
                                        String str = null;
                                        String pdfName = rsDiagrams.getString("pdf_name");
                                        String diagramName = pdfName.substring(0, pdfName.indexOf(".PDF"));
                                        diagramName = diagramName.replaceAll("[^a-zA-Z1-9_]", "_");
                                        File pdfFile = new File(ReportsGenerationDialog.this.reportsPath + "/" + modelExtraFilesDirName, diagramName + ".pdf");
                                        if (pdfFile.exists()) continue;
                                        Blob pdfBlob = rsDiagrams.getBlob("diagram_pdf");
                                        try (InputStream in = pdfBlob.getBinaryStream();){
                                            int len;
                                            int len1;
                                            InputStreamReader r = new InputStreamReader(in, "UTF-8");
                                            while ((len1 = ((Reader)r).read(buffer, 0, buffer.length)) != -1) {
                                                s.append(buffer, 0, len1);
                                                str = s.toString();
                                            }
                                            InputStream pdfInputStream = pdfBlob.getBinaryStream();
                                            FileOutputStream pdfFOS = new FileOutputStream(pdfFile);
                                            byte[] buf = new byte[1024];
                                            while ((len = pdfInputStream.read(buf)) > 0) {
                                                pdfFOS.write(buf, 0, len);
                                            }
                                            pdfFOS.flush();
                                            pdfFOS.close();
                                            pdfInputStream.close();
                                        }
                                    }
                                    InputStream in = null;
                                    OutputStream out = null;
                                    if (ReportsGenerationDialog.this.cmbStandardReportConfigurationsRSP.getSelectedItem() == blankSR) {
                                        String[] list = modelExtraFilesDir.list();
                                        for (int i = 0; i < list.length; ++i) {
                                            try {
                                                int len1;
                                                in = new FileInputStream(modelExtraFilesDir + "/" + list[i]);
                                                out = new FileOutputStream(ReportsGenerationDialog.this.reportsPath + "/" + reportFilesDirName + "/" + list[i]);
                                                byte[] buf1 = new byte[1024];
                                                while ((len1 = in.read(buf1)) > 0) {
                                                    out.write(buf1, 0, len1);
                                                }
                                                in.close();
                                                out.close();
                                                continue;
                                            }
                                            catch (Exception e1) {
                                                LOGGER.error("Cannot copy diagram file from model directory to report directory " + e1);
                                                continue;
                                            }
                                            finally {
                                                try {
                                                    if (in != null) {
                                                        in.close();
                                                    }
                                                    if (out != null) {
                                                        out.close();
                                                    }
                                                }
                                                catch (IOException e) {
                                                    LOGGER.error("Error when copying files (ReportsGenerator.addDiagramsElement()) " + e);
                                                }
                                            }
                                        }
                                    } else {
                                        for (RSchemaSubView sw : ReportsGenerationDialog.this.getRSSubViews()) {
                                            for (ReportObject ro : ReportsGenerationDialog.this.getRSObjects()) {
                                                if (!ro.getObjectUniqueIdentifier().equals(objID) || !sw.getObjectOVID().equals(ro.getSubviewUniqueIdentifier())) continue;
                                                String pdfFoleName = sw.getName().replaceAll("[^a-zA-Z1-9_]", "_");
                                                try {
                                                    int len1;
                                                    in = new FileInputStream(modelExtraFilesDir + "/" + pdfFoleName + ".pdf");
                                                    out = new FileOutputStream(ReportsGenerationDialog.this.reportsPath + "/" + reportFilesDirName + "/" + pdfFoleName + ".pdf");
                                                    byte[] buf1 = new byte[1024];
                                                    while ((len1 = in.read(buf1)) > 0) {
                                                        out.write(buf1, 0, len1);
                                                    }
                                                    in.close();
                                                    out.close();
                                                }
                                                catch (Exception e1) {
                                                    LOGGER.error("Cannot copy diagram file from model directory to report directory " + e1);
                                                }
                                                finally {
                                                    try {
                                                        if (in != null) {
                                                            in.close();
                                                        }
                                                        if (out == null) continue;
                                                        out.close();
                                                    }
                                                    catch (IOException e) {
                                                        LOGGER.error("Error when copying files (ReportsGenerator.addDiagramsElement()) " + e);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    ReportsGenerationDialog.this.monitor.setNote(Messages.getString("ReportsGenerationDialog.Finished"));
                                    ReportsGenerationDialog.this.monitor.setProgress(100);
                                    ReportsGenerationDialog.this.monitor.close();
                                    boolean openReport = false;
                                    if (Desktop.isDesktopSupported()) {
                                        JOptionPane.showMessageDialog(ReportsGenerationDialog.this, MessageFormat.format(Messages.getString("ReportsGenerationDialog.ReportGenerationOKMsgV1"), ReportsGenerationDialog.this.reportFileName, ReportsGenerationDialog.this.reportsPath), Messages.getString("ReportsGenerationDialog.ReportGenerationRes"), 1);
                                        openReport = true;
                                    } else {
                                        JOptionPane.showMessageDialog(ReportsGenerationDialog.this, MessageFormat.format(Messages.getString("ReportsGenerationDialog.ReportGenerationOKMsgV2"), ReportsGenerationDialog.this.reportFileName, ReportsGenerationDialog.this.reportsPath), Messages.getString("ReportsGenerationDialog.ReportGenerationRes"), 1);
                                    }
                                    if (openReport) {
                                        Desktop.getDesktop().open(new File(ReportsGenerationDialog.this.reportsPath, ReportsGenerationDialog.this.reportFileName));
                                    }
                                }
                                stmt.close();
                                break block192;
                            }
                            if (generationResult == 1) {
                                JOptionPane.showMessageDialog(ReportsGenerationDialog.this, Messages.getString("ReportsGenerationDialog.ReportingDirObjErr"), Messages.getString("ReportsGenerationDialog.ReportGenerationRes"), 0);
                            } else if (generationResult == 2) {
                                JOptionPane.showMessageDialog(ReportsGenerationDialog.this, Messages.getString("ReportsGenerationDialog.ReportingDirPermissionsErr"), Messages.getString("ReportsGenerationDialog.ReportGenerationRes"), 0);
                            } else if (generationResult == 3) {
                                JOptionPane.showMessageDialog(ReportsGenerationDialog.this, Messages.getString("ReportsGenerationDialog.ReportingDirCreateErr"), Messages.getString("ReportsGenerationDialog.ReportGenerationRes"), 0);
                            }
                        }
                        catch (SQLException e) {
                            LOGGER.error("Generating report from Reporting Schema exception - " + e.getMessage());
                            JOptionPane.showMessageDialog(ReportsGenerationDialog.this, Messages.getString("ReportsGenerationDialog.ReportGenerationErrMsg"), Messages.getString("ReportsGenerationDialog.ReportGenerationRes"), 0);
                        }
                        catch (FileNotFoundException e) {
                            if (e.getMessage().contains("Access is denied")) {
                                JOptionPane.showMessageDialog(ReportsGenerationDialog.this, MessageFormat.format(Messages.getString("ReportsGenerationDialog.ReportGenerationAccessErrMsg"), e.getMessage()), Messages.getString("ReportsGenerationDialog.ReportGenerationRes"), 0);
                                LOGGER.error("Exception during report generation " + e);
                            } else {
                                JOptionPane.showMessageDialog(ReportsGenerationDialog.this, Messages.getString("ReportsGenerationDialog.ReportGenerationErrMsg"), Messages.getString("ReportsGenerationDialog.ReportGenerationRes"), 0);
                                LOGGER.error("Exception during report generation " + e);
                            }
                        }
                        catch (IOException e) {
                            LOGGER.error("Generating report from Reporting Schema exception - " + e.getMessage());
                            JOptionPane.showMessageDialog(ReportsGenerationDialog.this, Messages.getString("ReportsGenerationDialog.ReportGenerationErrMsg"), Messages.getString("ReportsGenerationDialog.ReportGenerationRes"), 0);
                        }
                        catch (NullPointerException e) {
                            LOGGER.error("Generating report from Reporting Schema exception. " + e);
                            JOptionPane.showMessageDialog(ReportsGenerationDialog.this, Messages.getString("ReportsGenerationDialog.ReportGenerationErrMsg"), Messages.getString("ReportsGenerationDialog.ReportGenerationRes"), 0);
                        }
                        catch (Exception e) {
                            LOGGER.error("Generating report from Reporting Schema exception. PLSQL package Pkg_Osdm_Utils did not returned report file. See the PLSQL log file for details. " + e.getMessage());
                            JOptionPane.showMessageDialog(ReportsGenerationDialog.this, Messages.getString("ReportsGenerationDialog.ReportGenerationErrMsg"), Messages.getString("ReportsGenerationDialog.ReportGenerationRes"), 0);
                        }
                        finally {
                            Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(0));
                            if (!stmt.isClosed()) {
                                try {
                                    stmt.close();
                                }
                                catch (SQLException e) {
                                    LOGGER.error("SQLException on statement close " + e);
                                }
                            }
                            if (ReportsGenerationDialog.this.bfile != null) {
                                try {
                                    ReportsGenerationDialog.this.bfile.closeFile();
                                }
                                catch (SQLException e) {
                                    LOGGER.error("Could not close report generation BFile " + e);
                                }
                            }
                            if (ReportsGenerationDialog.this.bfileBinaryStream != null) {
                                try {
                                    ReportsGenerationDialog.this.bfileBinaryStream.close();
                                }
                                catch (IOException e) {
                                    LOGGER.error("Could not close report generation BFile input stream " + e);
                                }
                            }
                            if (osw != null) {
                                try {
                                    osw.flush();
                                    osw.close();
                                }
                                catch (IOException e) {
                                    LOGGER.error("ReportsGenerator.createReport() Unable to close XSLT1.0 generated report " + ReportsGenerationDialog.this.reportFileName + ": " + e);
                                }
                            }
                            if (htmlIDXPW != null) {
                                htmlIDXPW.flush();
                                htmlIDXPW.close();
                            }
                            if (htmlTOCPW != null) {
                                htmlTOCPW.flush();
                                htmlTOCPW.close();
                            }
                            if (xmlISR != null) {
                                try {
                                    xmlISR.close();
                                }
                                catch (IOException e) {
                                    LOGGER.error("ReportsGenerator.createReport() Unable to close raw XML file after reading: " + e);
                                }
                            }
                            if (xsltISR != null) {
                                try {
                                    xsltISR.close();
                                }
                                catch (IOException e) {
                                    LOGGER.error("ReportsGenerator.createReport() Unable to close XSLT file : " + e);
                                }
                            }
                            if (xmlDOS != null) {
                                xmlDOS.flush();
                                xmlDOS.close();
                            }
                            ReportsGenerationDialog.this.monitor.close();
                        }
                    }
                    catch (Exception e) {
                        if (ReportsGenerationDialog.this.g != null && ReportsGenerationDialog.this.g.getMonitor() != null) {
                            ReportsGenerationDialog.this.g.getMonitor().close();
                        }
                        JOptionPane.showMessageDialog(ReportsGenerationDialog.this, Messages.getString("ReportsGenerationDialog.ReportGenerationErrMsg"), Messages.getString("ReportsGenerationDialog.ReportGenerationRes"), 0);
                        LOGGER.error("ReportsGenerationDialog.generateReport() - " + e.getMessage());
                    }
                }
            }
        };
        thread.start();
    }

    private Glossary getGlossaryFile() {
        Glossary glossary = null;
        File file = null;
        try {
            ApplicationView.waitLoadFilesThreadToComplete();
            URLFilter ddlFilter = new URLFilter(){

                public boolean accept(URL url) {
                    File file = new File(url.getPath());
                    return file.getName().toLowerCase().endsWith(".glossary") || file.isDirectory();
                }

                public String toString() {
                    return Messages.getString("GlossaryDialog.CWDGlossaryFiles");
                }
            };
            URLFileChooser fileChooser = new URLFileChooser();
            fileChooser.clearChooseableURLFilters();
            fileChooser.setSelectionScope(0);
            fileChooser.setSelectionMode(0);
            fileChooser.setShowJarsAsDirs(false);
            fileChooser.setURLFilter(ddlFilter);
            fileChooser.setPathContext("dataModeler_Glossary");
            if (lastFolder != null) {
                fileChooser.setSelectedURL(URLFactory.newDirURL((File)lastFolder));
            } else {
                String lastDir = this.getApplicationView().getSettings().getDefaultImportPath();
                if (lastDir != null && lastDir.length() > 0) {
                    fileChooser.setSelectedURL(URLFactory.newDirURL((String)lastDir));
                } else {
                    URL url = this.getApplicationView().getUserHomeDirectory();
                    if (url != null) {
                        fileChooser.setSelectedURL(url);
                    }
                }
            }
            int status = fileChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString("ReportsGenerationDialog.OpenGlossary"));
            if (status == 0 && (file = new File(fileChooser.getSelectedURL().getPath())) != null) {
                lastFolder = file.getParentFile();
                glossary = new Glossary(file);
                if (!glossary.isLoaded()) {
                    LOGGER.error("Reports generation : error during glossary file load " + file.toString());
                    JOptionPane.showMessageDialog(this, Messages.getString("ReportsGenerationDialog.ErrGlossaryOpen"), Messages.getString("ReportsGenerationDialog.OpenGlossary"), 0);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Generating report for glossary file : " + file != null ? file.toString() : " " + e.getMessage());
            JOptionPane.showMessageDialog(this, Messages.getString("ReportsGenerationDialog.ErrGlossaryPrint"), Messages.getString("ReportsGenerationDialog.ReportGenerationRes"), 0);
        }
        return glossary;
    }

    public JComboBox getCmbModels() {
        return this.cmbModelsLDP;
    }

    public List getFullModelList() {
        List<DataTypesDesign> fullModelsList = new ArrayList();
        if (this.tpane.getSelectedIndex() == 0) {
            Design d = (Design)this.cmbDesignsLDP.getSelectedItem();
            RelationalDesignSet rds = d.getRelationalDesigns();
            for (RelationalDesign rd : rds) {
                fullModelsList.add((DataTypesDesign)((Object)rd));
            }
            LogicalDesign ld = d.getLogicalDesign();
            fullModelsList.add((DataTypesDesign)((Object)ld));
            DataTypesDesign dtd = d.getDataTypesDesign();
            fullModelsList.add(dtd);
        } else if (this.tpane.getSelectedIndex() == 1) {
            fullModelsList = this.allRSModelsList;
        }
        return fullModelsList;
    }

    public void adujstSettings(boolean reportTypeChanged) {
        try {
            StandardReportConfiguration srConfig = blankSR;
            this.txtReportTtitle.setText("");
            Object selectedReportConfiguration = null;
            if (reportTypeChanged) {
                selectedReportConfiguration = blankSR;
            } else if (this.tpane.getSelectedIndex() == 0) {
                selectedReportConfiguration = this.cmbStandardReportConfigurationsLDP.getSelectedItem();
                if (selectedReportConfiguration != null) {
                    srConfig = (StandardReportConfiguration)selectedReportConfiguration;
                }
            } else if (this.tpane.getSelectedIndex() == 1 && (selectedReportConfiguration = this.cmbStandardReportConfigurationsRSP.getSelectedItem()) != null) {
                srConfig = (StandardReportConfiguration)selectedReportConfiguration;
            }
            if (((String)this.cmbReports.getSelectedItem()).equalsIgnoreCase("Tables")) {
                if (selectedReportConfiguration == blankSR) {
                    this.txtReportTtitle.setText("All Tables Details");
                    this.txtReportFileName.setText(ReportUtils.getReportFileName(ReportUtils.getReportsPath(this.appView), "AllTablesDetails"));
                } else if (srConfig.getObjects().size() > 1) {
                    this.txtReportTtitle.setText("All Tables Details");
                    this.txtReportFileName.setText(ReportUtils.getReportFileName(ReportUtils.getReportsPath(this.appView), "AllTablesDetails"));
                } else if (srConfig.getObjects().size() == 1) {
                    this.txtReportTtitle.setText("Table Details");
                    this.txtReportFileName.setText(ReportUtils.getReportFileName(ReportUtils.getReportsPath(this.appView), "SingleTableDetails"));
                }
                this.clazz = Table.class;
                this.cmbModelsLDP.setEnabled(true);
                this.cmbStandardTemplates.setEnabled(true);
                this.btnManageStandardTemplates.setEnabled(true);
                this.cmbStandardReportConfigurationsLDP.setEnabled(this.cmbModelsLDP.getSelectedIndex() > -1);
                this.btnStandardReportConfigurationsLDP.setEnabled(this.cmbModelsLDP.getSelectedIndex() > -1);
                this.cmbCustomTemplates.setEnabled(true);
                this.btnManageCustomTemplates.setEnabled(true);
                this.chbReplaceBooleanValues.setEnabled(true);
                this.cmbFalse.setEnabled(true);
                this.cmbTrue.setEnabled(true);
                this.cmbModelsRSP.setEnabled(this.cmbDesignsRSP.getSelectedItem() != null);
                this.cmbStandardReportConfigurationsRSP.setEnabled(this.cmbDesignsRSP.getSelectedItem() != null);
                this.btnStandardReportConfigurationsRSP.setEnabled(this.cmbDesignsRSP.getSelectedItem() != null);
                this.chbClearLMDiagrams.setSelected(false);
                this.chbClearLMDiagrams.setEnabled(true);
                this.chbClearRSDiagrams.setSelected(false);
                this.chbClearRSDiagrams.setEnabled(true);
            } else if (((String)this.cmbReports.getSelectedItem()).equalsIgnoreCase("Entities")) {
                if (selectedReportConfiguration == blankSR) {
                    this.txtReportTtitle.setText("All Entities Details");
                    this.txtReportFileName.setText(ReportUtils.getReportFileName(ReportUtils.getReportsPath(this.appView), "AllEntitiesDetails"));
                } else if (srConfig.getObjects().size() > 1) {
                    this.txtReportTtitle.setText("All Entities Details");
                    this.txtReportFileName.setText(ReportUtils.getReportFileName(ReportUtils.getReportsPath(this.appView), "AllEntitiesDetails"));
                } else if (srConfig.getObjects().size() == 1) {
                    this.txtReportTtitle.setText("Entity Details");
                    this.txtReportFileName.setText(ReportUtils.getReportFileName(ReportUtils.getReportsPath(this.appView), "SingleEntityDetails"));
                }
                this.clazz = Entity.class;
                this.cmbModelsLDP.setEnabled(false);
                this.cmbStandardTemplates.setEnabled(true);
                this.btnManageStandardTemplates.setEnabled(true);
                this.cmbStandardReportConfigurationsLDP.setEnabled(this.cmbModelsLDP.getSelectedIndex() > -1);
                this.btnStandardReportConfigurationsLDP.setEnabled(this.cmbModelsLDP.getSelectedIndex() > -1);
                this.cmbCustomTemplates.setEnabled(true);
                this.btnManageCustomTemplates.setEnabled(true);
                this.chbReplaceBooleanValues.setEnabled(true);
                this.cmbFalse.setEnabled(true);
                this.cmbTrue.setEnabled(true);
                this.cmbModelsRSP.setEnabled(false);
                this.cmbStandardReportConfigurationsRSP.setEnabled(this.cmbDesignsRSP.getSelectedItem() != null);
                this.btnStandardReportConfigurationsRSP.setEnabled(this.cmbDesignsRSP.getSelectedItem() != null);
                this.chbClearLMDiagrams.setSelected(false);
                this.chbClearLMDiagrams.setEnabled(true);
                this.chbClearRSDiagrams.setSelected(false);
                this.chbClearRSDiagrams.setEnabled(true);
            } else if (((String)this.cmbReports.getSelectedItem()).equalsIgnoreCase("Domains")) {
                this.clazz = Domain.class;
                this.txtReportTtitle.setText("All Domains Details");
                this.txtReportFileName.setText(ReportUtils.getReportFileName(ReportUtils.getReportsPath(this.appView), "AllDomainsDetails"));
                this.cmbModelsLDP.setEnabled(false);
                this.cmbStandardTemplates.setEnabled(true);
                this.btnManageStandardTemplates.setEnabled(true);
                this.cmbStandardReportConfigurationsLDP.setEnabled(false);
                this.btnStandardReportConfigurationsLDP.setEnabled(false);
                this.cmbCustomTemplates.setEnabled(true);
                this.btnManageCustomTemplates.setEnabled(true);
                this.chbReplaceBooleanValues.setEnabled(true);
                this.cmbFalse.setEnabled(true);
                this.cmbTrue.setEnabled(true);
                this.cmbModelsRSP.removeAllItems();
                this.cmbModelsRSP.setEnabled(false);
                this.cmbStandardReportConfigurationsRSP.setEnabled(false);
                this.btnStandardReportConfigurationsRSP.setEnabled(false);
                this.chbClearLMDiagrams.setSelected(false);
                this.chbClearLMDiagrams.setEnabled(false);
                this.chbClearRSDiagrams.setSelected(false);
                this.chbClearRSDiagrams.setEnabled(false);
            } else if (((String)this.cmbReports.getSelectedItem()).equalsIgnoreCase("Glossaries")) {
                this.clazz = Glossary.class;
                this.txtReportTtitle.setText("Glossary Details");
                this.txtReportFileName.setText(ReportUtils.getReportFileName(ReportUtils.getReportsPath(this.appView), "GlossaryDetails"));
                this.cmbModelsLDP.setEnabled(false);
                this.cmbStandardTemplates.setEnabled(false);
                this.btnManageStandardTemplates.setEnabled(false);
                this.cmbStandardReportConfigurationsLDP.setEnabled(false);
                this.btnStandardReportConfigurationsLDP.setEnabled(false);
                this.cmbCustomTemplates.setEnabled(false);
                this.btnManageCustomTemplates.setEnabled(false);
                this.chbReplaceBooleanValues.setEnabled(false);
                this.cmbFalse.setEnabled(false);
                this.cmbTrue.setEnabled(false);
                this.cmbModelsRSP.removeAllItems();
                this.cmbModelsRSP.setEnabled(false);
                this.cmbStandardReportConfigurationsRSP.setEnabled(false);
                this.btnStandardReportConfigurationsRSP.setEnabled(false);
                this.chbClearLMDiagrams.setSelected(false);
                this.chbClearLMDiagrams.setEnabled(false);
                this.chbClearRSDiagrams.setSelected(false);
                this.chbClearRSDiagrams.setEnabled(false);
            } else if (((String)this.cmbReports.getSelectedItem()).equalsIgnoreCase("Structured Types")) {
                if (selectedReportConfiguration == blankSR) {
                    this.txtReportTtitle.setText("All Structured Types Details");
                    this.txtReportFileName.setText(ReportUtils.getReportFileName(ReportUtils.getReportsPath(this.appView), "AllStructuredTypesDetails"));
                } else if (srConfig.getObjects().size() > 1) {
                    this.txtReportTtitle.setText("All Structured Types Details");
                    this.txtReportFileName.setText(ReportUtils.getReportFileName(ReportUtils.getReportsPath(this.appView), "AllStructuredTypesDetails"));
                } else if (srConfig.getObjects().size() == 1) {
                    this.txtReportTtitle.setText("Structured Type Details");
                    this.txtReportFileName.setText(ReportUtils.getReportFileName(ReportUtils.getReportsPath(this.appView), "SingleStructuredTypeDetails"));
                }
                this.clazz = StructuredType.class;
                this.cmbModelsLDP.setEnabled(false);
                this.cmbStandardTemplates.setEnabled(true);
                this.btnManageStandardTemplates.setEnabled(true);
                this.cmbStandardReportConfigurationsLDP.setEnabled(this.cmbModelsLDP.getSelectedIndex() > -1);
                this.btnStandardReportConfigurationsLDP.setEnabled(this.cmbModelsLDP.getSelectedIndex() > -1);
                this.cmbCustomTemplates.setEnabled(true);
                this.btnManageCustomTemplates.setEnabled(true);
                this.chbReplaceBooleanValues.setEnabled(true);
                this.cmbFalse.setEnabled(true);
                this.cmbTrue.setEnabled(true);
                this.cmbModelsRSP.setEnabled(false);
                this.cmbStandardReportConfigurationsRSP.setEnabled(this.cmbDesignsRSP.getSelectedItem() != null);
                this.btnStandardReportConfigurationsRSP.setEnabled(this.cmbDesignsRSP.getSelectedItem() != null);
                this.chbClearLMDiagrams.setSelected(false);
                this.chbClearLMDiagrams.setEnabled(true);
                this.chbClearRSDiagrams.setSelected(false);
                this.chbClearRSDiagrams.setEnabled(true);
            } else if (((String)this.cmbReports.getSelectedItem()).equalsIgnoreCase("Distinct Types")) {
                if (selectedReportConfiguration == blankSR) {
                    this.txtReportTtitle.setText("All Distinct Types Details");
                    this.txtReportFileName.setText(ReportUtils.getReportFileName(ReportUtils.getReportsPath(this.appView), "AllDistinctTypesDetails"));
                } else if (srConfig.getObjects().size() > 1) {
                    this.txtReportTtitle.setText("All Distinct Types Details");
                    this.txtReportFileName.setText(ReportUtils.getReportFileName(ReportUtils.getReportsPath(this.appView), "AllDistinctTypesDetails"));
                } else if (srConfig.getObjects().size() == 1) {
                    this.txtReportTtitle.setText("Distinct Type Details");
                    this.txtReportFileName.setText(ReportUtils.getReportFileName(ReportUtils.getReportsPath(this.appView), "SingleDistinctTypeDetails"));
                }
                this.clazz = DistinctType.class;
                this.cmbModelsLDP.setEnabled(false);
                this.cmbStandardTemplates.setEnabled(true);
                this.btnManageStandardTemplates.setEnabled(true);
                this.cmbStandardReportConfigurationsLDP.setEnabled(this.cmbModelsLDP.getSelectedIndex() > -1);
                this.btnStandardReportConfigurationsLDP.setEnabled(this.cmbModelsLDP.getSelectedIndex() > -1);
                this.cmbCustomTemplates.setEnabled(true);
                this.btnManageCustomTemplates.setEnabled(true);
                this.chbReplaceBooleanValues.setEnabled(true);
                this.cmbFalse.setEnabled(true);
                this.cmbTrue.setEnabled(true);
                this.cmbModelsRSP.setEnabled(false);
                this.cmbStandardReportConfigurationsRSP.setEnabled(this.cmbDesignsRSP.getSelectedItem() != null);
                this.btnStandardReportConfigurationsRSP.setEnabled(this.cmbDesignsRSP.getSelectedItem() != null);
                this.chbClearLMDiagrams.setSelected(false);
                this.chbClearLMDiagrams.setEnabled(false);
                this.chbClearRSDiagrams.setSelected(false);
                this.chbClearRSDiagrams.setEnabled(false);
            } else if (((String)this.cmbReports.getSelectedItem()).equalsIgnoreCase("Collection Types")) {
                if (selectedReportConfiguration == blankSR) {
                    this.txtReportTtitle.setText("All Collection Type Details");
                    this.txtReportFileName.setText(ReportUtils.getReportFileName(ReportUtils.getReportsPath(this.appView), "AllCollectionTypesDetails"));
                } else if (srConfig.getObjects().size() > 1) {
                    this.txtReportTtitle.setText("All Collection Type Details");
                    this.txtReportFileName.setText(ReportUtils.getReportFileName(ReportUtils.getReportsPath(this.appView), "AllCollectionTypesDetails"));
                } else if (srConfig.getObjects().size() == 1) {
                    this.txtReportTtitle.setText("Collection Type Details");
                    this.txtReportFileName.setText(ReportUtils.getReportFileName(ReportUtils.getReportsPath(this.appView), "SingleCollectionTypeDetails"));
                }
                this.clazz = CollectionType.class;
                this.cmbModelsLDP.setEnabled(false);
                this.cmbStandardTemplates.setEnabled(true);
                this.btnManageStandardTemplates.setEnabled(true);
                this.cmbStandardReportConfigurationsLDP.setEnabled(this.cmbModelsLDP.getSelectedIndex() > -1);
                this.btnStandardReportConfigurationsLDP.setEnabled(this.cmbModelsLDP.getSelectedIndex() > -1);
                this.cmbCustomTemplates.setEnabled(true);
                this.btnManageCustomTemplates.setEnabled(true);
                this.chbReplaceBooleanValues.setEnabled(true);
                this.cmbFalse.setEnabled(true);
                this.cmbTrue.setEnabled(true);
                this.cmbModelsRSP.setEnabled(false);
                this.cmbStandardReportConfigurationsRSP.setEnabled(this.cmbDesignsRSP.getSelectedItem() != null);
                this.btnStandardReportConfigurationsRSP.setEnabled(this.cmbDesignsRSP.getSelectedItem() != null);
                this.chbClearLMDiagrams.setSelected(false);
                this.chbClearLMDiagrams.setEnabled(false);
                this.chbClearRSDiagrams.setSelected(false);
                this.chbClearRSDiagrams.setEnabled(false);
            } else if (((String)this.cmbReports.getSelectedItem()).equalsIgnoreCase("Change Requests")) {
                this.clazz = ChangeRequest.class;
                this.txtReportTtitle.setText("Change Requests Details");
                this.txtReportFileName.setText(ReportUtils.getReportFileName(ReportUtils.getReportsPath(this.appView), "ChangeRequestsDetails"));
                this.cmbModelsLDP.setEnabled(false);
                this.cmbStandardTemplates.setEnabled(true);
                this.btnManageStandardTemplates.setEnabled(true);
                this.cmbStandardReportConfigurationsLDP.setEnabled(false);
                this.btnStandardReportConfigurationsLDP.setEnabled(false);
                this.cmbCustomTemplates.setEnabled(true);
                this.btnManageCustomTemplates.setEnabled(true);
                this.chbReplaceBooleanValues.setEnabled(true);
                this.cmbFalse.setEnabled(true);
                this.cmbTrue.setEnabled(true);
                this.cmbModelsRSP.removeAllItems();
                this.cmbModelsRSP.setEnabled(false);
                this.cmbStandardReportConfigurationsRSP.setEnabled(false);
                this.btnStandardReportConfigurationsRSP.setEnabled(false);
                this.chbClearLMDiagrams.setSelected(false);
                this.chbClearLMDiagrams.setEnabled(false);
                this.chbClearRSDiagrams.setSelected(false);
                this.chbClearRSDiagrams.setEnabled(false);
            } else if (((String)this.cmbReports.getSelectedItem()).equalsIgnoreCase("Measurements")) {
                this.clazz = Measurement.class;
                this.txtReportTtitle.setText("Measurements Details");
                this.txtReportFileName.setText(ReportUtils.getReportFileName(ReportUtils.getReportsPath(this.appView), "MeasurementsDetails"));
                this.cmbModelsLDP.setEnabled(false);
                this.cmbStandardTemplates.setEnabled(true);
                this.btnManageStandardTemplates.setEnabled(true);
                this.cmbStandardReportConfigurationsLDP.setEnabled(false);
                this.btnStandardReportConfigurationsLDP.setEnabled(false);
                this.cmbCustomTemplates.setEnabled(true);
                this.btnManageCustomTemplates.setEnabled(true);
                this.chbReplaceBooleanValues.setEnabled(true);
                this.cmbFalse.setEnabled(true);
                this.cmbTrue.setEnabled(true);
                this.cmbModelsRSP.removeAllItems();
                this.cmbModelsRSP.setEnabled(false);
                this.cmbStandardReportConfigurationsRSP.setEnabled(false);
                this.btnStandardReportConfigurationsRSP.setEnabled(false);
                this.chbClearLMDiagrams.setSelected(false);
                this.chbClearLMDiagrams.setEnabled(false);
                this.chbClearRSDiagrams.setSelected(false);
                this.chbClearRSDiagrams.setEnabled(false);
            } else if (((String)this.cmbReports.getSelectedItem()).equalsIgnoreCase("User Defined Properties")) {
                this.clazz = UserDefinedProperty.class;
                this.txtReportTtitle.setText("User Defined Properties");
                this.txtReportFileName.setText(ReportUtils.getReportFileName(ReportUtils.getReportsPath(this.appView), "UserDefinedProperties"));
                this.cmbModelsLDP.setEnabled(false);
                this.cmbStandardTemplates.setEnabled(true);
                this.btnManageStandardTemplates.setEnabled(true);
                this.cmbStandardReportConfigurationsLDP.setEnabled(false);
                this.btnStandardReportConfigurationsLDP.setEnabled(false);
                this.cmbCustomTemplates.setEnabled(true);
                this.btnManageCustomTemplates.setEnabled(true);
                this.chbReplaceBooleanValues.setEnabled(true);
                this.cmbFalse.setEnabled(true);
                this.cmbTrue.setEnabled(true);
                this.cmbModelsRSP.removeAllItems();
                this.cmbModelsRSP.setEnabled(false);
                this.cmbStandardReportConfigurationsRSP.setEnabled(false);
                this.btnStandardReportConfigurationsRSP.setEnabled(false);
                this.chbClearLMDiagrams.setSelected(false);
                this.chbClearLMDiagrams.setEnabled(false);
                this.chbClearRSDiagrams.setSelected(false);
                this.chbClearRSDiagrams.setEnabled(false);
            }
            this.manageTemplatesAction.setClazz(this.clazz);
            if (!((String)this.cmbReports.getSelectedItem()).equalsIgnoreCase("Glossaries") && !((String)this.cmbReports.getSelectedItem()).equalsIgnoreCase("User Defined Properties")) {
                this.initBlankCRTSearchableProperties();
            }
        }
        catch (Exception e) {
            LOGGER.error("ReportsGenerationDialog.adujstSettings Exception : " + e);
        }
    }

    private void reloadSelectableData() {
        this.cmbStandardTemplates.removeAllItems();
        this.cmbStandardTemplates.addItem(blankRT);
        for (StandardReportTemplate standardReportTemplate : this.appView.getReportTemplates()) {
            if (standardReportTemplate.getClazz() != this.clazz) continue;
            this.cmbStandardTemplates.addItem(standardReportTemplate);
        }
        this.cmbCustomTemplates.removeAllItems();
        this.cmbCustomTemplates.addItem(blankCRT);
        for (CustomReportTemplate customReportTemplate : this.appView.getCustomReportTemplates()) {
            if (customReportTemplate.getClazz() != this.clazz) continue;
            this.cmbCustomTemplates.addItem(customReportTemplate);
        }
        if (this.clazz != Domain.class || this.clazz != ChangeRequest.class || this.clazz != Measurement.class || this.clazz != Glossary.class) {
            this.reloadModels();
            this.reloadReportConfigurations(true);
        } else if (this.tpane.getSelectedIndex() == 0) {
            this.cmbModelsLDP.removeItemListener(this.ldModelsComboListener);
            this.cmbModelsLDP.removeAllItems();
            this.cmbModelsLDP.addItemListener(this.ldModelsComboListener);
        } else if (this.tpane.getSelectedIndex() == 1) {
            this.cmbModelsRSP.removeItemListener(this.rsModelsComboListener);
            this.cmbModelsRSP.removeAllItems();
            this.cmbModelsRSP.addItemListener(this.rsModelsComboListener);
        }
    }

    void reloadReportConfigurations(boolean isLoadedDesignsTab) {
        if (isLoadedDesignsTab) {
            this.cmbStandardReportConfigurationsLDP.removeItemListener(this.ldReportConfigurationsComboListener);
            this.cmbStandardReportConfigurationsLDP.removeAllItems();
            this.cmbStandardReportConfigurationsLDP.addItem(blankSR);
            for (StandardReportConfiguration rt : this.allConfigurationsList) {
                Design currentDesign = (Design)this.cmbDesignsLDP.getSelectedItem();
                DesignPart currentModel = (DesignPart)this.cmbModelsLDP.getSelectedItem();
                if (currentModel == null || !currentDesign.getObjectID().equals(rt.getDesignID()) || !currentModel.getObjectID().equals(rt.getModelID()) || this.clazz != rt.getClazz()) continue;
                this.cmbStandardReportConfigurationsLDP.addItem(rt);
            }
            this.cmbStandardReportConfigurationsLDP.addItemListener(this.ldReportConfigurationsComboListener);
        } else {
            this.cmbStandardReportConfigurationsRSP.removeItemListener(this.rsReportConfigurationsComboListener);
            this.cmbStandardReportConfigurationsRSP.removeAllItems();
            this.cmbStandardReportConfigurationsRSP.addItem(blankSR);
            for (StandardReportConfiguration rt : this.allConfigurationsList) {
                RSchemaDesign currentDesign = (RSchemaDesign)this.cmbDesignsRSP.getSelectedItem();
                RSchemaModel currentModel = (RSchemaModel)this.cmbModelsRSP.getSelectedItem();
                if (currentModel == null || !currentDesign.getDesignOVID().equals(rt.getDesignID()) || !currentModel.getObjectOVID().equals(rt.getModelID()) || this.clazz != rt.getClazz()) continue;
                this.cmbStandardReportConfigurationsRSP.addItem(rt);
            }
            this.cmbStandardReportConfigurationsRSP.addItemListener(this.rsReportConfigurationsComboListener);
        }
    }

    private void initReportParams() {
        try {
            this.tocTagName = "";
            String xsltVersion = "";
            xsltVersion = this.saxonPath != null && !this.saxonPath.equals("") ? "20" : "10";
            String fileFormat = ((String)this.cmbOutFormat.getSelectedItem()).toLowerCase();
            if (this.clazz == Table.class) {
                if (this.objects.length() == 1) {
                    this.xsltFile = new File(ApplicationView.basePath, "reports/xslt/" + xsltVersion + "/SingleTableDetails_" + fileFormat + ".xslt");
                    this.reportFileName = "SingleTableDetails_" + this.getLastUsedFileIdx("SingleTableDetails") + "_rs." + fileFormat;
                } else {
                    this.xsltFile = new File(ApplicationView.basePath, "reports/xslt/" + xsltVersion + "/AllTablesDetails_" + fileFormat + ".xslt");
                    this.reportFileName = "AllTablesDetails_" + this.getLastUsedFileIdx("AllTablesDetails") + "_rs." + fileFormat;
                    this.tocTagName = "TableName";
                }
            } else if (this.clazz == Entity.class) {
                if (this.objects.length() == 1) {
                    this.xsltFile = new File(ApplicationView.basePath, "reports/xslt/" + xsltVersion + "/SingleEntityDetails_" + fileFormat + ".xslt");
                    this.reportFileName = "SingleEntityDetails_" + this.getLastUsedFileIdx("SingleEntityDetails") + "_rs." + fileFormat;
                } else {
                    this.xsltFile = new File(ApplicationView.basePath, "reports/xslt/" + xsltVersion + "/AllEntitiesDetails_" + fileFormat + ".xslt");
                    this.reportFileName = "AllEntitiesDetails_" + this.getLastUsedFileIdx("AllEntitiesDetails") + "_rs." + fileFormat;
                    this.tocTagName = "EntityName";
                }
            } else if (this.clazz == CollectionType.class) {
                if (this.objects.length() == 1) {
                    this.xsltFile = new File(ApplicationView.basePath, "reports/xslt/" + xsltVersion + "/SingleCollectionTypeDetails_" + fileFormat + ".xslt");
                    this.reportFileName = "SingleCollectionTypeDetails_" + this.getLastUsedFileIdx("SingleCollectionTypeDetails") + "_rs." + fileFormat;
                } else {
                    this.xsltFile = new File(ApplicationView.basePath, "reports/xslt/" + xsltVersion + "/AllCollectionTypesDetails_" + fileFormat + ".xslt");
                    this.reportFileName = "AllCollectionTypesDetails_" + this.getLastUsedFileIdx("AllCollectionTypesDetails") + "_rs." + fileFormat;
                    this.tocTagName = "CTName";
                }
            } else if (this.clazz == StructuredType.class) {
                if (this.objects.length() == 1) {
                    this.xsltFile = new File(ApplicationView.basePath, "reports/xslt/" + xsltVersion + "/SingleStructuredTypeDetails_" + fileFormat + ".xslt");
                    this.reportFileName = "SingleStructuredTypeDetails_" + this.getLastUsedFileIdx("SingleStructuredTypeDetails") + "_rs." + fileFormat;
                } else {
                    this.xsltFile = new File(ApplicationView.basePath, "reports/xslt/" + xsltVersion + "/AllStructuredTypesDetails_" + fileFormat + ".xslt");
                    this.reportFileName = "AllStructuredTypesDetails_" + this.getLastUsedFileIdx("AllStructuredTypesDetails") + "_rs." + fileFormat;
                    this.tocTagName = "STName";
                }
            } else if (this.clazz == DistinctType.class) {
                if (this.objects.length() == 1) {
                    this.xsltFile = new File(ApplicationView.basePath, "reports/xslt/" + xsltVersion + "/SingleDistinctTypeDetails_" + fileFormat + ".xslt");
                    this.reportFileName = "SingleDistinctTypeDetails_" + this.getLastUsedFileIdx("SingleDistinctTypeDetails") + "_rs." + fileFormat;
                } else {
                    this.xsltFile = new File(ApplicationView.basePath, "reports/xslt/" + xsltVersion + "/AllDistinctTypesDetails_" + fileFormat + ".xslt");
                    this.reportFileName = "AllDistinctTypesDetails_" + this.getLastUsedFileIdx("AllDistinctTypesDetails") + "_rs." + fileFormat;
                    this.tocTagName = "DTName";
                }
            } else if (this.clazz == Domain.class) {
                this.xsltFile = new File(ApplicationView.basePath, "reports/xslt/" + xsltVersion + "/AllDomainsDetails_" + fileFormat + ".xslt");
                this.reportFileName = "AllDomainsDetails_" + this.getLastUsedFileIdx("AllDomainsDetails") + "_rs." + fileFormat;
                this.tocTagName = "DomainName";
            } else if (this.clazz == Glossary.class) {
                this.xsltFile = new File(ApplicationView.basePath, "reports/xslt/" + xsltVersion + "/GlossaryDetails_" + fileFormat + ".xslt");
                this.reportFileName = "GlossaryDetails_" + this.getLastUsedFileIdx("GlossaryDetails") + "_rs." + fileFormat;
            } else if (this.clazz == ChangeRequest.class) {
                this.xsltFile = new File(ApplicationView.basePath, "reports/xslt/" + xsltVersion + "/ChangeRequestsDetails_" + fileFormat + ".xslt");
                this.reportFileName = "ChangeRequestsDetails_" + this.getLastUsedFileIdx("ChangeRequestsDetails") + "_rs." + fileFormat;
            } else if (this.clazz == Measurement.class) {
                this.xsltFile = new File(ApplicationView.basePath, "reports/xslt/" + xsltVersion + "/MeasurementsDetails_" + fileFormat + ".xslt");
                this.reportFileName = "MeasurementsDetails_" + this.getLastUsedFileIdx("MeasurementsDetails") + "_rs." + fileFormat;
            }
        }
        catch (Exception e) {
            LOGGER.error("ReportsGenerationDialog.initReportParams() Exception : " + e);
        }
    }

    private long getLastUsedFileIdx(String reportName) {
        long lastUsedIdx = 0L;
        long currIdx = 0L;
        try {
            File[] listOfFiles;
            File folder = new File(this.reportsPath);
            if (!folder.exists()) {
                folder.mkdir();
            }
            if ((listOfFiles = folder.listFiles()) == null) {
                listOfFiles = new File(folder.getParent()).listFiles();
            }
            for (int i = 0; i < listOfFiles.length; ++i) {
                File currentFile = listOfFiles[i];
                String reportFileName = currentFile.getName();
                if (!currentFile.isFile() || !reportFileName.startsWith(reportName) || reportFileName.indexOf("_rs") <= 1) continue;
                String currentIndex = reportFileName.substring(reportFileName.indexOf("_") + 1, reportFileName.indexOf("_rs"));
                try {
                    currIdx = new Long(currentIndex);
                    if (currIdx <= lastUsedIdx) continue;
                    lastUsedIdx = currIdx;
                    continue;
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("ReportsGenerationDialog.getLastUsedFileIdx() Exception : " + e);
        }
        return lastUsedIdx + 1L;
    }

    private void loadReportCinfigurations() {
        if (!srLoaded) {
            this.srp.loadStandardReportConfigurations();
            srLoaded = true;
        }
    }

    private List<DesignObject> getDesignObjectsForObjectsIDs(DesignPart model, List<String> objectsIDsList) {
        DesignObject o;
        ArrayList<DesignObject> objects = new ArrayList<DesignObject>();
        ArrayList<DesignObject> tempList = new ArrayList<DesignObject>();
        Iterator it = null;
        Iterator<String> objectsIDsIt = objectsIDsList.iterator();
        if (model instanceof RelationalDesign) {
            it = ((RelationalDesign)model).getTableSet().iterator();
            while (it.hasNext()) {
                o = (DesignObject)it.next();
                tempList.add(o);
            }
        } else if (model instanceof LogicalDesign) {
            it = ((LogicalDesign)model).getEntitySet().iterator();
            while (it.hasNext()) {
                o = (DesignObject)it.next();
                tempList.add(o);
            }
        } else if (model instanceof DataTypesDesign) {
            it = ((DataTypesDesign)model).getStructuredTypeSet().iterator();
            while (it.hasNext()) {
                o = (DesignObject)it.next();
                tempList.add(o);
            }
            it = ((DataTypesDesign)model).getCollectionTypeSet().iterator();
            while (it.hasNext()) {
                o = (DesignObject)it.next();
                tempList.add(o);
            }
            it = ((DataTypesDesign)model).getDistinctTypeSet().iterator();
            while (it.hasNext()) {
                o = (DesignObject)it.next();
                tempList.add(o);
            }
        }
        block5: while (objectsIDsIt.hasNext()) {
            String objId = objectsIDsIt.next();
            for (DesignObject o2 : tempList) {
                if (!o2.getObjectID().equals(objId)) continue;
                objects.add(o2);
                continue block5;
            }
        }
        return objects;
    }

    private HashMap<DesignPartViewPlaceHolder, List<String>> getSubViewsMap(DesignPart model, StandardReportConfiguration src) {
        HashMap<DesignPartViewPlaceHolder, List<String>> subviews = new HashMap<DesignPartViewPlaceHolder, List<String>>();
        List<String> subviewsIDsList = src.getSubviews();
        Iterator allSWIt = model.getDesignSubviews().iterator();
        block0: while (allSWIt.hasNext()) {
            DesignPartViewPlaceHolder ph = (DesignPartViewPlaceHolder)allSWIt.next();
            for (String swId : subviewsIDsList) {
                if (!ph.getObjectID().equals(swId)) continue;
                ArrayList<String> objectsNamesList = new ArrayList<String>();
                for (TopView tv : ph.getDesignPartView().getTopviewsList()) {
                    DesignObject desObj = tv.getModel();
                    for (String objId : src.getObjects()) {
                        if (!desObj.getObjectID().equals(objId)) continue;
                        objectsNamesList.add(desObj.getLongName());
                    }
                }
                Collections.sort(objectsNamesList, this.toStringComparator);
                subviews.put(ph, objectsNamesList);
                continue block0;
            }
        }
        return subviews;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getLDObjects() {
        ArrayList<ReportObject> currentObjectsList = new ArrayList<ReportObject>();
        try {
            block29: {
                block27: {
                    block25: {
                        block23: {
                            block21: {
                                block19: {
                                    block17: {
                                        block26: {
                                            block28: {
                                                block15: {
                                                    block24: {
                                                        DesignPart model;
                                                        block22: {
                                                            block20: {
                                                                block18: {
                                                                    block16: {
                                                                        model = (DesignPart)this.cmbModelsLDP.getSelectedItem();
                                                                        if (model == null) break block15;
                                                                        if (this.clazz != Table.class) break block16;
                                                                        RelationalDesign d = (RelationalDesign)model;
                                                                        Iterator it = d.getTableSet().iterator();
                                                                        while (it.hasNext()) {
                                                                            Table table = (Table)it.next();
                                                                            currentObjectsList.add(new ReportObject(table, table.getName(), table.getObjectID(), "", "", "", true));
                                                                        }
                                                                        break block17;
                                                                    }
                                                                    if (this.clazz != Entity.class) break block18;
                                                                    LogicalDesign d = (LogicalDesign)model;
                                                                    Iterator it = d.getEntitySet().iterator();
                                                                    while (it.hasNext()) {
                                                                        Entity entity = (Entity)it.next();
                                                                        currentObjectsList.add(new ReportObject(entity, entity.getName(), entity.getObjectID(), "", "", "", true));
                                                                    }
                                                                    break block19;
                                                                }
                                                                if (this.clazz != StructuredType.class) break block20;
                                                                DataTypesDesign d = (DataTypesDesign)model;
                                                                Iterator it = d.getStructuredTypeSet().iterator();
                                                                while (it.hasNext()) {
                                                                    StructuredType structuredType = (StructuredType)it.next();
                                                                    currentObjectsList.add(new ReportObject(structuredType, structuredType.getName(), structuredType.getObjectID(), "", "", "", true));
                                                                }
                                                                break block21;
                                                            }
                                                            if (this.clazz != CollectionType.class) break block22;
                                                            DataTypesDesign d = (DataTypesDesign)model;
                                                            Iterator it = d.getCollectionTypeSet().iterator();
                                                            while (it.hasNext()) {
                                                                CollectionType collectionType = (CollectionType)it.next();
                                                                currentObjectsList.add(new ReportObject(collectionType, collectionType.getName(), collectionType.getObjectID(), "", "", "", true));
                                                            }
                                                            break block23;
                                                        }
                                                        if (this.clazz != DistinctType.class) break block24;
                                                        DataTypesDesign d = (DataTypesDesign)model;
                                                        Iterator it = d.getDistinctTypeSet().iterator();
                                                        while (it.hasNext()) {
                                                            DistinctType distinctType = (DistinctType)it.next();
                                                            currentObjectsList.add(new ReportObject(distinctType, distinctType.getName(), distinctType.getObjectID(), "", "", "", true));
                                                        }
                                                        break block25;
                                                    }
                                                    if (this.clazz != Domain.class) break block26;
                                                    Iterator it = ((Design)this.cmbDesignsLDP.getSelectedItem()).getDomainSet().iterator();
                                                    while (it.hasNext()) {
                                                        Domain domain = (Domain)it.next();
                                                        currentObjectsList.add(new ReportObject(domain, domain.getName(), domain.getObjectID(), "", "", "", true));
                                                    }
                                                    break block27;
                                                }
                                                if (this.clazz != ChangeRequest.class) break block28;
                                                Iterator it = ((Design)this.cmbDesignsLDP.getSelectedItem()).getChangeRequestSet().iterator();
                                                while (it.hasNext()) {
                                                    ChangeRequest changeRequest = (ChangeRequest)it.next();
                                                    currentObjectsList.add(new ReportObject(changeRequest, changeRequest.getName(), changeRequest.getObjectID(), "", "", "", true));
                                                }
                                                break block29;
                                            }
                                            if (this.clazz != Measurement.class) break;
                                            for (DesignPart dp : ((Design)this.cmbDesignsLDP.getSelectedItem()).getStorableDesignParts()) {
                                                List owm = dp.getObjectsWithMeasurements();
                                                if (owm.size() <= 0) continue;
                                                for (DesignObject desObject : owm) {
                                                    for (Measurement measurement : desObject.getMeasurements()) {
                                                        currentObjectsList.add(new ReportObject(measurement, measurement.getName(), measurement.getObjectID(), "", "", "", true));
                                                    }
                                                }
                                            }
                                            break;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Reports generation dialog getLDObjects()", e);
        }
        finally {
            return currentObjectsList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getRSObjects() {
        ArrayList<ReportObject> currentObjectsList = new ArrayList<ReportObject>();
        ReportObject ro2 = null;
        try {
            String modelOVID = ((RSchemaModel)this.cmbModelsRSP.getSelectedItem()).getObjectOVID();
            for (ReportObject ro2 : this.allRSObjectsList) {
                String objType = ro2.getObjectType();
                String objModelOVID = ro2.getModelOVID();
                if (this.clazz == Table.class && objModelOVID.equals(modelOVID) && objType.equals("Tables")) {
                    currentObjectsList.add(ro2);
                    continue;
                }
                if (this.clazz == Entity.class && objModelOVID.equals(modelOVID) && objType.equals("Entities")) {
                    currentObjectsList.add(ro2);
                    continue;
                }
                if (this.clazz == StructuredType.class && objModelOVID.equals(modelOVID) && objType.equals("Structured Types")) {
                    currentObjectsList.add(ro2);
                    continue;
                }
                if (this.clazz == CollectionType.class && objModelOVID.equals(modelOVID) && objType.equals("Collection Types")) {
                    currentObjectsList.add(ro2);
                    continue;
                }
                if (this.clazz != DistinctType.class || !objModelOVID.equals(modelOVID) || !objType.equals("Distinct Types")) continue;
                currentObjectsList.add(ro2);
            }
        }
        catch (Exception e) {
            LOGGER.error("Reports generation dialog getRSObjects()", e);
        }
        finally {
            return currentObjectsList;
        }
    }

    private List getRSSubViews() {
        ArrayList<RSchemaSubView> currentSWList = new ArrayList<RSchemaSubView>();
        String designOVID = ((RSchemaDesign)this.cmbDesignsRSP.getSelectedItem()).getDesignOVID();
        String modelOVID = ((RSchemaModel)this.cmbModelsRSP.getSelectedItem()).getObjectOVID();
        for (RSchemaSubView rSchemaSubView : this.allRSSubViewsList) {
            if (!rSchemaSubView.getModelOVID().equals(modelOVID)) continue;
            currentSWList.add(rSchemaSubView);
        }
        return currentSWList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDesigns(Connection connection) {
        block22: {
            this.cmbDesignsRSP.removeItemListener(this.rsDesignsComboListener);
            this.cmbDesignsRSP.removeAllItems();
            this.cmbModelsRSP.removeAllItems();
            this.allRSObjectsList = new ArrayList();
            this.allRSModelsList = new ArrayList();
            this.allRSSubViewsList = new ArrayList();
            Statement stmt = null;
            ArrayList<String> tempDesignsList = new ArrayList<String>();
            ArrayList<String> tempModelsList = new ArrayList<String>();
            ArrayList<String> tempSubviewsList = new ArrayList<String>();
            try {
                if (connection == null) break block22;
                try {
                    float vers = SchemaFactory.schemaVersion(connection);
                    if (vers != 0.0f) {
                        String designsQuery = "SELECT  design_ovid, design_name, version_comments, TO_CHAR(date_published,'dd.mm.yyyy hh24:mi:ss') FROM    dmrs_designs ORDER BY design_name";
                        String modelsQuery = "SELECT model_ovid, model_name, model_type, design_ovid FROM  \tdmrs_models ";
                        String subviewsQuery = "SELECT ovid, diagram_name, model_ovid, diagram_type  FROM  \tdmrs_diagrams";
                        String objectsQuery = "SELECT d.ovid, b.name,  b.ovid,  DECODE(b.type,  'Table','Tables', 'Entity', 'Entities', 'StructuredType', 'Structured Types', 'CollectionType', 'Collection Types', 'DistinctType', 'Distinct Types'),b.model_ovid FROM   dmrs_vdiagrams d , dmrs_diagram_elements b WHERE d.ovid = b.diagram_ovid AND   d.diagram_type IN ('MainView', 'Subview') AND   d.is_display = 'N' AND   b.type IN ('Table', 'Entity', 'StructuredType', 'CollectionType', 'DistinctType')";
                        try {
                            stmt = connection.prepareStatement(designsQuery);
                            ResultSet rset = stmt.executeQuery();
                            while (rset.next()) {
                                String designObjOVID = rset.getString(1);
                                if (tempDesignsList.contains(designObjOVID)) continue;
                                RSchemaDesign rSchemaDesign = new RSchemaDesign(rset.getString(2), designObjOVID, rset.getString(4), rset.getString(3));
                                this.cmbDesignsRSP.addItem(rSchemaDesign);
                                tempDesignsList.add(designObjOVID);
                            }
                            stmt.close();
                            stmt = connection.prepareStatement(modelsQuery);
                            rset = stmt.executeQuery();
                            while (rset.next()) {
                                String modelObjOVID = rset.getString(1);
                                if (tempModelsList.contains(modelObjOVID)) continue;
                                RSchemaModel rSchemaModel = new RSchemaModel(rset.getString(2), rset.getString(3), modelObjOVID, rset.getString(4));
                                this.allRSModelsList.add(rSchemaModel);
                                tempModelsList.add(modelObjOVID);
                            }
                            stmt.close();
                            stmt = connection.prepareStatement(subviewsQuery);
                            rset = stmt.executeQuery();
                            while (rset.next()) {
                                String subviewObjOVID = rset.getString(1);
                                if (tempSubviewsList.contains(subviewObjOVID)) continue;
                                RSchemaSubView rSchemaSubView = new RSchemaSubView(rset.getString(2), rset.getString(3), subviewObjOVID);
                                if (rset.getString(4).equals("MainView")) continue;
                                this.allRSSubViewsList.add(rSchemaSubView);
                                tempSubviewsList.add(subviewObjOVID);
                            }
                            stmt.close();
                            stmt = connection.prepareStatement(objectsQuery);
                            rset = stmt.executeQuery();
                            while (rset.next()) {
                                ReportObject reportObject = new ReportObject("", rset.getString(2), rset.getString(3), rset.getString(4), rset.getString(5), rset.getString(1), true);
                                this.allRSObjectsList.add(reportObject);
                            }
                            stmt.close();
                            this.cmbDesignsRSP.addItemListener(this.rsDesignsComboListener);
                        }
                        catch (SQLException e) {
                            LOGGER.error("Reports generation dialog loadDesigns()", e);
                        }
                        break block22;
                    }
                    MessageDialogs.showMessage("");
                }
                catch (DifferentVersionException dve) {
                    MessageDialogs.showWarningMessage("");
                }
                catch (Exception e) {
                    LOGGER.error("Reports generation dialog loadDesigns()", e);
                    MessageDialogs.showErrorMessage(Messages.getString("SelectDesignsDialog.UnableToLoadDesigns"), true);
                }
            }
            catch (Exception e) {
                LOGGER.error("Reports generation dialog loadDesigns()", e);
                MessageDialogs.showErrorMessage(Messages.getString("SelectDesignsDialog.UnableToLoadDesigns"), true);
            }
            finally {
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException e) {
                        LOGGER.error("Reports generation dialog loadDesigns()", e);
                    }
                }
            }
        }
    }

    public String getSelectedGlossaryOVID() {
        return this.selectedGlossaryOVID;
    }

    public void setSelectedGlossaryOVID(String selectedGlossaryOVID) {
        this.selectedGlossaryOVID = selectedGlossaryOVID;
    }

    private int getStoredPackageReportCode() {
        try {
            String reportType = (String)this.cmbReports.getSelectedItem();
            if (reportType.equalsIgnoreCase("Tables")) {
                if (this.objects.length() == 1) {
                    return 1;
                }
                return 2;
            }
            if (reportType.equalsIgnoreCase("Entities")) {
                if (this.objects.length() == 1) {
                    return 3;
                }
                return 4;
            }
            if (reportType.equalsIgnoreCase("Domains")) {
                return 5;
            }
            if (reportType.equalsIgnoreCase("Glossaries")) {
                return 6;
            }
            if (reportType.equalsIgnoreCase("Structured Types")) {
                if (this.objects.length() == 1) {
                    return 7;
                }
                return 8;
            }
            if (reportType.equalsIgnoreCase("Collection Types")) {
                if (this.objects.length() == 1) {
                    return 9;
                }
                return 10;
            }
            if (reportType.equalsIgnoreCase("Distinct Types")) {
                if (this.objects.length() == 1) {
                    return 11;
                }
                return 12;
            }
            if (reportType.equalsIgnoreCase("Change Requests")) {
                return 13;
            }
            if (reportType.equalsIgnoreCase("Measurements")) {
                return 14;
            }
        }
        catch (Exception e) {
            LOGGER.error("Reports generation dialog getStoredPackageReportCode()", e);
            return 0;
        }
        return 0;
    }

    private void loadCustomReportTemplates() {
        if (!ctrLoaded) {
            this.customReportTemplatesPersistence.loadCustomReportTemplates(this.appView);
            ctrLoaded = true;
        }
    }

    private void initBlankCRTSearchableProperties() {
        List allSearchableProperties = ReportUtils.getSearchablePropertyDescriptions(this.clazz, this.metaDataManager);
        blankCRT.getReportSections().clear();
        ArrayList<ReportColumn> tempList = new ArrayList<ReportColumn>();
        for (ClassDescription.PropertyDescription pd : allSearchableProperties) {
            ReportColumn po = new ReportColumn(pd.name, ReportUtils.getDisplayName(pd.name), 0.0, "", "", ReportConstants.isPropertyMassUpdatable(pd, this.currentModel), false, false);
            tempList.add(po);
        }
        Collections.sort(tempList, new ReportUtils.ColumnsComparator());
        ClassDescription cd = this.metaDataManager.getClassDescription(this.clazz.getName());
        ReportSection rs = new ReportSection(cd, 0, "");
        rs.setCustomName(this.clazz.getName());
        rs.getReportColumns().addAll(tempList);
        blankCRT.getReportSections().add(rs);
    }

    static {
        LOGGER = new Logger(ReportsGenerationDialog.class);
    }

    private class CustomReportsAction
    implements ActionListener {
        private CustomReportsAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List currentObjectsList = new ArrayList();
            DesignPart model = null;
            if (ReportsGenerationDialog.this.tpane.getSelectedIndex() == 0) {
                model = (DesignPart)ReportsGenerationDialog.this.cmbModelsLDP.getSelectedItem();
                currentObjectsList = ReportsGenerationDialog.this.getLDObjects();
            } else if (ReportsGenerationDialog.this.tpane.getSelectedIndex() == 1) {
                currentObjectsList = ReportsGenerationDialog.this.getRSObjects();
            }
            CustomReportsTemplatesDialog dialog = new CustomReportsTemplatesDialog(ReportsGenerationDialog.this.appView, ReportsGenerationDialog.this.clazz, ReportsGenerationDialog.this, ReportsGenerationDialog.this.customReportTemplatesPersistence, null, model, ReportsGenerationDialog.this.clazz, currentObjectsList);
            dialog.showDialog();
        }
    }

    public class ReportObject
    implements Comparable {
        private String objectUniqueIdentifier = "";
        private String objectType = "";
        private String objectName = "";
        private String modelOVID = "";
        private String subviewUniqueIdentifier = "";
        private boolean inReport = true;
        private Object object;

        private ReportObject(Object object, String objectName, String objectUniqueIdentifier, String objectType, String modelOVID, String subviewUniqueIdentifier, boolean inReport) {
            this.object = object;
            this.objectUniqueIdentifier = objectUniqueIdentifier;
            this.objectType = objectType;
            this.objectName = objectName;
            this.modelOVID = modelOVID;
            this.subviewUniqueIdentifier = subviewUniqueIdentifier;
            this.inReport = inReport;
        }

        public String getObjectUniqueIdentifier() {
            return this.objectUniqueIdentifier;
        }

        public boolean isInReport() {
            return this.inReport;
        }

        public void setInReport(boolean inReport) {
            this.inReport = inReport;
        }

        public String getSubviewUniqueIdentifier() {
            return this.subviewUniqueIdentifier;
        }

        public void setSubviewUniqueIdentifier(String subviewUniqueIdentifier) {
            this.subviewUniqueIdentifier = subviewUniqueIdentifier;
        }

        public String getObjectType() {
            return this.objectType;
        }

        public String getObjectName() {
            return this.objectName;
        }

        public String getModelOVID() {
            return this.modelOVID;
        }

        public Object getObject() {
            return this.object;
        }

        public int compareTo(Object o) {
            return this.getObjectName().compareToIgnoreCase(((ReportObject)o).getObjectName());
        }
    }

    class RSchemaSubView
    implements Comparable {
        private String name;
        private String modelOVID;
        private String objectOVID;

        private RSchemaSubView(String name, String modelOVID, String objectOVID) {
            this.name = name;
            this.modelOVID = modelOVID;
            this.objectOVID = objectOVID;
        }

        public String getName() {
            return this.name;
        }

        public String getModelOVID() {
            return this.modelOVID;
        }

        public String getObjectOVID() {
            return this.objectOVID;
        }

        public int compareTo(Object o) {
            return this.getName().compareToIgnoreCase(((RSchemaSubView)o).getName());
        }
    }

    class RSchemaModel
    implements Comparable {
        private String name;
        private String type;
        private String objectOVID;
        private String designOVID;

        private RSchemaModel(String name, String type, String objectOVID, String designOVID) {
            this.name = name;
            this.type = type;
            this.objectOVID = objectOVID;
            this.designOVID = designOVID;
        }

        public String getType() {
            return this.type;
        }

        public String getDesignOVID() {
            return this.designOVID;
        }

        public String getName() {
            return this.name;
        }

        public String getObjectOVID() {
            return this.objectOVID;
        }

        public int compareTo(Object o) {
            return this.getName().compareToIgnoreCase(((RSchemaModel)o).getName());
        }
    }

    class CmbModelsRSPRenderer
    extends JLabel
    implements ListCellRenderer {
        CmbModelsRSPRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String text = "";
            if (value != null) {
                text = ((RSchemaModel)value).getName();
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setText(text);
            this.setOpaque(true);
            return this;
        }
    }

    private class RSchemaDesign {
        private String designName;
        private String designOVID;
        private String designDate;
        private String designComments;

        RSchemaDesign(String name, String designOVID, String designDate, String designComments) {
            this.designName = name;
            this.designOVID = designOVID;
            this.designDate = designDate;
            this.designComments = designComments;
        }

        public String getDesignName() {
            return this.designName;
        }

        public String getDesignOVID() {
            return this.designOVID;
        }

        public String getDesignDate() {
            return this.designDate;
        }

        public String getDesignComments() {
            return this.designComments;
        }
    }

    class CmbDesignsRSPRenderer
    extends JLabel
    implements ListCellRenderer {
        CmbDesignsRSPRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String text = "";
            if (value != null) {
                RSchemaDesign rsd = (RSchemaDesign)value;
                text = rsd.getDesignComments() == null || rsd.getDesignComments().trim().equals("") ? rsd.getDesignName() + " / " + rsd.getDesignDate() : rsd.getDesignName() + " / " + rsd.getDesignDate() + " / " + rsd.getDesignComments();
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setText(text);
            this.setOpaque(true);
            return this;
        }
    }

    private class RSDesignsComboListener
    implements ItemListener {
        private RSDesignsComboListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                ReportsGenerationDialog.this.reloadModels();
            }
        }
    }

    private class RSReportConfigurationsComboListener
    implements ItemListener {
        private RSReportConfigurationsComboListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                ReportsGenerationDialog.this.adujstSettings(false);
            }
        }
    }

    private class LDReportConfigurationsComboListener
    implements ItemListener {
        private LDReportConfigurationsComboListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                ReportsGenerationDialog.this.adujstSettings(false);
            }
        }
    }

    private class ReportsComboListener
    implements ItemListener {
        private ReportsComboListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                ReportsGenerationDialog.this.adujstSettings(true);
                ReportsGenerationDialog.this.reloadSelectableData();
                if (((String)ReportsGenerationDialog.this.cmbReports.getSelectedItem()).equalsIgnoreCase("Glossaries")) {
                    if (ReportsGenerationDialog.this.templatesTabbedPane.getSelectedComponent() == ReportsGenerationDialog.this.customReportsTemplatesPanel) {
                        ReportsGenerationDialog.this.btnGenerate.setEnabled(false);
                    } else {
                        ReportsGenerationDialog.this.btnGenerate.setEnabled(true);
                    }
                } else {
                    ReportsGenerationDialog.this.btnGenerate.setEnabled(true);
                }
            }
        }
    }

    private class RSModelsComboListener
    implements ItemListener {
        private RSModelsComboListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                ReportsGenerationDialog.this.reloadReportConfigurations(false);
            }
        }
    }

    private class LDModelsComboListener
    implements ItemListener {
        private LDModelsComboListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                ReportsGenerationDialog.this.reloadReportConfigurations(true);
            }
        }
    }

    private class LDDesignsComboListener
    implements ItemListener {
        private LDDesignsComboListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                ReportsGenerationDialog.this.reloadModels();
            }
        }
    }

    class StandardReportRenderer
    extends JLabel
    implements ListCellRenderer {
        StandardReportRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            StandardReportConfiguration r = (StandardReportConfiguration)value;
            if (r != null) {
                this.setText(r.getName());
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            return this;
        }
    }

    private class ShowStandardReportConfigurationsAction
    implements ActionListener {
        private ShowStandardReportConfigurationsAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List currentObjectsList = new ArrayList();
            if (ReportsGenerationDialog.this.tpane.getSelectedIndex() == 0) {
                currentObjectsList = ReportsGenerationDialog.this.getLDObjects();
                ReportsGenerationDialog.this.extraParams.put("design_id", ((Design)ReportsGenerationDialog.this.cmbDesignsLDP.getSelectedItem()).getObjectID());
                ReportsGenerationDialog.this.extraParams.put("model_id", ((DesignPart)ReportsGenerationDialog.this.cmbModelsLDP.getSelectedItem()).getObjectID());
                ReportsGenerationDialog.this.extraParams.put("subviews", ((DesignPart)ReportsGenerationDialog.this.cmbModelsLDP.getSelectedItem()).getDesignSubviews());
            } else if (ReportsGenerationDialog.this.tpane.getSelectedIndex() == 1) {
                currentObjectsList = ReportsGenerationDialog.this.getRSObjects();
                ReportsGenerationDialog.this.extraParams.put("design_id", ((RSchemaDesign)ReportsGenerationDialog.this.cmbDesignsRSP.getSelectedItem()).getDesignOVID());
                ReportsGenerationDialog.this.extraParams.put("model_id", ((RSchemaModel)ReportsGenerationDialog.this.cmbModelsRSP.getSelectedItem()).getObjectOVID());
                ReportsGenerationDialog.this.extraParams.put("subviews", ReportsGenerationDialog.this.getRSSubViews());
            }
            ReportsGenerationDialog.this.extraParams.put("srp_persistence", ReportsGenerationDialog.this.srp);
            ReportsGenerationDialog.this.extraParams.put("parent", ReportsGenerationDialog.this);
            ReportsGenerationDialog.this.extraParams.put("objects_list", currentObjectsList);
            ReportsGenerationDialog.this.extraParams.put("loaded_designs", ReportsGenerationDialog.this.tpane.getSelectedIndex() == 0);
            StandardReportsConfigurationDialog moDialog = new StandardReportsConfigurationDialog(ReportsGenerationDialog.this.appView, ReportsGenerationDialog.this.clazz, ReportsGenerationDialog.this.extraParams);
            moDialog.showDialog();
        }
    }

    private class ReloadDesignsAndModelsAction
    implements ActionListener {
        private ReloadDesignsAndModelsAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                ReportsGenerationDialog.this.loadDesigns(DatabaseConnections.getInstance().getConnection(ReportsGenerationDialog.this.getSelectedConnectionProperties()));
                ReportsGenerationDialog.this.reloadModels();
                ReportsGenerationDialog.this.reloadReportConfigurations(false);
                if (((String)ReportsGenerationDialog.this.cmbReports.getSelectedItem()).equalsIgnoreCase("Tables")) {
                    ReportsGenerationDialog.this.cmbDesignsRSP.setEnabled(true);
                    ReportsGenerationDialog.this.cmbModelsRSP.setEnabled(true);
                    ReportsGenerationDialog.this.cmbStandardReportConfigurationsRSP.setEnabled(true);
                    ReportsGenerationDialog.this.btnStandardReportConfigurationsRSP.setEnabled(true);
                } else if (((String)ReportsGenerationDialog.this.cmbReports.getSelectedItem()).equalsIgnoreCase("Entities")) {
                    ReportsGenerationDialog.this.cmbDesignsRSP.setEnabled(true);
                    ReportsGenerationDialog.this.cmbModelsRSP.setEnabled(true);
                    ReportsGenerationDialog.this.cmbStandardReportConfigurationsRSP.setEnabled(true);
                    ReportsGenerationDialog.this.btnStandardReportConfigurationsRSP.setEnabled(true);
                } else if (((String)ReportsGenerationDialog.this.cmbReports.getSelectedItem()).equalsIgnoreCase("Domains")) {
                    ReportsGenerationDialog.this.cmbDesignsRSP.setEnabled(true);
                    ReportsGenerationDialog.this.cmbModelsRSP.setEnabled(false);
                    ReportsGenerationDialog.this.cmbStandardReportConfigurationsRSP.setEnabled(false);
                    ReportsGenerationDialog.this.btnStandardReportConfigurationsRSP.setEnabled(false);
                } else if (((String)ReportsGenerationDialog.this.cmbReports.getSelectedItem()).equalsIgnoreCase("Glossaries")) {
                    ReportsGenerationDialog.this.cmbDesignsRSP.setEnabled(true);
                    ReportsGenerationDialog.this.cmbModelsRSP.setEnabled(false);
                    ReportsGenerationDialog.this.cmbStandardReportConfigurationsRSP.setEnabled(false);
                    ReportsGenerationDialog.this.btnStandardReportConfigurationsRSP.setEnabled(false);
                } else if (((String)ReportsGenerationDialog.this.cmbReports.getSelectedItem()).equalsIgnoreCase("Structured Types")) {
                    ReportsGenerationDialog.this.cmbDesignsRSP.setEnabled(true);
                    ReportsGenerationDialog.this.cmbModelsRSP.setEnabled(false);
                    ReportsGenerationDialog.this.cmbStandardReportConfigurationsRSP.setEnabled(false);
                    ReportsGenerationDialog.this.btnStandardReportConfigurationsRSP.setEnabled(false);
                } else if (((String)ReportsGenerationDialog.this.cmbReports.getSelectedItem()).equalsIgnoreCase("Distinct Types")) {
                    ReportsGenerationDialog.this.cmbDesignsRSP.setEnabled(true);
                    ReportsGenerationDialog.this.cmbModelsRSP.setEnabled(false);
                    ReportsGenerationDialog.this.cmbStandardReportConfigurationsRSP.setEnabled(false);
                    ReportsGenerationDialog.this.btnStandardReportConfigurationsRSP.setEnabled(false);
                } else if (((String)ReportsGenerationDialog.this.cmbReports.getSelectedItem()).equalsIgnoreCase("Collection Types")) {
                    ReportsGenerationDialog.this.cmbDesignsRSP.setEnabled(true);
                    ReportsGenerationDialog.this.cmbModelsRSP.setEnabled(false);
                    ReportsGenerationDialog.this.cmbStandardReportConfigurationsRSP.setEnabled(false);
                    ReportsGenerationDialog.this.btnStandardReportConfigurationsRSP.setEnabled(false);
                } else if (((String)ReportsGenerationDialog.this.cmbReports.getSelectedItem()).equalsIgnoreCase("Change Requests")) {
                    ReportsGenerationDialog.this.cmbDesignsRSP.setEnabled(true);
                    ReportsGenerationDialog.this.cmbModelsRSP.setEnabled(false);
                    ReportsGenerationDialog.this.cmbStandardReportConfigurationsRSP.setEnabled(false);
                    ReportsGenerationDialog.this.btnStandardReportConfigurationsRSP.setEnabled(false);
                } else if (((String)ReportsGenerationDialog.this.cmbReports.getSelectedItem()).equalsIgnoreCase("Measurements")) {
                    ReportsGenerationDialog.this.cmbDesignsRSP.setEnabled(true);
                    ReportsGenerationDialog.this.cmbModelsRSP.setEnabled(false);
                    ReportsGenerationDialog.this.cmbStandardReportConfigurationsRSP.setEnabled(false);
                    ReportsGenerationDialog.this.btnStandardReportConfigurationsRSP.setEnabled(false);
                }
            }
            catch (ConnectionException e1) {
                LOGGER.error("Exception ReportsGenerationDialog.ReloadDesignsAndModelsAction ", e1);
            }
        }
    }

    private class TestAction
    implements ActionListener {
        private TestAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FCPConnectionDialog.testConnection(ReportsGenerationDialog.this.getSelectedConnectionProperties());
        }
    }

    private class RemoveAction
    implements ActionListener {
        private RemoveAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Properties cd = ReportsGenerationDialog.this.getSelectedConnectionProperties();
            if (cd != null) {
                try {
                    String connName = ConnectionInfo.getConnectionName(cd);
                    int result = JOptionPane.showConfirmDialog(ReportsGenerationDialog.this, MessageFormat.format(Messages.getString("ReportsGenerationDialog.SureToDelete"), connName), Messages.getString("ReportsGenerationDialog.SelectOption"), 0);
                    if (result == 0) {
                        DatabaseConnections.getInstance().removeConnection(connName);
                        ReportsGenerationDialog.this.updateConnections();
                        ReportsGenerationDialog.this.tbConnections.clearSelection();
                        ReportsGenerationDialog.this.btnTest.setEnabled(false);
                        ReportsGenerationDialog.this.btnProps.setEnabled(false);
                        ReportsGenerationDialog.this.btnRemove.setEnabled(false);
                    }
                }
                catch (ConnectionException e1) {
                    LOGGER.error("Unable to delete connection", e1);
                    MessageDialogs.showMessage(ApplicationView.frame, "Unable to delete connection");
                }
            }
        }
    }

    private class AddAction
    implements ActionListener {
        private AddAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                FCPConnectionDialog.showConnectionDialog(true);
                ReportsGenerationDialog.this.updateConnections();
            }
            catch (Exception e1) {
                LOGGER.error(e1);
            }
        }
    }
}

