/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.wizards.metadata.oracle;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.wizards.Messages;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class ImportDBOptionsOracle
extends CustomDialog {
    protected JDialog dialog;
    protected JButton bnCancel;
    protected JButton bnOK;
    boolean partitions;
    boolean triggers;
    boolean structTypes;
    boolean spatial;
    boolean secondaryTables;
    public JCheckBox chSecondaryTables;
    public JCheckBox chPartitions;
    public JCheckBox chTriggers;
    public JCheckBox chSTructuredTypesScan;
    public JCheckBox chSpatial;
    protected JPanel generalPanelContents;
    private boolean okPressed = false;

    public ImportDBOptionsOracle(ApplicationView appView, boolean partitions, boolean triggers, boolean structTypes, boolean spatial, boolean secondaryTables) {
        super(appView);
        this.partitions = partitions;
        this.triggers = triggers;
        this.structTypes = structTypes;
        this.spatial = spatial;
        this.secondaryTables = secondaryTables;
        this.add((Component)this.initGeneralPanel(), "Center");
        this.add((Component)this.initButtonsPanel(), "South");
    }

    protected JPanel initGeneralPanel() {
        JPanel jpanel = new JPanel(new BorderLayout());
        jpanel.setPreferredSize(this.getDialogPreferredSize());
        this.generalPanelContents = new JPanel(new GridLayout(0, 1));
        this.chPartitions = new JCheckBox(Messages.getString("ImportDBOptionsOracle.Partitions"));
        this.chTriggers = new JCheckBox(Messages.getString("ImportDBOptionsOracle.Triggers"));
        this.chSTructuredTypesScan = new JCheckBox(Messages.getString("ImportDBOptionsOracle.StucturedTypesScan"));
        this.chSecondaryTables = new JCheckBox(Messages.getString("AbstractDBMExtractionWizardImpl.SecondaryTables"));
        this.chSpatial = new JCheckBox(Messages.getString("AbstractDBMExtractionWizardImpl.SpatialProperties"));
        this.chPartitions.setSelected(this.partitions);
        this.chTriggers.setSelected(this.triggers);
        this.chSTructuredTypesScan.setSelected(this.structTypes);
        this.chSpatial.setSelected(this.spatial);
        this.chSecondaryTables.setSelected(this.secondaryTables);
        this.generalPanelContents.add(this.chPartitions);
        this.generalPanelContents.add(this.chTriggers);
        this.generalPanelContents.add(this.chSTructuredTypesScan);
        this.generalPanelContents.add(this.chSecondaryTables);
        this.generalPanelContents.add(this.chSpatial);
        jpanel.add((Component)new JPanel(), "West");
        jpanel.add((Component)this.generalPanelContents, "Center");
        return jpanel;
    }

    protected JPanel initButtonsPanel() {
        JPanel pnButtons = new JPanel(new FlowLayout(2));
        this.bnOK = new JButton(this.createOKButton());
        this.bnOK.setMnemonic(79);
        this.bnCancel = new JButton(this.createCancelButton());
        this.bnCancel.setMnemonic(67);
        pnButtons.add(this.bnOK);
        pnButtons.add(this.bnCancel);
        this.bnOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        return pnButtons;
    }

    protected Action createOKButton() {
        AbstractAction action = new AbstractAction(Messages.getString("CommonPropertiesDialog.OK")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportDBOptionsOracle.this.apply();
                ImportDBOptionsOracle.this.close();
            }
        };
        return action;
    }

    protected Action createCancelButton() {
        AbstractAction action = new AbstractAction(Messages.getString("CommonPropertiesDialog.Cancel")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportDBOptionsOracle.this.okPressed = false;
                ImportDBOptionsOracle.this.close();
            }
        };
        return action;
    }

    public void showDialog() {
        this.getDialog().setVisible(true);
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    public Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), this.getDialogTitle());
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.setContentPane(this);
            this.dialog.getRootPane().setDefaultButton(this.bnOK);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setResizable(false);
            this.dialog.setModal(true);
            CommonUtil.centerOnScreen(this.dialog);
        }
        return this.dialog;
    }

    @Override
    protected String getHelpIndex() {
        return "IMPORT_DB_OPTIONS_ORACLE";
    }

    public void apply() {
        this.okPressed = true;
    }

    protected String getDialogTitle() {
        return "Optional Import and Processing";
    }

    protected Dimension getDialogPreferredSize() {
        return new Dimension(300, 200);
    }

    public boolean isOKPressed() {
        return this.okPressed;
    }

    public boolean isProcessPartitions() {
        return this.chPartitions.isSelected();
    }

    public boolean isProcessTriggers() {
        return this.chTriggers.isSelected();
    }

    public boolean isProcessUsedStructuredTypes() {
        return this.chSTructuredTypesScan.isSelected();
    }

    public boolean isProcessSpatial() {
        return this.chSpatial.isSelected();
    }

    public boolean isProcessSecondaryTables() {
        return this.chSecondaryTables.isSelected();
    }
}

