/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.wizards;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.relational.ApplyNamingStandards;
import oracle.dbtools.crest.model.design.relational.ColumnView;
import oracle.dbtools.crest.model.design.relational.FKContainer;
import oracle.dbtools.crest.model.design.relational.FKElement;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableSet;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.relational.ViewIndex;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableViewProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.model.design.undo.CreateDO_Edit;
import oracle.dbtools.crest.model.design.undo.GroupCreateEdit;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.relational.DPVRelational;
import oracle.dbtools.crest.swingui.relational.DPVRelationalSubView;
import oracle.dbtools.crest.swingui.relational.TVView;
import oracle.dbtools.crest.swingui.wizards.Messages;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.logging.Logger;

public class Table2ViewDialog
extends CustomDialog {
    private JButton btnGenerate;
    private JButton btnClose;
    private JComboBox cmbRelationals;
    private JButton bnSelectAll;
    private JButton bnDeselectAll;
    private JScrollPane spnTables;
    private JTable tblTables;
    private String title;
    private JDialog dialog;
    private JCheckBox cbEditioning;
    private JCheckBox cbViewConstraints;
    private JCheckBox cbCreateSubView;
    private JTextField tfNamingRule;
    private JButton btnAddVariable;
    private static final Logger LOGGER = new Logger(Table2ViewDialog.class);

    public Table2ViewDialog(ApplicationView applView, String title) {
        super(applView);
        this.title = title;
        this.setLayout(new BorderLayout());
        this.cmbRelationals = new JComboBox();
        this.bnSelectAll = new JButton(Messages.getString("Table2ViewDialog.SelectAll"));
        this.bnSelectAll.setMnemonic(65);
        this.bnSelectAll.setPreferredSize(MessageDialogs.BUTTON_SIZE_160);
        this.bnSelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Table2ViewDialog.this.selectAllRows(true);
            }
        });
        this.bnDeselectAll = new JButton(Messages.getString("Table2ViewDialog.DeselectAll"));
        this.bnDeselectAll.setMnemonic(68);
        this.bnDeselectAll.setPreferredSize(MessageDialogs.BUTTON_SIZE_180);
        this.bnDeselectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Table2ViewDialog.this.selectAllRows(false);
            }
        });
        this.spnTables = new JScrollPane();
        this.tblTables = new JTable();
        this.add((Component)this.makeTopPanel(), "North");
        this.add(this.makeCenterPanel(), "Center");
        this.add(this.makeDialogButtonsPanel(), "South");
    }

    @Override
    protected String getHelpIndex() {
        return "TABLE_TO_VIEW_WIZARD";
    }

    @Override
    protected void close() {
        if (this.dialog != null) {
            this.dialog.dispose();
        }
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog(this.getApplicationView().getFrame(), this.title, true);
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.addListeners();
            this.dialog.setResizable(true);
            this.dialog.setMinimumSize(new Dimension(630, 250));
            this.dialog.pack();
        }
        return this.dialog;
    }

    public void showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.refreshComponents();
        this.getDialog().setVisible(true);
    }

    private void refreshComponents() {
        DefaultComboBoxModel mdlCombo = (DefaultComboBoxModel)this.cmbRelationals.getModel();
        ActionListener[] actList = this.cmbRelationals.getActionListeners();
        for (int i = 0; i < actList.length; ++i) {
            this.cmbRelationals.removeActionListener(actList[i]);
        }
        mdlCombo.removeAllElements();
        Object[] relDesigns = this.getApplicationView().getCurrentDesign().getRelationalDesigns().toArray();
        for (int i = 0; i < relDesigns.length; ++i) {
            mdlCombo.addElement(relDesigns[i]);
        }
        this.cmbRelationals.setEditable(false);
        RelationalDesign phyDesign = (RelationalDesign)this.cmbRelationals.getSelectedItem();
        this.tblTables.setModel(new CustomTBModel(phyDesign.getTableSet()));
        this.setTableWidths();
        for (int i = 0; i < actList.length; ++i) {
            this.cmbRelationals.addActionListener(actList[i]);
        }
        this.handleGenerateButton();
    }

    private void addListeners() {
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Table2ViewDialog.this.close();
            }
        });
        this.btnGenerate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Table2ViewDialog.this.generateViews();
            }
        });
        this.cmbRelationals.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Table2ViewDialog.this.loadNewTableSet();
            }
        });
    }

    protected void loadNewTableSet() {
        try {
            RelationalDesign phyDesign = (RelationalDesign)this.cmbRelationals.getSelectedItem();
            CustomTBModel mdlTable = new CustomTBModel(phyDesign.getTableSet());
            this.tblTables.setModel(mdlTable);
            this.setTableWidths();
            this.handleGenerateButton();
        }
        catch (ClassCastException e) {
            LOGGER.error("ERROR::Table2ViewDialog::loadNewTableSet() -> ClassCastException", e);
        }
    }

    protected void selectAllRows(boolean selected) {
        CustomTBModel mdlTable = (CustomTBModel)this.tblTables.getModel();
        int rowsCount = mdlTable != null ? mdlTable.getRowCount() : 0;
        for (int i = 0; i < rowsCount; ++i) {
            mdlTable.setValueAt(selected, i, 0);
        }
        this.tblTables.invalidate();
        this.tblTables.repaint();
        this.handleGenerateButton();
    }

    private void handleGenerateButton() {
        CustomTBModel mdlTable = (CustomTBModel)this.tblTables.getModel();
        int rowsCount = mdlTable != null ? mdlTable.getRowCount() : 0;
        for (int i = 0; i < rowsCount; ++i) {
            Boolean isSelected = (Boolean)mdlTable.getValueAt(i, 0);
            if (!isSelected.booleanValue()) continue;
            this.btnGenerate.setEnabled(true);
            return;
        }
        this.btnGenerate.setEnabled(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateViews() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        ApplicationView.canLogging = false;
        DesignPart phDesign = null;
        GroupCreateEdit groupEdit = null;
        try {
            CustomTBModel mdlTable = (CustomTBModel)this.tblTables.getModel();
            int rowsCount = mdlTable != null ? mdlTable.getRowCount() : 0;
            Boolean isSelected = null;
            ArrayList<Object> arrSelTables = new ArrayList<Object>();
            HashMap<TableView, Table> map = new HashMap<TableView, Table>();
            try {
                DesignPartView subView;
                for (int i = 0; i < rowsCount; ++i) {
                    isSelected = (Boolean)mdlTable.getValueAt(i, 0);
                    if (!isSelected.booleanValue()) continue;
                    arrSelTables.add(mdlTable.getElementAt(i, 1));
                }
                phDesign = (RelationalDesign)this.cmbRelationals.getSelectedItem();
                phDesign.getUndoManager().setLocked(true);
                ArrayList<TableView> arrViews = new ArrayList<TableView>();
                for (Table table : arrSelTables) {
                    TableView view = this.addView(table, (RelationalDesign)phDesign, new Rectangle(0, 0), map);
                    view.addSQLNameHelpersForTable(table);
                    view.setParsed(true);
                    arrViews.add(view);
                }
                ArrayList arrayList = new ArrayList();
                if (this.cbViewConstraints.isSelected()) {
                    boolean oldValue = phDesign.getDesign().isPropagatePKChahges();
                    phDesign.getDesign().setPropagatePKChahges(false);
                    try {
                        this.createForeignKeys(map, arrayList);
                    }
                    finally {
                        phDesign.getDesign().setPropagatePKChahges(oldValue);
                    }
                }
                DPVRelational dpv = (DPVRelational)((RelationalDesign)phDesign).getMainView();
                for (TableView view : arrViews) {
                    TopView tv = view.getFirstViewForDPV(dpv);
                    if (tv == null) continue;
                    dpv.resizeView(tv);
                }
                Rectangle2D r2d = ((RelationalDesign)phDesign).getMainView().getWorkSpace().getDiagramBounds();
                if (r2d != null) {
                    Rectangle rect = r2d.getBounds();
                    this.rearrangeViews(rect, arrViews, ((RelationalDesign)phDesign).getMainView());
                }
                if (arrayList.size() > 0 && !((RelationalDesign)phDesign).getMainView().isAutoRoute()) {
                    ((DPVRelational)((RelationalDesign)phDesign).getMainView()).straightenLines(arrayList);
                }
                for (TableView view : arrViews) {
                    if (groupEdit == null) {
                        groupEdit = arrViews.size() == 1 ? new GroupCreateEdit(view, "Redo Create of " + view.getLongName(), "Undo Create of " + view.getLongName()) : new GroupCreateEdit(view, "Redo Create of Views from Tables(" + arrViews.size() + ")", "Undo Create of Views from Tables(" + arrViews.size() + ")");
                    }
                    CreateDO_Edit.addUndoableCreateEditForObject(groupEdit, view);
                }
                if (arrayList.size() > 0 && groupEdit != null) {
                    for (FKIndexAssociation fk : arrayList) {
                        CreateDO_Edit.addUndoableCreateEditForObject(groupEdit, fk);
                    }
                }
                if (this.cbCreateSubView.isSelected() && (subView = this.createSubViewFromSelected(arrViews.toArray(), ((RelationalDesign)phDesign).getMainView())) != null) {
                    Rectangle rect = new Rectangle(0, 0, r2d.getBounds().width, 0);
                    this.rearrangeViews(rect, arrViews, subView);
                    if (arrayList.size() > 0) {
                        ((DPVRelationalSubView)subView).straightenLines(arrayList);
                    }
                }
                phDesign.setDirty(true);
                JOptionPane.showMessageDialog(this, Messages.getString("Table2ViewDialog.ViewsGeneratedSuccessfully"));
            }
            catch (ClassCastException e) {
                LOGGER.error("ERROR::Table2ViewDialog::generateViews() -> ClassCastException", e);
                JOptionPane.showMessageDialog(this, Messages.getString("Table2ViewDialog.ErrorOccuredWhileGeneratingViews"));
                ApplicationView.canLogging = true;
                if (phDesign != null) {
                    phDesign.getUndoManager().setLocked(false);
                    if (groupEdit != null) {
                        int size = groupEdit.getNumberOfEdits();
                        groupEdit.end();
                        if (size > 0) {
                            phDesign.postUndoableEdit(groupEdit);
                        }
                    }
                }
                this.setCursor(Cursor.getPredefinedCursor(0));
                return;
            }
        }
        finally {
            ApplicationView.canLogging = true;
            if (phDesign != null) {
                phDesign.getUndoManager().setLocked(false);
                if (groupEdit != null) {
                    int size = groupEdit.getNumberOfEdits();
                    groupEdit.end();
                    if (size > 0) {
                        phDesign.postUndoableEdit(groupEdit);
                    }
                }
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public DesignPartView createSubViewFromSelected(Object[] selectedObjects, DesignPartView dpv) {
        DesignPartView subView;
        if (selectedObjects.length > 0 && (subView = this.getApplicationView().createSubview(dpv)) != null) {
            subView.setAutoRoute(false);
            for (int i = 0; i < selectedObjects.length; ++i) {
                Object obj = selectedObjects[i];
                if (!(obj instanceof Table) && !(obj instanceof TableView)) continue;
                TopView tv = dpv.getViewFor((DesignObject)obj);
                ContainerView tvt = ((ContainerView)tv).createViewSynonim(subView);
                if (tvt.getCellView() != null) {
                    tvt.getCellView().setNewBounds(tv.getBounds());
                } else {
                    tvt.setBounds(tv.getBounds());
                }
                if (tvt instanceof TVView) {
                    ((TVView)tvt).addTVFKRelations();
                }
                tvt.addTVTypeSubstitutions();
                tvt.setHideElementsInCurrentOnly(tv.isHideElementsInCurrentOnly());
                tvt.getHiddenElements().addAll(tv.getHiddenElements());
                subView.synchronizeSynonymWithDisplays(tvt);
            }
            subView.getWorkSpace().updateSettings();
            return subView;
        }
        return null;
    }

    private void rearrangeViews(Rectangle usedRect, List tableViews, DesignPartView dpv) {
        int offsetLeft = 20;
        int horizontalOffset = 50;
        int verticalOffset = 50;
        int width = 200;
        int height = 80;
        int left = offsetLeft;
        int top = (int)Math.round(usedRect.getMaxY()) + verticalOffset;
        int count = 0;
        if (tableViews != null && tableViews.size() > 0) {
            Iterator it = tableViews.iterator();
            count = 0;
            int res = ((int)usedRect.getMaxX() - offsetLeft) / (width + horizontalOffset);
            if (res > width) {
                ++res;
            }
            int maxTablePerRow = (int)Math.floor(res);
            while (it.hasNext()) {
                TableView view = (TableView)it.next();
                TopView topView = view.getFirstViewForDPV(dpv);
                if (topView == null) continue;
                ++count;
                Rectangle rec = topView.getBounds();
                if (topView.getCellView() != null) {
                    topView.getCellView().setNewBounds(new Rectangle(left, top, rec.width, rec.height));
                }
                left = left + rec.width + horizontalOffset;
                height = Math.max(height, rec.height);
                if (count != maxTablePerRow) continue;
                count = 0;
                left = offsetLeft;
                top = top + height + verticalOffset;
                height = 80;
            }
        }
    }

    private TableView addView(Table table, RelationalDesign phDesign, Rectangle r, Map<TableView, Table> map) {
        TableView tableView = phDesign.getTableViewSet().createTableView(null);
        String viewName = ApplyNamingStandards.createView_Name(table.getName(), this.tfNamingRule.getText(), table.getDesignPart().getName(), table.getAbbreviation());
        this.getApplicationView().getSettings().setViewNamingRule(this.tfNamingRule.getText());
        ApplicationView.log(Messages.getString("Table2ViewDialog.CreateView") + " - " + viewName);
        tableView.setName(viewName);
        tableView.setSchemaObject(table.getSchemaObject());
        tableView.addToContainers(table, "");
        tableView.setOriginalTableID(table.getObjectID());
        map.put(tableView, table);
        for (ContainedObject col : table.getElementsCollection()) {
            tableView.add(col);
        }
        tableView.setUserDefined(true);
        tableView.setUserDefinedSQL(tableView.generateSQL());
        for (ColumnView cv : tableView.getElementsCollection()) {
            ContainedObjectWithDomain fe = cv.getReferencedColumn();
            if (fe == null) continue;
            cv.setCommentInRDBMS(fe.getCommentInRDBMS());
        }
        if (this.cbViewConstraints.isSelected()) {
            KeyObject[] keys = table.getKeys();
            for (int i = 0; i < keys.length; ++i) {
                ContainedObject columnView;
                ContainedObject column;
                int j;
                ContainedObject[] columns;
                ViewIndex index;
                KeyObject key = keys[i];
                if (key.isPK()) {
                    index = new ViewIndex(tableView.getDesignPart());
                    tableView.add(index);
                    index.setPK(true);
                    index.setName(key.getName());
                    columns = key.getElements();
                    for (j = 0; j < columns.length; ++j) {
                        column = columns[j];
                        columnView = tableView.getElementByName(column.getName());
                        if (columnView == null) continue;
                        index.add(columnView);
                    }
                    continue;
                }
                if (!key.isUnique()) continue;
                index = new ViewIndex(tableView.getDesignPart());
                tableView.add(index);
                index.setUnique(true);
                index.setName(key.getName());
                columns = key.getElements();
                for (j = 0; j < columns.length; ++j) {
                    column = columns[j];
                    columnView = tableView.getElementByName(column.getName());
                    if (columnView == null) continue;
                    index.add(columnView);
                }
            }
        }
        if (this.cbEditioning.isSelected()) {
            for (StorageDesign stDes : phDesign.getSorageDesigns()) {
                TableViewProxyOraclev10g tableViewProxy;
                if (!stDes.isOpen() || !(stDes instanceof StorageDesignOraclev11g) || (tableViewProxy = (TableViewProxyOraclev10g)stDes.getTableViewProxySet().getObjectByID(tableView.getObjectID())) == null) continue;
                tableViewProxy.setEditioning("YES");
            }
        }
        TopView topView = phDesign.getMainView().getViewFor(tableView);
        Dimension dim = phDesign.getTableSize(table);
        if (topView != null && topView.getCellView() != null) {
            r.width = dim.width;
            r.height = dim.height;
            topView.getCellView().setNewBounds(r);
        }
        return tableView;
    }

    private void createForeignKeys(Map<TableView, Table> map, List fkList) {
        for (Map.Entry<TableView, Table> entry : map.entrySet()) {
            TableView view = entry.getKey();
            Table table = entry.getValue();
            FKIndexAssociation[] fkeys = table.getFKAssociations();
            for (int i = 0; i < fkeys.length; ++i) {
                KeyObject index;
                FKIndexAssociation fk = fkeys[i];
                FKContainer remoteTable = fk.getRemoteTable();
                TableView remoteView = this.getRemoteView(remoteTable);
                if (remoteView == null || (index = remoteView.getPK()) == null) continue;
                try {
                    FKIndexAssociation fkass = view.addFK(index);
                    fkass.setName(fk.getName());
                    fkass.setMandatory(fk.isMandatory());
                    ContainedObject[] elements = index.getElements();
                    for (int j = 0; j < elements.length; ++j) {
                        FKElement col = (FKElement)elements[j];
                        fkass.addFKElementToView(fk.getLocalFKIndex().getElement(j).getName(), col, view);
                    }
                    fkass.resetEdgeParams();
                    fkList.add(fkass);
                    continue;
                }
                catch (Throwable t) {
                    LOGGER.error("ERROR::Table2ViewDialog::createForeignKeys(): ", t);
                }
            }
        }
    }

    private TableView getRemoteView(FKContainer remoteTable) {
        Iterator it = remoteTable.getRelationalModel().getTableViewSet().iterator();
        while (it.hasNext()) {
            TableView remoteView = (TableView)it.next();
            if (!remoteTable.getObjectID().equalsIgnoreCase(remoteView.getOriginalTableID())) continue;
            return remoteView;
        }
        return null;
    }

    private Component makeCenterPanel() {
        JPanel pnl = new JPanel(new BorderLayout());
        pnl.add((Component)this.makeTable(), "Center");
        pnl.add(this.makeOptions(), "South");
        return pnl;
    }

    private Component makeDialogButtonsPanel() {
        JPanel pnl = new JPanel(new FlowLayout(2));
        this.btnGenerate = new JButton(Messages.getString("Table2ViewDialog.Generate"));
        this.btnGenerate.setMnemonic(71);
        this.btnClose = new JButton(Messages.getString("Table2ViewDialog.Close"));
        this.btnClose.setMnemonic(67);
        this.btnGenerate.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.btnClose.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        JButton btnHelp = new JButton(this.getHelpAction());
        btnHelp.setMnemonic(72);
        btnHelp.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        pnl.add(this.btnGenerate);
        pnl.add(this.btnClose);
        pnl.add(btnHelp);
        return pnl;
    }

    private JComponent makeTopPanel() {
        JPanel pnl = new JPanel(new FlowLayout(0));
        DefaultComboBoxModel mdlCombo = new DefaultComboBoxModel();
        this.cmbRelationals.setModel(mdlCombo);
        this.cmbRelationals.setEditable(false);
        this.cmbRelationals.setPreferredSize(new Dimension(250, 23));
        JPanel jpanel = new JPanel(new FlowLayout(2));
        jpanel.add(this.bnSelectAll);
        jpanel.add(this.bnDeselectAll);
        pnl.add(this.cmbRelationals);
        pnl.add(jpanel);
        return pnl;
    }

    private JComponent makeTable() {
        this.tblTables.getSelectionModel().setSelectionMode(0);
        this.tblTables.setCellSelectionEnabled(false);
        this.tblTables.setRowSelectionAllowed(true);
        this.tblTables.setColumnSelectionAllowed(false);
        this.tblTables.setBorder(LineBorder.createBlackLineBorder());
        this.tblTables.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Table2ViewDialog.this.handleGenerateButton();
            }
        });
        CustomTBModel mdlTable = new CustomTBModel(new TableSet(null));
        this.tblTables.setModel(mdlTable);
        this.setTableWidths();
        this.spnTables.setViewportView(this.tblTables);
        return this.spnTables;
    }

    private void setTableWidths() {
        int column_offset = 20;
        CustomTBModel mdlTable = (CustomTBModel)this.tblTables.getModel();
        Enumeration<TableColumn> enumCol = this.tblTables.getColumnModel().getColumns();
        int colNum = 0;
        FontMetrics fm = this.tblTables.getFontMetrics(this.tblTables.getFont());
        String name = "default";
        while (enumCol.hasMoreElements()) {
            TableColumn col = enumCol.nextElement();
            if (colNum == 0 && enumCol.hasMoreElements()) {
                name = mdlTable.getColumnName(colNum);
                int colWidth = fm.stringWidth(name) + 20;
                col.setMaxWidth(colWidth);
            }
            ++colNum;
        }
    }

    private Component makeOptions() {
        JPanel pnl = new JPanel(new BorderLayout());
        pnl.add((Component)this.makeViewOptions(), "Center");
        pnl.add((Component)this.makeNamingRule(), "South");
        return pnl;
    }

    private JComponent makeViewOptions() {
        JPanel pnViewOptions = new JPanel(new FlowLayout(0));
        JLabel label = new JLabel(Messages.getString("Table2ViewDialog.CreateEditioningViews"));
        label.setHorizontalAlignment(4);
        pnViewOptions.add(label);
        this.cbEditioning = new JCheckBox();
        this.cbEditioning.setSelected(false);
        pnViewOptions.add(this.cbEditioning);
        pnViewOptions.add(new JPanel());
        JLabel lb2 = new JLabel(Messages.getString("Table2ViewDialog.CreateViewsConstraints"));
        lb2.setHorizontalAlignment(4);
        pnViewOptions.add(lb2);
        this.cbViewConstraints = new JCheckBox();
        this.cbViewConstraints.setSelected(false);
        pnViewOptions.add(this.cbViewConstraints);
        pnViewOptions.add(new JPanel());
        JLabel lb3 = new JLabel(Messages.getString("Table2ViewDialog.CreateSubView"));
        lb3.setHorizontalAlignment(4);
        pnViewOptions.add(lb3);
        this.cbCreateSubView = new JCheckBox();
        this.cbCreateSubView.setSelected(false);
        pnViewOptions.add(this.cbCreateSubView);
        return pnViewOptions;
    }

    private JComponent makeNamingRule() {
        JPanel pnNamingRule = new JPanel(new FlowLayout(0));
        JLabel label = new JLabel(Messages.getString("Table2ViewDialog.NamingRule"));
        label.setHorizontalAlignment(4);
        pnNamingRule.add(label);
        this.tfNamingRule = new JTextField();
        this.tfNamingRule.setText(this.getApplicationView().getSettings().getViewNamingRule());
        this.tfNamingRule.setPreferredSize(new Dimension(250, 23));
        pnNamingRule.add(this.tfNamingRule);
        this.btnAddVariable = new JButton(Messages.getString("Table2ViewDialog.AddVariable"));
        this.btnAddVariable.setMnemonic(86);
        this.btnAddVariable.setPreferredSize(MessageDialogs.BUTTON_SIZE_EX);
        this.btnAddVariable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String[][] names = new String[][]{{"{model}", "model name"}, {"{table}", "table name"}};
                Table2ViewDialog.this.createDialog(names, Table2ViewDialog.this.tfNamingRule);
            }
        });
        pnNamingRule.add(this.btnAddVariable);
        return pnNamingRule;
    }

    private void createDialog(String[][] value, JTextField field) {
        KeyDialog keyDialog = new KeyDialog(this.getApplicationView());
        keyDialog.setValues(value);
        keyDialog.setVisible(true);
        StringBuffer buffer = new StringBuffer();
        int cursorPos = field.getCaretPosition();
        int tfSize = field.getText().length();
        if (cursorPos == 0) {
            buffer.append(keyDialog.getProviderName());
        }
        if (tfSize != 0) {
            for (int i = 0; i < tfSize; ++i) {
                String providerName;
                buffer.append(field.getText().charAt(i));
                if (cursorPos != i + 1 || (providerName = keyDialog.getProviderName()) == null) continue;
                buffer.append(providerName);
            }
            field.setText(buffer.toString());
        } else {
            field.setText(keyDialog.getProviderName());
        }
    }

    class CustomTBModel
    extends AbstractTableModel {
        private TableSet mdlData = null;
        private ArrayList checkedState = null;
        private Class[] columnTypes = new Class[]{Boolean.class, Object.class};
        private String[] columnNames = new String[]{Messages.getString("Table2ViewDialog.Selected"), Messages.getString("Table2ViewDialog.Tables")};
        private boolean[] columnEditable = new boolean[]{true, false};

        public CustomTBModel(TableSet model) {
            this.mdlData = model;
            this.initCheckedState();
        }

        private void initCheckedState() {
            if (this.mdlData != null) {
                int size = this.mdlData.size();
                this.checkedState = new ArrayList(size);
                for (int i = 0; i < size; ++i) {
                    this.checkedState.add(i, Boolean.TRUE);
                }
            }
        }

        public Class getColumnClass(int columnIndex) {
            return this.columnTypes[columnIndex];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return this.columnEditable[columnIndex];
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.mdlData != null ? this.mdlData.size() : -1;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (this.getColumnClass(columnIndex).equals(Boolean.class)) {
                return this.checkedState.get(rowIndex);
            }
            if (this.getColumnClass(columnIndex).equals(Object.class)) {
                Table obj = (Table)this.mdlData.getElement(rowIndex);
                return obj.getName();
            }
            return "Unexpected class at: " + rowIndex + " " + columnIndex;
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            if (this.isCellEditable(rowIndex, columnIndex) && this.getColumnClass(columnIndex).equals(Boolean.class)) {
                this.checkedState.set(rowIndex, value);
            }
        }

        public Object getElementAt(int rowIndex, int columnIndex) {
            return this.mdlData.getElement(rowIndex);
        }

        public boolean[] getColumnEditable() {
            return this.columnEditable;
        }

        public void setColumnEditable(boolean[] columnEditable) {
            this.columnEditable = columnEditable;
        }

        public String[] getColumnNames() {
            return this.columnNames;
        }

        public void setColumnNames(String[] columnNames) {
            this.columnNames = columnNames;
        }

        public Class[] getColumnTypes() {
            return this.columnTypes;
        }

        public void setColumnTypes(Class[] columnTypes) {
            this.columnTypes = columnTypes;
        }

        public TableSet getMdlData() {
            return this.mdlData;
        }
    }

    private class KeyDialog
    extends JDialog {
        private JTable nameTable;
        private JScrollPane pane;
        private JPanel buttonsPanel;
        private String[][] values;
        private NameProvider provider;

        public KeyDialog(ApplicationView view) {
            super(view.getFrame());
            this.values = new String[0][];
            this.provider = new NameProvider();
            this.setTitle(Messages.getString("Table2ViewDialog.NameElementProvider"));
            this.nameTable = new JTable(new KeyTableModel());
            this.nameTable.setSelectionMode(0);
            this.nameTable.setTableHeader(null);
            this.pane = new JScrollPane(this.nameTable);
            this.pane.setPreferredSize(new Dimension(350, 100));
            this.getContentPane().add(this.pane);
            this.getContentPane().add((Component)this.getButtonPanel(), "South");
            this.setResizable(false);
            this.setModal(true);
            this.pack();
            CommonUtil.centerOnScreen(this);
        }

        protected JPanel getButtonPanel() {
            if (this.buttonsPanel == null) {
                this.buttonsPanel = new JPanel();
                JButton ok = new JButton(Messages.getString("Table2ViewDialog.OK"));
                ok.setPreferredSize(MessageDialogs.BUTTON_SIZE);
                ok.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (KeyDialog.this.nameTable.getSelectedRow() != -1) {
                            KeyDialog.this.provider.setName(KeyDialog.this.nameTable.getValueAt(KeyDialog.this.nameTable.getSelectedRow(), 0).toString());
                        }
                        KeyDialog.this.dispose();
                    }
                });
                JButton cancel = new JButton(Messages.getString("Table2ViewDialog.Cancel"));
                cancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
                cancel.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        KeyDialog.this.dispose();
                    }
                });
                this.buttonsPanel.add(ok);
                this.buttonsPanel.add(cancel);
            }
            return this.buttonsPanel;
        }

        public String getProviderName() {
            return this.provider.getName();
        }

        public void setValues(String[][] value) {
            this.values = value;
        }

        class KeyTableModel
        extends AbstractTableModel {
            KeyTableModel() {
            }

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public int getRowCount() {
                return KeyDialog.this.values.length;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                return KeyDialog.this.values[rowIndex][columnIndex];
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }
        }
    }

    class NameProvider {
        private String name;

        NameProvider() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String newName) {
            this.name = newName;
        }
    }
}

