/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.printing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.util.Enumeration;
import java.util.Properties;
import javax.swing.JDialog;
import oracle.dbtools.crest.swingui.printing.Messages;
import oracle.dbtools.crest.swingui.printing.PrintPreviewController;
import oracle.dbtools.crest.swingui.printing.PrintPreviewModel;
import oracle.dbtools.crest.swingui.printing.PrintPreviewView;
import oracle.dbtools.crest.swingui.printing.SwingComponentPrinter;

public class SwingComponentAdapter
implements SwingComponentPrinter {
    private PrintPreviewView view;
    private PrintPreviewModel model;
    private PrintPreviewController control;

    @Override
    public void setComponentToPrint(Component cmp, Dimension dim) {
        this.model = new PrintPreviewModel(cmp, dim);
    }

    @Override
    public Component getViewComponent() {
        if (this.model == null) {
            throw new IllegalStateException(Messages.getString("SwingComponentAdapter.PrinterModelNotYetInitialized"));
        }
        if (this.view == null) {
            this.view = new PrintPreviewView(this.model);
        }
        return this.view;
    }

    @Override
    public Component getButtonPanel() {
        if (this.model == null) {
            throw new IllegalStateException(Messages.getString("SwingComponentAdapter.PrinterModelNotYetInitialized"));
        }
        if (this.control == null) {
            this.control = new PrintPreviewController(this.model);
        }
        return this.control;
    }

    @Override
    public void setPreferences(Properties props) {
        if (this.model == null) {
            throw new IllegalStateException(Messages.getString("SwingComponentAdapter.PrinterModelNotYetInitialized"));
        }
        if (props == null) {
            return;
        }
        PageFormat pageformat = (PageFormat)this.model.getPageFormat().clone();
        Paper paper = pageformat.getPaper();
        int orientation = pageformat.getOrientation();
        double width = paper.getWidth();
        double height = paper.getHeight();
        double imageablex = paper.getImageableX();
        double imageabley = paper.getImageableY();
        double imageablewidth = paper.getImageableWidth();
        double imageableheight = paper.getImageableHeight();
        Enumeration<Object> e = props.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement().toString().trim();
            String value = props.get(key).toString().trim();
            if ("pageformat.orientation".equalsIgnoreCase(key)) {
                orientation = Integer.parseInt(value);
                continue;
            }
            if ("pageformat.width".equalsIgnoreCase(key)) {
                width = Double.parseDouble(value);
                continue;
            }
            if ("pageformat.height".equalsIgnoreCase(key)) {
                height = Double.parseDouble(value);
                continue;
            }
            if ("pageformat.imageablex".equalsIgnoreCase(key)) {
                imageablex = Double.parseDouble(value);
                continue;
            }
            if ("pageformat.imageabley".equalsIgnoreCase(key)) {
                imageabley = Double.parseDouble(value);
                continue;
            }
            if ("pageformat.imageablewidth".equalsIgnoreCase(key)) {
                imageablewidth = Double.parseDouble(value);
                continue;
            }
            if (!"pageformat.imageableheight".equalsIgnoreCase(key)) continue;
            imageableheight = Double.parseDouble(value);
        }
        pageformat.setOrientation(orientation);
        paper.setSize(width, height);
        paper.setImageableArea(imageablex, imageabley, imageablewidth, imageableheight);
        this.model.setPageFormat(pageformat);
    }

    @Override
    public Properties getPreferences() {
        if (this.model == null) {
            throw new IllegalStateException(Messages.getString("SwingComponentAdapter.PrinterModelNotYetInitialized"));
        }
        PageFormat pageformat = this.model.getPageFormat();
        Paper paper = pageformat.getPaper();
        Properties props = new Properties();
        props.put("pageformat.orientation", pageformat.getOrientation() + "");
        props.put("pageformat.width", paper.getWidth() + "");
        props.put("pageformat.height", paper.getHeight() + "");
        props.put("pageformat.imageablex", paper.getImageableX() + "");
        props.put("pageformat.imageabley", paper.getImageableY() + "");
        props.put("pageformat.imageablewidth", paper.getImageableWidth() + "");
        props.put("pageformat.imageableheight", paper.getImageableHeight() + "");
        return props;
    }

    @Override
    public void prepareGC() {
        this.model = null;
        this.view = null;
        this.control = null;
    }

    @Override
    public void setDialog(JDialog dialog) {
        if (this.control != null) {
            this.control.setDialog(dialog);
        }
    }
}

