/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v9i;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v12c.StorageDesignOraclev12c;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.SequenceOraclev9i;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.AbstractPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.PropertiesPropagationDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.swingui.editor.storage.oracle.ObjectPermissionsDialogOracle;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;

public class SequencePropertyDialogOraclev9i
extends AbstractOraclePropertyDialog {
    private SequenceOraclev9i sequence;
    private JComboBox cbUser;
    private JIntegerField ifStartWith;
    private JIntegerField ifIncrementBy;
    private JIntegerField ifMaxValue;
    private JIntegerField ifMinValue;
    private JComboBox cbCycle;
    private JComboBox cbNoCache;
    private JIntegerField ifCache;
    private JComboBox cbOrder;
    private JComboBox cbSession;
    private JButton bnPermissions;
    private ObjectPermissionsDialogOracle dialog;
    private static final int SEQ_VALUE_MAX_DIGITS = 28;

    public SequencePropertyDialogOraclev9i(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.sequence = (SequenceOraclev9i)object;
        int height = 400;
        if (this.getStorageDesign() instanceof StorageDesignOraclev12c) {
            height = 430;
        }
        this.setHeight(height);
        this.initCommentsView(height - 50);
        this.initNotesView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("SequencePropertyDialogOraclev9i.SequenceProperties");
    }

    @Override
    protected void initGeneralView() {
        int yCoord;
        super.initGeneralView();
        this.initUser();
        this.initStartWith();
        this.initIncrementBy();
        this.initMinValue();
        this.initMaxValue();
        this.initCycle();
        this.initCache();
        this.initOrder();
        if (this.storageDesign instanceof StorageDesignOraclev12c) {
            this.initSession(320);
            yCoord = 360;
        } else {
            yCoord = 330;
        }
        if (this.isEditable()) {
            this.initPropagatePropsButton(yCoord);
        }
        this.initPermissionsButton(yCoord);
    }

    private void initUser() {
        JLabel label = new JLabel(Messages.getString("SequencePropertyDialogOraclev9i.User"));
        this.general.add(label);
        this.cbUser = new JComboBox();
        this.setBG(this.cbUser);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getUserSet().toArray(), this.cbUser);
        }
        this.cbUser.removeItem(this.getStorageDesign().getUserSet().getByName("PUBLIC"));
        this.cbUser.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbUser);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.cbUser, 50);
    }

    private void initStartWith() {
        JLabel label = new JLabel(Messages.getString("SequencePropertyDialogOraclev9i.StartWith"));
        this.general.add(label);
        this.ifStartWith = new JIntegerField();
        this.ifStartWith.setColumns(26);
        this.ifStartWith.setLargeIntegerDocument(28);
        this.general.add(this.ifStartWith);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.ifStartWith, 80);
    }

    private void initIncrementBy() {
        JLabel label = new JLabel(Messages.getString("SequencePropertyDialogOraclev9i.IncrementBy"));
        this.general.add(label);
        this.ifIncrementBy = new JIntegerField();
        this.ifIncrementBy.setColumns(26);
        this.ifIncrementBy.setLargeIntegerDocument(28);
        this.general.add(this.ifIncrementBy);
        this.setLabelConstraints(label, 110);
        this.setObjectConstraints(this.ifIncrementBy, 110);
    }

    private void initMaxValue() {
        JLabel label = new JLabel(Messages.getString("SequencePropertyDialogOraclev9i.MaxValue"));
        this.general.add(label);
        this.ifMaxValue = new JIntegerField();
        this.ifMaxValue.setColumns(26);
        this.ifMaxValue.setLargeIntegerDocument(28);
        this.general.add(this.ifMaxValue);
        this.setLabelConstraints(label, 170);
        this.setObjectConstraints(this.ifMaxValue, 170);
    }

    private void initMinValue() {
        JLabel label = new JLabel(Messages.getString("SequencePropertyDialogOraclev9i.MinValue"));
        this.general.add(label);
        this.ifMinValue = new JIntegerField();
        this.ifMinValue.setColumns(26);
        this.ifMinValue.setLargeIntegerDocument(28);
        this.general.add(this.ifMinValue);
        this.setLabelConstraints(label, 140);
        this.setObjectConstraints(this.ifMinValue, 140);
    }

    private void initCycle() {
        JLabel label = new JLabel(Messages.getString("SequencePropertyDialogOraclev9i.Cycle"));
        this.general.add(label);
        this.cbCycle = new JComboBox<String>(YES_NO);
        this.setBG(this.cbCycle);
        this.cbCycle.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbCycle);
        this.setLabelConstraints(label, 200);
        this.setObjectConstraints(this.cbCycle, 200);
    }

    private void initCache() {
        JLabel label = new JLabel(Messages.getString("SequencePropertyDialogOraclev9i.NoCache"));
        this.general.add(label);
        this.cbNoCache = new JComboBox<String>(YES_NO);
        this.setBG(this.cbNoCache);
        this.cbNoCache.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbNoCache);
        this.setLabelConstraints(label, 230);
        this.setObjectConstraints(this.cbNoCache, 230);
        this.cbNoCache.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AbstractPropertyDialog.YES.equals(SequencePropertyDialogOraclev9i.this.cbNoCache.getSelectedItem())) {
                    SequencePropertyDialogOraclev9i.this.ifCache.setValue(null);
                    SequencePropertyDialogOraclev9i.this.ifCache.setEditable(false);
                    SequencePropertyDialogOraclev9i.this.ifCache.setFocusable(false);
                } else {
                    try {
                        SequencePropertyDialogOraclev9i.this.ifCache.setValue(Integer.valueOf(SequencePropertyDialogOraclev9i.this.sequence.getCache()));
                    }
                    catch (NumberFormatException nfe) {
                        SequencePropertyDialogOraclev9i.this.ifCache.setValue(null);
                    }
                    SequencePropertyDialogOraclev9i.this.ifCache.setEditable(true);
                    SequencePropertyDialogOraclev9i.this.ifCache.setFocusable(true);
                }
            }
        });
        label = new JLabel(Messages.getString("SequencePropertyDialogOraclev9i.Cache"));
        this.general.add(label);
        this.ifCache = new JIntegerField();
        this.ifCache.setColumns(26);
        this.general.add(this.ifCache);
        this.setLabelConstraints(label, 260);
        this.setObjectConstraints(this.ifCache, 260);
    }

    private void initOrder() {
        JLabel label = new JLabel(Messages.getString("SequencePropertyDialogOraclev9i.Order"));
        this.general.add(label);
        this.cbOrder = new JComboBox<String>(YES_NO);
        this.setBG(this.cbOrder);
        this.cbOrder.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbOrder);
        this.setLabelConstraints(label, 290);
        this.setObjectConstraints(this.cbOrder, 290);
    }

    private void initSession(int yCoord) {
        JLabel label = new JLabel(Messages.getString("SequencePropertyDialogOraclev9i.SessionOnly"));
        this.general.add(label);
        this.cbSession = new JComboBox<String>(YES_NO);
        this.setBG(this.cbSession);
        this.cbSession.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbSession);
        this.setLabelConstraints(label, yCoord);
        this.setObjectConstraints(this.cbSession, yCoord);
    }

    private void initPropagatePropsButton(int yCoord) {
        JButton bnPropagateProps = new JButton(Messages.getString("SequencePropertyDialogOraclev9i.PropagateProperties"));
        bnPropagateProps.setIcon(this.getAppView().getConfiguration().getIcon("PROPS_PROPAGATION", 16));
        bnPropagateProps.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList list = new ArrayList();
                list.addAll(SequencePropertyDialogOraclev9i.this.getStorageDesign().getSequenceSet().getElementsList());
                list.remove(SequencePropertyDialogOraclev9i.this.sequence);
                new PropertiesPropagationDialog(SequencePropertyDialogOraclev9i.this.getAppView(), SequencePropertyDialogOraclev9i.this.sequence, list).showDialog();
            }
        });
        this.general.add(bnPropagateProps);
        this.setObjectConstraints(bnPropagateProps, 10, yCoord);
    }

    private void initPermissionsButton(int yCoord) {
        this.bnPermissions = new JButton(Messages.getString("SequencePropertyDialogOraclev9i.Permissions"));
        this.bnPermissions.setIcon(this.getAppView().getConfiguration().getIcon("PERMISSIONS_ICON", 16));
        this.bnPermissions.addActionListener(new PermissionsListener());
        this.general.add(this.bnPermissions);
        this.setObjectConstraints(this.bnPermissions, 270, yCoord);
    }

    @Override
    public void initProperties() {
        double i;
        this.initCaption(this.sequence.getName());
        this.tfName.setText(this.sequence.getName());
        this.selectObject(this.cbUser, this.sequence.getUser());
        try {
            i = Double.parseDouble(this.sequence.getStartWith());
            this.ifStartWith.setText(this.sequence.getStartWith());
        }
        catch (NumberFormatException nfe) {
            this.ifStartWith.setText("");
        }
        try {
            i = Double.parseDouble(this.sequence.getIncrementBy());
            this.ifIncrementBy.setText(this.sequence.getIncrementBy());
        }
        catch (NumberFormatException nfe) {
            this.ifIncrementBy.setText("");
        }
        try {
            double i2 = Double.parseDouble(this.sequence.getMaxValue());
            this.ifMaxValue.setText(this.sequence.getMaxValue());
        }
        catch (NumberFormatException nfe) {
            this.ifMaxValue.setText("");
        }
        try {
            double i3 = Double.parseDouble(this.sequence.getMinValue());
            this.ifMinValue.setText(this.sequence.getMinValue());
        }
        catch (NumberFormatException nfe) {
            this.ifMinValue.setText("");
        }
        this.cbCycle.setSelectedItem(SequencePropertyDialogOraclev9i.translateYesNoForDisplay(this.sequence.getCycle()));
        this.cbNoCache.setSelectedItem(SequencePropertyDialogOraclev9i.translateYesNoForDisplay(this.sequence.getNoCache()));
        try {
            this.ifCache.setValue(Integer.valueOf(this.sequence.getCache()));
        }
        catch (NumberFormatException nfe) {
            this.ifCache.setValue(null);
        }
        this.cbOrder.setSelectedItem(SequencePropertyDialogOraclev9i.translateYesNoForDisplay(this.sequence.getOrder()));
        if (this.storageDesign instanceof StorageDesignOraclev12c) {
            this.cbSession.setSelectedItem(SequencePropertyDialogOraclev9i.translateYesNoForDisplay(this.sequence.getSession()));
        }
        this.getCommentsList().insert(this.sequence.getComment(), 0);
        this.taNotes.setText(this.sequence.getNotes());
    }

    @Override
    protected void setProperties() {
        if (this.sequence != null) {
            double i;
            Object selected = this.cbUser.getSelectedItem();
            if (selected instanceof UserOracle) {
                this.sequence.setUser((UserOracle)selected);
            } else {
                this.sequence.setUser(null);
            }
            this.sequence.setName(this.tfName.getText());
            try {
                i = Double.parseDouble(this.ifStartWith.getText());
                this.sequence.setStartWith(this.ifStartWith.getText());
            }
            catch (NumberFormatException nfe) {
                this.sequence.setStartWith("");
            }
            try {
                i = Double.parseDouble(this.ifIncrementBy.getText());
                this.sequence.setIncrementBy(this.ifIncrementBy.getText());
            }
            catch (NumberFormatException nfe) {
                this.sequence.setIncrementBy("");
            }
            try {
                double i2 = Double.parseDouble(this.ifMaxValue.getText());
                this.sequence.setMaxValue(this.ifMaxValue.getText());
            }
            catch (NumberFormatException nfe) {
                this.sequence.setMaxValue("");
            }
            try {
                double i3 = Double.parseDouble(this.ifMinValue.getText());
                this.sequence.setMinValue(this.ifMinValue.getText());
            }
            catch (NumberFormatException nfe) {
                this.sequence.setMinValue("");
            }
            this.sequence.setCycle(SequencePropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbCycle.getSelectedItem()));
            String noCache = (String)this.cbNoCache.getSelectedItem();
            this.sequence.setNoCache(SequencePropertyDialogOraclev9i.translateYesNoForStorage(noCache));
            if (noCache.equals(NO)) {
                try {
                    int i4 = Integer.parseInt(this.ifCache.getText());
                    this.sequence.setCache(this.ifCache.getText());
                }
                catch (NumberFormatException nfe) {
                    this.sequence.setCache("");
                }
            }
            this.sequence.setOrder(SequencePropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbOrder.getSelectedItem()));
            if (this.storageDesign instanceof StorageDesignOraclev12c) {
                this.sequence.setSession(SequencePropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbSession.getSelectedItem()));
            }
            this.sequence.setComment(this.getCommentsList().getText());
            this.sequence.setNotes(this.taNotes.getText());
        }
    }

    @Override
    protected boolean allowName(String newName) {
        Object selectedUser = this.cbUser.getSelectedItem();
        if (selectedUser instanceof UserOracle) {
            newName = ((UserOracle)selectedUser).getName() + '.' + newName;
        }
        return this.getStorageObject().allowName(newName, true);
    }

    private class PermissionsListener
    implements ActionListener {
        private PermissionsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SequencePropertyDialogOraclev9i.this.dialog = new ObjectPermissionsDialogOracle(SequencePropertyDialogOraclev9i.this.getAppView(), SequencePropertyDialogOraclev9i.this.getStorageDesign(), SequencePropertyDialogOraclev9i.this.sequence);
            SequencePropertyDialogOraclev9i.this.dialog.showDialog();
        }
    }
}

