/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.RollbackSegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;

public class RollbackSegmentPropertyDialogOracle
extends AbstractOraclePropertyDialog {
    private RollbackSegmentOracle segment;
    private JComboBox cbPublic;
    private JComboBox cbInitialSizeUnit;
    private JComboBox cbNextSizeUnit;
    private JIntegerField ifSCInitialExtent;
    private JIntegerField ifSCNextExtent;
    private JIntegerField ifSCMinExtents;
    private JTextField tfSCMaxExtents;
    private JTextField tfSCOptimal;
    private JPanel tablespaces;
    private JList allTablespacesList;
    private JList selectedTablespacesList;
    private DefaultListModel allTablespacesModel;
    private DefaultListModel selectedTablespacesModel;
    private JButton bnAddTablespaces;
    private JButton bnRemoveTablespaces;

    public RollbackSegmentPropertyDialogOracle(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.segment = (RollbackSegmentOracle)object;
        this.setHeight(380);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("RollbackSegmentPropertyDialogOracle.SegmentProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initPublic();
        this.initSCInitialExtent();
        this.initSCNextExtent();
        this.initSCMinExtents();
        this.initSCMaxExtents();
        this.initSCOptimal();
    }

    @Override
    protected void addTabs() {
        this.initTablespacesView();
    }

    private void initTablespacesView() {
        this.tablespaces = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("RollbackSegmentPropertyDialogOracle.Tablespaces"), this.tablespaces);
        this.initTablespaces();
    }

    protected SpringLayout getTablespacesLayout() {
        return (SpringLayout)this.tablespaces.getLayout();
    }

    private void initTablespaces() {
        this.initAllTablespacesList();
        this.initSelectedTablespacesList();
        this.initTablespacesButtons();
    }

    private void initAllTablespacesList() {
        JLabel label = new JLabel(Messages.getString("RollbackSegmentPropertyDialogOracle.AllTablespaces"));
        this.tablespaces.add(label);
        this.allTablespacesModel = new DefaultListModel();
        this.allTablespacesList = new JList(this.allTablespacesModel);
        ListSelectionModel listSelectionModel = this.allTablespacesList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllTablespacesListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.allTablespacesList);
        sp.setPreferredSize(new Dimension(144, 310));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.tablespaces.add(sp);
        this.setLabelConstraints(this.getTablespacesLayout(), label, 12, 14);
        this.setObjectConstraints(this.getTablespacesLayout(), sp, 10, 34);
    }

    private void initSelectedTablespacesList() {
        JLabel label = new JLabel(Messages.getString("RollbackSegmentPropertyDialogOracle.SelectedTablespaces"));
        this.tablespaces.add(label);
        this.selectedTablespacesModel = new DefaultListModel();
        this.selectedTablespacesList = new JList(this.selectedTablespacesModel);
        ListSelectionModel listSelectionModel = this.selectedTablespacesList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedTablespacesListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.selectedTablespacesList);
        sp.setPreferredSize(new Dimension(145, 310));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.tablespaces.add(sp);
        this.setLabelConstraints(this.getTablespacesLayout(), label, 292, 14);
        this.setObjectConstraints(this.getTablespacesLayout(), sp, 290, 34);
    }

    private void initTablespacesButtons() {
        this.bnAddTablespaces = new JButton(ADD_CAPTION);
        this.bnAddTablespaces.addActionListener(new AddTablespacesActionListener());
        this.bnAddTablespaces.setEnabled(false);
        this.tablespaces.add(this.bnAddTablespaces);
        this.setObjectConstraints(this.getTablespacesLayout(), this.bnAddTablespaces, 175, 145);
        this.bnRemoveTablespaces = new JButton(REMOVE_CAPTION);
        this.bnRemoveTablespaces.setEnabled(false);
        this.bnRemoveTablespaces.addActionListener(new RemoveTablespacesActionListener());
        this.tablespaces.add(this.bnRemoveTablespaces);
        this.setObjectConstraints(this.getTablespacesLayout(), this.bnRemoveTablespaces, 175, 175);
        RollbackSegmentPropertyDialogOracle.equalizeButtonSizes(this.bnAddTablespaces, this.bnRemoveTablespaces);
    }

    private void initPublic() {
        JLabel label = new JLabel(Messages.getString("RollbackSegmentPropertyDialogOracle.Public"));
        this.general.add(label);
        this.cbPublic = new JComboBox<String>(YES_NO);
        this.setBG(this.cbPublic);
        this.cbPublic.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbPublic);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.cbPublic, 50);
    }

    private void initSCInitialExtent() {
        JLabel label = new JLabel(Messages.getString("RollbackSegmentPropertyDialogOracle.SCInitialExtent"));
        this.general.add(label);
        this.ifSCInitialExtent = new JIntegerField(0, 16);
        this.general.add(this.ifSCInitialExtent);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.ifSCInitialExtent, this.getDialogWidth() - 15 - this.tfName.getPreferredSize().width, 80);
        this.cbInitialSizeUnit = new JComboBox<String>(RollbackSegmentOracle.getSizeUnitChoices());
        this.general.add(this.cbInitialSizeUnit);
        this.cbInitialSizeUnit.setPreferredSize(new Dimension(50, this.tfName.getPreferredSize().height));
        this.setObjectConstraints(this.cbInitialSizeUnit, 80);
    }

    private void initSCNextExtent() {
        JLabel label = new JLabel(Messages.getString("RollbackSegmentPropertyDialogOracle.SCNextExtent"));
        this.general.add(label);
        this.ifSCNextExtent = new JIntegerField(0, 16);
        this.general.add(this.ifSCNextExtent);
        this.setLabelConstraints(label, 110);
        this.setObjectConstraints(this.ifSCNextExtent, this.getDialogWidth() - 15 - this.tfName.getPreferredSize().width, 110);
        this.cbNextSizeUnit = new JComboBox<String>(RollbackSegmentOracle.getSizeUnitChoices());
        this.general.add(this.cbNextSizeUnit);
        this.cbNextSizeUnit.setPreferredSize(new Dimension(50, this.tfName.getPreferredSize().height));
        this.setObjectConstraints(this.cbNextSizeUnit, 110);
    }

    private void initSCMinExtents() {
        JLabel label = new JLabel(Messages.getString("RollbackSegmentPropertyDialogOracle.SCMinExtents"));
        this.general.add(label);
        this.ifSCMinExtents = new JIntegerField(0, 26);
        this.general.add(this.ifSCMinExtents);
        this.setLabelConstraints(label, 140);
        this.setObjectConstraints(this.ifSCMinExtents, 140);
    }

    private void initSCMaxExtents() {
        JLabel label = new JLabel(Messages.getString("RollbackSegmentPropertyDialogOracle.SCMaxExtents"));
        this.general.add(label);
        this.tfSCMaxExtents = new JTextField("UNLIMITED", 26);
        this.general.add(this.tfSCMaxExtents);
        this.setLabelConstraints(label, 170);
        this.setObjectConstraints(this.tfSCMaxExtents, 170);
    }

    private void initSCOptimal() {
        JLabel label = new JLabel(Messages.getString("RollbackSegmentPropertyDialogOracle.SCOptimal"));
        this.general.add(label);
        this.tfSCOptimal = new JTextField("", 26);
        this.general.add(this.tfSCOptimal);
        this.setLabelConstraints(label, 200);
        this.setObjectConstraints(this.tfSCOptimal, 200);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.segment.getName());
        this.tfName.setText(this.segment.getName());
        this.cbPublic.setSelectedItem(RollbackSegmentPropertyDialogOracle.translateYesNoForDisplay(this.segment.getPub()));
        this.cbInitialSizeUnit.setSelectedItem(this.segment.getInitialSizeUnit());
        this.cbNextSizeUnit.setSelectedItem(this.segment.getNextSizeUnit());
        this.ifSCInitialExtent.setValue((long)this.segment.getSCInitialExtent());
        this.ifSCNextExtent.setValue((long)this.segment.getSCNextExtent());
        this.ifSCMinExtents.setValue((long)this.segment.getSCMinExtents());
        this.tfSCMaxExtents.setText(this.segment.getSCMaxExtents());
        this.tfSCOptimal.setText(this.segment.getScOptimal());
        Iterator tsIt = this.segment.getTablespaceSet().iterator();
        while (tsIt.hasNext()) {
            ModelIDObject ts = this.getStorageDesign().getTableSpaceSet().getById((String)tsIt.next());
            if (!(ts instanceof TableSpaceOracle)) continue;
            this.selectedTablespacesModel.addElement(ts);
        }
        TableSpaceOracle[] tablespaceSet = (TableSpaceOracle[])this.getStorageDesign().getTableSpaceSet().toArray();
        for (int i = 0; i < tablespaceSet.length; ++i) {
            TableSpaceOracle ts = tablespaceSet[i];
            if (this.selectedTablespacesModel.contains(ts)) continue;
            this.allTablespacesModel.addElement(ts);
        }
        this.getCommentsList().insert(this.segment.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.segment != null) {
            this.segment.setName(this.tfName.getText());
            this.segment.setPub(RollbackSegmentPropertyDialogOracle.translateYesNoForStorage((String)this.cbPublic.getSelectedItem()));
            this.segment.setInitialSizeUnit((String)this.cbInitialSizeUnit.getSelectedItem());
            this.segment.setNextSizeUnit((String)this.cbNextSizeUnit.getSelectedItem());
            this.segment.setSCInitialExtent(this.ifSCInitialExtent.getIntValue());
            this.segment.setSCNextExtent(this.ifSCNextExtent.getIntValue());
            this.segment.setSCMinExtents(this.ifSCMinExtents.getIntValue());
            this.segment.setSCMaxExtents(this.tfSCMaxExtents.getText());
            this.tfSCMaxExtents.setText(this.segment.getSCMaxExtents());
            this.segment.setScOptimal(this.tfSCOptimal.getText());
            this.segment.clear();
            Object[] tablespaceSet = this.selectedTablespacesModel.toArray();
            for (int i = 0; i < tablespaceSet.length; ++i) {
                Object ob = tablespaceSet[i];
                if (!(ob instanceof TableSpaceOracle)) continue;
                this.segment.setTablespaces(((TableSpaceOracle)ob).getObjectID());
            }
            this.segment.setComment(this.getCommentsList().getText());
        }
    }

    private class RemoveTablespacesActionListener
    implements ActionListener {
        private RemoveTablespacesActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!RollbackSegmentPropertyDialogOracle.this.selectedTablespacesModel.isEmpty()) {
                Object[] selectedObjects = RollbackSegmentPropertyDialogOracle.this.selectedTablespacesList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (RollbackSegmentPropertyDialogOracle.this.allTablespacesModel.contains(ob)) continue;
                    RollbackSegmentPropertyDialogOracle.this.allTablespacesModel.addElement(ob);
                    RollbackSegmentPropertyDialogOracle.this.selectedTablespacesModel.removeElement(ob);
                }
            }
        }
    }

    private class AddTablespacesActionListener
    implements ActionListener {
        private AddTablespacesActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!RollbackSegmentPropertyDialogOracle.this.allTablespacesModel.isEmpty()) {
                Object[] selectedObjects = RollbackSegmentPropertyDialogOracle.this.allTablespacesList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (RollbackSegmentPropertyDialogOracle.this.selectedTablespacesModel.contains(ob)) continue;
                    RollbackSegmentPropertyDialogOracle.this.selectedTablespacesModel.addElement(ob);
                    RollbackSegmentPropertyDialogOracle.this.allTablespacesModel.removeElement(ob);
                }
            }
        }
    }

    private class SelectedTablespacesListSelectionHandler
    implements ListSelectionListener {
        private SelectedTablespacesListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (RollbackSegmentPropertyDialogOracle.this.isEditable() && !e.getValueIsAdjusting()) {
                if (RollbackSegmentPropertyDialogOracle.this.selectedTablespacesList.getSelectedIndex() == -1) {
                    RollbackSegmentPropertyDialogOracle.this.bnRemoveTablespaces.setEnabled(false);
                } else {
                    RollbackSegmentPropertyDialogOracle.this.bnRemoveTablespaces.setEnabled(true);
                }
            }
        }
    }

    private class AllTablespacesListSelectionHandler
    implements ListSelectionListener {
        private AllTablespacesListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (RollbackSegmentPropertyDialogOracle.this.isEditable() && !e.getValueIsAdjusting()) {
                if (RollbackSegmentPropertyDialogOracle.this.allTablespacesList.getSelectedIndex() == -1) {
                    RollbackSegmentPropertyDialogOracle.this.bnAddTablespaces.setEnabled(false);
                } else {
                    RollbackSegmentPropertyDialogOracle.this.bnAddTablespaces.setEnabled(true);
                }
            }
        }
    }
}

