/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.relational;

import java.awt.Component;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JOptionPane;
import oracle.dbtools.crest.model.design.AbstractViewElement;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.engineering.AbstractEngineering;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.relational.ApplyNamingStandards;
import oracle.dbtools.crest.model.design.relational.FKContainer;
import oracle.dbtools.crest.model.design.relational.FKElement;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.swingui.editor.relational.Messages;
import oracle.dbtools.crest.util.options.namingstandards.NamingStandardRule;

public class FKUtilities {
    public static String generateFKName(FKIndexAssociation fk, int fkNumber) {
        FKContainer parentTable = (FKContainer)fk.getSourceObject();
        FKContainer table = (FKContainer)fk.getTargetObject();
        String childName = table.getName();
        NamingStandardRule namingStandardRule = table.getDesign().getDesignLevelSettings().getNamingStandardRule();
        String relModelName = table.getDesignPart().getName();
        String abbreviation = table.getAbbreviation();
        Relation rel = fk.getEngRelation();
        String relName = null;
        if (rel != null) {
            relName = rel.getName();
            char logSep = namingStandardRule.getLogicalSeparatorChar();
            char relSep = namingStandardRule.getRelationalSeparatorChar();
            relName = AbstractEngineering.transformSeparatorFromLogical(relName, logSep, relSep);
        }
        return ApplyNamingStandards.createFK_Name(childName, parentTable, fkNumber, namingStandardRule, relModelName, abbreviation, relName);
    }

    public static String generateFKName(FKContainer table, FKContainer parentTable, List<FKIndexAssociation.FKMemento> fkList) {
        String childName = table.getName();
        NamingStandardRule namingStandardRule = table.getDesign().getDesignLevelSettings().getNamingStandardRule();
        String relModelName = table.getDesignPart().getName();
        String abbreviation = table.getAbbreviation();
        String indexName = "";
        String lastGeneratedIndexName = null;
        int count = fkList.size();
        while (!(indexName = ApplyNamingStandards.createFK_Name(childName, parentTable, count, namingStandardRule, relModelName, abbreviation, null)).equals(lastGeneratedIndexName)) {
            lastGeneratedIndexName = indexName;
            ++count;
            if (FKUtilities.hasFK_Name(fkList, indexName)) continue;
        }
        return indexName;
    }

    public static boolean hasFK_Name(List<FKIndexAssociation.FKMemento> fkList, String name) {
        for (FKIndexAssociation.FKMemento fkMemento : fkList) {
            if (!fkMemento.name.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public static String generateFKName(FKContainer table, FKContainer parentTable, KeyObject parentKey) {
        FKIndexAssociation[] fkeys = table.getFKAssociations();
        int count = fkeys.length - 1;
        String childName = table.getName();
        NamingStandardRule namingStandardRule = table.getDesign().getDesignLevelSettings().getNamingStandardRule();
        String relModelName = table.getDesignPart().getName();
        String abbreviation = table.getAbbreviation();
        String indexName = "";
        String lastGeneratedIndexName = null;
        while (!(indexName = ApplyNamingStandards.createFK_Name(childName, parentTable, parentKey, count, namingStandardRule, relModelName, abbreviation, null)).equals(lastGeneratedIndexName)) {
            lastGeneratedIndexName = indexName;
            ++count;
            if (FKUtilities.hasFK_Name(fkeys, indexName)) continue;
        }
        return indexName;
    }

    public static boolean hasFK_Name(FKIndexAssociation[] fkeys, String name) {
        for (int i = 0; i < fkeys.length; ++i) {
            if (!fkeys[i].getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public static boolean compatibleColumns(FKElement col1, FKElement col2) {
        if (col1.isOid() && col1.getContainerWithKeyObject().getBasedOnStructuredType() != null) {
            return col2.isRefToStructuredType(col1.getContainerWithKeyObject().getBasedOnStructuredType());
        }
        String c1name = col1.getDataType().getName();
        if (col1 instanceof AbstractViewElement && "UNKNOWN".equalsIgnoreCase(c1name)) {
            return true;
        }
        String c2name = col2.getDataType().getName();
        if (col2 instanceof AbstractViewElement && "UNKNOWN".equalsIgnoreCase(c2name)) {
            return true;
        }
        return c1name.equalsIgnoreCase(c2name);
    }

    public static boolean hasPKColumns(FKIndexAssociation fk) {
        KeyObject pk = fk.getContainerWithKeyObject().getPK();
        if (pk != null && fk.getLocalFKIndex() != null) {
            for (FKElement co : fk.getLocalFKIndex().getElementsCollection()) {
                if (!pk.contains(co)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasPKColumnsOnly(FKIndexAssociation fk) {
        KeyObject pk = fk.getContainerWithKeyObject().getPK();
        if (pk == null) {
            return false;
        }
        if (pk != null && fk.getLocalFKIndex() != null) {
            for (FKElement co : fk.getLocalFKIndex().getElementsCollection()) {
                if (pk.contains(co)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean hasPKColumnsOnly(FKIndexAssociation fk, FKElement[] fkColumns) {
        KeyObject pk = fk.getContainerWithKeyObject().getPK();
        if (pk == null) {
            return false;
        }
        if (pk != null && fk.getLocalFKIndex() != null) {
            for (FKElement co : fkColumns) {
                if (pk.contains(co)) continue;
                return false;
            }
        }
        return true;
    }

    public static FKElement[] getCompatibleColumns(FKContainer container, FKElement column) {
        ArrayList columns = container.getElementsCollection();
        List nestedColumns = container.getNestedElements();
        if (nestedColumns.size() > 0) {
            columns = new ArrayList(columns);
            columns.addAll(nestedColumns);
        }
        return FKUtilities.getCompatibleColumns(columns, column);
    }

    public static FKElement[] getCompatibleColumns(Collection<FKElement> columns, FKElement column) {
        ArrayList<FKElement> col = new ArrayList<FKElement>();
        for (FKElement currentColumn : columns) {
            if (!FKUtilities.compatibleColumns(column, currentColumn)) continue;
            col.add(currentColumn);
        }
        return col.toArray(new FKElement[0]);
    }

    public static boolean hasMandatoryColumns(FKElement[] fkColumns) {
        for (int i = 0; i < fkColumns.length; ++i) {
            if (fkColumns[i].getNullsAllowed()) continue;
            return true;
        }
        return false;
    }

    public static boolean hasOptionalColumns(FKElement[] fkColumns) {
        for (int i = 0; i < fkColumns.length; ++i) {
            if (!fkColumns[i].getNullsAllowed()) continue;
            return true;
        }
        return false;
    }

    public static boolean checkRequiredProperties(Component messageDialogParent, FKElement[] fkColumns, FKIndexAssociation fkIndexAssociation, boolean mandatory, boolean transferable) {
        int i;
        if (fkColumns == null || fkColumns.length == 0) {
            JOptionPane.showMessageDialog(messageDialogParent, FKUtilities.formatMessage("ForeignKeyPropertiesDialogEx.IncompleteFKdefinition", fkIndexAssociation.getName()), Messages.getString("ForeignKeyPropertiesDialogEx.FKColumnsAssignment"), 0);
            return false;
        }
        for (i = 0; i < fkColumns.length; ++i) {
            if (fkColumns[i] != null) continue;
            JOptionPane.showMessageDialog(messageDialogParent, FKUtilities.formatMessage("ForeignKeyPropertiesDialogEx.IncompleteFKdefinition", fkIndexAssociation.getName()), Messages.getString("ForeignKeyPropertiesDialogEx.FKColumnsAssignment"), 0);
            return false;
        }
        if (FKUtilities.hasPKColumnsOnly(fkIndexAssociation, fkColumns) && !mandatory) {
            JOptionPane.showMessageDialog(messageDialogParent, FKUtilities.formatMessage("ForeignKeyPropertiesDialogEx.FKCannotBeOptional", fkIndexAssociation.getName()), Messages.getString("ForeignKeyPropertiesDialogEx.FKColumnsInPK"), 0);
            return false;
        }
        if (!mandatory && FKUtilities.hasMandatoryColumns(fkColumns) && !FKUtilities.hasOptionalColumns(fkColumns)) {
            int result = JOptionPane.showConfirmDialog(messageDialogParent, FKUtilities.formatMessage("ForeignKeyPropertiesDialogEx.FKIsOptional", fkIndexAssociation.getName()), Messages.getString("ForeignKeyPropertiesDialogEx.MandatoryFKColumns"), 0);
            return result == 0;
        }
        for (i = 0; i < fkColumns.length; ++i) {
            for (FKIndexAssociation fk : fkColumns[i].getAllFKs()) {
                if (fk == fkIndexAssociation || fk.isTransferable() == transferable) continue;
                JOptionPane.showMessageDialog(messageDialogParent, MessageFormat.format(FKUtilities.formatMessage("ForeignKeyPropertiesDialogEx.Column", fkIndexAssociation.getName()), fkColumns[i].getName()), Messages.getString("ForeignKeyPropertiesDialogEx.FKColumnCollisionalUsage"), 0);
                return false;
            }
        }
        return true;
    }

    public static String formatMessage(String messageKey, String fkName) {
        return MessageFormat.format(Messages.getString(messageKey), fkName);
    }

    public static FKElement[] getFKColumns(FKIndexAssociation.FKMemento fkMemento) {
        return FKUtilities.getFKColumns(fkMemento, null);
    }

    public static FKElement[] getFKColumns(FKIndexAssociation.FKMemento fkMemento, List newColumns) {
        FKElement[] fkColumns = new FKElement[fkMemento.columns.size()];
        for (int i = 0; i < fkMemento.columns.size(); ++i) {
            String columnID = fkMemento.columns.get(i);
            FKElement column = null;
            if (columnID != null && (column = (FKElement)fkMemento.table.getElementByID(columnID)) == null && newColumns != null) {
                column = FKUtilities.getColumn(columnID, newColumns);
            }
            fkColumns[i] = column;
        }
        return fkColumns;
    }

    public static FKElement[] getFKColumnsFromTable(FKIndexAssociation.FKMemento fkMemento, FKContainer table) {
        ArrayList<FKElement> list = new ArrayList<FKElement>();
        for (int i = 0; i < fkMemento.columns.size(); ++i) {
            String columnID = fkMemento.columns.get(i);
            FKElement column = null;
            if (columnID == null || (column = (FKElement)table.getElementByID(columnID)) == null) continue;
            list.add(column);
        }
        return list.toArray(new FKElement[0]);
    }

    public static FKElement getColumn(String columnID, List columns) {
        for (FKElement column : columns) {
            if (!columnID.equals(column.getObjectID())) continue;
            return column;
        }
        return null;
    }

    public static boolean containsEmptyColumns(FKIndexAssociation.FKMemento fkMemento) {
        if (fkMemento.columns.isEmpty()) {
            return true;
        }
        for (String columnID : fkMemento.columns) {
            if (columnID != null && !columnID.equals("")) continue;
            return true;
        }
        return false;
    }
}

