/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.logical;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.datatype.MDDataType;
import oracle.dbtools.crest.model.datatype.MDImplicitSized;
import oracle.dbtools.crest.model.datatype.MDPackedSized;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.compare.CompareTreeNavigationDesign;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.impact.ImpA_Relation;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.logical.AttributePropertiesDialogEx;
import oracle.dbtools.crest.swingui.editor.logical.LogicalObjectPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.logical.Messages;
import oracle.dbtools.crest.swingui.impact.ImpactTreeRenderer;
import oracle.dbtools.crest.swingui.logical.TVEntity;
import oracle.dbtools.crest.swingui.logical.TVRelation;
import oracle.dbtools.crest.util.GUID;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;
import oracle.dbtools.crest.util.gui.swing.MoveUpDownListJTable;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.options.PreferredDomain;
import oracle.ide.Ide;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;

public class RelationPropertiesDialogEx
extends LogicalObjectPropertiesDialog {
    private Relation relation;
    private JPanel pnCardinality;
    private JTextField tfNameOnSource;
    private JComboBox cbSourceEntity;
    private JComboBox cbSourceCardinality;
    private JCheckBox chSourceOptional;
    private JComboBox cbSourceEntitySynonym;
    private Entity oldSource;
    private JTextField tfNameOnTarget;
    private JComboBox cbTargetEntity;
    private JComboBox cbTargetCardinality;
    private JCheckBox chTargetOptional;
    private JCheckBox chTargetTransferable;
    private JCheckBox chSourceTransferable;
    private JComboBox cbTargetEntitySynonym;
    private Entity oldTarget;
    private JComboBox cbDominantRole;
    private JComboBox cbDeleteRule;
    private JComboBox cbSourcePK;
    private JComboBox cbTargetPK;
    private JCheckBox chIdentifying;
    private JCheckBox chUseSurrogateKey;
    private JCheckBox chInArc;
    private JTree tree;
    private Entity noneEntity;
    private JPanel pnFKAttributes;
    private JPanel pnAttributes;
    private List<Attribute> fkAttributesList;
    private DesignObject obj;
    private JTable tbAttributes;
    private JTable coTable;
    private List attributesList;
    private RSyntaxTextArea taColumnComments;
    private RSyntaxTextArea taColumnNotes;
    private RSyntaxTextArea taColumnCommentsInRDBMS;
    private JTextField tfColumnName;
    private JRadioButton rbDomain;
    private JRadioButton rbLogical;
    private JRadioButton rbDistinct;
    private JRadioButton rbStructured;
    private JRadioButton rbCollection;
    private JComboBox cbDatatype;
    private ActionListener cbDatatypeActionListener;
    private JTextField ifDTSize;
    private JIntegerField ifDTPrecision;
    private JIntegerField ifDTScale;
    private JPanel pnDType;
    private JPanel pnDTSize;
    private JPanel pnDTScale;
    private JPanel pnRef;
    private Attribute selectedAttribute = null;
    private JButton bnCOAdd;
    private JButton bnCORemove;
    private JButton bnCOUp;
    private JButton bnCODown;
    private JButton bnCOCopy;
    private JButton bnCOPaste;
    private boolean sizeEnabled = false;
    private JCheckBox chbUsePreferredList;
    private LogicalDatatype selLogicalDatatype = null;
    private boolean initialUseDomainPreferredList = true;
    private boolean initialUseLogicalTypePreferredList = true;
    private List<Domain> additionalPreferredDomains = new ArrayList<Domain>();
    private List currentPreferredDomainList = new ArrayList();
    private List currentPreferredLogicalTypeList = new ArrayList();
    private List<LogicalDatatype> additionalPreferredLogicalTypes = new ArrayList<LogicalDatatype>();
    private boolean precisionEnabled = false;
    private JCheckBox chbReference;
    private JComboBox cbUnits;
    private ButtonGroup group;
    private final int INIT = 0;
    private final int ADD = 1;
    private final int DELETE = 2;
    private final int INIT_SELECTED = 3;
    private int distinctTypesCount = this.getDesignObject().getDesign().getDataTypesDesign().getDistinctTypeSet().size();
    private int structuredTypesCount = this.getDesignObject().getDesign().getDataTypesDesign().getStructuredTypeSet().size();
    private int collectionTypesCount = this.getDesignObject().getDesign().getDataTypesDesign().getCollectionTypeSet().size();
    private String storedColumnDefaultDatatype = this.getAppView().getSettings().getColumnDefaultDatatype().trim();
    private Object domainDefaultDataType;
    private Object logicalDefaultDataType;
    private String precisionDefaultValue;
    private String scaleDefaultValue;
    private String sizeDefaultValue;
    private JCheckBox chbMandatory;
    private Entity entity;
    private int attrCounter = 0;
    private static final String ATTRIBUTES_TAB_NAME = Messages.getString("RelationPropertiesDialogEx.Attributes");
    private static final Logger LOGGER = new Logger(RelationPropertiesDialogEx.class);

    public RelationPropertiesDialogEx(ApplicationView view, DesignObject object) {
        super(view, object);
        this.obj = object;
    }

    @Override
    public String getCaption() {
        return Messages.getString("RelationPropertiesDialogEx.RelationProperties");
    }

    @Override
    protected int getMinimumWidth() {
        return 880;
    }

    @Override
    protected int getMinimumHeight() {
        return 520;
    }

    @Override
    public void initProperties(DesignObject object) {
        if (object instanceof Relation) {
            this.relation = (Relation)object;
            this.entity = this.relation.getOwnedEntity();
            this.attributesList.addAll(Arrays.asList(this.entity.getElements()));
            this.noneEntity = this.relation.getNONEEntity();
            this.initDefaults();
            this.oldSource = this.relation.getSourceEntity();
            this.oldTarget = this.relation.getTargetEntity();
            this.tfNameOnSource.setText(this.relation.getNameOnSource());
            this.fillComboItems(Relation.getCardinalityChoices(), this.cbTargetCardinality, false);
            this.cbTargetCardinality.setSelectedItem(this.relation.getTargetCardinality());
            this.chSourceOptional.setSelected(this.relation.isOptionalSource());
            this.cbTargetCardinality.addActionListener(this.setDominantRoleState());
            this.fillComboItems(Relation.getCardinalityChoices(), this.cbSourceCardinality, false);
            this.cbSourceCardinality.setSelectedItem(this.relation.getSourceCardinality());
            this.cbSourceCardinality.addActionListener(this.setDominantRoleState());
            this.tfNameOnTarget.setText(this.relation.getNameOnTarget());
            this.chTargetOptional.setSelected(this.relation.isOptionalTarget());
            this.fillComboItems(this.getDesignObject().getDesign().getLogicalDesign().getEntitySet().toArray(), this.cbSourceEntity, false);
            this.cbSourceEntity.setSelectedItem(this.oldSource);
            this.cbSourceEntity.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RelationPropertiesDialogEx.this.cbSourceEntitySynonym.removeAllItems();
                    RelationPropertiesDialogEx.this.fillSourceSynonymComboBox();
                }
            });
            this.fillComboItems(this.getDesignObject().getDesign().getLogicalDesign().getEntitySet().toArray(), this.cbTargetEntity, false);
            this.cbTargetEntity.setSelectedItem(this.oldTarget);
            this.cbTargetEntity.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RelationPropertiesDialogEx.this.cbTargetEntitySynonym.removeAllItems();
                    RelationPropertiesDialogEx.this.fillTargetSynonymComboBox();
                }
            });
            DesignPartView dpv = this.getAppView().getCurrentDPV();
            if (this.relation.getSourceEntity().getDesignPart() != dpv.getDesignPart()) {
                dpv = this.relation.getSourceEntity().getDesignPart().getMainView();
            }
            this.fillSourceSynonymComboBox();
            dpv = this.getAppView().getCurrentDPV();
            if (this.relation.getTargetEntity().getDesignPart() != dpv.getDesignPart()) {
                dpv = this.relation.getTargetEntity().getDesignPart().getMainView();
            }
            this.fillTargetSynonymComboBox();
            this.fillComboItems(this.relation.initDominatRole(), this.cbDominantRole, false);
            if (this.relation.getDominantRole() != null) {
                this.cbDominantRole.setSelectedItem(this.relation.getDominantRole());
            } else {
                this.cbDominantRole.setSelectedItem(this.noneEntity);
            }
            this.cbDominantRole.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RelationPropertiesDialogEx.this.relation.setDominantRole((Entity)RelationPropertiesDialogEx.this.cbDominantRole.getSelectedItem());
                    RelationPropertiesDialogEx.this.setIdentifyingVisible(RelationPropertiesDialogEx.this.isIdentifyingVisible());
                    RelationPropertiesDialogEx.this.enableOptionality();
                }
            });
            this.chIdentifying.setSelected(this.relation.isIdentifying());
            this.chIdentifying.setEnabled(this.isIdentifyingVisible());
            this.chIdentifying.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RelationPropertiesDialogEx.this.enableOptionality();
                }
            });
            this.chInArc.setSelected(this.relation.getArc() != null);
            if (this.relation.getArc() != null) {
                this.chInArc.setText(this.relation.getArc().getName());
            }
            this.chUseSurrogateKey.setSelected(this.relation.isUseSurrogateKey());
            this.fillComboItems(this.oldSource.getKeys(), this.cbSourcePK, true);
            this.fillComboItems(this.oldTarget.getKeys(), this.cbTargetPK, true);
            if (!this.relation.isUseSurrogateKey()) {
                this.cbSourcePK.setSelectedItem(this.relation.getSourcePk());
                this.cbTargetPK.setSelectedItem(this.relation.getTargetPk());
            }
            this.chSourceTransferable.setSelected(this.relation.isSourceTransferable());
            this.chTargetTransferable.setSelected(this.relation.isTargetTransferable());
            this.enableOptionality();
            this.setDomainRoleVisible(this.isDominantRoleVisible());
            this.fillComboItems(FKIndexAssociation.DELETE_RULES, this.cbDeleteRule, false);
            this.cbDeleteRule.setSelectedItem(this.relation.getDeleteRule());
            this.initAttributes();
            this.initMeasurements();
            this.initChangeRequests();
            this.initResponsibleParties();
            this.initDocuments();
            this.initDynamicProperties();
        }
    }

    @Override
    protected void setProperties() {
        Relation rel;
        if (this.selectedAttribute != null) {
            this.initSelectedAttributeOptions(this.selectedAttribute, true);
        }
        this.setPreviousSelectedAttribute();
        boolean identifying = this.chIdentifying.isSelected();
        if (identifying) {
            Relation.Cardinality cbSourceCardinalityVal = (Relation.Cardinality)this.cbSourceCardinality.getSelectedItem();
            Relation.Cardinality cbTargetCardinalityVal = (Relation.Cardinality)this.cbTargetCardinality.getSelectedItem();
            Entity entpk = null;
            Entity entfk = null;
            if (cbSourceCardinalityVal.getValue() == 0) {
                entfk = (Entity)this.cbSourceEntity.getSelectedItem();
                entpk = (Entity)this.cbTargetEntity.getSelectedItem();
            } else if (cbTargetCardinalityVal.getValue() == 0) {
                entfk = (Entity)this.cbTargetEntity.getSelectedItem();
                entpk = (Entity)this.cbSourceEntity.getSelectedItem();
            } else {
                entpk = (Entity)this.cbDominantRole.getSelectedItem();
                if (entpk == (entfk = (Entity)this.cbTargetEntity.getSelectedItem())) {
                    entfk = (Entity)this.cbSourceEntity.getSelectedItem();
                }
            }
            if (entfk == entpk) {
                String message = Messages.getString("RelationPropertiesDialogEx.RecursiveRelationship");
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), message, Messages.getString("RelationPropertiesDialogEx.RelationChange"), 2);
                this.chIdentifying.setSelected(false);
                this.chTargetOptional.setEnabled(true);
                this.chSourceOptional.setEnabled(true);
            } else {
                boolean hasPath = entpk.hasRelPathTo(entfk);
                if (hasPath) {
                    String message = Messages.getString("RelationPropertiesDialogEx.CiclicReferenceCreated");
                    JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), message, Messages.getString("RelationPropertiesDialogEx.RelationChange"), 2);
                    this.chIdentifying.setSelected(false);
                    this.chTargetOptional.setEnabled(true);
                    this.chSourceOptional.setEnabled(true);
                }
            }
        }
        if (!this.oldSource.equals(this.cbSourceEntity.getSelectedItem()) || !this.oldTarget.equals(this.cbTargetEntity.getSelectedItem())) {
            rel = this.createRelation((TVEntity)this.cbSourceEntitySynonym.getSelectedItem(), (TVEntity)this.cbTargetEntitySynonym.getSelectedItem(), this.relation);
            this.oldSource = rel.getSourceEntity();
            this.oldTarget = rel.getTargetEntity();
            this.setDesignObject(rel);
            this.relation.copy(rel);
            this.relation = rel;
            this.relation.setSourceCardinality(this.relation.getSourceCardinality());
        } else {
            rel = this.relation;
        }
        try {
            int i;
            rel.setName(this.tfName.getText());
            rel.setComment(this.taComments.getText());
            rel.setCommentInRDBMS(this.taCommentsInRDBMS.getText());
            rel.setNotes(this.taNotes.getText());
            rel.setNameOnSource(this.tfNameOnSource.getText());
            rel.setUseSurrogateKey(this.chUseSurrogateKey.isSelected());
            rel.setFireCardinalityChange(false);
            rel.setSourceTransferable(this.chSourceTransferable.isSelected());
            rel.setTargetTransferable(this.chTargetTransferable.isSelected());
            rel.setSourcePk((CandidateKey)this.cbSourcePK.getSelectedItem());
            rel.setTargetPk((CandidateKey)this.cbTargetPK.getSelectedItem());
            rel.setOptionalSource(this.chSourceOptional.isSelected());
            rel.setSourceCardinality(this.cbSourceCardinality.getSelectedItem());
            rel.setNameOnTarget(this.tfNameOnTarget.getText());
            rel.setOptionalTarget(this.chTargetOptional.isSelected());
            if (this.cbDominantRole.getSelectedItem().equals(this.noneEntity)) {
                this.relation.setDominantRole(null);
            } else {
                this.relation.setDominantRole((Entity)this.cbDominantRole.getSelectedItem());
            }
            rel.setIdentifying(this.chIdentifying.isSelected());
            rel.setDeleteRule((String)this.cbDeleteRule.getSelectedItem());
            rel.setFireCardinalityChange(true);
            rel.setTargetCardinality(this.cbTargetCardinality.getSelectedItem());
            rel.setSourceTV((TVEntity)this.cbSourceEntitySynonym.getSelectedItem());
            rel.setTargetTV((TVEntity)this.cbTargetEntitySynonym.getSelectedItem());
            this.setEngineering();
            this.setMeasurements();
            this.setChangeRequests();
            this.setResponsibleParties();
            this.setDocuments();
            Object[] attributesSet = this.attributesList.toArray();
            Attribute[] atts = (Attribute[])this.entity.getElements();
            for (i = 0; i < atts.length; ++i) {
                Attribute att = atts[i];
                if (this.attributesList.contains(att)) continue;
                att.remove();
            }
            for (i = 0; i < attributesSet.length; ++i) {
                Attribute attribute = (Attribute)attributesSet[i];
                if (!this.entity.getAttributeSet().contains(attribute)) {
                    this.entity.getAttributeSet().add(attribute);
                    this.entity.add(attribute);
                }
                attribute.moveToIndex(i);
            }
            for (TVRelation tv : rel.getAllTVRelations()) {
                tv.resetEdgeParams();
                tv.displayLabels();
            }
        }
        catch (Exception e) {
            LOGGER.error("Error setting Relation's properties!", e);
        }
        RelationPropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.relation.clearProperties();
        for (DynamicProperty dp : this.dynamicPropertiesList) {
            this.relation.setProperty(dp.getName(), dp.getValue());
        }
    }

    @Override
    protected void initTree(DefaultMutableTreeNode root) {
        this.addToTree(root, this.getCardinalityPanel());
        this.addToTree(root, this.getAttributesPanel());
        this.addToTree(root, this.getEngineeringPanel());
        this.addToTree(root, this.getCommentsPanel());
        this.addToTree(root, this.getCommentsInRDBMSPanel());
        this.addToTree(root, this.getNotesPanel());
        this.addToTree(root, this.getFKAttributesPanel());
        this.addToTree(root, this.getImpactAnalysisPanel());
        this.addToTree(root, this.getMeasurementsPanel());
        this.addToTree(root, this.getChangeRequestsPanel());
        this.addToTree(root, this.getResPartiesPanel());
        this.addToTree(root, this.getDocumentsPanel());
        this.addToTree(root, this.getDynamicPropertiesPanel());
        this.addToTree(root, this.getSummaryPanel());
        this.getTree().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                String newSelectedTabName;
                if (e.getOldLeadSelectionPath() != null && (newSelectedTabName = ((JPanel)((DefaultMutableTreeNode)e.getNewLeadSelectionPath().getLastPathComponent()).getUserObject()).getName()).equals(ATTRIBUTES_TAB_NAME)) {
                    RelationPropertiesDialogEx.this.initAttributes();
                }
            }
        });
    }

    @Override
    protected String getHelpIndex() {
        return "RELATION_PROPERTIES_DIALOG";
    }

    protected JPanel getCardinalityPanel() {
        if (this.pnCardinality == null) {
            this.pnCardinality = this.createPage(Messages.getString("RelationPropertiesDialogEx.General"));
            JPanel mainPanel = new JPanel(new BorderLayout());
            JPanel northPanel = new JPanel(new GridLayout(2, 1, 10, 10));
            JLabel lbName = new JLabel(LB_NAME);
            lbName.setPreferredSize(this.getDefaultSize());
            this.tfName = new JTextField();
            this.tfName.setPreferredSize(this.getDefaultSize());
            this.tfName.setEnabled(this.isEditable());
            JPanel r1 = new JPanel(new BorderLayout());
            r1.add((Component)lbName, "West");
            r1.add((Component)this.tfName, "Center");
            northPanel.add(r1);
            JLabel lbSurrogateKey = new JLabel(Messages.getString("RelationPropertiesDialogEx.UseSurrogateKeys"));
            lbSurrogateKey.setPreferredSize(this.getDefaultSize());
            this.chUseSurrogateKey = new JCheckBox();
            this.chUseSurrogateKey.setPreferredSize(this.getDefaultSize());
            JPanel r5 = new JPanel(new BorderLayout());
            r5.add((Component)lbSurrogateKey, "West");
            r5.add((Component)this.chUseSurrogateKey, "Center");
            northPanel.add(r5);
            JPanel southPanel = new JPanel(new BorderLayout());
            southPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 3, 0));
            JPanel cardinalityPanel = new JPanel(new BorderLayout());
            JPanel jpanel1 = new JPanel(new GridLayout(1, 2));
            JPanel pnLeft = new JPanel(new GridLayout(0, 1, 10, 10));
            pnLeft.setBorder(BorderFactory.createTitledBorder(Messages.getString("RelationPropertiesDialogEx.SourceCardinality")));
            JPanel pnRight = new JPanel(new GridLayout(0, 1, 10, 10));
            pnRight.setBorder(BorderFactory.createTitledBorder(Messages.getString("RelationPropertiesDialogEx.TargetCardinality")));
            this.initLeftPanel(pnLeft);
            this.initRightPanel(pnRight);
            jpanel1.add(pnLeft);
            jpanel1.add(pnRight);
            cardinalityPanel.add((Component)jpanel1, "North");
            JPanel pnBottom = new JPanel(new BorderLayout());
            JPanel jp = new JPanel(new GridLayout(5, 2, 10, 10));
            JLabel lbDominantRole = new JLabel(LB_DOMINANT);
            lbDominantRole.setPreferredSize(this.getDefaultSize());
            this.cbDominantRole = new JComboBox();
            this.cbDominantRole.setPreferredSize(this.getDefaultSize());
            JPanel r3 = new JPanel(new BorderLayout());
            r3.add((Component)lbDominantRole, "West");
            r3.add((Component)this.cbDominantRole, "Center");
            jp.add(r3);
            jp.add(new JPanel());
            JLabel lbIdentifying = new JLabel(LB_IDENTIFYING);
            lbIdentifying.setPreferredSize(this.getDefaultSize());
            this.chIdentifying = new JCheckBox();
            this.chIdentifying.setPreferredSize(this.getDefaultSize());
            JPanel r4 = new JPanel(new BorderLayout());
            r4.add((Component)lbIdentifying, "West");
            r4.add((Component)this.chIdentifying, "Center");
            jp.add(r4);
            JLabel lbInarc = new JLabel(oracle.dbtools.crest.swingui.editor.relational.Messages.getString("ForeignKeyPropertiesDialogEx.InArc"));
            lbInarc.setPreferredSize(this.getDefaultSize());
            this.chInArc = new JCheckBox();
            this.chInArc.setPreferredSize(this.getDefaultSize());
            JPanel r9 = new JPanel(new BorderLayout());
            r9.add((Component)lbInarc, "West");
            r9.add((Component)this.chInArc, "Center");
            this.chInArc.setEnabled(false);
            jp.add(r9);
            JLabel lbDeleteRule = new JLabel(LB_DELETE_RULE);
            lbDeleteRule.setPreferredSize(this.getDefaultSize());
            this.cbDeleteRule = new JComboBox();
            this.cbDeleteRule.setPreferredSize(this.getDefaultSize());
            lbDeleteRule.setToolTipText(DELETE_RULE_TIP);
            this.cbDeleteRule.setToolTipText(DELETE_RULE_TIP);
            r3 = new JPanel(new BorderLayout());
            r3.add((Component)lbDeleteRule, "West");
            r3.add((Component)this.cbDeleteRule, "Center");
            jp.add(r3);
            jp.add(new JPanel());
            pnBottom.add(jp);
            southPanel.add((Component)cardinalityPanel, "North");
            JPanel cPanel = new JPanel(new BorderLayout());
            cPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 3, 0));
            cPanel.add((Component)pnBottom, "North");
            southPanel.add((Component)cPanel, "Center");
            mainPanel.add((Component)northPanel, "North");
            mainPanel.add((Component)southPanel, "Center");
            this.pnCardinality.add(mainPanel);
        }
        return this.pnCardinality;
    }

    private void initLeftPanel(JPanel jpanel) {
        JLabel lbSource = new JLabel(LB_SOURCE);
        lbSource.setPreferredSize(this.getDefaultSize());
        this.cbSourceEntity = new JComboBox();
        this.cbSourceEntity.setPreferredSize(this.getDefaultSize());
        this.cbSourceEntity.setEnabled(true);
        jpanel.add(this.createRow(lbSource, this.cbSourceEntity));
        JLabel lbSourcePK = new JLabel(Messages.getString("RelationPropertiesDialogEx.SourceKey"));
        lbSourcePK.setPreferredSize(this.getDefaultSize());
        this.cbSourcePK = new JComboBox();
        this.cbSourcePK.setPreferredSize(this.getDefaultSize());
        jpanel.add(this.createRow(lbSourcePK, this.cbSourcePK));
        JLabel lbNameOnSource = new JLabel(LB_NAME_ON_SOURCE);
        lbNameOnSource.setPreferredSize(this.getDefaultSize());
        this.tfNameOnSource = new JTextField();
        this.tfNameOnSource.setPreferredSize(this.getDefaultSize());
        jpanel.add(this.createRow(lbNameOnSource, this.tfNameOnSource));
        JLabel lbSourceEntitySynonym = new JLabel(LB_SOURCE_ENTITY_SYNONYM);
        lbSourceEntitySynonym.setPreferredSize(this.getDefaultSize());
        this.cbSourceEntitySynonym = new JComboBox();
        this.cbSourceEntitySynonym.setPreferredSize(this.getDefaultSize());
        jpanel.add(this.createRow(lbSourceEntitySynonym, this.cbSourceEntitySynonym));
        JLabel lbTargetCardinality = new JLabel(LB_TARGET_CARDINALITY);
        lbTargetCardinality.setPreferredSize(this.getDefaultSize());
        lbTargetCardinality.setToolTipText(Messages.getString("RelationPropertiesDialogEx.DefinesTargetSingleMultiple"));
        this.cbTargetCardinality = new JComboBox();
        this.cbTargetCardinality.setRenderer(new CardinalityComboBoxRenderer(true));
        this.cbTargetCardinality.setPreferredSize(this.getDefaultSize());
        this.cbTargetCardinality.setToolTipText(lbTargetCardinality.getToolTipText());
        jpanel.add(this.createRow(lbTargetCardinality, this.cbTargetCardinality));
        JLabel lbSourceOptional = new JLabel(LB_SOURCE_OPTIONAL);
        lbSourceOptional.setPreferredSize(this.getDefaultSize());
        lbSourceOptional.setToolTipText(Messages.getString("RelationPropertiesDialogEx.DefinesSourceOptionalMandatory"));
        this.chSourceOptional = new JCheckBox();
        this.chSourceOptional.setPreferredSize(this.getDefaultSize());
        this.chSourceOptional.setToolTipText(lbSourceOptional.getToolTipText());
        jpanel.add(this.createRow(lbSourceOptional, this.chSourceOptional));
        JLabel lbTransferable = new JLabel(Messages.getString("RelationPropertiesDialogEx.Transferable"));
        lbTransferable.setPreferredSize(this.getDefaultSize());
        lbTransferable.setToolTipText(Messages.getString("RelationPropertiesDialogEx.DefinesTargetOptionalMandatory"));
        this.chSourceTransferable = new JCheckBox();
        this.chSourceTransferable.setPreferredSize(this.getDefaultSize());
        jpanel.add(this.createRow(lbTransferable, this.chSourceTransferable));
    }

    private ActionListener setDominantRoleState() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RelationPropertiesDialogEx.this.setDomainRoleVisible(RelationPropertiesDialogEx.this.isDominantRoleVisible());
                RelationPropertiesDialogEx.this.setIdentifyingVisible(RelationPropertiesDialogEx.this.isIdentifyingVisible());
                RelationPropertiesDialogEx.this.enableOptionality();
            }
        };
    }

    public boolean isDominantRoleVisible() {
        Relation.Cardinality cbTargetCardinalityVal;
        Relation.Cardinality cbSourceCardinalityVal = (Relation.Cardinality)this.cbSourceCardinality.getSelectedItem();
        if (cbSourceCardinalityVal.equals(cbTargetCardinalityVal = (Relation.Cardinality)this.cbTargetCardinality.getSelectedItem()) && cbSourceCardinalityVal.getValue() != 0) {
            Object tobj;
            Object sobj = this.cbSourceEntity.getSelectedItem();
            return sobj != (tobj = this.cbTargetEntity.getSelectedItem());
        }
        return false;
    }

    public void setDomainRoleVisible(boolean isDominantRoleVisible) {
        this.cbDominantRole.setEnabled(isDominantRoleVisible);
    }

    private boolean isIdentifyingVisible() {
        boolean target_opt;
        boolean sourse_opt;
        Relation.Cardinality cbTargetCardinalityVal;
        Relation.Cardinality cbSourceCardinalityVal = (Relation.Cardinality)this.cbSourceCardinality.getSelectedItem();
        if (!cbSourceCardinalityVal.equals(cbTargetCardinalityVal = (Relation.Cardinality)this.cbTargetCardinality.getSelectedItem()) || cbSourceCardinalityVal.equals(cbTargetCardinalityVal) && cbSourceCardinalityVal.getValue() != 0 && !this.cbDominantRole.getSelectedItem().equals(this.noneEntity) && this.isDominantRoleVisible()) {
            return true;
        }
        if (cbSourceCardinalityVal.getValue() == 1 && cbTargetCardinalityVal.getValue() == 1 && (sourse_opt = this.chSourceOptional.isSelected()) != (target_opt = this.chTargetOptional.isSelected())) {
            return true;
        }
        this.chIdentifying.setSelected(false);
        return false;
    }

    private void setIdentifyingVisible(boolean isIdentifying) {
        this.chIdentifying.setEnabled(isIdentifying);
    }

    private void initRightPanel(JPanel jpanel) {
        JLabel lbTarget = new JLabel(LB_TARGET);
        lbTarget.setPreferredSize(this.getDefaultSize());
        this.cbTargetEntity = new JComboBox();
        this.cbTargetEntity.setPreferredSize(this.getDefaultSize());
        this.cbTargetEntity.setEnabled(true);
        jpanel.add(this.createRow(lbTarget, this.cbTargetEntity));
        JLabel lbTargetPK = new JLabel(Messages.getString("RelationPropertiesDialogEx.TargetKey"));
        lbTargetPK.setPreferredSize(this.getDefaultSize());
        this.cbTargetPK = new JComboBox();
        this.cbTargetPK.setPreferredSize(this.getDefaultSize());
        jpanel.add(this.createRow(lbTargetPK, this.cbTargetPK));
        JLabel lbNameOnTarget = new JLabel(LB_NAME_ON_TARGET);
        lbNameOnTarget.setPreferredSize(this.getDefaultSize());
        this.tfNameOnTarget = new JTextField();
        this.tfNameOnTarget.setPreferredSize(this.getDefaultSize());
        jpanel.add(this.createRow(lbNameOnTarget, this.tfNameOnTarget));
        JLabel lbTargetEntitySynonym = new JLabel(LB_TARGET_ENTITY_SYNONYM);
        lbTargetEntitySynonym.setPreferredSize(this.getDefaultSize());
        this.cbTargetEntitySynonym = new JComboBox();
        this.cbTargetEntitySynonym.setPreferredSize(this.getDefaultSize());
        jpanel.add(this.createRow(lbTargetEntitySynonym, this.cbTargetEntitySynonym));
        JLabel lbSourceCardinality = new JLabel(LB_SOURCE_CARDINALITY);
        lbSourceCardinality.setPreferredSize(this.getDefaultSize());
        lbSourceCardinality.setToolTipText(Messages.getString("RelationPropertiesDialogEx.DefinesSourceSingleMultiple"));
        this.cbSourceCardinality = new JComboBox();
        this.cbSourceCardinality.setRenderer(new CardinalityComboBoxRenderer(false));
        this.cbSourceCardinality.setPreferredSize(this.getDefaultSize());
        this.cbSourceCardinality.setToolTipText(lbSourceCardinality.getToolTipText());
        jpanel.add(this.createRow(lbSourceCardinality, this.cbSourceCardinality));
        JLabel lbTargetOptional = new JLabel(LB_TARGET_OPTIONAL);
        lbTargetOptional.setPreferredSize(this.getDefaultSize());
        lbTargetOptional.setToolTipText(Messages.getString("RelationPropertiesDialogEx.DefinesTargetOptionalMandatory"));
        this.chTargetOptional = new JCheckBox();
        this.chTargetOptional.setPreferredSize(this.getDefaultSize());
        this.chTargetOptional.setToolTipText(lbTargetOptional.getToolTipText());
        jpanel.add(this.createRow(lbTargetOptional, this.chTargetOptional));
        JLabel lbTransferable = new JLabel(Messages.getString("RelationPropertiesDialogEx.Transferable"));
        lbTransferable.setPreferredSize(this.getDefaultSize());
        lbTransferable.setToolTipText(Messages.getString("RelationPropertiesDialogEx.DefinesTargetOptionalMandatory"));
        this.chTargetTransferable = new JCheckBox();
        this.chTargetTransferable.setPreferredSize(this.getDefaultSize());
        jpanel.add(this.createRow(lbTransferable, this.chTargetTransferable));
    }

    private void enableOptionality() {
        boolean selected = this.chIdentifying.isSelected();
        if (!selected) {
            this.chTargetOptional.setEnabled(true);
            this.chSourceOptional.setEnabled(true);
        } else {
            Relation.Cardinality tCard;
            Relation.Cardinality sCard = (Relation.Cardinality)this.cbSourceCardinality.getSelectedItem();
            if (!sCard.equals(tCard = (Relation.Cardinality)this.cbTargetCardinality.getSelectedItem())) {
                if (sCard.getValue() == 0) {
                    this.chSourceOptional.setEnabled(false);
                    this.chSourceOptional.setSelected(false);
                } else {
                    this.chTargetOptional.setEnabled(false);
                    this.chTargetOptional.setSelected(false);
                }
            } else {
                Entity ent = (Entity)this.cbDominantRole.getSelectedItem();
                if (ent == this.relation.getTargetEntity()) {
                    this.chSourceOptional.setEnabled(false);
                    this.chSourceOptional.setSelected(false);
                    this.chTargetOptional.setEnabled(true);
                } else {
                    this.chTargetOptional.setEnabled(false);
                    this.chTargetOptional.setSelected(false);
                    this.chSourceOptional.setEnabled(true);
                }
            }
        }
    }

    private Relation createRelation(TVEntity sourceEntity, TVEntity targetEntity, Relation newRel) {
        newRel.setSourceEntity((Entity)sourceEntity.getModel());
        newRel.setTargetEntity((Entity)targetEntity.getModel());
        newRel.setSourceTV(sourceEntity);
        newRel.setTargetTV(targetEntity);
        newRel.addToAllDPVs();
        ((TVRelation)newRel.getTopView()).addConnection();
        return newRel;
    }

    private void fillSourceSynonymComboBox() {
        DesignPartView sourceDPV = this.getAppView().getCurrentDPV();
        Entity source = (Entity)this.cbSourceEntity.getSelectedItem();
        ArrayList allSourceSynonyms = new ArrayList();
        if (source.getViewsForDPV(sourceDPV) != null) {
            allSourceSynonyms.addAll(source.getViewsForDPV(sourceDPV));
            this.fillComboItems(allSourceSynonyms.toArray(), this.cbSourceEntitySynonym, false);
        }
        this.cbSourceEntitySynonym.setSelectedItem(this.relation.getSourceTV(sourceDPV));
    }

    private void fillTargetSynonymComboBox() {
        DesignPartView targetDPV = this.getAppView().getCurrentDPV();
        Entity target = (Entity)this.cbTargetEntity.getSelectedItem();
        ArrayList allTargetSynonyms = new ArrayList();
        if (target.getViewsForDPV(targetDPV) != null) {
            allTargetSynonyms.addAll(target.getViewsForDPV(targetDPV));
            this.fillComboItems(allTargetSynonyms.toArray(), this.cbTargetEntitySynonym, false);
        }
        this.cbTargetEntitySynonym.setSelectedItem(this.relation.getTargetTV(targetDPV));
    }

    private JPanel getImpactAnalysisPanel() {
        JPanel pnImpact = this.createPage(IMPACT_ANALYSIS);
        this.tree = new JTree();
        this.tree.setToggleClickCount(50);
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TreePath path;
                Object last;
                if (e.getClickCount() == 2 && (last = (path = RelationPropertiesDialogEx.this.tree.getClosestPathForLocation(e.getPoint().x, e.getPoint().y)).getLastPathComponent()) instanceof ModelIdObjectSelection) {
                    ModelIDObject obj = ((ModelIdObjectSelection)last).getObject();
                    if (obj != null) {
                        e.consume();
                        obj.showPropertyDialog();
                    } else {
                        if (RelationPropertiesDialogEx.this.tree.isCollapsed(path)) {
                            RelationPropertiesDialogEx.this.tree.expandPath(path);
                        } else {
                            RelationPropertiesDialogEx.this.tree.collapsePath(path);
                        }
                        e.consume();
                    }
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.tree);
        pnImpact.add((Component)scrollPane, "Center");
        return pnImpact;
    }

    @Override
    protected JTree initImpactAnalysisTreeModel() {
        this.tree.addTreeWillExpandListener(this);
        CompareTreeNavigationDesign treeDesign = new CompareTreeNavigationDesign(new ImpA_Relation(this.relation, null, true), false);
        ImpactTreeRenderer renderer = new ImpactTreeRenderer();
        this.tree.setModel(treeDesign);
        this.tree.setCellRenderer(renderer);
        return this.tree;
    }

    protected JPanel getFKAttributesPanel() {
        if (this.pnFKAttributes == null) {
            this.pnFKAttributes = this.createPage("FK Attributes");
            this.fkAttributesList = new ArrayList<Attribute>();
            JTable table = new JTable(new FKAttributesModel());
            table.setSelectionMode(0);
            JPanel panel = new JPanel(new BorderLayout());
            panel.add(new JScrollPane(table));
            this.pnFKAttributes.add(panel);
        }
        return this.pnFKAttributes;
    }

    private void initAttributes() {
        Entity sourceEntity;
        this.fkAttributesList.clear();
        Entity targetEntity = this.relation.getTargetEntity();
        if (targetEntity != null) {
            ContainedObject[] cobs = targetEntity.getAllElementsGeneratedBy(this.relation.getObjectID());
            for (int i = 0; i < cobs.length; ++i) {
                this.fkAttributesList.add((Attribute)cobs[i]);
            }
        }
        if ((sourceEntity = this.relation.getSourceEntity()) != null && targetEntity != sourceEntity) {
            ContainedObject[] cobs = sourceEntity.getAllElementsGeneratedBy(this.relation.getObjectID());
            for (int i = 0; i < cobs.length; ++i) {
                this.fkAttributesList.add((Attribute)cobs[i]);
            }
        }
    }

    private static void stopCellEditing(JTable table) {
        int icol = table.getEditingColumn();
        int irow = table.getEditingRow();
        if (icol > -1 && irow > -1) {
            table.getCellEditor(irow, icol).stopCellEditing();
        }
    }

    @Override
    protected void onCancel() {
        if (this.obj.showForFirstTime()) {
            try {
                this.obj.remove();
            }
            catch (Exception e) {
                LOGGER.error("Error when removing relation!", e);
            }
        }
    }

    protected JPanel getAttributesPanel() {
        if (this.pnAttributes == null) {
            this.pnAttributes = new JPanel(new BorderLayout());
            this.attributesList = new ArrayList();
            DataModel dataModel = new DataModel();
            this.tbAttributes = new AttributeTable(dataModel);
            this.tbAttributes.setSelectionMode(1);
            TableColumn column = this.tbAttributes.getColumnModel().getColumn(0);
            column.setPreferredWidth(30);
            column.setMaxWidth(50);
            column.setMinWidth(25);
            column = this.tbAttributes.getColumnModel().getColumn(1);
            column.setPreferredWidth(295);
            column = this.tbAttributes.getColumnModel().getColumn(2);
            column.setCellRenderer(new DataTypeCellRenderer());
            column.setPreferredWidth(275);
            column = this.tbAttributes.getColumnModel().getColumn(3);
            column.setMaxWidth(30);
            column.setMinWidth(30);
            column.setCellRenderer(new StatusCellRenderer());
            column = this.tbAttributes.getColumnModel().getColumn(4);
            column.setPreferredWidth(170);
            column = this.tbAttributes.getColumnModel().getColumn(5);
            column.setPreferredWidth(220);
            column = this.tbAttributes.getColumnModel().getColumn(6);
            column.setPreferredWidth(170);
            JScrollPane scrollpane = new JScrollPane(this.tbAttributes);
            JPanel columnsPanel = new JPanel(new BorderLayout());
            columnsPanel.add(scrollpane);
            this.pnAttributes.add(columnsPanel);
        }
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab(Messages.getString("EntityPropertiesDialogEx.Details"), this.createExtendedAttributePanel());
        tabbedPane.addTab(Messages.getString("EntityPropertiesDialogEx.Overview"), this.pnAttributes);
        JPanel jpanel = this.createPage(ATTRIBUTES_TAB_NAME);
        jpanel.add(tabbedPane);
        tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                RelationPropertiesDialogEx.this.setPreviousSelectedAttribute();
            }
        });
        return jpanel;
    }

    private JPanel createExtendedAttributePanel() {
        JPanel jpanel = new JPanel(new BorderLayout());
        this.coTable = new JTable(new AttributeModel());
        this.coTable.setSelectionMode(2);
        TableColumn column = this.coTable.getColumnModel().getColumn(0);
        column.setPreferredWidth(30);
        column.setMaxWidth(50);
        column.setMinWidth(25);
        this.coTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Attribute col;
                int row;
                if (e.getClickCount() == 1) {
                    RelationPropertiesDialogEx.this.setAttributeSelected();
                } else if (e.getClickCount() == 2 && (row = RelationPropertiesDialogEx.this.coTable.getSelectedRow()) != -1 && RelationPropertiesDialogEx.this.attributesList.size() > 0 && row < RelationPropertiesDialogEx.this.attributesList.size() && !(col = (Attribute)RelationPropertiesDialogEx.this.attributesList.get(row)).isDialogVisible()) {
                    col.showModal = true;
                    AttributePropertiesDialogEx dialog = new AttributePropertiesDialogEx((Dialog)RelationPropertiesDialogEx.this, RelationPropertiesDialogEx.this.getAppView(), col, RelationPropertiesDialogEx.this.chbUsePreferredList.isSelected());
                    dialog.initProperties(col);
                    dialog.show();
                    if (RelationPropertiesDialogEx.this.selectedAttribute != null) {
                        RelationPropertiesDialogEx.this.initSelectedAttributeOptions(RelationPropertiesDialogEx.this.selectedAttribute, false);
                    }
                }
            }
        });
        JScrollPane scrollpane = new JScrollPane(this.coTable);
        JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
        buttonGeneral.setPreferredSize(new Dimension(250, 35));
        GUIConfiguration configuration = GUIConfiguration.getInstance();
        final JButton btnProperties = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
        btnProperties.setToolTipText(BTN_PROPERTIES);
        btnProperties.addActionListener(new COPropertiesAction());
        if (this.isEditable()) {
            MoveUpDownListJTable upDown = new MoveUpDownListJTable(this.attributesList, this.coTable);
            String addTip = "<html><body>" + Messages.getString("EntityPropertiesDialogEx.AddTip1") + "<p>" + Messages.getString("EntityPropertiesDialogEx.AddTip2") + "<p>" + Messages.getString("EntityPropertiesDialogEx.AddTip3") + "</body>" + "</html>";
            this.bnCOAdd = new JButton(configuration.getIcon("ADD_ICON", this.getPreferredIconSize()));
            this.bnCOAdd.setToolTipText(addTip);
            this.bnCOAdd.addActionListener(new COAddAction());
            this.bnCORemove = new JButton(configuration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
            this.bnCORemove.setToolTipText(BTN_REMOVE);
            this.bnCORemove.addActionListener(new CORemoveAction());
            this.bnCOUp = new JButton(configuration.getIcon("MOVE_UP_ICON", this.getPreferredIconSize()));
            this.bnCOUp.setToolTipText(BTN_MOVE_UP);
            this.bnCOUp.addActionListener(new MoveUpDownListJTable.MoveUpAction(upDown));
            this.bnCODown = new JButton(configuration.getIcon("MOVE_DOWN_ICON", this.getPreferredIconSize()));
            this.bnCODown.setToolTipText(BTN_MOVE_DOWN);
            this.bnCODown.addActionListener(new MoveUpDownListJTable.MoveDownAction(upDown));
            this.bnCOCopy = new JButton(configuration.getIcon("COPY_ICON", this.getPreferredIconSize()));
            this.bnCOCopy.setToolTipText(Messages.getString("EntityPropertiesDialogEx.CopyAttributes"));
            this.bnCOCopy.addActionListener(new COCopyAction());
            this.bnCOPaste = new JButton(configuration.getIcon("PASTE_ICON", this.getPreferredIconSize()));
            this.bnCOPaste.setToolTipText(Messages.getString("EntityPropertiesDialogEx.PasteAttributes"));
            this.bnCOPaste.addActionListener(new COPasteAction());
            this.coTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (RelationPropertiesDialogEx.this.attributesList.isEmpty()) {
                        RelationPropertiesDialogEx.this.bnCORemove.setEnabled(false);
                        btnProperties.setEnabled(false);
                        RelationPropertiesDialogEx.this.bnCOUp.setEnabled(false);
                        RelationPropertiesDialogEx.this.bnCODown.setEnabled(false);
                    } else {
                        RelationPropertiesDialogEx.this.bnCORemove.setEnabled(true);
                        RelationPropertiesDialogEx.this.bnCOUp.setEnabled(true);
                        RelationPropertiesDialogEx.this.bnCODown.setEnabled(true);
                        btnProperties.setEnabled(true);
                        RelationPropertiesDialogEx.this.setAttributeSelected();
                    }
                }
            });
            this.coTable.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (RelationPropertiesDialogEx.this.attributesList.isEmpty()) {
                        RelationPropertiesDialogEx.this.bnCORemove.setEnabled(false);
                        btnProperties.setEnabled(false);
                        RelationPropertiesDialogEx.this.bnCOUp.setEnabled(false);
                        RelationPropertiesDialogEx.this.bnCODown.setEnabled(false);
                    } else {
                        RelationPropertiesDialogEx.this.bnCORemove.setEnabled(true);
                        RelationPropertiesDialogEx.this.bnCOUp.setEnabled(true);
                        RelationPropertiesDialogEx.this.bnCODown.setEnabled(true);
                        btnProperties.setEnabled(true);
                    }
                }
            });
            ListSelectionModel rowSM = this.coTable.getSelectionModel();
            rowSM.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        RelationPropertiesDialogEx.this.bnCORemove.setEnabled(true);
                        btnProperties.setEnabled(true);
                    } else {
                        RelationPropertiesDialogEx.this.bnCORemove.setEnabled(false);
                        RelationPropertiesDialogEx.this.bnCOUp.setEnabled(false);
                        RelationPropertiesDialogEx.this.bnCODown.setEnabled(false);
                    }
                }
            });
        }
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.add(btnProperties);
        if (this.isEditable()) {
            toolBar.addSeparator();
            toolBar.add(this.bnCOAdd);
            toolBar.add(this.bnCORemove);
            toolBar.add(this.bnCOUp);
            toolBar.add(this.bnCODown);
            toolBar.addSeparator();
            toolBar.add(this.bnCOCopy);
            toolBar.add(this.bnCOPaste);
        }
        buttonGeneral.add(toolBar);
        JPanel columnsPanel = new JPanel(new BorderLayout());
        columnsPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("EntityPropertiesDialogEx.AttributesL")));
        columnsPanel.add((Component)buttonGeneral, "North");
        columnsPanel.add(scrollpane);
        jpanel.add((Component)columnsPanel, "Center");
        this.coTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    RelationPropertiesDialogEx.this.deleteAttribute(RelationPropertiesDialogEx.this.coTable);
                }
            }
        });
        JPanel pnOptions = new JPanel(new BorderLayout());
        pnOptions.setBorder(BorderFactory.createTitledBorder(Messages.getString("EntityPropertiesDialogEx.AttributeProperties")));
        JPanel pnGrid = new JPanel(new BorderLayout());
        Dimension dim = new Dimension(60, 20);
        Dimension dimL = new Dimension(120, 20);
        JLabel lbColumnName = new JLabel(LB_NAME);
        lbColumnName.setPreferredSize(dimL);
        this.tfColumnName = new JTextField();
        this.tfColumnName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 38) {
                    RelationPropertiesDialogEx.this.moveUp();
                } else if (e.getKeyCode() == 40) {
                    RelationPropertiesDialogEx.this.moveDown();
                }
            }
        });
        Dimension dim1 = new Dimension(200, 20);
        Dimension dim2 = new Dimension(260, 20);
        this.tfColumnName.setPreferredSize(dim2);
        JPanel pnSize = new JPanel(new BorderLayout());
        pnSize.add((Component)this.createRow(lbColumnName, this.tfColumnName), "North");
        pnSize.add((Component)new JPanel(), "Center");
        pnGrid.add((Component)pnSize, "North");
        RBActionListener rbAL = new RBActionListener();
        this.rbDomain = new JRadioButton(LB_DOMAIN);
        this.rbLogical = new JRadioButton(Messages.getString("EntityPropertiesDialogEx.Logical"));
        this.rbDistinct = new JRadioButton(Messages.getString("EntityPropertiesDialogEx.Distinct"));
        this.rbStructured = new JRadioButton(Messages.getString("EntityPropertiesDialogEx.Structured"));
        this.rbCollection = new JRadioButton(Messages.getString("EntityPropertiesDialogEx.Collection"));
        this.rbDomain.addActionListener(rbAL);
        this.rbLogical.addActionListener(rbAL);
        this.rbDistinct.addActionListener(rbAL);
        this.rbStructured.addActionListener(rbAL);
        this.rbCollection.addActionListener(rbAL);
        this.group = new ButtonGroup();
        this.group.add(this.rbDomain);
        this.group.add(this.rbLogical);
        this.group.add(this.rbDistinct);
        this.group.add(this.rbStructured);
        this.group.add(this.rbCollection);
        JPanel pnRadioGroup1 = new JPanel(new GridLayout(1, 0));
        pnRadioGroup1.add(this.rbDomain);
        pnRadioGroup1.add(this.rbLogical);
        pnRadioGroup1.add(this.rbDistinct);
        JPanel pnRadioGroup2 = new JPanel(new GridLayout(1, 0));
        pnRadioGroup2.add(this.rbStructured);
        pnRadioGroup2.add(this.rbCollection);
        pnRadioGroup2.add(new JPanel());
        JLabel lbDatatype = new JLabel(LB_DATATYPE);
        lbDatatype.setPreferredSize(dimL);
        JPanel pnDTGrid = new JPanel(new GridLayout(0, 1));
        JLabel lbEmpty = new JLabel();
        lbEmpty.setPreferredSize(dimL);
        pnDTGrid.add(this.createRow(lbDatatype, pnRadioGroup1));
        pnDTGrid.add(this.createRow(lbEmpty, pnRadioGroup2));
        pnGrid.add((Component)pnDTGrid, "Center");
        JPanel pnDT = new JPanel(new BorderLayout(0, 10));
        JPanel pnKey = new JPanel(new BorderLayout());
        pnKey.add((Component)pnDT, "Center");
        pnGrid.add((Component)pnKey, "South");
        JLabel lbType = new JLabel(LB_TYPE);
        lbType.setPreferredSize(dimL);
        this.cbDatatype = new JComboBox();
        this.cbDatatype.setPreferredSize(dim1);
        this.cbDatatype.setMaximumRowCount(20);
        this.cbDatatypeActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean canBeUsedForPK = true;
                if (RelationPropertiesDialogEx.this.rbLogical.isSelected()) {
                    RelationPropertiesDialogEx.this.updateLogicalDatatypeOptions();
                    LogicalDatatype sel = (LogicalDatatype)RelationPropertiesDialogEx.this.cbDatatype.getSelectedItem();
                    if (sel != null) {
                        String selectedDataTypeName = sel.getName();
                        Design design = RelationPropertiesDialogEx.this.getDesignObject().getDesign();
                        LogicalDatatype logicaldatatype = (LogicalDatatype)design.getLogicalDatatypeSet().getByName(selectedDataTypeName);
                        MDDataType translatedDataType = logicaldatatype.createDataType(design.getSelectedRDBMSType().getName(), new HashMap());
                        String translatedDataTypeName = translatedDataType.getName();
                        canBeUsedForPK = LogicalDatatype.canBeUsedForPK(translatedDataTypeName);
                    }
                } else if (RelationPropertiesDialogEx.this.rbStructured.isSelected() && RelationPropertiesDialogEx.this.selectedAttribute != null && !RelationPropertiesDialogEx.this.selectedAttribute.isOid() || RelationPropertiesDialogEx.this.rbCollection.isSelected()) {
                    canBeUsedForPK = false;
                }
                if (!canBeUsedForPK) {
                    // empty if block
                }
            }
        };
        this.cbDatatype.addActionListener(this.cbDatatypeActionListener);
        JLabel lbPreferred = new JLabel(Messages.getString("EntityPropertiesDialogEx.Preferred"));
        lbPreferred.setHorizontalAlignment(0);
        lbPreferred.setPreferredSize(new Dimension(lbPreferred.getPreferredSize().width + 10, lbPreferred.getPreferredSize().height));
        this.chbUsePreferredList = new JCheckBox();
        this.chbUsePreferredList.addActionListener(new UsePreferredListListener());
        pnSize = new JPanel(new BorderLayout());
        pnSize.add((Component)new JPanel(), "North");
        pnSize.add((Component)this.createRow(lbType, this.cbDatatype), "Center");
        pnSize.add((Component)this.createRow(lbPreferred, this.chbUsePreferredList), "East");
        pnDT.add((Component)pnSize, "North");
        this.pnDType = new JPanel(new BorderLayout());
        this.pnDType.setPreferredSize(new Dimension(200, 50));
        JLabel lbSize = new JLabel(' ' + LB_SIZE);
        lbSize.setHorizontalAlignment(2);
        lbSize.setPreferredSize(dimL);
        this.ifDTSize = new JTextField();
        this.ifDTSize.setPreferredSize(dim2);
        this.pnDTSize = new JPanel(new GridLayout(0, 1, 0, 10));
        this.pnDTSize.add(this.createRow(lbSize, this.ifDTSize));
        this.pnDType.add((Component)this.pnDTSize, "North");
        pnDT.add((Component)this.pnDType, "Center");
        JLabel lbUnits = new JLabel(Messages.getString("EntityPropertiesDialogEx.Units"));
        lbUnits.setHorizontalAlignment(2);
        lbUnits.setPreferredSize(dimL);
        this.cbUnits = new JComboBox<String>(LogicalDatatype.UNITS);
        this.cbUnits.setPreferredSize(new Dimension(60, 20));
        JPanel pnUnits = new JPanel(new BorderLayout());
        pnUnits.add((Component)this.createRow(lbUnits, this.cbUnits), "West");
        pnUnits.add((Component)new JPanel(), "Center");
        this.pnDTSize.add(pnUnits);
        JLabel lbPrecision = new JLabel(LB_PRECISION);
        lbPrecision.setHorizontalAlignment(2);
        lbPrecision.setPreferredSize(dimL);
        this.ifDTPrecision = new JIntegerField();
        this.ifDTPrecision.setPreferredSize(dim2);
        this.pnDTScale = new JPanel(new GridLayout(0, 1, 0, 10));
        this.pnDTScale.add(this.createRow(lbPrecision, this.ifDTPrecision));
        JLabel lbScale = new JLabel(LB_SCALE);
        lbScale.setHorizontalAlignment(2);
        lbScale.setPreferredSize(dimL);
        this.ifDTScale = new JIntegerField();
        this.ifDTScale.setPreferredSize(dim2);
        this.pnDTScale.add(this.createRow(lbScale, this.ifDTScale));
        this.pnRef = new JPanel(new GridLayout(0, 1, 0, 10));
        JLabel lbRef = new JLabel("");
        lbRef.setHorizontalAlignment(0);
        lbRef.setPreferredSize(dim);
        this.chbReference = new JCheckBox(Messages.getString("EntityPropertiesDialogEx.Reference"));
        this.ifDTSize.setPreferredSize(dim2);
        this.pnRef.add(this.createRow(lbRef, this.chbReference));
        JPanel pnKeys = new JPanel(new GridLayout(0, 1));
        pnKey.add((Component)pnKeys, "South");
        pnKeys.add(new JPanel());
        this.chbMandatory = new JCheckBox(Messages.getString("EntityPropertiesDialogEx.Mandatory"));
        this.chbMandatory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (RelationPropertiesDialogEx.this.selectedAttribute != null) {
                    RelationPropertiesDialogEx.this.selectedAttribute.setNullsAllowed(!RelationPropertiesDialogEx.this.chbMandatory.isSelected());
                }
            }
        });
        JPanel pn1 = new JPanel(new GridLayout(1, 0));
        pn1.add(this.chbMandatory);
        lbEmpty = new JLabel("");
        lbEmpty.setPreferredSize(dim);
        pnKeys.add(this.createRow(lbEmpty, pn1));
        JTabbedPane tpComments = new JTabbedPane();
        this.taColumnComments = new RSyntaxTextArea();
        this.taColumnComments.setLineWrap(true);
        this.taColumnComments.setWrapStyleWord(true);
        this.taColumnComments.setBorder(null);
        this.taColumnComments.setAntiAliasingEnabled(true);
        this.taColumnComments.setFont(this.tfName.getFont());
        this.taColumnNotes = new RSyntaxTextArea();
        this.taColumnNotes.setLineWrap(true);
        this.taColumnNotes.setWrapStyleWord(true);
        this.taColumnNotes.setBorder(null);
        this.taColumnNotes.setAntiAliasingEnabled(true);
        this.taColumnNotes.setFont(this.tfName.getFont());
        this.taColumnCommentsInRDBMS = new RSyntaxTextArea();
        this.taColumnCommentsInRDBMS.setLineWrap(true);
        this.taColumnCommentsInRDBMS.setWrapStyleWord(true);
        this.taColumnCommentsInRDBMS.setBorder(null);
        this.taColumnCommentsInRDBMS.setAntiAliasingEnabled(true);
        this.taColumnCommentsInRDBMS.setFont(this.tfName.getFont());
        tpComments.addTab(Messages.getString("EntityPropertiesDialogEx.Comments"), new JScrollPane((Component)this.taColumnComments));
        tpComments.addTab(Messages.getString("EntityPropertiesDialogEx.CommentsInRDBMS"), new JScrollPane((Component)this.taColumnCommentsInRDBMS));
        tpComments.addTab(Messages.getString("EntityPropertiesDialogEx.Notes"), new JScrollPane((Component)this.taColumnNotes));
        tpComments.setPreferredSize(new Dimension(300, 100));
        JPanel pnTop = new JPanel(new FlowLayout(0));
        pnTop.add(pnGrid);
        pnOptions.add((Component)pnTop, "North");
        pnOptions.add((Component)tpComments, "Center");
        jpanel.add((Component)pnOptions, "East");
        this.updateDTComboBox();
        return jpanel;
    }

    private void setAttributeSelected() {
        int row = this.coTable.getSelectedRow();
        if (row != -1 && this.attributesList.size() > 0 && row < this.attributesList.size()) {
            Attribute attribute = (Attribute)this.attributesList.get(row);
            this.initSelectedAttributeOptions(attribute, true);
        }
    }

    private void initSelectedAttributeOptions(Attribute attribute, boolean setPrevious) {
        if (setPrevious && this.selectedAttribute == attribute) {
            return;
        }
        if (setPrevious) {
            this.setPreviousSelectedAttribute();
        }
        this.selectedAttribute = attribute;
        if (this.isEditable()) {
            this.enableAttributeOptions(true, 3);
        } else {
            this.enableAttributeOptions(false, 3);
        }
        this.tfColumnName.setText(attribute.getName());
        short use = attribute.getUse();
        switch (use) {
            case 0: {
                this.rbDomain.setSelected(true);
                this.updateDTComboBox();
                this.cbDatatype.setSelectedItem(attribute.getDomain());
                break;
            }
            case 1: {
                this.rbLogical.setSelected(true);
                this.updateDTComboBox();
                this.cbDatatype.setSelectedItem(attribute.getLogicalDatatype());
                try {
                    if (this.isEditable()) {
                        this.cbUnits.setEnabled(true);
                    }
                    String size = attribute.getSize();
                    String[] parts_n = size.split(" ");
                    this.ifDTSize.setText(parts_n[0]);
                    if (parts_n.length == 2) {
                        this.cbUnits.setSelectedItem(parts_n[1]);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    this.ifDTPrecision.setValue(Integer.parseInt(attribute.getPrecision()) > 0 ? Integer.valueOf(Integer.parseInt(attribute.getPrecision())) : null);
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    this.ifDTScale.setValue(Integer.parseInt(attribute.getScale()) > 0 ? Integer.valueOf(Integer.parseInt(attribute.getScale())) : null);
                }
                catch (Exception e) {}
                break;
            }
            case 2: {
                this.rbDistinct.setSelected(true);
                this.updateDTComboBox();
                this.cbDatatype.setSelectedItem(attribute.getDistinctType());
                break;
            }
            case 3: {
                this.rbStructured.setSelected(true);
                this.updateDTComboBox();
                this.cbDatatype.setSelectedItem(attribute.getStructuredType());
                this.chbReference.setSelected(attribute.isReference());
                break;
            }
            case 4: {
                this.rbCollection.setSelected(true);
                this.updateDTComboBox();
                this.cbDatatype.setSelectedItem(attribute.getCollectionType());
                break;
            }
            default: {
                this.rbDomain.setSelected(true);
                this.updateDTComboBox();
                this.cbDatatype.setSelectedItem(attribute.getDomain());
            }
        }
        this.chbMandatory.setSelected(!attribute.getNullsAllowed());
        this.taColumnComments.setText(attribute.getComment());
        this.taColumnCommentsInRDBMS.setText(attribute.getCommentInRDBMS());
        this.taColumnNotes.setText(attribute.getNotes());
        this.coTable.updateUI();
        boolean keepFKNamesSync = this.getAppView().getSettings().isKeepFKNamesSynchronized();
        if (attribute.isFKAttribute() && keepFKNamesSync) {
            this.tfColumnName.setEnabled(false);
        } else {
            this.tfColumnName.selectAll();
            this.tfColumnName.requestFocus();
        }
    }

    private void setPreviousSelectedAttribute() {
        if (this.selectedAttribute != null) {
            String cName;
            int newNumber = 0;
            String colName = cName = this.tfColumnName.getText();
            while (this.attributeExists(colName) && !this.selectedAttribute.getName().equalsIgnoreCase(this.tfColumnName.getText())) {
                colName = cName.concat("_").concat(Integer.toString(++newNumber));
            }
            this.selectedAttribute.setName(colName);
            if (this.rbDomain.isSelected()) {
                Object datatype = this.cbDatatype.getSelectedItem();
                if (datatype instanceof Domain) {
                    Domain domain = (Domain)datatype;
                    this.selectedAttribute.setUse((short)0);
                    if (this.selectedAttribute.getDomain() != domain) {
                        this.selectedAttribute.setDomain(domain);
                        if (domain.getCheck() != null && !domain.getCheck().isEmpty()) {
                            this.selectedAttribute.setUseDomainConstraints(true);
                        }
                    }
                }
            } else if (this.rbLogical.isSelected()) {
                int scaleDefaultValue;
                this.selectedAttribute.setDataTypeParameter("size", "");
                this.selectedAttribute.setDataTypeParameter("precision", "");
                this.selectedAttribute.setDataTypeParameter("scale", "");
                this.selectedAttribute.setUse((short)1);
                this.selectedAttribute.setLogicalDatatype((LogicalDatatype)this.cbDatatype.getSelectedItem());
                Map defaults = ((LogicalDatatype)this.cbDatatype.getSelectedItem()).getLTDefaultValues();
                String pdf = (String)defaults.get("precision_default_value");
                int precisionDefaultValue = pdf != "" && pdf != null ? new Integer((String)defaults.get("precision_default_value")) : 0;
                String sizeDefaultValue = (String)defaults.get("size_default_value");
                String scdf = (String)defaults.get("scale_default_value");
                int n = scaleDefaultValue = scdf != "" && scdf != null ? new Integer((String)defaults.get("scale_default_value")) : 0;
                if (this.sizeEnabled) {
                    String size = this.ifDTSize.getText();
                    if (size != "" && !size.equals(sizeDefaultValue)) {
                        if (this.cbUnits.getSelectedIndex() > 0) {
                            this.selectedAttribute.setDataTypeParameter("size", String.valueOf(size) + ' ' + this.cbUnits.getSelectedItem());
                        } else {
                            this.selectedAttribute.setDataTypeParameter("size", String.valueOf(size));
                        }
                    } else {
                        this.selectedAttribute.setDataTypeParameter("size", "");
                        this.selectedAttribute.setDataTypeParameter("precision", "");
                        this.selectedAttribute.setDataTypeParameter("scale", "");
                    }
                } else if (this.precisionEnabled) {
                    this.selectedAttribute.setDataTypeParameter("size", "");
                    if (this.ifDTPrecision.getIntValue() != precisionDefaultValue || this.ifDTScale.getIntValue() != scaleDefaultValue) {
                        this.selectedAttribute.setDataTypeParameter("precision", String.valueOf(this.ifDTPrecision.getIntValue()));
                        this.selectedAttribute.setDataTypeParameter("scale", String.valueOf(this.ifDTScale.getIntValue()));
                    } else {
                        this.selectedAttribute.setDataTypeParameter("precision", "");
                        this.selectedAttribute.setDataTypeParameter("scale", "");
                    }
                }
            } else if (this.rbDistinct.isSelected()) {
                this.selectedAttribute.setUse((short)2);
                this.selectedAttribute.setDistinctType((DistinctType)this.cbDatatype.getSelectedItem());
            } else if (this.rbStructured.isSelected()) {
                this.selectedAttribute.setUse((short)3);
                this.selectedAttribute.setReference(this.chbReference.isSelected());
                this.selectedAttribute.setStructuredType((StructuredType)this.cbDatatype.getSelectedItem());
            } else if (this.rbCollection.isSelected()) {
                this.selectedAttribute.setUse((short)4);
                this.selectedAttribute.setCollectionType((CollectionType)this.cbDatatype.getSelectedItem());
            }
            this.selectedAttribute.setComment(this.taColumnComments.getText());
            this.selectedAttribute.setCommentInRDBMS(this.taColumnCommentsInRDBMS.getText());
            this.selectedAttribute.setNotes(this.taColumnNotes.getText());
            this.coTable.updateUI();
            this.tbAttributes.updateUI();
        }
    }

    private void addAttribute(ActionEvent e) {
        boolean shift = false;
        boolean ctrl = false;
        if (e != null) {
            shift = (e.getModifiers() & 1) == 1;
            ctrl = (e.getModifiers() & 2) == 2;
        }
        int irow = this.coTable.getSelectedRow();
        int rowCount = this.attributesList.size();
        Attribute attribute = new Attribute(this.entity.getDesignPart());
        attribute.setObjectID(new GUID().toString());
        attribute.setName(this.generateAttributeName());
        attribute.setDesign(this.entity.getDesign());
        attribute.setContainer(this.entity);
        attribute.setDesignObjectSet(this.entity.getAttributeSet());
        int added = rowCount;
        if (irow > -1) {
            if (shift) {
                if (rowCount == 0) {
                    this.attributesList.add(attribute);
                } else {
                    this.attributesList.add(irow, attribute);
                    added = irow;
                }
            } else if (ctrl) {
                if (rowCount == 0 || rowCount - 1 == irow) {
                    this.attributesList.add(attribute);
                } else {
                    this.attributesList.add(irow + 1, attribute);
                    added = irow + 1;
                }
            } else {
                this.attributesList.add(attribute);
            }
        } else {
            this.attributesList.add(attribute);
        }
        this.tbAttributes.updateUI();
        this.coTable.updateUI();
        this.tbAttributes.changeSelection(added, 1, false, false);
        this.coTable.changeSelection(added, 1, false, false);
        this.initSelectedAttributeOptions(attribute, true);
        Enumeration<AbstractButton> columnDefaultdataTypeGroupEnumeration = this.group.getElements();
        while (columnDefaultdataTypeGroupEnumeration.hasMoreElements()) {
            JRadioButton rb = (JRadioButton)columnDefaultdataTypeGroupEnumeration.nextElement();
            if (!rb.getText().trim().equalsIgnoreCase(this.storedColumnDefaultDatatype)) continue;
            rb.setSelected(true);
            this.updateDTComboBox();
            this.setDefaultDatatype();
        }
        this.enableAttributeOptions(true, 1);
    }

    private void setDefaultDatatype() {
        if (this.rbDomain.isSelected()) {
            this.cbDatatype.setSelectedItem(this.domainDefaultDataType);
        } else if (this.rbLogical.isSelected()) {
            this.cbDatatype.setSelectedItem(this.logicalDefaultDataType);
        }
    }

    private void coCopyAttributes() {
        this.getAppView().clearCopiedObjects();
        int[] rows = this.coTable.getSelectedRows();
        for (int i = 0; i < rows.length; ++i) {
            int ind = rows[i];
            if (ind <= -1 || ind >= this.attributesList.size()) continue;
            this.getAppView().addCopiedObject((Attribute)this.attributesList.get(ind));
        }
        this.bnCOPaste.setEnabled(this.getAppView().getCopiedObjects().size() > 0);
    }

    private void coPasteAttributes() {
        List copiedObjects = this.getAppView().getCopiedObjects();
        for (Object obj : copiedObjects) {
            if (!(obj instanceof Attribute)) continue;
            Attribute source = (Attribute)obj;
            Attribute attribute = new Attribute(this.entity.getDesignPart());
            attribute.setName(this.generatePastedAttributeName(source.getName()));
            String name = attribute.getName();
            attribute.setDesign(this.entity.getDesign());
            attribute.setContainer(this.entity);
            attribute.setDesignObjectSet(this.entity.getAttributeSet());
            this.attributesList.add(attribute);
            source.copy(attribute);
            attribute.setName(name);
        }
        if (copiedObjects.size() > 0) {
            this.coTable.updateUI();
            this.tbAttributes.updateUI();
            this.tbAttributes.changeSelection(this.attributesList.size() - 1, 1, false, false);
            this.coTable.changeSelection(this.attributesList.size() - 1, 1, false, false);
        }
    }

    private void moveUp() {
        int row = this.coTable.getSelectedRow();
        if (row > 0) {
            this.coTable.getSelectionModel().setSelectionInterval(row - 1, row - 1);
            this.setAttributeSelected();
        }
    }

    private void moveDown() {
        int row = this.coTable.getSelectedRow();
        if (row > -1) {
            if (row < this.attributesList.size() - 1) {
                this.coTable.getSelectionModel().setSelectionInterval(row + 1, row + 1);
                this.setAttributeSelected();
            } else if (!ApplicationView.IS_VIEWER && row == this.attributesList.size() - 1) {
                this.addAttribute(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDTComboBox() {
        block61: {
            block62: {
                block60: {
                    this.cbDatatype.removeAllItems();
                    this.pnDType.removeAll();
                    this.pnDType.updateUI();
                    if (!this.rbDomain.isSelected()) break block60;
                    Domain selDomain = null;
                    if (this.selectedAttribute != null) {
                        selDomain = this.selectedAttribute.getDomain();
                    }
                    if (selDomain == null) {
                        selDomain = this.getDesignObject().getDesign().getDomainSet().getDefaultDomain();
                    }
                    if (this.initialUseDomainPreferredList) {
                        this.chbUsePreferredList.setSelected(this.getAppView().getSettings().isUsePreferredDomains());
                        this.initialUseDomainPreferredList = false;
                    }
                    if (this.chbUsePreferredList.isSelected()) {
                        ArrayList<Domain> allPreferredDomains = new ArrayList<Domain>();
                        List pDomains = this.getCurrentPreferredDomains();
                        allPreferredDomains.addAll(pDomains);
                        if (pDomains.size() > 0) {
                            for (Domain domain : pDomains) {
                                if (selDomain == null) continue;
                                if (!domain.getObjectID().equalsIgnoreCase(selDomain.getObjectID())) {
                                    if (this.additionalPreferredDomains.contains(selDomain)) continue;
                                    this.additionalPreferredDomains.add(selDomain);
                                    continue;
                                }
                                if (this.additionalPreferredDomains.contains(selDomain)) {
                                    this.additionalPreferredDomains.remove(selDomain);
                                }
                                break;
                            }
                        } else if (!this.additionalPreferredDomains.contains(selDomain)) {
                            this.additionalPreferredDomains.add(selDomain);
                        }
                        allPreferredDomains.addAll(this.additionalPreferredDomains);
                        for (Object e : allPreferredDomains) {
                            this.cbDatatype.addItem(e);
                            if (this.domainDefaultDataType == null) {
                                this.domainDefaultDataType = e;
                            }
                            if (!e.toString().equalsIgnoreCase("unknown")) continue;
                            this.domainDefaultDataType = e;
                        }
                        this.cbDatatype.setSelectedItem(selDomain);
                        this.getAppView().getSettings().setUsePreferredDomains(true);
                    } else {
                        Iterator it = this.getDesignObject().getDesign().getDomainSet().iterator();
                        while (it.hasNext()) {
                            Object obj = it.next();
                            this.cbDatatype.addItem(obj);
                            if (!obj.toString().equalsIgnoreCase("unknown")) continue;
                            this.domainDefaultDataType = obj;
                        }
                        this.cbDatatype.setSelectedItem(selDomain);
                        this.getAppView().getSettings().setUsePreferredDomains(false);
                    }
                    break block61;
                }
                if (!this.rbLogical.isSelected()) break block62;
                String size = "";
                String precision = "";
                String scale = "";
                String units = "";
                try {
                    this.cbDatatype.removeActionListener(this.cbDatatypeActionListener);
                    this.selLogicalDatatype = null;
                    if (this.selectedAttribute != null) {
                        this.selLogicalDatatype = this.selectedAttribute.getLogicalDatatype();
                        size = this.selectedAttribute.getDataTypeParameter("size");
                        precision = this.selectedAttribute.getDataTypeParameter("precision");
                        scale = this.selectedAttribute.getDataTypeParameter("scale");
                        String[] stringArray = size.split(" ");
                        if (stringArray.length == 2) {
                            size = stringArray[0];
                            units = stringArray[1];
                        }
                    }
                    if (this.initialUseLogicalTypePreferredList) {
                        this.chbUsePreferredList.setSelected(this.getAppView().getSettings().isUsePreferredLogicalTypes());
                        this.initialUseLogicalTypePreferredList = false;
                    }
                    if (this.chbUsePreferredList.isSelected()) {
                        ArrayList<LogicalDatatype> arrayList = new ArrayList<LogicalDatatype>();
                        List pLogicalDatatypes = this.getCurrentPreferredLogicalDatatypes();
                        arrayList.addAll(pLogicalDatatypes);
                        if (pLogicalDatatypes.size() > 0) {
                            for (LogicalDatatype logicalDatatype : pLogicalDatatypes) {
                                if (this.selLogicalDatatype == null) continue;
                                if (!logicalDatatype.getObjectID().equalsIgnoreCase(this.selLogicalDatatype.getObjectID())) {
                                    if (this.additionalPreferredLogicalTypes.contains(this.selLogicalDatatype)) continue;
                                    this.additionalPreferredLogicalTypes.add(this.selLogicalDatatype);
                                    continue;
                                }
                                if (this.additionalPreferredLogicalTypes.contains(this.selLogicalDatatype)) {
                                    this.additionalPreferredLogicalTypes.remove(this.selLogicalDatatype);
                                }
                                break;
                            }
                        } else if (!this.additionalPreferredLogicalTypes.contains(this.selLogicalDatatype)) {
                            this.additionalPreferredLogicalTypes.add(this.selLogicalDatatype);
                        }
                        arrayList.addAll(this.additionalPreferredLogicalTypes);
                        for (Object e : arrayList) {
                            this.cbDatatype.addItem(e);
                            if (this.logicalDefaultDataType == null) {
                                this.logicalDefaultDataType = e;
                            }
                            if (!e.toString().equalsIgnoreCase("unknown")) continue;
                            this.logicalDefaultDataType = e;
                        }
                        this.getAppView().getSettings().setUsePreferredLogicalTypes(true);
                    } else {
                        Iterator iterator = this.getDesignObject().getDesign().getLogicalDatatypeSet().iterator();
                        while (iterator.hasNext()) {
                            Object obj = iterator.next();
                            this.cbDatatype.addItem(obj);
                            if (!obj.toString().equalsIgnoreCase("unknown")) continue;
                            this.logicalDefaultDataType = obj;
                        }
                        this.getAppView().getSettings().setUsePreferredLogicalTypes(false);
                    }
                    this.cbDatatype.addActionListener(this.cbDatatypeActionListener);
                    this.cbDatatype.setSelectedItem(this.selLogicalDatatype);
                }
                catch (Throwable throwable) {
                    this.cbDatatype.addActionListener(this.cbDatatypeActionListener);
                    this.cbDatatype.setSelectedItem(this.selLogicalDatatype);
                    if (this.ifDTSize.isEnabled()) {
                        try {
                            this.ifDTSize.setText(size != null && size != "" ? size : null);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    if (this.ifDTPrecision.isEnabled()) {
                        try {
                            this.ifDTPrecision.setValue((long)Integer.parseInt(precision != null && precision != "" ? precision : null));
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    if (this.ifDTScale.isEnabled()) {
                        try {
                            this.ifDTScale.setValue((long)Integer.parseInt(scale != null && scale != "" ? scale : null));
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    if (this.cbUnits.isEnabled()) {
                        this.cbUnits.setSelectedItem(units);
                    }
                    throw throwable;
                }
                if (this.ifDTSize.isEnabled()) {
                    try {
                        this.ifDTSize.setText(size != null && size != "" ? size : null);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (this.ifDTPrecision.isEnabled()) {
                    try {
                        this.ifDTPrecision.setValue((long)Integer.parseInt(precision != null && precision != "" ? precision : null));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (this.ifDTScale.isEnabled()) {
                    try {
                        this.ifDTScale.setValue((long)Integer.parseInt(scale != null && scale != "" ? scale : null));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (this.cbUnits.isEnabled()) {
                    this.cbUnits.setSelectedItem(units);
                }
                break block61;
            }
            if (this.rbDistinct.isSelected()) {
                Iterator it = this.getDesignObject().getDesign().getDataTypesDesign().getDistinctTypeSet().iterator();
                while (it.hasNext()) {
                    this.cbDatatype.addItem(it.next());
                }
            } else if (this.rbStructured.isSelected()) {
                Iterator it = this.getDesignObject().getDesign().getDataTypesDesign().getStructuredTypeSet().iterator();
                while (it.hasNext()) {
                    this.cbDatatype.addItem(it.next());
                }
                this.pnDType.add(this.pnRef);
                this.chbReference.setSelected(false);
            } else if (this.rbCollection.isSelected()) {
                Iterator it = this.getDesignObject().getDesign().getDataTypesDesign().getCollectionTypeSet().iterator();
                while (it.hasNext()) {
                    this.cbDatatype.addItem(it.next());
                }
            }
        }
        this.cbDatatype.updateUI();
    }

    private void deleteAttribute(JTable jtable) {
        int icol = jtable.getEditingColumn();
        int irow = jtable.getEditingRow();
        if (icol > -1 && irow > -1) {
            jtable.getCellEditor(irow, icol).stopCellEditing();
        }
        int[] rows = jtable.getSelectedRows();
        ArrayList<Attribute> list = new ArrayList<Attribute>();
        for (int i = rows.length - 1; i >= 0; --i) {
            Attribute attribute;
            int objectNumber = rows[i];
            if (objectNumber != -1 && this.attributesList.size() > 0 && objectNumber < this.attributesList.size() && !(attribute = (Attribute)this.attributesList.get(objectNumber)).isFKAttribute()) {
                list.add(attribute);
            }
            for (Object e : list) {
                this.attributesList.remove(e);
            }
            this.tbAttributes.clearSelection();
            this.tbAttributes.updateUI();
            this.coTable.clearSelection();
            this.coTable.updateUI();
            this.selectedAttribute = null;
            this.enableAttributeOptions(this.attributesList.size() > 0 && this.coTable.getSelectedRow() > 0, 2);
        }
    }

    private void enableAttributeOptions(boolean enabled, int operation) {
        boolean basedOnStructuredTypeTable = false;
        boolean enableBasedOnStructureType = enabled && !basedOnStructuredTypeTable;
        this.tfColumnName.setEnabled(enableBasedOnStructureType);
        this.rbDomain.setEnabled(enableBasedOnStructureType);
        this.rbLogical.setEnabled(enableBasedOnStructureType);
        if (operation == 0) {
            this.rbStructured.setEnabled(enableBasedOnStructureType);
            this.rbDistinct.setEnabled(enableBasedOnStructureType);
            this.rbCollection.setEnabled(enableBasedOnStructureType);
        } else if (operation == 1 || operation == 2 || operation == 3) {
            if (this.structuredTypesCount > 0) {
                this.rbStructured.setEnabled(enableBasedOnStructureType);
            } else {
                this.rbStructured.setEnabled(false);
            }
            if (this.distinctTypesCount > 0) {
                this.rbDistinct.setEnabled(enableBasedOnStructureType);
            } else {
                this.rbDistinct.setEnabled(false);
            }
            if (this.collectionTypesCount > 0) {
                this.rbCollection.setEnabled(enableBasedOnStructureType);
            } else {
                this.rbCollection.setEnabled(false);
            }
            if (this.rbStructured.isSelected() && !this.rbStructured.isEnabled() || this.rbDistinct.isSelected() && !this.rbDistinct.isEnabled() || this.rbCollection.isSelected() && !this.rbCollection.isEnabled()) {
                this.rbDomain.setSelected(true);
            }
        }
        this.cbDatatype.setEnabled(enableBasedOnStructureType);
        this.ifDTSize.setEnabled(enableBasedOnStructureType);
        this.cbUnits.setEnabled(enableBasedOnStructureType);
        this.ifDTPrecision.setEnabled(enableBasedOnStructureType);
        this.ifDTScale.setEnabled(enableBasedOnStructureType);
        this.chbMandatory.setEnabled(enabled);
        this.taColumnComments.setEditable(enabled);
        this.taColumnCommentsInRDBMS.setEditable(enabled);
        this.taColumnNotes.setEditable(enabled);
        this.chbReference.setEnabled(enabled);
        if (!enabled) {
            this.rbDomain.setSelected(true);
            this.updateDTComboBox();
            this.tfColumnName.setText("");
            this.ifDTSize.setText("");
            this.cbUnits.setSelectedIndex(0);
            this.ifDTPrecision.setText("");
            this.ifDTScale.setText("");
            this.taColumnComments.setText("");
            this.taColumnCommentsInRDBMS.setText("");
            this.taColumnNotes.setText("");
        }
    }

    private List getCurrentPreferredDomains() {
        this.currentPreferredDomainList.clear();
        Iterator allDesignDomainsDesignIterator = this.getDesignObject().getDesign().getDomainSet().iterator();
        while (allDesignDomainsDesignIterator.hasNext()) {
            Domain obj = (Domain)allDesignDomainsDesignIterator.next();
            PreferredDomain pd0 = new PreferredDomain();
            pd0.setObjectId(obj.getObjectID());
            List<PreferredDomain> settingsPreferreddomainsList = this.getAppView().getSettings().getPreferredDomains();
            for (PreferredDomain pd : settingsPreferreddomainsList) {
                if (!pd0.getObjectId().equalsIgnoreCase(pd.getObjectId())) continue;
                this.currentPreferredDomainList.add(obj);
            }
        }
        return this.currentPreferredDomainList;
    }

    private List getCurrentPreferredLogicalDatatypes() {
        this.currentPreferredLogicalTypeList.clear();
        Iterator allLogicalDatatypeIterator = this.getDesignObject().getDesign().getLogicalDatatypeSet().iterator();
        while (allLogicalDatatypeIterator.hasNext()) {
            LogicalDatatype ldt0 = (LogicalDatatype)allLogicalDatatypeIterator.next();
            List<LogicalDatatype> settingsPreferredLogicalDatatypeList = this.getAppView().getSettings().getPreferredLogicaltypes();
            for (LogicalDatatype ldt1 : settingsPreferredLogicalDatatypeList) {
                if (!ldt0.getObjectID().equalsIgnoreCase(ldt1.getObjectID())) continue;
                this.currentPreferredLogicalTypeList.add(ldt0);
            }
        }
        return this.currentPreferredLogicalTypeList;
    }

    private void updateLogicalDatatypeOptions() {
        this.ifDTSize.setText("");
        this.ifDTPrecision.setText("");
        this.ifDTScale.setText("");
        this.cbUnits.setSelectedIndex(0);
        this.cbUnits.setEnabled(false);
        this.pnDType.removeAll();
        this.pnDType.updateUI();
        this.sizeEnabled = false;
        this.precisionEnabled = false;
        LogicalDatatype selected = (LogicalDatatype)this.cbDatatype.getSelectedItem();
        if (selected != null) {
            Map defaults = selected.getLTDefaultValues();
            if (defaults != null) {
                this.precisionDefaultValue = (String)defaults.get("precision_default_value");
                this.sizeDefaultValue = (String)defaults.get("size_default_value");
                this.scaleDefaultValue = (String)defaults.get("scale_default_value");
            }
            Map m = selected.getToPhysical();
            MDDataType datatype = selected.createDataType(this.entity.getSelectedRDBMSType().getName(), m);
            if (datatype instanceof MDImplicitSized) {
                this.ifDTSize.setText(this.sizeDefaultValue);
                this.ifDTSize.setEnabled(false);
                this.ifDTPrecision.setText(this.precisionDefaultValue);
                this.ifDTPrecision.setEnabled(false);
                this.ifDTScale.setText(this.scaleDefaultValue);
                this.ifDTScale.setEnabled(false);
                this.pnDType.removeAll();
                this.pnDType.updateUI();
                this.sizeEnabled = false;
                this.precisionEnabled = false;
            } else if (datatype instanceof MDPackedSized) {
                this.ifDTSize.setText(this.sizeDefaultValue);
                this.ifDTSize.setEnabled(false);
                this.pnDType.removeAll();
                this.pnDType.add((Component)this.pnDTScale, "North");
                this.pnDType.updateUI();
                this.sizeEnabled = false;
                this.precisionEnabled = true;
                try {
                    if (datatype.getPrecision() != 0) {
                        this.ifDTPrecision.setText("" + datatype.getPrecision());
                    }
                    if (this.isEditable()) {
                        this.ifDTPrecision.setEnabled(true);
                        if (this.ifDTPrecision.getText().trim().length() == 0) {
                            this.ifDTPrecision.setText(this.precisionDefaultValue);
                        }
                    }
                }
                catch (Exception e) {
                    this.ifDTPrecision.setEnabled(false);
                }
                try {
                    if (datatype.getScale() != 0) {
                        this.ifDTScale.setText("" + datatype.getScale());
                    }
                    if (this.isEditable()) {
                        this.ifDTScale.setEnabled(true);
                        if (this.ifDTScale.getText().trim().length() == 0) {
                            this.ifDTScale.setText(this.scaleDefaultValue);
                        }
                    }
                }
                catch (Exception e) {
                    this.ifDTScale.setEnabled(false);
                }
            } else {
                try {
                    if (datatype.hasSize()) {
                        if (!datatype.getSize().equalsIgnoreCase("0")) {
                            if (this.isEditable()) {
                                this.cbUnits.setEnabled(true);
                            }
                            String size = datatype.getSize();
                            String[] parts_n = size.split(" ");
                            this.ifDTSize.setText(parts_n[0]);
                            if (parts_n.length == 2) {
                                this.cbUnits.setSelectedItem(parts_n[1]);
                            }
                        } else {
                            this.ifDTSize.setText(this.sizeDefaultValue);
                            if (this.isEditable()) {
                                this.cbUnits.setEnabled(true);
                            }
                        }
                        if (this.isEditable()) {
                            this.ifDTSize.setEnabled(true);
                        }
                        this.pnDType.removeAll();
                        this.pnDType.add((Component)this.pnDTSize, "North");
                        this.pnDType.updateUI();
                        this.sizeEnabled = true;
                        this.precisionEnabled = false;
                    } else {
                        this.ifDTSize.setEnabled(false);
                    }
                }
                catch (Exception e) {
                    this.ifDTSize.setEnabled(false);
                }
                try {
                    if (datatype.hasPrecision()) {
                        if (datatype.getPrecision() != 0) {
                            this.ifDTPrecision.setText("" + datatype.getPrecision());
                        }
                        if (this.isEditable()) {
                            this.ifDTPrecision.setEnabled(true);
                            if (this.ifDTPrecision.getText().trim().length() == 0) {
                                this.ifDTPrecision.setText(this.precisionDefaultValue);
                            }
                        }
                        this.pnDType.removeAll();
                        this.pnDType.add((Component)this.pnDTScale, "North");
                        this.pnDType.updateUI();
                        this.sizeEnabled = false;
                        this.precisionEnabled = true;
                    } else {
                        this.ifDTPrecision.setEnabled(false);
                    }
                }
                catch (Exception e) {
                    this.ifDTPrecision.setEnabled(false);
                }
                try {
                    if (datatype.hasScale()) {
                        if (datatype.getScale() != 0) {
                            this.ifDTScale.setText("" + datatype.getScale());
                        }
                        if (this.isEditable()) {
                            this.ifDTScale.setEnabled(true);
                            if (this.ifDTScale.getText().trim().length() == 0) {
                                this.ifDTScale.setText(this.scaleDefaultValue);
                            }
                        }
                        this.pnDType.removeAll();
                        this.pnDType.add((Component)this.pnDTScale, "North");
                        this.pnDType.updateUI();
                        this.sizeEnabled = false;
                        this.precisionEnabled = true;
                    } else {
                        this.ifDTScale.setEnabled(false);
                    }
                }
                catch (Exception e) {
                    this.ifDTScale.setEnabled(false);
                }
            }
        }
    }

    private boolean attributeExists(String name) {
        for (int i = 0; i < this.attributesList.size(); ++i) {
            Attribute attribute = (Attribute)this.attributesList.get(i);
            if (!name.equalsIgnoreCase(attribute.getName())) continue;
            return true;
        }
        return false;
    }

    protected String generateAttributeName() {
        String name = "Attribute";
        int newNumber = 0;
        int lastNumber = this.attributesList.size();
        if (lastNumber != 0) {
            newNumber = this.attrCounter = lastNumber + 1;
        } else {
            ++this.attrCounter;
            newNumber = this.attrCounter;
        }
        String attrName = name.concat("_").concat(Integer.toString(newNumber));
        while (this.attributeExists(attrName)) {
            newNumber = ++this.attrCounter;
            attrName = name.concat("_").concat(Integer.toString(newNumber));
        }
        return attrName;
    }

    protected String generatePastedAttributeName(String pastedColumnName) {
        if (!this.attributeExists(pastedColumnName)) {
            return pastedColumnName;
        }
        int newNumber = 0;
        for (Attribute col : this.attributesList) {
            String colName = col.getName();
            if (colName.indexOf(pastedColumnName) < 0) continue;
            ++newNumber;
        }
        String colName = pastedColumnName.concat("_").concat(Integer.toString(newNumber));
        while (this.attributeExists(colName)) {
            colName = pastedColumnName.concat("_").concat(Integer.toString(++newNumber));
        }
        return colName;
    }

    private class UsePreferredListListener
    implements ActionListener {
        private UsePreferredListListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RelationPropertiesDialogEx.this.setPreviousSelectedAttribute();
            RelationPropertiesDialogEx.this.updateDTComboBox();
        }
    }

    private class RBActionListener
    implements ActionListener {
        private RBActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RelationPropertiesDialogEx.this.updateDTComboBox();
            RelationPropertiesDialogEx.this.setDefaultDatatype();
        }
    }

    private class COPasteAction
    extends AbstractAction {
        private COPasteAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RelationPropertiesDialogEx.this.coPasteAttributes();
            RelationPropertiesDialogEx.this.setAttributeSelected();
        }
    }

    private class COCopyAction
    extends AbstractAction {
        private COCopyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RelationPropertiesDialogEx.this.setPreviousSelectedAttribute();
            RelationPropertiesDialogEx.this.coCopyAttributes();
        }
    }

    private class CORemoveAction
    implements ActionListener {
        private CORemoveAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RelationPropertiesDialogEx.this.deleteAttribute(RelationPropertiesDialogEx.this.coTable);
        }
    }

    private class COAddAction
    implements ActionListener {
        private COAddAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RelationPropertiesDialogEx.this.addAttribute(e);
        }
    }

    private class COPropertiesAction
    implements ActionListener {
        private COPropertiesAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = RelationPropertiesDialogEx.this.coTable.getSelectedRow();
            if (row != -1) {
                Attribute col;
                RelationPropertiesDialogEx.this.setPreviousSelectedAttribute();
                if (RelationPropertiesDialogEx.this.attributesList.size() > 0 && row < RelationPropertiesDialogEx.this.attributesList.size() && !(col = (Attribute)RelationPropertiesDialogEx.this.attributesList.get(row)).isDialogVisible()) {
                    col.showModal = true;
                    AttributePropertiesDialogEx dialog = new AttributePropertiesDialogEx((Dialog)RelationPropertiesDialogEx.this, RelationPropertiesDialogEx.this.getAppView(), col, RelationPropertiesDialogEx.this.chbUsePreferredList.isSelected());
                    dialog.initProperties(col);
                    dialog.show();
                    if (RelationPropertiesDialogEx.this.selectedAttribute != null) {
                        RelationPropertiesDialogEx.this.initSelectedAttributeOptions(RelationPropertiesDialogEx.this.selectedAttribute, false);
                    }
                }
            }
        }
    }

    public class AttributeModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return RelationPropertiesDialogEx.this.attributesList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return " ";
            }
            if (column == 1) {
                return Messages.getString("EntityPropertiesDialogEx.Name");
            }
            if (column == 2) {
                return Messages.getString("EntityPropertiesDialogEx.DataType");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int col) {
            if (col == 0) {
                return Integer.class;
            }
            if (col == 1) {
                return String.class;
            }
            if (col == 2) {
                return String.class;
            }
            return Integer.class;
        }

        @Override
        public Object getValueAt(int row, int col) {
            Attribute column = (Attribute)RelationPropertiesDialogEx.this.attributesList.get(row);
            if (col == 0) {
                return new Integer(row + 1);
            }
            if (col == 1) {
                return column.getName();
            }
            if (col == 2) {
                return column.getGenericDatatypeString();
            }
            return new Integer(row * col);
        }
    }

    class DataTypeCellRenderer
    extends JLabel
    implements TableCellRenderer {
        DataTypeCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            Attribute attribute = (Attribute)value;
            this.setOpaque(true);
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setBackground(table.getBackground());
                this.setForeground(table.getForeground());
            }
            this.setHorizontalAlignment(2);
            this.setText(attribute.getGenericDatatypeString());
            return this;
        }
    }

    class StatusCellRenderer
    extends JCheckBox
    implements TableCellRenderer {
        StatusCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            this.setOpaque(true);
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setBackground(table.getBackground());
                this.setForeground(table.getForeground());
            }
            this.setHorizontalAlignment(0);
            this.setEnabled(false);
            this.setSelected((Boolean)value);
            return this;
        }
    }

    class AttributeTable
    extends JTable {
        AttributeTable(TableModel dataModel) {
            super(dataModel);
        }

        @Override
        public String getToolTipText(MouseEvent e) {
            String tip = null;
            Point p = e.getPoint();
            int rowIndex = this.rowAtPoint(p);
            int colIndex = this.columnAtPoint(p);
            int realColumnIndex = this.convertColumnIndexToModel(colIndex);
            Attribute attribute = (Attribute)RelationPropertiesDialogEx.this.attributesList.get(rowIndex);
            if (realColumnIndex == 3) {
                TableModel model = this.getModel();
                boolean checked = (Boolean)model.getValueAt(rowIndex, 3);
                if (!checked) {
                    tip = MessageFormat.format(Messages.getString("EntityPropertiesDialogEx.Attribute"), attribute.getName());
                }
            } else if (realColumnIndex != 4) {
                tip = super.getToolTipText(e);
            }
            return tip;
        }
    }

    public class DataModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 7;
        }

        @Override
        public int getRowCount() {
            return RelationPropertiesDialogEx.this.attributesList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return " ";
            }
            if (column == 1) {
                return Messages.getString("EntityPropertiesDialogEx.Name");
            }
            if (column == 2) {
                return Messages.getString("EntityPropertiesDialogEx.DataType");
            }
            if (column == 3) {
                return "M";
            }
            if (column == 4) {
                return Messages.getString("EntityPropertiesDialogEx.Comments");
            }
            if (column == 5) {
                return Messages.getString("EntityPropertiesDialogEx.CommentsInRDBMS");
            }
            if (column == 6) {
                return Messages.getString("EntityPropertiesDialogEx.Notes");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            Attribute attribute = (Attribute)RelationPropertiesDialogEx.this.attributesList.get(row);
            if (col == 0) {
                return new Integer(row + 1);
            }
            if (col == 1) {
                return attribute.getName();
            }
            if (col == 2) {
                return attribute;
            }
            if (col == 3) {
                return !attribute.getNullsAllowed();
            }
            if (col == 4) {
                return attribute.getComment();
            }
            if (col == 5) {
                return attribute.getCommentInRDBMS();
            }
            if (col == 6) {
                return attribute.getNotes();
            }
            return new Integer(row * col);
        }
    }

    class CardinalityComboBoxRenderer
    extends JLabel
    implements ListCellRenderer {
        boolean manyOnRight;
        int ONE_ONE = 2;
        int ONE_N = 0;
        int N_ONE = 1;
        Icon[] images = new Icon[3];

        CardinalityComboBoxRenderer(boolean manyOnRight) {
            this.manyOnRight = manyOnRight;
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            this.images[this.ONE_N] = configuration.getIcon("ONE_TO_N_LINE_ICON", RelationPropertiesDialogEx.this.getPreferredIconSize());
            this.images[this.N_ONE] = configuration.getIcon("N_TO_ONE_LINE_ICON", RelationPropertiesDialogEx.this.getPreferredIconSize());
            this.images[this.ONE_ONE] = configuration.getIcon("ONE_TO_ONE_LINE_ICON", RelationPropertiesDialogEx.this.getPreferredIconSize());
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
            this.setVerticalAlignment(0);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof Relation.Cardinality) {
                Relation.Cardinality card = (Relation.Cardinality)value;
                if (isSelected) {
                    this.setBackground(list.getSelectionBackground());
                    this.setForeground(list.getSelectionForeground());
                } else {
                    this.setBackground(list.getBackground());
                    this.setForeground(list.getForeground());
                }
                Icon icon = null;
                icon = "*".equals(card.toString()) ? (this.manyOnRight ? this.images[this.ONE_N] : this.images[this.N_ONE]) : this.images[this.ONE_ONE];
                this.setIcon(icon);
                this.setText(card.toString());
            }
            return this;
        }
    }

    public class FKAttributesModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return RelationPropertiesDialogEx.this.fkAttributesList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("RelationPropertiesDialogEx.Entity");
            }
            if (column == 1) {
                return Messages.getString("RelationPropertiesDialogEx.Attribute");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col == 0) {
                return ((Attribute)RelationPropertiesDialogEx.this.fkAttributesList.get(row)).getParent();
            }
            return ((Attribute)RelationPropertiesDialogEx.this.fkAttributesList.get(row)).getName();
        }
    }
}

