/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.datatypes;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.model.datatype.MDDataType;
import oracle.dbtools.crest.model.datatype.MDImplicitSized;
import oracle.dbtools.crest.model.datatype.MDPackedSized;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.AbstractDatatypePropertiesDialog;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.datatypes.Messages;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;

public class DistinctTypePropertiesDialogEx
extends AbstractDatatypePropertiesDialog {
    private DistinctType distinctType;
    private JComboBox cbLogicalType;
    private JTextField ifSize;
    private JIntegerField ifPrecision;
    private JIntegerField ifScale;
    private TreeMap typesRDBMSSites = new TreeMap();
    private int precisionDefaultValueInt;
    private int scaleDefaultValue;
    private String sizeDefaultValue;

    public DistinctTypePropertiesDialogEx(ApplicationView view, DesignObject object) {
        super(view, object);
        this.initGeneral();
    }

    @Override
    public String getCaption() {
        return Messages.getString("DistinctTypePropertiesDialogEx.DistinctTypeProperties");
    }

    @Override
    public void initProperties(DesignObject object) {
        if (object instanceof DistinctType) {
            int scale;
            int precision;
            this.distinctType = (DistinctType)object;
            this.initDefaults();
            this.fillComboItems(this.getDesignObject().getDesign().getLogicalDatatypeSet().toArray(), this.cbLogicalType, false);
            this.cbLogicalType.setSelectedItem(this.distinctType.getLogicalDataType());
            String size = this.distinctType.getSize();
            if (size != null && !size.equals("")) {
                this.ifSize.setText(size);
            }
            if ((precision = this.distinctType.getPrecision()) >= 0) {
                this.ifPrecision.setValue((long)precision);
            }
            if ((scale = this.distinctType.getScale()) > 0) {
                this.ifScale.setValue((long)scale);
            }
            this.initType();
            this.initUsedInAttributes(this.distinctType, (short)2);
            this.initUsedInColumns();
            this.initResponsibleParties();
            this.initDocuments();
            this.initDynamicProperties();
        }
    }

    @Override
    protected void setProperties() {
        this.distinctType.setName(this.tfName.getText());
        this.distinctType.setComment(this.taComments.getText());
        this.distinctType.setCommentInRDBMS(this.taCommentsInRDBMS.getText());
        this.distinctType.setNotes(this.taNotes.getText());
        this.distinctType.setLogicalDataType((LogicalDatatype)this.cbLogicalType.getSelectedItem());
        this.distinctType.setSize(String.valueOf(this.ifSize.getText()));
        this.distinctType.setPrecision(this.ifPrecision.getIntValue());
        this.distinctType.setScale(this.ifScale.getIntValue());
        Map defaults = ((LogicalDatatype)this.cbLogicalType.getSelectedItem()).getLTDefaultValues();
        String pdf = (String)defaults.get("precision_default_value");
        this.precisionDefaultValueInt = pdf != "" && pdf != null ? new Integer((String)defaults.get("precision_default_value")) : 0;
        this.sizeDefaultValue = (String)defaults.get("size_default_value");
        String scdf = (String)defaults.get("scale_default_value");
        this.scaleDefaultValue = scdf != "" && scdf != null ? new Integer((String)defaults.get("scale_default_value")) : 0;
        try {
            if (!this.ifSize.getText().equals(this.sizeDefaultValue)) {
                this.distinctType.setSize(this.ifSize.getText());
            } else {
                this.distinctType.setSize("");
            }
        }
        catch (Exception e) {
            this.distinctType.setSize("");
        }
        try {
            if (this.ifPrecision.getIntValue() != this.precisionDefaultValueInt || this.ifScale.getIntValue() != this.scaleDefaultValue) {
                this.distinctType.setPrecision(this.ifPrecision.getIntValue());
                this.distinctType.setScale(this.ifScale.getIntValue());
            } else {
                this.distinctType.setPrecision(0);
                this.distinctType.setScale(0);
            }
        }
        catch (Exception e) {
            this.distinctType.setPrecision(0);
            this.distinctType.setScale(0);
        }
        this.setResponsibleParties();
        this.setDocuments();
        DistinctTypePropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.distinctType.clearProperties();
        for (DynamicProperty dp : this.dynamicPropertiesList) {
            this.distinctType.setProperty(dp.getName(), dp.getValue());
        }
    }

    private void initType() {
        LogicalDatatype logicalDataType = this.distinctType.getLogicalDataType();
        if (logicalDataType != null) {
            Map m = logicalDataType.getToPhysical();
            MDDataType datatype = logicalDataType.createDataType(this.distinctType.getSelectedRDBMSType().getName(), m);
            if (datatype instanceof MDImplicitSized) {
                this.ifSize.setEnabled(false);
                this.ifPrecision.setEnabled(false);
                this.ifScale.setEnabled(false);
            } else if (datatype instanceof MDPackedSized) {
                this.ifSize.setText("");
                this.ifSize.setEnabled(false);
                try {
                    if (this.distinctType.getPrecision() >= 0) {
                        this.ifPrecision.setValue((long)this.distinctType.getPrecision());
                    } else if (datatype.getPrecision() != 0) {
                        this.ifPrecision.setValue(datatype.getPrecision() > 0 ? Integer.valueOf(datatype.getPrecision()) : null);
                    }
                    datatype.getPrecision();
                    this.ifPrecision.setEnabled(true);
                }
                catch (Exception e) {
                    this.ifPrecision.setEnabled(false);
                }
                try {
                    if (this.distinctType.getScale() != 0) {
                        this.ifScale.setValue(this.distinctType.getScale() > 0 ? Integer.valueOf(this.distinctType.getScale()) : null);
                    } else if (datatype.getScale() != 0) {
                        this.ifScale.setValue(datatype.getScale() > 0 ? Integer.valueOf(datatype.getScale()) : null);
                    }
                    datatype.getScale();
                    this.ifScale.setEnabled(true);
                }
                catch (Exception e) {
                    this.ifScale.setEnabled(false);
                }
            } else {
                try {
                    if (!this.distinctType.getSize().equalsIgnoreCase("")) {
                        this.ifSize.setText(this.distinctType.getSize());
                    } else if (!datatype.getSize().equalsIgnoreCase("0")) {
                        this.ifSize.setText(datatype.getSize());
                    }
                    datatype.getSize();
                    this.ifSize.setEnabled(true);
                }
                catch (Exception e) {
                    this.ifSize.setEnabled(false);
                }
                try {
                    if (this.distinctType.getPrecision() != 0) {
                        this.ifPrecision.setValue(this.distinctType.getPrecision() > 0 ? Integer.valueOf(this.distinctType.getPrecision()) : null);
                    } else if (datatype.getPrecision() != 0) {
                        this.ifPrecision.setValue(datatype.getPrecision() > 0 ? Integer.valueOf(datatype.getPrecision()) : null);
                    }
                    datatype.getPrecision();
                    this.ifPrecision.setEnabled(true);
                }
                catch (Exception e) {
                    this.ifPrecision.setEnabled(false);
                }
                try {
                    if (this.distinctType.getScale() != 0) {
                        this.ifScale.setValue(this.distinctType.getScale() > 0 ? Integer.valueOf(this.distinctType.getScale()) : null);
                    } else if (datatype.getScale() != 0) {
                        this.ifScale.setValue(datatype.getScale() > 0 ? Integer.valueOf(datatype.getScale()) : null);
                    }
                    datatype.getScale();
                    this.ifScale.setEnabled(true);
                }
                catch (Exception e) {
                    this.ifScale.setEnabled(false);
                }
            }
        }
    }

    @Override
    protected void initTree(DefaultMutableTreeNode root) {
        this.addToTree(root, this.getGeneralPanel());
        this.addToTree(root, this.getCommentsPanel());
        this.addToTree(root, this.getCommentsInRDBMSPanel());
        this.addToTree(root, this.getNotesPanel());
        this.addToTree(root, this.getUsedInPanel());
        this.addToTree(root, this.getResPartiesPanel());
        this.addToTree(root, this.getDocumentsPanel());
        this.addToTree(root, this.getDynamicPropertiesPanel());
        this.addToTree(root, this.getSummaryPanel());
    }

    @Override
    protected String getHelpIndex() {
        return "DISTINCTTYPE_PROPERTIES_DIALOG";
    }

    private void initGeneral() {
        Iterator it1 = Design.getDefaultRDBMSTypeSet().iterator();
        while (it1.hasNext()) {
            RDBMSType t = (RDBMSType)it1.next();
            this.typesRDBMSSites.put(t.getType(), t.getName());
        }
        JLabel lbLogType = new JLabel(LB_LOGICAL_TYPE);
        lbLogType.setPreferredSize(this.getDefaultSize());
        this.cbLogicalType = new JComboBox();
        this.cbLogicalType.setPreferredSize(this.getDefaultSize());
        this.cbLogicalType.setMaximumRowCount(20);
        this.cbLogicalType.addActionListener(new DatatypeListener());
        this.cbLogicalType.setEnabled(this.isEditable());
        this.addRowToGeneralPanel(this.createRow(lbLogType, this.cbLogicalType));
        JLabel lbSize = new JLabel(LB_SIZE);
        lbSize.setPreferredSize(this.getDefaultSize());
        this.ifSize = new JTextField();
        this.ifSize.setPreferredSize(this.getDefaultSize());
        this.ifSize.setEnabled(this.isEditable());
        this.addRowToGeneralPanel(this.createRow(lbSize, this.ifSize));
        JLabel lbPrecision = new JLabel(LB_PRECISION);
        lbPrecision.setPreferredSize(this.getDefaultSize());
        this.ifPrecision = new JIntegerField();
        this.ifPrecision.setPreferredSize(this.getDefaultSize());
        this.ifPrecision.setEnabled(this.isEditable());
        this.addRowToGeneralPanel(this.createRow(lbPrecision, this.ifPrecision));
        JLabel lbScale = new JLabel(LB_SCALE);
        lbScale.setPreferredSize(this.getDefaultSize());
        this.ifScale = new JIntegerField();
        this.ifScale.setPreferredSize(this.getDefaultSize());
        this.ifScale.setEnabled(this.isEditable());
        this.addRowToGeneralPanel(this.createRow(lbScale, this.ifScale));
    }

    private void updateType() {
        this.ifSize.setText("");
        this.ifPrecision.setText("");
        this.ifScale.setText("");
        LogicalDatatype selected = (LogicalDatatype)this.cbLogicalType.getSelectedItem();
        if (selected != null) {
            Map defaults = selected.getLTDefaultValues();
            String pdf = (String)defaults.get("precision_default_value");
            this.precisionDefaultValueInt = pdf != "" && pdf != null ? new Integer((String)defaults.get("precision_default_value")) : 0;
            String scdf = (String)defaults.get("scale_default_value");
            this.scaleDefaultValue = scdf != "" && scdf != null ? new Integer((String)defaults.get("scale_default_value")) : 0;
            Map m = selected.getToPhysical();
            MDDataType datatype = selected.createDataType(this.distinctType.getSelectedRDBMSType().getName(), m);
            if (datatype instanceof MDImplicitSized) {
                this.ifSize.setEnabled(false);
                this.ifPrecision.setEnabled(false);
                this.ifScale.setEnabled(false);
            } else if (datatype instanceof MDPackedSized) {
                this.ifSize.setText("");
                this.ifSize.setEnabled(false);
                try {
                    if (datatype.getPrecision() != 0) {
                        this.ifPrecision.setValue((long)datatype.getPrecision());
                    } else {
                        this.ifPrecision.setValue(this.precisionDefaultValueInt > 0 ? Integer.valueOf(this.precisionDefaultValueInt) : null);
                    }
                    this.ifPrecision.setEnabled(true);
                }
                catch (Exception e) {
                    this.ifPrecision.setEnabled(false);
                }
                try {
                    if (datatype.getScale() != 0) {
                        this.ifScale.setValue((long)datatype.getScale());
                    } else {
                        this.ifScale.setValue(this.scaleDefaultValue > 0 ? Integer.valueOf(this.scaleDefaultValue) : null);
                    }
                    this.ifScale.setEnabled(true);
                }
                catch (Exception e) {
                    this.ifScale.setEnabled(false);
                }
            } else {
                try {
                    if (!datatype.getSize().equalsIgnoreCase("0")) {
                        this.ifSize.setText(datatype.getSize());
                    }
                    this.ifSize.setEnabled(true);
                }
                catch (Exception e) {
                    this.ifSize.setEnabled(false);
                }
                try {
                    if (datatype.getPrecision() != 0) {
                        this.ifPrecision.setValue((long)datatype.getPrecision());
                    }
                    this.ifPrecision.setEnabled(true);
                }
                catch (Exception e) {
                    this.ifPrecision.setEnabled(false);
                }
                try {
                    if (datatype.getScale() != 0) {
                        this.ifScale.setValue((long)datatype.getScale());
                    }
                    this.ifScale.setEnabled(true);
                }
                catch (Exception e) {
                    this.ifScale.setEnabled(false);
                }
            }
        }
    }

    private static void stopCellEditing(JTable table) {
        int icol = table.getEditingColumn();
        int irow = table.getEditingRow();
        if (icol > -1 && irow > -1) {
            table.getCellEditor(irow, icol).stopCellEditing();
        }
    }

    private class DatatypeListener
    implements ActionListener {
        private DatatypeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            DistinctTypePropertiesDialogEx.this.updateType();
        }
    }
}

