/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileFilter;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.tree.TreePath;
import javax.swing.undo.UndoManager;
import oracle.dbtools.crest.exports.csv.CSVExporter;
import oracle.dbtools.crest.exports.csv.SelectCSVExportDialog;
import oracle.dbtools.crest.exports.cubeviews.CubeViewsExporter;
import oracle.dbtools.crest.exports.oracleaw.OracleAW11Exporter;
import oracle.dbtools.crest.exports.reports.ReportsHandler;
import oracle.dbtools.crest.exports.xmla.XMLAExporter;
import oracle.dbtools.crest.fcp.DataModelerAddin;
import oracle.dbtools.crest.fcp.FileNavigatorWrapper;
import oracle.dbtools.crest.fcp.GlobalSearchDockable;
import oracle.dbtools.crest.fcp.preferences.ModelingPreferences;
import oracle.dbtools.crest.fcp.vcs.DataModelerChangeList;
import oracle.dbtools.crest.fcp.vcs.MergeConflictsDialog;
import oracle.dbtools.crest.fcp.vcs.svn.SVNChangeListWindow;
import oracle.dbtools.crest.fcp.vcs.svn.SVNClientHelper;
import oracle.dbtools.crest.fcp.vcs.svn.SVNHistoryWindow;
import oracle.dbtools.crest.fcp.vcs.svn.SVNViewPropertiesWindow;
import oracle.dbtools.crest.fcp.vcs.svn.commands.SVNMergeWindow;
import oracle.dbtools.crest.fcp.vcs.svn.commands.SVNStatusCommand;
import oracle.dbtools.crest.imports.cubeviews.CubeViewsHandler;
import oracle.dbtools.crest.imports.ddl.DDLFilesCollector;
import oracle.dbtools.crest.imports.ddl.DDLHandler;
import oracle.dbtools.crest.imports.erwin.ERwinHandler;
import oracle.dbtools.crest.imports.var.ImportTypeSelector;
import oracle.dbtools.crest.imports.var.MappedVarsCollector;
import oracle.dbtools.crest.imports.var.VARParser;
import oracle.dbtools.crest.imports.xmla.XMLAHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.glossary.Glossary;
import oracle.dbtools.crest.model.design.logical.RestoreMappings;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.metadata.XMLTransformationManager;
import oracle.dbtools.crest.model.persistence.db.AbstractRepositoryManager;
import oracle.dbtools.crest.model.persistence.xml.XMLConstants;
import oracle.dbtools.crest.swingui.AbstractController;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.ExternalLogDialog;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.MDBAction;
import oracle.dbtools.crest.swingui.MenuUtils;
import oracle.dbtools.crest.swingui.Messages;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.swingui.SelectableObject;
import oracle.dbtools.crest.swingui.admin.domains.DomainAdmin;
import oracle.dbtools.crest.swingui.admin.masktemplates.MaskTemplatesAdmin;
import oracle.dbtools.crest.swingui.admin.objects.ObjectNamesAdmin;
import oracle.dbtools.crest.swingui.admin.rdbms.RDBMSSiteEditor;
import oracle.dbtools.crest.swingui.admin.types.TypesAdmin;
import oracle.dbtools.crest.swingui.compare.ModelChooserDialog;
import oracle.dbtools.crest.swingui.diagram.Diagram;
import oracle.dbtools.crest.swingui.domains.ImportDomainsDialog;
import oracle.dbtools.crest.swingui.editor.SelectExportDialog;
import oracle.dbtools.crest.swingui.glossary.GlossaryDialog;
import oracle.dbtools.crest.swingui.logical.ControllerLogical;
import oracle.dbtools.crest.swingui.logical.DPVLogical;
import oracle.dbtools.crest.swingui.printing.DesignPrintModule;
import oracle.dbtools.crest.swingui.printing.ImageExporter;
import oracle.dbtools.crest.swingui.printing.PDFExporter;
import oracle.dbtools.crest.swingui.relational.ControllerRelational;
import oracle.dbtools.crest.swingui.transformations.NamesStandardizationDialog;
import oracle.dbtools.crest.swingui.wizards.Table2ViewDialog;
import oracle.dbtools.crest.swingui.wizards.TypesToDomainsDialog;
import oracle.dbtools.crest.swingui.wizards.View2TableDialog;
import oracle.dbtools.crest.swingui.wizards.cwddesigner.CWDExtractionWizard;
import oracle.dbtools.crest.swingui.wizards.metadata.DBMExtractionWizard;
import oracle.dbtools.crest.swingui.wizards.oracledesigner.ODExtractionWizard;
import oracle.dbtools.crest.swingui.wizards.reports.ExportReportsDialog;
import oracle.dbtools.crest.swingui.wizards.reports.ReportsGenerationDialog;
import oracle.dbtools.crest.util.Extension;
import oracle.dbtools.crest.util.FileUtils;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.TimeLog;
import oracle.dbtools.crest.util.gui.swing.JListDialog;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.print.Config;
import oracle.dbtools.raptor.ssh.navigator.SshNavigatorManager;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFilter;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.vcs.icons.VCSIconArb;

public class ControllerApplication
extends AbstractController {
    private OpenDesign openDesign;
    private CloseDesign closeDesign;
    private CloseAllDesigns closeAllDesigns;
    private PrintDialog printDialog;
    private PageSetup pageSetup;
    private ExportToImage exportToImage;
    private ExportToPDF exportToPDF;
    private ShowDDLFileEditor ddlEditor;
    private ImportDDL importDDL;
    private ImportCubeViewsXML importCubeViews;
    private ImportVar importVAR;
    private ImportXMLA importXMLA;
    private ImportERwin4 importERwin4;
    private ImportERwin7 importERwin7;
    private ImportDBMetadata importMD;
    private ImportOracleDesigner importOD;
    private ImportCWD4ALLDesigner importCWD;
    private ImportDomainFile importDomains;
    private ExportToCWD exportToCWD;
    private ExportToCSV exportToCSV;
    private ExportToReportsSchema exportToReports;
    private ExportToOracleAW exportOracleAW;
    private ExportXMLA exportXMLA;
    private Undo undoAction;
    private Redo redoAction;
    private Copy copyAction;
    private Paste pasteAction;
    private Delete deleteAction;
    private AlignLeft alignLeft;
    private AlignTop alignTop;
    private EqualWidth equalWidth;
    private EqualHeight equalHeight;
    private ExitApplication exitAction;
    private SaveAll saveAll;
    private SaveAs saveAs;
    private NamesStandardization namesStandardization;
    private GlossaryEditor glossaryEditor;
    private ShowEditor showEditor;
    private ShowDDL showDDL;
    private DomainsAdministration domainsAdmin;
    private MaskTemplatesAdministration maskTemplatesAdministration;
    private TypesAdministration typesAdmin;
    private RDBMSSiteAdministration rdbmsAdmin;
    private Table2ViewWizard t2vWizard;
    private View2TableWizard v2tWizard;
    private TypesToDomainsWizard typesToDomainsWizard;
    private CompareModels compareModels;
    private Recent emptyRecent = new Recent();
    private ShowDesignRules designRules;
    private ShowCustomDesignRules customDesignRules;
    private ShowCustomLibrariesManager customLibraries;
    private ShowTransformationsManager customTransformations;
    private ShowTableDDLTransformations tableDDLTransformations;
    private ExportDDLFile exportDDL;
    private ExportCubeViewsXML exportCubeViews;
    private ViewDetails viewDetails;
    private ShowBarkerNotation showBarkerNotation;
    private ShowBachmanNotation showBachmanNotation;
    private ShowIENotation showIENotation;
    private OpenStorageDesign openStorageDesign;
    private CloseStorageDesign closeStorageDesign;
    private ExternalLog externalLog;
    private ZoomIn zoomIn;
    private ZoomOut zoomOut;
    private FitScreen fitScreen;
    private ActualSize actualSize;
    private Search search;
    private GlobalSearch globalSearch;
    private ShowReports showReports;
    private PendingChanges pendingChanges;
    private FileNavigator fileNavigator;
    private SSHNavigator sshNavigator;
    private ObjectNamesAdministration fixedNamesAdministration;
    private boolean isNewDesignPathVersioned = false;
    private static final Logger LOGGER = new Logger(ControllerApplication.class);
    private static final String[] FILE_PATH = new String[]{FILE_CAPTION};
    private static final String[] IMPORT_PATH = new String[]{FILE_PATH[0], IMPORT_CAPTION};
    private static final String[] EXPORT_PATH = new String[]{FILE_PATH[0], EXPORT_CAPTION};
    private static final String[] REPORTS_PATH = new String[]{FILE_PATH[0], REPORTS_CAPTION};
    private static final String[] EXPORT_DIAGRAM_PATH = new String[]{FILE_PATH[0], PRINT_DIAGRAM_CAPTION};
    private static final String[] VIEW_PATH = new String[]{VIEW_CAPTION};
    private static final String[] TOOLS_PATH = new String[]{TOOLS_CAPTION};
    private static final String[] RECENT_PATH = new String[]{FILE_PATH[0], RECENT_FILES_CAPTION};
    private static final String[] EDIT_PATH = new String[]{EDIT_CAPTION};
    private static final String[] STORAGE_PATH = new String[]{STORAGE_CAPTION};
    private static final String[] LOGICAL_DIAGRAM_NOTATION_PATH = new String[]{VIEW_PATH[0], LOGICAL_DIAGRAM_NOTATION_CAPTION};
    public static final int PERCENTAGE_SAVING_RELATIONAL_DESIGNS = 70;
    private static final int PERCENTAGE_SAVING_DESIGN = 10;
    public static final String SAVE_OLD_DESIGN_WARNING = "This design is saved in an old format and can't be overwritten!\nPlease use \"Save As..\" option to save it as new design.";

    public ControllerApplication(ApplicationView appView) {
        super(appView);
    }

    @Override
    public void initializeActions() {
        this.openDesign = new OpenDesign();
        this.add(this.openDesign);
        this.closeDesign = new CloseDesign();
        this.add(this.closeDesign);
        this.closeAllDesigns = new CloseAllDesigns();
        this.add(this.closeAllDesigns);
        if (!ApplicationView.IS_VIEWER) {
            this.saveAll = new SaveAll();
            this.add(this.saveAll);
            this.saveAs = new SaveAs();
            this.add(this.saveAs);
        }
        if (ApplicationView.LOGICAL_MODEL_ONLY) {
            this.importVAR = new ImportVar();
            this.add(this.importVAR);
            this.importCWD = new ImportCWD4ALLDesigner();
            this.add(this.importCWD);
            this.importDomains = new ImportDomainFile();
            this.add(this.importDomains);
            this.exportToCWD = new ExportToCWD();
            this.add(this.exportToCWD);
            this.add(new ExportDDLFile());
            this.exportToCSV = new ExportToCSV();
            this.add(this.exportToCSV);
        } else if (!ApplicationView.IS_VIEWER) {
            this.importDDL = new ImportDDL();
            this.add(this.importDDL);
            this.importCubeViews = new ImportCubeViewsXML();
            this.add(this.importCubeViews);
            this.importVAR = new ImportVar();
            this.add(this.importVAR);
            this.importXMLA = new ImportXMLA();
            this.add(this.importXMLA);
            this.importERwin4 = new ImportERwin4();
            this.add(this.importERwin4);
            this.importERwin7 = new ImportERwin7();
            this.add(this.importERwin7);
            this.importMD = new ImportDBMetadata();
            this.add(this.importMD);
            this.importOD = new ImportOracleDesigner();
            this.add(this.importOD);
            this.importCWD = new ImportCWD4ALLDesigner();
            this.add(this.importCWD);
            this.importDomains = new ImportDomainFile();
            this.add(this.importDomains);
            this.exportToCWD = new ExportToCWD();
            this.add(this.exportToCWD);
            this.exportDDL = new ExportDDLFile();
            this.add(this.exportDDL);
            this.exportCubeViews = new ExportCubeViewsXML();
            this.add(this.exportCubeViews);
            this.exportXMLA = new ExportXMLA();
            this.add(this.exportXMLA);
            this.exportOracleAW = new ExportToOracleAW();
            this.add(this.exportOracleAW);
            this.exportToCSV = new ExportToCSV();
            this.add(this.exportToCSV);
            this.exportToReports = new ExportToReportsSchema();
            this.add(this.exportToReports);
        }
        this.pageSetup = new PageSetup();
        this.add(this.pageSetup);
        this.printDialog = new PrintDialog();
        this.add(this.printDialog);
        this.exportToImage = new ExportToImage();
        this.add(this.exportToImage);
        this.exportToPDF = new ExportToPDF();
        this.add(this.exportToPDF);
        this.emptyRecent.setEnabled(false);
        this.emptyRecent.setIcon(null);
        this.add(this.emptyRecent);
        this.exitAction = new ExitApplication();
        this.add(this.exitAction);
        if (!ApplicationView.IS_VIEWER) {
            this.add(this.getUndoAction());
            this.add(this.getRedoAction());
            this.copyAction = new Copy();
            this.add(this.copyAction);
            this.pasteAction = new Paste();
            this.add(this.pasteAction);
            this.deleteAction = new Delete();
            this.add(this.deleteAction);
            this.alignLeft = new AlignLeft();
            this.add(this.alignLeft);
            this.alignTop = new AlignTop();
            this.add(this.alignTop);
            this.equalWidth = new EqualWidth();
            this.add(this.equalWidth);
            this.equalHeight = new EqualHeight();
            this.add(this.equalHeight);
        }
        this.showEditor = new ShowEditor();
        this.add(this.showEditor);
        if (!ApplicationView.IS_VIEWER) {
            this.viewDetails = new ViewDetails();
            this.add(this.viewDetails);
            this.showBarkerNotation = new ShowBarkerNotation();
            this.add(this.showBarkerNotation);
            this.showBachmanNotation = new ShowBachmanNotation();
            this.add(this.showBachmanNotation);
            this.showIENotation = new ShowIENotation();
            this.add(this.showIENotation);
        }
        this.showDDL = new ShowDDL();
        this.add(this.showDDL);
        this.ddlEditor = new ShowDDLFileEditor();
        this.add(this.ddlEditor);
        this.externalLog = new ExternalLog();
        this.add(this.externalLog);
        this.zoomIn = new ZoomIn();
        this.add(this.zoomIn);
        this.zoomOut = new ZoomOut();
        this.add(this.zoomOut);
        this.fitScreen = new FitScreen();
        this.add(this.fitScreen);
        this.actualSize = new ActualSize();
        this.add(this.actualSize);
        this.search = new Search();
        this.add(this.search);
        this.globalSearch = new GlobalSearch();
        this.add(this.globalSearch);
        if (ApplicationView.LOGICAL_MODEL_ONLY) {
            this.domainsAdmin = new DomainsAdministration();
            this.add(this.domainsAdmin);
            this.namesStandardization = new NamesStandardization();
            this.add(this.namesStandardization);
            this.glossaryEditor = new GlossaryEditor();
            this.add(this.glossaryEditor);
        } else if (!ApplicationView.IS_VIEWER) {
            this.domainsAdmin = new DomainsAdministration();
            this.add(this.domainsAdmin);
            this.typesAdmin = new TypesAdministration();
            this.add(this.typesAdmin);
            this.rdbmsAdmin = new RDBMSSiteAdministration();
            this.add(this.rdbmsAdmin);
            this.maskTemplatesAdministration = new MaskTemplatesAdministration();
            this.add(this.maskTemplatesAdministration);
            this.t2vWizard = new Table2ViewWizard();
            this.add(this.t2vWizard);
            this.v2tWizard = new View2TableWizard();
            this.add(this.v2tWizard);
            this.typesToDomainsWizard = new TypesToDomainsWizard();
            this.add(this.typesToDomainsWizard);
            this.namesStandardization = new NamesStandardization();
            this.add(this.namesStandardization);
            this.glossaryEditor = new GlossaryEditor();
            this.add(this.glossaryEditor);
            if (ApplicationView.debugMode) {
                this.add(new RestoreLostMappings());
            }
        }
        this.fixedNamesAdministration = new ObjectNamesAdministration();
        this.add(this.fixedNamesAdministration);
        this.designRules = new ShowDesignRules();
        this.add(this.designRules);
        this.customDesignRules = new ShowCustomDesignRules();
        this.add(this.customDesignRules);
        this.customLibraries = new ShowCustomLibrariesManager();
        this.add(this.customLibraries);
        this.customTransformations = new ShowTransformationsManager();
        this.add(this.customTransformations);
        this.tableDDLTransformations = new ShowTableDDLTransformations();
        this.add(this.tableDDLTransformations);
        this.showReports = new ShowReports();
        this.add(this.showReports);
        if (!ApplicationView.IS_VIEWER) {
            this.compareModels = new CompareModels();
            this.add(this.compareModels);
        }
        this.openStorageDesign = new OpenStorageDesign();
        this.add(this.openStorageDesign);
        this.closeStorageDesign = new CloseStorageDesign();
        this.add(this.closeStorageDesign);
        this.pendingChanges = new PendingChanges();
        this.fileNavigator = new FileNavigator();
        this.sshNavigator = new SSHNavigator();
    }

    @Override
    public DesignPartView getDesignPartView() {
        return null;
    }

    @Override
    public void setDesignPartView(DesignPartView dpv) {
    }

    @Override
    public String getToolBarName() {
        return Messages.getString("ControllerApplication.Global");
    }

    @Override
    public void select_SelectAction() {
    }

    public boolean designIsEmpty() {
        return this.getDesign().isNewDesign() && this.getApplicationView().getDirtyDesigns(true).length <= 0;
    }

    public Object[] getAvailableDesignNames() {
        ArrayList<String> result = new ArrayList<String>();
        Object[] temp = this.getApplicationView().getPersistenceManager().getAvailableDesigns();
        if (temp != null) {
            if (temp.length < 1) {
                return temp;
            }
            for (int i = 0; i < temp.length; ++i) {
                String name = (String)temp[i];
                result.add(name);
            }
            return result.toArray();
        }
        return result.toArray();
    }

    public Object getDesignNameChoice(Object[] availableDesignNames) {
        if (availableDesignNames.length < 1) {
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("ControllerApplication.NoDesignsToOpen"), Messages.getString("ControllerApplication.OpenDesign"), 1, this.getConfiguration().getIcon("OPEN_ICON", this.getPreferredIconSize()));
            return null;
        }
        return JOptionPane.showInputDialog((Component)Ide.getMainWindow(), Messages.getString("ControllerApplication.ChooseDesign"), Messages.getString("ControllerApplication.OpenDesign"), 3, this.getConfiguration().getIcon("OPEN_ICON", this.getPreferredIconSize()), availableDesignNames, availableDesignNames[0]);
    }

    public JMenu getRecentsMenu() {
        return this.getApplicationView().getControllerSet().getMenuStructure().get(RECENT_PATH);
    }

    public void centerOnScreen(JDialog window) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension mySize = window.getSize();
        Point newLocation = new Point((screenSize.width - mySize.width) / 2, (screenSize.height - mySize.height) / 3);
        window.setLocation(newLocation);
    }

    public Undo getUndoAction() {
        if (this.undoAction == null) {
            this.undoAction = new Undo(this.getDesign().getUndoManager());
        }
        return this.undoAction;
    }

    public Redo getRedoAction() {
        if (this.redoAction == null) {
            this.redoAction = new Redo(this.getDesign().getUndoManager());
        }
        return this.redoAction;
    }

    private Design findDesign(String storagePath) {
        for (Design design : this.getApplicationView().getDesigns()) {
            if (design.getStoragePath() == null || !FileUtils.fixPath(design.getStoragePath()).equalsIgnoreCase(FileUtils.fixPath(storagePath))) continue;
            return design;
        }
        return null;
    }

    public void openDesign(String desingPath) {
        String ext = ".dmd";
        File selected = new File(desingPath);
        if (selected != null && selected.exists()) {
            String designPath = selected.getParent();
            String fileName = selected.getName();
            String designName = FileUtils.removeExt(fileName);
            int pos = fileName.lastIndexOf(".");
            if (pos > -1) {
                ext = fileName.substring(pos);
            }
            this.doOpenDesign(designName, designPath, ext, true);
        }
    }

    private void doOpenDesign(final String designName, final String designPath, final String ext, boolean loadLastDPV) {
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block19: {
                    try {
                        Design selDesign = (Design)SVNChangeListWindow.getSelectedElementInScopeCB();
                        String choice = designName;
                        if (choice != null) {
                            TimeLog.log();
                            Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(3));
                            try {
                                Design design;
                                if (ControllerApplication.this.getApplicationView().getDesigns().size() > 1 || !ControllerApplication.this.designIsEmpty()) {
                                    design = ControllerApplication.this.getApplicationView().addDesign(true);
                                    ControllerApplication.this.getApplicationView().setCurrentDesign(design);
                                }
                                ControllerApplication.this.getApplicationView().getCurrentDesign().setFileName(choice);
                                ControllerApplication.this.getApplicationView().getCurrentDesign().setDesignPath(designPath);
                                ControllerApplication.this.getApplicationView().getCurrentDesign().setOldRepositoryType(".xml".equalsIgnoreCase(ext));
                                ControllerApplication.this.getApplicationView().getCurrentDesign().setCompressedDesign(".dmdz".equalsIgnoreCase(ext));
                                ControllerApplication.this.getApplicationView().setDesignName(choice);
                                ApplicationView.loading = true;
                                try {
                                    ControllerApplication.this.getApplicationView().enableControls(false);
                                    try {
                                        ApplicationView.log(MessageFormat.format(Messages.getString("ControllerApplication.OpenDesignP"), choice));
                                        ApplicationView.canLogging = false;
                                        design = ControllerApplication.this.getDesign();
                                        if (selDesign != null && selDesign.equals(design)) {
                                            SVNChangeListWindow.removeFromScope(design);
                                            SVNChangeListWindow.removeFromScope(selDesign);
                                        }
                                        if (design.openDesign(choice, ext)) {
                                            ControllerApplication.this.getApplicationView().getCurrentDesign().selectLastOpenDPV();
                                            ControllerApplication.this.getApplicationView().synchronizeTitle();
                                            ControllerApplication.this.getApplicationView().getBrowserPanel().expandToPath(ControllerApplication.this.getDesign().getPath());
                                            if (Extension.isSVNExtensionLoaded() && !design.isOldRepositoryType()) {
                                                SVNClientHelper.getInstance().checkVersioned(design);
                                                if (SVNClientHelper.getInstance().isVersioned(design.getStoragePath()) && !SVNClientHelper.getInstance().hasProperties(design)) {
                                                    SVNChangeListWindow.getSVNOutgoingChangesChangeList().setDataModelerChangesTimerTaskUpdatable(false);
                                                    SVNChangeListWindow.getSVNIncomingChangesChangeList().setDataModelerChangesTimerTaskUpdatable(false);
                                                    SVNChangeListWindow.getSVNUnversionedFilesChangeList().setDataModelerChangesTimerTaskUpdatable(false);
                                                }
                                                SVNChangeListWindow.addToScope(design);
                                            }
                                        }
                                        ApplicationView.canLogging = true;
                                        ApplicationView.log(MessageFormat.format(Messages.getString("ControllerApplication.OpenDesignP"), Messages.getString("OpenDesignDialog.OK")));
                                    }
                                    finally {
                                        ControllerApplication.this.getApplicationView().enableControls(true);
                                        ApplicationView.canLogging = true;
                                    }
                                }
                                finally {
                                    ApplicationView.loading = false;
                                }
                            }
                            finally {
                                Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(0));
                                TimeLog.log();
                            }
                            if (Extension.isSVNExtensionLoaded()) {
                                MergeConflictsDialog.getInstance().checkForConflicts(ControllerApplication.this.getDesign());
                            }
                            break block19;
                        }
                        ApplicationView.log(Messages.getString("ControllerApplication.OpenDesignCanceled"));
                    }
                    catch (Throwable error) {
                        LOGGER.error("Error Opening Design!", error);
                    }
                }
            }
        };
        thread.start();
    }

    public void refreshOutgoingChanges() {
        Dockable obj;
        DockStation dockStation = DockStation.getDockStation();
        if (dockStation != null && (obj = dockStation.getDockable(SVNChangeListWindow.VIEW_ID)) != null && obj instanceof SVNChangeListWindow) {
            ((SVNChangeListWindow)obj).refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private void saveDesign(Design design) {
        Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(3));
        try {
            int lpers = design.getLoadedModelPersistence();
            int cpers = design.getModelPersistence();
            ApplicationView.log(Messages.getString("ControllerApplication.SavingDesignAndPhysicalModels"));
            if (design.getLoadedVersion() < design.getVersion() && design.canUpgradeInPlace() || Design.PERS_MODEL_MIXED_MODE != lpers && lpers != cpers) {
                design.loadAllModels();
                this.getApplicationView().getXMLTransformationManager().setCheckDirty(false);
            } else {
                this.getApplicationView().getXMLTransformationManager().setCheckDirty(true);
            }
            this.saveAll();
            design.setReadOnly(false);
            design.setDirty(false);
        }
        finally {
            this.getApplicationView().getXMLTransformationManager().setCheckDirty(true);
            Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveAsDesign(int operation) {
        block35: {
            try {
                if (operation == 5) {
                    SelectExportDialog dialog = new SelectExportDialog(this.getApplicationView(), Messages.getString("ControllerApplication.SelectModelsSubviewsToExport"));
                    boolean okRes = dialog.showDialog();
                    if (!okRes) {
                        return;
                    }
                    this.getDesign().buildExporMaps(dialog.getSelectedModelsAndSWs());
                }
                String oldDesignPath = this.getApplicationView().getCurrentDesign().getDesignPath();
                String oldDesignNamePath = this.getApplicationView().getCurrentDesign().getStoragePath();
                String designName = null;
                if (!this.getDesign().isNewDesign()) {
                    designName = this.getDesign().getName();
                }
                String name = this.getApplicationView().selectDesignName(designName);
                String newDesignPath = this.getApplicationView().getCurrentDesign().getDesignPath();
                ProgressDialog monitor = null;
                if (name != null) {
                    Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(3));
                    try {
                        boolean doit = this.getApplicationView().overwriteDesign(name);
                        if (!doit) {
                            while (name != null && !doit) {
                                name = this.getApplicationView().selectDesignName(name);
                                if (name != null) {
                                    doit = this.getApplicationView().overwriteDesign(name);
                                    continue;
                                }
                                doit = false;
                            }
                        }
                        if (doit) {
                            try {
                                monitor = new ProgressDialog(this.getApplicationView(), Messages.getString("ControllerApplication.SaveAs"), 0, 100);
                                this.getDesign().setCurrentOperation(operation);
                                if (!"".equals(oldDesignPath)) {
                                    this.getApplicationView().getCurrentDesign().setDesignPath(oldDesignPath);
                                    ApplicationView.loading = true;
                                    this.getDesign().loadAllModels(monitor);
                                    ApplicationView.loading = false;
                                }
                                monitor.setProgress(70);
                                if (operation == 4) {
                                    this.getApplicationView().getCurrentDesign().setFileName(name);
                                    this.getApplicationView().getBrowserPanel().getNavigationTreeDesign().updateSubtree(this.getApplicationView().getDesigns());
                                    this.getApplicationView().synchronizeTitle();
                                    this.getApplicationView().getCurrentDesign().setNewDesign(false);
                                    this.getApplicationView().getCurrentDesign().setCurrentOperation(4);
                                    this.getApplicationView().getCurrentDesign().setOldDesignPath(oldDesignNamePath);
                                    this.getDesign().resetDomains();
                                } else if (operation == 5) {
                                    this.getApplicationView().getCurrentDesign().setCurrentOperation(operation);
                                    this.getApplicationView().setCurrentOperation(operation);
                                    this.getApplicationView().getCurrentDesign().setExportFileName(name);
                                    this.getApplicationView().getCurrentDesign().setExportDesignPath(newDesignPath);
                                }
                                this.getApplicationView().getCurrentDesign().setDesignPath(newDesignPath);
                                this.getApplicationView().deleteDesign(this.getApplicationView().getCurrentDesign().getFileName());
                                this.getApplicationView().getXMLTransformationManager().setCheckDirty(false);
                                monitor.setNote(Messages.getString("ControllerApplication.SaveAs"));
                                Design design = this.getDesign();
                                boolean saveInNewPlace = !newDesignPath.equals(oldDesignPath);
                                this.isNewDesignPathVersioned = false;
                                if (saveInNewPlace) {
                                    if (Extension.isSVNExtensionLoaded()) {
                                        this.isNewDesignPathVersioned = SVNClientHelper.getInstance().isVersioned(newDesignPath);
                                    }
                                    design.setVersioned(false);
                                    if (this.isNewDesignPathVersioned) {
                                        int pers = design.getModelPersistence();
                                        design.setModelPersistence(Design.PERS_MODEL_IN_MANY_FILES);
                                    }
                                }
                                if (this.getDesign().getLoadedVersion() < 3.4f) {
                                    for (RelationalDesign pd : this.getDesign().getRelationalDesigns()) {
                                        String id = pd.getObjectID();
                                        if (!id.startsWith("RelD")) continue;
                                        pd.setObjectID(id);
                                        pd.setDirty(true);
                                    }
                                }
                                this.getDesign().setLoadedVersion(this.getDesign().getVersion());
                                this.saveAll();
                                this.getApplicationView().getPersistenceManager().setCheckDirty(true);
                                design.setReadOnly(false);
                                if (saveInNewPlace) {
                                    int step = 10;
                                    monitor.setNote(Messages.getString("ControllerApplication.CheckingProperties"));
                                    if (Extension.isSVNExtensionLoaded() && this.isNewDesignPathVersioned) {
                                        SVNClientHelper.getInstance().checkProperties(design, false);
                                    }
                                    monitor.increaseProgress(step);
                                    monitor.setNote(Messages.getString("ControllerApplication.AddingToVCS"));
                                    monitor.getDialog().setVisible(false);
                                    try {
                                        this.addToVCS(design, newDesignPath, name);
                                    }
                                    finally {
                                        monitor.getDialog().setVisible(true);
                                    }
                                }
                                monitor.setProgress(100);
                                ApplicationView.loading = false;
                            }
                            catch (Throwable error) {
                                try {
                                    LOGGER.error("Error loading design during Save As...!", error);
                                    ApplicationView.log(Messages.getString("ControllerApplication.ErrorLoadingDesignDuringSaveAs"));
                                    MessageDialogs.showErrorMessage(Messages.getString("ControllerApplication.ErrorInSaveAsOperation"), true);
                                    break block35;
                                }
                                catch (Throwable throwable) {
                                    throw throwable;
                                }
                                finally {
                                    ApplicationView.loading = false;
                                    this.getApplicationView().getPersistenceManager().setCheckDirty(true);
                                    this.getDesign().setReadOnly(false);
                                }
                            }
                            this.getApplicationView().getPersistenceManager().setCheckDirty(true);
                            this.getDesign().setReadOnly(false);
                            break block35;
                        }
                        this.getApplicationView().getCurrentDesign().setDesignPath(oldDesignPath);
                        ApplicationView.log(Messages.getString("ControllerApplication.SaveDesignAsCanceled"));
                        break block35;
                    }
                    finally {
                        if (monitor != null) {
                            monitor.close();
                        }
                        if (operation == 5) {
                            this.getDesign().clearExportMaps();
                            this.getApplicationView().getCurrentDesign().setDesignPath(oldDesignPath);
                            this.getApplicationView().getCurrentDesign().setExportFileName("");
                            MessageDialogs.showMessage((Component)Ide.getMainWindow(), Messages.getString("ControllerApplication.ExportedOk"));
                        }
                        Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(0));
                        this.getApplicationView().getCurrentDesign().setCurrentOperation(-1);
                        this.getApplicationView().getCurrentDesign().setOldDesignPath(null);
                        this.getApplicationView().setCurrentOperation(-1);
                    }
                }
                ApplicationView.log(Messages.getString("ControllerApplication.SaveDesignAsCanceled"));
            }
            catch (Throwable error) {
                LOGGER.error("Error Saving Design as...!", error);
            }
        }
    }

    private void addToVCS(Design design, String designPath, String designName) {
        if (Extension.isSVNExtensionLoaded()) {
            SVNClientHelper svnClientHelper = SVNClientHelper.getInstance();
            JTextArea commitComment = new JTextArea(7, 50);
            Object[] commentsFields = new Object[]{Messages.getString("ControllerApplication.InitialCommitComments"), commitComment};
            if (this.isNewDesignPathVersioned && JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), Messages.getString("ControllerApplication.AddToVCSConfirmation"), Messages.getString("ControllerApplication.AddToVCS"), 0) == 0) {
                JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), commentsFields, Messages.getString("ControllerApplication.DesignCheckIn"), -1, -1, VCSIconArb.getIcon((String)"commit2.png"));
                boolean compressedDesign = design.isCompressedDesign();
                String designExtension = compressedDesign ? ".dmdz" : ".dmd";
                File designFile = new File(designPath, designName + designExtension);
                File designFolder = new File(designPath, designName);
                this.addToVCSSystemTypesFolder(designPath);
                ApplicationView.log("Start adding files");
                TimeLog.log("Start adding files");
                svnClientHelper.doAdd(designFile);
                svnClientHelper.doAdd(designFolder);
                ApplicationView.log("End adding files");
                TimeLog.log("End adding files");
                design.setVersioned(true);
                svnClientHelper.checkProperties(design, false, false);
                svnClientHelper.doCommit(new File[]{designFile, designFolder}, commitComment.getText(), true, false);
                SVNChangeListWindow.addToScope(design);
            }
        }
    }

    private void addToVCSSystemTypesFolder(String designPath) {
        String defaultSystemTypesPath;
        SVNClientHelper svnClientHelper = SVNClientHelper.getInstance();
        if (!svnClientHelper.isVersioned(defaultSystemTypesPath = XMLTransformationManager.getDefaultSystemTypesPath())) {
            URLFileChooser fileChooser = new URLFileChooser();
            fileChooser.clearChooseableURLFilters();
            fileChooser.setSelectionScope(1);
            fileChooser.setSelectionMode(0);
            boolean chooseSystemTypesFolder = true;
            while (chooseSystemTypesFolder) {
                int status = fileChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString("ControllerApplication.SaveSystemTypes"));
                if (status == 0) {
                    File selected = new File(fileChooser.getSelectedURL().getPath());
                    if (!svnClientHelper.isVersioned(fileChooser.getSelectedURL().getPath())) {
                        if (selected.getPath().equalsIgnoreCase(designPath) || selected.getPath().startsWith(designPath + File.pathSeparator)) {
                            svnClientHelper.doAdd(selected);
                            svnClientHelper.doCommit(new File[]{selected}, Messages.getString("ControllerApplication.SystemTypesFolderAddedToVC"), true, false);
                            chooseSystemTypesFolder = false;
                        } else {
                            JLabel[] errorMessageLabel = new JLabel[]{new JLabel(Messages.getString("ControllerApplication.SystemTypesFolderNotVersioned")), new JLabel(Messages.getString("ControllerApplication.PleaseSelectVersionedFolder"))};
                            JOptionPane.showMessageDialog((Component)fileChooser, errorMessageLabel, Messages.getString("ControllerApplication.NonVersionedFolderNotAllowed"), 0, null);
                        }
                    } else {
                        chooseSystemTypesFolder = false;
                    }
                    ApplicationView.getInstance().getSettings().setDefaultSystemTypesPath(selected.getPath());
                    ModelingPreferences.getInstance((PropertyStorage)Preferences.getPreferences()).setDefaultSystemTypesPath(selected.getPath());
                    continue;
                }
                chooseSystemTypesFolder = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAll() {
        Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(3));
        Design design = this.getDesign();
        try {
            TimeLog.log("start save operation");
            int mb = 0x100000;
            Runtime runtime = Runtime.getRuntime();
            System.out.println("begin memory  total  " + runtime.totalMemory() / (long)mb + "  /memory  fre  " + runtime.freeMemory() / (long)mb + "  /used memory  " + (runtime.totalMemory() - runtime.freeMemory()) / (long)mb);
            ApplicationView.log(MessageFormat.format(Messages.getString("ControllerApplication.SaveDesign"), design.getFileName()));
            Design sel = DataModelerChangeList.getSelectedDesign();
            if (design == sel) {
                design.setSingleObjectRefresh(false);
            }
            design.saveAll();
            if (this.getApplicationView().getCurrentOperation() != 5) {
                if (Extension.isSVNExtensionLoaded() && design == sel) {
                    SVNChangeListWindow.getSVNOutgoingChangesChangeList().refresh();
                }
                this.getApplicationView().addRecent(this.getApplicationView().getDesignName(), this.getApplicationView().getCurrentDesign().getDesignPath());
            }
            TimeLog.log("End save operation");
            System.out.println("END memory  total  " + runtime.totalMemory() / (long)mb + "  /memory  fre  " + runtime.freeMemory() / (long)mb + "  /used memory  " + (runtime.totalMemory() - runtime.freeMemory()) / (long)mb);
            ApplicationView.log(MessageFormat.format(Messages.getString("ControllerApplication.DesignSaved"), design.getFileName()) + " (" + design.getStoragePath() + ")");
        }
        finally {
            design.setSingleObjectRefresh(true);
            Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public void updateMenus() {
        if (!ApplicationView.IS_VIEWER) {
            this.saveAll.setEnabled(!this.getDesign().isReadOnly());
            this.namesStandardization.setEnabled(!this.getDesign().isReadOnly());
            this.alignLeft.setEnabled(this.canAlign());
            this.alignTop.setEnabled(this.alignLeft.isEnabled());
            this.equalWidth.setEnabled(this.alignLeft.isEnabled());
            this.equalHeight.setEnabled(this.alignLeft.isEnabled());
            this.copyAction.setEnabled(this.canCopy());
            this.pasteAction.setEnabled(this.canPaste());
            this.deleteAction.setEnabled(this.canDelete());
            this.updateViewDetailsMenu();
            this.showBarkerNotation.setEnabled(this.isBarkerNotationEnabled());
            this.showBachmanNotation.setEnabled(this.isBachmanNotationEnabled());
            this.showIENotation.setEnabled(this.isIENotationEnabled());
            this.updateUndoRedoMenu();
        } else {
            this.setEnabled(this.namesStandardization, false);
            this.setEnabled(this.alignLeft, false);
            this.setEnabled(this.alignTop, false);
            this.setEnabled(this.equalWidth, false);
            this.setEnabled(this.equalHeight, false);
            this.setEnabled(this.copyAction, false);
            this.setEnabled(this.pasteAction, false);
            this.setEnabled(this.deleteAction, false);
            this.updateViewDetailsMenu();
            this.setEnabled(this.showBarkerNotation, this.isBarkerNotationEnabled());
            this.setEnabled(this.showBachmanNotation, this.isBachmanNotationEnabled());
            this.setEnabled(this.showIENotation, this.isIENotationEnabled());
            this.updateUndoRedoMenu();
        }
        this.setEnabled(this.showEditor, this.checkSelected());
        this.setEnabled(this.showDDL, this.hasDDL());
        this.setEnabled(this.ddlEditor, this.hasRelationalModels());
        this.setEnabled(this.exportDDL, this.hasRelationalModels());
        this.getApplicationView().updateDesignRules(!this.getDesign().isReadOnly());
        AbstractRepositoryManager dbman = this.getApplicationView().getDBPersistenceManager().getDBRepositoryManager();
        boolean connected = dbman.isConnected() || this.getDesign().isLoadFromDB();
        this.setEnabled(this.openDesign, !connected);
        this.setEnabled(this.saveAll, !connected && !ApplicationView.IS_VIEWER);
        this.setEnabled(this.saveAs, !connected && !ApplicationView.IS_VIEWER);
    }

    public void updateUndoRedoMenu() {
        if (this.undoAction != null) {
            this.undoAction.setEnabled(this.getDesign().getUndoManager().canUndo());
            this.undoAction.setName(this.getDesign().getUndoManager().getUndoPresentationName());
        }
        if (this.redoAction != null) {
            this.redoAction.setEnabled(this.getDesign().getUndoManager().canRedo());
            this.redoAction.setName(this.getDesign().getUndoManager().getRedoPresentationName());
        }
    }

    private void updateViewDetailsMenu() {
        if (this.isEditable() && this.viewDetails != null && this.viewDetails.getMenu() != null && this.getApplicationView().getCurrentDPV() != null) {
            this.viewDetails.getMenu().removeAll();
            JMenu dm = this.getApplicationView().getCurrentDPV().getDetailsMenu();
            this.viewDetails.getMenu().setMnemonic(MenuUtils.getMnemonicKey(Messages.getString("ControllerApplication.ViewDetails")));
            Component[] comps = dm.getMenuComponents();
            for (int i = 0; i < comps.length; ++i) {
                Component c = comps[i];
                if (c instanceof JMenuItem) {
                    this.viewDetails.getMenu().add(c);
                    continue;
                }
                if (!(c instanceof JSeparator)) continue;
                this.viewDetails.getMenu().addSeparator();
            }
        }
    }

    private boolean isBarkerNotationEnabled() {
        if (this.getApplicationView().getCurrentDPV() != null) {
            return this.getApplicationView().getCurrentDPV() instanceof DPVLogical && this.getApplicationView().getCurrentDPV().getNotation() != 1;
        }
        return false;
    }

    private boolean isBachmanNotationEnabled() {
        if (this.getApplicationView().getCurrentDPV() != null) {
            return this.getApplicationView().getCurrentDPV() instanceof DPVLogical && this.getApplicationView().getCurrentDPV().getNotation() != 0;
        }
        return false;
    }

    private boolean isIENotationEnabled() {
        if (this.getApplicationView().getCurrentDPV() != null) {
            return this.getApplicationView().getCurrentDPV() instanceof DPVLogical && this.getApplicationView().getCurrentDPV().getNotation() != 2;
        }
        return false;
    }

    public ExitApplication getExitAction() {
        return this.exitAction;
    }

    public MDBAction getOpenDesignAction() {
        return this.openDesign;
    }

    public MDBAction getCloseDesignAction() {
        return this.closeDesign;
    }

    public MDBAction getCloseAllDesignsAction() {
        return this.closeAllDesigns;
    }

    public MDBAction getSaveDesignAction() {
        return this.saveAll;
    }

    public MDBAction getSaveAsAction() {
        return this.saveAs;
    }

    public MDBAction getPrintAction() {
        return this.printDialog;
    }

    public MDBAction getPageSetupAction() {
        return this.pageSetup;
    }

    public MDBAction getExportToImageAction() {
        return this.exportToImage;
    }

    public MDBAction getExportToPDFAction() {
        return this.exportToPDF;
    }

    public MDBAction getExportToReportingSchemaAction() {
        return this.exportToReports;
    }

    public MDBAction getShowDDLAction() {
        return this.showDDL;
    }

    public MDBAction getDDLEditorAction() {
        return this.ddlEditor;
    }

    public MDBAction getImportDDLAction() {
        return this.importDDL;
    }

    public MDBAction getImportCubeViewsAction() {
        return this.importCubeViews;
    }

    public MDBAction getImportVARAction() {
        return this.importVAR;
    }

    public MDBAction getImportXMLAAction() {
        return this.importXMLA;
    }

    public MDBAction getImportERwin4Action() {
        return this.importERwin4;
    }

    public MDBAction getImportERwin7Action() {
        return this.importERwin7;
    }

    public MDBAction getImportMDAction() {
        return this.importMD;
    }

    public MDBAction getImportODAction() {
        return this.importOD;
    }

    public MDBAction getImportOSDMAction() {
        return this.importCWD;
    }

    public MDBAction getImportDomainsAction() {
        return this.importDomains;
    }

    public MDBAction getExportToOracleAWAction() {
        return this.exportOracleAW;
    }

    public MDBAction getExportToCWD4ALL() {
        return this.exportToCWD;
    }

    public MDBAction getExportToCSV() {
        return this.exportToCSV;
    }

    public MDBAction getExportAsXMLAAction() {
        return this.exportXMLA;
    }

    public MDBAction getExportCubeViewsAction() {
        return this.exportCubeViews;
    }

    public MDBAction getExportDDLAction() {
        return this.exportDDL;
    }

    public MDBAction geDesignRulesAction() {
        return this.designRules;
    }

    public MDBAction getCustomDesignRulesAction() {
        return this.customDesignRules;
    }

    public MDBAction getCustomLibrariesAction() {
        return this.customLibraries;
    }

    public MDBAction getTransformationsAction() {
        return this.customTransformations;
    }

    public MDBAction getTableDDLTransformationsAction() {
        return this.tableDDLTransformations;
    }

    public MDBAction getCompareAction() {
        return this.compareModels;
    }

    public MDBAction getDomainsAdminAction() {
        return this.domainsAdmin;
    }

    public MDBAction getMaskTemplatesAdministration() {
        return this.maskTemplatesAdministration;
    }

    public MDBAction getTypesAdminAction() {
        return this.typesAdmin;
    }

    public MDBAction getRDBMSAdminAction() {
        return this.rdbmsAdmin;
    }

    public MDBAction getT2VWizardAction() {
        return this.t2vWizard;
    }

    public MDBAction getV2TWizardAction() {
        return this.v2tWizard;
    }

    public MDBAction getTypesToDomainsWizardAction() {
        return this.typesToDomainsWizard;
    }

    public MDBAction getNamesStandardizationAction() {
        return this.namesStandardization;
    }

    public MDBAction getGlossaryEditorAction() {
        return this.glossaryEditor;
    }

    public MDBAction getCopyAction() {
        return this.copyAction;
    }

    public MDBAction getPasteAction() {
        return this.pasteAction;
    }

    public MDBAction getDeleteAction() {
        return this.deleteAction;
    }

    public MDBAction getShowEditorAction() {
        return this.showEditor;
    }

    public OpenStorageDesign getOpenStorageDesignAction() {
        return this.openStorageDesign;
    }

    public CloseStorageDesign getCloseStorageDesignAction() {
        return this.closeStorageDesign;
    }

    public MDBAction getAlignLeftAction() {
        return this.alignLeft;
    }

    public MDBAction getAlignTopAction() {
        return this.alignTop;
    }

    public MDBAction getEqualWidthAction() {
        return this.equalWidth;
    }

    public MDBAction getEqualHeightAction() {
        return this.equalHeight;
    }

    public MDBAction getShowBarkerNotationAction() {
        return this.showBarkerNotation;
    }

    public MDBAction getShowBachmanNotationAction() {
        return this.showBachmanNotation;
    }

    public MDBAction getShowIENotationAction() {
        return this.showIENotation;
    }

    public MDBAction getExternalLogAction() {
        return this.externalLog;
    }

    public MDBAction getZoomInAction() {
        return this.zoomIn;
    }

    public MDBAction getZoomOutAction() {
        return this.zoomOut;
    }

    public MDBAction getFitScreenAction() {
        return this.fitScreen;
    }

    public MDBAction getActualSizeAction() {
        return this.actualSize;
    }

    public MDBAction getSearchAction() {
        return this.search;
    }

    public MDBAction getGlobalSearchAction() {
        return this.globalSearch;
    }

    public MDBAction getViewDetails() {
        return this.viewDetails;
    }

    public ShowReports getShowReports() {
        return this.showReports;
    }

    public PendingChanges getPendingChanges() {
        return this.pendingChanges;
    }

    public FileNavigator getFileNavigator() {
        return this.fileNavigator;
    }

    public SSHNavigator getSSHNavigator() {
        return this.sshNavigator;
    }

    public MDBAction getFixedNamesAdminAction() {
        return this.fixedNamesAdministration;
    }

    private boolean canAlign() {
        boolean result = false;
        if (this.getApplicationView().getCurrentDPV() != null) {
            if (this.getApplicationView().getCurrentDPV().getRepositoryOID() != null) {
                if (!this.getApplicationView().getCurrentDPV().getDesignPart().isCheckedOutByMe()) {
                    return false;
                }
                result = ApplicationView.LOGICAL_MODEL_ONLY && !(this.getApplicationView().getCurrentDPV() instanceof DPVLogical) ? false : this.getApplicationView().getCurrentDPV().getWorkSpace().canAlign();
            } else {
                result = this.getApplicationView().getCurrentDPV().getWorkSpace().canAlign();
            }
        }
        return result;
    }

    private boolean canCopy() {
        if (this.getApplicationView().getCurrentDPV() != null) {
            if (this.getApplicationView().getCurrentDPV().getRepositoryOID() != null) {
                if (!this.getApplicationView().getCurrentDPV().getDesignPart().isCheckedOutByMe()) {
                    return false;
                }
                if (ApplicationView.LOGICAL_MODEL_ONLY && !(this.getApplicationView().getCurrentDPV() instanceof DPVLogical)) {
                    return false;
                }
                SelectableObject selected = this.getApplicationView().getCurrentDPV().getCurrentSelection();
                return selected != null && selected.getSelectedDesignObject() != null && selected.getSelectedDesignObject().canCopy();
            }
            SelectableObject selected = this.getApplicationView().getCurrentDPV().getCurrentSelection();
            return selected != null && selected.getSelectedDesignObject() != null && selected.getSelectedDesignObject().canCopy();
        }
        return false;
    }

    private boolean canDelete() {
        if (this.getApplicationView().getCurrentDPV() != null) {
            if (this.getApplicationView().getCurrentDPV().getRepositoryOID() != null) {
                if (!this.getApplicationView().getCurrentDPV().getDesignPart().isCheckedOutByMe()) {
                    return false;
                }
                if (ApplicationView.LOGICAL_MODEL_ONLY && !(this.getApplicationView().getCurrentDPV() instanceof DPVLogical)) {
                    return false;
                }
                SelectableObject selected = this.getApplicationView().getCurrentDPV().getCurrentSelection();
                return selected != null && selected.getSelectedDesignObject() != null;
            }
            SelectableObject selected = this.getApplicationView().getCurrentDPV().getCurrentSelection();
            return selected != null && selected.getSelectedDesignObject() != null;
        }
        return false;
    }

    @Override
    public boolean canPaste() {
        if (this.getApplicationView().getCurrentDPV() != null) {
            if (this.getApplicationView().getCurrentDPV().getRepositoryOID() != null) {
                if (!this.getApplicationView().getCurrentDPV().getDesignPart().isCheckedOutByMe()) {
                    return false;
                }
                if (ApplicationView.LOGICAL_MODEL_ONLY && !(this.getApplicationView().getCurrentDPV() instanceof DPVLogical)) {
                    return false;
                }
                return this.getApplicationView().getCurrentDPV().getController().canPaste();
            }
            return this.getApplicationView().getCurrentDPV().getController().canPaste();
        }
        return false;
    }

    private boolean checkSelected() {
        Object selected;
        TreePath path;
        Object selected2;
        boolean result = false;
        if (this.getApplicationView().getCurrentDPV() != null && this.getApplicationView().getCurrentDPV().getCurrentSelection() != null && (selected2 = this.getApplicationView().getCurrentDPV().getCurrentSelection().getSelectedObject()) instanceof DesignObject) {
            result = true;
        }
        if (!result && this.getApplicationView().getBrowserPanel() != null && (path = this.getApplicationView().getBrowserPanel().getJTree().getSelectionPath()) != null && (selected = path.getLastPathComponent()) instanceof DesignObject) {
            result = true;
        }
        return result;
    }

    private boolean hasRelationalModels() {
        return this.getDesign().getRelationalDesigns().size() > 0;
    }

    private boolean hasDDL() {
        Object selected;
        boolean result = false;
        if (this.getApplicationView().getCurrentDPV() != null && this.getApplicationView().getCurrentDPV().getCurrentSelection() != null && ((selected = this.getApplicationView().getCurrentDPV().getCurrentSelection().getSelectedObject()) instanceof Table || selected instanceof TableView || selected instanceof Index && !((Index)selected).isPK())) {
            result = true;
        }
        return result;
    }

    public Recent getEmptyRecent() {
        return this.emptyRecent;
    }

    class SSHNavigator
    extends MDBAction {
        private SSHNavigator() {
            super(AbstractController.SSH_NAVIGATOR_CAPTION, ControllerApplication.this.getConfiguration().getIcon("CONNECTIONS_FOLDER_ICON", ControllerApplication.this.getPreferredIconSize()));
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            SshNavigatorManager.getInstance().getNavigatorWindow().show();
        }
    }

    class FileNavigator
    extends MDBAction {
        private FileNavigator() {
            super(AbstractController.FILE_NAVIGATOR_CAPTION, ControllerApplication.this.getConfiguration().getIcon("FILES_ICON", ControllerApplication.this.getPreferredIconSize()));
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            FileNavigatorWrapper.getInstance().showWindow();
        }
    }

    class PendingChanges
    extends MDBAction {
        private PendingChanges() {
            super(MenuUtils.getMnemonicStr(AbstractController.PENDING_CHANGES_CAPTION));
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.PENDING_CHANGES_CAPTION));
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            if (Extension.isSVNExtensionLoaded()) {
                SVNStatusCommand.showSvnChangeListWindow();
            }
        }
    }

    class ShowReports
    extends MDBAction {
        private ReportsGenerationDialog reportsDialog;

        private ShowReports() {
            super(MenuUtils.getMnemonicStr(AbstractController.REPORTS_CAPTION));
            this.setMenuPath(REPORTS_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.REPORTS_CAPTION));
            this.setAccelerator(KeyStroke.getKeyStroke(82, 576, false));
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            this.execute();
        }

        public void execute() {
            try {
                this.reportsDialog = new ReportsGenerationDialog(ControllerApplication.this.getApplicationView(), new HashMap());
                this.reportsDialog.showDialog();
            }
            catch (Throwable error) {
                LOGGER.error("Error in Reports generation", error);
            }
        }
    }

    class ObjectNamesAdministration
    extends MDBAction {
        private ObjectNamesAdmin objectNamesAdmin;

        ObjectNamesAdministration() {
            super(MenuUtils.getMnemonicStr(AbstractController.FN_CAPTION), ControllerApplication.this.getConfiguration().getIcon("NAMES_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(TOOLS_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.FN_CAPTION));
            this.setAccelerator(KeyStroke.getKeyStroke(79, 576, false));
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            Design design = ControllerApplication.this.getApplicationView().selectDesign();
            if (design != null) {
                ControllerApplication.this.getApplicationView().setCurrentDesign(design);
                this.execute();
            }
        }

        @Override
        public boolean addSeparatorBefore() {
            return true;
        }

        public void execute() {
            try {
                this.objectNamesAdmin = new ObjectNamesAdmin(ControllerApplication.this.getApplicationView());
                this.objectNamesAdmin.showDialog();
            }
            catch (Throwable error) {
                LOGGER.error("Error in objects name administration", error);
            }
        }
    }

    class GlossaryEditor
    extends MDBAction {
        private GlossaryEditor() {
            super(MenuUtils.getMnemonicStr(AbstractController.GLOSSARY_CAPTION), ControllerApplication.this.getConfiguration().getIcon("NAMES_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(TOOLS_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.GLOSSARY_CAPTION));
            this.setAccelerator(KeyStroke.getKeyStroke(89, 576, false));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doActionPerformed(ActionEvent e) {
            block10: {
                try {
                    URLFilter glossaryFilter = new URLFilter(){

                        public boolean accept(URL url) {
                            File file = new File(url.getPath());
                            return file.getName().toLowerCase().endsWith(".glossary") || file.isDirectory();
                        }

                        public String toString() {
                            return Messages.getString("ControllerApplication.GlossaryFiles");
                        }
                    };
                    URLFileChooser fileChooser = new URLFileChooser();
                    fileChooser.clearChooseableURLFilters();
                    fileChooser.setSelectionScope(0);
                    fileChooser.setSelectionMode(0);
                    fileChooser.setShowJarsAsDirs(false);
                    fileChooser.setURLFilter(glossaryFilter);
                    fileChooser.setPathContext("dataModeler_Glossary");
                    String lastDir = ControllerApplication.this.getApplicationView().getSettings().getDefaultImportPath();
                    if (lastDir != null) {
                        fileChooser.setSelectedURL(URLFactory.newDirURL((String)lastDir));
                    } else {
                        URL url = ControllerApplication.this.getApplicationView().getUserHomeDirectory();
                        if (url != null) {
                            fileChooser.setSelectedURL(url);
                        }
                    }
                    int status = fileChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString("ControllerApplication.SelectGlossaryFile"));
                    if (status != 0) break block10;
                    Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(3));
                    try {
                        Glossary glossary;
                        File selected = new File(fileChooser.getSelectedURL().getPath());
                        String fname = selected.getName().toLowerCase();
                        if (!fname.endsWith(".glossary") && !fname.endsWith(".glossary")) {
                            selected = new File(selected.getPath() + ".glossary");
                        }
                        if ((glossary = new Glossary(selected)).getLoadError() == 0) {
                            GlossaryDialog dialog = new GlossaryDialog(ControllerApplication.this.getApplicationView().getFrame(), glossary);
                            dialog.showDialog();
                        }
                    }
                    finally {
                        Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
                catch (Throwable error) {
                    LOGGER.error("Error Importing XMI File!", error);
                }
            }
        }
    }

    class ExportDDLFile
    extends MDBAction {
        private ExportDDLFile() {
            super(MenuUtils.getMnemonicStr(Messages.getString("ControllerApplication.DDLFile")), ControllerApplication.this.getConfiguration().getIcon("DDL_FILE_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(EXPORT_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(Messages.getString("ControllerApplication.DDLFile")));
            this.setAccelerator(KeyStroke.getKeyStroke(69, 64, false));
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            RelationalDesign design = ControllerApplication.this.getApplicationView().selectRelationalDesign();
            if (design != null) {
                ControllerApplication.this.getDesign().setRelationalDesign(design);
                ControllerApplication.this.getApplicationView().setDDLFileMakerEditorVisible(true);
            }
        }
    }

    class ShowIENotation
    extends MDBAction {
        public ShowIENotation() {
            super(MenuUtils.getMnemonicStr(Messages.getString("ControllerApplication.IENotation")));
            this.setMenuPath(LOGICAL_DIAGRAM_NOTATION_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(Messages.getString("ControllerApplication.IENotation")));
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            DesignPartView dpv;
            if (ControllerApplication.this.getApplicationView().getCurrentDPV() != null && (dpv = ControllerApplication.this.getApplicationView().getCurrentDPV()).getNotation() != 2) {
                dpv.setNotation(2);
                dpv.updateDiagramSettings();
            }
        }
    }

    class ShowBachmanNotation
    extends MDBAction {
        public ShowBachmanNotation() {
            super(MenuUtils.getMnemonicStr(Messages.getString("ControllerApplication.BachmanNotation")));
            this.setMenuPath(LOGICAL_DIAGRAM_NOTATION_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(Messages.getString("ControllerApplication.BachmanNotation")));
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            DesignPartView dpv;
            if (ControllerApplication.this.getApplicationView().getCurrentDPV() != null && (dpv = ControllerApplication.this.getApplicationView().getCurrentDPV()).getNotation() != 0) {
                dpv.setNotation(0);
                dpv.updateDiagramSettings();
            }
        }
    }

    class ShowBarkerNotation
    extends MDBAction {
        public ShowBarkerNotation() {
            super(MenuUtils.getMnemonicStr(Messages.getString("ControllerApplication.BarkerNotation")));
            this.setMenuPath(LOGICAL_DIAGRAM_NOTATION_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(Messages.getString("ControllerApplication.BarkerNotation")));
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            DesignPartView dpv;
            if (ControllerApplication.this.getApplicationView().getCurrentDPV() != null && (dpv = ControllerApplication.this.getApplicationView().getCurrentDPV()).getNotation() != 1) {
                dpv.setNotation(1);
                dpv.updateDiagramSettings();
            }
        }
    }

    class ViewDetails
    extends MDBAction {
        public ViewDetails() {
            super(MenuUtils.getMnemonicStr(Messages.getString("ControllerApplication.ViewDetails")));
            this.setMenuPath(VIEW_PATH);
        }

        @Override
        public boolean isPopupMenu() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
        }
    }

    public class Recent
    extends MDBAction {
        private String designName;
        private String designPath;

        public Recent() {
            super("EMPTY", ControllerApplication.this.getConfiguration().getIcon("RECENT_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(RECENT_PATH);
        }

        public void setDesignName(String designName) {
            this.designName = designName;
            this.setName(designName);
        }

        public void setDesignPath(String designPath) {
            this.designPath = designPath;
        }

        public String getDesignName() {
            return this.designName;
        }

        public String getDesignPath() {
            return this.designPath;
        }

        @Override
        public String getToolTipText() {
            return this.designPath;
        }

        private String getFileExt() {
            for (int i = 0; i < XMLConstants.DESIGN_EXTENSIONS.length; ++i) {
                String ext = XMLConstants.DESIGN_EXTENSIONS[i];
                File file = new File(this.designPath, this.designName + ext);
                if (!file.exists()) continue;
                return ext;
            }
            return null;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            Thread thread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    block17: {
                        try {
                            int mb = 0x100000;
                            Runtime runtime = Runtime.getRuntime();
                            System.out.println("open design begin memory  total  " + runtime.totalMemory() / (long)mb + "  /memory  fre  " + runtime.freeMemory() / (long)mb + "  /used memory  " + (runtime.totalMemory() - runtime.freeMemory()) / (long)mb);
                            if (Recent.this.designName == null || Recent.this.designPath == null) break block17;
                            Design design = ControllerApplication.this.findDesign(Recent.this.designPath + "/" + Recent.this.designName);
                            if (design != null) {
                                MessageDialogs.showWarningMessage("Design: '" + Recent.this.designName + "' is already opened.");
                                ControllerApplication.this.getApplicationView().getBrowserPanel().expandToPath(design.getPath());
                                return;
                            }
                            String ext = Recent.this.getFileExt();
                            if (ext != null) {
                                Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(3));
                                try {
                                    if (ControllerApplication.this.getApplicationView().getDesigns().size() > 1 || !ControllerApplication.this.designIsEmpty()) {
                                        design = ControllerApplication.this.getApplicationView().addDesign(true);
                                        ControllerApplication.this.getApplicationView().setCurrentDesign(design);
                                    }
                                    ControllerApplication.this.getApplicationView().getCurrentDesign().setDesignPath(Recent.this.designPath);
                                    ControllerApplication.this.getApplicationView().getCurrentDesign().setFileName(Recent.this.designName);
                                    ControllerApplication.this.getApplicationView().getCurrentDesign().setOldRepositoryType(".xml".equalsIgnoreCase(ext));
                                    ControllerApplication.this.getApplicationView().getCurrentDesign().setCompressedDesign(".dmdz".equalsIgnoreCase(ext));
                                    ApplicationView.loading = true;
                                    try {
                                        ControllerApplication.this.getApplicationView().enableControls(false);
                                        try {
                                            ApplicationView.log(MessageFormat.format(Messages.getString("ControllerApplication.OpenDesignP"), Recent.this.designName));
                                            ApplicationView.canLogging = false;
                                            design = ControllerApplication.this.getDesign();
                                            if (design.openDesign(Recent.this.designName, ext)) {
                                                if (Extension.isSVNExtensionLoaded() && !design.isOldRepositoryType()) {
                                                    SVNClientHelper.getInstance().checkVersioned(design);
                                                    SVNChangeListWindow.addToScope(design);
                                                }
                                                ControllerApplication.this.getApplicationView().synchronizeTitle();
                                                ControllerApplication.this.getApplicationView().getSettings().removeRecent(Recent.this);
                                                ControllerApplication.this.getApplicationView().getSettings().addRecent(Recent.this);
                                                ControllerApplication.this.getApplicationView().getBrowserPanel().expandToPath(ControllerApplication.this.getDesign().getPath());
                                            }
                                            ApplicationView.canLogging = true;
                                            ApplicationView.log(MessageFormat.format(Messages.getString("ControllerApplication.OpenDesignP"), Messages.getString("OpenDesignDialog.OK")));
                                        }
                                        finally {
                                            System.out.println("open design END memory  total  " + runtime.totalMemory() / (long)mb + "  /memory  fre  " + runtime.freeMemory() / (long)mb + "  /used memory  " + (runtime.totalMemory() - runtime.freeMemory()) / (long)mb);
                                            ControllerApplication.this.getApplicationView().enableControls(true);
                                            ApplicationView.canLogging = true;
                                        }
                                    }
                                    finally {
                                        ApplicationView.loading = false;
                                    }
                                }
                                finally {
                                    Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(0));
                                }
                                if (Extension.isSVNExtensionLoaded()) {
                                    MergeConflictsDialog.getInstance().checkForConflicts(ControllerApplication.this.getDesign());
                                }
                                break block17;
                            }
                            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("ControllerApplication.DesignDoNotExist"), Recent.this.designName));
                        }
                        catch (Throwable error) {
                            LOGGER.error("Error Opening Design!", error);
                        }
                    }
                }
            };
            thread.start();
        }
    }

    class ExternalLog
    extends MDBAction {
        ExternalLog() {
            super(MenuUtils.getMnemonicStr(AbstractController.EXTERNAL_LOG_CAPTION), ControllerApplication.this.getConfiguration().getIcon("LOG_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(VIEW_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.EXTERNAL_LOG_CAPTION));
            this.setAccelerator(KeyStroke.getKeyStroke(69, 128));
        }

        @Override
        public boolean addSeparatorBefore() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            ExternalLogDialog.showExternalLog();
        }
    }

    class TypesToDomainsWizard
    extends MDBAction {
        TypesToDomainsWizard() {
            super(MenuUtils.getMnemonicStr(AbstractController.TYPES_TO_DOMAINS_WIZARD_CAPTION), ControllerApplication.this.getConfiguration().getIcon("TYPES_TO_DOMAINS_WIZARD_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(TOOLS_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.TYPES_TO_DOMAINS_WIZARD_CAPTION));
            this.setAccelerator(KeyStroke.getKeyStroke(80, 576, false));
        }

        @Override
        public boolean addSeparatorBefore() {
            return false;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            Design design = ControllerApplication.this.getApplicationView().selectDesign();
            if (design != null) {
                ControllerApplication.this.getApplicationView().setCurrentDesign(design);
                this.execute();
            }
        }

        public void execute() {
            new TypesToDomainsDialog(ControllerApplication.this.getApplicationView(), MenuUtils.getMnemonicStr(AbstractController.TYPES_TO_DOMAINS_WIZARD_CAPTION)).showDialog();
        }
    }

    class View2TableWizard
    extends MDBAction {
        private View2TableDialog view2TableDialog;

        View2TableWizard() {
            super(MenuUtils.getMnemonicStr(AbstractController.V2TW_CAPTION), ControllerApplication.this.getConfiguration().getIcon("VIEW_2_TABLE_WIZARD_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(TOOLS_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.V2TW_CAPTION));
            this.setAccelerator(KeyStroke.getKeyStroke(86, 576, false));
        }

        @Override
        public boolean addSeparatorBefore() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            Design design = ControllerApplication.this.getApplicationView().selectDesign();
            if (design != null) {
                ControllerApplication.this.getApplicationView().setCurrentDesign(design);
                this.execute();
            }
        }

        public void execute() {
            try {
                if (this.view2TableDialog == null) {
                    this.view2TableDialog = new View2TableDialog(ControllerApplication.this.getApplicationView(), MenuUtils.getMnemonicStr(AbstractController.V2TW_CAPTION));
                }
                this.view2TableDialog.showDialog();
            }
            catch (Throwable error) {
                LOGGER.error("Error in View2TableWizard", error);
            }
        }
    }

    class Table2ViewWizard
    extends MDBAction {
        private Table2ViewDialog table2ViewDialog;

        Table2ViewWizard() {
            super(MenuUtils.getMnemonicStr(AbstractController.T2VW_CAPTION), ControllerApplication.this.getConfiguration().getIcon("TABLE_2_VIEW_WIZARD_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(TOOLS_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.T2VW_CAPTION));
            this.setAccelerator(KeyStroke.getKeyStroke(65, 576, false));
        }

        @Override
        public boolean addSeparatorBefore() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            Design design = ControllerApplication.this.getApplicationView().selectDesign();
            if (design != null) {
                ControllerApplication.this.getApplicationView().setCurrentDesign(design);
                this.execute();
            }
        }

        public void execute() {
            try {
                if (this.table2ViewDialog == null) {
                    this.table2ViewDialog = new Table2ViewDialog(ControllerApplication.this.getApplicationView(), MenuUtils.getMnemonicStr(AbstractController.T2VW_CAPTION));
                }
                this.table2ViewDialog.showDialog();
            }
            catch (Throwable error) {
                LOGGER.error("Error in Table2ViewWizard", error);
            }
        }
    }

    class GlobalSearch
    extends MDBAction {
        private GlobalSearch() {
            super(MenuUtils.getMnemonicStr(Messages.getString("ControllerApplication.GlobalSearch")), ControllerApplication.this.getConfiguration().getIcon("SEARCH_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(VIEW_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(Messages.getString("ControllerApplication.GlobalSearch")));
            this.setAccelerator(KeyStroke.getKeyStroke(71, 128, false));
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            GlobalSearchDockable globalSearchDockable = null;
            DockStation dockStation = DockStation.getDockStation();
            Dockable dockable = dockStation.getDockable(GlobalSearchDockable.VIEW_ID);
            if (dockable == null) {
                globalSearchDockable = new GlobalSearchDockable();
                globalSearchDockable.show();
            } else if (dockable instanceof GlobalSearchDockable && !(globalSearchDockable = (GlobalSearchDockable)dockable).isVisible()) {
                dockStation.activateDockable((Dockable)globalSearchDockable);
            }
        }
    }

    class Search
    extends MDBAction {
        private Search() {
            super(MenuUtils.getMnemonicStr(Messages.getString("ControllerApplication.Find")), ControllerApplication.this.getConfiguration().getIcon("SEARCH_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(VIEW_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(Messages.getString("ControllerApplication.Find")));
            this.setAccelerator(KeyStroke.getKeyStroke(70, 128, false));
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            MDBAction acSearch;
            if (ControllerApplication.this.getApplicationView().getCurrentDPV() != null && (acSearch = ControllerApplication.this.getApplicationView().getCurrentDPV().getController().getFindAction()) != null) {
                acSearch.doActionPerformed(null);
            }
        }
    }

    class ActualSize
    extends MDBAction {
        private ActualSize() {
            super(MenuUtils.getMnemonicStr(Messages.getString("ControllerApplication.DefaultSize")), ControllerApplication.this.getConfiguration().getIcon("ACTUAL_SIZE_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(VIEW_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(Messages.getString("ControllerApplication.DefaultSize")));
            this.setAccelerator(KeyStroke.getKeyStroke(116, 0, false));
            this.setAllowedInToolbar(true);
        }

        @Override
        public boolean addSeparatorAfter() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            try {
                if (ControllerApplication.this.getApplicationView().getCurrentDPV() != null) {
                    ControllerLogical.ActualSize logical = ((ControllerLogical)ControllerApplication.this.getApplicationView().getDPVLogical().getController()).getDefaultSizeAction();
                    ControllerRelational.ActualSize physical = ((ControllerRelational)ControllerApplication.this.getApplicationView().getDPVRelational().getController()).getDefaultSizeAction();
                    if (ControllerApplication.this.getApplicationView().getCurrentDPV() == ControllerApplication.this.getApplicationView().getDPVLogical()) {
                        ((MDBAction)logical).doActionPerformed(null);
                    } else {
                        ((MDBAction)physical).doActionPerformed(null);
                    }
                }
            }
            catch (Throwable error) {
                LOGGER.error("Error setting Actual Size!", error);
            }
        }
    }

    class FitScreen
    extends MDBAction {
        private FitScreen() {
            super(MenuUtils.getMnemonicStr(Messages.getString("ControllerApplication.FitScreen")), ControllerApplication.this.getConfiguration().getIcon("FIT_SCREEN_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(VIEW_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(Messages.getString("ControllerApplication.FitScreen")));
            this.setAccelerator(KeyStroke.getKeyStroke(119, 0, false));
            this.setAllowedInToolbar(true);
        }

        @Override
        public boolean addSeparatorAfter() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            try {
                if (ControllerApplication.this.getApplicationView().getCurrentDPV() != null) {
                    ControllerLogical.FitScreen logical = ((ControllerLogical)ControllerApplication.this.getApplicationView().getDPVLogical().getController()).getFitScreenAction();
                    ControllerRelational.FitScreen physical = ((ControllerRelational)ControllerApplication.this.getApplicationView().getDPVRelational().getController()).getFitScreenAction();
                    if (ControllerApplication.this.getApplicationView().getCurrentDPV() == ControllerApplication.this.getApplicationView().getDPVLogical()) {
                        ((MDBAction)logical).doActionPerformed(null);
                    } else {
                        ((MDBAction)physical).doActionPerformed(null);
                    }
                }
            }
            catch (Throwable error) {
                LOGGER.error("Error Fit Screen!", error);
            }
        }
    }

    class ZoomOut
    extends MDBAction {
        private ZoomOut() {
            super(MenuUtils.getMnemonicStr(Messages.getString("ControllerApplication.ZoomOut")), ControllerApplication.this.getConfiguration().getIcon("ZOOM_OUT_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(VIEW_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(Messages.getString("ControllerApplication.ZoomOut")));
            this.setAccelerator(KeyStroke.getKeyStroke(118, 0, false));
            this.setAllowedInToolbar(true);
        }

        @Override
        public boolean addSeparatorAfter() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            try {
                if (ControllerApplication.this.getApplicationView().getCurrentDPV() != null) {
                    ControllerLogical.ZoomOut logical = ((ControllerLogical)ControllerApplication.this.getApplicationView().getDPVLogical().getController()).getZoomOutAction();
                    ControllerRelational.ZoomOut physical = ((ControllerRelational)ControllerApplication.this.getApplicationView().getDPVRelational().getController()).getZoomOutAction();
                    if (ControllerApplication.this.getApplicationView().getCurrentDPV() == ControllerApplication.this.getApplicationView().getDPVLogical()) {
                        ((MDBAction)logical).doActionPerformed(null);
                    } else {
                        ((MDBAction)physical).doActionPerformed(null);
                    }
                }
            }
            catch (Throwable error) {
                LOGGER.error("Error Zooming out!", error);
            }
        }
    }

    class ZoomIn
    extends MDBAction {
        private ZoomIn() {
            super(MenuUtils.getMnemonicStr(Messages.getString("ControllerApplication.ZoomIn")), ControllerApplication.this.getConfiguration().getIcon("ZOOM_IN_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(VIEW_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(Messages.getString("ControllerApplication.ZoomIn")));
            this.setAccelerator(KeyStroke.getKeyStroke(117, 0, false));
            this.setAllowedInToolbar(true);
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            try {
                if (ControllerApplication.this.getApplicationView().getCurrentDPV() != null) {
                    ControllerLogical.ZoomIn logical = ((ControllerLogical)ControllerApplication.this.getApplicationView().getDPVLogical().getController()).getZoomInAction();
                    ControllerRelational.ZoomIn physical = ((ControllerRelational)ControllerApplication.this.getApplicationView().getDPVRelational().getController()).getZoomInAction();
                    if (ControllerApplication.this.getApplicationView().getCurrentDPV() == ControllerApplication.this.getApplicationView().getDPVLogical()) {
                        ((MDBAction)logical).doActionPerformed(null);
                    } else {
                        ((MDBAction)physical).doActionPerformed(null);
                    }
                }
            }
            catch (Throwable error) {
                LOGGER.error("Error Zooming in!", error);
            }
        }
    }

    class SaveAs
    extends MDBAction {
        protected int operation;

        private SaveAs() {
            super(MenuUtils.getMnemonicStr(AbstractController.SAVE_AS_CAPTION), ControllerApplication.this.getConfiguration().getIcon("SAVE_AS_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.operation = 4;
            this.setMenuPath(FILE_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.SAVE_AS_CAPTION));
            this.setAccelerator(KeyStroke.getKeyStroke(83, 192, false));
        }

        private SaveAs(String name, Icon icon) {
            super(name, icon);
            this.operation = 4;
        }

        @Override
        public boolean addSeparatorAfter() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            Design design = ControllerApplication.this.getApplicationView().selectDesign();
            if (design != null) {
                ControllerApplication.this.getApplicationView().setCurrentDesign(design);
                this.execute();
            }
        }

        public void execute() {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    ControllerApplication.this.saveAsDesign(SaveAs.this.operation);
                }
            };
            thread.start();
        }
    }

    class ExportToCWD
    extends SaveAs {
        private ExportToCWD() {
            super(MenuUtils.getMnemonicStr(Messages.getString("ControllerApplication.ToDataModelerDesign")), ControllerApplication.this.getConfiguration().getIcon("APPLICATION_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.operation = 5;
            this.setMenuPath(EXPORT_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(Messages.getString("ControllerApplication.ToDataModelerDesign")));
        }

        @Override
        public boolean addSeparatorAfter() {
            return true;
        }
    }

    class Delete
    extends MDBAction {
        private Delete() {
            super(MenuUtils.getMnemonicStr(Messages.getString("ControllerApplication.Delete")), ControllerApplication.this.getConfiguration().getIcon("DELETE_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(EDIT_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(Messages.getString("ControllerApplication.Delete")));
            this.setAccelerator(KeyStroke.getKeyStroke(127, 0, false));
            this.setEnabled(false);
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            ControllerApplication.this.getApplicationView().getCurrentDPV().getWorkSpace().deleteAllSelected();
        }
    }

    class Paste
    extends MDBAction {
        private Paste() {
            super(MenuUtils.getMnemonicStr(Messages.getString("ControllerApplication.Paste")), ControllerApplication.this.getConfiguration().getIcon("PASTE_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(EDIT_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(Messages.getString("ControllerApplication.Paste")));
            this.setAccelerator(KeyStroke.getKeyStroke(86, 128, false));
            this.setEnabled(false);
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            if (ControllerApplication.this.getApplicationView().getCurrentDPV() != null) {
                ControllerApplication.this.getApplicationView().getCurrentDPV().getController().paste(null);
            }
        }
    }

    class Copy
    extends MDBAction {
        private Copy() {
            super(MenuUtils.getMnemonicStr(Messages.getString("ControllerApplication.Copy")), ControllerApplication.this.getConfiguration().getIcon("COPY_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(EDIT_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(Messages.getString("ControllerApplication.Copy")));
            this.setAccelerator(KeyStroke.getKeyStroke(67, 128, false));
            this.setEnabled(false);
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            ControllerApplication.this.getApplicationView().clearCopiedObjects();
            Object[] selectedObjects = ControllerApplication.this.getApplicationView().getCurrentDPV().getSelectedObjects();
            for (int i = 0; i < selectedObjects.length; ++i) {
                if (!(selectedObjects[i] instanceof DesignObject)) continue;
                ControllerApplication.this.getApplicationView().addCopiedObject((DesignObject)selectedObjects[i]);
            }
        }
    }

    class ExportToPDF
    extends MDBAction {
        ExportToPDF() {
            super(MenuUtils.getMnemonicStr(AbstractController.TO_PDF_CAPTION), ControllerApplication.this.getConfiguration().getIcon("EXPORT_TO_IMAGE", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(EXPORT_DIAGRAM_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.TO_PDF_CAPTION));
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            Thread thread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    block13: {
                        try {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException ie) {
                                // empty catch block
                            }
                            Diagram diagram = (Diagram)ControllerApplication.this.getApplicationView().getSelectedWorkSpaceComponent();
                            if (diagram == null) break block13;
                            Object[] selection = diagram.getSelectionCells();
                            try {
                                diagram.clearSelection();
                                diagram.setCursor(Cursor.getPredefinedCursor(3));
                                try {
                                    Dimension size = diagram.getPreferredScrollableViewportSize();
                                    if (size.height <= 0 || size.width <= 0) {
                                        JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), new Object[]{Messages.getString("ControllerApplication.NoPrintableArea")}, Messages.getString("ControllerApplication.Information"), 2);
                                        return;
                                    }
                                    new PDFExporter(ControllerApplication.this.getApplicationView()).export(diagram);
                                }
                                finally {
                                    diagram.setCursor(Cursor.getPredefinedCursor(0));
                                }
                            }
                            finally {
                                diagram.setSelectionCells(selection);
                            }
                        }
                        catch (Throwable error) {
                            LOGGER.error("Error Printing to PDF File!", error);
                        }
                    }
                }
            };
            thread.setPriority(10);
            thread.start();
        }
    }

    class ExportToImage
    extends MDBAction {
        ExportToImage() {
            super(MenuUtils.getMnemonicStr(AbstractController.TO_IMAGE_CAPTION), ControllerApplication.this.getConfiguration().getIcon("EXPORT_TO_IMAGE", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(EXPORT_DIAGRAM_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.TO_IMAGE_CAPTION));
        }

        @Override
        public boolean addSeparatorAfterInRoot() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            Thread thread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    block13: {
                        try {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException ie) {
                                // empty catch block
                            }
                            Diagram diagram = (Diagram)ControllerApplication.this.getApplicationView().getSelectedWorkSpaceComponent();
                            if (diagram == null) break block13;
                            Object[] selection = diagram.getSelectionCells();
                            try {
                                diagram.clearSelection();
                                diagram.setCursor(Cursor.getPredefinedCursor(3));
                                try {
                                    Dimension size = diagram.getPreferredScrollableViewportSize();
                                    if (size.height <= 0 || size.width <= 0) {
                                        JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), new Object[]{Messages.getString("ControllerApplication.NoPrintableArea")}, Messages.getString("ControllerApplication.Information"), 2);
                                        return;
                                    }
                                    new ImageExporter(ControllerApplication.this.getApplicationView()).export(diagram);
                                }
                                finally {
                                    diagram.setCursor(Cursor.getPredefinedCursor(0));
                                }
                            }
                            finally {
                                diagram.setSelectionCells(selection);
                            }
                        }
                        catch (Throwable error) {
                            LOGGER.error("Error Printing to Image File!", error);
                        }
                    }
                }
            };
            thread.setPriority(10);
            thread.start();
        }
    }

    class CompareModels
    extends MDBAction {
        CompareModels() {
            super(MenuUtils.getMnemonicStr(AbstractController.CM_CAPTION), ControllerApplication.this.getConfiguration().getIcon("COMPARE_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(TOOLS_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.CM_CAPTION));
            this.setAccelerator(KeyStroke.getKeyStroke(77, 576, false));
        }

        @Override
        public boolean addSeparatorBefore() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            Design design = ControllerApplication.this.getApplicationView().selectDesign();
            if (design != null) {
                ControllerApplication.this.getApplicationView().setCurrentDesign(design);
                this.execute();
            }
        }

        public void execute() {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    try {
                        URLFilter fileFilter = new URLFilter(){

                            public boolean accept(URL url) {
                                File file = new File(url.getPath());
                                return file.getName().toLowerCase().endsWith(".dmd") || file.getName().toLowerCase().endsWith(".dmdz") || file.getName().toLowerCase().endsWith(".xml") || file.isDirectory();
                            }

                            public String toString() {
                                return Messages.getString("ControllerApplication.OracleSQLDeveloperModelingDesigns");
                            }
                        };
                        URLFileChooser fileChooser = new URLFileChooser();
                        fileChooser.clearChooseableURLFilters();
                        fileChooser.setSelectionScope(0);
                        fileChooser.setSelectionMode(0);
                        fileChooser.setShowJarsAsDirs(false);
                        fileChooser.setURLFilter(fileFilter);
                        fileChooser.setPathContext("dataModeler_OpenDesign");
                        String lastDir = ControllerApplication.this.getApplicationView().getSettings().getDefaultDesignsPath();
                        if (lastDir != null) {
                            fileChooser.setSelectedURL(URLFactory.newDirURL((String)lastDir));
                        } else {
                            URL url = ControllerApplication.this.getApplicationView().getUserHomeDirectory();
                            if (url != null) {
                                fileChooser.setSelectedURL(url);
                            }
                        }
                        ModelChooserDialog wizard = new ModelChooserDialog(ControllerApplication.this.getApplicationView(), new File("D://"));
                        wizard.setVisible(true);
                    }
                    catch (Throwable error) {
                        LOGGER.error("Error Importing Oracle SQL Developer Modeling Designer!", error);
                    }
                }
            };
            thread.start();
        }
    }

    class RDBMSSiteAdministration
    extends MDBAction {
        private RDBMSSiteEditor rdbmsSiteEditor;

        RDBMSSiteAdministration() {
            super(MenuUtils.getMnemonicStr(AbstractController.RDBMS_SITE_CAPTION), ControllerApplication.this.getConfiguration().getIcon("RDBMS_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(TOOLS_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.RDBMS_SITE_CAPTION));
            this.setAccelerator(KeyStroke.getKeyStroke(66, 576, false));
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            Design design = ControllerApplication.this.getApplicationView().selectDesign();
            if (design != null) {
                ControllerApplication.this.getApplicationView().setCurrentDesign(design);
                this.execute();
            }
        }

        public void execute() {
            try {
                this.rdbmsSiteEditor = new RDBMSSiteEditor(ControllerApplication.this.getApplicationView());
                if (!this.rdbmsSiteEditor.isDialogVisible()) {
                    this.rdbmsSiteEditor.showDialog();
                    this.rdbmsSiteEditor.refreshCurrentDesRDBMSSiteList();
                }
            }
            catch (Throwable error) {
                LOGGER.error("Error in RDBMSSiteEditor", error);
            }
        }
    }

    class TypesAdministration
    extends MDBAction {
        private TypesAdmin typesAdmin;

        TypesAdministration() {
            super(MenuUtils.getMnemonicStr(AbstractController.TA_CAPTION), ControllerApplication.this.getConfiguration().getIcon("TYPES_ADMIN_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(TOOLS_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.TA_CAPTION));
            this.setAccelerator(KeyStroke.getKeyStroke(84, 576, false));
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            try {
                this.typesAdmin = new TypesAdmin(ControllerApplication.this.getApplicationView());
                this.typesAdmin.showDialog();
            }
            catch (Throwable error) {
                LOGGER.error("Error in Types Administration", error);
            }
        }
    }

    class MaskTemplatesAdministration
    extends MDBAction {
        private MaskTemplatesAdmin maskTemplatesAdmin;

        MaskTemplatesAdministration() {
            super(MenuUtils.getMnemonicStr(AbstractController.MT_CAPTION), ControllerApplication.this.getConfiguration().getIcon("MASK_TEMPLATE_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(TOOLS_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.MT_CAPTION));
            this.setAccelerator(KeyStroke.getKeyStroke(83, 576, false));
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            this.execute();
        }

        public void execute() {
            try {
                this.maskTemplatesAdmin = new MaskTemplatesAdmin(ControllerApplication.this.getApplicationView());
                this.maskTemplatesAdmin.showDialog();
            }
            catch (Throwable error) {
                LOGGER.error("Error in Mask Templates Administration", error);
            }
        }
    }

    class DomainsAdministration
    extends MDBAction {
        private DomainAdmin domainAdmin;

        DomainsAdministration() {
            super(MenuUtils.getMnemonicStr(AbstractController.DA_CAPTION), ControllerApplication.this.getConfiguration().getIcon("DOMAIN_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(TOOLS_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.DA_CAPTION));
            this.setAccelerator(KeyStroke.getKeyStroke(68, 576, false));
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            Design design = ControllerApplication.this.getApplicationView().selectDesign();
            if (design != null) {
                ControllerApplication.this.getApplicationView().setCurrentDesign(design);
                this.execute();
            }
        }

        public void execute() {
            try {
                this.domainAdmin = new DomainAdmin(ControllerApplication.this.getApplicationView());
                this.domainAdmin.showDialog();
            }
            catch (Throwable error) {
                LOGGER.error("Error in Domains Administration", error);
            }
        }
    }

    class NamesStandardization
    extends MDBAction {
        NamesStandardization() {
            super(MenuUtils.getMnemonicStr(AbstractController.NS_CAPTION), ControllerApplication.this.getConfiguration().getIcon("NAMES_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(TOOLS_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.NS_CAPTION));
            this.setAccelerator(KeyStroke.getKeyStroke(78, 576, false));
        }

        @Override
        public boolean addSeparatorBefore() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            Design design = ControllerApplication.this.getApplicationView().selectDesign();
            if (design != null) {
                ControllerApplication.this.getApplicationView().setCurrentDesign(design);
                this.execute();
            }
        }

        public void execute() {
            try {
                NamesStandardizationDialog dialog = new NamesStandardizationDialog(ControllerApplication.this.getApplicationView());
                dialog.showDialog();
            }
            catch (Throwable error) {
                LOGGER.error("Error in Names Standardization!", error);
            }
        }
    }

    class RestoreLostMappings
    extends MDBAction {
        RestoreLostMappings() {
            super(Messages.getString("ControllerApplication.RestoreMappings"), ControllerApplication.this.getConfiguration().getIcon("NAMES_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(TOOLS_PATH);
        }

        @Override
        public boolean addSeparatorBefore() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            Design design = ControllerApplication.this.getApplicationView().selectDesign();
            if (design != null) {
                ControllerApplication.this.getApplicationView().setCurrentDesign(design);
                this.execute();
            }
        }

        public void execute() {
            try {
                RestoreMappings rm = new RestoreMappings(ControllerApplication.this.getDesign());
                rm.restore();
            }
            catch (Throwable error) {
                LOGGER.error("Error in Restore Mappings!", error);
            }
        }
    }

    public class SaveAll
    extends MDBAction {
        public SaveAll() {
            super(MenuUtils.getMnemonicStr(AbstractController.SAVE_DESIGN_CAPTION), ControllerApplication.this.getConfiguration().getIcon("SAVE_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(FILE_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.SAVE_DESIGN_CAPTION));
            this.setAccelerator(KeyStroke.getKeyStroke(83, 128, false));
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            Design design = ControllerApplication.this.getApplicationView().selectDesign();
            if (design != null) {
                if (design.isOldRepositoryType() || design.getLoadedVersion() < design.getVersion() && !design.canUpgradeInPlace()) {
                    JOptionPane.showOptionDialog((Component)Ide.getMainWindow(), oracle.dbtools.crest.model.Messages.getString("Design.ThisDesignIsInOldFormat"), oracle.dbtools.crest.model.Messages.getString("Design.Warning"), 0, 1, null, new String[]{oracle.dbtools.crest.model.Messages.getString("Design.OK")}, oracle.dbtools.crest.model.Messages.getString("Design.OK"));
                } else {
                    ControllerApplication.this.getApplicationView().setCurrentDesign(design);
                    this.execute();
                }
            }
        }

        public void execute() {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    try {
                        Design design = ControllerApplication.this.getDesign();
                        if (design.isNewDesign() || "".equalsIgnoreCase(ControllerApplication.this.getApplicationView().getCurrentDesign().getDesignPath())) {
                            ControllerApplication.this.saveAsDesign(4);
                        } else {
                            ControllerApplication.this.saveDesign(design);
                        }
                    }
                    catch (Throwable error) {
                        LOGGER.error("Error Save All!", error);
                    }
                }
            };
            thread.start();
        }
    }

    class CloseStorageDesign
    extends MDBAction {
        private CloseStorageDesign() {
            super(MenuUtils.getMnemonicStr(AbstractController.CLOSE_STORAGE_DESIGN_CAPTION), ControllerApplication.this.getConfiguration().getIcon("CLOSE_STORAGE_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(STORAGE_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.CLOSE_STORAGE_DESIGN_CAPTION));
            this.setAccelerator(KeyStroke.getKeyStroke(67, 576, false));
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            try {
                RelationalDesign relDesign = ControllerApplication.this.getApplicationView().selectRelationalDesign();
                if (relDesign != null) {
                    StorageDesign[] storageDesigns = relDesign.getStorageDesignFactory().getOpenStorageDesigns();
                    for (int i = 0; i < storageDesigns.length; ++i) {
                        StorageDesign storageDesign = storageDesigns[i];
                        if (!ControllerApplication.this.getApplicationView().closeStorageDesign(storageDesign)) continue;
                        ApplicationView.log(MessageFormat.format(Messages.getString("ControllerApplication.ClosePhysicalModel"), storageDesign.getName()));
                        storageDesign.close();
                    }
                }
            }
            catch (Throwable error) {
                LOGGER.error("Error Closing Storage Design!", error);
            }
        }
    }

    class OpenStorageDesign
    extends MDBAction {
        private OpenStorageDesign() {
            super(MenuUtils.getMnemonicStr(AbstractController.OPEN_STORAGE_DESIGN_CAPTION), ControllerApplication.this.getConfiguration().getIcon("OPEN_STORAGE_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(STORAGE_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.OPEN_STORAGE_DESIGN_CAPTION));
            this.setAccelerator(KeyStroke.getKeyStroke(79, 576, false));
        }

        @Override
        public boolean addSeparatorAfter() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            Thread thread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    block13: {
                        try {
                            RelationalDesign relModel = ControllerApplication.this.getApplicationView().selectRelationalDesign();
                            if (relModel == null) break block13;
                            ControllerApplication.this.getDesign().setRelationalDesign(relModel);
                            Object[] choices = ControllerApplication.this.getApplicationView().getCurrentDesign().getRDBMSSiteSet().toSiteArray();
                            RDBMSSite choice = null;
                            choice = (RDBMSSite)JListDialog.showDialog(ControllerApplication.this.getApplicationView().getFrame(), Messages.getString("ControllerApplication.SelectSite"), Messages.getString("ControllerApplication.DatabaseSites"), choices, relModel.getSelectedRDBMSSite());
                            if (choice == null) {
                                ApplicationView.log(Messages.getString("ControllerApplication.OpenPhysicalModelCanceled"));
                                break block13;
                            }
                            Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(3));
                            try {
                                ProgressDialog monitor = new ProgressDialog(ControllerApplication.this.getApplicationView(), "", 0, 100);
                                try {
                                    ApplicationView.log(MessageFormat.format(Messages.getString("ControllerApplication.OpenPhysicalModel"), choice));
                                    ApplicationView.canLogging = false;
                                    monitor.setNote(MessageFormat.format(Messages.getString("ControllerApplication.OpenDesignP"), String.valueOf(choice)));
                                    monitor.setProgress(50);
                                    StorageDesign storageDesign = relModel.getStorageDesign(choice);
                                    if (ControllerApplication.this.getApplicationView().getCurrentDesign().isLoadFromDB()) {
                                        AbstractRepositoryManager rman = ControllerApplication.this.getApplicationView().getDBPersistenceManager().getDBRepositoryManager();
                                        rman.readPhysicalModel(storageDesign);
                                    } else if (relModel.getDesign().isOldRepositoryType()) {
                                        storageDesign.load();
                                    } else {
                                        ControllerApplication.this.getApplicationView().getXMLTransformationManager().openPhysicalModel(storageDesign);
                                    }
                                    monitor.setProgress(100);
                                    storageDesign.setOpen(true);
                                    storageDesign.setTempModel(false);
                                    ControllerApplication.this.getApplicationView().getBrowserPanel().getNavigationTreeDesign().updateSubtree(storageDesign);
                                }
                                finally {
                                    monitor.close();
                                    ApplicationView.canLogging = true;
                                    ApplicationView.log(Messages.getString("ControllerApplication.OpenPhysicalModelFinished"));
                                }
                            }
                            finally {
                                Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(0));
                            }
                        }
                        catch (Throwable error) {
                            LOGGER.error("Error Opening Storage Design!", error);
                        }
                    }
                }
            };
            thread.start();
        }
    }

    public class ExitApplication
    extends MDBAction {
        private ExitApplication() {
            super(MenuUtils.getMnemonicStr(AbstractController.EXIT_CAPTION), ControllerApplication.this.getConfiguration().getIcon("EXIT_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(FILE_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.EXIT_CAPTION));
            this.setAccelerator(KeyStroke.getKeyStroke(115, 512, false));
        }

        @Override
        public boolean addSeparatorBefore() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            ControllerApplication.this.getApplicationView().exitApplication();
        }
    }

    public class CloseAllDesigns
    extends MDBAction {
        public CloseAllDesigns() {
            super(MenuUtils.getMnemonicStr(AbstractController.CLOSE_ALL_DESIGNS_CAPTION), ControllerApplication.this.getConfiguration().getIcon("CLOSE_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(FILE_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.CLOSE_ALL_DESIGNS_CAPTION));
            this.setAccelerator(KeyStroke.getKeyStroke(65, 128, false));
        }

        @Override
        public boolean addSeparatorAfter() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            ControllerApplication.this.getApplicationView().closeAllDesigns();
            if (Extension.isSVNExtensionLoaded()) {
                SVNHistoryWindow.getInstance().clear();
                SVNMergeWindow.getInstance().clear();
                SVNViewPropertiesWindow.getInstance().clear();
            }
        }
    }

    public class CloseDesign
    extends MDBAction {
        public CloseDesign() {
            super(MenuUtils.getMnemonicStr(AbstractController.CLOSE_DESIGN_CAPTION), ControllerApplication.this.getConfiguration().getIcon("CLOSE_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(FILE_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.CLOSE_DESIGN_CAPTION));
            this.setAccelerator(KeyStroke.getKeyStroke(87, 128, false));
        }

        @Override
        public boolean addSeparatorAfter() {
            return false;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            int mb = 0x100000;
            Runtime runtime = Runtime.getRuntime();
            System.out.println("close before execute end memory  total  " + runtime.totalMemory() / (long)mb + "  /memory  fre  " + runtime.freeMemory() / (long)mb + "  /used memory  " + (runtime.totalMemory() - runtime.freeMemory()) / (long)mb);
            Design design = ControllerApplication.this.getApplicationView().selectDesign();
            if (design != null) {
                ControllerApplication.this.getApplicationView().setCurrentDesign(design);
                this.execute();
            }
            System.gc();
            System.runFinalization();
            System.out.println("close after execute end memory  total  " + runtime.totalMemory() / (long)mb + "  /memory  fre  " + runtime.freeMemory() / (long)mb + "  /used memory  " + (runtime.totalMemory() - runtime.freeMemory()) / (long)mb);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute() {
            block34: {
                try {
                    ControllerApplication.this.getApplicationView().cancel = false;
                    Design currentDesign = ControllerApplication.this.getApplicationView().getCurrentDesign();
                    if (!ApplicationView.IS_VIEWER) {
                        Object[] list;
                        if (!ControllerApplication.this.getDesign().isLoadFromDB() && (ControllerApplication.this.getDesign().isNewDesign() || "".equalsIgnoreCase(ControllerApplication.this.getApplicationView().getCurrentDesign().getDesignPath()))) {
                            list = ControllerApplication.this.getApplicationView().whatToSave(true);
                            if (list != null && list.length > 0) {
                                list = ApplicationView.checkAndAddDesign(ControllerApplication.this.getDesign(), list);
                            }
                            if (list != null && list.length > 0) {
                                String name;
                                String oldDesignPath = ControllerApplication.this.getApplicationView().getCurrentDesign().getDesignPath();
                                String designName = null;
                                if (!ControllerApplication.this.getDesign().isNewDesign()) {
                                    designName = ControllerApplication.this.getDesign().getName();
                                }
                                if ((name = ControllerApplication.this.getApplicationView().selectDesignName(designName)) != null) {
                                    Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(3));
                                    try {
                                        boolean doit = ControllerApplication.this.getApplicationView().overwriteDesign(name);
                                        if (!doit) {
                                            while (name != null && !doit) {
                                                name = ControllerApplication.this.getApplicationView().selectDesignName(name);
                                                if (name != null) {
                                                    doit = ControllerApplication.this.getApplicationView().overwriteDesign(name);
                                                    continue;
                                                }
                                                doit = false;
                                            }
                                        }
                                        if (doit) {
                                            currentDesign.setFileName(name);
                                            ControllerApplication.this.getApplicationView().setDesignName(name);
                                            ControllerApplication.this.getApplicationView().synchronizeTitle();
                                            ControllerApplication.this.getApplicationView().getXMLTransformationManager().setCheckDirty(!ControllerApplication.this.getDesign().isNewDesign());
                                            ApplicationView.log(Messages.getString("ControllerApplication.SavingDesignAndPhysicalModels"));
                                            ControllerApplication.this.getApplicationView().doSave(list);
                                            ControllerApplication.this.getApplicationView().getCurrentDesign().setNewDesign(false);
                                            ControllerApplication.this.getApplicationView().addRecent(ControllerApplication.this.getApplicationView().getDesignName(), ControllerApplication.this.getApplicationView().getCurrentDesign().getDesignPath());
                                            ControllerApplication.this.getApplicationView().getCurrentDesign().setReadOnly(false);
                                            ControllerApplication.this.getApplicationView().getCurrentDesign().setDirty(false);
                                        }
                                        ControllerApplication.this.getApplicationView().getCurrentDesign().setDesignPath(oldDesignPath);
                                        ApplicationView.log(Messages.getString("ControllerApplication.SaveDesignAsCanceled"));
                                    }
                                    finally {
                                        Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(0));
                                    }
                                } else {
                                    ApplicationView.log(Messages.getString("ControllerApplication.SaveDesignAsCanceled"));
                                    ControllerApplication.this.getApplicationView().cancel = true;
                                }
                            }
                        } else {
                            list = ControllerApplication.this.getApplicationView().whatToSave(false);
                            if (list != null && list.length > 0) {
                                try {
                                    list = ApplicationView.checkAndAddDesign(ControllerApplication.this.getDesign(), list);
                                    Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(3));
                                    ControllerApplication.this.getApplicationView().doSave(list);
                                }
                                finally {
                                    Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(0));
                                }
                            }
                        }
                        if (!ControllerApplication.this.getApplicationView().cancel) {
                            currentDesign.removeDeletedProxies();
                            for (RelationalDesign rd : currentDesign.getRelationalDesigns()) {
                                rd.closeAllSearchDockables();
                                StorageDesign[] sds = rd.getStorageDesignFactory().getOpenStorageDesigns();
                                for (int i = 0; i < sds.length; ++i) {
                                    StorageDesign sd = sds[i];
                                    sd.closeAllSearchDockables();
                                    DataModelerAddin.closeAllEditors(sd, false);
                                }
                            }
                            for (MultidimensionalDesign md : currentDesign.getMultidimensionalDesigns()) {
                                md.closeAllSearchDockables();
                            }
                            currentDesign.getLogicalDesign().closeAllSearchDockables();
                            currentDesign.getDataTypesDesign().closeAllSearchDockables();
                            currentDesign.getProcessModel().closeAllSearchDockables();
                            ControllerApplication.this.getApplicationView().getTSDPPolicySet().removeSetListener(currentDesign);
                            ControllerApplication.this.getApplicationView().getSensitiveTypeSet().removeSetListener(currentDesign);
                            DockStation dockStation = DockStation.getDockStation();
                            Dockable dockable = dockStation.getDockable(GlobalSearchDockable.VIEW_ID);
                            if (dockable != null && dockable instanceof GlobalSearchDockable) {
                                GlobalSearchDockable gsd = (GlobalSearchDockable)dockable;
                                gsd.close();
                            }
                        }
                    }
                    if (ControllerApplication.this.getApplicationView().cancel) break block34;
                    Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(3));
                    try {
                        ApplicationView.log(Messages.getString("ControllerApplication.CloseDesign") + ControllerApplication.this.getApplicationView().getDesignName());
                        Design old = currentDesign;
                        boolean isVersioned = old.isVersioned();
                        ControllerApplication.this.getApplicationView().removeDesign(currentDesign);
                        if (ControllerApplication.this.getApplicationView().getCurrentDPV() != null) {
                            ControllerApplication.this.getApplicationView().getCurrentDPV().setCurrentSelection(null, null);
                        }
                        currentDesign = ControllerApplication.this.getApplicationView().getCurrentDesign();
                        if (Extension.isSVNExtensionLoaded()) {
                            Object obj = SVNChangeListWindow.getSelectedElementInScopeCB();
                            SVNChangeListWindow.removeFromScope(old);
                            if (isVersioned) {
                                SVNHistoryWindow.getInstance().clearForDesign(old);
                                SVNMergeWindow.getInstance().clearForDesign(old);
                                SVNViewPropertiesWindow.getInstance().clearForDesign(old);
                            }
                            if (old == obj) {
                                ControllerApplication.this.refreshOutgoingChanges();
                            }
                        }
                        ControllerApplication.this.getApplicationView().clearTitle();
                        ControllerApplication.this.getApplicationView().getBrowserPanel().expandToPath(ControllerApplication.this.getDesign().getPath());
                    }
                    finally {
                        Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
                catch (Throwable error) {
                    LOGGER.error("Error Closing Design!", error);
                }
            }
        }
    }

    class OpenDesign
    extends MDBAction {
        private String ext;
        private String designPath;

        private OpenDesign() {
            super(MenuUtils.getMnemonicStr(AbstractController.OPEN_DESIGN_CAPTION), ControllerApplication.this.getConfiguration().getIcon("OPEN_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.ext = ".dmd";
            this.setMenuPath(FILE_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.OPEN_DESIGN_CAPTION));
            this.setAccelerator(KeyStroke.getKeyStroke(79, 128, false));
        }

        private String selectDesign() {
            try {
                URLFilter fileFilter = new URLFilter(){

                    public boolean accept(URL url) {
                        File file = new File(url.getPath());
                        return file.getName().toLowerCase().endsWith(".dmd") || file.getName().toLowerCase().endsWith(".dmdz") || file.getName().toLowerCase().endsWith(".xml") || file.isDirectory();
                    }

                    public String toString() {
                        return Messages.getString("ControllerApplication.OracleSQLDeveloperModelingDesigns");
                    }
                };
                URLFileChooser fileChooser = new URLFileChooser();
                fileChooser.clearChooseableURLFilters();
                fileChooser.setSelectionScope(0);
                fileChooser.setSelectionMode(0);
                fileChooser.setShowJarsAsDirs(false);
                fileChooser.setURLFilter(fileFilter);
                fileChooser.setPathContext("dataModeler_OpenDesign");
                String lastDir = ControllerApplication.this.getApplicationView().getSettings().getDefaultDesignsPath();
                if (lastDir != null) {
                    fileChooser.setSelectedURL(URLFactory.newDirURL((String)lastDir));
                } else {
                    URL url = ControllerApplication.this.getApplicationView().getUserHomeDirectory();
                    if (url != null) {
                        fileChooser.setSelectedURL(url);
                    }
                }
                int status = fileChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString("ControllerApplication.OpenDesign"));
                if (status == 0) {
                    File selected = new File(fileChooser.getSelectedURL().getPath());
                    if (selected != null && selected.exists()) {
                        this.designPath = selected.getParent();
                        String fileName = selected.getName();
                        String designName = FileUtils.removeExt(fileName);
                        Design design = ControllerApplication.this.findDesign(this.designPath + "/" + designName);
                        if (design != null) {
                            MessageDialogs.showWarningMessage("Design: '" + designName + "' is already opened.");
                            ControllerApplication.this.getApplicationView().getBrowserPanel().expandToPath(design.getPath());
                            return null;
                        }
                        int pos = fileName.lastIndexOf(".");
                        if (pos > -1) {
                            this.ext = fileName.substring(pos);
                        }
                        return designName;
                    }
                    MessageDialogs.showWarningMessage("Selected Design does not exists.");
                    return null;
                }
                return null;
            }
            catch (Throwable e) {
                LOGGER.error("Error Oen design!", e);
                return null;
            }
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            ControllerApplication.this.doOpenDesign(this.selectDesign(), this.designPath, this.ext, false);
        }
    }

    class ImportDomainFile
    extends MDBAction {
        private ImportDomainFile() {
            super(MenuUtils.getMnemonicStr(AbstractController.IMPORT_DOMAINS_CAPTION), ControllerApplication.this.getConfiguration().getIcon("DOMAIN_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(IMPORT_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.IMPORT_DOMAINS_CAPTION));
            this.setAccelerator(KeyStroke.getKeyStroke(77, 192, false));
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            Design design = ControllerApplication.this.getApplicationView().selectDesign();
            if (design != null) {
                ControllerApplication.this.getApplicationView().setCurrentDesign(design);
                this.execute();
            }
        }

        public void execute() {
            ImportDomainsDialog dialog = new ImportDomainsDialog(ControllerApplication.this.getApplicationView(), ControllerApplication.this.getDesign().getLogicalDesign());
            dialog.show();
        }
    }

    class ImportCWD4ALLDesigner
    extends MDBAction {
        private ImportCWD4ALLDesigner() {
            super(MenuUtils.getMnemonicStr(Messages.getString("ControllerApplication.DataModelingDesign")), ControllerApplication.this.getConfiguration().getIcon("APPLICATION_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(IMPORT_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(Messages.getString("ControllerApplication.DataModelingDesign")));
            this.setAccelerator(KeyStroke.getKeyStroke(87, 192, false));
        }

        @Override
        public boolean addSeparatorBefore() {
            return !ApplicationView.LOGICAL_MODEL_ONLY;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            Design design = ControllerApplication.this.getApplicationView().selectDesign();
            if (design != null) {
                ControllerApplication.this.getApplicationView().setCurrentDesign(design);
                this.execute();
            }
        }

        public void execute() {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    try {
                        URLFilter fileFilter = new URLFilter(){

                            public boolean accept(URL url) {
                                File file = new File(url.getPath());
                                return file.getName().toLowerCase().endsWith(".dmd") || file.getName().toLowerCase().endsWith(".dmdz") || file.getName().toLowerCase().endsWith(".xml") || file.isDirectory();
                            }

                            public String toString() {
                                return Messages.getString("ControllerApplication.OracleSQLDeveloperModelingDesigns");
                            }
                        };
                        URLFileChooser fileChooser = new URLFileChooser();
                        fileChooser.clearChooseableURLFilters();
                        fileChooser.setSelectionScope(0);
                        fileChooser.setSelectionMode(0);
                        fileChooser.setShowJarsAsDirs(false);
                        fileChooser.setURLFilter(fileFilter);
                        fileChooser.setPathContext("dataModeler_Imports");
                        String lastDir = ControllerApplication.this.getApplicationView().getSettings().getDefaultImportPath();
                        if (lastDir != null) {
                            fileChooser.setSelectedURL(URLFactory.newDirURL((String)lastDir));
                        } else {
                            URL url = ControllerApplication.this.getApplicationView().getUserHomeDirectory();
                            if (url != null) {
                                fileChooser.setSelectedURL(url);
                            }
                        }
                        int status = fileChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString("ControllerApplication.ImportDesign"));
                        if (status == 0) {
                            File selected = new File(fileChooser.getSelectedURL().getPath());
                            if (selected != null) {
                                CWDExtractionWizard wizard = new CWDExtractionWizard(ControllerApplication.this.getApplicationView(), selected);
                                wizard.setVisible(true);
                            }
                        } else {
                            ApplicationView.log(Messages.getString("ControllerApplication.ImportDesignCanceled"));
                        }
                    }
                    catch (Throwable error) {
                        LOGGER.error("Error Importing Oracle SQL Developer Modeling Designer!", error);
                    }
                }
            };
            thread.start();
        }
    }

    class ExportToReportsSchema
    extends MDBAction {
        private ExportToReportsSchema() {
            super(MenuUtils.getMnemonicStr(Messages.getString("ControllerApplication.ToReportModel")), ControllerApplication.this.getConfiguration().getIcon("REPORTS_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(EXPORT_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(Messages.getString("ControllerApplication.ToReportModel")));
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            Design design = ControllerApplication.this.getApplicationView().selectDesign();
            if (design != null) {
                ControllerApplication.this.getApplicationView().setCurrentDesign(design);
                this.execute();
            }
        }

        public void execute() {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    try {
                        try {
                            Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(3));
                            ApplicationView.log("Exporting to Reports Schema");
                            ExportReportsDialog dialog = new ExportReportsDialog(ControllerApplication.this.getApplicationView());
                            if (dialog.showDialog()) {
                                ReportsHandler handler = new ReportsHandler(ControllerApplication.this.getApplicationView(), dialog.getConnection(), dialog.getComments(), dialog.exportDiagramsAsPDF(), dialog.clearDiagrams());
                                handler.export();
                            }
                        }
                        finally {
                            Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(0));
                        }
                    }
                    catch (Throwable error) {
                        LOGGER.error("Error in Export to Reports Schema.", error);
                    }
                }
            };
            thread.start();
        }
    }

    class ExportToCSV
    extends MDBAction {
        private ExportToCSV() {
            super(MenuUtils.getMnemonicStr(Messages.getString("ControllerApplication.ToCSV")), ControllerApplication.this.getConfiguration().getIcon("CSV_FILE", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(EXPORT_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(Messages.getString("ControllerApplication.ToCSV")));
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            Design design = ControllerApplication.this.getApplicationView().selectDesign();
            if (design != null) {
                ControllerApplication.this.getApplicationView().setCurrentDesign(design);
                this.execute();
            }
        }

        public void execute() {
            try {
                SelectCSVExportDialog dialog = new SelectCSVExportDialog(ControllerApplication.this.getApplicationView());
                boolean okRes = dialog.showDialog();
                if (!okRes) {
                    ApplicationView.log(Messages.getString("ControllerApplication.ExportToCSVCanceled"));
                    return;
                }
                FileFilter csvFilter = new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        return file.getName().toLowerCase().endsWith(".csv");
                    }
                };
                URLFileChooser fileChooser = new URLFileChooser();
                fileChooser.clearChooseableURLFilters();
                fileChooser.setSelectionScope(1);
                fileChooser.setSelectionMode(0);
                fileChooser.setShowJarsAsDirs(false);
                fileChooser.setPathContext("dataModeler_Exports");
                String lastDir = ControllerApplication.this.getApplicationView().getSettings().getLastExportFolder();
                if (lastDir != null) {
                    fileChooser.setSelectedURL(URLFactory.newDirURL((String)lastDir));
                } else {
                    URL url = ControllerApplication.this.getApplicationView().getUserHomeDirectory();
                    if (url != null) {
                        fileChooser.setSelectedURL(url);
                    }
                }
                int status = fileChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString("ControllerApplication.SelectFolder"));
                if (status == 0) {
                    File selectedFolder = new File(fileChooser.getSelectedURL().getPath());
                    if (!selectedFolder.exists()) {
                        selectedFolder.mkdirs();
                    }
                    if (selectedFolder.exists()) {
                        File[] csvFiles;
                        ControllerApplication.this.getApplicationView().getSettings().setLastExportFolder(selectedFolder.getPath());
                        if (selectedFolder.exists() && (csvFiles = selectedFolder.listFiles(csvFilter)).length > 0) {
                            int option = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), Messages.getString("ControllerApplication.FolderContainsCSVfilesDeleted"), Messages.getString("ControllerApplication.Warning"), 0, 3);
                            if (option == 1) {
                                ApplicationView.log(Messages.getString("ControllerApplication.ExportToCSVCanceled"));
                                return;
                            }
                            for (int i = csvFiles.length - 1; i >= 0; --i) {
                                File csvFile = csvFiles[i];
                                csvFile.delete();
                            }
                        }
                        CSVExporter exporter = new CSVExporter(ControllerApplication.this.getApplicationView());
                        exporter.setExportFolder(selectedFolder.getPath());
                        exporter.setDesignPartObjects(dialog.getDesignPartObjects());
                        exporter.execute();
                        ApplicationView.log(MessageFormat.format(Messages.getString("ControllerApplication.ExportToCSV"), selectedFolder.getPath()));
                    } else {
                        ApplicationView.log(Messages.getString("ControllerApplication.ExportToCSVFailed"));
                    }
                } else {
                    ApplicationView.log(Messages.getString("ControllerApplication.ExportToCSVCanceled"));
                }
            }
            catch (Throwable error) {
                LOGGER.error("Error in Export to CSV!", error);
            }
        }
    }

    class ExportXMLA
    extends MDBAction {
        private ExportXMLA() {
            super(MenuUtils.getMnemonicStr(Messages.getString("ControllerApplication.ToMicrosoftXMLA")), ControllerApplication.this.getConfiguration().getIcon("XMLA_FILE_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(EXPORT_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(Messages.getString("ControllerApplication.ToMicrosoftXMLA")));
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            Design design = ControllerApplication.this.getApplicationView().selectDesign();
            if (design != null) {
                ControllerApplication.this.getApplicationView().setCurrentDesign(design);
                this.execute();
            }
        }

        public void execute() {
            try {
                try {
                    Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(3));
                    ApplicationView.log(Messages.getString("ControllerApplication.ExportAsXMLAFile"));
                    XMLAExporter xmlaHandler = new XMLAExporter(ControllerApplication.this.getApplicationView());
                    xmlaHandler.export();
                }
                finally {
                    Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(0));
                }
            }
            catch (Throwable error) {
                LOGGER.error("Error in Export as XMLA File!", error);
            }
        }
    }

    class ExportToOracleAW
    extends MDBAction {
        private ExportToOracleAW() {
            super(MenuUtils.getMnemonicStr(Messages.getString("ControllerApplication.ToOracleAW")), ControllerApplication.this.getConfiguration().getIcon("XML_FILE_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(EXPORT_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(Messages.getString("ControllerApplication.ToOracleAW")));
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            Design design = ControllerApplication.this.getApplicationView().selectDesign();
            if (design != null) {
                ControllerApplication.this.getApplicationView().setCurrentDesign(design);
                this.execute();
            }
        }

        public void execute() {
            try {
                try {
                    Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(3));
                    ApplicationView.log(Messages.getString("ControllerApplication.ExportToOracleAW"));
                    OracleAW11Exporter cvHandler = new OracleAW11Exporter(ControllerApplication.this.getApplicationView());
                    cvHandler.export();
                }
                finally {
                    Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(0));
                }
            }
            catch (Throwable error) {
                LOGGER.error("Error in Export to Oracle AW!", error);
            }
        }
    }

    class ExportCubeViewsXML
    extends MDBAction {
        private ExportCubeViewsXML() {
            super(MenuUtils.getMnemonicStr(Messages.getString("ControllerApplication.CubeViewsMetadata")), ControllerApplication.this.getConfiguration().getIcon("XML_FILE_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(EXPORT_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(Messages.getString("ControllerApplication.CubeViewsMetadata")));
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            Design design = ControllerApplication.this.getApplicationView().selectDesign();
            if (design != null) {
                ControllerApplication.this.getApplicationView().setCurrentDesign(design);
                this.execute();
            }
        }

        public void execute() {
            try {
                try {
                    Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(3));
                    ApplicationView.log(Messages.getString("ControllerApplication.ExportCubeViewsMetaData"));
                    CubeViewsExporter cvHandler = new CubeViewsExporter(ControllerApplication.this.getApplicationView());
                    cvHandler.export();
                }
                finally {
                    Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(0));
                }
            }
            catch (Throwable error) {
                LOGGER.error("Error Exporting Cube Views Meta Data!", error);
            }
        }
    }

    class ImportOracleDesigner
    extends MDBAction {
        private ImportOracleDesigner() {
            super(MenuUtils.getMnemonicStr(AbstractController.IMPORT_OD_CAPTION), ControllerApplication.this.getConfiguration().getIcon("OD_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(IMPORT_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.IMPORT_OD_CAPTION));
            this.setAccelerator(KeyStroke.getKeyStroke(79, 192, false));
        }

        @Override
        public boolean addSeparatorBefore() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            Design design = ControllerApplication.this.getApplicationView().selectDesign();
            if (design != null) {
                ControllerApplication.this.getApplicationView().setCurrentDesign(design);
                this.execute();
            }
        }

        public void execute() {
            try {
                boolean inExistingDesign = !ControllerApplication.this.getDesign().isNewDesign();
                ODExtractionWizard wizard = new ODExtractionWizard(ControllerApplication.this.getApplicationView(), inExistingDesign);
                wizard.setVisible(true);
            }
            catch (Throwable error) {
                LOGGER.error("Error Importing Oracle Designer!", error);
            }
        }
    }

    class ImportDBMetadata
    extends MDBAction {
        private ImportDBMetadata() {
            super(MenuUtils.getMnemonicStr(AbstractController.IMPORT_MD_CAPTION), ControllerApplication.this.getConfiguration().getIcon("DBM_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(IMPORT_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.IMPORT_MD_CAPTION));
            this.setAccelerator(KeyStroke.getKeyStroke(66, 192, false));
        }

        @Override
        public boolean addSeparatorBefore() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            Design design = ControllerApplication.this.getApplicationView().selectDesign();
            if (design != null) {
                ControllerApplication.this.getApplicationView().setCurrentDesign(design);
                this.execute();
            }
        }

        public void execute() {
            try {
                DBMExtractionWizard wizard = new DBMExtractionWizard(ControllerApplication.this.getApplicationView());
                wizard.setVisible(true);
            }
            catch (Throwable error) {
                LOGGER.error("Error Importing DB Metadata!", error);
            }
        }
    }

    class ImportERwin7
    extends MDBAction {
        private ImportERwin7() {
            super(MenuUtils.getMnemonicStr(AbstractController.IMPORT_ERWIN7_CAPTION), ControllerApplication.this.getConfiguration().getIcon("XML_FILE_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(IMPORT_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.IMPORT_ERWIN7_CAPTION));
            this.setAccelerator(KeyStroke.getKeyStroke(82, 192, false));
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            Design design = ControllerApplication.this.getApplicationView().selectFirstDesign();
            if (design != null) {
                ControllerApplication.this.getApplicationView().setCurrentDesign(design);
                this.execute();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute() {
            block10: {
                try {
                    if (!ControllerApplication.this.designIsEmpty()) {
                        Design design = ControllerApplication.this.getApplicationView().addDesign(false);
                        ControllerApplication.this.getApplicationView().setCurrentDesign(design);
                    }
                    URLFilter fileFilter = new URLFilter(){

                        public boolean accept(URL url) {
                            File file = new File(url.getPath());
                            return file.getName().toLowerCase().endsWith(".xml") || file.isDirectory();
                        }

                        public String toString() {
                            return Messages.getString("ControllerApplication.ERwin7xFiles");
                        }
                    };
                    URLFileChooser fileChooser = new URLFileChooser();
                    fileChooser.clearChooseableURLFilters();
                    fileChooser.setSelectionScope(0);
                    fileChooser.setSelectionMode(0);
                    fileChooser.setShowJarsAsDirs(false);
                    fileChooser.setURLFilter(fileFilter);
                    fileChooser.setPathContext("dataModeler_Imports");
                    String lastDir = ControllerApplication.this.getApplicationView().getSettings().getDefaultImportPath();
                    if (lastDir != null) {
                        fileChooser.setSelectedURL(URLFactory.newDirURL((String)lastDir));
                    } else {
                        URL url = ControllerApplication.this.getApplicationView().getUserHomeDirectory();
                        if (url != null) {
                            fileChooser.setSelectedURL(url);
                        }
                    }
                    int status = fileChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString("ControllerApplication.ImportERwinFileTitle"));
                    if (status != 0) break block10;
                    Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(3));
                    try {
                        File selected = new File(fileChooser.getSelectedURL().getPath());
                        if (selected != null) {
                            ApplicationView.log(Messages.getString("ControllerApplication.ImportERwinFileTitle"));
                            ERwinHandler erwinHandler = new ERwinHandler(ControllerApplication.this.getApplicationView(), false);
                            erwinHandler.parse(selected, 7);
                        }
                    }
                    finally {
                        Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
                catch (Throwable error) {
                    LOGGER.error("Error Importing ERwin 7.x File", error);
                }
            }
        }
    }

    class ImportERwin4
    extends MDBAction {
        private ImportERwin4() {
            super(MenuUtils.getMnemonicStr(AbstractController.IMPORT_ERWIN4_CAPTION), ControllerApplication.this.getConfiguration().getIcon("XML_FILE_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(IMPORT_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.IMPORT_ERWIN4_CAPTION));
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            Design design = ControllerApplication.this.getApplicationView().selectDesign();
            if (design != null) {
                ControllerApplication.this.getApplicationView().setCurrentDesign(design);
                this.execute();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute() {
            block10: {
                try {
                    if (!ControllerApplication.this.designIsEmpty()) {
                        Design design = ControllerApplication.this.getApplicationView().addDesign(false);
                        ControllerApplication.this.getApplicationView().setCurrentDesign(design);
                    }
                    URLFilter fileFilter = new URLFilter(){

                        public boolean accept(URL url) {
                            File file = new File(url.getPath());
                            return file.getName().toLowerCase().endsWith(".xml") || file.isDirectory();
                        }

                        public String toString() {
                            return Messages.getString("ControllerApplication.ERwin4xFiles");
                        }
                    };
                    URLFileChooser fileChooser = new URLFileChooser();
                    fileChooser.clearChooseableURLFilters();
                    fileChooser.setSelectionScope(0);
                    fileChooser.setSelectionMode(0);
                    fileChooser.setShowJarsAsDirs(false);
                    fileChooser.setURLFilter(fileFilter);
                    fileChooser.setPathContext("dataModeler_Imports");
                    String lastDir = ControllerApplication.this.getApplicationView().getSettings().getDefaultImportPath();
                    if (lastDir != null) {
                        fileChooser.setSelectedURL(URLFactory.newDirURL((String)lastDir));
                    } else {
                        URL url = ControllerApplication.this.getApplicationView().getUserHomeDirectory();
                        if (url != null) {
                            fileChooser.setSelectedURL(url);
                        }
                    }
                    int status = fileChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString("ControllerApplication.ImportERwinFileTitle"));
                    if (status != 0) break block10;
                    Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(3));
                    try {
                        File selected = new File(fileChooser.getSelectedURL().getPath());
                        if (selected != null) {
                            ApplicationView.log(Messages.getString("ControllerApplication.ImportERwinFileTitle"));
                            ERwinHandler erwinHandler = new ERwinHandler(ControllerApplication.this.getApplicationView(), false);
                            erwinHandler.parse(selected, 4);
                        }
                    }
                    finally {
                        Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
                catch (Throwable error) {
                    LOGGER.error("Error Importing ERwin 4.x File", error);
                }
            }
        }
    }

    class ImportXMLA
    extends MDBAction {
        private ImportXMLA() {
            super(MenuUtils.getMnemonicStr(AbstractController.IMPORT_XMLA_CAPTION), ControllerApplication.this.getConfiguration().getIcon("XMLA_FILE_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(IMPORT_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.IMPORT_XMLA_CAPTION));
            this.setAccelerator(KeyStroke.getKeyStroke(65, 192, false));
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            Design design = ControllerApplication.this.getApplicationView().selectDesign();
            if (design != null) {
                ControllerApplication.this.getApplicationView().setCurrentDesign(design);
                this.execute();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute() {
            block11: {
                try {
                    if (!ControllerApplication.this.designIsEmpty()) {
                        Design design = ControllerApplication.this.getApplicationView().addDesign(false);
                        ControllerApplication.this.getApplicationView().setCurrentDesign(design);
                    }
                    URLFilter fileFilter = new URLFilter(){

                        public boolean accept(URL url) {
                            File file = new File(url.getPath());
                            return file.getName().toLowerCase().endsWith(".xmla") || file.isDirectory();
                        }

                        public String toString() {
                            return Messages.getString("ControllerApplication.XMLAFiles");
                        }
                    };
                    URLFileChooser fileChooser = new URLFileChooser();
                    fileChooser.clearChooseableURLFilters();
                    fileChooser.setSelectionScope(0);
                    fileChooser.setSelectionMode(0);
                    fileChooser.setShowJarsAsDirs(false);
                    fileChooser.setURLFilter(fileFilter);
                    fileChooser.setPathContext("dataModeler_Imports");
                    String lastDir = ControllerApplication.this.getApplicationView().getSettings().getDefaultImportPath();
                    if (lastDir != null) {
                        fileChooser.setSelectedURL(URLFactory.newDirURL((String)lastDir));
                    } else {
                        URL url = ControllerApplication.this.getApplicationView().getUserHomeDirectory();
                        if (url != null) {
                            fileChooser.setSelectedURL(url);
                        }
                    }
                    int status = fileChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString("ControllerApplication.ImportXMLAFileTitle"));
                    if (status != 0) break block11;
                    Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(3));
                    try {
                        File selected = new File(fileChooser.getSelectedURL().getPath());
                        if (selected != null) {
                            String designName = selected.getName();
                            int ext = designName.lastIndexOf(46);
                            if (ext > -1) {
                                designName = designName.substring(0, ext);
                            }
                            ApplicationView.log(Messages.getString("ControllerApplication.ImportXMLAFileTitle"));
                            boolean inExistingDesign = !ControllerApplication.this.getDesign().isNewDesign();
                            XMLAHandler xmlaHandler = new XMLAHandler(ControllerApplication.this.getApplicationView(), inExistingDesign);
                            xmlaHandler.parse(selected);
                        }
                    }
                    finally {
                        Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
                catch (Throwable error) {
                    LOGGER.error("Error Importing XMLA File!", error);
                }
            }
        }
    }

    class ImportCubeViewsXML
    extends MDBAction {
        private ImportCubeViewsXML() {
            super(MenuUtils.getMnemonicStr(Messages.getString("ControllerApplication.CubeViewsMetadata")), ControllerApplication.this.getConfiguration().getIcon("XML_FILE_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(IMPORT_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(Messages.getString("ControllerApplication.CubeViewsMetadata")));
            this.setAccelerator(KeyStroke.getKeyStroke(67, 192, false));
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            Design design = ControllerApplication.this.getApplicationView().selectDesign();
            if (design != null) {
                ControllerApplication.this.getApplicationView().setCurrentDesign(design);
                this.execute();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute() {
            block13: {
                int entNum = ControllerApplication.this.getLogicalDesign().getEntitySet().size();
                int tabNum = 0;
                int relModels = 0;
                boolean tocurrent = false;
                for (RelationalDesign pdes : ControllerApplication.this.getDesign().getRelationalDesigns()) {
                    tabNum += pdes.getTableSet().size();
                    ++relModels;
                }
                if (!ControllerApplication.this.getDesign().isNewDesign() || entNum + tabNum > 0) {
                    String mes1 = MessageFormat.format(Messages.getString("ControllerApplication.LogicalModelEntities"), String.valueOf(entNum));
                    String mes2 = MessageFormat.format(Messages.getString("ControllerApplication.TablesInrelationalModel"), String.valueOf(tabNum), String.valueOf(relModels));
                    String mes3 = Messages.getString("ControllerApplication.ImportToCurrentDesign");
                    int option = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), mes1 + mes2 + mes3, Messages.getString("ControllerApplication.CubeViewsImportToExistingDesign"), 0);
                    if (option != 0) {
                        return;
                    }
                    tocurrent = true;
                }
                try {
                    URLFilter fileFilter = new URLFilter(){

                        public boolean accept(URL url) {
                            File file = new File(url.getPath());
                            return file.getName().toLowerCase().endsWith(".xml") || file.isDirectory();
                        }

                        public String toString() {
                            return Messages.getString("ControllerApplication.CubeViewsMetadataFiles");
                        }
                    };
                    URLFileChooser fileChooser = new URLFileChooser();
                    fileChooser.clearChooseableURLFilters();
                    fileChooser.setSelectionScope(0);
                    fileChooser.setSelectionMode(0);
                    fileChooser.setShowJarsAsDirs(false);
                    fileChooser.setURLFilter(fileFilter);
                    fileChooser.setPathContext("dataModeler_Imports");
                    String lastDir = ControllerApplication.this.getApplicationView().getSettings().getDefaultImportPath();
                    if (lastDir != null) {
                        fileChooser.setSelectedURL(URLFactory.newDirURL((String)lastDir));
                    } else {
                        URL url = ControllerApplication.this.getApplicationView().getUserHomeDirectory();
                        if (url != null) {
                            fileChooser.setSelectedURL(url);
                        }
                    }
                    int status = fileChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString("ControllerApplication.ImportCubeViewsMetadata"));
                    if (status != 0) break block13;
                    Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(3));
                    try {
                        File selected = new File(fileChooser.getSelectedURL().getPath());
                        if (selected != null) {
                            String designName = selected.getName();
                            int ext = designName.lastIndexOf(46);
                            if (ext > -1) {
                                designName = designName.substring(0, ext);
                            }
                            ApplicationView.log(Messages.getString("ControllerApplication.ImportCubeViewsMetadata"));
                            ControllerApplication.this.getDesign().setImportToCurrent(tocurrent);
                            CubeViewsHandler cvHandler = new CubeViewsHandler(ControllerApplication.this.getApplicationView());
                            cvHandler.parse(selected);
                        }
                    }
                    finally {
                        ControllerApplication.this.getDesign().setImportToCurrent(false);
                        Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
                catch (Throwable error) {
                    LOGGER.error("Error Importing Cube Views Meta Data!", error);
                }
            }
        }
    }

    class ImportDDL
    extends MDBAction {
        private ImportDDL() {
            super(MenuUtils.getMnemonicStr(AbstractController.IMPORT_DDL_CAPTION), ControllerApplication.this.getConfiguration().getIcon("DDL_FILE_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(IMPORT_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.IMPORT_DDL_CAPTION));
            this.setAccelerator(KeyStroke.getKeyStroke(68, 192, false));
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            Design design = ControllerApplication.this.getApplicationView().selectDesign();
            if (design != null) {
                ControllerApplication.this.getApplicationView().setCurrentDesign(design);
                this.execute();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute() {
            block6: {
                try {
                    DDLFilesCollector collector = new DDLFilesCollector(ControllerApplication.this.getApplicationView());
                    if (!collector.showDialog() || collector.getDDLFiles().length <= 0) break block6;
                    Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(3));
                    try {
                        File file = (File)collector.getDDLFiles()[0];
                        String designName = file.getName();
                        int ext = designName.lastIndexOf(46);
                        if (ext > -1) {
                            designName = designName.substring(0, ext);
                        }
                        String oldDesignPath = ControllerApplication.this.getApplicationView().getCurrentDesign().getDesignPath();
                        ApplicationView.log(Messages.getString("ControllerApplication.ImportingDDLFile"));
                        DDLHandler ddlHandler = new DDLHandler(ControllerApplication.this.getApplicationView(), collector.getSelectedModel(), collector.swapTargetModel(), collector.skipMergeDialog());
                        ddlHandler.parse(collector.getDDLFiles(), designName, oldDesignPath);
                    }
                    finally {
                        Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
                catch (Throwable error) {
                    LOGGER.error("Error Importing DDL File!", error);
                }
            }
        }
    }

    class ImportVar
    extends MDBAction {
        ImportTypeSelector typeSelector;

        private ImportVar() {
            super(MenuUtils.getMnemonicStr(AbstractController.IMPORT_VAR_CAPTION), ControllerApplication.this.getConfiguration().getIcon("VAR_FILE_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.typeSelector = null;
            this.setMenuPath(IMPORT_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.IMPORT_VAR_CAPTION));
            this.setAccelerator(KeyStroke.getKeyStroke(86, 192, false));
        }

        public ImportTypeSelector getImportTypeSelector() {
            if (this.typeSelector == null) {
                this.typeSelector = new ImportTypeSelector(ControllerApplication.this.getApplicationView());
            }
            return this.typeSelector;
        }

        private int getImportType() {
            this.getImportTypeSelector().showDialog();
            return this.getImportTypeSelector().getResult();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doActionPerformed(ActionEvent e) {
            block22: {
                if (!ControllerApplication.this.designIsEmpty()) {
                    Design design = ControllerApplication.this.getApplicationView().addDesign(false);
                    ControllerApplication.this.getApplicationView().setCurrentDesign(design);
                }
                try {
                    File selected;
                    File file = null;
                    if (this.getImportType() == 2) {
                        return;
                    }
                    int choice = this.getImportTypeSelector().getdbType();
                    boolean importPM = this.getImportTypeSelector().importProcessModel();
                    if (choice == 2) {
                        MappedVarsCollector collector = new MappedVarsCollector(ControllerApplication.this.getApplicationView());
                        boolean result = collector.showDialog(ControllerApplication.this.getApplicationView());
                        if (!result) break block22;
                        Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(3));
                        try {
                            VARParser varParser = new VARParser();
                            ApplicationView.log(Messages.getString("ControllerApplication.ImportMultiMappedVARFiles"));
                            varParser.parse(null, ControllerApplication.this.getApplicationView(), collector, null, importPM);
                            break block22;
                        }
                        finally {
                            Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(0));
                        }
                    }
                    if (choice != 1) break block22;
                    URLFilter fileFilter = new URLFilter(){

                        public boolean accept(URL url) {
                            File file = new File(url.getPath());
                            return file.getName().toLowerCase().endsWith(".var") || file.isDirectory();
                        }

                        public String toString() {
                            return Messages.getString("ControllerApplication.VARFiles");
                        }
                    };
                    URLFileChooser fileChooser = new URLFileChooser();
                    fileChooser.clearChooseableURLFilters();
                    fileChooser.setSelectionScope(0);
                    fileChooser.setSelectionMode(0);
                    fileChooser.setShowJarsAsDirs(false);
                    fileChooser.setURLFilter(fileFilter);
                    fileChooser.setPathContext("dataModeler_Imports");
                    String lastDir = ControllerApplication.this.getApplicationView().getSettings().getDefaultImportPath();
                    if (lastDir != null) {
                        fileChooser.setSelectedURL(URLFactory.newDirURL((String)lastDir));
                    } else {
                        URL url = ControllerApplication.this.getApplicationView().getUserHomeDirectory();
                        if (url != null) {
                            fileChooser.setSelectedURL(url);
                        }
                    }
                    int status = fileChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString("ControllerApplication.SelectAFile"));
                    if (status != 0 || (selected = new File(fileChooser.getSelectedURL().getPath())) == null) break block22;
                    file = selected;
                    Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(3));
                    try {
                        VARParser varParser = new VARParser();
                        ApplicationView.loading = true;
                        try {
                            String version;
                            int index = this.getImportTypeSelector().getComboIndex();
                            switch (index) {
                                case 0: {
                                    version = "Sterling COOL:DBA V2.1";
                                    break;
                                }
                                case 1: {
                                    version = "Sterling Bsnteam V7.2";
                                    break;
                                }
                                case 2: {
                                    version = "Cayenne Bsnteam V7.2";
                                    break;
                                }
                                default: {
                                    version = "Sterling COOL:DBA V2.1";
                                }
                            }
                            ApplicationView.log(Messages.getString("ControllerApplication.ImportVARFile"));
                            varParser.parse(file, ControllerApplication.this.getApplicationView(), null, version, importPM);
                        }
                        finally {
                            ApplicationView.loading = false;
                        }
                    }
                    finally {
                        Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
                catch (Throwable error) {
                    LOGGER.error("Error Importing VAR File!", error);
                }
            }
        }
    }

    class EqualHeight
    extends MDBAction {
        private EqualHeight() {
            super(MenuUtils.getMnemonicStr(AbstractController.EQUAL_HEIGHT_CAPTION), ControllerApplication.this.getConfiguration().getIcon("EQUAL_HEIGHT_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(EDIT_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.EQUAL_HEIGHT_CAPTION));
            this.setEnabled(false);
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            ControllerApplication.this.getApplicationView().getCurrentDPV().getWorkSpace().alignSelected(4);
        }
    }

    class EqualWidth
    extends MDBAction {
        private EqualWidth() {
            super(MenuUtils.getMnemonicStr(AbstractController.EQUAL_WIDTH_CAPTION), ControllerApplication.this.getConfiguration().getIcon("EQUAL_WIDTH_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(EDIT_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.EQUAL_WIDTH_CAPTION));
            this.setEnabled(false);
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            ControllerApplication.this.getApplicationView().getCurrentDPV().getWorkSpace().alignSelected(3);
        }
    }

    class AlignTop
    extends MDBAction {
        private AlignTop() {
            super(MenuUtils.getMnemonicStr(AbstractController.ALIGN_TOP_CAPTION), ControllerApplication.this.getConfiguration().getIcon("ALIGN_TOP_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(EDIT_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.ALIGN_TOP_CAPTION));
            this.setAccelerator(KeyStroke.getKeyStroke(84, 128, false));
            this.setEnabled(false);
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            ControllerApplication.this.getApplicationView().getCurrentDPV().getWorkSpace().alignSelected(1);
        }
    }

    class AlignLeft
    extends MDBAction {
        private AlignLeft() {
            super(MenuUtils.getMnemonicStr(AbstractController.ALIGN_LEFT_CAPTION), GUIConfiguration.getInstance().getIcon("ALIGN_LEFT_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(EDIT_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.ALIGN_LEFT_CAPTION));
            this.setAccelerator(KeyStroke.getKeyStroke(76, 128, false));
            this.setEnabled(false);
        }

        @Override
        public boolean addSeparatorBefore() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            ControllerApplication.this.getApplicationView().getCurrentDPV().getWorkSpace().alignSelected(0);
        }
    }

    class Redo
    extends MDBAction {
        private Redo(UndoManager undoManager) {
            super(MenuUtils.getMnemonicStr(AbstractController.REDO_CAPTION), ControllerApplication.this.getConfiguration().getIcon("REDO_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(EDIT_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.REDO_CAPTION));
        }

        @Override
        public boolean addSeparatorAfter() {
            return true;
        }

        private UndoManager getUndoManager() {
            return ControllerApplication.this.getApplicationView().getCurrentDesign().getUndoManager();
        }

        @Override
        public String getName() {
            return this.getUndoManager().getRedoPresentationName();
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            this.getUndoManager().redo();
            ControllerApplication.this.updateUndoRedoMenu();
        }

        protected void updateRedoState() {
        }
    }

    class Undo
    extends MDBAction {
        private Undo(UndoManager undoManager) {
            super(MenuUtils.getMnemonicStr(AbstractController.UNDO_CAPTION), ControllerApplication.this.getConfiguration().getIcon("UNDO_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(EDIT_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.UNDO_CAPTION));
        }

        @Override
        public String getName() {
            return this.getUndoManager().getUndoPresentationName();
        }

        private UndoManager getUndoManager() {
            return ControllerApplication.this.getApplicationView().getCurrentDesign().getUndoManager();
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            this.getUndoManager().undo();
            ControllerApplication.this.updateUndoRedoMenu();
        }

        protected void updateUndoState() {
        }
    }

    class ShowTableDDLTransformations
    extends MDBAction {
        private ShowTableDDLTransformations() {
            super(MenuUtils.getMnemonicStr(AbstractController.TABLE_DDL_TRANSFORMATION_CAPTION), ControllerApplication.this.getConfiguration().getIcon("TABLE_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(TOOLS_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.TABLE_DDL_TRANSFORMATION_CAPTION));
        }

        @Override
        public boolean addSeparatorBefore() {
            return ControllerApplication.this.isEditable();
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            ControllerApplication.this.getApplicationView().setDDLTransformationsScriptsDialogVisible(true);
        }
    }

    class ShowTransformationsManager
    extends MDBAction {
        private ShowTransformationsManager() {
            super(MenuUtils.getMnemonicStr(AbstractController.DESIGN_RULES_TRANSFORMATIONS_CAPTION), ControllerApplication.this.getConfiguration().getIcon("TRANSFORMATION_SCRIPT_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(TOOLS_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.DESIGN_RULES_TRANSFORMATIONS_CAPTION));
        }

        @Override
        public boolean addSeparatorBefore() {
            return ControllerApplication.this.isEditable();
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            ControllerApplication.this.getApplicationView().setTransformationsManagerVisible(true);
        }
    }

    class ShowCustomLibrariesManager
    extends MDBAction {
        private ShowCustomLibrariesManager() {
            super(MenuUtils.getMnemonicStr(AbstractController.DESIGN_RULES_LIBRARIES_CAPTION), ControllerApplication.this.getConfiguration().getIcon("TRANSFORMATION_SCRIPT_LIBRARIES_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(TOOLS_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.DESIGN_RULES_LIBRARIES_CAPTION));
        }

        @Override
        public boolean addSeparatorBefore() {
            return ControllerApplication.this.isEditable();
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            ControllerApplication.this.getApplicationView().setCustomLibrariesManagerVisible(true);
        }
    }

    class ShowCustomDesignRules
    extends MDBAction {
        private ShowCustomDesignRules() {
            super(MenuUtils.getMnemonicStr(AbstractController.DESIGN_RULES_CUSTOM_CAPTION), ControllerApplication.this.getConfiguration().getIcon("CUSTOM_DESIGN_RULE_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(TOOLS_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.DESIGN_RULES_CUSTOM_CAPTION));
        }

        @Override
        public boolean addSeparatorBefore() {
            return ControllerApplication.this.isEditable();
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            ControllerApplication.this.getApplicationView().setCustomDesignRulesManagerVisible(true);
        }
    }

    class ShowDesignRules
    extends MDBAction {
        private ShowDesignRules() {
            super(MenuUtils.getMnemonicStr(AbstractController.DESIGN_RULES_CAPTION), ControllerApplication.this.getConfiguration().getIcon("DESIGN_RULE_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(TOOLS_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.DESIGN_RULES_CAPTION));
            this.setAccelerator(KeyStroke.getKeyStroke(82, 576, false));
        }

        @Override
        public boolean addSeparatorBefore() {
            return ControllerApplication.this.isEditable();
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            ControllerApplication.this.getApplicationView().setDesignRuleViewVisible(true);
        }
    }

    class PageSetup
    extends MDBAction {
        private PageSetup() {
            super(MenuUtils.getMnemonicStr(AbstractController.PAGE_SETUP_CAPTION));
            this.setMenuPath(FILE_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.PAGE_SETUP_CAPTION));
            this.setAccelerator(KeyStroke.getKeyStroke(84, 128, false));
        }

        @Override
        public boolean addSeparatorBefore() {
            return ControllerApplication.this.isEditable();
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            Config conf = Config.getConfig();
            if (conf.openPageSetup()) {
                ControllerApplication.this.getApplicationView().savePageSetupSettings(conf);
            }
        }
    }

    class PrintDialog
    extends MDBAction {
        DesignPrintModule printer;

        private PrintDialog() {
            super(MenuUtils.getMnemonicStr(AbstractController.PRINT_CAPTION), ControllerApplication.this.getConfiguration().getIcon("PRINT_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.printer = null;
            this.setMenuPath(FILE_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.PRINT_CAPTION));
            this.setAccelerator(KeyStroke.getKeyStroke(80, 128, false));
        }

        @Override
        public boolean addSeparatorBefore() {
            return ControllerApplication.this.isEditable();
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            Thread thread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    block17: {
                        try {
                            Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(3));
                            try {
                                String[] errors;
                                if (PrintDialog.this.printer == null) {
                                    PrintDialog.this.printer = new DesignPrintModule();
                                }
                                if ((errors = PrintDialog.this.printer.connect()) != null) {
                                    try {
                                        Thread.sleep(100L);
                                    }
                                    catch (InterruptedException ie) {
                                        // empty catch block
                                    }
                                    Component component = ControllerApplication.this.getApplicationView().getSelectedWorkSpaceComponent();
                                    Dimension size = ControllerApplication.this.getApplicationView().getSelectedWorkSpaceSize();
                                    if (size.height <= 20 || size.width <= 20) {
                                        JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), new Object[]{Messages.getString("ControllerApplication.NoPrintableArea")}, Messages.getString("ControllerApplication.Information"), 2);
                                        return;
                                    }
                                    boolean showGrid = true;
                                    boolean showPageGrid = true;
                                    if (component instanceof Diagram) {
                                        showGrid = ((Diagram)component).isGridVisible();
                                        showPageGrid = ((Diagram)component).isPageGridVisible();
                                        ((Diagram)component).setGridVisible(false);
                                        ((Diagram)component).setPageGridVisible(false);
                                        if (showGrid || showPageGrid) {
                                            ((Diagram)component).repaint();
                                        }
                                    }
                                    try {
                                        PrintDialog.this.printer.setComponentToPrint(component, size);
                                        JPanel panel = new JPanel(new BorderLayout());
                                        panel.add(PrintDialog.this.printer.getButtonPanel(), "North");
                                        JScrollPane sp = new JScrollPane(PrintDialog.this.printer.getViewComponent());
                                        sp.getVerticalScrollBar().setUnitIncrement(50);
                                        panel.add((Component)sp, "Center");
                                        JDialog dialog = new JDialog(ControllerApplication.this.getApplicationView().getFrame(), Messages.getString("ControllerApplication.Print"), false);
                                        dialog.setContentPane(panel);
                                        PrintDialog.this.printer.setDialog(dialog);
                                        dialog.pack();
                                        Dimension ss = Toolkit.getDefaultToolkit().getScreenSize();
                                        dialog.setSize((int)(ss.getWidth() / 1.5), (int)(ss.getHeight() - 150.0));
                                        ControllerApplication.this.centerOnScreen(dialog);
                                        dialog.setModal(true);
                                        dialog.setVisible(true);
                                        break block17;
                                    }
                                    finally {
                                        if (component instanceof Diagram) {
                                            ((Diagram)component).setGridVisible(showGrid);
                                            ((Diagram)component).setPageGridVisible(showPageGrid);
                                        }
                                    }
                                }
                                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), errors, Messages.getString("ControllerApplication.PrintError"), 0);
                            }
                            finally {
                                Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(0));
                            }
                        }
                        catch (Throwable error) {
                            LOGGER.error("Error Printing Design!", error);
                        }
                    }
                }
            };
            thread.start();
        }
    }

    class ShowDDLFileEditor
    extends MDBAction {
        private ShowDDLFileEditor() {
            super(MenuUtils.getMnemonicStr(AbstractController.DDL_FILE_EDITOR_CAPTION), ControllerApplication.this.getConfiguration().getIcon("DDL_EDITOR_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(VIEW_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.DDL_FILE_EDITOR_CAPTION));
            this.setAccelerator(KeyStroke.getKeyStroke(76, 576, false));
        }

        @Override
        public boolean addSeparatorAfter() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            RelationalDesign design = ControllerApplication.this.getApplicationView().selectRelationalDesign();
            if (design != null) {
                ControllerApplication.this.getDesign().setRelationalDesign(design);
                ControllerApplication.this.getApplicationView().setDDLFileMakerEditorVisible(true);
            }
        }
    }

    class ShowDDL
    extends MDBAction {
        @Override
        public boolean addSeparatorBefore() {
            return ControllerApplication.this.isEditable();
        }

        private ShowDDL() {
            super(MenuUtils.getMnemonicStr(AbstractController.DDL_PREVIEW_CAPTION), ControllerApplication.this.getConfiguration().getIcon("DDL_PREVIEW_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(VIEW_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.DDL_PREVIEW_CAPTION));
            this.setAccelerator(KeyStroke.getKeyStroke(73, 576, false));
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            ControllerApplication.this.getApplicationView().setDDLViewerVisible(true);
        }
    }

    class ShowEditor
    extends MDBAction {
        private ShowEditor() {
            super(MenuUtils.getMnemonicStr(AbstractController.EDITOR_CAPTION), ControllerApplication.this.getConfiguration().getIcon("EDIT_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(VIEW_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.EDITOR_CAPTION));
            this.setAccelerator(KeyStroke.getKeyStroke(10, 512, false));
        }

        @Override
        public boolean addSeparatorAfter() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            if (ControllerApplication.this.getApplicationView().getCurrentDPV() != null && ControllerApplication.this.getApplicationView().getCurrentDPV().getCurrentSelection() != null) {
                SelectableObject so = ControllerApplication.this.getApplicationView().getCurrentDPV().getCurrentSelection();
                if (so.getSelectedDesignObject() != null) {
                    so.getSelectedDesignObject().showPropertyDialog();
                }
            } else {
                Object selected;
                TreePath path = ControllerApplication.this.getApplicationView().getBrowserPanel().getJTree().getSelectionPath();
                if (path != null && (selected = path.getLastPathComponent()) instanceof DesignObject) {
                    ((DesignObject)selected).showPropertyDialog();
                }
            }
        }
    }
}

