/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.process;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectPlaceHolder;
import oracle.dbtools.crest.model.design.Label;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.process.AbstractProcessObject;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.Flow;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLWriter;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultEdge;
import oracle.dbtools.crest.swingui.diagram.graph.EdgeView;
import oracle.dbtools.crest.swingui.diagram.graph.PortView;
import oracle.dbtools.crest.swingui.process.TVFlow;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WXMLDataFlowDesign
extends AbstractXMLWriter {
    private DataFlowDesign design = null;

    public WXMLDataFlowDesign(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    public boolean canWrite(Object object) {
        return object instanceof DataFlowDesign;
    }

    @Override
    public Document writeDocument(Object object) {
        this.design = (DataFlowDesign)object;
        if (this.design.getAppView().isSelectedForSave(object)) {
            Document doc = this.createDocument("design");
            Element designElm = doc.getDocumentElement();
            designElm.setAttribute("id", StringUtilities.encodeAttributeValue(this.design.getObjectID()));
            designElm.setAttribute("top_level_dfd_design", String.valueOf(this.design.isTopLevel()));
            Element referenced = doc.createElement("ref");
            designElm.appendChild(referenced);
            Element vGlobals = doc.createElement("synonyms_for_globals");
            designElm.appendChild(vGlobals);
            Element vFlows = doc.createElement("view_flows");
            designElm.appendChild(vFlows);
            Collection all = this.design.getStorableDesignObjects();
            Iterator it = all.iterator();
            DesignObject designObject = null;
            while (it.hasNext()) {
                designObject = (DesignObject)it.next();
                this.handleDesignObject(referenced, designObject);
            }
            this.handleSynonymsForGlobals(this.design, vGlobals);
            this.handleFlows(this.design, vFlows);
            this.appendDisplayProperties(designElm, this.design.getMainView());
            this.appendDocumentsInfo(doc, designElm, this.design);
            this.appendPartiesInfo(doc, designElm, this.design);
            this.appendDiagramViews(doc, designElm, this.design);
            this.design.setDirty(false);
            this.design.getMainView().setDirty(false);
            this.design.getMainDPVPlaceHolder().setDirty(false);
            return doc;
        }
        return null;
    }

    private void appendDocumentsInfo(Document doc, Element designElm, DataFlowDesign design) {
        this.appendObjects(designElm, design.getDocuments().toArray(), "documents");
    }

    private void appendPartiesInfo(Document doc, Element docElement, DataFlowDesign design) {
        this.appendObjects(docElement, design.getResponsibleParties().toArray(), "parties");
    }

    protected void appendObjects(Element objectInfoNode, Object[] objects, String id) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (int i = 0; i < objects.length; ++i) {
            DesignObject desObj = (DesignObject)objects[i];
            map.put(String.valueOf(i + 1), StringUtilities.encodeAttributeValue(desObj.getObjectID()));
        }
        this.appendProperties(objectInfoNode, id, map);
    }

    @Override
    protected void appendProperties(Element objectInfoNode, String id, Map map) {
        Element propertiesList = objectInfoNode.getOwnerDocument().createElement(id);
        Object[] keys = map.keySet().toArray();
        for (int i = 0; i < keys.length; ++i) {
            String key = (String)keys[i];
            String value = (String)map.get(key);
            if (key.equalsIgnoreCase("object.property.auto.DialogVisible")) continue;
            Element param = objectInfoNode.getOwnerDocument().createElement("parameter");
            propertiesList.appendChild(param);
            this.appendProperty(param, key, value);
        }
        objectInfoNode.appendChild(propertiesList);
    }

    private void handleDesignObject(Element referenced, DesignObject designObject) {
        if (!this.getPersistenceManager().isXML_FromDataBase()) {
            if (this.getPersistenceManager().isCheckDirty()) {
                if (designObject.isDirty()) {
                    this.getPersistenceManager().write(designObject);
                }
            } else {
                this.getPersistenceManager().write(designObject);
            }
        }
        this.appendReferencedObjectElement(referenced, designObject);
    }

    private void appendReferencedObjectElement(Element parentNode, DesignObject designObject) {
        if (designObject instanceof Note && designObject.getFirstViewForDPV(this.design.getMainView()) == null) {
            return;
        }
        Document doc = parentNode.getOwnerDocument();
        Element objInfo = doc.createElement("objectid");
        objInfo.setAttribute("role", designObject.belongsToDesign() ? OBJECT_CONTAINS : OBJECT_USES);
        objInfo.setAttribute("type", StringUtilities.encodeAttributeValue(designObject.getObjectTypeName()));
        objInfo.setAttribute("oid", StringUtilities.encodeAttributeValue(designObject.getObjectID()));
        if (designObject instanceof Process) {
            objInfo.setAttribute("process_number", String.valueOf(this.design.getProcessNumber((Process)designObject)));
        }
        this.appendGraphicalInfo(objInfo, designObject);
        parentNode.appendChild(objInfo);
    }

    public void appendGraphicalInfo(Element objInfo, DesignObject designObject) {
        ApplicationView view = designObject.getDesign().getAppView();
        if (view != null) {
            Element graphInfo = objInfo.getOwnerDocument().createElement("graphical");
            Map map = view.getGraphicalPropsFor(designObject);
            Iterator it = map.keySet().iterator();
            while (it.hasNext()) {
                Element param = objInfo.getOwnerDocument().createElement("parameter");
                graphInfo.appendChild(param);
                String key = (String)it.next();
                param.setAttribute("name", key);
                param.setAttribute("value", (String)map.get(key));
            }
            objInfo.appendChild(graphInfo);
        }
    }

    @Override
    public String getFilenameFor(Object object) {
        DataFlowDesign dsn = (DataFlowDesign)object;
        return StringUtilities.encodeAttributeValue(dsn.getObjectID());
    }

    @Override
    public String getRelativePath() {
        if (this.design != null && this.design.getAppView() != null) {
            String designName = this.design.getAppView().getDesignName();
            StringBuffer buffer = new StringBuffer();
            buffer.append('/').append(designName).append('/').append(DATAFLOW_PATH);
            return buffer.toString();
        }
        return DATAFLOW_PATH;
    }

    public void handleFlows(DataFlowDesign dsn, Element designElm) {
        if (dsn.getAppView() != null) {
            DesignPartView dpv = dsn.getMainView();
            Iterator it = dsn.getFlowSet().iterator();
            while (it.hasNext()) {
                Flow flow = (Flow)it.next();
                if (flow.getSourceTV(dpv) == null && flow.getTargetTV(dpv) == null) continue;
                this.appendFlowObjectElement(dsn, designElm, flow);
            }
        }
    }

    public void handleSynonymsForGlobals(DataFlowDesign dsn, Element designElm) {
        if (dsn.getAppView() != null) {
            ArrayList collection = new ArrayList();
            dsn.getAgents().addAllElementsTo(collection);
            dsn.getStores().addAllElementsTo(collection);
            dsn.getExtProcesses().addAllElementsTo(collection);
            DesignPartView dpv = dsn.getMainView();
            for (DesignObjectPlaceHolder dph : collection) {
                AbstractProcessObject obj = (AbstractProcessObject)dph.getDesignObject();
                this.appendSynonymForGlobalElement(designElm, obj, dpv);
            }
        }
    }

    private void appendSynonymForGlobalElement(Element parentNode, AbstractProcessObject designObject, DesignPartView dpv) {
        Document doc = parentNode.getOwnerDocument();
        TopView tv = (TopView)designObject.getViewsForDPV(dpv).get(0);
        Element objInfo = doc.createElement("objectid");
        objInfo.setAttribute("role", designObject.belongsToDesign() ? OBJECT_CONTAINS : OBJECT_USES);
        objInfo.setAttribute("type", StringUtilities.encodeAttributeValue(designObject.getObjectTypeName()));
        objInfo.setAttribute("oid", StringUtilities.encodeAttributeValue(designObject.getObjectID()));
        this.appendGraphicalInfo(objInfo, designObject, tv);
        parentNode.appendChild(objInfo);
    }

    public void appendGraphicalInfo(Element objInfo, DesignObject designObject, TopView tv) {
        ApplicationView view = designObject.getDesign().getAppView();
        if (view != null) {
            Element graphInfo = objInfo.getOwnerDocument().createElement("graphical");
            Map map = view.getGraphicalPropsFor(tv);
            String viewType = (String)map.get("viewtype");
            graphInfo.setAttribute("viewtype", viewType);
            Iterator it = map.keySet().iterator();
            while (it.hasNext()) {
                Element param = objInfo.getOwnerDocument().createElement("parameter");
                graphInfo.appendChild(param);
                String key = (String)it.next();
                param.setAttribute("name", key);
                param.setAttribute("value", (String)map.get(key));
            }
            objInfo.appendChild(graphInfo);
        }
    }

    private void appendFlowObjectElement(DataFlowDesign dsn, Element parentNode, Flow flow) {
        Document doc = parentNode.getOwnerDocument();
        DesignPartView dpv = dsn.getMainView();
        TVFlow tv = (TVFlow)flow.getViewFor(dpv);
        Element objInfo = doc.createElement("objectid");
        objInfo.setAttribute("role", "represents");
        objInfo.setAttribute("type", flow.getObjectTypeName());
        objInfo.setAttribute("oid", StringUtilities.encodeAttributeValue(flow.getObjectID()));
        objInfo.setAttribute("viewid_source", flow.getSourceTV(dpv) != null ? flow.getSourceTV(dpv).getViewID() : NULL_STR);
        objInfo.setAttribute("viewid_target", flow.getTargetTV(dpv) != null ? flow.getTargetTV(dpv).getViewID() : NULL_STR);
        Element points = doc.createElement("points");
        if (tv != null) {
            if (tv.getCellView() != null) {
                EdgeView acv = (EdgeView)((DefaultEdge)tv.getCellView().getCell()).getCellView();
                List edgePoints = acv.getPoints();
                for (int i = 0; i < edgePoints.size(); ++i) {
                    Object obj = edgePoints.get(i);
                    Point2D p = obj instanceof PortView ? ((PortView)obj).getPoint() : (Point2D)obj;
                    if (p == null) continue;
                    Element point = doc.createElement("point");
                    point.setAttribute("x_coordinate", Double.toString(p.getX()));
                    point.setAttribute("y_coordinate", Double.toString(p.getY()));
                    points.appendChild(point);
                }
            } else {
                List edgePoints = tv.getEdgePoints();
                for (int i = 0; i < edgePoints.size(); ++i) {
                    Object obj = edgePoints.get(i);
                    Point2D p = obj instanceof PortView ? ((PortView)obj).getPoint() : (Point2D)obj;
                    if (p == null) continue;
                    Element point = doc.createElement("point");
                    point.setAttribute("x_coordinate", Double.toString(p.getX()));
                    point.setAttribute("y_coordinate", Double.toString(p.getY()));
                    points.appendChild(point);
                }
            }
        }
        objInfo.appendChild(points);
        if (tv != null) {
            EdgeView edgeView = (EdgeView)tv.getCellView();
            if (edgeView != null) {
                Element labels = doc.createElement("labels");
                Element lbl = doc.createElement("main_label");
                lbl.setAttribute("x_coordinate", Double.toString(tv.getLabelBounds().getX()));
                lbl.setAttribute("y_coordinate", Double.toString(tv.getLabelBounds().getY()));
                lbl.setAttribute("width", Double.toString(tv.getLabelBounds().getWidth()));
                lbl.setAttribute("height", Double.toString(tv.getLabelBounds().getHeight()));
                labels.appendChild(lbl);
                Label label = tv.getLabel(1);
                if (label != null) {
                    this.appendDesignObjectColor(lbl, label);
                    this.appendDesignObjectFonts(lbl, label);
                }
                objInfo.appendChild(labels);
            }
            Element graphycal = doc.createElement("graphical");
            Element param = objInfo.getOwnerDocument().createElement("parameter");
            graphycal.appendChild(param);
            param.setAttribute("name", "use_default_color");
            param.setAttribute("value", Boolean.toString(tv.useDefaultColor()));
            if (!tv.useDefaultColor()) {
                param = objInfo.getOwnerDocument().createElement("parameter");
                graphycal.appendChild(param);
                param.setAttribute("name", "color");
                param.setAttribute("value", tv.getBackgroundColor() != null ? Integer.toString(tv.getBackgroundColor().getRGB()) : NULL_STR);
                param = objInfo.getOwnerDocument().createElement("parameter");
                graphycal.appendChild(param);
                param.setAttribute("name", "width");
                param.setAttribute("value", Integer.toString(tv.getLineWidth()));
            }
            objInfo.appendChild(graphycal);
        }
        parentNode.appendChild(objInfo);
    }
}

