/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.multidimensional;

import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.multidimensional.CalculatedAttribute;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.SlowChangingAttribute;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractRXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.multidimensional.MDConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RXMLLevel
extends AbstractRXMLDesignObject
implements MDConstants {
    public RXMLLevel(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    protected DesignObject instantiateDesignObject(String objectID, Design design, Element objInfo) {
        return design.getMultidimensionalDesign().getLevelSet().createLevel(StringUtilities.decodeAttributeValue(objectID));
    }

    @Override
    public Object recreateObject(Element objInfo, Design design, boolean tryReadWriteLocking) {
        DesignObject attr;
        DesignObject dattr;
        ContainedObject attribute;
        String aID;
        int i;
        ContainedObject column;
        String valueColumnID;
        ContainedObject column2;
        ContainerObject entity;
        Level level = (Level)super.recreateObject(objInfo, design, tryReadWriteLocking);
        TreeMap<String, String> map = this.getProperties(objInfo, "attributes");
        level.setDescription((String)map.get("description"));
        String levelEntityID = (String)map.get("entity");
        if (!"null".equalsIgnoreCase(levelEntityID) && (entity = (ContainerObject)level.getDesign().getDesignObject(levelEntityID)) != null) {
            level.setLevelEntity(entity);
        }
        level.setSelectionCriteria((String)map.get("selectioncriteria"));
        level.setSelectionCriteriaDescription((String)map.get("selectioncriteriades"));
        level.setValueBasedHierarchy(Boolean.valueOf((String)map.get("valuebased")));
        String defAttr = (String)map.get("default_attribute");
        String awShort_Desc = (String)map.get("aw_short_description");
        String awLong_Desc = (String)map.get("aw_long_description");
        String awTime_Span = (String)map.get("aw_time_span");
        String awTime_end = (String)map.get("aw_time_end");
        String nameColumnID = (String)map.get("name_column");
        if (!"null".equalsIgnoreCase(nameColumnID) && (column2 = (ContainedObject)level.getDesign().getDesignObject(nameColumnID)) != null) {
            level.setNameColumn(column2);
        }
        if (!"null".equalsIgnoreCase(valueColumnID = (String)map.get("value_column")) && (column = (ContainedObject)level.getDesign().getDesignObject(valueColumnID)) != null) {
            level.setValueColumn(column);
        }
        Map objMap = this.getProperties(objInfo, "levelkey");
        Object[] objects = objMap.keySet().toArray();
        for (i = 0; i < objects.length; ++i) {
            aID = (String)objMap.get(objects[i]);
            attribute = (ContainedObject)level.getDesign().getDesignObject(aID);
            if (attribute == null) continue;
            level.addToLevelKey(attribute);
        }
        if (level.isValueBasedHierarchy()) {
            level.setRootIdentification((String)map.get("rootident"));
            level.setIdentificationValue((String)map.get("identvalue"));
            objMap = this.getProperties(objInfo, "parentkey");
            objects = objMap.keySet().toArray();
            for (i = 0; i < objects.length; ++i) {
                aID = (String)objMap.get(objects[i]);
                attribute = (ContainedObject)level.getDesign().getDesignObject(aID);
                if (attribute == null) continue;
                level.addToParentKey(attribute);
            }
        }
        this.handleCalculatedAttributes(objInfo, level);
        if (defAttr != null && (dattr = level.getAttributeById(defAttr)) != null) {
            level.setDefaultAttribute(dattr);
        }
        if (RXMLLevel.getFirstChildByTagName(objInfo, "contained") != null) {
            NodeList objElms = RXMLLevel.getFirstChildByTagName(objInfo, "contained").getElementsByTagName("slowchangingattribute");
            int length = objElms.getLength();
            for (int i2 = 0; i2 < length; ++i2) {
                String indexed;
                String name;
                Element child = (Element)objElms.item(i2);
                map = new TreeMap<String, String>();
                NodeList propList = child.getElementsByTagName("parameter");
                int plength = propList.getLength();
                for (int j = 0; j < plength; ++j) {
                    Element param = (Element)propList.item(j);
                    map.put(param.getAttribute("name"), param.getAttribute("value"));
                }
                String attrID = (String)map.get("attributeid");
                ContainedObject attribute2 = (ContainedObject)level.getDesign().getDesignObject(attrID);
                if (attribute2 == null) continue;
                SlowChangingAttribute scha = new SlowChangingAttribute(level, attribute2);
                level.addDescriptiveAttribute(scha);
                String type = (String)map.get("type");
                scha.setType(type);
                String classification = (String)map.get("classification");
                if (classification != null) {
                    scha.setClassification(classification);
                }
                if ((name = (String)map.get("name")) != null) {
                    scha.setName(name);
                }
                if ((indexed = (String)map.get("indexed")) != null && "true".equalsIgnoreCase(indexed)) {
                    scha.setIndexed(true);
                }
                String historyAttributes = (String)map.get("historyattributes");
                StringTokenizer tokenizer = new StringTokenizer(historyAttributes, ",");
                while (tokenizer.hasMoreTokens()) {
                    String haID = tokenizer.nextToken();
                    attribute2 = (ContainedObject)level.getDesign().getDesignObject(haID);
                    if (attribute2 == null) continue;
                    scha.addHistoryAttribute(attribute2);
                }
            }
        }
        Level.OraAWAttributes oa = level.getOraAWAttributes();
        if (awShort_Desc != null && (attr = level.getAttributeById(awShort_Desc)) != null) {
            oa.shortDesc = (ContainedObject)attr;
        }
        if (awLong_Desc != null && (attr = level.getAttributeById(awLong_Desc)) != null) {
            oa.longDesc = (ContainedObject)attr;
        }
        if (awTime_end != null && (attr = level.getAttributeById(awTime_end)) != null) {
            oa.timeEnd = (ContainedObject)attr;
        }
        if (awTime_Span != null && (attr = level.getAttributeById(awTime_Span)) != null) {
            oa.timeSpan = (ContainedObject)attr;
        }
        StringBuffer buffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            buffer.append(this.getPersistenceManager().getAppView().getCurrentDesign().getDesignPath()).append('/');
        }
        buffer.append(this.getRelativePath()).append('/').append(StringUtilities.decodeAttributeValue(level.getObjectID())).append(".dmd");
        level.setFilePath(buffer.toString());
        return level;
    }

    private void handleCalculatedAttributes(Element parentNode, Level level) {
        Element list = RXMLLevel.getFirstChildByTagName(parentNode, "calculated_attributes");
        if (list != null) {
            NodeList nodes = list.getElementsByTagName("contained");
            int count = nodes.getLength();
            for (int i = 0; i < count; ++i) {
                Element elem = (Element)nodes.item(i);
                String name = elem.getAttribute("name");
                String id = elem.getAttribute("oid");
                String func = elem.getAttribute("ca_expression");
                CalculatedAttribute ca = level.addCalculatedAttribute(StringUtilities.decodeAttributeValue(name), id);
                ca.setFunction(StringUtilities.decodeAttributeValue(func));
            }
        }
    }

    @Override
    public Object recreateDesign(Document doc, DesignPart design, boolean tryReadWriteLocking) {
        return null;
    }

    @Override
    public String getRelativePath() {
        StringBuffer buffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null && this.getPersistenceManager().getAppView().getCurrentDesign().getMultidimensionalDesigns().size() > 0) {
            String designName = this.getPersistenceManager().getAppView().getDesignName();
            String dfDesName = this.getPersistenceManager().getAppView().getCurrentDesign().getMultidimensionalDesign().getObjectID();
            buffer.append(designName).append('/').append("multidimensional").append('/').append(dfDesName).append('/');
        }
        buffer.append(this.getConfiguration().get("levelPath"));
        return buffer.toString();
    }

    @Override
    public boolean isReaderForClass(Class type) {
        return type == Level.class;
    }
}

