/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.model.SubViewObjectSet;
import oracle.dbtools.crest.model.TypeSubstitution;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DiagramView;
import oracle.dbtools.crest.model.design.Label;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLWriter;
import oracle.dbtools.crest.model.persistence.xml.WXMLSubview;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TVTypeSubstitution;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.graph.CellView;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultEdge;
import oracle.dbtools.crest.swingui.diagram.graph.EdgeView;
import oracle.dbtools.crest.swingui.diagram.graph.PortView;
import oracle.dbtools.crest.swingui.logical.DPVLogicalSubView;
import oracle.dbtools.crest.swingui.logical.TVArc;
import oracle.dbtools.crest.swingui.logical.TVRelation;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WXMLLogicalDesign
extends AbstractXMLWriter {
    private LogicalDesign design = null;
    private static float NFS = 2.4f;
    private float version = NFS;

    public WXMLLogicalDesign(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    public boolean canWrite(Object object) {
        return object instanceof LogicalDesign;
    }

    @Override
    public Document writeDocument(Object object) {
        this.design = (LogicalDesign)object;
        if (this.design.getAppView().isSelectedForSave(object)) {
            this.version = this.design.getDesign().getVersion();
            Design des = this.design.getDesign();
            Document doc = this.createDocument("design");
            Element designElm = doc.getDocumentElement();
            designElm.setAttribute("id", StringUtilities.encodeAttributeValue(this.design.getObjectID()));
            Element referenced = doc.createElement("ref");
            designElm.appendChild(referenced);
            Element vSynonyms = null;
            Element vRelations = null;
            Element logSubViews = null;
            if (this.version < NFS) {
                vSynonyms = doc.createElement("view_synonyms");
                designElm.appendChild(vSynonyms);
                vRelations = doc.createElement("view_relations");
                designElm.appendChild(vRelations);
                logSubViews = doc.createElement("logical_sub_views_collection");
                designElm.appendChild(logSubViews);
            }
            Element type_subst = doc.createElement("type_substitutions");
            designElm.appendChild(type_subst);
            Collection all = this.design.getStorableDesignObjects();
            Iterator it = all.iterator();
            DesignObject designObject = null;
            while (it.hasNext()) {
                designObject = (DesignObject)it.next();
                if (!des.shouldExport(designObject)) continue;
                this.handleDesignObject(referenced, designObject);
            }
            if (this.version < NFS) {
                this.handleTVSynonyms(this.design, vSynonyms);
                this.handleRelations(this.design, vRelations);
            }
            this.handleTypeSubstitutions(this.design, type_subst);
            if (this.version < NFS) {
                this.appendSubordinateDisplays(designElm, this.design.getMainView());
                this.handleLogicalSubViews(this.design, logSubViews);
                this.appendDiagramViews(doc, designElm, this.design);
            } else {
                WXMLSubview svWriter = this.getPersistenceManager().getDesignPartViewWriter();
                svWriter.appendExtSubViews(designElm, this.design);
            }
            this.appendDocumentsInfo(doc, designElm, this.design);
            this.appendPartiesInfo(doc, designElm, this.design);
            this.appendNamingOptions(doc, designElm, this.design);
            this.design.setDirty(false);
            return doc;
        }
        return null;
    }

    private void appendDocumentsInfo(Document doc, Element designElm, LogicalDesign design) {
        this.appendObjects(designElm, design.getDocuments().toArray(), "documents");
    }

    private void appendPartiesInfo(Document doc, Element docElement, LogicalDesign design) {
        this.appendObjects(docElement, design.getResponsibleParties().toArray(), "parties");
    }

    protected void appendObjects(Element objectInfoNode, Object[] objects, String id) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (int i = 0; i < objects.length; ++i) {
            DesignObject desObj = (DesignObject)objects[i];
            map.put(String.valueOf(i + 1), StringUtilities.encodeAttributeValue(desObj.getObjectID()));
        }
        this.appendProperties(objectInfoNode, id, map);
    }

    @Override
    protected void appendProperties(Element objectInfoNode, String id, Map map) {
        Element propertiesList = objectInfoNode.getOwnerDocument().createElement(id);
        Object[] keys = map.keySet().toArray();
        for (int i = 0; i < keys.length; ++i) {
            String key = (String)keys[i];
            String value = (String)map.get(key);
            if (key.equalsIgnoreCase("object.property.auto.DialogVisible")) continue;
            Element param = objectInfoNode.getOwnerDocument().createElement("parameter");
            propertiesList.appendChild(param);
            this.appendProperty(param, key, value);
        }
        objectInfoNode.appendChild(propertiesList);
    }

    private void handleDesignObject(Element referenced, DesignObject designObject) {
        if (!this.getPersistenceManager().isXML_FromDataBase()) {
            boolean check = this.getPersistenceManager().isCheckDirty() ? designObject.isDirty() : true;
            if (check) {
                this.getPersistenceManager().write(designObject);
            }
        }
        this.appendReferencedObjectElement(referenced, designObject);
    }

    private void appendReferencedObjectElement(Element parentNode, DesignObject designObject) {
        if (designObject instanceof Note && designObject.getFirstViewForDPV(this.design.getMainView()) == null) {
            return;
        }
        Document doc = parentNode.getOwnerDocument();
        Element objInfo = doc.createElement("objectid");
        objInfo.setAttribute("role", designObject.belongsToDesign() ? OBJECT_CONTAINS : OBJECT_USES);
        objInfo.setAttribute("type", StringUtilities.encodeAttributeValue(designObject.getObjectTypeName()));
        objInfo.setAttribute("oid", StringUtilities.encodeAttributeValue(designObject.getObjectID()));
        if (this.version < NFS) {
            this.appendGraphicalInfo(objInfo, designObject);
        }
        parentNode.appendChild(objInfo);
    }

    public void appendGraphicalInfo(Element objInfo, DesignObject designObject) {
        ApplicationView view = designObject.getDesign().getAppView();
        if (view != null) {
            Element graphInfo = objInfo.getOwnerDocument().createElement("graphical");
            Map map = view.getGraphicalPropsFor(designObject);
            Iterator it = map.keySet().iterator();
            while (it.hasNext()) {
                Element param = objInfo.getOwnerDocument().createElement("parameter");
                graphInfo.appendChild(param);
                String key = (String)it.next();
                param.setAttribute("name", key);
                param.setAttribute("value", (String)map.get(key));
            }
            objInfo.appendChild(graphInfo);
        }
    }

    @Override
    public String getFilenameFor(Object object) {
        LogicalDesign dsn = (LogicalDesign)object;
        return dsn.getName();
    }

    @Override
    public String getRelativePath() {
        if (this.design != null && this.design.getAppView() != null) {
            String designName = this.design.getAppView().getDesignName();
            StringBuffer buffer = new StringBuffer();
            buffer.append(designName).append('/').append("logical");
            return buffer.toString();
        }
        return "logical";
    }

    public void handleTVSynonyms(LogicalDesign dsn, Element designElm) {
        if (this.design.getAppView() != null) {
            DesignPartView dpv = dsn.getMainView();
            Iterator it = dsn.getEntitySet().iterator();
            while (it.hasNext()) {
                Entity ent = (Entity)it.next();
                if (!dsn.getDesign().shouldExport(ent)) continue;
                for (TopView tv : ent.getViewSynonims(dpv)) {
                    this.appendReferencedObjectReprElement(designElm, tv);
                }
            }
            it = dsn.getEntityViewSet().iterator();
            while (it.hasNext()) {
                EntityView tabv = (EntityView)it.next();
                if (!dsn.getDesign().shouldExport(tabv)) continue;
                for (TopView tv : tabv.getViewSynonims(dpv)) {
                    this.appendReferencedObjectReprElement(designElm, tv);
                }
            }
        }
    }

    private void appendReferencedObjectReprElement(Element parentNode, TopView tv) {
        Document doc = parentNode.getOwnerDocument();
        DesignObject designObject = tv.getModel();
        Element objInfo = doc.createElement("objectid");
        objInfo.setAttribute("role", "represents");
        objInfo.setAttribute("type", StringUtilities.encodeAttributeValue(designObject.getObjectTypeName()));
        objInfo.setAttribute("oid", StringUtilities.encodeAttributeValue(designObject.getObjectID()));
        objInfo.setAttribute("viewid", tv.getViewID());
        objInfo.setAttribute("tv_generator_id", tv.getGeneratorID());
        this.appendGraphicalInfo(objInfo, tv);
        parentNode.appendChild(objInfo);
    }

    public void appendGraphicalInfo(Element objInfo, TopView tv) {
        DesignObject designObject = tv.getModel();
        ApplicationView view = designObject.getDesign().getAppView();
        if (view != null) {
            Element graphInfo = objInfo.getOwnerDocument().createElement("graphical");
            Map map = view.getGraphicalPropsFor(tv);
            Iterator it = map.keySet().iterator();
            while (it.hasNext()) {
                Element param = objInfo.getOwnerDocument().createElement("parameter");
                graphInfo.appendChild(param);
                String key = (String)it.next();
                param.setAttribute("name", key);
                param.setAttribute("value", (String)map.get(key));
            }
            objInfo.appendChild(graphInfo);
        }
    }

    public void handleRelations(LogicalDesign dsn, Element designElm) {
        if (dsn.getAppView() != null) {
            Relation rel;
            Iterator it = dsn.getRelationSet().iterator();
            while (it.hasNext()) {
                rel = (Relation)it.next();
                if (!dsn.getDesign().shouldExport(rel)) continue;
                this.appendRelationObjectElement(dsn, designElm, rel);
            }
            it = dsn.getInheritanceRelationSet().iterator();
            while (it.hasNext()) {
                rel = (Relation)it.next();
                if (!dsn.getDesign().shouldExport(rel.getSourceObject()) || !dsn.getDesign().shouldExport(rel.getTargetObject())) continue;
                this.appendRelationObjectElement(dsn, designElm, rel);
            }
        }
    }

    private void appendRelationObjectElement(LogicalDesign dsn, Element parentNode, Relation rel) {
        Point2D p;
        Object obj;
        int i;
        List edgePoints;
        Document doc = parentNode.getOwnerDocument();
        DesignPartView dpv = dsn.getMainView();
        TVRelation tv = (TVRelation)rel.getTopView();
        Element objInfo = doc.createElement("objectid");
        objInfo.setAttribute("role", "represents");
        objInfo.setAttribute("type", StringUtilities.encodeAttributeValue(rel.getObjectTypeName()));
        objInfo.setAttribute("oid", rel.getObjectID());
        objInfo.setAttribute("viewid_source", rel.getSourceTV(dpv) != null ? rel.getSourceTV(dpv).getViewID() : NULL_STR);
        objInfo.setAttribute("viewid_target", rel.getTargetTV(dpv) != null ? rel.getTargetTV(dpv).getViewID() : NULL_STR);
        Element points = doc.createElement("points");
        if (tv != null && tv.getEdge() != null && tv.getEdge().getCellView() != null) {
            edgePoints = ((EdgeView)tv.getEdge().getCellView()).getPoints();
            for (i = 0; i < edgePoints.size(); ++i) {
                obj = edgePoints.get(i);
                p = obj instanceof PortView ? ((PortView)obj).getPoint() : (Point2D)obj;
                if (p == null) continue;
                Element point = doc.createElement("point");
                point.setAttribute("x_coordinate", Double.toString(p.getX()));
                point.setAttribute("y_coordinate", Double.toString(p.getY()));
                points.appendChild(point);
            }
        } else if (tv != null) {
            edgePoints = tv.getEdgePoints();
            for (i = 0; i < edgePoints.size(); ++i) {
                obj = edgePoints.get(i);
                p = obj instanceof PortView ? ((PortView)obj).getPoint() : (Point2D)obj;
                if (p == null) continue;
                Element point = doc.createElement("point");
                point.setAttribute("x_coordinate", Double.toString(p.getX()));
                point.setAttribute("y_coordinate", Double.toString(p.getY()));
                points.appendChild(point);
            }
        }
        objInfo.appendChild(points);
        if (tv != null) {
            EdgeView edgeView = tv.getEdgeView();
            if (edgeView != null) {
                Element labels = doc.createElement("labels");
                Element lbl = doc.createElement("source");
                lbl.setAttribute("x_coordinate", Double.toString(tv.getSourceLabelBounds().getX()));
                lbl.setAttribute("y_coordinate", Double.toString(tv.getSourceLabelBounds().getY()));
                lbl.setAttribute("width", Double.toString(tv.getSourceLabelBounds().getWidth()));
                lbl.setAttribute("height", Double.toString(tv.getSourceLabelBounds().getHeight()));
                labels.appendChild(lbl);
                Label label = tv.getLabel(0);
                if (label != null) {
                    this.appendDesignObjectColor(lbl, label);
                    this.appendDesignObjectFonts(lbl, label);
                }
                lbl = doc.createElement("target");
                lbl.setAttribute("x_coordinate", Double.toString(tv.getTargetLabelBounds().getX()));
                lbl.setAttribute("y_coordinate", Double.toString(tv.getTargetLabelBounds().getY()));
                lbl.setAttribute("width", Double.toString(tv.getTargetLabelBounds().getWidth()));
                lbl.setAttribute("height", Double.toString(tv.getTargetLabelBounds().getHeight()));
                labels.appendChild(lbl);
                label = tv.getLabel(2);
                if (label != null) {
                    this.appendDesignObjectColor(lbl, label);
                    this.appendDesignObjectFonts(lbl, label);
                }
                objInfo.appendChild(labels);
            }
            Element graphycal = doc.createElement("graphical");
            Element param = objInfo.getOwnerDocument().createElement("parameter");
            graphycal.appendChild(param);
            param.setAttribute("name", "use_default_color");
            param.setAttribute("value", Boolean.toString(tv.useDefaultColor()));
            if (!tv.useDefaultColor()) {
                param = objInfo.getOwnerDocument().createElement("parameter");
                graphycal.appendChild(param);
                param.setAttribute("name", "color");
                param.setAttribute("value", tv.getBackgroundColor() != null ? Integer.toString(tv.getBackgroundColor().getRGB()) : NULL_STR);
                param = objInfo.getOwnerDocument().createElement("parameter");
                graphycal.appendChild(param);
                param.setAttribute("name", "width");
                param.setAttribute("value", Integer.toString(tv.getLineWidth()));
            }
            objInfo.appendChild(graphycal);
        }
        parentNode.appendChild(objInfo);
    }

    public void handleLogicalSubViews(LogicalDesign dsn, Element logSubViews) {
        if (dsn.getAppView() != null) {
            Document doc = logSubViews.getOwnerDocument();
            SubViewObjectSet col = dsn.getLogicalDesignSubviews();
            Iterator itsv = col.iterator();
            while (itsv.hasNext()) {
                Relation rel;
                DesignPartViewPlaceHolder dpvPH = (DesignPartViewPlaceHolder)itsv.next();
                DPVLogicalSubView dpv = (DPVLogicalSubView)dpvPH.getDesignPartView();
                if (!dsn.getDesign().shouldExportDPV(dpv)) continue;
                Element logSubView = doc.createElement("logical_sub_view");
                logSubView.setAttribute("subview_name", StringUtilities.encodeAttributeValue(dpv.getName()));
                logSubView.setAttribute("id", dpv.getDPVId());
                logSubView.setAttribute("generator", dpv.getGeneratorId());
                logSubView.setAttribute("visible", dpvPH.getVisible() ? "true" : "false");
                logSubView.setAttribute("comment", StringUtilities.encodeAttributeValue(dpvPH.getComment()));
                logSubView.setAttribute("notes", StringUtilities.encodeAttributeValue(dpvPH.getNotes()));
                logSubViews.appendChild(logSubView);
                this.addEntitiesInDPV(dsn, logSubView, dpv);
                this.addEntitiyViewsInDPV(dsn, logSubView, dpv);
                this.addNotesInDPV(dsn, logSubView, dpv);
                this.addDiagramViewsInDPV(dsn, logSubView, dpv);
                Iterator itrel = dsn.getRelationSet().iterator();
                while (itrel.hasNext()) {
                    rel = (Relation)itrel.next();
                    this.appendSubViewInfoRelation(logSubView, dpv, rel);
                }
                itrel = dsn.getInheritanceRelationSet().iterator();
                while (itrel.hasNext()) {
                    rel = (Relation)itrel.next();
                    this.appendSubViewInfoRelation(logSubView, dpv, rel);
                }
                itrel = dsn.getTypeSubstitutionSet().iterator();
                while (itrel.hasNext()) {
                    TypeSubstitution ts = (TypeSubstitution)itrel.next();
                    this.appendSubViewInfoTypeSubst(logSubView, dpv, ts);
                }
                this.addArcViewsInDPV(dsn, logSubView, dpv);
                this.appendSubordinateDisplays(logSubView, dpv);
            }
        }
    }

    private void addEntitiesInDPV(LogicalDesign dsn, Element logSubView, DPVLogicalSubView dpv) {
        Iterator it = dsn.getEntitySet().iterator();
        while (it.hasNext()) {
            Entity entity = (Entity)it.next();
            for (TopView tv : entity.getViewsForDPV(dpv)) {
                this.appendReferencedObjectReprElement(logSubView, tv);
            }
        }
    }

    private void addEntitiyViewsInDPV(LogicalDesign dsn, Element logSubView, DPVLogicalSubView dpv) {
        Iterator it = dsn.getEntityViewSet().iterator();
        while (it.hasNext()) {
            EntityView entity = (EntityView)it.next();
            for (TopView tv : entity.getViewsForDPV(dpv)) {
                this.appendReferencedObjectReprElement(logSubView, tv);
            }
        }
    }

    private void addNotesInDPV(LogicalDesign dsn, Element logSubView, DPVLogicalSubView dpv) {
        Iterator it = dsn.getNoteSet().iterator();
        while (it.hasNext()) {
            Note note = (Note)it.next();
            TopView tv = note.getFirstViewForDPV(dpv);
            if (tv == null) continue;
            this.appendReferencedObjectReprElement(logSubView, tv);
        }
    }

    private void addDiagramViewsInDPV(LogicalDesign dsn, Element logSubView, DPVLogicalSubView dpv) {
        Iterator it = dsn.getDiagramViewSet().iterator();
        while (it.hasNext()) {
            DiagramView dv = (DiagramView)it.next();
            TopView tv = dv.getFirstViewForDPV(dpv);
            if (tv == null) continue;
            this.appendDiagramViewInfo(logSubView.getOwnerDocument(), logSubView, dv, tv);
        }
    }

    private void addArcViewsInDPV(LogicalDesign dsn, Element logSubView, DPVLogicalSubView dpv) {
        CellView[] cellViews = dpv.getWorkSpace().getDiagramLayoutCache().getRoots();
        for (int j = 0; j < cellViews.length; ++j) {
            TopView tv = ((DefaultDiagramCell)cellViews[j].getCell()).getTopView();
            if (tv.isConnection() || !(cellViews[j].getCell() instanceof DefaultDiagramCell) || !(tv instanceof TVArc)) continue;
            this.appendReferencedObjectReprElement(logSubView, tv);
        }
    }

    private void appendSubViewInfoRelation(Element parentNode, DesignPartView dpv, Relation rel) {
        block13: {
            try {
                Document doc = parentNode.getOwnerDocument();
                TVRelation tv = (TVRelation)rel.getViewFor(dpv);
                if (tv == null || rel.getSourceTV(dpv) == null || rel.getTargetTV(dpv) == null) break block13;
                Element objInfo = doc.createElement("objectid");
                objInfo.setAttribute("role", "represents");
                objInfo.setAttribute("type", StringUtilities.encodeAttributeValue(rel.getObjectTypeName()));
                objInfo.setAttribute("oid", StringUtilities.encodeAttributeValue(rel.getObjectID()));
                objInfo.setAttribute("viewid_source", rel.getSourceTV(dpv) != null ? rel.getSourceTV(dpv).getViewID() : NULL_STR);
                objInfo.setAttribute("viewid_target", rel.getTargetTV(dpv) != null ? rel.getTargetTV(dpv).getViewID() : NULL_STR);
                Element points = doc.createElement("points");
                if (tv != null) {
                    Point2D p;
                    Object obj;
                    int i;
                    List edgePoints;
                    if (tv.getEdge() != null && tv.getEdge().getCellView() != null) {
                        edgePoints = ((EdgeView)tv.getEdge().getCellView()).getPoints();
                        for (i = 0; i < edgePoints.size(); ++i) {
                            obj = edgePoints.get(i);
                            p = obj instanceof PortView ? ((PortView)obj).getPoint() : (Point2D)obj;
                            if (p == null) continue;
                            Element point = doc.createElement("point");
                            point.setAttribute("x_coordinate", Double.toString(p.getX()));
                            point.setAttribute("y_coordinate", Double.toString(p.getY()));
                            points.appendChild(point);
                        }
                    } else if (tv.getCellView() != null) {
                        edgePoints = ((EdgeView)tv.getCellView()).getPoints();
                        for (i = 0; i < edgePoints.size(); ++i) {
                            obj = edgePoints.get(i);
                            p = obj instanceof PortView ? ((PortView)obj).getPoint() : (Point2D)obj;
                            if (p == null) continue;
                            Element point = doc.createElement("point");
                            point.setAttribute("x_coordinate", Double.toString(p.getX()));
                            point.setAttribute("y_coordinate", Double.toString(p.getY()));
                            points.appendChild(point);
                        }
                    } else {
                        edgePoints = tv.getEdgePoints();
                        for (i = 0; i < edgePoints.size(); ++i) {
                            obj = edgePoints.get(i);
                            p = obj instanceof PortView ? ((PortView)obj).getPoint() : (Point2D)obj;
                            if (p == null) continue;
                            Element point = doc.createElement("point");
                            point.setAttribute("x_coordinate", Double.toString(p.getX()));
                            point.setAttribute("y_coordinate", Double.toString(p.getY()));
                            points.appendChild(point);
                        }
                    }
                }
                objInfo.appendChild(points);
                EdgeView edgeView = tv.getEdgeView();
                if (edgeView != null) {
                    Element labels = doc.createElement("labels");
                    Element lbl = doc.createElement("source");
                    lbl.setAttribute("x_coordinate", Double.toString(tv.getSourceLabelBounds().getX()));
                    lbl.setAttribute("y_coordinate", Double.toString(tv.getSourceLabelBounds().getY()));
                    lbl.setAttribute("width", Double.toString(tv.getSourceLabelBounds().getWidth()));
                    lbl.setAttribute("height", Double.toString(tv.getSourceLabelBounds().getHeight()));
                    labels.appendChild(lbl);
                    Label label = tv.getLabel(0);
                    if (label != null) {
                        this.appendDesignObjectColor(lbl, label);
                        this.appendDesignObjectFonts(lbl, label);
                    }
                    lbl = doc.createElement("target");
                    lbl.setAttribute("x_coordinate", Double.toString(tv.getTargetLabelBounds().getX()));
                    lbl.setAttribute("y_coordinate", Double.toString(tv.getTargetLabelBounds().getY()));
                    lbl.setAttribute("width", Double.toString(tv.getTargetLabelBounds().getWidth()));
                    lbl.setAttribute("height", Double.toString(tv.getTargetLabelBounds().getHeight()));
                    labels.appendChild(lbl);
                    label = tv.getLabel(2);
                    if (label != null) {
                        this.appendDesignObjectColor(lbl, label);
                        this.appendDesignObjectFonts(lbl, label);
                    }
                    objInfo.appendChild(labels);
                }
                parentNode.appendChild(objInfo);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public void handleTypeSubstitutions(LogicalDesign dsn, Element designElm) {
        if (dsn.getAppView() != null) {
            DesignPartView dpv = dsn.getMainView();
            Iterator it = dsn.getTypeSubstitutionSet().iterator();
            while (it.hasNext()) {
                TypeSubstitution ts = (TypeSubstitution)it.next();
                ContainerView chCV = ts.getChildCV(dpv);
                ContainerView parCV = ts.getParentCV(dpv);
                if (chCV == null || parCV == null || !dsn.getDesign().shouldExport(chCV.getModel()) || !dsn.getDesign().shouldExport(parCV.getModel())) continue;
                this.appendTypeSbstElement(dsn, designElm, ts);
            }
        }
    }

    private void appendTypeSbstElement(LogicalDesign dsn, Element parentNode, TypeSubstitution ts) {
        Document doc = parentNode.getOwnerDocument();
        DesignPartView dpv = dsn.getMainView();
        TVTypeSubstitution tv = (TVTypeSubstitution)ts.getViewFor(dpv);
        Element objInfo = doc.createElement("objectid");
        objInfo.setAttribute("role", "represents");
        objInfo.setAttribute("type", ts.getObjectTypeName());
        objInfo.setAttribute("oid", StringUtilities.encodeAttributeValue(ts.getObjectID()));
        if (ts.getChildContainerObject() != null) {
            objInfo.setAttribute("child_id", StringUtilities.encodeAttributeValue(ts.getChildContainerObject().getObjectID()));
        } else {
            objInfo.setAttribute("child_id", "null");
        }
        if (ts.getParentContainerObject() != null) {
            objInfo.setAttribute("parent_id", StringUtilities.encodeAttributeValue(ts.getParentContainerObject().getObjectID()));
        } else {
            objInfo.setAttribute("parent_id", "null");
        }
        objInfo.setAttribute("view_id_child", ts.getChildCV(dpv) != null ? ts.getChildCV(dpv).getViewID() : NULL_STR);
        objInfo.setAttribute("view_id_parent", ts.getParentCV(dpv) != null ? ts.getParentCV(dpv).getViewID() : NULL_STR);
        Element points = doc.createElement("points");
        if (tv != null) {
            EdgeView acv = (EdgeView)((DefaultEdge)tv.getCellView().getCell()).getCellView();
            List edgePoints = acv.getPoints();
            for (int i = 0; i < edgePoints.size(); ++i) {
                Object obj = edgePoints.get(i);
                Point2D p = obj instanceof PortView ? ((PortView)obj).getPoint() : (Point2D)obj;
                Element point = doc.createElement("point");
                point.setAttribute("x_coordinate", Double.toString(p.getX()));
                point.setAttribute("y_coordinate", Double.toString(p.getY()));
                points.appendChild(point);
            }
        }
        objInfo.appendChild(points);
        if (tv != null) {
            Element graphycal = doc.createElement("graphical");
            Element param = objInfo.getOwnerDocument().createElement("parameter");
            graphycal.appendChild(param);
            param.setAttribute("name", "use_default_color");
            param.setAttribute("value", Boolean.toString(tv.useDefaultColor()));
            if (!tv.useDefaultColor()) {
                param = objInfo.getOwnerDocument().createElement("parameter");
                graphycal.appendChild(param);
                param.setAttribute("name", "color");
                param.setAttribute("value", tv.getBackgroundColor() != null ? Integer.toString(tv.getBackgroundColor().getRGB()) : NULL_STR);
                param = objInfo.getOwnerDocument().createElement("parameter");
                graphycal.appendChild(param);
                param.setAttribute("name", "width");
                param.setAttribute("value", Integer.toString(tv.getLineWidth()));
            }
            objInfo.appendChild(graphycal);
        }
        parentNode.appendChild(objInfo);
    }

    private void appendSubViewInfoTypeSubst(Element parentNode, DesignPartView dpv, TypeSubstitution ts) {
        Document doc = parentNode.getOwnerDocument();
        TVTypeSubstitution tv = (TVTypeSubstitution)ts.getViewFor(dpv);
        if (tv != null) {
            Element objInfo = doc.createElement("objectid");
            objInfo.setAttribute("role", "represents");
            objInfo.setAttribute("type", StringUtilities.encodeAttributeValue(ts.getObjectTypeName()));
            objInfo.setAttribute("oid", StringUtilities.encodeAttributeValue(ts.getObjectID()));
            objInfo.setAttribute("view_id_child", ts.getChildCV(dpv) != null ? ts.getChildCV(dpv).getViewID() : NULL_STR);
            objInfo.setAttribute("view_id_parent", ts.getParentCV(dpv) != null ? ts.getParentCV(dpv).getViewID() : NULL_STR);
            Element points = doc.createElement("points");
            if (tv != null) {
                if (tv.getCellView() != null) {
                    EdgeView acv = (EdgeView)((DefaultEdge)tv.getCellView().getCell()).getCellView();
                    List edgePoints = acv.getPoints();
                    for (int i = 0; i < edgePoints.size(); ++i) {
                        Object obj = edgePoints.get(i);
                        Point2D p = obj instanceof PortView ? ((PortView)obj).getPoint() : (Point2D)obj;
                        Element point = doc.createElement("point");
                        point.setAttribute("x_coordinate", Double.toString(p.getX()));
                        point.setAttribute("y_coordinate", Double.toString(p.getY()));
                        points.appendChild(point);
                    }
                } else {
                    List edgePoints = tv.getEdgePoints();
                    for (int i = 0; i < edgePoints.size(); ++i) {
                        Point2D p = (Point2D)edgePoints.get(i);
                        Element point = doc.createElement("point");
                        point.setAttribute("x_coordinate", Double.toString(p.getX()));
                        point.setAttribute("y_coordinate", Double.toString(p.getY()));
                        points.appendChild(point);
                    }
                }
            }
            objInfo.appendChild(points);
            parentNode.appendChild(objInfo);
        }
    }
}

