/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.relational;

import java.util.ArrayList;
import java.util.Iterator;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.DesignRule;
import oracle.dbtools.crest.util.options.namingstandards.NamingStandardRule;

public class DRIndexNamingStandard
extends DesignRule {
    private final String RULE_ID = "C28EC3DA-186B-DA2D-2995-8EA2E1A04954";
    private NamingStandardRule namingRule;
    private String tableName = "";
    private String tableAbbr = "";
    private String modelName = "";

    public DRIndexNamingStandard() {
        this.setName(Messages.getString("DRIndexNamingStandard.IdentifyIndexesWithWrongNamingStandards"));
        this.setDescription(Messages.getString("DRIndexNamingStandard.IndexesWithWrongNamingStandardsNotRecommended"));
    }

    private Object[] getIndexes(Table table) {
        ArrayList<KeyObject> list = new ArrayList<KeyObject>();
        Iterator it = table.getKeySet().iterator();
        while (it.hasNext()) {
            KeyObject key = (KeyObject)it.next();
            if (key.isPK() || key.isUnique() || key.isFK()) continue;
            list.add(key);
        }
        return list.toArray();
    }

    private int getPosition(Index index) {
        Object[] allIndexes = this.getIndexes(index.getTable());
        for (int i = 0; i < allIndexes.length; ++i) {
            Object object = allIndexes[i];
            if (!index.equals(object)) continue;
            return i + 1;
        }
        return 0;
    }

    @Override
    public CheckResult doCheck(Object object) {
        Index index = (Index)object;
        this.namingRule = index.getDesign().getDesignLevelSettings().getNamingStandardRule();
        String result = this.namingRule.getIdxConstr();
        if (!(index.isPK() || index.isUnique() || index.isFK())) {
            int counter = this.getPosition(index);
            Table table = index.getTable();
            this.tableName = table.getName();
            this.tableAbbr = table.getAbbreviation();
            if (this.tableAbbr.equals("")) {
                this.tableAbbr = this.tableName;
            }
            this.tableName = this.tableName.replaceAll("\\$", "\\\\\\$");
            result = result.replaceAll("\\{table\\}", this.tableName);
            result = result.replaceAll("\\{seq nr\\}", String.valueOf(counter));
            this.tableAbbr = this.tableAbbr.replaceAll("\\$", "\\\\\\$");
            result = result.replaceAll("\\{table abbr\\}", this.tableAbbr);
            this.modelName = index.getDesignPart().getName();
            this.modelName = this.modelName.replaceAll("\\$", "\\\\\\$");
            result = result.replaceAll("\\{model\\}", this.modelName);
            if (index.getElements().length > 0) {
                Column indexColumn = (Column)index.getElement(0);
                String columnName = indexColumn.getShortName();
                String columnAbbr = indexColumn.getAbbreviation();
                if (columnAbbr.equals("")) {
                    columnAbbr = columnName;
                }
                columnName = columnName.replaceAll("\\$", "\\\\\\$");
                result = result.replaceAll("\\{column\\}", columnName);
                columnAbbr = columnAbbr.replaceAll("\\$", "\\\\\\$");
                result = result.replaceAll("\\{column abbr\\}", columnAbbr);
            }
            if (index.getName().equalsIgnoreCase(result)) {
                return CheckResult.createOk(index, this, Messages.getString("DRIndexNamingStandard.IndexNameIsInValidFormat"));
            }
            return CheckResult.createWarning(index, this, this.getDescription());
        }
        return CheckResult.createOk(index, this, Messages.getString("DRIndexNamingStandard.IndexNameIsInValidFormat"));
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public String getRuleId() {
        return "C28EC3DA-186B-DA2D-2995-8EA2E1A04954";
    }
}

